<?php
	require_once '../../autoload.php';

	$result = array (
			"status"	=> 'KO',
			"results"	=> -1
	);
	
	$pdo = getPDO ();
		
	if ( $pdo )
	{
		$mod_id						= -1;
		$room_id					= -1;
		$name 						= "";
		$modalitytitle 				= "";
		$manufacturer  				= "";
		$model 						= "";
		$uid 						= "";
		$installation_date 			= "";
		$dap_calibration_date 		= "";
		$detector_type  			= "";
		$detector_number  			= -1;
		$reconstruction_software  	= "";
		$comment  					= "";
		$active  					= 0;
		$radiology_interventional  	= 0;
		$manual_encoding  			= 0;
		
		if ( isset($_POST['mod_id']) )						$mod_id 					= $_POST['mod_id'];
		if ( isset($_POST['room_id']) )						$room_id 					= $_POST['room_id'];
		if ( isset($_POST['name']) )						$name 						= $_POST['name'];
		if ( isset($_POST['modalitytitle']) )				$modalitytitle				= $_POST['modalitytitle'];
		if ( isset($_POST['manufacturer']) )				$manufacturer				= $_POST['manufacturer'];
		if ( isset($_POST['model']) )						$model						= $_POST['model'];
		if ( isset($_POST['uid']) )							$uid						= $_POST['uid'];
		if ( isset($_POST['installation_date']) )			$installation_date			= $_POST['installation_date'];
		if ( isset($_POST['dap_calibration_date']) )		$dap_calibration_date		= $_POST['dap_calibration_date'];
		if ( isset($_POST['detector_type']) )				$detector_type				= $_POST['detector_type'];
		if ( isset($_POST['detector_number']) )				$detector_number			= $_POST['detector_number'];
		if ( isset($_POST['reconstruction_software']) )		$reconstruction_software	= $_POST['reconstruction_software'];
		if ( isset($_POST['comment']) )						$comment					= $_POST['comment'];
		if ( isset($_POST['active']) )						$active						= $_POST['active'];
		if ( isset($_POST['radiology_interventional']) )	$radiology_interventional	= $_POST['radiology_interventional'];
		if ( isset($_POST['manual_encoding']) )				$manual_encoding			= $_POST['manual_encoding'];
		
		if ( $mod_id == -1 )
		{
			$sql = "insert into modality ( room_id, name ) values ( :room_id, 'New modality') returning mod_id;";

			$s0 = $pdo->prepare ( $sql );

			$s0->bindParam ( ':room_id', 	$room_id 	);
		}
		else
		{
			$sql = 'update modality';
 			$sql .= ' set name = :name,';
 			$sql .= 		'modalitytitle 			= :modalitytitle,';
 			$sql .= 		'company 				= :manufacturer,';
 			$sql .= 		'companymodel 			= :model,';
 			$sql .= 		'device_uid 			= :uid,';
 			if ( $installation_date != "" )
 				$sql .= 		'installation 			= :installation_date,';
 			if ( $dap_calibration_date != "" )
 				$sql .= 		'dap_calibration_date 	= :dap_calibration_date,';
 			$sql .= 		'detector_type 				= :detector_type,';
 			$sql .= 		'ct_number_barette			= :detector_number,';
 			$sql .= 		'reconstruction_software	= :reconstruction_software,';
 			$sql .= 		'comment					= :comment,';
 			$sql .= 		'active						= :active,';
 			$sql .= 		'manualencoding				= :manual_encoding,';
 			$sql .= 		'ri							= :radiology_interventional';
			$sql .= ' where mod_id = :mod_id';

			$s0 = $pdo->prepare ( $sql );

			$s0->bindParam ( ':mod_id', 				$mod_id 				);
			$s0->bindParam ( ':name', 					$name 					);
			$s0->bindParam ( ':modalitytitle', 			$modalitytitle 			);
			$s0->bindParam ( ':manufacturer', 			$manufacturer 			);
			$s0->bindParam ( ':model', 					$model 					);
			$s0->bindParam ( ':uid', 					$uid 					);
			if ( $installation_date != "" )
				$s0->bindParam ( ':installation_date', 		$installation_date 		);
			if ( $dap_calibration_date != "" )
				$s0->bindParam ( ':dap_calibration_date', 	$dap_calibration_date 		);
			$s0->bindParam ( ':detector_type', 				$detector_type 				);
			$s0->bindParam ( ':detector_number',			$detector_number			);
			$s0->bindParam ( ':reconstruction_software',	$reconstruction_software	);
			$s0->bindParam ( ':comment',					$comment	);
			$s0->bindParam ( ':active',						$active	);
			$s0->bindParam ( ':manual_encoding',			$manual_encoding	);
			$s0->bindParam ( ':radiology_interventional',	$radiology_interventional	);
		}	
		
		if ( $s0->execute () == true )
		{
			$result['status'] = 'OK';
			if ( $mod_id == -1 )
				$result['results'] = $s0->fetchColumn ();
			else
				$result['results'] = $mod_id;
		}
	}
	
	header('Content-type: application/json');
	
	echo json_encode ( $result );
?>