<?php
	require_once '../../../autoload.php';

	$result = array (
			"status"	=> 'KO',
			"results"	=> array ()
	);
	
	$pdo = getPDO ();
		
	if ( $pdo )
	{
		$mod_id = -1;
		
		if ( isset($_POST['mod_id']) )		$mod_id = $_POST['mod_id'];

		$sql = "select 
					mod_id,
					room_id,
					name as inp_name, 
					active::integer as check_active, 
					device_uid as inp_deviceuid,
					contact_id,
					comment as inp_comment, 
					modalitytitle,
					company as inp_company, 
					companymodel as inp_companymodel,
					installation as installation_date,
					ri::integer as check_ri,
					dap_calibration_date,
					ct_number_barette,
					detector_type,
					reconstruction_software,
					manualencoding::integer as check_me,
					store_sr::integer check_storesr 
				from 
					modality 
				where 
					mod_id=:mod_id and removed = false";

		$s0 = $pdo->prepare ( $sql );

		$s0->bindParam ( ':mod_id', $mod_id );
		
		if ( $s0->execute () )
		{
			$result['status'] ='OK';

			$d0 = $s0->fetchAll ();

			for ( $i=0; $i<count($d0); $i++ )
			{
				$res = array (	"mod_id" 					=> $d0[$i]['mod_id'],
								"room_id"					=> $d0[$i]['room_id'],
								"name"						=> $d0[$i]['inp_name'],
								"active"					=> $d0[$i]['check_active'],
								"uid"						=> $d0[$i]['inp_deviceuid'],
								"comment"					=> $d0[$i]['inp_comment'],
								"modalitytitle"				=> $d0[$i]['modalitytitle'],
								"manufacturer"				=> $d0[$i]['inp_company'],
								"model"						=> $d0[$i]['inp_companymodel'],
								"installation_date"			=> $d0[$i]['installation_date'],
								"dap_calibration_date"		=> $d0[$i]['dap_calibration_date'],
								"detector_type"				=> $d0[$i]['detector_type'],
								"detector_number"			=> $d0[$i]['ct_number_barette'],
								"reconstruction_software"	=> $d0[$i]['reconstruction_software'],
								"comment"					=> $d0[$i]['inp_comment'],
								"active"					=> $d0[$i]['check_active'],
								"radiology_interventional"	=> $d0[$i]['check_ri'],
								"manual_encoding"			=> $d0[$i]['check_me'] );

				array_push ( $result['results'], $res );
			}
		}
	}
	
	header('Content-type: application/json');
	
	echo json_encode ( $result );
?>