<?php
	require_once '../../../autoload.php';
	// require_once 'tools.php';

	error_log ( "##################################################" );
	error_log ( "### test_tree ###" );

  $result = array (
			"status"	=> 'KO',
			"results"	=> array ()
	);

  $conn = get_dbconnection();

  if ( $conn )
  {
      	$aInstitutionSetup = array();
      	$aInstitutionSetup['-1'] = array(); //undef first position;
      	$sql="select institution.inst_id,institution.name as instname,department.dep_id,department.name as depname,department.type,room.room_id,room.name as roomname, modality.mod_id, modality.name as modname, modality.active::integer as modactive
            from institution left join department on(institution.inst_id = department.inst_id and institution.removed = false and department.removed = false) left join room on(department.dep_id = room.dep_id and room.removed = false) left join modality on (room.room_id = modality.room_id and modality.removed = false)
            where coalesce(institution.removed,false)=false and coalesce(department.removed,false)=false and coalesce(room.removed,false)=false and coalesce(modality.removed,false)=false
            order by lower(institution.name),lower(department.name),lower(room.name),lower(modality.name);";

      	if($query=pg_query($conn,$sql))
      	{
      			$last_inst_id 	= -1;
						$last_dep_id	= -1;
						$last_room_id	= -1;
						$last_mod_id	= -1;

						$inst 	= -1;
						$dep 	= -1;
						$room 	= -1;

        		while ( $row = pg_fetch_row($query) )
        		{
        				$inst_id 	= $row[0];
        				$dep_id 	= $row[2];
        				$room_id 	= $row[5];
        				$mod_id 	= $row[7];

        				if ( $inst_id != -1 && $dep_id != -1 )
        				{
          					// Institution
										if ( $inst_id != $last_inst_id )
										{
												$r0 = array (	"text" 		=> $row[1],
														"expanded" 	=> true,
														"checked" 	=> true,
														"data"		=> ['id' => $inst_id],
														"icon"		=> "fa fa-w fa-hospital",
														// "iconFile"	=> "SubFW/bmp/hospital-1.png",									
														'data1'			=> "institution",
														'data2'			=> $inst_id,
														"nodes" 	=> array() );

												array_push ( $result['results'], $r0 );

												$last_inst_id = $inst_id;

												$inst++;
												$dep = -1;
										}

										// Department
										if ( $dep_id != $last_dep_id )
										{
												$r1 = array (	"text" 		=> $row[3],
														"expanded" 	=> true,
														"checked" 	=> true,
														"iconFile"	=> "SubFW/bmp/radio-dep.svg",									
														'data1'			=> "department",
														'data2'			=> $dep_id,
														"nodes" 	=> array() );

												$last_dep_id = $dep_id;

												array_push ( $result['results'][$inst]['nodes'], $r1 );

												$dep++;
												$room= -1;
										}

										// Room
										if ( $room_id != $last_room_id )
										{
												$r2 = array (	"text" 		=> $row[6],
															"expanded" 	=> true,
															"checked" 	=> true,
															"iconFile"	=> "SubFW/bmp/radio-dep.svg",
															'data1'			=> "room",
															'data2'			=> $room_id,
															"nodes" 	=> array() );

												$last_room_id = $room_id;
												
												array_push ( $result['results'][$inst]['nodes'][$dep]['nodes'], $r2 );

												$room++;
										}

										// Modality
										if ( $mod_id != $last_mod_id )
										{
												$r3 = array (	"text" 		=> $row[8],
															"expanded" 	=> true,
															"checked" 	=> true,
															"iconFile"	=> "SubFW/bmp/RXModality.svg",
															'data1'			=> "modality",
															'data2'			=> $mod_id );

												$last_mod_id = $mod_id;
												
												array_push ( $result['results'][$inst]['nodes'][$dep]['nodes'][$room]['nodes'], $r3 );

										}
								}
        		}
      	}
    }
    else
    {
      error_log ( 'db_treeinstitutionsetup.php: Could not connect to database' );
    }

    
		header('Content-type: application/json');

    echo json_encode ( $result );
?>