
<?php

include '../autoload.php';

// Récupération des paramètres
$jrxml  = $GLOBALS["JASPER_TEMPLATES_FOLDER"].'/'.$_POST['jrxml'] ?? '';
$output = $_POST['output'] ?? 'stdout';
$format = $_POST['format'] ?? 'html';

// Filtrage des autres paramètres transmis à Java
$params = [];
foreach ($_POST as $key => $value) {
    if (!in_array($key, ['jrxml', 'output', 'format'])) {
        $params[$key] = $value;
    }
}

// Construction de la chaîne de paramètres
$flatParams = [];
foreach ($params as $key => $value) {
    $flatParams[] = escapeshellarg($key . '=' . $value);
}
$paramString = implode(' ', $flatParams);

// Log en cas de debug
error_log("jrxml : $jrxml");
error_log("paramString : $paramString");

$jarFile = $GLOBALS["JASPER_APP_FOLDER"] . "/eoJasperConverter.jar";

// Construction de la commande Java
$cmd = $GLOBALS["JAVA_EXE"].' -jar "' . $jarFile . '" ' . escapeshellarg($output) . ' ' . escapeshellarg($format) . ' "' . $jrxml . '" ' . $paramString;

// Préparation des descripteurs pour proc_open
$descriptorspec = [
    0 => ['pipe', 'r'],  // stdin
    1 => ['pipe', 'w'],  // stdout (PDF ou HTML)
    2 => ['pipe', 'w']   // stderr (erreurs Java)
];

// Lancement du process
$process = proc_open($cmd, $descriptorspec, $pipes);

if (is_resource($process)) 
{
    fclose($pipes[0]); 

    $outputContent = stream_get_contents($pipes[1]);
    fclose($pipes[1]);

    $stderr = stream_get_contents($pipes[2]);
    fclose($pipes[2]);

    $returnCode = proc_close($process);

    if ($returnCode !== 0) {
        http_response_code(500);
        header('Content-Type: text/plain; charset=UTF-8');
        echo "Erreur lors de la génération du rapport :\n\n" . $stderr;
        exit;
    }

    // Détection du format de retour
    if ($format === 'pdf') {
        header('Content-Type: application/pdf');
        header('Content-Disposition: inline; filename="rapport.pdf"');
    } else {
        header('Content-Type: text/html; charset=UTF-8');
    }

    echo $outputContent;
    exit;
} 
else 
{
    http_response_code(500);
    echo "Erreur : impossible de lancer le process Java.";
    exit;
}


?>
