<?php
require_once '../autoload.php';

	$xml = "<SDR>";
	$conn = get_dbconnection();
	$dap="";
			$dlp="";
			$dgmleft="";
			$dgmright="";
			$mbq="";
			$patient_id="";
			$patient_name="";
			$patient_sex="";
			$patient_birthdate="";
			$pat_id=-1;
			$stu_id=-1;
			$idsite = 0;

		if(isset($_GET["stu_id"]))
			$stu_id = $_GET["stu_id"];

		if(isset($_GET["pat_id"]))
			$pat_id = $_GET["pat_id"];

		if($conn)
		{
			$site_study = explode("_",$stu_id,2);
			if(count($site_study) == 1) // no remote site ID
			{
				$site_study[0] = $idsite;
				$site_study[1] = $stu_id;
			}

			$stu_id = $site_study[1];
			$idsite = $site_study[0];

			$sessionGLOBALS = get_active_remote_site($conn,$GLOBALS['eoDACS_FDW']);

			if(!array_key_exists($idsite,$sessionGLOBALS['eoDACS_FDW']))
			{
				$xml.="<error>Remote site ID({$idsite}) is not accessible.</error>";
				$xml.= "</SDR>";
				$xml = str_replace('&','&amp;',$xml );
				header('Content-Type: text/xml');
				echo $xml;
				exit();
			}

			$arr_patid_by_site = get_patidlist_by_site($conn,$sessionGLOBALS,$idsite,$pat_id,$stu_id);
	
			$pat_id = $arr_patid_by_site[0][0]; // should be unique;
			$sqlpatidfromstuid = "in(".$pat_id.")";

				$sqlpatient="select replace(name,'^',' ') as name, to_char(birthdate,'DD/MM/YYYY') as birthdate,master_id,sex from patient where pat_id {$sqlpatidfromstuid} limit 1;";

				if($query=pg_query($conn,$sqlpatient))
				{
					if($row = pg_fetch_row($query))
					{
						$patient_name=$row[0];
						$patient_birthdate=$row[1];
						$patient_id=$row[2];
						$patient_sex=$row[3];
					}
				}
			$sqlarray = array();
			foreach ($sessionGLOBALS['eoDACS_FDW'] as $key => &$site ) {
				$listofpatid =  implode(",", $arr_patid_by_site[$key]);

				if($listofpatid == '')
					continue;

				if(!array_key_exists($key, $sqlarray))
				{
					$sqlarray[$key] = array();
				}
				//requestlist_globalanatsum
				$sqlarray[$key][] = "select round(sum(dap_auto)::numeric,2) as dap, round(sum (dlp_auto)::numeric,2) as dlp,
				(select round(sum(dgm_auto)::numeric,2) as dgmleft from {$site['schemaremote']}.v_serie as serie where laterality_auto ilike 'L%' and stu_id in (select stu_id from  {$site['schemaremote']}.study where pat_id in({$listofpatid}))),
				(select round(sum(dgm_auto)::numeric,2) as dgmright from {$site['schemaremote']}.v_serie as serie where laterality_auto ilike 'R%' and stu_id in (select stu_id from  {$site['schemaremote']}.study where pat_id in({$listofpatid}))) ,
				sum(dosenm_auto) as mbq from  {$site['schemaremote']}.study where pat_id in({$listofpatid})";
			}


			$sqlbysite = get_full_fdw_request($conn,$sqlarray,$sessionGLOBALS);
			$sql="with t as ({$sqlbysite})
			select sum(dap),sum(dlp),sum(dgmleft), sum(dgmright) ,sum(mbq) from t";

			if($query=pg_query($conn,$sql))
			{
				if($row= pg_fetch_row($query))
				{
					$dap=$row[0];
					$dlp=$row[1];
					$dgmleft=$row[2];
					$dgmright=$row[3];
					$mbq=$row[4];
				}
			}

		}
?>



<html>
<header><title>R&eacute;sum&eacute; radiologique patient</title>
<link rel="stylesheet" href="<?php echo $GLOBALS["approot"];?>/eoDACS/SubFW/css/paper.css">
<style>@page { size: A4;
    margin: 15mm 15mm 15mm 15mm;

 }
@media print
{
    .no-print, .no-print *
    {
        display: none !important;
    }
}
.fade{
	opacity: 0.6;
}
.fade:hover{
	opacity: 1;
}

</style>

</header>
<body class="A4">
<div class="no-print fade" style="position:fixed;right:20px;top:20px;z-index:99" onclick="window.print();"><img src="../eoDACS/SubFW/bmp/printer_1.png" style="height:32px;"></div>
<section class="sheet padding-10mm" style="height: auto !important;min-height: 297mm;">

<article>
	<div style="position:absolute;left:15mm;top;20mm;"><?php echo $GLOBALS["BRIEF_REPORT_HEADER"];?></div>

	<br><br><br><br><br><br>
		<center><b><u>Objet : R&eacute;sum&eacute; dosim&eacute;trique de <?php echo $patient_name; ?> n&eacute;(e) le <?php echo $patient_birthdate; ?></u></b></center>
<br><br><br>
<center>
<table>
<tr>
<td><b>DLP</b> total :&nbsp;&nbsp;</td>
<td> <b><?php echo 0+$dlp;?> mGy.cm</b></td>
</tr>
<tr>
<td><b>DAP</b> total :&nbsp;&nbsp;</td>
<td> <b><?php echo 0+$dap;?> mGy.cm<sup>2</b></sup></td>
</tr>
<tr>
<td><b>MGD</b> total :&nbsp;&nbsp;</td>
<td><b><?php echo (0+$dgmleft+$dgmright);?> mGy </b>	(Gauche: <b><?php echo 0+$dgmleft;?> mGy</b> / Droite: <b><?php echo 0+$dgmright; ?> mGy</b>)</td>
</tr>
<td><b>MBq</b> total :&nbsp;&nbsp;</td>
<td> <b><?php echo 0+$mbq;?> MBq</b></td>
</tr>
</table>

<br>
<hr>
<br>
<u>D&eacute;tail par examen :</u>
<br>
<br>
<table style="width:90%;margin-left:5%;border-collapse:collapse;">
<tr><td style="width:15%;font-weight:bold;padding-bottom:10px;">Date</td><td style="width:20%;font-weight:bold;padding-bottom:10px;">Site</td><td style="width:50%;font-weight:bold;padding-bottom:10px;">Examen</td><td style="width:35%;font-weight:bold;padding-bottom:10px;">Dose</td>
</tr>
<?php

	$sqlarray = array();
	foreach ($sessionGLOBALS['eoDACS_FDW'] as $key => &$site ) {
		$listofpatid =  implode(",", $arr_patid_by_site[$key]);

		if($listofpatid == '')
			continue;

		if(!array_key_exists($key, $sqlarray))
		{
			$sqlarray[$key] = array();
		}
		//requestlist_globalanatsum
		$sqlarray[$key][] = "select '{$site['name']}', to_char(study.date,'DD/MM/YYYY'),'<b>'||modality.modalitytitle||'</b>,&nbsp;&nbsp;'||study.description_auto, coalesce(round(greatest(dap_total::numeric,dap_auto::numeric),2)||' mGy.cm<sup>2</sup>',round(dlp_auto::numeric,2)||' mGy.cm',round(dgm_auto::numeric,2)||' mGy',round(dosenm_auto::numeric,2)||' MBq'),study.date
		from {$site['schemaremote']}.study,{$site['schemaremote']}.modality_profile,{$site['schemaremote']}.modality_identity,{$site['schemaremote']}.modality
		where pat_id in({$listofpatid}) and modality_profile.pro_id=study.pro_id
		and modality_profile.modident_id=modality_identity.modident_id and modality.mod_id=modality_identity.mod_id";
	}

	$sqlbysite = get_full_fdw_request($conn,$sqlarray,$sessionGLOBALS);
	$sql="with t as ({$sqlbysite})
	select * from t  order by date desc;";

	$query=pg_query($conn,$sql);
	while($row=pg_fetch_row($query))
	{

?>
				<tr style="border-top: 1px solid black;">
				<td><?php echo $row[1]; ?></td><td><?php echo $row[0]; ?></td><td><?php echo $row[2]; ?></td><td><?php echo $row[3]; ?></td>
				</tr>

<?php
	}
?>
</table>

 </center>
	</article>

  </section>


</body>
</html>
