
 <?php
   include '../../autoload.php';

   function read_ctrxml($path)
   {
     // Create a DOMDocument instance
      $xml = new DOMDocument;

      // Load the XML data source
      $xml->Load($path);

      $config = [];
      $config['scp'] = [];

      foreach ($xml->getElementsByTagName('Controller') as $conf) {
        foreach ($conf->childNodes as $attr)
        {
          if(strtolower($attr->nodeName) == 'ip')
          {
            $config['ip'] = $attr->nodeValue;
          }
        }
      }

      foreach ($xml->getElementsByTagName('SCPWorker') as $scp) {

        $currentscp = [];
        foreach ($scp->childNodes as $attr)
        {
          if(strtolower($attr->nodeName) == 'aet')
          {
            $currentscp['aet'] = $attr->nodeValue;
          }

          if(strtolower($attr->nodeName) == 'port')
          {
            $currentscp['port'] = $attr->nodeValue;
          }
        }
        $config['scp'][] = $currentscp;
       }

       return $config;
   }

?>
 <!DOCTYPE html>
 <html lang="en">
 <head>

   <meta charset="utf-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
   <meta name="description" content="">
   <meta name="author" content="">
   <link rel="stylesheet" type="text/css" href="<?php echo $DHTMLX_URL;?>/codebase/fonts/font_roboto/roboto.css"/>
   <link rel="stylesheet" type="text/css" href="<?php echo $DHTMLX_URL;?>/codebase/dhtmlx.css"/>
   <link rel="stylesheet" type="text/css" href="<?php echo $DHTMLX_URL;?>/skins/web/dhtmlx.css"/>
   <link rel="stylesheet" type="text/css" href="<?php echo $EXTERN_CSS;?>/bootstrap-4.3.1/css/bootstrap.min.css"/>
   <link rel="shortcut icon" type="image/x-icon" href="<?php echo $EODACS_ROOT;?>/../eoDACSCommon/pics/eodacs.png" />
   <script type='text/javascript' src="<?php echo $DHTMLX_URL;?>/codebase/dhtmlx.js"></script>
   <script type='text/javascript' src="<?php echo $DHTMLX_EOADDON;?>/dhtmlxgrid_searchcbfilter.js"></script>
   <script type='text/javascript' src="<?php echo $DHTMLX_EOADDON;?>/dhtmlxgrid_doublecalendarinput.js"></script>


   <title>eoDACS DICOM Config</title>

   <!-- Custom fonts for this template-->
   <link href="<?php echo $EXTERN_CSS;?>/font-awesome-current/css/all.min.css" rel="stylesheet" type="text/css">

   <script src="<?php echo $EODACS_ROOT;?>/js/jquery/jquery.min.js"></script>

   <!-- Core plugin JavaScript-->
   <script src="<?php echo $EODACS_ROOT;?>/js/jquery-easing/jquery.easing.min.js"></script>
   <!-- Custom styles for this template-->
   <link href="css/sb-admin.css" rel="stylesheet">


   <link rel="stylesheet" href="<?php echo $EXTERN_CSS;?>/checkbox/searchableOptionList.css">
   <script type="text/javascript" src="js/jquery/jquery.js"></script>
   <script type="text/javascript" src="<?php echo $EXTERN_CSS;?>/checkbox/sol.js"></script>

   <style>


 </style>

 <script>

 <?php create_translate_xml_js_function(); ?>


 </script>
    </head>

    <body>
        <?php
        $config = read_ctrxml($GLOBALS['CTRXML']);
     ?>
        <div class="container-fluid">
            <div class="row m-0 p-0 pt-3">
                <div class="col col-auto m-0 p-0 w-50">
                    <div class="row m-0 p-0 ps-3 pe-3 fw-bold rounded-top ximeo_app-color" data-langkey="Server">
                        Server
                    </div>
                    <div class="d-flex m-0 p-0 ps-2 pe-2 pt-1 pb-1 border-start border-bottom border-end">
                        <div class="m-0 p-0 pe-2">IP address :</div>
                        <div class="m-0 p-0"><?= $config['ip'] ?></div>
                    </div>
                </div>
            </div>
            
            <div class="row m-0 p-0 pt-3 w-50">
                <div class="col m-0 p-0 border-bottom">
                    <div class="row m-0 p-0 ps-3 pe-3 fw-bold rounded-top ximeo_app-color" data-langkey="DICOM SCP :">
                    </div>
                    <div class="row m-0 p-0 border-start border-bottom border-end">
                        <div class="col-sm-4 m-0 p-0 ps-2">
                            <b>AET</b>
                        </div>
                        <div class="col-sm-6 m-0 p-0 ps-2 border-start">
                            <b>PORT</b>
                        </div>
                    </div>
                    <?php
                        foreach($config['scp'] as $scp)
                        {
                            if($scp['aet'] == 'EODACSQR')
                                continue;
                        ?>
                        <div class="row m-0 p-0 border-start border-end">
                            <div class="col-sm-4 m-0 p-0 ps-2 pe-2">
                                <?= $scp['aet'] ?>
                            </div>
                            <div class="col-sm-6 m-0 p-0 ps-2 border-start">
                                <?= $scp['port'] ?>
                            </div>
                        </div>
                        <?php
                        }
                    ?>
                </div>
            </div>



            <div class="row m-0 p-0 pt-3 w-50">
                <div class="col m-0 p-0 border-bottom">
                    <div class="row m-0 p-0 ps-3 pe-3 fw-bold rounded-top ximeo_app-color" data-langkey="MPPS SCP :">
                    </div>
                    <div class="row m-0 p-0 border-start border-bottom border-end">
                        <div class="col-sm-4 m-0 p-0 ps-2">
                            <b>AET</b>
                        </div>
                        <div class="col-sm-6 m-0 p-0 ps-2 border-start">
                            <b>PORT</b>
                        </div>
                    </div>
                    <?php

                    foreach($GLOBALS['DAPCAREMPPSCONFIG_ARRAY'] as $inifile)
                    {
                        // Parse without sections
                        $ini_array = parse_ini_file($inifile);
                    ?>
                        <div class="row m-0 p-0 border-start border-end">
                            <div class="col-sm-4 m-0 p-0 ps-2 pe-2">
                                <?= $ini_array['AET'] ?>
                            </div>
                            <div class="col-sm-6 m-0 p-0 ps-2 border-start">
                                <?= $ini_array['PORT'] ?>
                            </div>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
        </div>

        <script>
            switchLanguage ( eoDACS.CurrentLanguage );
        </script>

    </body>
 </html>
