

	let XIM_CheckboxMenu = {
		NbCheckboxMenu : 0,
	
		CBMList : Array (),
		
		GetNbItems : function ()
		{
			return XIM_CheckboxMenu.CBMList.length;
		},
		
		IDValid : function ( cbm_id )
		{
			if ( cbm_id >= 0 && cbm_id < XIM_CheckboxMenu.CBMList.length )
				return true;
			else
				return false;
		},
		
		AddItem : function ( item )
		{
			XIM_CheckboxMenu.CBMList.push ( item );
		},
		
		OnClick : function ( cal_id, item )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnClick ( item );
		},
		
		UnselectItem : function ( cbm_id, index )
		{
			if ( XIM_CheckboxMenu.IDValid( cbm_id ) )
				XIM_CheckboxMenu.CBMList [cbm_id].UnselectItem ( index );
		},
		
		OnSelectButtonClicked : function ( cal_id )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnSelectButtonClicked ();
		}
		,

		OnExpandButtonClicked : function ( cal_id )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnExpandButtonClicked ();
		}
		,

		OnUnselectButtonClicked : function ( cal_id )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnUnselectButtonClicked ();
		}
	}
		

function CBMenuSize ( el )
{
	let idcDiv = el.id + "_div";

	let offset = $('#'+el.id).offset();
	let h = $('#'+el.id).height();
	offset.top += h;

	$('#'+idcDiv).css ( offset );
}

class C_CheckboxMenu
{
	constructor ( container, ident, title )
	{
		this.Container 		= container;
		this.Ident			= ident;
		this.NbItems		= 0;
		this.ID				= XIM_CheckboxMenu.GetNbItems ();
		this.CallbackFct	= "";

		let idc = document.getElementById ( this.Container );
		
		let idcButtonsContainer = this.Ident + "_buttons_container";
		
		let tmp = "";
		
		tmp += '<div id="'+this.Ident+'" class="dropdown w-100">';
		tmp += 		"<div id=\""+idcButtonsContainer+"\" class=\"m-0 p-0 mb-1\" style=\"max-height: 100px !important; overflow-y: auto !important;\">";
		tmp += 		"</div>";
																				
		tmp += 		'<a class="btn border dropdown-toggle w-100" href="#" role="button" id="dropdownMenuLink" aria-expanded="false" style="overflow: hidden;" onclick="XIM_CheckboxMenu.OnExpandButtonClicked('+this.ID+')">';
		tmp +=			title;
		tmp += 		"</a>";

		tmp +=	"</div>";
		
		idc.innerHTML = tmp;

		let idcDiv 		= this.Ident + "_div";
		let idcDivBack 	= this.Ident + "_div_back";
		let idcList 		= this.Ident + "_ul";

		tmp = '<div id="'+idcDivBack+'" class="m-0 p-0 bg-warning" style="z-index: 1999; position: absolute !important; left: 0px; top: 0px; width: 100%; height: 100%; opacity: 0; display: none;" onclick="XIM_CheckboxMenu.OnExpandButtonClicked('+this.ID+')"></div>';
		tmp +=  '<div id="'+idcDiv+'" class="m-0 p-0 ps-1 pe-1 pb-1 bg-white w-auto h-auto border rounded" style="opacity: 1.0;  z-index: 2000; display: none; position: absolute;">';
		tmp +=		'<ul id="'+idcList+'" class="m-0 p-0" style="list-style-type: none; max-height: 300px !important; overflow-y: auto !important;">';
		tmp +=			"<div id=\"IdcCBMSelectButton\" class=\"w-100 d-flex flex-row-reverse\"><button type=\"button\" class=\"btn btn-link\" data-langkey=\"Select all\" onclick=\"XIM_CheckboxMenu.OnSelectButtonClicked("+this.ID+")\">Select all</button><button type=\"button\" class=\"btn btn-link\" data-langkey=\"Unselect all\" onclick=\"XIM_CheckboxMenu.OnUnselectButtonClicked("+this.ID+")\">Unselect all</button></div>";
		tmp +=		"</ul>";
		tmp += '</div>';


		$('body').append ( tmp );
			
		XIM_CheckboxMenu.AddItem ( this );

		let el = document.getElementById (this.Ident);
		new ResizeObserver ( () => {CBMenuSize (el);} ).observe ( el );
	}

	AddTextSeparator ( label )
	{
		let idcList = document.getElementById ( this.Ident + "_ul" );
		
		let idcItem = this.Ident + "_cb_" + this.NbItems;
		
		let li = document.createElement('li');
		let tmp = "";
		tmp +=				"<div class=\"w-100 m-0 p-0 ps-3 pe-3 bg-light text-muted fs-5 border-bottom border-top\">"+label+"</div>";
		
		li.innerHTML = tmp;
		
		idcList.appendChild ( li );
	}
	
	AddItem ( ident1, ident2, label, subLabel )
	{
		let idcList = document.getElementById ( this.Ident + "_ul" );
		
		let idcItem = this.Ident + "_cb_" + this.NbItems;
		
		let li = document.createElement('li');
		let tmp = "";
		tmp +=				"<a class=\"dropdown-item\">";
		tmp +=				"<div class=\"form-check w-100\">";
		tmp +=					"<input id=\""+idcItem+"\" class=\"form-check-input\" type=\"checkbox\" data-ident1="+ident1+" data-ident2="+ident2+" data-index=\""+this.NbItems+"\" data-item=\""+label+"\" data-sublabel=\""+subLabel+"\" onclick=\"XIM_CheckboxMenu.OnClick("+this.ID+", '"+idcItem+"')\" >";
		tmp +=					"</input>";
		tmp +=					"<label class=\"form-check-label\" for=\""+idcItem+"\">"+label+"</label>";
		tmp +=				"</div>";
		tmp +=				"</a>";
		
		li.innerHTML = tmp;
		
		idcList.appendChild ( li );
		
		this.NbItems++;
	}
	
	OnClick ( item )
	{
		let idcCB = document.getElementById ( item );

		console.log ( " item : " + item );
		
		let label 		= idcCB.dataset.item;
		let subLabel 	= idcCB.dataset.sublabel;
		let index 		= idcCB.dataset.index;
		let ident1		= idcCB.dataset.ident1;
		let ident2		= idcCB.dataset.ident2;
		
		if ( idcCB.checked )
		{
			this.SelectItem ( label, subLabel, index, ident1, ident2 );
		}
		else
			this.UnselectItem ( index );
	}
	
	OnSelectButtonClicked ()
	{
		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcCBItem = this.Ident + "_cb_" + i;
		
			// document.getElementById ( idcCBItem ).checked = true;
			let idcCB = document.getElementById ( idcCBItem );
			idcCB.checked = true;
			let label 		= idcCB.dataset.item;
			let subLabel 	= idcCB.dataset.sublabel;
			let index 		= idcCB.dataset.index;
			
			this.SelectItem ( label, subLabel, index );
		}
	}
	
	OnUnselectButtonClicked ()
	{
		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcCBItem = this.Ident + "_cb_" + i;
		
			let idcCB = document.getElementById ( idcCBItem );
			idcCB.checked = false;
			let index = idcCB.dataset.index;
			
			this.UnselectItem ( index );
		}
	}

	OnExpandButtonClicked ()
	{
		console.log ( "OnExpandButtonClicked..." );

		let pos = $('#'+this.Ident).position();
		let offset = $('#'+this.Ident).offset();
		let h = $('#'+this.Ident).height();

		offset.top += h;

		console.log ( " pos : " + pos.left + " / " + pos.top );
		console.log ( " offset : " + offset.left + " / " + offset.top );

		let idcDiv 		= this.Ident + "_div";
		let idcDivBack 	= this.Ident + "_div_back";
		$('#'+idcDiv).css ( offset );

		if ( $('#'+idcDiv).is (":visible") == false )
		{
			$('#'+idcDivBack).show ();
			$('#'+idcDiv).show ();
		}
		else
		{
			$('#'+idcDivBack).hide ();
			$('#'+idcDiv).hide ();
		}
	}

			
	SelectItem ( itemLabel, subLabel, index, ident1, ident2 )
	{
		let cbmIdent = this.Ident;
		
		let idcButtonsContainer = this.Ident + "_buttons_container";
		
		let idc = document.getElementById ( idcButtonsContainer );
		
		let div = document.createElement('div');
		div.setAttribute ( 'id', this.Ident + '_button_' + index );
		div.classList.add( "ximeo_sol-selected-display-item" );
		div.dataset.index = index;
		div.dataset.ident1 = ident1;
		div.dataset.ident2 = ident2;
		div.dataset.name = cbmIdent;

		/*
		let tmp = "";
		tmp +=				"<span class=\"ximeo_sol-quick-delete\" onclick=\"XIM_CheckboxMenu.UnselectItem("+this.ID+", '"+index+"')\">x</span>";
		tmp +=				"<span class=\"ximeo_sol-selected-display-item-text\">"+itemLabel+"</span>";
		*/

		let tmp = "";
		tmp += '<div class="row m-0 p-0 ps-1 pe-1">';

		tmp += 		'<div class="col-auto m-0 p-0 ps-1 pe-2">';
		if ( subLabel != 'undefined' )
		{
			tmp += 			'<div class="row m-0 p-0">';
			// tmp +=				"<span class=\"ximeo_sol-selected-display-item-text\">"+subLabel+"</span>";
			tmp +=				'<span class="m-0 p-0 fst-italic">'+subLabel+'</span>';
			tmp += 			'</div>';
		}
		tmp += 			'<div class="row m-0 p-0">';
		// tmp +=				"<span class=\"ximeo_sol-selected-display-item-text\">"+itemLabel+"</span>";
		tmp +=				'<span class="m-0 p-0 fw-bold">'+itemLabel+'</span>';
		tmp += 			'</div>';
		tmp += 		'</div>';

		tmp += 		'<div class="col m-0 p-0 ps-1">';
		// tmp +=			"<span class=\"ximeo_sol-quick-delete\" onclick=\"XIM_CheckboxMenu.UnselectItem("+this.ID+", '"+index+"')\">x</span>";
		tmp +=			'<span class="ximeo_sol-quick-delete" onclick="XIM_CheckboxMenu.UnselectItem('+this.ID+', '+index+')">x</span>';

		tmp += 		'</div>';

		tmp += '</div>';
		
		div.innerHTML = tmp;
		
		idc.appendChild ( div );

		this.SelectionChanged ();
	}
	
	UnselectItem ( index )
	{	
		let idcContainerDiv = this.Ident + "_buttons_container";
		let idcButtonDiv 	= this.Ident + '_button_' + index;

		let buttonToRemove = document.getElementById ( idcButtonDiv );

		if ( buttonToRemove != null )
			document.getElementById ( idcContainerDiv ).removeChild ( buttonToRemove );
		
		let idcCheckbox = this.Ident + "_cb_" + index;
		$('#'+idcCheckbox).prop("checked", false );

		this.SelectionChanged ();
	}

	SelectionChanged ()
	{
		if ( this.CallbackFct != "" )
		{
			this.CallbackFct ();
		}
	}

	GetElementsList ()
	{
		let elements = [];

		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcItem = this.Ident + "_cb_" + i;
			// if ( document.getElementById ( idcItem ).checked == true )
			{
				let ident1 = document.getElementById ( idcItem ).dataset.ident1;
				let ident2 = document.getElementById ( idcItem ).dataset.ident2;

				let elem = [];

				elem.push ( ident1 );
				elem.push ( ident2 );

				elements.push ( elem );
			}
		}

		return elements;
	}

	GetSelection ()
	{
		let selectedElements = [];

		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcItem = this.Ident + "_cb_" + i;
			if ( document.getElementById ( idcItem ).checked == true )
			{
				let ident1 = document.getElementById ( idcItem ).dataset.ident1;
				let ident2 = document.getElementById ( idcItem ).dataset.ident2;

				let elem = [];

				elem.push ( ident1 );
				elem.push ( ident2 );

				selectedElements.push ( elem );
			}
		}

		return selectedElements;
	}

	
	GetSelection2 ()
	{
		let selectedElements = [];

		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcItem = this.Ident + "_cb_" + i;

			if ( document.getElementById ( idcItem ).checked == true )
			{
				let ident2 = document.getElementById ( idcItem ).dataset.ident2;

				let elem = [];

				elem.push ( ident2 );

				selectedElements.push ( elem );
			}
		}

		return selectedElements;
	}

	GetSelection2String ()
	{
		let idlist1 = '';

		let valueList = this.GetSelection2();

		if(valueList.length)
        	idlist1 = valueList[0];

      	for ( let j = 1; j < valueList.length; j++ )
      	{
       	 	idlist1 += ','+valueList[j];
      	}

      	return idlist1;
     }

	UnselectAll ()
	{	
		for ( let i=0; i<this.NbItems; i++ )
		{
			this.UnselectItem ( i );
		}
	}

	SelectElement ( elements )
	{
		for ( let i=0; i<elements.length; i++)
		{
			for ( let j=0; j<this.NbItems; j++ )
			{
				let idcCBItem = this.Ident + "_cb_" + j;
		
				let idcCB = document.getElementById ( idcCBItem );
				
				let index = idcCB.dataset.index;
			
				if ( index == elements [i] )
				{
					idcCB.checked = true;

					let label = idcCB.dataset.item;

					this.SelectItem ( label, index );
				}
			}
		}


	}

	SelectElementIdent2 ( elements )
	{
		for ( let i=0; i<elements.length; i++)
		{
			for ( let j=0; j<this.NbItems; j++ )
			{
				let idcCBItem = this.Ident + "_cb_" + j;
		
				let idcCB = document.getElementById ( idcCBItem );
				
				let ident2 = idcCB.dataset.ident2;
			
				if ( ident2 == elements [i] )
				{
					idcCB.checked = true;

					let label = idcCB.dataset.item;
					let index = idcCB.dataset.index;

					this.SelectItem ( label, index );
				}
			}
		}


	}

	ClearAll ()
	{
		this.UnselectAll ();

		let idcList = document.getElementById ( this.Ident + "_ul" );

		while ( idcList.hasChildNodes() )
		{
			idcList.removeChild ( idcList.firstChild );
		}

		this.NbItems = 0;
	}
}