	var DT_FileDlg = null;

	//############################################################################################
	// ### Class C_File

	class C_File
	{
		constructor ()
		{
			this.Mode  				= -1;
			this.Initialized 		= false;
			this.Type				= "";
			this.Folder				= "";
			this.Filename			= "";
			this.CallbackFct 		= "";
			this.OKCallbackFct 		= "";
			this.ErrorCallbackFct 	= "";


			let nbItems = $('.c_file').length;

			this.Ident 	= "Idc_C_FileDlg_" + nbItems;

			let tmp = '';
					
			tmp += '<div id="'+this.Ident+'"  class="c_file modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" style="z-index: 10000 !important;">';
			tmp += 		'<div class="modal-dialog modal-dialog-centered" role="document" style="resize: true;">';
			tmp += 			'<div class="modal-content">';
							
			tmp += 				'<div class="modal-header p-3 pb-3 pt-3 border-bottom bg-light">';
			tmp += 					'<h5 id="'+this.Ident+'_DlgCaption" class="fw-bold mb-0"></h5>';
			tmp += 					'<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="$(\'#'+this.Ident+'\').modal(\'hide\')"></button>';
			tmp += 				'</div>';
										
			tmp += 				'<div class="modal-body w-100 pb-0">';
			tmp += 					'<div class="container p-0 m-0">';
					
			tmp += 						'<div class="row m-0 p-0 w-100">';
			tmp += 							'<div class="col p-0 col-md-auto">';
			tmp += 								'<div id="'+this.Ident+'_NameRowLabel" class="collapse m-0 p-0 pt-3 pb-2 w-100">';
			tmp += 									'<div class="m-0 p-0 pt-1 ps-0 pe-1 mb-2" data-langkey="Name :"></div>';
			tmp +=								'</div>';
			tmp += 								'<div class="m-0 p-0 pt-1 ps-0 pe-1 mb-2" data-langkey="Label :"></div>';
			tmp += 							'</div>';
			tmp += 							'<div class="col m-0 p-0">';
			tmp += 								'<div id="'+this.Ident+'_NameRowInput" class="collapse m-0 p-0 pt-3 pb-2 w-100">';
			tmp += 									'<input type="text" id="'+this.Ident+'_Name" class="form-control form-control-sm m-0 p-0 ps-2 mb-1" />';
			tmp +=								'</div>';
			tmp += 								'<input type="text" id="'+this.Ident+'_Label" class="form-control form-control-sm m-0 p-0 ps-2 mb-1" />';
			tmp += 							'</div>';
			tmp += 						'</div>';
						
			tmp += 						'<div class="row m-0 p-0 w-100">';
			tmp += 							'<div class="col m-0 p-0">';
			tmp += 								'<label for="IdcNewRealDocumentComment" class="form-label m-0 p-0" data-langkey="Comment :"></label>';
			tmp += 								'<textarea class="form-control m-0 p-0 ps-2 mb-1" id="'+this.Ident+'_Comment" rows="3"></textarea>';
			tmp += 							'</div>';
			tmp += 						'</div>';
						
			tmp +=						'<fieldset id="'+this.Ident+'_FileRow" class="ximeo_fieldset collapse mb-1 mt-2 m-0">';
			tmp +=							'<legend class="ximeo_fieldset" data-langkey="File :"></legend>';
			tmp += 							'<div class="m-0 p-0 pt-1 pb-2 w-100">';
			tmp += 								'<div class="row m-0 p-0 pt-3 w-100">';
			tmp += 									'<div class="m-0 p-0">';
			tmp += 										'<input class="form-control m-0" type="file" id="'+this.Ident+'_File" readonly />';
			tmp += 									'</div>';
			tmp += 								'</div>';
			tmp += 							'</div>';

			tmp += 							'<div id="'+this.Ident+'_ProgressRow" class="collapse m-0 p-0 pt-3 pb-2 w-100">';
			tmp += 								'<div class="row m-0 p-0 pt-1 pb-2 w-100">';
			tmp +=									'<div class="col">';
			tmp +=										'<button id="'+this.Ident+'_Abort" class="btn btn-primary text-center pt-0 pb-0 ps-2 pe-2" style="background-color: #2F83B0" >';
			tmp +=	 										'<img src="./SubFW/bmp/validate_white.png" class="imgclickable float-start me-2" style="width: 18px; vertical-align: middle;">';
			tmp += 											'<span data-langkey="Abort">Abort</span>';
			tmp += 										'</button>';
			tmp +=									'</div>';
			tmp +=									'<div class="col">';
			tmp +=										'<progress id="'+this.Ident+'_Progress">';
			tmp += 										'</progress>';
			tmp +=									'</div>';
			tmp +=									'<div class="col">';
			tmp +=										'<output id="'+this.Ident+'_Output">';
			tmp += 										'</output>';
			tmp +=									'</div>';
			tmp +=								'</div>';
			tmp +=							'</div>';
			tmp +=						'</fieldset>';
			tmp += 					'</div>';
					
			tmp += 				'</div>';
			tmp += 				'<div class="modal-footer mt-3">';
			tmp += 					'<button class="btn btn-primary text-center pt-0 pb-0 ps-2 pe-2" style="background-color: #2F83B0" onclick="C_FileValidate(\''+this.Ident+'\')">';
			tmp += 						'<img src="./SubFW/bmp/validate_white.png" class="imgclickable float-start me-2" style="width: 18px; vertical-align: middle;">';
			tmp += 						'<span data-langkey="Validate">Validate</span>';
			tmp += 					'</button>';
			tmp += 					'<button class="btn btn-secondary text-center ms-4 pt-0 pb-0 ps-2 pe-2" style="background-color: #2F83B0" onclick="$(\'#'+this.Ident+'\').modal(\'hide\')">';
			tmp += 						'<img src="./SubFW/Bmp/close_white.png" class="imgclickable float-start me-2" style="width: 18px; vertical-align: middle;">';
			tmp += 						'<span data-langkey="Cancel">Cancel</span>';
			tmp += 					'</button>';
			tmp += 				'</div>';
			tmp += 			'</div>';
			tmp += 		'</div>';
			tmp += 	'</div>';

					
			$('body').append (tmp);


			$( '#'+this.Ident ).data ( 'CFObj', this );
		}

		Show ( mode, data )		// mode 0 : Add, mode 1 : Edit
		{
			if ( this.Initialized == false )
			{
				this.Initialized = true;
			}

			let loadData = this.LoadData.bind ( this );

			switch ( mode )
			{
				case 0: 	// Add
					this.Mode = 0;
					$( '#' + this.Ident ).data ('ext_id', data.ExtID );
					$( '#' + this.Ident + '_NameRowLabel' ).addClass ( 'show' );
					$( '#' + this.Ident + '_NameRowInput' ).addClass ( 'show' );
					$( '#' + this.Ident + '_FileRow' ).addClass ( 'show' );
					$( '#' + this.Ident + '_Name' ).val ( '' );
					$( '#' + this.Ident + '_Label' ).val ( '' );
					$( '#' + this.Ident + '_Comment' ).val ( '' );
					$( '#' + this.Ident + '_Date' ).val ( GetCurrentDate (eoDACS.CurrentLanguage) );
					break;

				case 1: 	// Edit
					this.Mode = 1;
					$( '#' + this.Ident + '_NameRowLabel' ).addClass ( 'show' );
					$( '#' + this.Ident + '_NameRowInput' ).addClass ( 'show' );
					$( '#' + this.Ident + '_FileRow' ).removeClass ( 'show' );
					$( '#' + this.Ident ).data ( 'id', data.ID );
					loadData ( data.Type, data.ID );
					break;
			}
			
			$( '#' + this.Ident+'_DlgCaption' ).text ( data.Caption );
			this.Type  				= data.Type;
			this.Folder				= data.Folder;
			this.CallbackFct 		= (data.CallbackFct != undefined)? 		data.CallbackFct 		: "";
			this.OKCallbackFct 		= (data.OKCallbackFct != undefined)? 	data.OKCallbackFct 		: "";
			this.ErrorCallbackFct 	= (data.ErrorCallbackFct != undefined)? data.ErrorCallbackFct 	: "";

				

			$('#'+this.Ident+'').modal('show');
		}

		Add ( data )
		{
			this.Show ( 0, data );
		}

		Edit ( data )
		{
			this.Show ( 1, data );
		}

		OnLoadDataOK ( data )
		{
			$( '#' + this.Ident + '_Name' ).val ( data.name );
			$( '#' + this.Ident + '_Label' ).val ( data.label );
			$( '#' + this.Ident + '_Comment' ).val ( data.comment );
			$( '#' + this.Ident + '_Date' ).val ( data.create_date );
		}

		LoadData ( type, id )
		{
			let onLoadDataOK = this.OnLoadDataOK.bind(this);
			var request = $.ajax ({
        		url: 		"SubFW/database/common/db_form_document_load.php",
        		type: 		"post",
        		dataType: 	"json",
        		data: 		{id: id}
    			}
    		)
			.done ( onLoadDataOK )
    		.fail ();
		}


		Close ()
		{
			$('#'+this.Ident+'').modal('hide');
		}

		Validate ()
		{
			let file 		= $('#'+this.Ident +'_File').get(0).files[0];

			let uploadFile  = this.UploadFile.bind(this);
			let saveForm	= this.SaveForm.bind(this);

			switch ( this.Mode )
			{
				case 0:  	// Add
					uploadFile ( this.Folder, file );
					break;

				case 1:  	// Edit
					saveForm ();
					break;

				case 2:  	// New version
					uploadFile ( this.Folder, file );
					break;
			}
			
		}

		SaveForm ( uploaded_filename )
		{
			let saveFail 	= this.SaveFail.bind(this);
			let saveOK 		= this.SaveOK.bind(this);

			let type  		= this.Type;
			let date 		= $( '#' + this.Ident + '_Date' ).val ();
			let name		= $( '#' + this.Ident + '_Name' ).val ();
			let label		= $( '#' + this.Ident + '_Label' ).val ();
			let comment		= $( '#' + this.Ident + '_Comment' ).val ();
			let filename  	= this.Filename;

			if ( this.CallbackFct != "" )
			{
				let values = { 	'Date': 				date,
								'Name': 				name,
								'Label': 				label,
								'Comment': 				comment,
								'Filename':	 			filename,
								'UploadedFilename':	 	uploaded_filename };

				this.CallbackFct ( values );
			}
			else
			{
				let data 		= {};
				let toProcess 	= false;

				switch ( this.Mode )
				{
					case 0:  	// Add
						{
							let id = $('#' + this.Ident ).data ('ext_id');

							let row_id = id;

    						data [id+'_!nativeeditor_status'] 		= 'inserted';
    						data [id+'_documentmode']				= 'newdocument';
    						data [id+'_ext_id']						= id;
    						data [id+'_document_type']				= type;
    						data [id+'_name']						= name;
    						data [id+'_create_date']				= date;
    						data [id+'_label']						= label;
    						data [id+'_comment']					= comment;
    						data [id+'_uploaded_by']				= G_USE_ID;
    						data [id+'_revision']					= 1;
    						data [id+'_devicedocumentfile_r_0']		= filename;
    						data [id+'_devicedocumentfile_s_0'] 	= uploaded_filename;
    						data [id+'_devicedocumentfile_count']	= 1;
    						data ['ids']							= row_id;

    						toProcess = true;
    					}
    					break;

    				case 1: 	// Edit
    					{
							let id = $('#' + this.Ident ).data ('id');

    						data [id+'_!nativeeditor_status'] 	= 'updated';
    						data [id+'_create_date']			= date;
    						data [id+'_name']					= name;
    						data [id+'_label']					= label;
    						data [id+'_comment']				= comment;

    						data ['ids']						= id;

    						toProcess = true;
    					}
    					break;
    			}

    			if ( toProcess == true )
    			{
					var request = $.ajax ({
        				url: "SubFW/database/common/file.php",
        				type: "post",
        				dataType: "json",
        				data: data
    					}
    				)
    				.done ( saveOK )
    				.fail ( saveFail );
    			}
			}
			
			// $('#'+this.Ident+'').modal('hide');
		}

		SaveOK ( data )
		{
			this.Close ();
			
			if ( this.OKCallbackFct != "" )
				this.OKCallbackFct ( data );
		}

		SaveFail ()
		{
			if ( this.ErrorCallbackFct != "" )
				this.ErrorCallbackFct ();
		}

		UploadEnded ( uploaded_filename )
		{
			$( '#' + this.Ident + '_ProgressRow' ).removeClass ( 'show' );

			this.SaveForm ( uploaded_filename );
		}


		UploadError ()
		{
		}

		UploadFile ( folder, fileToUpload )
		{
			$( '#' + this.Ident + '_ProgressRow' ).addClass ( 'show' );
			
			this.Filename = fileToUpload.name;

			let uploadError = this.UploadError.bind(this);
			let uploadEnded = this.UploadEnded.bind(this);

  			const progressBar 	= document.getElementById ( this.Ident+"_Progress" );
  			const log 			= document.getElementById ( this.Ident+"_Output" );
  			const abortButton 	= document.getElementById ( this.Ident+"_Abort" );

   			const xhr = new XMLHttpRequest();
   			xhr.timeout 		= 20000; // 20 seconds
   			xhr.responseType	= "text";
   			
   			xhr.onreadystatechange = function() 
   			{
   				if ( xhr.readyState==4 )
    			{
    				if ( xhr.status == 200 )
    				{
    					let res = JSON.parse ( xhr.responseText ).result;

        				if ( res == 'OK' )
        				{
        					log.textContent = "Upload finished.";
        					uploadEnded ( JSON.parse ( xhr.responseText ).filename );
        				}
        				else
        				{
        					log.textContent = "Upload error.";
        					uploadError ();
        				}
        			}
        			else
        			{
        				log.textContent = "Upload error.";
        				uploadError ();
        			}
    			}
			};
			

   			
   			// Link abort button
   			abortButton.addEventListener (
     			"click",
      			() => {
        			xhr.abort();
      			},
      			{ once: true },
    		);

    		// When the upload starts, we display the progress bar
    		xhr.upload.addEventListener("loadstart", (event) => {
      			progressBar.classList.add("visible");
      			progressBar.value = 0;
      			progressBar.max = event.total;
      			log.textContent = "Uploading (0%)…";
      			abortButton.disabled = false;
    		});

    		// Each time a progress event is received, we update the bar
    		xhr.upload.addEventListener("progress", (event) => {
      			progressBar.value = event.loaded;
      			log.textContent = `Uploading (${(
        		(event.loaded / event.total) *
        		100
      			).toFixed(2)}%)…`;
    		});

    		function errorAction(event) 
    		{
      			progressBar.classList.remove("visible");
      			log.textContent = `Upload failed: ${event.type}`;

      			this.UploadError ();
    		}
    		// xhr.upload.addEventListener("error", errorAction);
    		xhr.upload.addEventListener("abort", errorAction);
    		xhr.upload.addEventListener("timeout", errorAction);
    		

    		// Build the payload
    		const fileData = new FormData();
    		fileData.append ( "file", fileToUpload );
    		fileData.append ( 'folder', folder );

    		// Theoretically, event listeners could be set after the open() call
    		// but browsers are buggy here
    		xhr.open("POST", "SubFW/html/UploadFile.php", true);

    		// Note that the event listener must be set before sending (as it is a preflighted request)
    		xhr.send(fileData);
  		}
	}

	function C_FileValidate ( ident )
	{
		let cfObj = $('#'+ident).data ('CFObj');

		cfObj.Validate ();
	}



	//############################################################################################
	// ### Class C_FileDT

	function CFShortcut ( origine )
	{
		return '<img class=\"C_FileDT_Edit imgclickable  pe-2\" title=\"'+Translate ( 'Edit' )+'\" src=\"SubFW/bmp/edit_blue.png\" style=\"height: 18px; width: auto;\"></img><img class=\"C_FileDT_Download imgclickable  pe-2\" title=\"'+Translate ( 'Download' )+'\" src=\"SubFW/bmp/download_blue.png\" style=\"height: 22px; width: auto;\"></img>';
	}

	class C_FileDT
	{
		constructor ( ident )
		{
			if ( DT_FileDlg == null )
				DT_FileDlg = new C_File ();

			// External data
			this.Ident				= ident;
			this.Caption			= "";
			this.Container			= "";
			this.DocType			= "";
			this.ExtID  			= -1;


			// Local data
			this.FileDT				= null;
			this.Initialized 		= false;
		
			this.FileDT = new C_DataTable ();
			this.FileDT.DataSrcType		= 0;
			this.FileDT.Ident 			= this.Ident +'_DT';
			this.FileDT.Container 		= this.Ident + '_DTContainer';
			this.FileDT.DataSrc 			= 'SubFW/database/common/GetDTRealFiles.php';
			this.FileDT.DataFct			= this.DTGetData.bind(this);
			this.FileDT.SetColReorder 	( true );

			// this.FileDT.AddColumn ( 'Shortcuts',				'',		 					0, true,   0, 	 100, false, '', 	'<img class=\"C_FileDT_Histo imgclickable  pe-2\" title=\"'+Translate ( 'Previous versions' )+'\" src=\"SubFW/bmp/counter_back_blue.png\" style=\"height: 18px; width: auto;\"></img><img class=\"C_FileDT_AddVersion imgclickable  pe-2\" title=\"'+Translate ( 'Add' )+'\" src=\"SubFW/bmp/add_blue.png\" style=\"height: 18px; width: auto;\"></img><img class=\"C_FileDT_Edit imgclickable  pe-2\" title=\"'+Translate ( 'Edit' )+'\" src=\"SubFW/bmp/edit_blue.png\" style=\"height: 18px; width: auto;\"></img><img class=\"C_FileDT_View imgclickable  pe-2\" title=\"'+Translate ( 'View' )+'\" src=\"SubFW/bmp/view_blue_48.png\" style=\"height: 18px; width: auto;\"></img>' );
			this.FileDT.AddColumn ( 'Shortcuts',			'shortcut',					0, true,   0, 	 80, false, '', 	'', CFShortcut );
			this.FileDT.AddColumn ( 'id',					'id',	 					1, false,  1,  '10%', false, '',	'' );
			this.FileDT.AddColumn ( 'doc_master_id',		'doc_master_id',			1, false,  2,  '10%', false, '',	'' );
			this.FileDT.AddColumn ( 'doc_master_groupid',	'doc_master_groupid',		1, false,  3,  '10%', true,  '', 	'' );
			this.FileDT.AddColumn ( 'Label',				'label', 					1, true,   4,  '10%', true,  '', 	'' );
			this.FileDT.AddColumn ( 'Date',					'date',						1, true,   5,  '10%', true,  '', 	'' );
			this.FileDT.AddColumn ( 'Author',				'author',					1, true,   6,  '10%', true,  '', 	'' );
			this.FileDT.AddColumn ( 'Name',					'name',						1, true,   7,  '10%', true,  '', 	'' );
			this.FileDT.AddColumn ( 'Comment',				'comment',					1, true,   8,  '10%', true,  '', 	'' );
		}

		Create ( mode )		// Mode : 0 = couleur application, arrondi, pading 2.   Mode : 1 = couleur gris, pas d'arrondi, padding 0.
		{
			mode = ( mode == undefined )? 0 : mode;
			let tmp = "";

			let onAddFile 		= this.OnAddFile.bind (this)
			let onDeleteFile 	= this.OnDeleteFile.bind (this)

			if ( mode == 0 )
			{
				tmp += '<div id="'+this.Ident+'_Div" class="c_filedt d-flex flex-column h-100 p-2">';
				tmp += 		'<div class="row m-0">';
				tmp +=			'<div class="ximeo_caption w-100 text-white ps-2 pe-2 pt-2 pb-2">';
			}
			else
			{
				tmp += '<div id="'+this.Ident+'_Div" class="c_filedt d-flex flex-column h-100 p-0 border">';
				tmp += 		'<div class="row m-0">';
				tmp += 				'<div class="w-100 m-0 ps-2 pe-2 pt-1 pb-1 border-bottom ximeo_bg-dark-3 text-white" >';
			}
			tmp +=				'<div class="row w-100 m-0 p-0">';
			tmp +=					'<div class="col-auto m-0 p-0">';
			tmp +=						'<span data-langkey="'+this.Caption+'"></span>';
			tmp +=					'</div>';
			tmp +=					'<div class="col m-0 p-0">';
			tmp +=						'<div class="d-flex flex-row-reverse w-100 h-100 m-0 p-0">';
			tmp +=							'<div class="col-md-auto h-100 m-0 p-0">';
			tmp +=								'<img id="'+this.Ident+'_DeleteButton" src="SubFW/bmp/trash_white.png" data-langkey_title="Delete" class="imgclickable ximeo_bmp">';
			tmp +=							'</div>';
			tmp +=							'<div class="col-md-auto h-100 m-0 p-0 ps-2 pe-2">';
			tmp +=								'<img id="'+this.Ident+'_AddButton" src="SubFW/bmp/add_white.png" data-langkey_title="Add" class="imgclickable ximeo_bmp">';
			tmp +=							'</div>';
			tmp +=						'</div>';
			tmp +=					'</div>';
			tmp +=				'</div>';
			tmp +=			'</div>';
			tmp +=		'</div>';
			tmp +=		'<div class="row flex-grow-1 m-0 bg-warning">';
			tmp +=			'<div id="'+this.Ident+'_DTContainer" class="col w-100 h-100 m-0 p-0 ps-2 pe-2 bg-white">';
			tmp +=			'</div>';
			tmp +=		'</div>';
			tmp +=	'</div>';


			document.getElementById ( this.Container ).innerHTML = tmp;

			document.getElementById ( this.Ident + '_AddButton' 	).addEventListener ( "click", onAddFile 	);
			document.getElementById ( this.Ident + '_DeleteButton' 	).addEventListener ( "click", onDeleteFile 	);

			this.FileDT.Create ();

			let dtProperties = this.DTProperties.bind (this);

			let C_FileDTListMenu = [
				{
					header: ''
				},
				{
					img: 'SubFW/bmp/setup_1_blue.png',
					text: 'Grid properties...',
					action: function(e, selector) { dtProperties (); }
				}
			];

			context.attach ( '#' + this.FileDT.Ident, C_FileDTListMenu );
			this.FileDT.SetRowToSelect('first_row');

			let onEditFile 		= this.OnEditFile.bind ( this );
			let onDownloadFile 	= this.OnDownloadFile.bind ( this );

			let ident = this.Ident;

			$('#'+this.Ident +'_DT'+' tbody').on('click', '.C_FileDT_Edit', function () 
			{
				let row = $(this).closest('tr');
				let id = $('#'+ident +'_DT').DataTable().row( row ).data().id;
					
				onEditFile ( id );
			} );	

			$('#'+this.Ident +'_DT'+' tbody').on('click', '.C_FileDT_Download', function () 
			{
				let row = $(this).closest('tr');
				let id = $('#'+ident +'_DT').DataTable().row( row ).data().id;
					
				onDownloadFile ( id );
			} );	
		}

		LoadUserCfg ( use_id )
		{
			this.FileDT.LoadUserCfg ( use_id );
		}

		DTProperties ()
		{
			this.FileDT.Properties ();
		}

		DTGetData ( d ) 
		{
			d.ext_id 		= this.ExtID;
			d.doctype		= this.DocType;
			d.versioning	= 0;
					
			return $.extend( {}, d );
		}


		Refresh ()
		{
			this.FileDT.Refresh ();
		}

		// ##########################################################################""
		// ### Add document

		AddDocumentOKCallback ( data )
		{
			this.FileDT.Refresh ();
			this.FileDT.SetRowToSelect ( 'id', data.tid );
		}

		AddDocumentErrorCallback ( data )
		{
		}

		OnAddFile ()
		{
			let data = {};
			data.Type 				= this.DocType;
			data.Caption			= Translate ( "New file" );
			data.Folder				= this.DocType;
			data.ExtID  			= this.ExtID;
			data.OKCallbackFct 		= this.AddDocumentOKCallback.bind(this);
			data.ErrorCallbackFct 	= this.AddDocumentErrorCallback.bind(this);

			DT_FileDlg.Add ( data );
		}


		// ##########################################################################""
		// ### Delete file

		OnDeleteFile ()
		{
			let data = {};
			data.RequestURL		= "SubFW/database/common/delete_document.php";
			data.RequestData	= "id";
			data.DTColIdent		= "id";
			data.NoSelectedMsg 	= Translate ( "No document selected !!!" );
			data.ConfirmMsg 	= Translate ( "Delete selected document ?" );
			data.ErrorMsg 		= Translate ( "Unable to delete document !!!" );

			this.FileDT.DeleteSelectedRow ( data );
		}

	
		// ##########################################################################""
		// ### Edit file

		OnEditFile ( id )
		{
			let data = {};
			data.Type  				= this.DocType;
			data.Caption			= Translate ( "Edit file" );
			data.ID  				= id;
			data.OKCallbackFct 		= this.AddDocumentOKCallback.bind(this);
			data.ErrorCallbackFct 	= this.AddDocumentErrorCallback.bind(this);
		
			DT_FileDlg.Edit ( data );
		}

	
		// ##########################################################################""
		// ### Download file

		OnDownloadFile ( id )
		{
			var a = document.createElement("a");
        	document.body.appendChild(a);
        	var idd = 'docid'+id;
        	a.id=idd;
        	a.href = G_ServerAddress + eoDACS.ServerFolder + "/eoDACS/SubFW/database/common/download.php?docid="+id;
        	a.click();
        	document.body.removeChild(a);
		}
	}
