function InitMainPage ()
{
	let mainInit = sessionStorage.getItem ( 'MainPageInitialized' );

	if ( mainInit == 'true' )
	{
		return;
	}

	sessionStorage.setItem ( 'MainPageInitialized', 					true  );
				
	sessionStorage.setItem ( 'DashboardPageInitialized', 				false );
	sessionStorage.setItem ( 'ExamListPageInitialized', 				false );
	sessionStorage.setItem ( 'PatientDosimetryPageInitialized',  		false );
	sessionStorage.setItem ( 'StatisticPageInitialized',				false );
	sessionStorage.setItem ( 'ExportAuthoritiesPageInitialized',		false );
	sessionStorage.setItem ( 'SettingsPageInitialized',					false );
							
	$(document).ready ( function () 
	{
		let exportLabel = 'Export to authorities';
		if ( eoDACS.Country == 'BE' )
			exportLabel = "Export AFCN";
		if ( eoDACS.Country == 'FR' )
			exportLabel = "Export ASN";

		LeftTabs = new C_Tab ();

		LeftTabs.Ident 		= "IdcLeftTabs";
		LeftTabs.Container 	= "IdcLeftTabsContainer";

		LeftTabs.AddTab ( 'VIEW_DASHBOARD', 				"Dashboard", 				"fas fa-fw fa-tachometer-alt fs-4", 		OnSelectDashboard 			);
		LeftTabs.AddTab ( 'VIEW_EXAM_LIST',	 				"Exams list",	 			"fas fa-fw fa-list-alt fs-4",	 			OnSelectExamList 			);
		LeftTabs.AddTab ( 'VIEW_PATIENT_DOSIMETRY',			"Patient dosimetry",		"fas fa-fw fa-book-medical fs-4",	 		OnSelectPatientDosimetry	);
		LeftTabs.AddTab ( 'VIEW_STATISTIC', 				"Statistic",				"fas fa-fw fa-chart-area fs-4",				OnSelectStatistic			);
		LeftTabs.AddTab ( 'VIEW_EXPORT_AUTHORITIES',		exportLabel,				"fas fa-fw fa-file-export fs-4",			OnSelectExportAuthorities	);
		LeftTabs.AddSeparator ( 40 );
		LeftTabs.AddTab ( 'VIEW_SETUP',						"Parameters",				"fas fa-fw fa-cog fs-4",					OnSelectSettings			);

		LeftTabs.Create ();

		SelectPage ( LeftTabs.GetFirstTabIdent () );

		InitExamListPage ();
		// InitPatientDosimetryPage ();

		switchLanguage ( eoDACS.CurrentLanguage );

	} );
}



function SelectPage ( id )
{
	if ( LeftTabs.SelectTab ( id ) == true )
	{
	}
	else
	{
		console.log ( "Error : bad left tab id !!!" );
	}
}

function HideAllPanels ()
{
	$('#IdcDivDashboard' ).hide ();
	$('#IdcDivExamList' ).hide ();
	$('#IdcDivPatientDosimetry' ).hide ();
	$('#IdcDivStatistic' ).hide ();
	$('#IdcDivExportAuthorities' ).hide ();
	$('#IdcDivSettings' ).hide ();
}

function OnSelectDashboard ()
{
	HideAllPanels ();

	WaitingStart ("Patientez...");
	
	RenderPage ( "SubFW/html/dashboard.php", "IdcDivDashboard" );
	
	$('#IdcDivDashboard' ).show ();
}

function OnSelectExamList ()
{
	HideAllPanels ();

	$('#IdcDivExamList' ).show ();
	InitExamListPage ();	
}

function OnSelectPatientDosimetry ()
{
	HideAllPanels ();

	$('#IdcDivPatientDosimetry' ).show ();
	InitPatientDosimetryPage ();	
}

function OnSelectStatistic ()
{
	console.log ( "OnSelectStatistic...");

	HideAllPanels ();
	
	

	// $('#IdcDivStatisticContainer' ).show ();

	$('#IdcDivStatistic' ).show ();
	InitStatisticPage ();	

	RenderPage ( "SubFW/html/Statistic1.php", "IdcStatisticGraphicPanel" );
}


function OnSelectExportAuthorities ()
{
	HideAllPanels ();

	$('#IdcDivExportAuthorities' ).show ();
	InitExportAuthoritiesPage ();	

	RenderPage ( "SubFW/html/ExportAuthorities.php", "IdcExportAuthoritiesPanel" );
}

function OnSelectSettings ()
{
	HideAllPanels ();

	$('#IdcDivSettings' ).show ();
	InitSettingsPage ();	
}


