
	// Warning
	function MsgWarning ( warningText )
	{
		$('#IdcMsgWarningText').text ( warningText );
		
		$('#IdcMsgWarning').modal('show');
	}
	
	
	
	// Yes / No

	function MsgYesNo ( questionText, onYesFunction, onNoFunction )
	{
		$('#IdcMsgYesNoQuestionText').text ( questionText );
		
		$('#IdcMsgYesNo_Yes_Button').unbind ( 'click' );
		$('#IdcMsgYesNo_Yes_Button').click ( {OnYesFunction: onYesFunction}, MsgYesNo_YesClicked );
		
		$('#IdcMsgYesNo_No_Button').unbind ( 'click' );
		$('#IdcMsgYesNo_No_Button').click ( {OnNoFunction: onNoFunction}, MsgYesNo_NoClicked );
		
		
		$('#IdcMsgYesNo').modal('show');
	}
	
	function MsgYesNo_YesClicked ( event )
	{
		if ( event.data.OnYesFunction != null )
			event.data.OnYesFunction ();
		
		$('#IdcMsgYesNo').modal('hide');
	}
	
	function MsgYesNo_NoClicked ( event )
	{
		if ( event.data.OnNoFunction != null )
			event.data.OnNoFunction ();
		
		$('#IdcMsgYesNo').modal('hide');
	}
	
	
	
	
	// Comment
	function DlgComment ( captionText, ident, comment, onValidateFunction, onCancelFunction )
	{
		$('#IdcDlgComment').data ( 'ident', ident );
		
		$('#IdcDlgCommentEdit').val ( comment );
		
		$('#IdcDlgCommentCaption').text ( captionText );
		
		$('#IdcDlgComment_Validate_Button').unbind ( 'click' );
		$('#IdcDlgComment_Validate_Button').click ( {OnValidateFunction: onValidateFunction}, DlgComment_ValidateClicked );
		
		$('#IdcDlgComment_Cancel_Button').unbind ( 'click' );
		$('#IdcDlgComment_Cancel_Button').click ( {OnCancelFunction: onCancelFunction}, DlgComment_CancelClicked );
		
		$('#IdcDlgComment_Cross_Button').unbind ( 'click' );
		$('#IdcDlgComment_Cross_Button').click ( {OnCancelFunction: onCancelFunction}, DlgComment_CancelClicked );
		
		
		$('#IdcDlgComment').modal('show');
	}
	
	function DlgComment_ValidateClicked ( event )
	{
		if ( event.data.OnValidateFunction != null )
		{
			let text = $('#IdcDlgCommentEdit').val ();
			let ident = $('#IdcDlgComment').data ( 'ident' );
			
			event.data.OnValidateFunction ( ident, text );
		}
		
		$('#IdcDlgComment').modal('hide');
	}
	
	function DlgComment_CancelClicked ( event )
	{
		if ( event.data.OnCancelFunction != null )
			event.data.OnCancelFunction ();
		
		$('#IdcDlgComment').modal('hide');
	}
	
	
	function MsgPopup ( message, delay = 2000 ) 
	{
		const toastEl = document.getElementById ( 'IdcMsgPopup' );
		const toastBody = toastEl.querySelector ( '.toast-body' );

      	toastBody.textContent = message;
      	toastEl.setAttribute ( 'data-bs-delay', delay );

      	const toast = new bootstrap.Toast(toastEl);
      	toast.show ();
    }