	ExamListDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/patient_folder_2.png',
			text: 'Patient dosimetric folder...',
			action: function(e, selector) { ELDosimetricPatientFolder (); }
		},
		{
			img: 'SubFW/bmp/alert_management.png',
			text: 'Alert management...',
			action: function(e, selector) { ELAlertStatus (); }
		},
		{
			divider: true
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcExamListDT.Properties (); }
		}		
	];

	let ELDTRefreshAllowed = true;
	let ELTabToSelect = '';
	let ELNDRToSelect = '';

	let IdcELModalityFilter = null;

	IdcExamListDT = null;
		
	function InitExamListPage ()
	{
		let ss = sessionStorage.getItem ( 'ExamListPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'ExamListPageInitialized', true );

		IdcExamListDT = new C_DataTable ();
		IdcExamListDT.DataSrcType		= 0;
		IdcExamListDT.Ident 			= 'IdcExamListDT';
		IdcExamListDT.Container 		= 'IdcELDTContainer';
		IdcExamListDT.CfgParameterName 	= 'ExamListDTProperties';
		IdcExamListDT.DataSrc 			= 'SubFW/database/examlist/GetDTExamList.php';
		IdcExamListDT.DataFct			= ExamListDTGetData;
		IdcExamListDT.DrawCallbackFct	= ExamListDTDrawCallback;
		IdcExamListDT.DeferLoading		= 0;
		IdcExamListDT.AllowColumnHidding ( false );
		IdcExamListDT.SetColReorder 	( true );
		IdcExamListDT.OnSelectChanged	( ExamListDTSelectChanged );
		IdcExamListDT.OnDClickFct		= ExamListDTDClick;

		IdcExamListDT.RowCallbackFct	= ExamListDTRowCallback;
				



		IdcExamListDT.AddColumn ( '',													'alertraise',				0, true,   0,   80,  false, 'text-center', 	'', ELShortcut );		
		IdcExamListDT.AddColumn ( 'ack_id',										'ack_id',						0, false,  1,   70,  false, 'text-center', 	'' );
		IdcExamListDT.AddColumn ( 'pat_id',										'pat__id',					0, false,  2,   50,  true,  '', 			'' );
		IdcExamListDT.AddColumn ( 'stu_id',										'stu_id',						0, false,  3,   50,  true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('RI/RX'),					'isri',	 						1, true,   4, '10%', true,  'text-center', 			'' );
		IdcExamListDT.AddColumn ( Translate('A.N.'),					'accessionnumber',	1, true,   5, '10%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('Date'),					'date',							1, true,   6, '15%', true,  'text-center', 	'' );
		IdcExamListDT.AddColumn ( Translate('Name'),					'pname',						1, true,   7, '20%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('Modality'),			'mname',						1, true,   8, '10%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('Study'),					'description',			1, true,   9, '20%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('Radioelement'),	'radioelement_auto',1, true,  10, '20%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('MBq'),						'dosenm_auto',			1, true,  11, '20%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('DAP(mGy.cm²)'),	'dap_total',				1, true,  12, '15%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('DLP(mGy.cm)'),		'dlp_auto',					1, true,  13, '15%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( Translate('DGM(mGy)'),			'dgm_auto',					1, true,  14, '15%', true,  '', 			'' );
		IdcExamListDT.AddColumn ( 'alertraise',								'alertraise',				1, false, 15, '15%', true,  '', 			'' );

		let currentDate = GetCurrentDate();
		
		const rirxList = [
			{ id: '',		label: '*'},
			{ id: 'RI',	label: 'RI'},
			{ id: 'RX',	label: 'RX'}
		];
		IdcExamListDT.ColumnFilter ( 'isri',							'combo',	rirxList );
		IdcExamListDT.ColumnFilter ( 'date',							'period' );
		IdcExamListDT.ColumnFilter ( 'accessionnumber', 	'text' );
		IdcExamListDT.ColumnFilter ( 'pname', 						'text' );
		IdcExamListDT.ColumnFilter ( 'mname', 						'other',			'<div class="m-0 h-100 p-0 pb-2 pe-1" id="IdcELModalityFilterContainer"></div>' );
		IdcExamListDT.ColumnFilter ( 'description', 			'text' );

		IdcExamListDT.SetDefaultOrderColumn ( 4, 'asc' );

		IdcExamListDT.RefreshDelay = 800;
		
		IdcExamListDT.LoadUserCfg ( G_USE_ID );
		

		$(document).ready(function () 
		{
			console.log ("ready...");

			document.getElementById ('IdcELRXTab').addEventListener ( 'shown.bs.tab', () => { ELRXTabShown (); } );
			document.getElementById ('IdcELCTTab').addEventListener ( 'shown.bs.tab', () => { ELCTTabShown (); } );
			document.getElementById ('IdcELMGTab').addEventListener ( 'shown.bs.tab', () => { ELMGTabShown (); } );
			document.getElementById ('IdcELNMTab').addEventListener ( 'shown.bs.tab', () => { ELNMTabShown (); } );

			IdcExamListDT.Create ();
			context.attach ( '#IdcExamListDT', ExamListDTListMenu );
			IdcExamListDT.SetRowToSelect('first_row');
			$('#' + IdcExamListDT.Ident +' tbody').on('click', '.ExamList_View', function () 
			{
				let tr = $(this).closest('tr');
					
				ELViewClicked ( tr );
			} );
			$('#' + IdcExamListDT.Ident +' tbody').on('click', '.ExamList_Alert', function () 
			{
				let tr = $(this).closest('tr');
					
				ELAlertClicked ( tr );
			} );




			IdcELModalityFilter = new C_CheckboxMenu ( "IdcELModalityFilterContainer", "IdcELModalityFilter", Translate("Select") );
			InitModalitiesCBList ( IdcELModalityFilter );
			IdcELModalityFilter.CallbackFct = ExamListModalitiesCBChanged;

			ELFillAlertFilter ( 'RX' );
			
			switchLanguage ( eoDACS.CurrentLanguage );

			IdcExamListDT.Refresh ();

		
			/*
  			import('../../test.js')
      .then(module => {
        console.log('Module chargé !');
        module.initCubeScene('IdcTestRenderArea');
      })
      .catch(err => console.error('Erreur chargement module :', err));
		*/

		});
		
	}

	function ELShortcut ( alertraise, ident, row, col )
	{
		// console.log ( "ELShortcut : " + alertraise +  " / " + row );

		// console.log ( "ack_id : " + IdcExamListDT.GetRowData ( row ).ack_id );
		// let bmpAlert 	= 'alert_gray_ko.png';
		let bmpAlert 	= 'empty.png';
		let titleAlert  = 'No alert';
		let clickable	= '';

		if  ( alertraise > 0 )
		{
			let ack_id = IdcExamListDT.GetRowData ( row ).ack_id;

			if ( alertraise < 1.10 )
        		bmpAlert 	= (ack_id == null)? 'alert_green_ko.png' : 'alert_green_ok.png';
			else 
    			if ( alertraise < 1.30 )
    				bmpAlert 	= (ack_id == null)? 'alert_orange_ko.png' : 'alert_orange_ok.png';
    			else
    				bmpAlert 	= (ack_id == null)? 'alert_red_ko.png' : 'alert_red_ok.png';

			
			titleAlert  = 'Alert';
			clickable	= 'imgclickable';
		}

		let tmp  = '<img class=\"ExamList_View imgclickable  pe-2 border-end\" title=\"'+Translate ( 'Patient dosimetric summary' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/report.png\" style=\"height: 18px; width: auto;\"></img>';
		tmp 	+= '<img class=\"ExamList_Alert '+clickable+'  ps-2 pe-2\" title=\"'+Translate ( titleAlert )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/'+bmpAlert+'\" style=\"height: 28px; width: auto;\"></img>';

		return tmp;
	}

	function ELDatesFilterChanged ( dteIdx )
	{
		let d1 = new Date ( $('#IdcELDateFilter1').val () );
		let d2 = new Date ( $('#IdcELDateFilter2').val () );

		if ( dteIdx == '0' )
		{
			if ( d1 > d2 )
			{
				$('#IdcELDateFilter2').val ( $('#IdcELDateFilter1').val () );
			}
		}
		else
		{
			if ( d2 < d1 )
			{
				$('#IdcELDateFilter1').val ( $('#IdcELDateFilter2').val () );
			}
		}

		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}
		
	function ExamListDTGetData ( d )
	{
		console.log ("ExamListDTGetData...");

		console.log ( "RX visible : " + $('#IdcELRXPanel').is(':visible') );
		let modality = '';
		if ( $('#IdcELRXPanel').is(':visible') == true )
			modality = 'RX';
		else
			if ( $('#IdcELCTPanel').is(':visible') == true )
				modality = 'CT';
			else
				if ( $('#IdcELMGPanel').is(':visible') == true )
					modality = 'MG';

		d.modality = modality;
		d.rirx 		= $('#IdcExamListDT_isri :selected').val ();
		d.modalities = encodeURIComponent(IdcELModalityFilter.GetSelection2String ());

		d.date1  	= $('#IdcExamListDT_date_from').val ();
		d.date2  	= $('#IdcExamListDT_date_to').val ();
		d.acn 	  = $('#IdcExamListDT_accessionnumber').val ();
		d.pname	  = $('#IdcExamListDT_pname').val ();
		d.study 	= $('#IdcExamListDT_description').val ();
		
		if ( $('#IdcELAlertDiv').is (":visible") == true )
		{
			d.alertraised 	= 'true';
			d.nrdid			= $('#IdcELAlertList :selected').val ();;
		}
		else
		{
			d.alertraised 	= 'false';
		}

		WaitingStart ( Translate('Request in progress. Please wait.') );

		return $.extend( {}, d );
	}

	function ExamListModalitiesCBChanged ()
	{
		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}
		
		
	function ExamListDTSelectChanged ( rowsIdx )
	{
		let id 			= -1;
		let name 		= "";
		let type 		= "";
		let comment		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= $('#IdcExamListDT').DataTable().row( rowIdx ).data().id;
			name 		= $('#IdcExamListDT').DataTable().row( rowIdx ).data().name;
			type 		= $('#IdcExamListDT').DataTable().row( rowIdx ).data().type;
			comment 	= $('#IdcExamListDT').DataTable().row( rowIdx ).data().comment;
		}
	}

	function ELSetTabCaption ()
	{
		let idc = '';
		let label = '';
		if ( $('#IdcELRXPanel').is(':visible') == true )
		{
			idc = 'IdcELRXTab';
			label = Translate('RX');
		}
		else
			if ( $('#IdcELCTPanel').is(':visible') == true )
			{
				idc = 'IdcELCTTab';
				label = Translate('CT');
			}
			else
				if ( $('#IdcELMGPanel').is(':visible') == true )
				{
					idc = 'IdcELMGTab';
					label = Translate('MG');
				}
		if ( idc != '' )
		{
			let nbRecords = $('#IdcExamListDT').DataTable().page.info().recordsDisplay;
			console.log ( "Records : " + $('#IdcExamListDT').DataTable().page.info().recordsDisplay );
			$('#'+idc).html ( label + ' (<small>' +nbRecords+'</small>)' );
		}
	}

	function ExamListDTDrawCallback ( dtIdent )
	{
		WaitingStop ();

		ELSetTabCaption ();
	}

	function ExamListDTDClick ( rowIdx )
	{
		console.log ( "ExamListDTDClick..." );

		let pat_id 	= $('#IdcExamListDT').DataTable().row( rowIdx ).data().pat_id;
		let pname 	= $('#IdcExamListDT').DataTable().row( rowIdx ).data().pname;

		OpenModalPatientReport ( pat_id, pname );
	}

	function ELFillAlertFilter ( nrdtype )
	{
		$('#IdcELAlertList').find('option').remove ();

		$.post (
			"./SubFW/database/examlist/get_alert.php",
			{
				nrdid: -1,
				nrdtype: nrdtype
			},
			function ( data, status) 
			{
				for ( let i=0; i<data.length; i++ )
				{
					let value = data [i].id;
					let text  = data [i].name;

					$('#IdcELAlertList').append ( $('<option>',
					{
						value: value,  
						text: text
					}));

				}

				ELAlertFilterReady ();
			}
		);
	}

	function OnELAlertClicked ()
	{
		if ( $('#IdcELAlertDiv').is (":visible") == true )
		{
			$('#IdcELAlertDiv').hide ();

			$('#IdcELAlertIcon').removeClass ( "text-danger" );
			$('#IdcELAlertIcon').addClass ( "text-secondary" );
		}
		else
		{
			$('#IdcELAlertDiv').show ();

			$('#IdcELAlertIcon').removeClass ( "text-secondary" );
			$('#IdcELAlertIcon').addClass ( "text-danger" );
		}

		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}
	

	function ELViewClicked ( tr )
	{
		console.log ( "ELViewClicked..." );

		let row = $('#'+IdcExamListDT.Ident).DataTable ().row ( tr );

		console.log ( " ID : " + row.data().stu_id );

		OpenModalStudyReport ( row.data().stu_id );
	}

	function ELAlertClicked ( tr )
	{
		console.log ( "ELAlertClicked..." );

		let row = $('#'+IdcExamListDT.Ident).DataTable ().row ( tr );

		if ( row.data().alertraise == 0 )
			return;


		if ( row.child.isShown() ) 
		{
			row.child.hide ();
			tr.removeClass ( 'shown' );
		} 
		else 
		{
			let test = ELFillAlertSubDT ( tr, row );
		}
	}

	

	function ELFillAlertSubDT ( tr, row )
	{
		$.post (
			"./SubFW/database/examlist/get_alertforstudy.php",
			{
				stu_id: row.data().stu_id
			},
			function ( data, status) 
			{
				let div = $('<div class="row m-0 p-0">')
					.addClass( 'loading' )
					.text( 'Loading...' );

				let ret = '';
				ret += '<div class="col-auto m-2 p-2 border bg-light">';
				ret += 		'<div class="row m-0 p-2 ps-0 pt-0 fw-bold">';
				ret += 			Translate("Alerts");
				ret += 		'</div>';
				ret += 		'<div class="row m-0 p-0">';
				ret += 			'<div class="col-auto m-0 p-0">';
				ret += 				'<table id="IdcTable001" class="SubTable m-0 p-0 border-bottom">';
				ret += 					'<thead class="border-bottom" style="border-color: #067fb8 !important;">';
				ret += 						'<tr>';
				ret +=							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width: 100px;">'+Translate('Alert name')+'</th>';
				ret +=							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width: 100px;">'+Translate('Description')+'</th>';
				ret +=							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width: 100px;">'+Translate('Serie description')+'</th>';
				ret += 							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width:  40px;">'+Translate('Instance number')+'</th>';
				ret += 							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width:  34px;">'+Translate('DRL type')+'</th>';
				ret += 							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width:  36px;">'+Translate('Value')+'</th>';
				ret += 							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width:  36px;">'+Translate('DRL value')+'</th>';
				ret += 							'<th class="border-end p-0 ps-2 pe-2 fw-bold" style="width:  36px;">'+Translate('Factor')+'</th>';
				ret += 						'</tr>';
				ret += 					'</thead>';
				ret += 					'<tbody class="SubTable">';

				for ( let i=0; i<data.length; i++ )
				{
					let saw_id 				= data [i].saw_id;
					let alertname  			= (data [i].alertname != null)? data [i].alertname : '';
					let description  		= data [i].description;
					let description_auto 	= (data [i].description_auto != null)? data [i].description_auto : '';
					let instancenumber 		= (data [i].instancenumber != null)? data [i].instancenumber : '';
					let valuetype	 		= data [i].valuetype;
					let currentvalue 		= data [i].currentvalue;
					let nrdvalue	 		= data [i].nrdvalue;
					let factor		 		= data [i].factor;

					let textColor = '';
					let val = parseFloat ( factor );
					if ( val < 1.10 )
      				{
          				textColor = 'style="color:#808000;"';

      				}
      				else 
      					if ( val < 1.30 )
      					{
          					textColor = 'style="color:darkorange;"';
      					}
      					else
      					{
          					textColor = 'style="color:red;"';
      					}


					ret +=					'<tr '+textColor+'>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+alertname+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+description+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+description_auto+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+instancenumber+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+valuetype+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+currentvalue+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+nrdvalue+'</td>';
					ret +=							'<td class="border-end p-0 ps-2 pe-2">'+factor+'</td>';
					ret +=					'</tr>';
				}

				ret +=					'</tbody>';
				ret +=				'</table>';
				ret += 			'</div>';		// Col
				ret += 		'</div>';		// Row
				ret += '</div>';
				
				div
					.html( ret )
					.removeClass( 'loading' );

				row.child ( div ).show ();
				tr.addClass ( 'shown' );
			}
		);
	}

	function ExamListDTRowCallback ( nRow, aData, iDisplayIndex )
	{
		let val = parseFloat ( aData.alertraise );
		if ( val > 0 )
		{
			let alert_class = '';

			if ( val < 1.10 )
        		alert_class = 'alert_green';
			else 
    			if ( val < 1.30 )
    				alert_class = 'alert_orange';
    			else
    				alert_class = 'alert_red';

    		if ( alert_class != '' )
    			$(nRow).addClass ( alert_class );
    	}
	}



	function ELDosimetricPatientFolder ()
	{
		console.log ( "ELDosimetricPatientFolder..." );

		// IdcPatientDosimetrySplitter1_2

		let pat_id 	= IdcExamListDT.GetSelectedRowData ().pat_id;
		let pname 	= IdcExamListDT.GetSelectedRowData ().pname;

		OpenModalPatientReport ( pat_id, pname );
	}



	function ELRXTabShown ()
	{
		console.log ( "ELRXTabShown..." );

		var element = $('#IdcELDTContainer').detach();
		$('#IdcELRXPanel').append(element);
		ELFillAlertFilter ( 'RX' );


		$('#IdcELRiRxFilter').find('option').remove ();
		$('#IdcELRiRxFilter').append ( new Option ( '*', '') );
		$('#IdcELRiRxFilter').append ( new Option ( 'RX', 'RX') );
		$('#IdcELRiRxFilter').append ( new Option ( 'RI', 'RI') );
		
		IdcExamListDT.SetColumnTitle ( 'isri', 		Translate('RI/RX') );
		IdcExamListDT.SetColumnTitle ( 'dap_total', Translate('DAP(mGy.cm²)') );

		IdcExamListDT.ShowColumn ( 'isri', true );
		IdcExamListDT.ShowColumn ( 'dap_total',			true 	);	// RX
		IdcExamListDT.ShowColumn ( 'dlp_auto', 			false 	);	// CT
		IdcExamListDT.ShowColumn ( 'dgm_auto', 			false 	);	// MG
		IdcExamListDT.ShowColumn ( 'radioelement_auto', false 	);	// NM
		IdcExamListDT.ShowColumn ( 'dosenm_auto', 		false 	);	// NM

		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}

	function ELCTTabShown ()
	{
		console.log ( "ELCTTabShown..." );

		var element = $('#IdcELDTContainer').detach();
		$('#IdcELCTPanel').append(element);
		ELFillAlertFilter ( 'CT' );

		$('#IdcELRiRxFilter').find('option').remove ();
		$('#IdcELRiRxFilter').append ( new Option ( '*', '') );
		$('#IdcELRiRxFilter').append ( new Option ( 'CT', 'CT') );
		$('#IdcELRiRxFilter').append ( new Option ( 'RI', 'RI') );
		
		IdcExamListDT.SetColumnTitle ( 'isri', Translate('RI/CT') );
		// IdcExamListDT.SetColumnTitle ( 'dap_total', Translate('DLP(mGy.cm)') );

		IdcExamListDT.ShowColumn ( 'isri', true );
		IdcExamListDT.ShowColumn ( 'dap_total',			false 	);	// RX
		IdcExamListDT.ShowColumn ( 'dlp_auto', 			true 	);	// CT
		IdcExamListDT.ShowColumn ( 'dgm_auto', 			false 	);	// MG
		IdcExamListDT.ShowColumn ( 'radioelement_auto', false 	);	// NM
		IdcExamListDT.ShowColumn ( 'dosenm_auto', 		false 	);	// NM

		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}

	function ELMGTabShown ()
	{
		console.log ( "ELMGTabShown..." );

		var element = $('#IdcELDTContainer').detach();
		ELFillAlertFilter ( 'MG' );
		$('#IdcELMGPanel').append(element);

		IdcExamListDT.ShowColumn ( 'isri', false );
		IdcExamListDT.ShowColumn ( 'dap_total',			false 	);	// RX
		IdcExamListDT.ShowColumn ( 'dlp_auto', 			false 	);	// CT
		IdcExamListDT.ShowColumn ( 'dgm_auto', 			true 	);	// MG
		IdcExamListDT.ShowColumn ( 'radioelement_auto', false 	);	// NM
		IdcExamListDT.ShowColumn ( 'dosenm_auto', 		false 	);	// NM

		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}

	function ELNMTabShown ()
	{
		console.log ( "ELNMTabShown..." );

		var element = $('#IdcELDTContainer').detach();
		ELFillAlertFilter ( 'NM' );
		$('#IdcELNMPanel').append(element);

		IdcExamListDT.ShowColumn ( 'isri', false );
		IdcExamListDT.ShowColumn ( 'dap_total',			false 	);	// RX
		IdcExamListDT.ShowColumn ( 'dlp_auto', 			false 	);	// CT
		IdcExamListDT.ShowColumn ( 'dgm_auto', 			false 	);	// MG
		IdcExamListDT.ShowColumn ( 'radioelement_auto', true 	);	// NM
		IdcExamListDT.ShowColumn ( 'dosenm_auto', 		true 	);	// NM

		if ( ELDTRefreshAllowed == true )
				IdcExamListDT.Refresh ();
	}

	function ELAlertStatus ()
	{
		console.log ( "ELAlertStatus...");

		// let stu_id = $('#IdcExamListDT').DataTable().row( rowIdx ).data().id;

		let stu_id = IdcExamListDT.GetSelectedRowData ().stu_id;

		showAlertModal ( stu_id );
	}



	function show_studyalert ( nrdtype, nrdid, modid )
	{
			console.log ( "show_studyalert...");
      // loadpageparam('examlist','nrdtype='+nrdtype+'&nrdid='+nrdid+'&modid='+modid);
      console.log ( " values : " + nrdtype + " / " + nrdid + " / " + modid );

      ELTabToSelect = 'IdcELCTTab';

      ELNDRToSelect = nrdid;

      ELDTRefreshAllowed = false;

      SelectPage ( 'VIEW_EXAM_LIST' );

      
      const triggerEl = document.getElementById('IdcELCTTab');
			const tab = new bootstrap.Tab(triggerEl);
			tab.show();

			let dataAlertPeriod  = document.getElementById ( 'IdcDashboard').dataset.alertperiod;
			let date = new Date ();
			date.setDate ( date.getDate() - dataAlertPeriod );
			$('#IdcExamListDT_date_from').val ( date.toISOString().split('T')[0] );	
    }




    function ELAlertFilterReady ()
    {
    		console.log ( "ELFilterReady...");

    		if ( ELNDRToSelect != '' )
    		{
						const alertList = document.getElementById('IdcELAlertList');
						const nrdid = String(ELNDRToSelect);

						ELNDRToSelect = '';

 						for (let option of alertList.options) 
 						{
   							const ids = option.value.split(',');
   							if (ids.includes(String(nrdid))) 
   							{
     								alertList.value = option.value;

     								$('#IdcELAlertDiv').show ();

										$('#IdcELAlertIcon').removeClass ( "text-secondary" );
										$('#IdcELAlertIcon').addClass ( "text-danger" );
										ELDTRefreshAllowed = true;

										IdcExamListDT.Refresh ();
     								break;
   							}
 						}
    		}
    }


    /* <i id="IdcELAlertIcon" class="fas fa-2x fa-exclamation-triangle text-danger" onclick="OnELAlertClicked();"></i>
    */

