

	PatientDosimetryDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcPatientDosimetryDT.Properties (); }
		}
	];

	PDPatientListDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcPDPatientListDT.Properties (); }
		}
	];

	let IdcPatientDosimetryDT = null;
	let PDCurrentJRXMLFolder  	= '';
	let PDCurrentJRXMLFileName	= '';
	let PDCurrentJRXMLParamName = '';
	let PDCurrentJRXMLID 		= -1;
	let PDCurrentPatientName	= '';
		
	function InitPatientDosimetryPage ()
	{
		console.log ( "### InitPatientDosimetryPage..." );

		let ss = sessionStorage.getItem ( 'PatientDosimetryPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'PatientDosimetryPageInitialized', true );
			
		IdcPatientDosimetryDT = new C_DataTable ();
		IdcPatientDosimetryDT.DataSrcType		= 0;
		IdcPatientDosimetryDT.Ident 			= 'IdcPatientDosimetryDT';
		IdcPatientDosimetryDT.Container 		= 'IdcPatientDosimetryDTContainer';
		IdcPatientDosimetryDT.CfgParameterName = 'PatientDosimetryDTProperties';
		IdcPatientDosimetryDT.DataSrc 			= 'SubFW/database/patient_dosimetry/GetDTHistoPatientList.php';
		IdcPatientDosimetryDT.DataFct			= PatientDosimetryDTGetData;
		IdcPatientDosimetryDT.SetColReorder 	( true );
		IdcPatientDosimetryDT.OnSelectChanged	( PatientDosimetryDTSelectChanged );
				
		IdcPatientDosimetryDT.AddColumn ( 'stu_id',			'stu_id',	 				0, false,  0,  50,  false, '', 					'' );
		IdcPatientDosimetryDT.AddColumn ( Translate('Mod.'),			'modalitytitle',		 	1, true,   1, '10%', true,  '', 				'' );
		IdcPatientDosimetryDT.AddColumn ( Translate('Date'),			'date', 					1, true,   2, '10%', true,  'text-center', 		'' );
		IdcPatientDosimetryDT.AddColumn ( Translate('Group'),			'groupname',				1, true,   3, '25%', true,  '', 				'' );
		IdcPatientDosimetryDT.AddColumn ( Translate('A.N.'),			'accessionnumber',			1, true,   4, '20%', true,  '', 				'' );
		IdcPatientDosimetryDT.AddColumn ( Translate('Description'),		'description',				1, true,   5, '35%', true,  '', 				'' );

		IdcPatientDosimetryDT.ColumnFilter (  'accessionnumber', 	'text' );
		IdcPatientDosimetryDT.ColumnFilter (  'description', 		'text' );
		
		IdcPatientDosimetryDT.LoadUserCfg ( G_USE_ID );




		IdcPDPatientListDT = new C_DataTable ();
		IdcPDPatientListDT.DataSrcType		= 0;
		IdcPDPatientListDT.Ident 			= 'IdcPDPatientListDT';
		IdcPDPatientListDT.Container 		= 'IdcPDPatientListDTContainer';
		IdcPDPatientListDT.CfgParameterName = 'PDPatientListDTProperties';
		IdcPDPatientListDT.DataSrc 			= 'SubFW/database/patient_dosimetry/GetDTPatientList.php';
		IdcPDPatientListDT.DataFct			= PDPatientListDTGetData;
		IdcPDPatientListDT.DrawCallbackFct	= PDPatientListDTDrawCallback;
		IdcPDPatientListDT.ErrorCallbackFct	= PDPatientListDTErrorCallback;
		IdcPDPatientListDT.SetColReorder 	( true );
		IdcPDPatientListDT.SelectOnRightClickEnabled = false;
		IdcPDPatientListDT.OnSelectChanged	( PDPatientListDTSelectChanged );
				
		IdcPDPatientListDT.AddColumn ( 'pat_id',				'pat_id',			0, false,  0,  50, 	 false, '', 				'' );
		IdcPDPatientListDT.AddColumn ( 'ID',					'id',	 			1, true,   1, '30%', true,  '', 				'' );
		IdcPDPatientListDT.AddColumn ( Translate('Name'),		'name',				1, true,   2, '35%', true,  '', 				'' );
		IdcPDPatientListDT.AddColumn ( Translate('Birthdate'),	'birthdate',		1, true,   3, '20%', true,  'text-center', 		'' );
		IdcPDPatientListDT.AddColumn ( Translate('Age'),		'age',				1, true,   4, '15%', true,  'text-center',		'' );
		IdcPDPatientListDT.AddColumn ( 'A.N.',					'accessionnumber',	1, true,   5, '15%', true,  '', 				'' );
		IdcPDPatientListDT.SetDefaultOrderColumn ( 2, 'asc' )

		// IdcPDPatientListDT.ColumnFilter (  'name', 		'text' );
		// IdcPDPatientListDT.ColumnFilter (  'birthdate', 'date' );
		
		
		IdcPDPatientListDT.LoadUserCfg ( G_USE_ID );
		

		$(document).ready(function () 
		{
			
			$('#IdcPDDosimetryDiv').data ( 'mode', 'visit' );
    		$('#IdcPDDosimetryDiv').data ( 'type', 'internal' );

			IdcPatientDosimetrySplitter1_2 	= new C_Splitter ( "IdcPatientDosimetrySplitter1_2" );

			IdcPatientDosimetryDT.Create ();
			context.attach ( '#IdcPatientDosimetryDT', PatientDosimetryDTListMenu );
			IdcPatientDosimetryDT.SetRowToSelect('first_row');

			IdcPDPatientListDT.Create ();
			context.attach ( '#IdcPDPatientListDT', PDPatientListDTListMenu );
			// IdcPDPatientListDT.SetRowToSelect('first_row');

			if ( $('#IdcPDPatientCaption').text () == '' )
				$('#IdcPDPatientCaption').text ( Translate ('No patient selected') );

			PDRefreshPatientReportsList ();
			$('#IdcPDPatientReportSelect').prop ( 'disabled', true );
			$('#IdcPDPatientReportSelect').on('change', PDPatientReportChanged );

			PDRefreshVisitReportsList ();
			$('#IdcPDVisitReportSelect').on('change', PDVisitReportChanged );

			$('#IdcPDJasperPDF').on('change', PDJasperPDFClicked );
			
			switchLanguage ( eoDACS.CurrentLanguage );
			
		});
	}
		
	function PatientDosimetryDTGetData ( d )
	{
		d.patid = $('#IdcPDPatientCaption').data ( 'id' );

		return $.extend( {}, d );
	}
		
		
	function PatientDosimetryDTSelectChanged ( rowsIdx )
	{
		console.log ( "PatientDosimetryDTSelectChanged..." );

		// $('#IdcPDJasperDiv').hide ();
    	// $('#IdcTestDetach').show ();

    	let mode = $('#IdcPDDosimetryDiv').data ( 'mode' );
    	let type = $('#IdcPDDosimetryDiv').data ( 'type' );

    	console.log ( " mode : " + mode );
    	if ( mode == 'patient' )
    	{
    		$('#IdcSDRMainDiv3').hide ();
    		$('#IdcSDRMainDiv2').hide ();
    		$('#IdcSDRMainDiv1').show ();
    	}

    	$('#IdcPDDosimetryDiv').data ( 'mode', 'visit' );

		let stu_id 			= -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			stu_id 			= $('#IdcPatientDosimetryDT').DataTable().row( rowIdx ).data().stu_id;
			let date		= $('#IdcPatientDosimetryDT').DataTable().row( rowIdx ).data().date;
			let description	= $('#IdcPatientDosimetryDT').DataTable().row( rowIdx ).data().description;
			let an 			= $('#IdcPatientDosimetryDT').DataTable().row( rowIdx ).data().accessionnumber;

			

			rep_mode="patient";
			

			$('#IdcPDPatientCaption').data ( 'stu_id', stu_id.split('_')[1] );

			$('#IdcSDRCaption').html ( Translate('Study') + " : " + an + " - " + date + " - " + description );
			$('#IdcPDVisitReportSelect').show ();

			$('#IdcPDPatientReportSelect').val (-1);

			if ( mode == 'patient' )
			{
				getStuInfos ( stu_id );
				$('#IdcPDDosimetryDiv').data ( 'type', 'internal' );
			}
			else
			{
				if ( type == 'internal' )
				{
					getStuInfos ( stu_id );
				}
				else
				{
					console.log ( " stu_id : " + stu_id );
					// Refresh jasper report
					PDDisplayJasperReport ( PDCurrentJRXMLFolder, PDCurrentJRXMLFileName, PDCurrentJRXMLParamName, stu_id.split('_')[1] );
				}
			}
		}
	}




	function PDPatientListDTGetData ( d )
	{
		console.log ( "PDPatientListDTGetData..." );
		d.value 			= $('#IdcPDPatientListValue').val ();

		if ( d.value != '' )
			IdcPDPatientListDT.SetRowToSelect('');

		let stu_id = document.getElementById ( 'IdcDivPatientDosimetry' ).dataset.stu_id;

		console.log ( "stu_id : " + stu_id );
		d.stuid = stu_id;

		return $.extend( {}, d );
	}
		
		
	function PDPatientListDTSelectChanged ( rowsIdx )
	{
		if ( $('#IdcPDPatientDiv').is (":visible") == false )
			return;

		console.log ( "PDPatientListDTSelectChanged ("+rowsIdx+")..." );
		let pat_id		= -1;
		let patientName = "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			pat_id		= $('#IdcPDPatientListDT').DataTable().row( rowIdx ).data().pat_id;
			patientName	= $('#IdcPDPatientListDT').DataTable().row( rowIdx ).data().name;

			PDCurrentPatientName = patientName;

			$('#IdcPDPatientDiv').hide ();
			$('#IdcPDMask').hide ();
			$('#IdcPDDosimetryDiv').show ();

			console.log ( "Set patient name : " + patientName );
			$('#IdcPDPatientCaption').text ( patientName );

			$('#IdcPDPatientCaption').data ( 'id', pat_id );

			$('#IdcPDPatientReportSelect').prop ( 'disabled', false );

			IdcPatientDosimetryDT.Refresh ();
		}
	}



	function OnPatientDosimetrySearch ()
	{
		console.log ( "OnPatientDosimetrySearch..." );

		$('#IdcPDMask').show ();

		$('#IdcPDPatientDiv').show ();
		$('#IdcPDDosimetryDiv').hide ();

		WaitingStart ( Translate ('Request in progress. Please wait.') );
		IdcPDPatientListDT.RealRefresh ();
	}

	function OnPDMaskClicked()
	{
		$('#IdcPDMask').hide ();
		$('#IdcPDPatientDiv').hide ();
		$('#IdcPDDosimetryDiv').show ();
	}

	function PDPatientListDTDrawCallback ( dtIdent )
	{
		WaitingStop ();
	}

	function PDPatientListDTErrorCallback ( dtIdent )
	{
		WaitingStop ();

		MsgWarning ( "Une erreur s'est produite.");
	}


	function OnPDPatientNameClicked ()
	{
		console.log ( "OnPDPatientNameClicked..." );
	}

	function OnPDPatientIDClicked ()
	{
		console.log ( "OnPDPatientIDClicked..." );
	}

	function OnPDAccessionNumberClicked ()
	{
		console.log ( "OnPDAccessionNumberClicked..." );
	}





	function show_patientdosimetrybystuID ( stu_id )
    {
    	console.log ( "show_patientdosimetrybystuID..." );
    	console.log ( " stu_id : ", stu_id );

    	document.getElementById ( 'IdcDivPatientDosimetry' ).dataset.stu_id = stu_id;
    	$('#IdcPDPatientListValue').val ( '' );

    	SelectPage ( 'VIEW_PATIENT_DOSIMETRY' );
    	IdcPDPatientListDT.SetRowToSelect('first_row');

    	$('#IdcPDSearchButton').click ();
    }


    function PDRefreshPatientReportsList ()
	{
		$('#IdcPDPatientReportSelect').empty ();

		$('#IdcPDPatientReportSelect').append ( 
			'<option value="-1"></option>'
			);

		$('#IdcPDPatientReportSelect').append ( 
			'<optgroup label="Internal"><option value="0" data-langkey="Complete dosimetric history"><option value="1" data-langkey="Dosimetric patient summary"></option></optgroup>'
			);
		


		$.post (
			"./SubFW/html/JasperParser.php",
			{
				folder: 		"PatientDosimetry/Patient"
			},
			function ( data ) 
			{
				const reports = data.reports || [];

				const optgroup = $('<optgroup>', { label: 'Autres rapports' });

				reports.forEach ( report => { 

					let fileNameWithoutExt = report.file.replace(/\.jrxml$/i, '');

					if ( fileNameWithoutExt.toLowerCase().includes('sub') == false )
					{
						const option = $('<option>', {
                			value: report.file,
                			text: fileNameWithoutExt
            			}).data('params', report.parameters);

            			optgroup.append(option);
					}


				})

				$('#IdcPDPatientReportSelect').append(optgroup);
			},
			'json'
		);
	}

	function PDRefreshVisitReportsList ()
	{
		$('#IdcPDVisitReportSelect').empty ();

		$('#IdcPDVisitReportSelect').append ( 
			'<optgroup label="Internal"><option value="0" data-langkey="Visit dosimetric report"></option></optgroup>'
			);
		


		$.post (
			"./SubFW/html/JasperParser.php",
			{
				folder: 		"PatientDosimetry/Visit"
			},
			function ( data ) 
			{
				const reports = data.reports || [];

				const optgroup = $('<optgroup>', { label: 'Autres rapports' });

				reports.forEach ( report => { 

					let fileNameWithoutExt = report.file.replace(/\.jrxml$/i, '');

					if ( fileNameWithoutExt.toLowerCase().includes('sub') == false )
					{
						const option = $('<option>', {
                			value: report.file,
                			text: fileNameWithoutExt
            			}).data('params', report.parameters);

            			optgroup.append(option);
					}


				})

				$('#IdcPDVisitReportSelect').append(optgroup);
			},
			'json'
		);
	}




	function PDPatientReportChanged ()
	{
		console.log ( "PDPatientReportChanged..." );

    	const selectedOption = $('#IdcPDPatientReportSelect').find('option:selected');

    	console.log ( "selectedOption : " + selectedOption.val () );

    	switch ( selectedOption.val () )
    	{
    		case '-1':
    			console.log ( "None");
    			break;
    		
    		case '0':
    			$('#IdcPDDosimetryDiv').data ( 'mode', 'patient' );
    			$('#IdcPDDosimetryDiv').data ( 'type', 'internal' );
    			// $('#IdcPDJasperDiv').hide ();
    			$('#IdcTestDetach').show ();
    			detailedreport(true);
    			$('#IdcSDRMainDiv2').hide ();
    			$('#IdcSDRMainDiv3').hide ();
    			$('#IdcSDRMainDiv1').show ();
    			$('#IdcSDRCaption').html ( PDCurrentPatientName );
    			$('#IdcPDVisitReportSelect').hide ();

    		break;

    		case '1':
    			{
    				$('#IdcPDDosimetryDiv').data ( 'mode', 'patient' );
    				$('#IdcPDDosimetryDiv').data ( 'type', 'internal' );
    				
    				// $('#IdcPDJasperDiv').hide ();
    				$('#IdcTestDetach').show ();
    				
    				$('#IdcSDRMainDiv1').hide ();
    				$('#IdcSDRMainDiv3').hide ();
    				$('#IdcSDRMainDiv2').show ();
    			
    				var page="SubFW/html/briefdosereport.php";
    			
    				let pat_id = $('#IdcPDPatientCaption').data ( 'id');

    				page += "?pat_id="+pat_id;

    				/*
    				let stu_id = -1;
					page += "?pat_id="+pat_id;
					if(pat_id==-1)
						page+="&stu_id="+stu_id;
					*/
    				RenderPage ( page, "IdcSDRMainDiv2" );
    			
    				$('#IdcSDRCaption').html ( PDCurrentPatientName );
    				$('#IdcPDVisitReportSelect').hide ();
    			}
    		break;
    		
    		default:
    			$('#IdcPDDosimetryDiv').data ( 'mode', 'patient' );
    			$('#IdcPDDosimetryDiv').data ( 'type', 'jasper' );

    			$('#IdcSDRMainDiv1').hide ();
    			$('#IdcSDRMainDiv2').hide ();
    			$('#IdcSDRMainDiv3').show ();

    			$('#IdcSDRCaption').html ( PDCurrentPatientName );
    			$('#IdcPDVisitReportSelect').hide ();

    			console.log ( " params : ", selectedOption.data ('params') );

    			let params = selectedOption.data ('params');
    			let firstParam = params [0].name;
    			
    			let pat_id = $('#IdcPDPatientCaption').data ( 'id' );
    			
				PDDisplayJasperReport ("PatientDosimetry/Patient/", selectedOption.val (), firstParam, pat_id );
    			break;
    	}
	}


	function PDVisitReportChanged ()
	{
		console.log ( "PDVisitReportChanged..." );

    	const selectedOption = $('#IdcPDVisitReportSelect').find('option:selected');

    	console.log ( "selectedOption : " + selectedOption.val () );

    	switch ( selectedOption.val () )
    	{
    		case '0':
    			console.log ( "Internal");
    			$('#IdcPDDosimetryDiv').data ( 'mode', 'visit' );
    			$('#IdcPDDosimetryDiv').data ( 'type', 'internal' );

    			// $('#IdcPDJasperDiv').hide ();
    			$('#IdcTestDetach').show ();
    			detailedreport(true);
    			$('#IdcSDRMainDiv2').hide ();
    			$('#IdcSDRMainDiv3').hide ();
    			$('#IdcSDRMainDiv1').show ();

    			// $('#IdcSDRCaption').html ( $('#IdcSDRCaption').text() );
    			// $('#IdcPDVisitReportSelect').hide ();

    		break;

    		default:
    			$('#IdcPDDosimetryDiv').data ( 'mode', 'visit' );
    			$('#IdcPDDosimetryDiv').data ( 'type', 'jasper' );

				// $('#IdcTestDetach').hide ();
    			// $('#IdcPDJasperDiv').show ();

    			$('#IdcSDRMainDiv1').hide ();
    			$('#IdcSDRMainDiv2').hide ();
    			$('#IdcSDRMainDiv3').show ();
    			

    			// $('#IdcPDJasperReportCaption').html ( $('#IdcSDRCaption').text() );
    			

    			console.log ( " params : ", selectedOption.data ('params') );

    			let params = selectedOption.data ('params');
    			let firstParam = params [0].name;
    			
    			let stu_id = $('#IdcPDPatientCaption').data ( 'stu_id' );
				PDDisplayJasperReport ( "PatientDosimetry/Visit/", selectedOption.val (), firstParam, stu_id );
    			break;
    	}
	}

	function PDDisplayJasperReport ( folder, jrxmlFileName, paramName, id )
	{
		console.log ( "jrxmlFileName : " + jrxmlFileName );

		PDCurrentJRXMLFolder  	= folder;
		PDCurrentJRXMLFileName  = jrxmlFileName;
		PDCurrentJRXMLParamName	= paramName;
		PDCurrentJRXMLID 		= id;

		console.log ( "paramName : " + paramName );
		console.log ( "id : " + id );

    	WaitingStart();

    	const jasperTemplatesFolder = folder;
    	const jrxmlFile 			= jrxmlFileName;
    	const pdfMode 				= $('#IdcPDJasperPDF').is(':checked');
    	// const pdfMode 				= false;

    	console.log ( " pdfMode : " + pdfMode );

    	const paramsDiv 	= document.getElementById('IdcStatJasperParameters');
    	const inputs 		= paramsDiv.querySelectorAll('input, select, textarea');

    	const parameters = {};

    	parameters[paramName] = id;


    	const bodyParams = new URLSearchParams();
    	bodyParams.append ( 'jrxml', 	jasperTemplatesFolder + jrxmlFile);
    	bodyParams.append ( 'output', 	'stdout');
    	bodyParams.append ( 'format', 	pdfMode ? 'pdf' : 'html');

    	for ( const [key, value] of Object.entries(parameters) ) 
    	{
    		console.log ( " key : " + key + " / " + value );
        	bodyParams.append(key, value);
    	}

    	fetch('./SubFW/html/JasperConverter.php', {
        	method: 'POST',
        	body: bodyParams
    	})
    	.then(response => {
        	if (!response.ok) throw new Error("Erreur HTTP");
        		return pdfMode ? response.blob() : response.text();
    	})
    	.then(data => {
        	WaitingStop();

        	if (pdfMode) 
        	{
    			const pdfUrl = URL.createObjectURL(data);

    			const iframe = document.createElement('iframe');

    			iframe.src 			= eoDACS.ServerAddress + eoDACS.ServerFolder + "/Common/PDFViewer.php?color_class=ximeo_bg_gray_4";
    			iframe.className 	= 'w-100 h-100';
    			iframe.style.flex 	= '1';
    			iframe.style.border = 'none';

    			const container = document.getElementById('IdcPDJasperContainer');
    			
    			container.innerHTML = ''; // Nettoyer le conteneur
    			container.appendChild(iframe);

    			iframe.onload = () => {
        			iframe.contentWindow.postMessage({
            			type: 'load-pdf-blob',
            			blobUrl: pdfUrl
        			}, '*');
    			};
			}
        	else 
        	{
            	$('#IdcPDJasperContainer').html ( data );
        	}
    	})
    	.catch ( error => {
        	WaitingStop();
        	console.error("Erreur lors de la récupération :", error);
    	});
	} 





	function PDJasperPDFClicked () 
	{
		PDDisplayJasperReport ( PDCurrentJRXMLFolder, PDCurrentJRXMLFileName, PDCurrentJRXMLParamName, PDCurrentJRXMLID );
	}