	function InitSettingsPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsPageInitialized', true );

		sessionStorage.setItem ( 'SettingsAlertPageInitialized', 				false );
		sessionStorage.setItem ( 'SettingsUserAccessPageInitialized', 			false );
		sessionStorage.setItem ( 'SettingsIntegrationErrorsPageInitialized', 	false );
		sessionStorage.setItem ( 'SettingsStudiesConfigurationPageInitialized', false );
		sessionStorage.setItem ( 'SettingsSeriesConfigurationPageInitialized', 	false );
		sessionStorage.setItem ( 'SettingsAFCNExportPageInitialized', 			false )	;
		sessionStorage.setItem ( 'SettingsInstitutionPageInitialized', 			false );
		sessionStorage.setItem ( 'SettingsSOPPageInitialized', 					false );
		sessionStorage.setItem ( 'SettingsDICOMPageInitialized', 				false );
			
		$(document).ready(function () 
		{		
			SettingsLeftTabs = new C_Tab ();

			SettingsLeftTabs.Ident 		= "IdcSettingsLeftTabs";
			SettingsLeftTabs.Container 	= "IdcSettingsTabsContainer";
		
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_ALERT', 					"Alerts", 					"fa fa-fw fa-exclamation-triangle fs-4", 		OnSettingsAlert					);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_USER_ACCESS', 				"User access", 				"fa fa-fw fa-users-cog fs-4", 					OnSettingsUserAccess			);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_INTEGRATION_ERRORS', 		"Integration status", 		"fa fa-fw fa-chain-broken fs-4", 				OnSettingsIntegrationErrors		);
			SettingsLeftTabs.AddSeparator ( 40 );
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_STUDIES_CONFIGURATION',	"Studies configuration", 	"fa fa-fw fa-heartbeat fs-4", 					OnSettingsStudiesConfiguration	);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_SERIES_CONFIGURATION',		"Series configuration", 	"fa fa-fw fa-heartbeat fs-4", 					OnSettingsSeriesConfiguration	);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_STATISTICAL_TEMPLATES',	"Statistical templates", 	"fa fa-fw fa-bar-chart fs-4", 					OnSettingsStatisticalTemplates	);
			// SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_EFFECTIVE_DOSE',			"Effective dose", 			"fa fa-fw fa-radiation fs-4", 					OnSettingsEffectiveDose			);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_AFCN_EXPORT',				"Export AFCN",	 			"fa fa-fw fa-file-export fs-4",					OnSettingsAFCNExport			);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_INSTITUTION',				"Institution",	 			"fa fa-fw fa-hospital fs-4",					OnSettingsInstitution			);
			SettingsLeftTabs.AddSeparator ( 40 );
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_DICOM',					"DICOM setup",	 			"fa fa-fw fa-x-ray fs-4",						OnSettingsDICOM					);
			SettingsLeftTabs.AddTab ( 'VIEW_SETTINGS_SOP',						"SOP setup",	 			"fa fa-fw fa-procedures fs-4",					OnSettingsSOP					);
			
			SettingsLeftTabs.DisableAlert ();

			SettingsLeftTabs.Create ();

			SettingsLeftTabs.SelectTab ( 'VIEW_SETTINGS_ALERT' );


			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SettingsHideAllPanels ()
	{
		$('#IdcDivSettingsAlert' ).hide ();
		$('#IdcDivSettingsUserAccess' ).hide ();
		$('#IdcDivSettingsIntegrationStatus' ).hide ();
		$('#IdcDivSettingsStudiesConfiguration' ).hide ();
		$('#IdcDivSettingsSeriesConfiguration' ).hide ();
		$('#IdcDivSettingsStatisticalTemplates' ).hide ();
		$('#IdcDivSettingsEffectiveDose' ).hide ();
		$('#IdcDivSettingsAFCNExport' ).hide ();
		$('#IdcDivSettingsInstitution' ).hide ();
		$('#IdcDivSettingsDICOM' ).hide ();
		$('#IdcDivSettingsSOP' ).hide ();
	}

	function OnSettingsAlert ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsAlert' ).show ();
		InitSettingsAlertPage ();
	}

	function OnSettingsUserAccess ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsUserAccess' ).show ();
		InitSettingsUserAccessPage ();
	}

	function OnSettingsIntegrationErrors ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsIntegrationStatus' ).show ();
		InitSettingsIntegrationStatusPage ();
	}

	function OnSettingsStudiesConfiguration ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsStudiesConfiguration' ).show ();
		InitSettingsStudiesConfigurationPage ();
	}

	function OnSettingsSeriesConfiguration ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsSeriesConfiguration' ).show ();
		InitSettingsSeriesConfigurationPage ();
	}


	function OnSettingsStatisticalTemplates ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsStatisticalTemplates' ).show ();
		InitSettingsStatisticalTemplatesPage ();
	}

	function OnSettingsEffectiveDose ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsEffectiveDose' ).show ();
		InitSettingsEffectiveDosePage ();
	}

	function OnSettingsAFCNExport ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsAFCNExport' ).show ();
		InitSettingsAFCNExportPage ();
	}

	function OnSettingsInstitution ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsInstitution' ).show ();
		InitSettingsInstitutionPage ();
	}

	function OnSettingsDICOM ()
	{
		SettingsHideAllPanels ();

		RenderPage ( "SubFW/html/settings/dicom_config.php", "IdcDivSettingsDICOMPanel" );

		$('#IdcDivSettingsDICOM' ).show ();
		InitSettingsDICOMPage ();
	}

	function OnSettingsSOP ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsSOP' ).show ();
		InitSettingsSOPPage ();
	}