	
	SExportExamsDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSExportExamsDT.Properties (); }
		}
	];

	SAELinkedStudiesDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSAELinkedStudiesDT.Properties (); }
		}
	];

	SAENotLinkedStudiesDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSAENotLinkedStudiesDT.Properties (); }
		}
	];

	SAELinkedSeriesDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSAELinkedSeriesDT.Properties (); }
		}
	];

	SAENotLinkedSeriesDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSAENotLinkedSeriesDT.Properties (); }
		}
	];

	SAEDRLDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSAEDRLDT.Properties (); }
		}
	];

	

	function SAEStudyResData ( newrow, rstud_id, mstud_id )
	{
		this.newrow  		= newrow;
		this.rstud_id		= rstud_id;
		this.mstud_id 		= mstud_id;
	}

	function SAESerieResData ( newrow, rserd_id, mserd_id )
	{
		this.newrow  		= newrow;
		this.rserd_id		= rserd_id;
		this.mserd_id 		= mserd_id;
	}

	let SAEStudyToLink 			= Array ();
	let SAEStudyToUnLink 		= Array ();
	let SAEStudyCurrentRowData	= null;

	let SAESerieToLink 			= Array ();
	let SAESerieToUnLink 		= Array ();
	let SAESerieCurrentRowData	= null;

	function InitSettingsAFCNExportPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsAFCNExportPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsAFCNExportPageInitialized', true );

		IdcSExportExamsDT = new C_DataTable ();
		IdcSExportExamsDT.DataSrcType		= 0;
		IdcSExportExamsDT.Ident 			= 'IdcSExportExamsDT';
		IdcSExportExamsDT.Container 		= 'IdcSExportExamsDTContainer';
		IdcSExportExamsDT.CfgParameterName 	= 'SettingsExportExamsDTProperties';
		IdcSExportExamsDT.DataSrc 			= 'SubFW/database/settings/afcn/GetAFCNExamList.php';
		IdcSExportExamsDT.DataFct			= SExportExamsDTGetData;
		IdcSExportExamsDT.SetColReorder 	( true );
		IdcSExportExamsDT.OnSelectChanged	( SettingsExportExamsDTSelectChanged );

		IdcSExportExamsDT.AddColumn ( 'desc_id',					'desc_id',	 		0, false,  0,  50,   false, '', 				'' );
		IdcSExportExamsDT.AddColumn ( Translate('Exam'),			'description_fr',	1, true,   1, '10%', true,  '', 				'' );

		IdcSExportExamsDT.ColumnFilter ( 'description_fr', 	'text' );
		
		IdcSExportExamsDT.LoadUserCfg ( G_USE_ID );


		IdcSAELinkedStudiesDT = new C_DataTable ();
		IdcSAELinkedStudiesDT.DataSrcType		= 0;
		IdcSAELinkedStudiesDT.Ident 			= 'IdcSAELinkedStudiesDT';
		IdcSAELinkedStudiesDT.Container 		= 'IdcSAELinkedStudiesDTContainer';
		IdcSAELinkedStudiesDT.CfgParameterName 	= 'SettingsExportStudiesLinkedDTProperties';
		IdcSAELinkedStudiesDT.DataSrc 			= 'SubFW/database/settings/afcn/study_linked.php';
		IdcSAELinkedStudiesDT.DataFct			= SExportStudiesLinkedDTGetData;
		IdcSAELinkedStudiesDT.RowCallbackFct 	= SAELinkedStudiesRowCB;
		IdcSAELinkedStudiesDT.SetColReorder 	( true );
		// IdcSAELinkedStudiesDT.OnSelectChanged	( SettingsExportStudiesLinkedDTSelectChanged );

		IdcSAELinkedStudiesDT.AddColumn ( 'rstud_id',						'rstud_id',	 		0, false,   0,  50,   false, '', 		'' );
		IdcSAELinkedStudiesDT.AddColumn ( 'mstud_id',						'mstud_id',	 		0, false,   1,  50,   false, '', 		'' );
		IdcSAELinkedStudiesDT.AddColumn ( '',								'',					0, true,   2,  40,   false, '', 		'', SAFCNStudyShortcutDelete );
		IdcSAELinkedStudiesDT.AddColumn ( 'newRow',							'newrow', 			0, false,   3,  50,   false,  	'', '' );
		IdcSAELinkedStudiesDT.AddColumn ( Translate('Type'),				'modalitytitle',	1, true,   4, '10%', true,  'text-center', 		'' );
		IdcSAELinkedStudiesDT.AddColumn ( Translate('AFCN'),				'description_fr',	1, true,   5, '10%', true,  '', 		'' );
		IdcSAELinkedStudiesDT.AddColumn ( Translate('Master study'),		'mdescription',		1, true,   6, '10%', true,  '', 		'' );
		IdcSAELinkedStudiesDT.AddColumn ( Translate('Description'),			'rdescription',		1, true,   7, '10%', true,  '', 		'' );

		const typeList = [
			{ id: '',	label: Translate('All')},
			{ id: 'CR',	label: 'CR'},
			{ id: 'CT',	label: 'CT'},
			{ id: 'MG',	label: 'MG'},
			{ id: 'NM',	label: 'NM'},
			{ id: 'XA',	label: 'XA'},
			{ id: 'RX',	label: 'RX'}
		];

		IdcSAELinkedStudiesDT.ColumnFilter ( 'modalitytitle',	'combo', typeList  );
		IdcSAELinkedStudiesDT.ColumnFilter ( 'description_fr', 	'text' );
		
		IdcSAELinkedStudiesDT.LoadUserCfg ( G_USE_ID );


		IdcSAENotLinkedStudiesDT = new C_DataTable ();
		IdcSAENotLinkedStudiesDT.DataSrcType		= 0;
		IdcSAENotLinkedStudiesDT.Ident 				= 'IdcSAENotLinkedStudiesDT';
		IdcSAENotLinkedStudiesDT.Container 			= 'IdcSAENotLinkedStudiesDTContainer';
		IdcSAENotLinkedStudiesDT.CfgParameterName 	= 'SettingsExportStudiesLinkedDTProperties';
		IdcSAENotLinkedStudiesDT.DataSrc 			= 'SubFW/database/settings/afcn/study_linked.php';
		IdcSAENotLinkedStudiesDT.DataFct			= SExportStudiesNotLinkedDTGetData;
		IdcSAENotLinkedStudiesDT.RowCallbackFct 	= SAENotLinkedStudiesRowCB;
		IdcSAENotLinkedStudiesDT.SetColReorder 		( true );
		// IdcSAENotLinkedStudiesDT.OnSelectChanged	( SettingsExportStudiesNotLinkedDTSelectChanged );

		IdcSAENotLinkedStudiesDT.AddColumn ( 'rstud_id',						'rstud_id',	 		0, false,   0,  50,   false, '', 	'' );
		IdcSAENotLinkedStudiesDT.AddColumn ( 'mstud_id',						'mstud_id',	 		0, false,   1,  50,   false, '', 	'' );
		IdcSAENotLinkedStudiesDT.AddColumn ( '',								'',					0, true,   2,  40,   false, '', 	'', SAFCNStudyShortcutAdd );
		IdcSAENotLinkedStudiesDT.AddColumn ( 'newRow',							'newrow', 			0, false,   3,  50,   false,  	'', '' );
		IdcSAENotLinkedStudiesDT.AddColumn ( Translate('Type'),					'modalitytitle',	1, true,   4, '10%', true,  'text-center', 	'' );
		IdcSAENotLinkedStudiesDT.AddColumn ( Translate('AFCN'),					'description_fr',	1, true,   5, '10%', true,  '', 	'' );
		IdcSAENotLinkedStudiesDT.AddColumn ( Translate('Master study'),			'mdescription',		1, true,   6, '10%', true,  '', 	'' );
		IdcSAENotLinkedStudiesDT.AddColumn ( Translate('Description'),	'rdescription',		1, true,   7, '10%', true,  '', 	'' );

		IdcSAENotLinkedStudiesDT.ColumnFilter ( 'modalitytitle',	'combo', typeList  );
		IdcSAENotLinkedStudiesDT.ColumnFilter ( 'description_fr',	'text' );
			
		IdcSAENotLinkedStudiesDT.LoadUserCfg ( G_USE_ID );



		// Series linked
		IdcSAELinkedSeriesDT = new C_DataTable ();
		IdcSAELinkedSeriesDT.DataSrcType		= 0;
		IdcSAELinkedSeriesDT.Ident 				= 'IdcSAELinkedSeriesDT';
		IdcSAELinkedSeriesDT.Container 			= 'IdcSAELinkedSeriesDTContainer';
		IdcSAELinkedSeriesDT.CfgParameterName 	= 'SettingsExportSeriesLinkedDTProperties';
		IdcSAELinkedSeriesDT.DataSrc 			= 'SubFW/database/settings/afcn/serie_linked.php';
		IdcSAELinkedSeriesDT.DataFct			= SExportSeriesLinkedDTGetData;
		IdcSAELinkedSeriesDT.RowCallbackFct 	= SAELinkedSeriesRowCB;
		IdcSAELinkedSeriesDT.SetColReorder 	( true );
		
		IdcSAELinkedSeriesDT.AddColumn ( 'rserd_id',					'rserd_id',	 		0, false,   0,  50,   false, '', 		'' );
		IdcSAELinkedSeriesDT.AddColumn ( 'mserd_id',					'mserd_id',	 		0, false,   1,  50,   false, '', 		'' );
		IdcSAELinkedSeriesDT.AddColumn ( '',							'',					0, true,   2,  40,   false, '', 		'', SAFCNSerieShortcutDelete );
		IdcSAELinkedSeriesDT.AddColumn ( 'newRow',						'newrow', 			0, false,   3,  50,   false,  	'', '' );
		IdcSAELinkedSeriesDT.AddColumn ( Translate('Type'),				'modalitytitle',	1, true,   4, '10%', true,  'text-center', 		'' );
		IdcSAELinkedSeriesDT.AddColumn ( Translate('AFCN'),				'description_fr',	1, true,   5, '10%', true,  '', 		'' );
		IdcSAELinkedSeriesDT.AddColumn ( Translate('Master study'),		'mdescription',		1, true,   6, '10%', true,  '', 		'' );
		IdcSAELinkedSeriesDT.AddColumn ( Translate('Description'),		'rdescription',		1, true,   7, '10%', true,  '', 		'' );

		IdcSAELinkedSeriesDT.ColumnFilter ( 'modalitytitle',	'combo', typeList  );
		IdcSAELinkedSeriesDT.ColumnFilter ( 'description_fr', 	'text' );
		IdcSAELinkedSeriesDT.ColumnFilter ( 'rdescription', 		'text' );
		
		IdcSAELinkedSeriesDT.LoadUserCfg ( G_USE_ID );


		// Series not linked
		IdcSAENotLinkedSeriesDT = new C_DataTable ();
		IdcSAENotLinkedSeriesDT.DataSrcType		= 0;
		IdcSAENotLinkedSeriesDT.Ident 				= 'IdcSAENotLinkedSeriesDT';
		IdcSAENotLinkedSeriesDT.Container 			= 'IdcSAENotLinkedSeriesDTContainer';
		IdcSAENotLinkedSeriesDT.CfgParameterName 	= 'SettingsExportSeriesNotLinkedDTProperties';
		IdcSAENotLinkedSeriesDT.DataSrc 			= 'SubFW/database/settings/afcn/serie_linked.php';
		IdcSAENotLinkedSeriesDT.DataFct				= SExportSeriesNotLinkedDTGetData;
		IdcSAENotLinkedSeriesDT.RowCallbackFct 		= SAENotLinkedSeriesRowCB;
		IdcSAENotLinkedSeriesDT.SetColReorder 	( true );
		
		IdcSAENotLinkedSeriesDT.AddColumn ( 'rserd_id',						'rserd_id',	 		0, false,   0,  50,   false, '', 		'' );
		IdcSAENotLinkedSeriesDT.AddColumn ( 'mserd_id',						'mserd_id',	 		0, false,   1,  50,   false, '', 		'' );
		IdcSAENotLinkedSeriesDT.AddColumn ( '',								'',					0, true,   2,  40,   false, '', 		'', SAFCNSerieShortcutAdd );
		IdcSAENotLinkedSeriesDT.AddColumn ( 'newRow',						'newrow', 			0, false,   3,  50,   false,  	'', '' );
		IdcSAENotLinkedSeriesDT.AddColumn ( Translate('Type'),				'modalitytitle',	1, true,   4, '10%', true,  'text-center', 		'' );
		IdcSAENotLinkedSeriesDT.AddColumn ( Translate('AFCN'),				'description_fr',	1, true,   5, '10%', true,  '', 		'' );
		IdcSAENotLinkedSeriesDT.AddColumn ( Translate('Master study'),		'mdescription',		1, true,   6, '10%', true,  '', 		'' );
		IdcSAENotLinkedSeriesDT.AddColumn ( Translate('Description'),		'rdescription',		1, true,   7, '10%', true,  '', 		'' );

		IdcSAENotLinkedSeriesDT.ColumnFilter ( 'modalitytitle',		'combo', typeList  );
		IdcSAENotLinkedSeriesDT.ColumnFilter ( 'description_fr', 	'text' );
		IdcSAENotLinkedSeriesDT.ColumnFilter ( 'rdescription', 		'text' );
		
		IdcSAENotLinkedSeriesDT.LoadUserCfg ( G_USE_ID );



		// DRL
		IdcSAEDRLDT = new C_DataTable ();
		IdcSAEDRLDT.DataSrcType		= 0;
		IdcSAEDRLDT.Ident 				= 'IdcSAEDRLDT';
		IdcSAEDRLDT.Container 			= 'IdcSAEDRLDTContainer';
		IdcSAEDRLDT.CfgParameterName 	= 'SettingsExportDRLDTProperties';
		IdcSAEDRLDT.DataSrc 			= 'SubFW/database/settings/afcn/GetStudyAFCNLinkedNRD.php';
		IdcSAEDRLDT.DataFct				= SExportDRLDTGetData;
		// IdcSAEDRLDT.RowCallbackFct 		= SAENotLinkedSeriesRowCB;
		IdcSAEDRLDT.SetColReorder 	( true );
		
		IdcSAEDRLDT.AddColumn ( 'nrd_id',						'nrd_id',	 		0, false,   0,  50,   false, '', 		'' );
		IdcSAEDRLDT.AddColumn ( Translate('Name'),				'alertname',		1, true,   	1, '10%', true,  '', 		'' );
		IdcSAEDRLDT.AddColumn ( Translate('Type'),				'type',				1, true,   	2, '10%', true,  'text-center', 		'' );
		IdcSAEDRLDT.AddColumn ( Translate('Nb acqui.'),			'nacquisition',		1, true,   	3, '10%', true,  'text-end', 		'' );
		IdcSAEDRLDT.AddColumn ( Translate('Age (year)'),		'age',				1, true,   	4, '10%', true,  'text-center', 		'' );
		IdcSAEDRLDT.AddColumn ( Translate('Value type'),		'valuetype',				1, true,   	4, '10%', true,  'text-center', 		'' );
		IdcSAEDRLDT.AddColumn ( Translate('Value'),				'value',				1, true,   	4, '10%', true,  'text-center', 		'' );

		IdcSAEDRLDT.LoadUserCfg ( G_USE_ID );
			
		$(document).ready(function () 
		{		
			IdcSAESplitter1_2 			= new C_Splitter ( "IdcSAESplitter1_2" 			);
			IdcSAESplitter3_4 			= new C_Splitter ( "IdcSAESplitter3_4" 			);
			IdcSAESplitter5_6 			= new C_Splitter ( "IdcSAESplitter5_6" 			);

			IdcSExportExamsDT.Create ();
			context.attach ( '#IdcSExportExamsDT', SExportExamsDTListMenu );
			IdcSExportExamsDT.SetRowToSelect('first_row');

			IdcSAELinkedStudiesDT.Create ();
			context.attach ( '#IdcSAELinkedStudiesDT', SAELinkedStudiesDTListMenu );

			IdcSAENotLinkedStudiesDT.Create ();
			context.attach ( '#IdcSAENotLinkedStudiesDT', SAENotLinkedStudiesDTListMenu );

			IdcSAELinkedSeriesDT.Create ();
			context.attach ( '#IdcSAELinkedSeriesDT', SAELinkedSeriesDTListMenu );

			IdcSAENotLinkedSeriesDT.Create ();
			context.attach ( '#IdcSAENotLinkedSeriesDT', SAENotLinkedSeriesDTListMenu );

			IdcSAEDRLDT.Create ();
			context.attach ( '#IdcSAEDRLDT', SAEDRLDTListMenu );

			$('#' + IdcSAELinkedStudiesDT.Ident +' tbody').on('click', '.SAFCNStudyDeleteShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnAFCNStudyDeleteShortcut ( tr );
			} );

			$('#' + IdcSAENotLinkedStudiesDT.Ident +' tbody').on('click', '.SAFCNStudyAddShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnAFCNStudyAddShortcut ( tr );
			} );

			$('#' + IdcSAELinkedSeriesDT.Ident +' tbody').on('click', '.SAFCNSerieDeleteShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnAFCNSerieDeleteShortcut ( tr );
			} );

			$('#' + IdcSAENotLinkedSeriesDT.Ident +' tbody').on('click', '.SAFCNSerieAddShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnAFCNSerieAddShortcut ( tr );
			} );

			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}
	
	function OnAFCNStudyAddShortcut ( tr )
	{
		SAEStudyCurrentRowData = $('#'+IdcSAENotLinkedStudiesDT.Ident).DataTable ().row ( tr ).data ();

		if ( SAEStudyCurrentRowData.mstud_id != -1 )
		{
			$('#IdcSAEStudyAddSelectModal').modal('show');
		}
		else
			AFCNStudyAddElement ();			
	}

	function OnAFCNStudyDeleteShortcut ( tr )
	{
		SAEStudyCurrentRowData = $('#'+IdcSAELinkedStudiesDT.Ident).DataTable ().row ( tr ).data ();

		if ( SAEStudyCurrentRowData.mstud_id != -1 )
		{
			$('#IdcSAEStudyDeleteSelectModal').modal('show');
		}
		else
			AFCNStudyDeleteElement ();			
	}

	function AFCNStudyAddElement ( group )
	{
		if ( group == true )
		{
			if ( SAEStudyCurrentRowData.newrow == 1 )
			{
				SAEStudyToUnLink = SAEStudyToUnLink.filter(elem => elem.mstud_id === SAEStudyCurrentRowData.mstud_id );
			}
			else
			{
				let nbRows = IdcSAENotLinkedStudiesDT.GetRowNumber ();
				for ( let i=0; i<nbRows; i++ )
				{
					let rowData = IdcSAENotLinkedStudiesDT.GetRowData ( i );	

					if ( rowData.mstud_id == SAEStudyCurrentRowData.mstud_id )
					{
						SAEStudyToLink.push ( new SAEStudyResData ( 1, rowData.rstud_id, rowData.mstud_id ) );
					}
				}
			}
		}
		else 	// Study only
		{
			if ( SAEStudyCurrentRowData.newrow == 1 )
			{
				let idx = -1;
				for ( let i=0; i<SAEStudyToUnLink.length;i++ )
				{
					if ( SAEStudyToUnLink [i].rstud_id == SAEStudyCurrentRowData.rstud_id )
					{
						idx = i;
						break;
					}
				}
				if ( idx != -1)
				{
					SAEStudyToUnLink.splice ( idx, 1 );
				}
			}
			else
			{
				SAEStudyToLink.push ( new SAEStudyResData ( 1, SAEStudyCurrentRowData.rstud_id, SAEStudyCurrentRowData.mstud_id ) );
			}
		}

		IdcSAELinkedStudiesDT.Refresh ();
		IdcSAENotLinkedStudiesDT.Refresh ();
	}


	function AFCNStudyDeleteElement ( group )
	{
		if ( group == true )
		{
			if ( SAEStudyCurrentRowData.newrow == 1 )
			{
				SAEStudyToLink = SAEStudyToLink.filter(elem => elem.mstud_id !== SAEStudyCurrentRowData.mstud_id );
			}
			else
			{
				let nbRows = IdcSAELinkedStudiesDT.GetRowNumber ();
				for ( let i=0; i<nbRows; i++ )
				{
					let rowData = IdcSAELinkedStudiesDT.GetRowData ( i );	

					if ( rowData.mstud_id == SAEStudyCurrentRowData.mstud_id )
					{
						SAEStudyToUnLink.push ( new SAEStudyResData ( 1, rowData.rstud_id, rowData.mstud_id ) );
					}
				}
			}
		}
		else 	// Study only
		{
			if ( SAEStudyCurrentRowData.newrow == 1 )
			{
				let idx = -1;
				for ( let i=0; i<SAEStudyToLink.length;i++ )
				{
					if ( SAEStudyToLink [i].rstud_id == SAEStudyCurrentRowData.rstud_id )
					{
						idx = i;
						break;
					}
				}
				if ( idx != -1)
				{
					SAEStudyToLink.splice ( idx, 1 );
				}
			}
			else
			{
				SAEStudyToUnLink.push ( new SAEStudyResData ( 1, SAEStudyCurrentRowData.rstud_id ) );
			}
		}

		IdcSAELinkedStudiesDT.Refresh ();
		IdcSAENotLinkedStudiesDT.Refresh ();
	}

	function SAFCNStudyShortcutAdd ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SAFCNStudyAddShortcut imgclickable \" title=\"'+Translate ( 'Add' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/add_blue2.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}

	function SAFCNStudyShortcutDelete ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SAFCNStudyDeleteShortcut imgclickable \" title=\"'+Translate ( 'Trash' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/trash.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}














	function OnAFCNSerieAddShortcut ( tr )
	{
		SAESerieCurrentRowData = $('#'+IdcSAENotLinkedSeriesDT.Ident).DataTable ().row ( tr ).data ();

		if ( SAESerieCurrentRowData.mstud_id != -1 )
		{
			$('#IdcSAESerieAddSelectModal').modal('show');
		}
		else
			AFCNSerieAddElement ();			
	}

	function OnAFCNSerieDeleteShortcut ( tr )
	{
		SAESerieCurrentRowData = $('#'+IdcSAELinkedSeriesDT.Ident).DataTable ().row ( tr ).data ();

		if ( SAESerieCurrentRowData.mstud_id != -1 )
		{
			$('#IdcSAESerieDeleteSelectModal').modal('show');
		}
		else
			AFCNSerieDeleteElement ();			
	}

	function AFCNSerieAddElement ( group )
	{
		console.log ( "AFCNSerieAddElement..." );

		if ( group == true )
		{
			if ( SAESerieCurrentRowData.newrow == 1 )
			{
				SAESerieToUnLink = SAESerieToUnLink.filter(elem => elem.mstud_id === SAESerieCurrentRowData.mstud_id );
			}
			else
			{
				let nbRows = IdcSAENotLinkedSeriesDT.GetRowNumber ();
				for ( let i=0; i<nbRows; i++ )
				{
					let rowData = IdcSAENotLinkedSeriesDT.GetRowData ( i );	

					if ( rowData.mserd_id == SAESerieCurrentRowData.mserd_id )
					{
						SAESerieToLink.push ( new SAESerieResData ( 1, rowData.rserd_id, rowData.mserd_id ) );
					}
				}
			}
		}
		else 	// Serie only
		{
			if ( SAESerieCurrentRowData.newrow == 1 )
			{
				let idx = -1;
				for ( let i=0; i<SAESerieToUnLink.length;i++ )
				{
					if ( SAESerieToUnLink [i].rserd_id == SAESerieCurrentRowData.rserd_id )
					{
						idx = i;
						break;
					}
				}
				if ( idx != -1)
				{
					SAESerieToUnLink.splice ( idx, 1 );
				}
			}
			else
			{
				SAESerieToLink.push ( new SAESerieResData ( 1, SAESerieCurrentRowData.rserd_id, SAESerieCurrentRowData.mserd_id ) );
			}
		}

		IdcSAELinkedSeriesDT.Refresh ();
		IdcSAENotLinkedSeriesDT.Refresh ();
	}


	function AFCNSerieDeleteElement ( group )
	{
		if ( group == true )
		{
			if ( SAESerieCurrentRowData.newrow == 1 )
			{
				SAESerieToLink = SAESerieToLink.filter(elem => elem.mserd_id !== SAESerieCurrentRowData.mserd_id );
			}
			else
			{
				let nbRows = IdcSAELinkedSeriesDT.GetRowNumber ();
				for ( let i=0; i<nbRows; i++ )
				{
					let rowData = IdcSAELinkedSeriesDT.GetRowData ( i );	

					if ( rowData.mserd_id == SAESerieCurrentRowData.mserd_id )
					{
						SAESerieToUnLink.push ( new SAESerieResData ( 1, rowData.rserd_id, rowData.mserd_id ) );
					}
				}
			}
		}
		else 	// Serie only
		{
			if ( SAESerieCurrentRowData.newrow == 1 )
			{
				let idx = -1;
				for ( let i=0; i<SAESerieToLink.length;i++ )
				{
					if ( SAESerieToLink [i].rserd_id == SAESerieCurrentRowData.rserd_id )
					{
						idx = i;
						break;
					}
				}
				if ( idx != -1)
				{
					SAESerieToLink.splice ( idx, 1 );
				}
			}
			else
			{
				SAESerieToUnLink.push ( new SAESerieResData ( 1, SAESerieCurrentRowData.rserd_id ) );
			}
		}

		IdcSAELinkedSeriesDT.Refresh ();
		IdcSAENotLinkedSeriesDT.Refresh ();
	}

	function SAFCNSerieShortcutAdd ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SAFCNSerieAddShortcut imgclickable \" title=\"'+Translate ( 'Add' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/add_blue2.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}

	function SAFCNSerieShortcutDelete ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SAFCNSerieDeleteShortcut imgclickable \" title=\"'+Translate ( 'Trash' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/trash.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}

	function SExportExamsDTGetData ( d )
	{
		d.description = IdcSExportExamsDT.GetFilterData ('description_fr');

		return $.extend( {}, d );
	}

	function SExportStudiesLinkedDTGetData ( d )
	{
		let to_add = new Array();
		for ( let i=0; i<SAEStudyToLink.length; i++ )
			to_add.push (SAEStudyToLink [i].rstud_id );

		let to_remove = new Array();
		for ( let i=0; i<SAEStudyToUnLink.length; i++ )
			to_remove.push (SAEStudyToUnLink [i].rstud_id );

		d.linked = 1;
		d.modalitytitle = IdcSAELinkedStudiesDT.GetFilterData ('modalitytitle');
		d.description_fr = IdcSAELinkedStudiesDT.GetFilterData ('description_fr');
		d.to_add = JSON.stringify(to_add);
		d.to_remove = JSON.stringify(to_remove);
		d.desc_id = $('#IdcDivSettingsAFCNExport').data ( 'id' );

		return $.extend( {}, d );
	}

	function SExportStudiesNotLinkedDTGetData ( d )
	{
		let to_add = new Array();
		for ( let i=0; i<SAEStudyToLink.length; i++ )
			to_add.push (SAEStudyToLink [i].rstud_id );

		let to_remove = new Array();
		for ( let i=0; i<SAEStudyToUnLink.length; i++ )
			to_remove.push (SAEStudyToUnLink [i].rstud_id );

		d.linked = 0;
		d.modalitytitle = IdcSAENotLinkedStudiesDT.GetFilterData ('modalitytitle');
		d.description_fr = IdcSAENotLinkedStudiesDT.GetFilterData ('description_fr');
		d.to_add = JSON.stringify(to_add);
		d.to_remove = JSON.stringify(to_remove);
		d.desc_id = $('#IdcDivSettingsAFCNExport').data ( 'id' );
		return $.extend( {}, d );
	}

	function SExportSeriesLinkedDTGetData ( d )
	{
		console.log ( "SAESerieToLink : ", SAESerieToLink );

		let to_add = new Array();
		for ( let i=0; i<SAESerieToLink.length; i++ )
			to_add.push (SAESerieToLink [i].rserd_id );

		let to_remove = new Array();
		for ( let i=0; i<SAESerieToUnLink.length; i++ )
			to_remove.push (SAESerieToUnLink [i].rserd_id );

		d.linked 			= 1;
		d.modalitytitle 	= IdcSAELinkedSeriesDT.GetFilterData ('modalitytitle');
		d.description_fr 	= IdcSAELinkedSeriesDT.GetFilterData ('description_fr');
		d.rdescription 		= IdcSAELinkedSeriesDT.GetFilterData ('rdescription');
		d.to_add 	= JSON.stringify(to_add);
		d.to_remove = JSON.stringify(to_remove);
		d.desc_id = $('#IdcDivSettingsAFCNExport').data ( 'id' );

		return $.extend( {}, d );
	}

	function SExportSeriesNotLinkedDTGetData ( d )
	{
		let to_add = new Array();
		for ( let i=0; i<SAESerieToLink.length; i++ )
			to_add.push (SAESerieToLink [i].rserd_id );

		let to_remove = new Array();
		for ( let i=0; i<SAESerieToUnLink.length; i++ )
			to_remove.push (SAESerieToUnLink [i].rserd_id );

		d.linked = 1;
		d.modalitytitle 	= IdcSAENotLinkedSeriesDT.GetFilterData ('modalitytitle');
		d.description_fr 	= IdcSAENotLinkedSeriesDT.GetFilterData ('description_fr');
		d.rdescription 		= IdcSAENotLinkedSeriesDT.GetFilterData ('rdescription');
		d.to_add = JSON.stringify(to_add);
		d.to_remove = JSON.stringify(to_remove);
		d.desc_id = $('#IdcDivSettingsAFCNExport').data ( 'id' );

		d.linked = 0;

		return $.extend( {}, d );
	}


	function SExportDRLDTGetData ( d )
	{
		d.desc_id = $('#IdcDivSettingsAFCNExport').data ( 'id' );

		return $.extend( {}, d );
	}

	function SettingsExportExamsDTSelectChanged ( rowsIdx )
	{
		let desc_id = -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
			desc_id			= IdcSExportExamsDT.GetRowData ( rowIdx ).desc_id;
		}

		$('#IdcDivSettingsAFCNExport').data ( 'id', desc_id );

		if ( $('#IdcSAELinkedStudiesPanel').is (':visible') )
		{
			console.log ( "Refresh Studies ..." );
			IdcSAELinkedStudiesDT.RealRefresh ();
			IdcSAENotLinkedStudiesDT.RealRefresh ();
		}
		if ( $('#IdcSAELinkedSeriesPanel').is (':visible') )
		{
			console.log ( "Refresh Series ..." );
			IdcSAELinkedSeriesDT.RealRefresh ();
			IdcSAENotLinkedSeriesDT.RealRefresh ();
		}

		if ( $('#IdcSAEDRLPanel').is ( ':visible') )
		{
			console.log ( "Refresh NRD ..." );
			IdcSAEDRLDT.RealRefresh ();
		}
	}

	function SAELinkedStudiesRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newrow == 1 )
		{
			$(nRow).css ( 'background-color', '#00FF00');
		}
	}

	function SAENotLinkedStudiesRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newrow == 1 )
		{
			$(nRow).css ( 'background-color', '#FF0000');
		}

	}

	function SAELinkedSeriesRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newrow == 1 )
		{
			$(nRow).css ( 'background-color', '#00FF00');
		}
	}

	function SAENotLinkedSeriesRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newrow == 1 )
		{
			$(nRow).css ( 'background-color', '#FF0000');
		}

	}

	function SAEStudyAddGroup ()
	{
		AFCNStudyAddElement (true);			

		$('#IdcSAEStudyAddSelectModal').modal('hide');
	}

	function SAEStudyAddStudy ()
	{
		AFCNStudyAddElement (false);			

		$('#IdcSAEStudyAddSelectModal').modal('hide');

	}

	function SAEStudyDeleteGroup ()
	{
		AFCNStudyDeleteElement (true);			

		$('#IdcSAEStudyDeleteSelectModal').modal('hide');
	}

	function SAEStudyDeleteStudy ()
	{
		AFCNStudyDeleteElement (false);			

		$('#IdcSAEStudyDeleteSelectModal').modal('hide');

	}







	function SAESerieAddGroup ()
	{
		AFCNSerieAddElement (true);			

		$('#IdcSAESerieAddSelectModal').modal('hide');
	}

	function SAESerieAddSerie ()
	{
		AFCNSerieAddElement (false);			

		$('#IdcSAESerieAddSelectModal').modal('hide');

	}

	function SAESerieDeleteGroup ()
	{
		AFCNSerieDeleteElement (true);			

		$('#IdcSAESerieDeleteSelectModal').modal('hide');
	}

	function SAESerieDeleteSerie ()
	{
		AFCNSerieDeleteElement (false);			

		$('#IdcSAESerieDeleteSelectModal').modal('hide');

	}