	let SAPMailID 			= -1;
	let SANRDMailID 		= -1;
	let SANewModalityMailID = -1;

	function InitSettingsAlertPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsAlertPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsAlertPageInitialized', true );

		IdcSAPRecipientDT = new C_DataTable ();
		IdcSAPRecipientDT.DataSrcType		= 0;
		IdcSAPRecipientDT.Ident 			= 'IdcSAPRecipientDT';
		IdcSAPRecipientDT.Container 		= 'IdcSAPRecipientDTContainer';
		IdcSAPRecipientDT.CfgParameterName 	= 'SAPRecipientDTProperties';
		IdcSAPRecipientDT.DataSrc 			= 'SubFW/database/settings/alert/GetAlertAccountLinkDT.php';
		IdcSAPRecipientDT.DataFct			= SAPRecipientDTGetData;
		IdcSAPRecipientDT.SetColReorder 	( true );
		
		IdcSAPRecipientDT.AddColumn ( 'mail_id',						'mail_id',	 			0, false,  0,  50,   	false, '', 			'' );
		IdcSAPRecipientDT.AddColumn ( 'acc_id',							'acc_id',	 			0, false,  1,  50,   	false, '', 			'' );
		IdcSAPRecipientDT.AddColumn ( '',								'check',				1, true,   2,  40,   	false, '',			'', SAPRecipientCBRenderer );
		IdcSAPRecipientDT.AddColumn ( Translate('Users'),				'fullname',				1, true,   3,  '10%',    true, '',			'' );
		IdcSAPRecipientDT.AddColumn ( Translate('EMail'),				'mail',					1, true,   4,  '10%',    true, '',			'' );

		IdcSAPRecipientDT.LoadUserCfg ( G_USE_ID );



		IdcSANRDRecipientDT = new C_DataTable ();
		IdcSANRDRecipientDT.DataSrcType			= 0;
		IdcSANRDRecipientDT.Ident 				= 'IdcSANRDRecipientDT';
		IdcSANRDRecipientDT.Container 			= 'IdcSANRDRecipientDTContainer';
		IdcSANRDRecipientDT.CfgParameterName 	= 'SANRDRecipientDTProperties';
		IdcSANRDRecipientDT.DataSrc 			= 'SubFW/database/settings/alert/GetAlertAccountLinkDT.php';
		IdcSANRDRecipientDT.DataFct				= SANRDRecipientDTGetData;
		IdcSANRDRecipientDT.SetColReorder 	( true );
		
		IdcSANRDRecipientDT.AddColumn ( 'mail_id',					'mail_id',	 			0, false,  0,  50,   	false, '', 			'' );
		IdcSANRDRecipientDT.AddColumn ( 'acc_id',					'acc_id',	 			0, false,  1,  50,   	false, '', 			'' );
		IdcSANRDRecipientDT.AddColumn ( '',							'check',				1, true,   2,  40,   	false, '',			'', SANRDRecipientCBRenderer );
		IdcSANRDRecipientDT.AddColumn ( Translate('Users'),			'fullname',				1, true,   3,  '10%',    true, '',			'' );
		IdcSANRDRecipientDT.AddColumn ( Translate('EMail'),			'mail',					1, true,   4,  '10%',    true, '',			'' );

		IdcSANRDRecipientDT.LoadUserCfg ( G_USE_ID );


		IdcSANewModalityRecipientDT = new C_DataTable ();
		IdcSANewModalityRecipientDT.DataSrcType			= 0;
		IdcSANewModalityRecipientDT.Ident 				= 'IdcSANewModalityRecipientDT';
		IdcSANewModalityRecipientDT.Container 			= 'IdcSANewModalityRecipientDTContainer';
		IdcSANewModalityRecipientDT.CfgParameterName 	= 'SANewModalityRecipientDTProperties';
		IdcSANewModalityRecipientDT.DataSrc 			= 'SubFW/database/settings/alert/GetAlertAccountLinkDT.php';
		IdcSANewModalityRecipientDT.DataFct				= SANewModalityRecipientDTGetData;
		IdcSANewModalityRecipientDT.SetColReorder 	( true );
		
		IdcSANewModalityRecipientDT.AddColumn ( 'mail_id',					'mail_id',	 			0, false,  0,  50,   	false, '', 			'' );
		IdcSANewModalityRecipientDT.AddColumn ( 'acc_id',					'acc_id',	 			0, false,  1,  50,   	false, '', 			'' );
		IdcSANewModalityRecipientDT.AddColumn ( '',							'check',				1, true,   2,  40,   	false, '',			'', SANewModalityRecipientCBRenderer );
		IdcSANewModalityRecipientDT.AddColumn ( Translate('Users'),			'fullname',				1, true,   3,  '10%',    true, '',			'' );
		IdcSANewModalityRecipientDT.AddColumn ( Translate('EMail'),			'mail',					1, true,   4,  '10%',    true, '',			'' );

		IdcSANewModalityRecipientDT.LoadUserCfg ( G_USE_ID );

		$(document).ready(function () 
		{		
			IdcSAPRecipientDT.Create ();
			IdcSANRDRecipientDT.Create ();
			IdcSANewModalityRecipientDT.Create ();

			SAPLoadData ( false );

			switchLanguage ( eoDACS.CurrentLanguage );

			document.getElementById ('IdcSAPatientTab').addEventListener ( 'shown.bs.tab', () => { SAPatientTabShown (); } );
			document.getElementById ('IdcSANRDTab').addEventListener ( 'shown.bs.tab', () => { SANRDTabShown (); } );
			document.getElementById ('IdcSANewModalityTab').addEventListener ( 'shown.bs.tab', () => { SANewModalityTabShown (); } );
			document.getElementById ('IdcSARefreshStudyAlertTab').addEventListener ( 'shown.bs.tab', () => { SARefreshStudyTabShown (); } );
		});
	}

	function SAPRecipientDTGetData ( d )
	{
		d.alert_type = 'NRDPATIENTALERT';

		return $.extend( {}, d );
	}

	function SANRDRecipientDTGetData ( d )
	{
		d.alert_type = 'NRDALERT';

		return $.extend( {}, d );
	}

	function SANewModalityRecipientDTGetData ( d )
	{
		d.alert_type = 'NEWMODIDENT';

		return $.extend( {}, d );
	}

	function SAPRecipientCBRenderer ( data, ident, rowIdx, colIdx )
	{
		let rowData = IdcSAPRecipientDT.GetRowData ( rowIdx );

		let acc_id = rowData.acc_id;
		let email  = rowData.mail;
		let checked = ( rowData.mail_id != null )? 'checked': '';

		let id = "IdcSAPRecipientCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" data-acc_id='+acc_id+' data-email='+email+' data-row_idx='+rowIdx+' data-col_idx='+colIdx+' '+checked+'/></div>';
	}

	function SANRDRecipientCBRenderer ( data, ident, rowIdx, colIdx )
	{
		console.log ( "SANRDRecipientCBRenderer...");
		let rowData = IdcSANRDRecipientDT.GetRowData ( rowIdx );

		let acc_id = rowData.acc_id;
		let email  = rowData.mail;
		let checked = ( rowData.mail_id != null )? 'checked': '';

		let id = "IdcSANRDRecipientCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" data-acc_id='+acc_id+' data-email='+email+' data-row_idx='+rowIdx+' data-col_idx='+colIdx+' '+checked+'/></div>';
	}

	function SANewModalityRecipientCBRenderer ( data, ident, rowIdx, colIdx )
	{
		console.log ( "SANewModalityRecipientCBRenderer...");
		let rowData = IdcSANewModalityRecipientDT.GetRowData ( rowIdx );

		let acc_id = rowData.acc_id;
		let email  = rowData.mail;
		let checked = ( rowData.mail_id != null )? 'checked': '';

		let id = "IdcSANewModalityRecipientCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" data-acc_id='+acc_id+' data-email='+email+' data-row_idx='+rowIdx+' data-col_idx='+colIdx+' '+checked+'/></div>';
	}
	
	function SAPSave ()
	{
		let acc_ids = [];
		let emails 	= [];

		const elements = document.querySelectorAll('[id^="IdcSAPRecipientCB_"]');

		elements.forEach ( (el) => {
			console.log ( " el : " + el.id + " / " + el.dataset.acc_id + " / " + el.checked );
			if ( el.checked )
			{
				acc_ids.push 	( el.dataset.acc_id );
				emails.push 	( el.dataset.email );
			}
		} );

		let serviceActivated = $('#IdcSAPPatientEnable').prop ('checked');

		$.post (
				"SubFW/database/settings/alert/save_alert.php",
				{
					mail_id: 	SAPMailID,
					enabled: 	serviceActivated,
					acc_ids: 	acc_ids,
					emails: 	emails
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SAPLoadData ( true );

						// MsgWarning ( "Configuration des alertes effectuées." );
						MsgPopup ( "Configuration des alertes effectuées." );
					}
					else
						MsgWarning ( "Sauvegarde impossible !!!" );
				}
			);
	}

	function SANRDSave ()
	{
		let acc_ids = [];
		let emails 	= [];

		const elements = document.querySelectorAll('[id^="IdcSANRDRecipientCB_"]');

		elements.forEach ( (el) => {
			console.log ( " el : " + el.id + " / " + el.dataset.acc_id + " / " + el.checked );
			if ( el.checked )
			{
				acc_ids.push 	( el.dataset.acc_id );
				emails.push 	( el.dataset.email );
			}
		} );

		let serviceActivated = $('#IdcSANRDEnable').prop ('checked');

		$.post (
				"SubFW/database/settings/alert/save_alert.php",
				{
					mail_id: 	SANRDMailID,
					enabled: 	serviceActivated,
					acc_ids: 	acc_ids,
					emails: 	emails
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SANewModalityLoadData ( true );

						// MsgWarning ( "Configuration des alertes effectuées." );
						MsgPopup ( "Configuration des alertes effectuées." );
					}
					else
						MsgWarning ( "Sauvegarde impossible !!!" );
				}
			);
	}

	function SANewModalitySave ()
	{
		let acc_ids = [];
		let emails 	= [];

		const elements = document.querySelectorAll('[id^="IdcSANewModalityRecipientCB_"]');

		elements.forEach ( (el) => {
			console.log ( " el : " + el.id + " / " + el.dataset.acc_id + " / " + el.checked );
			if ( el.checked )
			{
				acc_ids.push 	( el.dataset.acc_id );
				emails.push 	( el.dataset.email );
			}
		} );

		let serviceActivated = $('#IdcSANewModalityEnable').prop ('checked');

		$.post (
				"SubFW/database/settings/alert/save_alert.php",
				{
					mail_id: 	SANRDMailID,
					enabled: 	serviceActivated,
					acc_ids: 	acc_ids,
					emails: 	emails
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SANewModalityLoadData ( true );

						MsgWarning ( "Configuration des alertes effectuées." );
					}
					else
						MsgWarning ( "Sauvegarde impossible !!!" );
				}
			);
	}

	

	function SAPLoadData ( refreshDT )
	{
		if ( refreshDT == true )
			IdcSAPRecipientDT.Refresh ();

		$.post (
				"SubFW/database/settings/alert/get_alert_enabled.php",
				{
					type: 'NRDPATIENTALERT'
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SAPMailID = data.results[0].mail_id;

						console.log ( "enabled : " + data.results[0].enabled );
						if ( data.results [0].enabled == true )
						{
							console.log ( "Check !!!");
							$('#IdcSAPPatientEnable').prop ('checked', true );
						}
						else
							$('#IdcSAPPatientEnable').prop ('checked', false );
					}
				}
			);	
	}

	function SANRDLoadData ( refreshDT )
	{
		if ( refreshDT == true )
			IdcSANRDRecipientDT.Refresh ();

		$.post (
				"SubFW/database/settings/alert/get_alert_enabled.php",
				{
					type: 'NRDALERT'
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SANRDMailID = data.results[0].mail_id;

						if ( data.results [0].enabled == true )
						{
							$('#IdcSANRDEnable').prop ('checked', true );
						}
						else
							$('#IdcSANRDEnable').prop ('checked', false );
					}
				}
			);	
	}

	function SANewModalityLoadData ( refreshDT )
	{
		if ( refreshDT == true )
			IdcSANewModalityRecipientDT.Refresh ();

		$.post (
				"SubFW/database/settings/alert/get_alert_enabled.php",
				{
					type: 'NEWMODIDENT'
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SANewModalityMailID = data.results[0].mail_id;

						if ( data.results [0].enabled == true )
						{
							$('#IdcSANewModalityEnable').prop ('checked', true );
						}
						else
							$('#IdcSANewModalityEnable').prop ('checked', false );
					}
				}
			);	
	}

	function SARefreshStudyLoadData ()
	{
		return;

		$.post (
				"SubFW/database/settings/alert/get_alert_enabled.php",
				{
					type: 'NEWMODIDENT'
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SANewModalityMailID = data.results[0].mail_id;

						if ( data.results [0].enabled == true )
						{
							$('#IdcSANewModalityEnable').prop ('checked', true );
						}
						else
							$('#IdcSANewModalityEnable').prop ('checked', false );
					}
				}
			);	
	}



	function SAPatientTabShown ()
	{
		console.log ( "SAPatientTabShown..." );

		SAPLoadData ( true );
	}

	function SANRDTabShown ()
	{
		console.log ( "SANRDTabShown..." );

		SANRDLoadData ( true );
	}

	function SANewModalityTabShown ()
	{
		console.log ( "SANewModalityTabShown..." );

		SANewModalityLoadData ( true );
	}

	function SARefreshStudyTabShown ()
	{
		console.log ( "SARefreshStudyTabShown..." );

		SARefreshStudyLoadData ();
	}

	function SARefreshStudyApply ()
	{
		console.log ( "SARefreshStudyApply..." );

		let fromDate 	= $('#IdcSARefreshFromDate').val ();
		let toDate 		= $('#IdcSARefreshToDate').val ();

		$.post (
				"SubFW/database/settings/alert/save_refresh_study.php",
				{
					from_date: 	fromDate,
					to_date: 	toDate
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					if ( data.status == 'OK' )
					{
						SARefreshStudyLoadData ();

						MsgWarning ( "Les alertes ont été mise à jours." );
					}
					else
						MsgWarning ( "Sauvegarde impossible !!!" );
				}
			);
	}