	
	let SITreeInstance = null;
	let copiedResults;

	function InitSettingsInstitutionPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsInstitutionPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsInstitutionPageInitialized', true );

		IdcSIModalitiesLinkedDT = new C_DataTable ();
		IdcSIModalitiesLinkedDT.DataSrcType			= 0;
		IdcSIModalitiesLinkedDT.Ident 				= 'IdcSIModalitiesLinkedDT';
		IdcSIModalitiesLinkedDT.Container 			= 'IdcSIModalitiesLinkedDTContainer';
		IdcSIModalitiesLinkedDT.CfgParameterName 	= 'SIModalitiesLinkedDTProperties';
		IdcSIModalitiesLinkedDT.DataSrc 			= 'SubFW/database/settings/institution/GetModalitiesLinkedDT.php';
		IdcSIModalitiesLinkedDT.DataFct				= SIModalitiesLinkedDTGetData;
		IdcSIModalitiesLinkedDT.SetColReorder 	( true );
		IdcSIModalitiesLinkedDT.OnSelectChanged	( SIModalitiesLinkedDTSelectChanged );

		IdcSIModalitiesLinkedDT.AddColumn ( 'modident_id',				'modident_id',	 				0, false,  	0,  50,   false, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( 'mod_id',					'mod_id',	 					0, false,  	1,  50,   false, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( 'status',					'status',						0, false,  	2, 	50,   false, '',	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( Translate('Short.'),		'',								0, true,  	3,  40,   false, '', 	'', SIShortcutDelete );
		IdcSIModalitiesLinkedDT.AddColumn ( Translate('UID'),			'device_uid',					0, true,	4, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( Translate('Name'),			'stationname',					1, true,  	5, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( 'AET',						'stationaet',					1, true,  	6, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( 'Perf name',				'performedstationname',			1, true,  	7, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( 'Perf AET',					'performedstationaet',			1, true,  	8, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( Translate('Manufacturer'),	'manufacturer',					1, true, 	9, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( Translate('Model'),			'manufacturermodel',			1, true,   10, '30%',  true, '', 	'' );
		IdcSIModalitiesLinkedDT.AddColumn ( Translate('Status'),		'status_label',					1, true,   11, '30%',  true, '', 	'',	Translate );
		// IdcSIModalitiesLinkedDT.SetColumnFilter ( 'description_fr', 		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcSExportDescriptionFilter" class="form-control pt-0 pb-0" oninput="IdcSExportExamsDT.Refresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );
		
		IdcSIModalitiesLinkedDT.LoadUserCfg ( G_USE_ID );

		IdcSIModalitiesNotLinkedDT = new C_DataTable ();
		IdcSIModalitiesNotLinkedDT.DataSrcType			= 0;
		IdcSIModalitiesNotLinkedDT.Ident 				= 'IdcSIModalitiesNotLinkedDT';
		IdcSIModalitiesNotLinkedDT.Container 			= 'IdcSIModalitiesNotLinkedDTContainer';
		IdcSIModalitiesNotLinkedDT.CfgParameterName 	= 'SIModalitiesNotLinkedDTProperties';
		IdcSIModalitiesNotLinkedDT.DataSrc 				= 'SubFW/database/settings/institution/GetModalitiesNotLinkedDT.php';
		IdcSIModalitiesNotLinkedDT.DataFct				= SIModalitiesNotLinkedDTGetData;
		IdcSIModalitiesNotLinkedDT.SetColReorder 	( true );
		IdcSIModalitiesNotLinkedDT.OnSelectChanged	( SIModalitiesNotLinkedDTSelectChanged );

		IdcSIModalitiesNotLinkedDT.AddColumn ( 'modident_id',				'modident_id',	 				0, false,  	0,  50,   false, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( 'mod_id',					'mod_id',	 					0, false,  	1,  50,   false, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( 'status',					'status',						0, false,  	2, 	50,   false, '',	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('Short.'),			'',							0, true,  	3,  40,   false, '', 	'', SIShortcutAdd );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('Modality'),		'modname',					1, true,  	4, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('UID'),			'device_uid',					1, true,	5, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('Name'),			'stationname',					1, true,  	5, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( 'AET',					'stationaet',					1, true,  	7, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( 'Perf name',				'performedstationname',			1, true,  	8, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( 'Perf AET',				'performedstationaet',			1, true,  	9, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('Manufacturer'),	'manufacturer',				1, true,   10, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('Model'),			'manufacturermodel',			1, true,   11, '30%',  true, '', 	'' );
		IdcSIModalitiesNotLinkedDT.AddColumn ( Translate('Status'),			'status_label',				1, true,   12, '30%',  true, '', 	'',	Translate );
		// IdcSIModalitiesNotLinkedDT.SetColumnFilter ( 'description_fr', 		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcSExportDescriptionFilter" class="form-control pt-0 pb-0" oninput="IdcSExportExamsDT.Refresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );
		
		IdcSIModalitiesLinkedDT.LoadUserCfg ( G_USE_ID );
			
		$(document).ready(function () 
		{		
			IdcSISplitter1_2 			= new C_Splitter ( "IdcSISplitter1_2" 			);
			IdcSISplitter3_4 			= new C_Splitter ( "IdcSISplitter3_4" 			);
			IdcSISplitter5_6 			= new C_Splitter ( "IdcSISplitter5_6" 			);

			IdcSISplitter1_2.LoadUserCfg		( G_USE_ID );
			IdcSISplitter3_4.LoadUserCfg		( G_USE_ID );
			IdcSISplitter5_6.LoadUserCfg		( G_USE_ID );

			SIFillTreeView ();

			FillStaffList ( 'IdcSIInstPersonOfContact' );
			FillStaffList ( 'IdcSIInstRadiophysicien' );

			FillStaffList ( 'IdcSIDepPersonOfContact' );
			FillStaffList ( 'IdcSIDepRadiophysicien' );

			IdcSIModalitiesLinkedDT.Create ();
			$('#' + IdcSIModalitiesLinkedDT.Ident +' tbody').on('click', '.SIModalityDeleteShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnSIModalityDeleteShortcut ( tr );
			} );

			IdcSIModalitiesNotLinkedDT.Create ();
			$('#' + IdcSIModalitiesNotLinkedDT.Ident +' tbody').on('click', '.SIModalityAddShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnSIModalityAddShortcut ( tr );
			} );

			// document.getElementById ('IdcSSCDRLTab').addEventListener ( 'shown.bs.tab', () => { SSCDRLTabShown (); } );


			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SIShortcutAdd ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SIModalityAddShortcut imgclickable \" title=\"'+Translate ( 'Add' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/add_blue2.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}

	function SIShortcutDelete ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SIModalityDeleteShortcut imgclickable \" title=\"'+Translate ( 'Delete' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/trash.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}

	function OnSIModalityAddShortcut ( tr )
	{
		let mod_id = $('#IdcSIPanelModality' ).data ('id');


		let row = $('#'+IdcSIModalitiesNotLinkedDT.Ident).DataTable ().row ( tr );

		let modident_id = row.data().modident_id;
		let status 		= row.data().status;

		$.post (
			"SubFW/database/settings/institution/add_modality_ident.php",
			{
				mod_id: 					mod_id,
				modident_id: 				modident_id,
				status: 					status
			},
			function (data)
			{
				if ( data.status == 'OK')
					SIFillTreeView ( 'modality', data.results );
				else
					MsgWarning ( Translate ("Unable to save modality !!!") );
			}
		);
	}

	function OnSIModalityDeleteShortcut ( tr )
	{
		let mod_id = $('#IdcSIPanelModality' ).data ('id');

		let row = $('#'+IdcSIModalitiesLinkedDT.Ident).DataTable ().row ( tr );
		let modident_id 	= row.data().modident_id;
		
		$.post (
			"SubFW/database/settings/institution/delete_modality_ident.php",
			{
				modident_id: 				modident_id
			},
			function (data)
			{
				if ( data.status == 'OK')
					SIFillTreeView ( 'modality', mod_id );
				else
					MsgWarning ( Translate ("Unable to remove modality !!!") );
			}
		);
	}

	function SIModalitiesLinkedDTGetData ( d )
	{
		d.mod_id	 = $('#IdcSIPanelModality' ).data ('id');

		return $.extend( {}, d );
	}

	function SIModalitiesLinkedDTSelectChanged ()
	{

	}

	function SIModalitiesNotLinkedDTGetData ( d )
	{
		d.mod_id	 = $('#IdcSIPanelModality' ).data ('id');

		return $.extend( {}, d );
	}

	function SIModalitiesNotLinkedDTSelectChanged ()
	{

	}

	InstitutionTreeMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/hospital.png',
			text: 'Add institution',
			action: function(e, selector) { SIAddInstitution (); }
		},
		{
			divider: true
		},
		{
			img: 'SubFW/bmp/alert_management.png',
			text: 'Add department',
			action: function(e, selector) { SIAddDepartment (); }
		},
		{
			divider: true
		},
		{
			img: 'SubFW/bmp/trash.png',
			text: 'Delete institution...',
			action: function(e, selector) { SIDeleteInstitution (); }
		}		
	];

	DepartmentTreeMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/alert_management.png',
			text: 'Add room',
			action: function(e, selector) { SIAddRoom (); }
		},
		{
			divider: true
		},
		{
			img: 'SubFW/bmp/trash.png',
			text: 'Delete department...',
			action: function(e, selector) { SIDeleteDepartment (); }
		}		
	];

	RoomTreeMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/alert_management.png',
			text: 'Add modality',
			action: function(e, selector) { SIAddModality (); }
		},
		{
			divider: true
		},
		{
			img: 'SubFW/bmp/trash.png',
			text: 'Delete room...',
			action: function(e, selector) { SIDeleteRoom (); }
		}		
	];

	ModalityTreeMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/trash.png',
			text: 'Delete modality...',
			action: function(e, selector) { SIDeleteModality (); }
		}		
	];

	function SIAddInstitution ()
	{
		console.log ( "SIAddInstitution..." );

		$.post (
			"SubFW/database/common/save_institution.php",
			{
				inst_id: 	-1
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				if ( data.status == 'OK')
					SIFillTreeView ( 'institution', data.results );
				else
					MsgWarning ( Translate ("Unable to save institution !!!") );
			}
		);
	}

	function SIAddDepartment ()
	{
		console.log ( "SIAddDepartment..." );

		let inst_id 		= $('#IdcSIPanelInstitution' ).data ('id');

		$.post (
			"SubFW/database/common/save_department.php",
			{
				inst_id: 	inst_id
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView (  'department', data.results  );
				}
				else
					MsgWarning ( Translate ("Unable to save department !!!") );
			}
		);
	}

	function SIAddRoom ()
	{
		console.log ( "SIAddRoom..." );

		let dep_id 		= $('#IdcSIPanelDepartment' ).data ('id');

		$.post (
			"SubFW/database/common/save_room.php",
			{
				dep_id: 	dep_id
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView (  'department', data.results  );
				}
				else
					MsgWarning ( Translate ("Unable to save room !!!") );
			}
		);
	}

	function SIInstitutionDelete ()
	{
		let inst_id	 		= $('#IdcSIPanelInstitution' ).data ('id');
		
		$.post (
			"SubFW/database/common/delete_institution.php",
			{
				inst_id: 	inst_id
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView ();
				}
				else
					MsgWarning ( Translate ("Unable to delete institution !!!") );
			}
		);
	}

	function SIDeleteInstitution ()
	{
		console.log ( "SIDeleteInstitution..." );

		MsgYesNo ( Translate("Delete selected institution ?"), SIInstitutionDelete );
	}

	function SIDepartmentDelete ()
	{
		let dep_id	 		= $('#IdcSIPanelDepartment' ).data ('id');
		
		$.post (
			"SubFW/database/common/delete_department.php",
			{
				dep_id: 	dep_id
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView ();
				}
				else
					MsgWarning ( Translate ("Unable to delete department !!!") );
			}
		);
	}

	function SIDeleteDepartment ()
	{
		console.log ( "SIDeleteInstitution..." );

		MsgYesNo ( Translate("Delete selected department ?"), SIDepartmentDelete );
	}

	function SIRoomDelete ()
	{
		let room_id	 		= $('#IdcSIPanelRoom' ).data ('id');

		$.post (
			"SubFW/database/common/delete_room.php",
			{
				room_id: 	room_id
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView ();
				}
				else
					MsgWarning ( Translate ("Unable to delete room !!!") );
			}
		);
	}

	function SIDeleteRoom ()
	{
		console.log ( "SIDeleteRoom..." );

		MsgYesNo ( Translate("Delete selected room ?"), SIRoomDelete );
	}

	function SIModalityDelete ()
	{
		let mod_id	 		= $('#IdcSIPanelModality' ).data ('id');

		$.post (
			"SubFW/database/common/delete_modality.php",
			{
				mod_id: 	mod_id
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView ();
				}
				else
					MsgWarning ( Translate ("Unable to delete modality !!!") );
			}
		);
	}

	function SIDeleteModality ()
	{
		console.log ( "SIDeleteModality..." );

		MsgYesNo ( Translate("Delete selected modality ?"), SIModalityDelete );
	}

	function SIFillTreeView ( data1, data2 )
	{
		$.post (
				eoDACS.ServerFolder + "/SubFW/database/settings/institution/tree_institution_setup.php",
					{
						ext_id: 0,
						type: 1
					},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );
						console.log ( " data.results : " + data.results );

						SIAddMenuToTreeItems ( data.results );

						switchLanguage ( eoDACS.CurrentLanguage );

						copiedResults = Object.assign([], data.results);

						$('#IdcSITreeContainer').C_TreeView ( { data: data.results }, SISelectionChanged );

						SITreeInstance = $('#IdcSITreeContainer').data('plugin_C_TreeView');
						if ( data1 !== undefined && data2 !== undefined )
							SITreeInstance.SelectItem ( data1, data2 );
						else
							SITreeInstance.SelectFirstItem ();
					}
			);
	}

	function SIAddMenuToTreeItems(nodes) 
	{
    	$.each(nodes, function(index, node) 
    	{
        	if (node.data1 === 'institution') 
        	{
            	// On ajoute un nouvel attribut text (ou on modifie l'existant)
            	node.menu = InstitutionTreeMenu;
        	}
        	else
        	{
        		if (node.data1 === 'department')
        			node.menu = DepartmentTreeMenu;
        		else
        			if (node.data1 === 'room')
        				node.menu = RoomTreeMenu;
        			else
        				if (node.data1 === 'modality')
        					node.menu = ModalityTreeMenu;

        	}

        	// Si le noeud a des enfants, on les parcourt aussi
        	if (node.nodes && node.nodes.length > 0) 
        	{
            	SIAddMenuToTreeItems(node.nodes);
        	}
    	});
	}


function SISelectionChanged ( data1, data2 )
{
	console.log ( "SISelectionChanged..." );

	let parents = [];

	const result = SIFindElementAndParents ( copiedResults, data1, data2 );
	if ( result ) 
	{
   		SIAddTreeElements ( result );
	} 
	else 
	{
    	console.log ( "Élément non trouvé." );
	}

	switch ( data1 )
	{
		case 'institution':
			$('#IdcSIPanelInstitution').show ();
			$('#IdcSIPanelDepartment').hide ();
			$('#IdcSIPanelRoom').hide ();
			$('#IdcSIPanelModality').hide ();
			SIFillInstitutionForm ( data2 );
			break;

		case 'department':
			$('#IdcSIPanelInstitution').hide ();
			$('#IdcSIPanelDepartment').show ();
			$('#IdcSIPanelRoom').hide ();
			$('#IdcSIPanelModality').hide ();
			SIFillDepartmentForm ( data2 );
			break;

		case 'room':
			$('#IdcSIPanelInstitution').hide ();
			$('#IdcSIPanelDepartment').hide ();
			$('#IdcSIPanelRoom').show ();
			$('#IdcSIPanelModality').hide ();
			SIFillRoomForm ( data2 );
			break;

		case 'modality':
			$('#IdcSIPanelInstitution').hide ();
			$('#IdcSIPanelDepartment').hide ();
			$('#IdcSIPanelRoom').hide ();
			$('#IdcSIPanelModality').show ();
			SIFillModalityForm ( data2 );
			break;
	}
}


function SISearch ()
{
	let text = $('#IdcSISearchText').val ();

	SITreeInstance.SelectNextItem ( text );
}

function SIAddTreeElements ( elements ) 
{
     const ol = document.getElementById('IdcSIList'); 

     ol.innerHTML = '';
            
     const newItem = document.createElement('li'); 

     for ( let i=0; i<elements.length; i++ )
     {
            const spanText = document.createElement('span'); 
            spanText.onclick = function () { clicInTree ( elements[i].data1, elements[i].data2 );};
            if ( i < elements.length -1 )
            {
            	spanText.classList.add('el_clic');
            	spanText.setAttribute('data-link', '#mangue');
            }
            spanText.textContent = elements[i].text; // Le texte du fruit

            newItem.appendChild(spanText); // Ajouter le texte au <li>

            if ( i < elements.length -1 )
            {
            	const spanSeparator = document.createElement('span'); 
            	spanSeparator.classList.add('separator');
            	spanSeparator.textContent = '>'; 
            
            	newItem.appendChild(spanSeparator); 
            }

            ol.appendChild(newItem); 
      }
}

function clicInTree ( id1, id2 )
{
	SITreeInstance.SelectItem ( id1, id2 );
}



function SIFindElementAndParents ( nodes, targetData1, targetData2 ) 
{
    let result = []; 

    function searchParent(node, targetData1, targetData2, parents) 
    {
        if ( node.data1 === targetData1 && node.data2 === targetData2 ) 
        {
            result = [...parents, { data1: node.data1, data2: node.data2, text: node.text }];
            return true; 
        }

        if ( node.nodes ) 
        {
            for (let child of node.nodes) 
            {
                const found = searchParent(child, targetData1, targetData2, [
                    ...parents,
                    { data1: node.data1, data2: node.data2, text: node.text }
                ]);
                if ( found ) 
                {
                    return true;
                }
            }
        }
        return false;
    }

    for ( let node of nodes ) 
    {
        const found = searchParent(node, targetData1, targetData2, []);
    
        if ( found ) 
            break; 
    }

    return result;
}

function SIInstitutionSave ()
{
	let inst_id 		= $('#IdcSIPanelInstitution' ).data ('id');

	let name 			= $('#IdcSIInstitutionName').val 		();
	let prefix 		= $('#IdcSIInstitutionPrefix').val 		();
	let address 		= $('#IdcSIInstitutionAddress').val 	();
	let contact 		= $('#IdcSIInstPersonOfContact').val 	();
	let radiophysicist 	= $('#IdcSIInstRadiophysicien').val 	();

	
	$.post (
			"SubFW/database/common/save_institution.php",
			{
				inst_id: 	inst_id,
				name: 		name,
				prefix: 	prefix,
				address: 	address,
				contact: 	contact,
				radiophy: 	radiophysicist
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				if ( data.status == 'OK')
					SIFillTreeView ( 'institution', data.results );
				else
					MsgWarning ( Translate ("Unable to save institution !!!") );
			}
		);

}

function SIDepartmentSave ()
{
	console.log ( "SIDepartmentSave..." );

	let dep_id 		= $('#IdcSIPanelDepartment' ).data ('id');

	let name 			= $('#IdcSIDepartmentName').val 	();
	let type 			= $('#IdcSIDepType').val 			();
	let contact 		= $('#IdcSIDepPersonOfContact').val ();
	let radiophysicist 	= $('#IdcSIDepRadiophysicien').val 	();

	
	$.post (
			"SubFW/database/common/save_department.php",
			{
				dep_id: 	dep_id,
				name: 		name,
				type: 		type,
				contact: 	contact,
				radiophy: 	radiophysicist
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView (  'department', data.results  );
				}
				else
					MsgWarning ( Translate ("Unable to save department !!!") );
			}
		);
}

function SIRoomSave ()
{
	console.log ( "SIRoomSave..." );

	let room_id	 		= $('#IdcSIPanelRoom' ).data ('id');

	let name 			= $('#IdcSIRoomName').val 	();
	
	$.post (
			"SubFW/database/common/save_room.php",
			{
				room_id: 	room_id,
				name: 		name
			},
			function (data)
			{
				console.log ( "Status : "+ data.status );
				console.log ( "Results : "+ data.results );
				if ( data.status == 'OK')
				{
					SIFillTreeView (  'room', data.results  );
				}
				else
					MsgWarning ( Translate ("Unable to save room !!!") );
			}
		);
}

function SIFillInstitutionForm ( id )
{
	console.log ( "FillInstitutionForm...");

	$('#IdcSIPanelInstitution' ).data ('id', id );

	$.post (
			"SubFW/database/settings/institution/get_institution.php",
			{
				inst_id: id
			},
			function (data)
			{
				if ( data.results.length == 1 )
				{
					$('#IdcSIInstitutionName').val 		( data.results[0].name );
					$('#IdcSIInstitutionPrefix').val 	( data.results[0].prefix );
					$('#IdcSIInstitutionAddress').val 	( data.results[0].address );
					$('#IdcSIInstPersonOfContact').val 	( data.results[0].contact );
					$('#IdcSIInstRadiophysicien').val 	( data.results[0].radiophysicist );
				}
			}
		);
}

function SIFillDepartmentForm ( id )
{
	console.log ( "FillDepartmentForm...");

	$('#IdcSIPanelDepartment' ).data ('id', id );

	$.post (
			"SubFW/database/settings/institution/get_department.php",
			{
				dep_id: id
			},
			function (data)
			{
				if ( data.results.length == 1 )
				{
					$('#IdcSIDepartmentName').val 		( data.results[0].name );
					$('#IdcSIDepType').val 	( data.results[0].type );
					$('#IdcSIDepPersonOfContact').val 	( data.results[0].contact );
					$('#IdcSIDepRadiophysicien').val 	( data.results[0].radiophysicist );
				}
			}
		);
}

function SIFillRoomForm ( id )
{
	console.log ( "FillRoomForm...");
	console.log ( " id : " + id );

	$('#IdcSIPanelRoom' ).data ('id', id );

	$.post (
			"SubFW/database/settings/institution/get_room.php",
			{
				room_id: id
			},
			function (data)
			{
				if ( data.results.length == 1 )
				{
					$('#IdcSIRoomName').val ( data.results[0].name );
				}
			}
		);
}

function SIFillModalityForm ( id )
{
	console.log ( "FillModalityForm...");
	console.log ( " id : " + id );

	$('#IdcSIPanelModality' ).data ('id', id );

	IdcSIModalitiesLinkedDT.Refresh ();
	IdcSIModalitiesNotLinkedDT.Refresh ();

	$.post (
			"SubFW/database/settings/institution/get_modality.php",
			{
				mod_id: id
			},
			function (data)
			{
				if ( data.results.length == 1 )
				{
					$('#IdcSIModalityName').val 					( data.results[0].name );
					$('#IdcSIModalityType').val 					( data.results[0].modalitytitle );
					$('#IdcSIModalityManufacturer').val 			( data.results[0].manufacturer );
					$('#IdcSIModalityModel').val 					( data.results[0].model );
					$('#IdcSIModalityUID').val 					( data.results[0].uid );
					$('#IdcSIModalityInstallDate').val				( data.results[0].installation_date );
					$('#IdcSIModalityDAPCalibrationDate').val		( data.results[0].dap_calibration_date );
					$('#IdcSIModalityDetectorType').val			( data.results[0].detector_type );
					$('#IdcSIModalityCTDetectorNumber').val			( data.results[0].detector_number );
					$('#IdcSIModalityReconstructionSoftware').val	( data.results[0].reconstruction_software );
					$('#IdcSIModalityComment').val				( data.results[0].comment );
					$('#IdcSIModalityActive').prop 		( 'checked', (data.results[0].active==1)?true : false );
					$('#IdcSIModalityRI').prop 	 		( 'checked', (data.results[0].radiology_interventional==1)?true : false );
					$('#IdcSIModalityManualEncoding').prop 	( 'checked', (data.results[0].manual_encoding==1)?true : false );
				}
			}
		);
	
}

function SICollapseAll ()
{
	SITreeInstance.CollapseAll ();
}

function SIExpandAll ()
{
	SITreeInstance.ExpandAll ();
}

function SIAddModality ()
{
	let room_id = $('#IdcSIPanelRoom' ).data ('id');

	console.log ( "room_id : " + room_id );

	$.post (
		"SubFW/database/common/save_modality.php",
		{
			room_id:  				room_id,
			mod_id: 					-1
		},
		function (data)
		{
			console.log ( "Status : "+ data.status );
			if ( data.status == 'OK')
				SIFillTreeView ( 'modality', data.results );
			else
				MsgWarning ( Translate ("Unable to save modality !!!") );
		}
	);
}

function SIModalitySave ()
{
	let mod_id = $('#IdcSIPanelModality' ).data ('id');

	let name 					= $('#IdcSIModalityName').val ();
	let modalitytitle 			= $('#IdcSIModalityType').val ();
	let manufacturer 			= $('#IdcSIModalityManufacturer').val ();
	let model 				= $('#IdcSIModalityModel').val ();
	let uid 					= $('#IdcSIModalityUID').val ();
	let installation_date 		= $('#IdcSIModalityInstallDate').val ();
	let dap_calibration_date 	= $('#IdcSIModalityDAPCalibrationDate').val ();
	let detector_type 			= $('#IdcSIModalityDetectorType').val ();
	let detector_number 		= $('#IdcSIModalityCTDetectorNumber').val ();
 	let reconstruction_software 	= $('#IdcSIModalityReconstructionSoftware').val ();
 	let comment 				= $('#IdcSIModalityComment').val ();
	let active 				= $('#IdcSIModalityActive').prop 		 ( 'checked' );
	let radiology_interventional  = $('#IdcSIModalityRI').prop 	 		 ( 'checked' );
	let manual_encoding 		= $('#IdcSIModalityManualEncoding').prop ( 'checked' );

	$.post (
		"SubFW/database/common/save_modality.php",
		{
			mod_id: 					mod_id,
			name: 					name,
			modalitytitle: 			modalitytitle,
			manufacturer: 				manufacturer,
			model: 					model,
			uid: 					uid,
			installation_date: 			installation_date,
			dap_calibration_date: 		dap_calibration_date,
			detector_type: 			detector_type,
			detector_number: 			detector_number,
			reconstruction_software: 	reconstruction_software,
			comment: 					comment,
			active: 					active,
			radiology_interventional: 	radiology_interventional,
			manual_encoding: 			manual_encoding
		},
		function (data)
		{
			console.log ( "Status : "+ data.status );
			if ( data.status == 'OK')
				SIFillTreeView ( 'modality', data.results );
			else
				MsgWarning ( Translate ("Unable to save modality !!!") );
		}
	);
}