	var GIntegrationStatusListCB = new Array ();

	SIntegrationStatusDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSIntegrationStatusListDT.Properties (); }
		}
	];

	function InitSettingsIntegrationStatusPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsIntegrationErrorsPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsIntegrationErrorsPageInitialized', true );

		IdcSIntegrationStatusListDT = new C_DataTable ();
		IdcSIntegrationStatusListDT.DataSrcType		= 0;
		IdcSIntegrationStatusListDT.Ident 			= 'IdcSIntegrationStatusListDT';
		IdcSIntegrationStatusListDT.Container 		= 'IdcSIntegrationStatusListDTContainer';
		IdcSIntegrationStatusListDT.CfgParameterName = 'SIntegrationStatusListDTProperties';
		IdcSIntegrationStatusListDT.DataSrc 		= 'SubFW/database/settings/integration_status/GetIntegrationStatusDT.php';
		IdcSIntegrationStatusListDT.DataFct			= SIntegrationStatusDTGetData;
		IdcSIntegrationStatusListDT.SetColReorder 	( true );
		IdcSIntegrationStatusListDT.OnSelectChanged	( SIntegrationStatusDTSelectChanged );
		IdcSIntegrationStatusListDT.RowCallbackFct	= SIntegrationStatusListRowCallback;
		IdcSIntegrationStatusListDT.DrawCallbackFct	= SIntegrationStatusListDrawCallback;
		IdcSIntegrationStatusListDT.OnRefreshFct	= SIntegrationStatusListDTRefresh;
		
		IdcSIntegrationStatusListDT.AddColumn ( 'sto_id',						'sto_id',	 			0, false,  0,  50,   false, '', 			'' );
		IdcSIntegrationStatusListDT.AddColumn ( '',								'check',				1, true,   1,  40,   false, '',				'', SIntegrationStatusListCBRenderer );
		IdcSIntegrationStatusListDT.AddColumn ( Translate('Date'),				'recdate',				1, true,   2, '10%', true,  'text-center',	'' );
		IdcSIntegrationStatusListDT.AddColumn ( Translate('Modality'),			'source',				1, true,   3, '10%', true,  '', 			'' );
		IdcSIntegrationStatusListDT.AddColumn ( Translate('Type'),				'modalitytitle',		1, true,   4, '10%', true,  'text-center',	'' );
		IdcSIntegrationStatusListDT.AddColumn ( 'Patient',						'patientname',			1, true,   5, '10%', true,  '', 			'' );
		IdcSIntegrationStatusListDT.AddColumn ( Translate('Status'),			'status',				1, true,   6, '10%', true,  '', 			'', SISStatusText );
		IdcSIntegrationStatusListDT.AddColumn ( Translate('Status details'),	'integration_error',	1, true,   7, '10%', true,  '', 			'' );
		IdcSIntegrationStatusListDT.AddColumn ( Translate('Clarifications'),	'integration_message',	1, true,   8, '10%', true,  '', 			'' );

		IdcSIntegrationStatusListDT.ColumnFilter (  'check', 'other', '<div class="m-0 p-0 w-100 text-center"><input id="IdcSISSendingListSendAll" class="XIMEO_DT-Checkbox m-0 p-0" type="checkbox" onclick="OnSISSendingListSendAllClicked(this)"/></div>' );

		IdcSIntegrationStatusListDT.ColumnFilter ( 'recdate', 'period' );
		IdcSIntegrationStatusListDT.ColumnFilter ( 'source' );
		IdcSIntegrationStatusListDT.ColumnFilter ( 'patientname' );
		const statusList = [
			{ id: -1,	label: Translate("All")},
			{ id: 0,	label: Translate("To process")},
			{ id: 1,	label: Translate("In progress")},
			{ id: 2,	label: Translate("Done")},
			{ id: 3,	label: Translate("Error")}
		];
		IdcSIntegrationStatusListDT.ColumnFilter ( 'status', 'combo', statusList );
		const modalitytitleList = [
			{ id: '',	label: Translate("All")},
			{ id: 'CR',	label: 'CR'},
			{ id: 'CT',	label: 'CT'},
			{ id: 'DX',	label: 'DX'},
			{ id: 'MG',	label: 'MG'},
			{ id: 'MR',	label: 'MR'},
			{ id: 'OT',	label: 'OT'},
			{ id: 'PR',	label: 'PR'},
			{ id: 'PT',	label: 'PT'},
			{ id: 'RF',	label: 'RF'},
			{ id: 'SR',	label: 'SR'},
			{ id: 'XA',	label: 'XA'}
		];
		IdcSIntegrationStatusListDT.ColumnFilter ( 'modalitytitle', 'combo', modalitytitleList );
		
		IdcSIntegrationStatusListDT.LoadUserCfg ( G_USE_ID );
			
		$(document).ready(function () 
		{		
			$.post (
				"SubFW/database/settings/integration_status/get_error_type_list.php",
				{
				},
				function (data)
				{
					const list = [];

					list.push ( { id: 	'',
									label: Translate('All') } );

					for ( let i=0; i<data.results.length; i++ )
					{
						list.push ( { id: 	data.results[i].error_type,
									  label: data.results[i].error_type } );
					}

					IdcSIntegrationStatusListDT.ColumnFilter ( 'integration_error', 'combo', list );
					IdcSIntegrationStatusListDT.Create ();
					context.attach ( '#IdcSIntegrationStatusListDT', SIntegrationStatusDTListMenu );
				}
			);
	
			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SIntegrationStatusListCBRenderer ( data, ident, rowIdx, colIdx )
	{
		// let rowData = $('#IdcSIntegrationStatusListDT').DataTable().row ( rowIdx ).data();

		// if ( rowData.status == 3 )
		{
			let sto_id = IdcSIntegrationStatusListDT.GetRowData ( rowIdx ).sto_id;

			let id = "IdcIntegrationStatusListSendCB_" + rowIdx;
			return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" data-row_idx='+rowIdx+' data-col_idx='+colIdx+' onclick="OnIntegrationStatusListCBClicked(this)"/></div>';
		}
	}

	function SISStatusText ( data )
	{
		let ret = '';
		switch ( data )
		{
			case '0': 	ret = Translate('To process');		break;
			case '1': 	ret = Translate('In progress');		break;
			case '2': 	ret = Translate('Done');			break;
			case '3': 	ret = Translate('Error');			break;
		}
		return ret;;
	}

	function SIntegrationStatusListRowCallback ( nRow, aData, iDisplayIndex )
	{
		if ( aData.status == 3 )	// Error
		{
			if ( aData.integration_error == 'INTEGRATE_SQL_FAILED' || aData.integration_error == 'INTEGRATE_MODALITYIDENTITY_NEW_FIRSTTIME' || aData.integration_error == 'INTEGRATE_MODALITYIDENTITY_NOT_CONFIGURED' )
				$(nRow).css ( 'background-color', '#F8D7DA');
			else
				$(nRow).css ( 'background-color', '#FFF3CD');
		}
	}

	function IntegrationListGetData ( sto_id )
	{
		for ( let i=0; i<GIntegrationStatusListCB.length; i++ )
		{
			if ( GIntegrationStatusListCB [i].sto_id == sto_id )
			{
				return GIntegrationStatusListCB [i];
			}
		}

		return null;
	}

	function OnIntegrationStatusListCBClicked ( e )
	{
		let rowIdx = $(e).data ( 'row_idx' );

		let sto_id = IdcSIntegrationStatusListDT.GetRowData ( rowIdx ).sto_id;

		for ( let i=0; i<GIntegrationStatusListCB.length; i++ )
		{
			if ( GIntegrationStatusListCB [i].sto_id == sto_id )
			{
				GIntegrationStatusListCB [i].to_send = e.checked;
				break;
			}
		}

		IntegrationStatusListUpdateInfo ();
	}

	function SIntegrationStatusListUpdateCheckbox ()
	{
		let rowsData 	= $('#IdcSIntegrationStatusListDT').DataTable().rows().data ();

		for ( let j=0; j<rowsData.length; j++ )
		{
			let sto_id = rowsData [j].sto_id;

			let data = IntegrationListGetData ( sto_id );
			if ( data != null )
			{
				if ( data.to_send 	)	document.getElementById ( "IdcIntegrationStatusListSendCB_" + j ).checked = true;	else document.getElementById ( "IdcIntegrationStatusListSendCB_" + j ).checked = false;
			}
		}

		IntegrationStatusListUpdateInfo ();
	}

	function SIntegrationStatusListDrawCallback ()
	{
		SIntegrationStatusListUpdateCheckbox ();
	}

	function SISSendingListLoad ()
	{
		GIntegrationStatusListCB = new Array ();

		$.post (
				"SubFW/database/settings/integration_status/get_integration_status_list.php",
				{
					recdate_from: 			$('#IdcSIntegrationStatusListDT_recdate_from').val (),
					recdate_to: 			$('#IdcSIntegrationStatusListDT_recdate_to').val (),
					stationname: 			$('#IdcSIntegrationStatusListDT_source').val (),
					modalitytitle: 			$('#IdcSIntegrationStatusListDT_modalitytitle').val (),
					patientname: 			$('#IdcSIntegrationStatusListDT_patientname').val (),
					status: 				$('#IdcSIntegrationStatusListDT_status').val (),
					integration_error: 		$('#IdcSIntegrationStatusListDT_integration_error').val (),
					integration_message: 	''
				},
				function (data)
				{
					for ( let i=0; i<data.results.length; i++ )
					{
						GIntegrationStatusListCB.push ( { sto_id: 	data.results[i].sto_id,
															to_send: false } );
					}
				}
			);
	}

	function SIntegrationStatusDTGetData ( d )
	{
		d.recdate_from			= IdcSIntegrationStatusListDT.GetFilterData ( 'recdate' ).from;
		d.recdate_to			= IdcSIntegrationStatusListDT.GetFilterData ( 'recdate' ).to;
		d.stationname			= IdcSIntegrationStatusListDT.GetFilterData ( 'source' );
		d.modalitytitle			= IdcSIntegrationStatusListDT.GetFilterData ( 'modalitytitle' );
		d.patientname			= IdcSIntegrationStatusListDT.GetFilterData ( 'patientname' );
		d.status				= IdcSIntegrationStatusListDT.GetFilterData ( 'status' );
		d.integration_error		= IdcSIntegrationStatusListDT.GetFilterData ( 'integration_error' );

		return $.extend( {}, d );
	}

	function SIntegrationStatusListDTRefresh ()		// Called by C_DataTable when filters changed
	{
		SISSendingListLoad ();
	}

	function SIntegrationStatusDTSelectChanged ( rows )
	{

	}

	function IntegrationStatusListUpdateInfo ()
	{
		console.log ( "IntegrationStatusListUpdateInfo..." );

		let nbCheck = 0;
		for ( let i=0; i<GIntegrationStatusListCB.length; i++ )
		{
			if ( GIntegrationStatusListCB [i].to_send == true )
			{
				nbCheck++;
			}
		}

		if ( nbCheck > 0 )
			$('#IdcSettingsIntegrationStatusReplay').prop ( 'disabled', false );
		else
			$('#IdcSettingsIntegrationStatusReplay').prop ( 'disabled', true );
	}

	function SIntegrationStatusReplaySelection ()
	{
		console.log ( "SIntegrationStatusReplaySelection..." );

		let sto_ids = [];
		for ( let i=0; i<GIntegrationStatusListCB.length; i++ )
		{
			if ( GIntegrationStatusListCB [i].to_send == true )
				sto_ids.push ( GIntegrationStatusListCB [i].sto_id );
		}

		console.log ( "sto_ids : ", sto_ids );

		$.post (
				"SubFW/database/settings/integration_status/integration_replay.php",
				{
					sto_ids: sto_ids
				},
				function (data)
				{
					console.log ( "Status : " + data.status );

					IdcSIntegrationStatusListDT.Refresh ();
				}
			);
	}

	function SIntegrationStatusReplay ()
	{
		MsgYesNo ( Translate ( "Replay selected elements ?" ), SIntegrationStatusReplaySelection );
	}



	function OnSISSendingListSendAllClicked ()
	{
		console.log ( "OnSISSendingListSendAllClicked..." );

		if ( $('#IdcSISSendingListSendAll').prop('checked') )
		{
			for ( let i=0; i<GIntegrationStatusListCB.length; i++ )
				GIntegrationStatusListCB [i].to_send = true;
		}
		else
		{
			for ( let i=0; i<GIntegrationStatusListCB.length; i++ )
				GIntegrationStatusListCB [i].to_send = false;
		}

		SIntegrationStatusListUpdateCheckbox ();
	}