	SettingsMasterSeriesDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSeCMasterSeriesDT.Properties (); }
		}
	];

	SSerieNRDDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSerieNRDDT.Properties (); }
		}
	];

	SSeCLinkedDescriptionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSeCLinkedDescriptionDT.Properties (); }
		}
	];

	

	let SeCLinkedDTInProgress;
	let SeCNotLinkedDTInProgress;

	
	function SSeCResData ( newRow, id, descr, mdescr, modal, date )
	{
		this.newRow  		= newRow;
		this.rserd_id		= id;
		this.description 	= descr;
		this.mdescription 	= mdescr;
		this.modality 		= modal;
		this.date 			= date;
	}

	let SSeCToLink 		= Array ();
	let SSeCToUnLink 	= Array ();
	

	function InitSettingsSeriesConfigurationPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsSeriesConfigurationPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsSeriesConfigurationPageInitialized', true );

		SeCLinkedDTInProgress  	= false;
		SeCNotLinkedDTInProgress = false;

		IdcSSeCMasterSeriesDT = new C_DataTable ();
		IdcSSeCMasterSeriesDT.DataSrcType		= 0;
		IdcSSeCMasterSeriesDT.Ident 			= 'IdcSSeCMasterSeriesDT';
		IdcSSeCMasterSeriesDT.Container 		= 'IdcSSeCMasterSeriesDTContainer';
		IdcSSeCMasterSeriesDT.CfgParameterName 	= 'SettingsMasterSeriesDTProperties';
		IdcSSeCMasterSeriesDT.DataSrc 			= 'SubFW/database/settings/serie/GetMasterSeriesListDT.php';
		IdcSSeCMasterSeriesDT.DataFct			= SSeCMasterSeriesDTGetData;
		IdcSSeCMasterSeriesDT.SetColReorder 	( false );
		IdcSSeCMasterSeriesDT.OnSelectChanged	( SSeCMasterSeriesDTSelectChanged );

		IdcSSeCMasterSeriesDT.AddColumn ( 'mserd_id',					'mserd_id',	 		0, false,  0,  50,   false, '', 				'' );
		IdcSSeCMasterSeriesDT.AddColumn ( Translate('Type'),			'type',				1, true,   1, '10%', true,  '', 				'' );
		IdcSSeCMasterSeriesDT.AddColumn ( Translate('Description'),		'description',		1, true,   2, '52%', true,  '', 				'' );
		IdcSSeCMasterSeriesDT.AddColumn ( Translate('Anatomic region'),	'anatomicregion',	1, true,   3, '38%', true,  '', 				'' );

		const typeList = [
			{ id: '',	label: Translate('All')},
			{ id: 'CT',	label: 'CT'},
			{ id: 'MG',	label: 'MG'},
			{ id: 'NM',	label: 'NM'},
			{ id: 'XA',	label: 'XA'},
			{ id: 'RX',	label: 'RX'}
		];

		IdcSSeCMasterSeriesDT.ColumnFilter ( 'type',		 	'combo' , typeList );
		IdcSSeCMasterSeriesDT.ColumnFilter ( 'description', 	'text' );
		IdcSSeCMasterSeriesDT.ColumnFilter ( 'anatomicregion', 	'text' );
		
		IdcSSeCMasterSeriesDT.LoadUserCfg ( G_USE_ID );

		IdcSSeCLinkedDescriptionDT = new C_DataTable ();
		IdcSSeCLinkedDescriptionDT.DataSrcType		= 0;
		IdcSSeCLinkedDescriptionDT.Ident 			= 'IdcSSeCLinkedDescriptionDT';
		IdcSSeCLinkedDescriptionDT.Container 		= 'IdcSSeCLinkedDescriptionDTContainer';
		IdcSSeCLinkedDescriptionDT.CfgParameterName = 'SSeCLinkedDescriptionDTProperties';
		IdcSSeCLinkedDescriptionDT.DataSrc 			= 'SubFW/database/settings/serie/seriem_description_linked1.php';
		IdcSSeCLinkedDescriptionDT.DataFct			= SSeCLinkedDescriptionDTGetData;
		IdcSSeCLinkedDescriptionDT.DrawCallbackFct	= SSeCLinkedDescriptionDTDrawCB;
		IdcSSeCLinkedDescriptionDT.RowCallbackFct 	= SSeCLinkedRowCB;
		IdcSSeCLinkedDescriptionDT.OnDClickFct		= SSeCLinkedDClick;

		IdcSSeCLinkedDescriptionDT.AddColumn ( 'rserd_id',						'rserd_id', 		0, false,   0,  50, false,  	'', '' );
		IdcSSeCLinkedDescriptionDT.AddColumn ( 'mserd_id',						'mserd_id', 		0, false,   1,  50, false,  	'', '' );
		IdcSSeCLinkedDescriptionDT.AddColumn ( 'newRow',						'newrow', 			0, false,   2,  50, false,  	'', '' );
		IdcSSeCLinkedDescriptionDT.AddColumn ( Translate('Description'),		'description',		1, true,   3,  '40%', true,  	'',	'' );
		IdcSSeCLinkedDescriptionDT.AddColumn ( Translate('Master serie'),		'mdescription',		1, true,   4,  '40%', true,  	'',	'' );
		IdcSSeCLinkedDescriptionDT.AddColumn ( Translate('Modality'),			'name',				1, true,   5,  '20%', true,  	'',	'' );

		IdcSSeCLinkedDescriptionDT.ColumnFilter ( 'description', 	'text' );
		IdcSSeCLinkedDescriptionDT.ColumnFilter ( 'mdescription',	'text' );
		IdcSSeCLinkedDescriptionDT.ColumnFilter ( 'modality',		'text' );


		IdcSSeCNotLinkedDescriptionDT = new C_DataTable ();
		IdcSSeCNotLinkedDescriptionDT.DataSrcType		= 0;
		IdcSSeCNotLinkedDescriptionDT.Ident 			= 'IdcSSeCNotLinkedDescriptionDT';
		IdcSSeCNotLinkedDescriptionDT.Container 		= 'IdcSSeCNotLinkedDescriptionDTContainer';
		IdcSSeCNotLinkedDescriptionDT.CfgParameterName  = 'SSeCNotLinkedDescriptionDTProperties';
		IdcSSeCNotLinkedDescriptionDT.DataSrc 			= 'SubFW/database/settings/serie/seriem_description_linked1.php';
		IdcSSeCNotLinkedDescriptionDT.DataFct			= SSeCNotLinkedDescriptionDTGetData;
		IdcSSeCNotLinkedDescriptionDT.DrawCallbackFct	= SSeCNotLinkedDescriptionDTDrawCB;
		IdcSSeCNotLinkedDescriptionDT.RowCallbackFct 	= SSeCNotLinkedRowCB;
		IdcSSeCNotLinkedDescriptionDT.OnDClickFct		= SSeCNotLinkedDClick;

		IdcSSeCNotLinkedDescriptionDT.AddColumn ( 'rserd_id',					'rserd_id', 		0, false,  	0,  50, 	false,  	'', '' );
		IdcSSeCNotLinkedDescriptionDT.AddColumn ( 'mserd_id',					'mserd_id', 		0, false,  	1,  50, 	false,  	'', '' );
		IdcSSeCNotLinkedDescriptionDT.AddColumn ( 'newRow',						'newrow', 			0, false,    2,  50, 	false,  	'', '' );
		IdcSSeCNotLinkedDescriptionDT.AddColumn ( Translate('Description'),		'description',		1, true,    3,  '40%', 	 true,  	'',	'' );
		IdcSSeCNotLinkedDescriptionDT.AddColumn ( Translate('Master serie'),	'mdescription',		1, true,    4,  '40%', 	 true,  	'',	'' );
		IdcSSeCNotLinkedDescriptionDT.AddColumn ( Translate('Modality'),		'name',				1, true,    5,  '20%', 	 true,  	'',	'' );
		IdcSSeCNotLinkedDescriptionDT.AddColumn ( Translate('Date'),			'date',				1, true,    6,  '15%', 	 true,  	'',	'', DICOMDate2StdDateFR );

		IdcSSeCNotLinkedDescriptionDT.ColumnFilter ( 'description', 	'text' );
		IdcSSeCNotLinkedDescriptionDT.ColumnFilter ( 'mdescription',	'text' );
		IdcSSeCNotLinkedDescriptionDT.ColumnFilter ( 'modality',		'text' );

		// NRD
		IdcSSerieNRDDT = new C_DataTable ();
		IdcSSerieNRDDT.DataSrcType		= 0;
		IdcSSerieNRDDT.Ident 			= 'IdcSSerieNRDDT';
		IdcSSerieNRDDT.Container 		= 'IdcSSerieNRDDTContainer';
		IdcSSerieNRDDT.CfgParameterName = 'SettingsSerieDTProperties';
		IdcSSerieNRDDT.DataSrc 			= 'SubFW/database/settings/serie/GetMasterSeriesNRDDT.php';
		IdcSSerieNRDDT.DataFct			= SSerieNRDDTGetData;
		IdcSSerieNRDDT.SetColReorder 	( true );
		IdcSSerieNRDDT.OnSelectChanged	( SSerieNRDDTSelectChanged );

		IdcSSerieNRDDT.AddColumn ( 'nrd_id',					'nrd_id',	 		0, false,  0,  50,  false, '', 					'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Name'),			'inp_alertname',	1, true,   1, '30%', true,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Type'),			'type',			 	1, true,   2, '30%', true,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Value type'),		'valuetype',		1, true,   3, '30%', true,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Value'),			'inp_value',		1, true,   4, '30%', true,  'text-end',			'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Nb acqui.'),		'inp_nacquisition',	1, true,   5, '30%', true,  'text-end',			'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Age (year)'),		'age',				1, true,   6, '30%', true,  'text-center',		'' );
		IdcSSerieNRDDT.AddColumn ( Translate('Weight (kg)'),	'weight',			1, true,   7, '30%', true,  'text-center', 		'' );
		IdcSSerieNRDDT.AddColumn ( 'age_begin',					'age_begin',		1, false,  8, '30%', false,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( 'age_end',					'age_end',			1, false,  9, '30%', false,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( 'weight_begin',				'weight_begin',		1, false, 10, '30%', false,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( 'weight_end',				'weight_end',		1, false, 11, '30%', false,  '', 				'' );
		IdcSSerieNRDDT.AddColumn ( 'combo_valuetype',			'combo_valuetype',	1, false, 12, '30%', false,  '', 				'' );
		
		IdcSSerieNRDDT.LoadUserCfg ( G_USE_ID );
			
		$(document).ready(function () 
		{		
			IdcSSeCSplitter1_2 			= new C_Splitter ( "IdcSSeCSplitter1_2" 			);
			IdcSSeCSplitter3_4 			= new C_Splitter ( "IdcSSeCSplitter3_4" 			);

			IdcSSeCMasterSeriesDT.Create ();
			context.attach ( '#IdcSSeCMasterSeriesDT', SettingsMasterSeriesDTListMenu );
			IdcSSeCMasterSeriesDT.SetRowToSelect ( 'first_row' );

			IdcSSeCLinkedDescriptionDT.Create ();

			IdcSSeCNotLinkedDescriptionDT.Create ();

			IdcSSerieNRDDT.Create ();
			context.attach ( '#IdcSSerieNRDDT', SSerieNRDDTListMenu );

			document.getElementById ('IdcSSeCInformationTab').addEventListener ( 'shown.bs.tab', () => { SSeCInformationTabShown (); } );
			document.getElementById ('IdcSSeCLinkedDescriptionTab').addEventListener ( 'shown.bs.tab', () => { SSeCLinkedDescriptionTabShown (); } );
			document.getElementById ('IdcSSeCDRLTab').addEventListener ( 'shown.bs.tab', () => { SSeCDRLTabShown (); } );

			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SSeCMasterSeriesDTGetData ( d )
	{

		d.type 				= $('#IdcSSeCMasterSeriesDT_type').val ();
		d.description 		= $('#IdcSSeCMasterSeriesDT_description').val ();
		d.anatomicregion 	= $('#IdcSSeCMasterSeriesDT_anatomicregion').val ();

		return $.extend( {}, d );
	}

	function SSeCMasterSeriesDTSelectChanged ( rowsIdx )
	{
		console.log ( "SSeCMasterSeriesDTSelectChanged..." );

		let mserd_id  		= -1;
		let description 	= '';
		let anatomicregion 	= '';
		let type 			= '';

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
			mserd_id			= IdcSSeCMasterSeriesDT.GetRowData ( rowIdx ).mserd_id;
			description			= IdcSSeCMasterSeriesDT.GetRowData ( rowIdx ).description;
			anatomicregion		= IdcSSeCMasterSeriesDT.GetRowData ( rowIdx ).anatomicregion;
			type				= IdcSSeCMasterSeriesDT.GetRowData ( rowIdx ).type;
		}

		$('#IdcSSeCInformationDiv').data ( 'id', mserd_id );
		$('#IdcSSeCMSDescription').val ( description );
		$('#IdcSSeCMSAnatomicRegion').val ( anatomicregion );
		$('#IdcSSeCMSType').val ( type );

		if ( document.getElementById ( 'IdcSSeCLinkedDescriptionPanel').checkVisibility () == true )
		{
			IdcSSeCLinkedDescriptionDT.RealRefresh ();
			IdcSSeCNotLinkedDescriptionDT.RealRefresh ();

			// FillSerieLinkedDescriptionDT ();
			// FillSerieNotLinkedDescriptionDT ();
		}

		if ( document.getElementById ( 'IdcSSeCDRLPanel').checkVisibility () == true )
		{
			IdcSSerieNRDDT.Refresh ();
		}
	}

	function OnSSeCMasterStudySaveOK ( response )
	{
		console.log ( "OnSSeCMasterStudySaveOK..." );
		console.log ( " response : " + response );
		WaitingStop ();

		if ( response != '-1')
		{
			IdcSSeCMasterSeriesDT.SetRowToSelect ( 'mserd_id', response );
			IdcSSeCMasterSeriesDT.Refresh ();
		}
		else
			OnSSeCMasterStudySaveError ();
	}

	
	function OnSSeCMasterStudySaveError ()
	{
		console.log ( "OnSSeCMasterStudySaveError..." );
		WaitingStop ();

		MsgWarning ( Translate("Unable to save master serie !!!") );	
	}
	
	function SSeCMasterStudySave ()
	{	
		let mserd_id 		= $('#IdcSSeCInformationDiv').data ( 'id' );
		let description		= $('#IdcSSeCMSDescription').val ();
		let anatomicregion	= $('#IdcSSeCMSAnatomicRegion').val ();
		let type  			= $('#IdcSSeCMSType').val ();
		

		let params = "mserd_id=" + mserd_id;
		params += "&description=" + description;
		params += "&anatomicregion=" + anatomicregion;
		params += "&type=" + type;
		params += "&ri=0";
		WaitingStart ( "Save in progress..." )
		PostASyncData ( "SubFW/database/settings/serie/save_master_serie.php", params, 'application/x-www-form-urlencoded', OnSSeCMasterStudySaveOK, OnSSeCMasterStudySaveError );
	}

	function SSeCMasterStudyAdd ()
	{
		let params = "mserd_id=-1";

		PostASyncData ( "SubFW/database/settings/serie/save_master_serie.php", params, 'application/x-www-form-urlencoded', OnSSeCMasterStudySaveOK, OnSSeCMasterStudySaveError );
	}

	
	function SSeCMasterStudyDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/settings/serie/delete_master_serie.php";
		data.RequestData	= "mserd_id";
		data.DTColIdent		= "mserd_id";
		data.NoSelectedMsg 	= Translate ( "No master serie selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected master serie ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete master serie !!!" );

		IdcSSeCMasterSeriesDT.DeleteSelectedRow ( data );
	}



	// Linked description
	function SSeCLinkedDescriptionSave ()
	{

	}



	function FillSerieLinkedDescriptionDT ()
	{
		console.log ( "FillSerieLinkedDescriptionDT..." );

		let idcDT = $('#IdcSSeCLinkedDescriptionDT').DataTable();

		idcDT.clear ();
		
		WaitingStart ( Translate ('Request in progress. Please wait.') );
		SeCLinkedDTInProgress = true;

		$.post (
			"./SubFW/database/settings/serie/seriem_description_linked.php",
			{
				linked: 1,
				mserdid: $('#IdcSSeCInformationDiv').data ( 'id' )
			},
			function ( data, status) 
			{
				let resultArray = Array ();
				console.log ("Linked data.length : " + data.length );
				for ( let i=0; i<data.length; i++ )
				{
					let rserd_id 		= data [i].rserd_id;
					let description  	= data [i].description;
					let mdescription  	= data [i].mdescription;
					let modality 		= data [i].modality;

					resultArray.push ( new SSeCResData ( 0, rserd_id, description, mdescription, modality, '' ) );
				}

				idcDT.rows.add ( resultArray ).draw();

				console.log ("Linked ended." );
			}
		);
	}

	function FillSerieNotLinkedDescriptionDT ()
	{
		console.log ( "FillSerieNotLinkedDescriptionDT..." );

		let idcDT = $('#IdcSSeCNotLinkedDescriptionDT').DataTable();

		idcDT.clear ();
		

		WaitingStart ( Translate ('Request in progress. Please wait.') );
		SeCNotLinkedDTInProgress = true;

		console.log ("Send request..." );
		/*
		$.post (
			"./SubFW/database/settings/serie/seriem_description_linked.php",
			{
				linked: 0,
				mserdid: $('#IdcSSeCInformationDiv').data ( 'id' ),
				datecode: document.querySelector('input[name="SeCNotLinkedDate"]:checked').value,
				withoutms: $('#IdcSeCNLWithoutMS').is(':checked')
			},
			function ( data, status) 
			{
				console.log (" Not linked data.length : " + data.length );
				let resultArray = Array ();

				for ( let i=0; i<data.length; i++ )
				{
					let rserd_id 		= data [i].rserd_id;
					let description  	= data [i].description;
					let mdescription  	= data [i].mdescription;
					let modality 		= data [i].modality;
					let date			= data [i].date;
					
					resultArray.push ( new SSeCResData ( 0, rserd_id, description, mdescription, modality, date ) );
				}

				idcDT.rows.add ( resultArray ).draw();

				console.log ("Not linked ended." );
			}
		);
		*/

		$.ajax (
		{
			url : "./SubFW/database/settings/serie/seriem_description_linked.php",
			type: 'POST',
			data: {
				linked: 0,
				mserdid: $('#IdcSSeCInformationDiv').data ( 'id' ),
				datecode: document.querySelector('input[name="SeCNotLinkedDate"]:checked').value,
				withoutms: $('#IdcSeCNLWithoutMS').is(':checked')
			},
			dataType: 'json',
			success: function () { console.log ("Success !!!"); },
			error: 	 function () { console.log ("Error !!!"); },

		});

	}

	function SSeCInformationTabShown () 
	{
	}

	function SSeCLinkedDescriptionTabShown ()
	{
		IdcSSeCLinkedDescriptionDT.Refresh ();

		// FillSerieLinkedDescriptionDT ();
		// FillSerieNotLinkedDescriptionDT ();
	}

	function SSeCDRLTabShown ()
	{
		let nrd_id = $('#IdcSSerieNRDDetailDiv').data ( 'nrd_id' );

		if ( nrd_id == -1 )
			IdcSSerieNRDDT.SetRowToSelect ( 'first_row' );

		IdcSSerieNRDDT.Refresh ();
	}

	function SSeCLinkedDescriptionDTDrawCB ()
	{
		SeCLinkedDTInProgress  	= false;
		if ( SeCNotLinkedDTInProgress == false )
			WaitingStop ();
	}

	function SSeCNotLinkedDescriptionDTDrawCB ()
	{
		SeCNotLinkedDTInProgress = false;

		if ( SeCLinkedDTInProgress == false )
			WaitingStop ();
	}

	function SSeCLinkedDClick ( rowIdx )
	{
		let rowData = IdcSSeCLinkedDescriptionDT.GetRowData ( rowIdx );

		let idcNotLinkedDT = $('#IdcSSeCNotLinkedDescriptionDT').DataTable();

		let newRow = Array ();

		newRow.push ( new SSeCResData ( (rowData.newRow == 0)? 1 : 0, rowData.rserd_id, rowData.description, rowData.mdescription, rowData.modality ) );

		idcNotLinkedDT.rows.add ( newRow ).draw ();

		let idcLinkedDT = $('#IdcSSeCLinkedDescriptionDT').DataTable();
		idcLinkedDT.row ( rowIdx ).remove().draw();
	}

	function SSeCNotLinkedDClick ( rowIdx )
	{
		let rowData = IdcSSeCNotLinkedDescriptionDT.GetRowData ( rowIdx );
		/*
		console.log ( "Date : " + rowData.date );

		let idcLinkedDT = $('#IdcSSeCLinkedDescriptionDT').DataTable();

		let newRow = Array ();

		newRow.push ( new SSeCResData ( (rowData.newRow == 0)? 1 : 0, rowData.rserd_id, rowData.description, rowData.mdescription, rowData.modality ) );

		idcLinkedDT.rows.add ( newRow ).draw ();


		let idcNotLinkedDT = $('#IdcSSeCNotLinkedDescriptionDT').DataTable();
		idcNotLinkedDT.row ( rowIdx ).remove().draw();
		*/

		console.log ( "RSerdID : " + rowData.rserd_id );

		SSeCToLink.push ( new SSeCResData ( (rowData.newRow == 0)? 1 : 0, rowData.rserd_id, rowData.description, rowData.mdescription, rowData.modality ) );
	}

	function SSeCLinkedRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newRow == 1 )
		{
			$(nRow).css ( 'background-color', '#00FF00');
		}

	}

	function SSeCNotLinkedRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newRow == 1 )
		{
			$(nRow).css ( 'background-color', '#FF0000');
		}

	}

	function SSeCNotLinkedDateChanged ()
	{
		console.log ( "MS : " + $('#IdcSeCNLWithoutMS').is (":checked") );

		FillSerieNotLinkedDescriptionDT ();		
	}




	function SSeCLinkedDescriptionDTGetData ( d )
	{
		d.linked 			= 1;
		d.mserdid 	 		= $('#IdcSSeCInformationDiv').data ( 'id' );

		d.union 			= (SSeCToLink.length > 0 )? SSeCToLink[0].rserd_id : '';

		return $.extend( {}, d );	
	}

	function SSeCNotLinkedDescriptionDTGetData ( d )
	{
		d.linked 			= 0;
		d.mserdid 	 		= $('#IdcSSeCInformationDiv').data ( 'id' );

		return $.extend( {}, d );	
	}
	




	// #################################################################################
	// NRD
	//

	function SSerieNRDDTGetData ( d )
	{
		console.log ( "SSerieNRDDTGetData..." );

		d.mserid = $('#IdcSSeCInformationDiv').data ( 'id' );

		console.log ( " d.mserid : " + d.mserid );

		return $.extend( {}, d );
	}

	function SSerieNRDDTSelectChanged ( rowsIdx )
	{
		let nrd_id			= -1;
		let name 			= "";
		let age_begin		= "";
		let age_end			= "";
		let weight_begin	= "";
		let weight_end		= "";
		let nb_acqui 		= "";
		let type 			= "";
		let value_type		= "";
		let value 			= "";
		
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			nrd_id			= IdcSSerieNRDDT.GetRowData ( rowIdx ).nrd_id;
			name			= IdcSSerieNRDDT.GetRowData ( rowIdx ).inp_alertname;
			age_begin		= IdcSSerieNRDDT.GetRowData ( rowIdx ).age_begin;
			age_end			= IdcSSerieNRDDT.GetRowData ( rowIdx ).age_end;
			weight_begin	= IdcSSerieNRDDT.GetRowData ( rowIdx ).weight_begin;
			weight_end		= IdcSSerieNRDDT.GetRowData ( rowIdx ).weight_end;
			nb_acqui 		= IdcSSerieNRDDT.GetRowData ( rowIdx ).inp_nacquisition;
			type 			= IdcSSerieNRDDT.GetRowData ( rowIdx ).type;
			value_type		= IdcSSerieNRDDT.GetRowData ( rowIdx ).combo_valuetype;
			value			= IdcSSerieNRDDT.GetRowData ( rowIdx ).inp_value;
		}

		$('#IdcSSerieNRDDetailDiv').data ( 'nrd_id', nrd_id );

		$('#IdcSSerieNRDName').val 	( name );
		$('#IdcSSerieNRDType').val 	( value_type );
		$('#IdcSSerieNRDValue').val ( value );
		$('#IdcSSerieNRDNumAcqui').val ( nb_acqui );
		$('#IdcSSerieNRDAgeBegin').val ( age_begin);
		$('#IdcSSerieNRDAgeEnd').val ( age_end);
		$('#IdcSSerieNRDWeightBegin').val ( weight_begin);
		$('#IdcSSerieNRDWeightEnd').val ( weight_end);
	}

	function OnSSerieNRDAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSSerieNRDDT.SetRowToSelect ( 'nrd_id', response );
			IdcSSerieNRDDT.Refresh ();
		}
		else
			OnSSerieNRDAddError ();
	}

	function OnSSerieNRDAddError ()
	{
		MsgWarning ( Translate("Unable to add DRL !!!") );
	}

	function SSerieNRDAdd ()
	{
		console.log ( "SSerieNRDAdd..." );

		let link_id	= $('#IdcSSeCInformationDiv').data ( 'id' );
		let params  = "id=-1&link_id=" + link_id;
		PostASyncData ( "SubFW/database/settings/serie/save_nrd.php", params, 'application/x-www-form-urlencoded', OnSSerieNRDAddOK, OnSSerieNRDAddError );
	}

	function OnSSerieNRDDeleteOK ( data )
	{
		IdcSSerieNRDDT.SetRowToSelect ( 'first_row' );
		IdcSSerieNRDDT.Refresh ();
	}

	function OnSSerieNRDDeleteError ( data )
	{
		MsgWarning ( Translate("Unable to delete DRL !!!") );
	}

	function DeleteSSerieNRD ()
	{
		let nrd_id = $('#IdcSSerieNRDDetailDiv').data ( 'nrd_id' );

		const formData = new FormData();
        formData.append ( 'nrd_id', nrd_id );
		PostASyncData ( "SubFW/database/settings/serie/delete_nrd.php", formData, null, OnSSerieNRDDeleteOK, OnSSerieNRDDeleteError );
	}

	function SSerieNRDDelete ()
	{
		let nrd_id = $('#IdcSSerieNRDDetailDiv').data ( 'nrd_id' );

		if ( nrd_id != -1 )
			MsgYesNo ( Translate("Delete selected DRL ?"), DeleteSSerieNRD );
		else
			MsgWarning ( Translate("No DRL selected !!!") );
	}

	function SSerieNRDSave ()
	{
		const formData = new FormData();
        formData.append ( 'id', 				$('#IdcSSerieNRDDetailDiv').data ( 'nrd_id' )	);
        formData.append ( 'name',				$('#IdcSSerieNRDName').val 	()					);
        formData.append ( 'combo_valuetype',	$('#IdcSSerieNRDType').val 	()					);
        formData.append ( 'value',				$('#IdcSSerieNRDValue').val	()					);
        formData.append ( 'nb_acqui',			$('#IdcSSerieNRDNumAcqui').val	()				);
        formData.append ( 'age_begin',			$('#IdcSSerieNRDAgeBegin').val	()				);
        formData.append ( 'age_end',			$('#IdcSSerieNRDAgeEnd').val	()				);
        formData.append ( 'weight_begin',		$('#IdcSSerieNRDWeightBegin').val	()		);
        formData.append ( 'weight_end',			$('#IdcSSerieNRDWeightEnd').val	()				);

        PostASyncData ( "SubFW/database/settings/serie/save_nrd.php", formData, null, OnSSerieNRDAddOK, OnSSerieNRDAddError );
	}