	SSOPSOPListDTMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSOPSOPListDT.Properties (); }
		}
	];

	SSOPTagsLinkedDTMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSOPTagsLinkedDT.Properties (); }
		},
		{
			img: 'SubFW/bmp/edit_blue.png',
			text: 'Edit...',
			action: function(e, selector) { SSOPDICOMEdit (); }
		}
	];

	SSOPTagsNotLinkedDTMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSOPTagsNotLinkedDT.Properties (); }
		}
	];

	function InitSettingsSOPPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsSOPPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsSOPPageInitialized', true );

		IdcSSOPSOPListDT = new C_DataTable ();
		IdcSSOPSOPListDT.DataSrcType		= 0;
		IdcSSOPSOPListDT.Ident 				= 'IdcSSOPSOPListDT';
		IdcSSOPSOPListDT.Container 			= 'IdcSSOPSOPListDTContainer';
		IdcSSOPSOPListDT.CfgParameterName 	= 'SettingsSOPSOPListDTProperties';
		IdcSSOPSOPListDT.DataSrc 			= 'SubFW/database/settings/sop/GetSOPClassListDT.php';
		IdcSSOPSOPListDT.DataFct			= SSOPSOPListDTGetData;
		IdcSSOPSOPListDT.SetColReorder 	 ( true );
		IdcSSOPSOPListDT.OnSelectChanged ( SSOPSOPListDTSelectChanged );

		IdcSSOPSOPListDT.AddColumn ( 'id',						'id',	 				0, false,  0,  50,   false, '', 				'' );
		IdcSSOPSOPListDT.AddColumn ( 'group_id',				'group_id',				0, false,  1,  50,   false, '', 				'' );
		IdcSSOPSOPListDT.AddColumn ( Translate('Type'),			'sopuidtype',			1, true,   2, '10%', true,  'text-center',		'' );
		IdcSSOPSOPListDT.AddColumn ( Translate('UID'),			'sopuid',				1, true,   3, '10%', true,  '', 				'' );
		IdcSSOPSOPListDT.AddColumn ( Translate('Modality'),		'modalitytitle',		1, true,   4, '10%', true,  '', 				'' );
		IdcSSOPSOPListDT.AddColumn ( Translate('Description'),	'custom_description',	1, true,   5, '10%', true,  '', 				'' );
		IdcSSOPSOPListDT.AddColumn ( Translate('Group'),		'group_name',			1, true,   6, '10%', true,  '', 				'' );

		let typeList = [
			{id: 	'',		label: Translate('All') },
			{id: 	'CT',	label: 'CT' 	},
			{id: 	'DX',	label: 'DX' 	},
			{id: 	'MG',	label: 'MG' 	},
			{id: 	'MPPS',	label: 'MPPS' 	},
			{id: 	'MR',	label: 'MR' 	},
			{id: 	'SR',	label: 'SR' 	}
		];

		IdcSSOPSOPListDT.ColumnFilter ( 'sopuidtype',			'combo', typeList );
		IdcSSOPSOPListDT.ColumnFilter ( 'sopuid',				'text' );
		IdcSSOPSOPListDT.ColumnFilter ( 'custom_description',	'text' );

		IdcSSOPSOPListDT.LoadUserCfg ( G_USE_ID );
		

		IdcSSOPTagsLinkedDT = new C_DataTable ();
		IdcSSOPTagsLinkedDT.DataSrcType		= 0;
		IdcSSOPTagsLinkedDT.Ident 				= 'IdcSSOPTagsLinkedDT';
		IdcSSOPTagsLinkedDT.Container 			= 'IdcSSOPTagsLinkedDTContainer';
		IdcSSOPTagsLinkedDT.CfgParameterName 	= 'SettingsSOPTagsLinkedDTProperties';
		IdcSSOPTagsLinkedDT.DataSrc 			= 'SubFW/database/settings/sop/GetLinkedDICOMTagsListDT.php';
		IdcSSOPTagsLinkedDT.DataFct				= SSOPTagsLinkedDTGetData;
		IdcSSOPTagsLinkedDT.SetColReorder 	( true );
		IdcSSOPTagsLinkedDT.OnSelectChanged	( SSOPTagsLinkedDTSelectChanged );

		IdcSSOPTagsLinkedDT.AddColumn ( 'id',					'id',	 				0, false,  0,  50,   false, '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'group_id',				'group_id',				0, false,  1,  50,   false, '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Match ID',				'match_id',				0, false,  2,  50, 	 false,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( '',						'',						0, true,   3,  40,   false, '', 		'', SSOPShortcutDelete );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Storage ID',			'storage_id',			1, true,   4, '10%', true,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Tag',					'tag',					1, true,   5, '10%', true,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Condition',			'dicom_condition',		1, true,   6, '10%', true,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Description',			'description',			1, true,   7, '10%', true,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Order',				'extract_order',		1, true,   8, '10%', true,  'text-end',	'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Unit',					'unit',					1, true,   9, '10%', true,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'Parse',				'parse_function',		1, true,  10, '10%', true,  '', 		'' );
		IdcSSOPTagsLinkedDT.AddColumn ( 'CvtFactor',			'cvt_factor',			1, true,  11, '10%', true,  'text-end',	'' );

		IdcSSOPTagsLinkedDT.ColumnFilter ( 'tag' );
		IdcSSOPTagsLinkedDT.ColumnFilter ( 'description' );

		IdcSSOPTagsLinkedDT.LoadUserCfg ( G_USE_ID );


		IdcSSOPTagsNotLinkedDT = new C_DataTable ();
		IdcSSOPTagsNotLinkedDT.DataSrcType		= 0;
		IdcSSOPTagsNotLinkedDT.Ident 				= 'IdcSSOPTagsNotLinkedDT';
		IdcSSOPTagsNotLinkedDT.Container 			= 'IdcSSOPTagsNotLinkedDTContainer';
		IdcSSOPTagsNotLinkedDT.CfgParameterName 	= 'SettingsSOPTagsNotLinkedDTProperties';
		IdcSSOPTagsNotLinkedDT.DataSrc 				= 'SubFW/database/settings/sop/GetNotLinkedDICOMTagsListDT.php';
		IdcSSOPTagsNotLinkedDT.DataFct				= SSOPTagsNotLinkedDTGetData;
		IdcSSOPTagsNotLinkedDT.SetColReorder 	( true );
		IdcSSOPTagsNotLinkedDT.OnSelectChanged	( SSOPTagsNotLinkedDTSelectChanged );

		IdcSSOPTagsNotLinkedDT.AddColumn ( 'id',					'match_id',				0, false,  0,  50,   false, '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( '',						'',						0, true,   1,  40,   false, '', 		'', SSOPShortcutAdd );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Storage ID',			'storage_id',			1, true,   2, '10%', true,  '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Tag',					'tag',					1, true,   3, '10%', true,  '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Condition',				'condition',			1, true,   4, '10%', true,  '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Type',					'type',					1, true,   5, '10%', true,  'text-end',	'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Attribute',				'attribute',			1, true,   6, '10%', true,  '', 		'' );
		
		IdcSSOPTagsNotLinkedDT.ColumnFilter ( 'tag' );
		IdcSSOPTagsNotLinkedDT.ColumnFilter ( 'attribute' );


		IdcSSOPTagsNotLinkedDT.LoadUserCfg ( G_USE_ID );

					
		$(document).ready(function () 
		{		
			IdcSSOPSplitter1_2 			= new C_Splitter ( "IdcSSOPSplitter1_2" 			);
			IdcSSOPSplitter3_4 			= new C_Splitter ( "IdcSSOPSplitter3_4" 			);
			
			IdcSSOPSplitter1_2.LoadUserCfg		( G_USE_ID );
			IdcSSOPSplitter3_4.LoadUserCfg		( G_USE_ID );

			IdcSSOPSOPListDT.Create ();
			context.attach ( '#IdcSSOPSOPListDT', SSOPSOPListDTMenu );
			IdcSSOPSOPListDT.SetRowToSelect('first_row');

			IdcSSOPTagsLinkedDT.Create ();
			context.attach ( '#IdcSSOPTagsLinkedDT', SSOPTagsLinkedDTMenu );
			IdcSSOPTagsLinkedDT.SetRowToSelect('first_row');
			$('#' + IdcSSOPTagsLinkedDT.Ident +' tbody').on('click', '.SSOPDeleteShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnSOPDeleteShortcut ( tr );
			} );

			IdcSSOPTagsNotLinkedDT.Create ();
			context.attach ( '#IdcSSOPTagsNotLinkedDT', SSOPTagsNotLinkedDTMenu );
			IdcSSOPTagsNotLinkedDT.SetRowToSelect('first_row');
			$('#' + IdcSSOPTagsNotLinkedDT.Ident +' tbody').on('click', '.SSOPAddShortcut', function () 
			{
				let tr = $(this).closest('tr');

				OnSOPAddShortcut ( tr );
			} );

			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SSOPShortcutAdd ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SSOPAddShortcut imgclickable \" title=\"'+Translate ( 'Add' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/add_blue2.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}

	function SSOPShortcutDelete ()
	{
		let tmp  = '<div class="w-100 m-0 p-0 text-center"><img class=\"SSOPDeleteShortcut imgclickable \" title=\"'+Translate ( 'Delete' )+'\" src=\"'+eoDACS.ServerFolder+'/SubFW/bmp/trash.png\" style=\"height: 18px; width: auto;\"></img></div>';
		
		return tmp;
	}


	function SSOPSOPListDTGetData ( d )
	{
		d.sopuidtype 	= $('#IdcSSOPSOPListDT_sopuidtype' ).val ();
		d.sopuid 		= $('#IdcSSOPSOPListDT_sopuid').val ();
		d.description 	= $('#IdcSSOPSOPListDT_custom_description').val ();

		return $.extend( {}, d );
	}

	function SSOPSOPListDTSelectChanged ( rowsIdx )
	{
		IdcSSOPTagsLinkedDT.RealRefresh ();
		IdcSSOPTagsNotLinkedDT.RealRefresh ();
	}

	function SSOPTagsLinkedDTGetData ( d )
	{
		let selRowData = IdcSSOPSOPListDT.GetSelectedRowData ();
		if ( selRowData != null )
		{
			d.sopuid 		= selRowData.sopuid;
			d.modalitytitle = selRowData.modalitytitle;
			d.group_id		= selRowData.group_id;
		}
		
		d.tag 			= $('#IdcSSOPTagsLinkedDT_tag').val ();
		d.description	= $('#IdcSSOPTagsLinkedDT_description').val ();

		return $.extend( {}, d );
	}

	function SSOPTagsLinkedDTSelectChanged ( rowsIdx )
	{
	}


	function SSOPTagsNotLinkedDTGetData ( d )
	{
		console.log ( "SSOPTagsNotLinkedDTGetData..." );
		
		let selRowData = IdcSSOPSOPListDT.GetSelectedRowData ();
		if ( selRowData != null )
		{
			d.sopuid 		= selRowData.sopuid;
			d.modalitytitle = selRowData.modalitytitle;

			d.tag 		= $('#IdcSSOPTagsNotLinkedDT_tag').val ();
			d.attribute = $('#IdcSSOPTagsNotLinkedDT_attribute').val ();
		}

		return $.extend( {}, d );
	}

	function SSOPTagsNotLinkedDTSelectChanged ( rowsIdx )
	{

	}

	function SSOPDICOMEdit ()
	{
		console.log ( "SSOPDICOMEdit..." );
	}

	/*
	IdcSSOPTagsNotLinkedDT.AddColumn ( 'id',					'id',	 				0, false,  0,  50,   false, '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( '',						'',						0, true,   1,  40,   false, '', 		'', SSOPShortcutAdd );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Storage ID',			'storage_id',			1, true,   2, '10%', true,  '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Tag',					'tag',					1, true,   3, '10%', true,  '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Condition',				'condition',			1, true,   4, '10%', true,  '', 		'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Type',					'type',					1, true,   5, '10%', true,  'text-end',	'' );
		IdcSSOPTagsNotLinkedDT.AddColumn ( 'Attribute',				'attribute',			1, true,   6, '10%', true,  '', 		'' );
	*/

	function OnSOPAddShortcut ( tr )
	{
		console.log ( 'OnSOPAddShortcut...' );
		let sopuid = '';
		let modalitytitle = '';
		let group_id = '';
		let selRowData = IdcSSOPSOPListDT.GetSelectedRowData ();
		if ( selRowData != null )
		{
			sopuid 			= selRowData.sopuid;
			modalitytitle 	= selRowData.sopuid;
			group_id 		= selRowData.group_id;

			let row = $('#'+IdcSSOPTagsNotLinkedDT.Ident).DataTable ().row ( tr );

			$.post (
				"SubFW/database/settings/sop/add_dicom_tag.php",
				{
					dicom_id: 		row.data().dicom_id,
					group_id: 		group_id,
					modalitytitle: 	modalitytitle,
					sopuid: 		sopuid
				},
				function (data)
				{
					if ( data.status == 'OK')
					{
						IdcSSOPTagsLinkedDT.Refresh ();
						IdcSSOPTagsNotLinkedDT.Refresh ();
					}
					else
						MsgWarning ( Translate ("Unable to save modality !!!") );
				}
			);
		}
	}

	function OnSOPDeleteShortcut ( tr )
	{
		console.log ( 'OnSOPDeleteShortcut...' );
		let sopuid = '';
		let modalitytitle = '';
		let group_id = '';

		let row = $('#'+IdcSSOPTagsLinkedDT.Ident).DataTable ().row ( tr );

		$.post (
			"SubFW/database/settings/sop/delete_dicom_tag.php",
			{
				init_id: 		row.data().init_id
			},
			function (data)
			{
				if ( data.status == 'OK')
				{
					IdcSSOPTagsLinkedDT.Refresh ();
					IdcSSOPTagsNotLinkedDT.Refresh ();
				}
				else
					MsgWarning ( Translate ("Unable to save modality !!!") );
			}
		);
	}