	SettingsMasterStudiesDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSCMasterStudiesDT.Properties (); }
		}
	];

	SStudyNRDDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSStudyNRDDT.Properties (); }
		}
	];

	SSCLinkedDescriptionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSCLinkedDescriptionDT.Properties (); }
		}
	];

	SSCNotLinkedDescriptionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSSCNotLinkedDescriptionDT.Properties (); }
		}
	];


	
	let SCLinkedDTInProgress;
	let SCNotLinkedDTInProgress;

	function SSCLinkedDescriptionFilter() 
	{
		console.log ( "SSCLinkedDescriptionFilter...");

		IdcSSCLinkedDescriptionDT.Refresh ();
	}

	/*
	function SSCNotLinkedDescriptionFilter() 
	{
		console.log ( "SSCNotLinkedDescriptionFilter...");

		IdcSSCNotLinkedDescriptionDT.Refresh ();
	}
	*/


	function SSCResData ( newrow, mstud_id, id, descr, mdescr, modal, date )
	{
		this.newrow  		= newrow;
		this.mstud_id		= mstud_id;
		this.rstud_id		= id;
		this.description 	= descr;
		this.mdescription 	= mdescr;
		this.modality 		= modal;
		this.date 			= date;
	}

	let SSCToLink 		= Array ();
	let SSCToUnLink 	= Array ();

	function InitSettingsStudiesConfigurationPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsStudiesConfigurationPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsStudiesConfigurationPageInitialized', true );

		SCLinkedDTInProgress  	= false;
		SCNotLinkedDTInProgress = false;

		IdcSSCMasterStudiesDT = new C_DataTable ();
		IdcSSCMasterStudiesDT.DataSrcType		= 0;
		IdcSSCMasterStudiesDT.Ident 			= 'IdcSSCMasterStudiesDT';
		IdcSSCMasterStudiesDT.Container 		= 'IdcSSCMasterStudiesDTContainer';
		IdcSSCMasterStudiesDT.CfgParameterName 	= 'SettingsMasterStudiesDTProperties';
		IdcSSCMasterStudiesDT.DataSrc 			= 'SubFW/database/settings/study/GetMasterStudiesListDT.php';
		IdcSSCMasterStudiesDT.DataFct			= SSCMasterStudiesDTGetData;
		IdcSSCMasterStudiesDT.SetColReorder 	( true );
		IdcSSCMasterStudiesDT.OnSelectChanged	( SSCMasterStudiesDTSelectChanged );

		IdcSSCMasterStudiesDT.AddColumn ( 'mstud_id',					'mstud_id',	 		0, false,  0,  50,   false, '', 				'' );
		IdcSSCMasterStudiesDT.AddColumn ( Translate('Type'),			'type',				1, true,   1, '10%', true,  'text-center', 				'' );
		IdcSSCMasterStudiesDT.AddColumn ( Translate('Description'),		'description',		1, true,   2, '52%', true,  '', 				'' );
		IdcSSCMasterStudiesDT.AddColumn ( Translate('Anatomic region'),	'anatomicregion',	1, true,   3, '38%', true,  '', 				'' );

		const typeList = [
			{ id: '',	label: Translate('All')},
			{ id: 'CT',	label: 'CT'},
			{ id: 'MG',	label: 'MG'},
			{ id: 'NM',	label: 'NM'},
			{ id: 'XA',	label: 'XA'},
			{ id: 'RX',	label: 'RX'}
		];

		IdcSSCMasterStudiesDT.ColumnFilter ( 'type',		 	'combo', typeList  );
		IdcSSCMasterStudiesDT.ColumnFilter ( 'description', 	'text' );
		IdcSSCMasterStudiesDT.ColumnFilter ( 'anatomicregion', 	'text' );
		
		IdcSSCMasterStudiesDT.LoadUserCfg ( G_USE_ID );


		IdcSSCLinkedDescriptionDT = new C_DataTable ();
		IdcSSCLinkedDescriptionDT.DataSrcType		= 0;
		IdcSSCLinkedDescriptionDT.Ident 			= 'IdcSSCLinkedDescriptionDT';
		IdcSSCLinkedDescriptionDT.Container 		= 'IdcSSCLinkedDescriptionDTContainer';
		IdcSSCLinkedDescriptionDT.CfgParameterName 	= 'SSCLinkedDescriptionDTProperties';
		IdcSSCLinkedDescriptionDT.DataSrc 			= 'SubFW/database/settings/study/studym_description_linked1.php';
		IdcSSCLinkedDescriptionDT.DataFct			= SSCLinkedDescriptionDTGetData;
		IdcSSCLinkedDescriptionDT.DrawCallbackFct	= SSCLinkedDescriptionDTDrawCB;
		IdcSSCLinkedDescriptionDT.RowCallbackFct 	= SSCLinkedRowCB;
		IdcSSCLinkedDescriptionDT.OnDClickFct		= SSCLinkedDClick;

		IdcSSCLinkedDescriptionDT.AddColumn ( 'rstud_id',						'rstud_id', 		0, false,  	0,  50, false,  	'', '' );
		IdcSSCLinkedDescriptionDT.AddColumn ( 'mstud_id',						'mstud_id', 		0, false,  	1,  50, false,  	'', '' );
		IdcSSCLinkedDescriptionDT.AddColumn ( 'newRow',							'newrow', 			0, false,  	2,  50, false,  	'', '' );
		IdcSSCLinkedDescriptionDT.AddColumn ( Translate('Description'),			'description',		1, true,   	3,  '40%', true,  	'',	'' );
		IdcSSCLinkedDescriptionDT.AddColumn ( Translate('Master study'),		'mdescription',		1, true,   	4,  '40%', true,  	'',	'' );
		IdcSSCLinkedDescriptionDT.AddColumn ( Translate('Modality'),			'name',				1, true,   	5,  '20%', true,  	'',	'' );

		IdcSSCLinkedDescriptionDT.ColumnFilter ( 'description', 	'text' );
		IdcSSCLinkedDescriptionDT.ColumnFilter ( 'mdescription',	'text' );
		IdcSSCLinkedDescriptionDT.ColumnFilter ( 'modality',		'text' );



		IdcSSCNotLinkedDescriptionDT = new C_DataTable ();
		IdcSSCNotLinkedDescriptionDT.DataSrcType		= 0;
		IdcSSCNotLinkedDescriptionDT.Ident 				= 'IdcSSCNotLinkedDescriptionDT';
		IdcSSCNotLinkedDescriptionDT.Container 			= 'IdcSSCNotLinkedDescriptionDTContainer';
		IdcSSCNotLinkedDescriptionDT.CfgParameterName 	= 'SSCNotLinkedDescriptionDTProperties';
		IdcSSCNotLinkedDescriptionDT.DataSrc 			= 'SubFW/database/settings/study/studym_description_linked1.php';
		IdcSSCNotLinkedDescriptionDT.DataFct			= SSCNotLinkedDescriptionDTGetData;
		IdcSSCNotLinkedDescriptionDT.DrawCallbackFct	= SSCNotLinkedDescriptionDTDrawCB;
		IdcSSCNotLinkedDescriptionDT.RowCallbackFct 	= SSCNotLinkedRowCB;
		IdcSSCNotLinkedDescriptionDT.OnDClickFct		= SSCNotLinkedDClick;

		IdcSSCNotLinkedDescriptionDT.AddColumn ( 'rstud_id',					'rstud_id', 		0, false,   0,  50, 	false,  '', '' );
		IdcSSCNotLinkedDescriptionDT.AddColumn ( 'mstud_id',					'mstud_id', 		0, false,  	1,  50, 	false,  '', '' );
		IdcSSCNotLinkedDescriptionDT.AddColumn ( 'newRow',						'newrow',	 		0, false,   2,  50, 	false,  '', '' );
		IdcSSCNotLinkedDescriptionDT.AddColumn ( Translate('Description'),		'description',		1, true,    3,  '35%', 	true,  	'',	'' );
		IdcSSCNotLinkedDescriptionDT.AddColumn ( Translate('Master study'),		'mdescription',		1, true,    4,  '30%', 	true,  	'',	'' );
		IdcSSCNotLinkedDescriptionDT.AddColumn ( Translate('Modality'),			'modalitytitle',	1, true,    5,  '20%', 	true,  	'',	'' );
		IdcSSCNotLinkedDescriptionDT.AddColumn ( Translate('Date'),				'date',				1, true,    6,  '15%', 	true,  	'text-center',	'', DICOMDate2StdDateFR );

		IdcSSCNotLinkedDescriptionDT.ColumnFilter ( 'description', 	'text' );
		IdcSSCNotLinkedDescriptionDT.ColumnFilter ( 'mdescription',	'text' );
		IdcSSCNotLinkedDescriptionDT.ColumnFilter ( 'modality',		'text' );




		// NRD
		IdcSStudyNRDDT = new C_DataTable ();
		IdcSStudyNRDDT.DataSrcType		= 0;
		IdcSStudyNRDDT.Ident 			= 'IdcSStudyNRDDT';
		IdcSStudyNRDDT.Container 		= 'IdcSStudyNRDDTContainer';
		IdcSStudyNRDDT.CfgParameterName = 'SettingsUserAccessDTProperties';
		IdcSStudyNRDDT.DataSrc 			= 'SubFW/database/settings/study/GetMasterStudiesNRDDT.php';
		IdcSStudyNRDDT.DataFct			= SStudyNRDDTGetData;
		IdcSStudyNRDDT.SetColReorder 	( true );
		IdcSStudyNRDDT.OnSelectChanged	( SStudyNRDDTSelectChanged );

		IdcSStudyNRDDT.AddColumn ( 'nrd_id',					'nrd_id',	 		0, false,  0,  50,  false, '', 					'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Name'),			'inp_alertname',	1, true,   1, '30%', true,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Type'),			'type',			 	1, true,   2, '30%', true,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Value type'),		'valuetype',		1, true,   3, '30%', true,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Value'),			'inp_value',		1, true,   4, '30%', true,  'text-end',			'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Nb acqui.'),		'inp_nacquisition',	1, true,   5, '30%', true,  'text-end',			'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Age (year)'),		'age',				1, true,   6, '30%', true,  'text-center',		'' );
		IdcSStudyNRDDT.AddColumn ( Translate('Weight (kg)'),	'weight',			1, true,   7, '30%', true,  'text-center', 		'' );
		IdcSStudyNRDDT.AddColumn ( 'age_begin',					'age_begin',		1, false,  8, '30%', false,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( 'age_end',					'age_end',			1, false,  9, '30%', false,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( 'weight_begin',				'weight_begin',		1, false, 10, '30%', false,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( 'weight_end',				'weight_end',		1, false, 11, '30%', false,  '', 				'' );
		IdcSStudyNRDDT.AddColumn ( 'combo_valuetype',			'combo_valuetype',	1, false, 12, '30%', false,  '', 				'' );
		
		
		
		IdcSStudyNRDDT.LoadUserCfg ( G_USE_ID );
			
		$(document).ready(function () 
		{		
			IdcSSCSplitter1_2 			= new C_Splitter ( "IdcSSCSplitter1_2" 			);
			IdcSSCSplitter3_4 			= new C_Splitter ( "IdcSSCSplitter3_4" 			);

			IdcSSCMasterStudiesDT.Create ();
			context.attach ( '#IdcSSCMasterStudiesDT', SettingsMasterStudiesDTListMenu );
			IdcSSCMasterStudiesDT.SetRowToSelect ( 'first_row' );

			IdcSSCLinkedDescriptionDT.Create ();
			context.attach ( '#IdcSSCLinkedDescriptionDT', SSCLinkedDescriptionDTListMenu );

			IdcSSCNotLinkedDescriptionDT.Create ();
			context.attach ( '#IdcSSCNotLinkedDescriptionDT', SSCNotLinkedDescriptionDTListMenu );

			IdcSStudyNRDDT.Create ();
			context.attach ( '#IdcSStudyNRDDT', SStudyNRDDTListMenu );

			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SSCMasterStudiesDTGetData ( d )
	{
		d.type 				= $('#IdcSSCMasterStudiesDT_type').val ();
		d.description 		= $('#IdcSSCMasterStudiesDT_description').val ();
		d.anatomicregion 	= $('#IdcSSCMasterStudiesDT_anatomicregion').val ();

		return $.extend( {}, d );
	}

	function SSCMasterStudiesDTSelectChanged ( rowsIdx )
	{
		console.log ( "SSCMasterStudiesDTSelectChanged..." );

		let mstud_id  		= -1;
		let description 	= '';
		let anatomicregion 	= '';
		let type 			= '';

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
			mstud_id			= IdcSSCMasterStudiesDT.GetRowData ( rowIdx ).mstud_id;
			description			= IdcSSCMasterStudiesDT.GetRowData ( rowIdx ).description;
			anatomicregion		= IdcSSCMasterStudiesDT.GetRowData ( rowIdx ).anatomicregion;
			type				= IdcSSCMasterStudiesDT.GetRowData ( rowIdx ).type;
		}

		$('#IdcSSCInformationDiv').data ( 'id', mstud_id );
		$('#IdcSSCMSDescription').val ( description );
		$('#IdcSSCMSAnatomicRegion').val ( anatomicregion );
		$('#IdcSSCMSType').val ( type );

		if ( document.getElementById ( 'IdcSSCLinkedDescriptionPanel').checkVisibility () == true )
		{
			SSCToLink 		= Array ();
			SSCToUnLink 	= Array ();

			IdcSSCLinkedDescriptionDT.RealRefresh ();
			IdcSSCNotLinkedDescriptionDT.RealRefresh ();

			IdcSStudyNRDDT.Refresh ();

			// FillLinkedDescriptionDT ();
			// FillNotLinkedDescriptionDT ();
		}

		if ( document.getElementById ( 'IdcSSCDRLPanel').checkVisibility () == true )
		{
			IdcSStudyNRDDT.RealRefresh ();
		}
	}

	function OnSSCMasterStudySaveOK ( response )
	{
		console.log ( "OnSSCMasterStudySaveOK..." );
		console.log ( " response : " + response );
		WaitingStop ();

		if ( response != '-1')
		{
			IdcSSCMasterStudiesDT.SetRowToSelect ( 'mstud_id', response );
			IdcSSCMasterStudiesDT.Refresh ();
		}
		else
			OnSSCMasterStudySaveError ();
	}

	
	function OnSSCMasterStudySaveError ()
	{
		console.log ( "OnSSCMasterStudySaveError..." );
		WaitingStop ();

		MsgWarning ( Translate("Unable to save master study !!!") );	
	}
	
	function SSCMasterStudySave ()
	{	
		let mstud_id 		= $('#IdcSSCInformationDiv').data ( 'id' );
		let description		= $('#IdcSSCMSDescription').val ();
		let anatomicregion	= $('#IdcSSCMSAnatomicRegion').val ();
		let type  			= $('#IdcSSCMSType').val ();
		

		let params = "mstud_id=" + mstud_id;
		params += "&description=" + description;
		params += "&anatomicregion=" + anatomicregion;
		params += "&type=" + type;
		params += "&ri=0";
		WaitingStart ( "Save in progress..." )
		PostASyncData ( "SubFW/database/settings/study/save_master_study.php", params, 'application/x-www-form-urlencoded', OnSSCMasterStudySaveOK, OnSSCMasterStudySaveError );
	}

	function SSCMasterStudyAdd ()
	{
		let params = "mstud_id=-1";

		PostASyncData ( "SubFW/database/settings/study/save_master_study.php", params, 'application/x-www-form-urlencoded', OnSSCMasterStudySaveOK, OnSSCMasterStudySaveError );
	}

	
	function SSCMasterStudyDelete ()
	{
		/*
		let selRows = IdcSSCMasterStudiesDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected master study ?"), DeleteSettingsMasterStudy );
		else
			MsgWarning ( Translate("No master selected !!!") );
		*/

		let data = {};
		data.RequestURL		= "SubFW/database/settings/study/delete_master_study.php";
		data.RequestData	= "mstud_id";
		data.DTColIdent		= "mstud_id";
		data.NoSelectedMsg 	= Translate ( "No master study selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected master study ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete master study !!!" );

		IdcSSCMasterStudiesDT.DeleteSelectedRow ( data );
	}



	// Linked description
	function SSCLinkedDescriptionSave ()
	{
		var dataToSend = [];

		let mstud_id 		= $('#IdcSSCInformationDiv').data ( 'id' );
		for ( let i=0; i<SSCToLink.length ; i++ )
		{
			dataToSend.push (
				{ 
					rstudid: SSCToLink [i].rstud_id, 
					mstud_id: SSCToLink [i].mstud_id, 
					newmstudid: mstud_id, 
					action: "add"  
				});
		}

		for ( let i=0; i<SSCToUnLink.length; i++ )
		{
			dataToSend.push (
				{ 
					rstudid: SSCToUnLink [i].rstud_id, 
					mstudid: SSCToUnLink [i].mstud_id, 
					newmstudid: mstud_id, 
					action: "del"  
				});
		}

    	var request = $.ajax ({
        		url: 		eoDACS.ServerFolder + "/SubFW/database/settings/study/modify_masterstudy.php",
        		type: 		"post",
        		dataType: 	"json",
        		contentType: "application/json",
        		data: 		JSON.stringify ( dataToSend )
    			}
    		)
			.done ( function () 
					{ 
						SSCToLink 		= Array ();
						SSCToUnLink 	= Array ();
						IdcSSCLinkedDescriptionDT.Refresh(); 
						IdcSSCNotLinkedDescriptionDT.Refresh(); 
					} )
    		.fail ();
	}



	function FillLinkedDescriptionDT ()
	{
		console.log ( "FillLinkedDescriptionDT..." );

		let idcDT = $('#IdcSSCLinkedDescriptionDT').DataTable();

		idcDT.clear ();
		
		WaitingStart ( Translate ('Request in progress. Please wait.') );
		SCLinkedDTInProgress = true;

		$.post (
			"./SubFW/database/settings/study/studym_description_linked.php",
			{
				linked: 1,
				mstudid: $('#IdcSSCInformationDiv').data ( 'id' )
			},
			function ( data, status) 
			{
				let resultArray = Array ();

				for ( let i=0; i<data.length; i++ )
				{
					let mstud_id 		= data [i].mstud_id;
					let rstud_id 		= data [i].rstud_id;
					let description  	= data [i].description;
					let mdescription  	= data [i].mdescription;
					let modality 		= data [i].modality;

					resultArray.push ( new SSCResData ( 0, mstud_id, rstud_id, description, mdescription, modality, '' ) );
				}

				idcDT.rows.add ( resultArray ).draw();
			}
		);
	}

	function FillNotLinkedDescriptionDT ()
	{
		console.log ( "FillNotLinkedDescriptionDT..." );

		let idcDT = $('#IdcSSCNotLinkedDescriptionDT').DataTable();

		idcDT.clear ();
		

		WaitingStart ( Translate ('Request in progress. Please wait.') );
		SCNotLinkedDTInProgress = true;

		$.post (
			"./SubFW/database/settings/study/studym_description_linked.php",
			{
				linked: 0,
				mstudid: $('#IdcSSCInformationDiv').data ( 'id' ),
				datecode: document.querySelector('input[name="SCNotLinkedDate"]:checked').value,
				withoutms: $('#IdcSCNLWithoutMS').is(':checked')
			},
			function ( data, status) 
			{
				let resultArray = Array ();

				for ( let i=0; i<data.length; i++ )
				{
					let rstud_id 		= data [i].rstud_id;
					let description  	= data [i].description;
					let mdescription  	= data [i].mdescription;
					let modality 		= data [i].modality;
					let date			= data [i].date;
					
					resultArray.push ( new SSCResData ( 0, rstud_id, description, mdescription, modality, date ) );
				}

				idcDT.rows.add ( resultArray ).draw();
			}
		);
	}

	function SSCInformationTabShown () 
	{
	}

	function SSCLinkedDescriptionTabShown ()
	{
		IdcSSCLinkedDescriptionDT.Refresh ();
		IdcSSCNotLinkedDescriptionDT.Refresh ();

		// FillLinkedDescriptionDT ();
		// FillNotLinkedDescriptionDT ();
	}

	function SSCDRLTabShown ()
	{
		let nrd_id = $('#IdcSStudyNRDDetailDiv').data ( 'nrd_id' );

		if ( nrd_id == -1 )
			IdcSStudyNRDDT.SetRowToSelect ( 'first_row' );

		IdcSStudyNRDDT.Refresh ();
	}

	function SSCLinkedDescriptionDTDrawCB ()
	{
		SCLinkedDTInProgress  	= false;
		if ( SCNotLinkedDTInProgress == false )
			WaitingStop ();
	}

	function SSCNotLinkedDescriptionDTDrawCB ()
	{
		SCNotLinkedDTInProgress = false;

		if ( SCLinkedDTInProgress == false )
			WaitingStop ();
	}

	function SSCLinkedDClick ( rowIdx )
	{
		console.log ( "DClick...");
		let rowData = IdcSSCLinkedDescriptionDT.GetRowData ( rowIdx );

		if ( rowData.newrow == 1 )
		{
			let idx = -1;
			for ( let i=0; i<SSCToLink.length;i++ )
			{
				if ( SSCToLink [i].rstud_id == rowData.rstud_id )
				{
					idx = i;
					break;
				}
			}
			if ( idx != -1)
			{
				SSCToLink.splice ( idx, 1 );

				IdcSSCLinkedDescriptionDT.Refresh ();
				IdcSSCNotLinkedDescriptionDT.Refresh ();
			}
		}
		else
		{
			SSCToUnLink.push ( new SSCResData ( (rowData.newrow == 0)? 1 : 0, rowData.mstud_id, rowData.rstud_id, rowData.description, rowData.mdescription, rowData.modality ) );

			// IdcSSCNotLinkedDescriptionDT.SetRowToSelect ( 'rstud_id', rowData.rstud_id );

			IdcSSCLinkedDescriptionDT.Refresh ();
			IdcSSCNotLinkedDescriptionDT.Refresh ();
		}
	}

	function SSCNotLinkedDClick ( rowIdx )
	{
		let rowData = IdcSSCNotLinkedDescriptionDT.GetRowData ( rowIdx );

		if ( rowData.newrow == 1 )
		{
			let idx = -1;
			for ( let i=0; i<SSCToUnLink.length;i++ )
			{
				if ( SSCToUnLink [i].rstud_id == rowData.rstud_id )
				{
					idx = i;
					break;
				}
			}
			if ( idx != -1)
			{
				SSCToUnLink.splice ( idx, 1 );

				IdcSSCLinkedDescriptionDT.Refresh ();
				IdcSSCNotLinkedDescriptionDT.Refresh ();
			}
		}
		else
		{
			SSCToLink.push ( new SSCResData ( (rowData.newrow == 0)? 1 : 0, rowData.mstud_id, rowData.rstud_id, rowData.description, rowData.mdescription, rowData.modality ) );

			IdcSSCLinkedDescriptionDT.Refresh ();
			IdcSSCNotLinkedDescriptionDT.Refresh ();
		}
	}

	function SSCLinkedRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newrow == 1 )
		{
			$(nRow).css ( 'background-color', '#00FF00');
		}

	}

	function SSCNotLinkedRowCB ( nRow, aData, iDisplayIndex )
	{
		if ( aData.newrow == 1 )
		{
			$(nRow).css ( 'background-color', '#FF0000');
		}

	}

	function SSCNotLinkedDateChanged ()
	{
		console.log ( "MS : " + $('#IdcSCNLWithoutMS').is (":checked") );

		// FillNotLinkedDescriptionDT ();		

		IdcSSCNotLinkedDescriptionDT.Refresh ();
	}




	function SSCLinkedDescriptionDTGetData ( d )
	{
		d.linked 		= 1;
		d.mstudid 		= $('#IdcSSCInformationDiv').data ( 'id' );

		d.description = $('#IdcSSCLinkedDescriptionDT_description').val();
		d.mdescription = $('#IdcSSCLinkedDescriptionDT_mdescription').val();

		let to_add = '';
		for ( let i=0; i<SSCToLink.length; i++ )
		{
			to_add += SSCToLink [i].rstud_id;
			if ( i<(SSCToLink.length-1) )
				to_add += ',';
		}
		d.to_add 		= to_add;

		let to_remove = '';
		for ( let i=0; i<SSCToUnLink.length; i++ )
		{
			to_remove += SSCToUnLink [i].rstud_id;
			if ( i<(SSCToUnLink.length-1) )
				to_remove += ',';
		}
		d.to_remove 		= to_remove;

		return $.extend( {}, d );
	}

	function SSCNotLinkedDescriptionDTGetData ( d )
	{
		console.log ( "SSCNotLinkedDescriptionDTGetData..." );
		d.linked 		= 0;
		d.mstudid 		= $('#IdcSSCInformationDiv').data ( 'id' );
		d.datecode 		= document.querySelector('input[name="SCNotLinkedDate"]:checked').value;
		d.withoutms		= $('#IdcSCNLWithoutMS').is(':checked');

		d.description 	= $('#IdcSSCNotLinkedDescriptionDT_description').val ();
		d.mdescription 	= $('#IdcSSCNotLinkedDescriptionDT_mdescription').val ();

		let to_add = '';
		for ( let i=0; i<SSCToLink.length; i++ )
		{
			to_add += SSCToLink [i].rstud_id;
			if ( i<(SSCToLink.length-1) )
				to_add += ',';
		}
		d.to_add 		= to_add;

		let to_remove = '';
		for ( let i=0; i<SSCToUnLink.length; i++ )
		{
			to_remove += SSCToUnLink [i].rstud_id;
			if ( i<(SSCToUnLink.length-1) )
				to_remove += ',';
		}
		d.to_remove 		= to_remove;

		return $.extend( {}, d );
	}



	// #################################################################################
	// NRD
	//

	function SStudyNRDDTGetData ( d )
	{
		console.log ( "SStudyNRDDTGetData..." );

		d.mstudid 		= $('#IdcSSCInformationDiv').data ( 'id' );

		console.log ( " d.mstudid : " + d.mstudid );

		return $.extend( {}, d );
	}

	function SStudyNRDDTSelectChanged ( rowsIdx )
	{
		let nrd_id			= -1;
		let name 			= "";
		let age_begin		= "";
		let age_end			= "";
		let weight_begin	= "";
		let weight_end		= "";
		let nb_acqui 		= "";
		let type 			= "";
		let value_type		= "";
		let value 			= "";
		
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			nrd_id			= IdcSStudyNRDDT.GetRowData ( rowIdx ).nrd_id;
			name			= IdcSStudyNRDDT.GetRowData ( rowIdx ).inp_alertname;
			age_begin		= IdcSStudyNRDDT.GetRowData ( rowIdx ).age_begin;
			age_end			= IdcSStudyNRDDT.GetRowData ( rowIdx ).age_end;
			weight_begin	= IdcSStudyNRDDT.GetRowData ( rowIdx ).weight_begin;
			weight_end		= IdcSStudyNRDDT.GetRowData ( rowIdx ).weight_end;
			nb_acqui 		= IdcSStudyNRDDT.GetRowData ( rowIdx ).inp_nacquisition;
			type 			= IdcSStudyNRDDT.GetRowData ( rowIdx ).type;
			value_type		= IdcSStudyNRDDT.GetRowData ( rowIdx ).combo_valuetype;
			value			= IdcSStudyNRDDT.GetRowData ( rowIdx ).inp_value;
		}

		$('#IdcSStudyNRDDetailDiv').data ( 'nrd_id', nrd_id );

		$('#IdcSStudyNRDName').val 	( name );
		$('#IdcSStudyNRDType').val 	( value_type );
		$('#IdcSStudyNRDValue').val ( value );
		$('#IdcSStudyNRDNumAcqui').val ( nb_acqui );
		$('#IdcSStudyNRDAgeBegin').val ( age_begin);
		$('#IdcSStudyNRDAgeEnd').val ( age_end);
		$('#IdcSStudyNRDWeightBegin').val ( weight_begin);
		$('#IdcSStudyNRDWeightEnd').val ( weight_end);
	}

	function OnSStudyNRDAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSStudyNRDDT.SetRowToSelect ( 'nrd_id', response );
			IdcSStudyNRDDT.Refresh ();
		}
		else
			OnSStudyNRDAddError ();
	}

	function OnSStudyNRDAddError ()
	{
		MsgWarning ( Translate("Unable to add DRL !!!") );
	}

	function SStudyNRDAdd ()
	{
		console.log ( "SStudyNRDAdd..." );

		let link_id	= $('#IdcSSCInformationDiv').data ( 'id' );
		let params  = "id=-1&link_id=" + link_id;
		PostASyncData ( "SubFW/database/settings/study/save_nrd.php", params, 'application/x-www-form-urlencoded', OnSStudyNRDAddOK, OnSStudyNRDAddError );
	}

	function OnSStudyNRDDeleteOK ( data )
	{
		IdcSStudyNRDDT.SetRowToSelect ( 'first_row' );
		IdcSStudyNRDDT.Refresh ();
	}

	function OnSStudyNRDDeleteError ( data )
	{
		MsgWarning ( Translate("Unable to delete DRL !!!") );
	}

	function DeleteSStudyNRD ()
	{
		let nrd_id = $('#IdcSStudyNRDDetailDiv').data ( 'nrd_id' );

		const formData = new FormData();
        formData.append ( 'nrd_id', nrd_id );
		PostASyncData ( "SubFW/database/settings/study/delete_nrd.php", formData, null, OnSStudyNRDDeleteOK, OnSStudyNRDDeleteError );
	}

	function SStudyNRDDelete ()
	{
		let nrd_id = $('#IdcSStudyNRDDetailDiv').data ( 'nrd_id' );

		if ( nrd_id != -1 )
			MsgYesNo ( Translate("Delete selected DRL ?"), DeleteSStudyNRD );
		else
			MsgWarning ( Translate("No DRL selected !!!") );
	}

	function SStudyNRDSave ()
	{
		const formData = new FormData();
        formData.append ( 'id', 		$('#IdcSStudyNRDDetailDiv').data ( 'nrd_id' )	);
        formData.append ( 'name',		$('#IdcSStudyNRDName').val 	()					);
        formData.append ( 'combo_valuetype',		$('#IdcSStudyNRDType').val 	()					);
        formData.append ( 'value',		$('#IdcSStudyNRDValue').val	()					);
        formData.append ( 'nb_acqui',	$('#IdcSStudyNRDNumAcqui').val	()				);
        formData.append ( 'age_begin',	$('#IdcSStudyNRDAgeBegin').val	()				);
        formData.append ( 'age_end',	$('#IdcSStudyNRDAgeEnd').val	()				);
        formData.append ( 'weight_begin',	$('#IdcSStudyNRDWeightBegin').val	()		);
        formData.append ( 'weight_end',	$('#IdcSStudyNRDWeightEnd').val	()				);

        PostASyncData ( "SubFW/database/settings/study/save_nrd.php", formData, null, OnSStudyNRDAddOK, OnSStudyNRDAddError );
	}


	