	SettingsUserAccessDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSUAUserDT.Properties (); }
		}
	];

	SUAGroupFilterDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSUAGroupFilterDT.Properties (); }
		}
	];

	SUALoginRolePermissionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSUALoginRolePermissionDT.Properties (); }
		}
	];

	SUAPlannedFilterAlertDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSUAPlannedFilterAlertDT.Properties (); }
		}
	];

	SUAPlannedAlertGroupPermissionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSUAPlannedAlertGroupPermissionDT.Properties (); }
		}
	];


	function InitSettingsUserAccessPage ()
	{
		console.log ( "InitSettingsUserAccessPage..." );

		let ss = sessionStorage.getItem ( 'SettingsUserAccessPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsUserAccessPageInitialized', true );

		IdcSUAUserDT = new C_DataTable ();
		IdcSUAUserDT.DataSrcType		= 0;
		IdcSUAUserDT.Ident 				= 'IdcSUAUserDT';
		IdcSUAUserDT.Container 			= 'IdcSUAUserDTContainer';
		IdcSUAUserDT.CfgParameterName 	= 'SettingsUserAccessDTProperties';
		IdcSUAUserDT.DataSrc 			= 'SubFW/database/settings/GetUsersListDT.php';
		IdcSUAUserDT.DataFct			= SUAUserDTGetData;
		IdcSUAUserDT.SetColReorder 	( true );
		IdcSUAUserDT.OnSelectChanged	( SUAUserDTSelectChanged );

		IdcSUAUserDT.AddColumn ( 'acc_id',					'acc_id',	 		0, false,  0,  50,  false, '', 					'' );
		IdcSUAUserDT.AddColumn ( Translate('Login'),		'username',		 	1, true,   1, '30%', true,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('Lastname'),		'lastname',		 	1, true,   2, '30%', true,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('Firstname'),	'firstname',	 	1, true,   3, '30%', true,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('Password'),		'password',		 	1, false,  4, '30%', false,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('Mail'),			'mail',			 	1, false,  5, '30%', false,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('lro_id'),		'lro_id',		 	1, false,  6, '30%', false,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('afg_id'),		'afg_id',		 	1, false,  7, '30%', false,  '', 				'' );
		IdcSUAUserDT.AddColumn ( Translate('operator'),		'operator',		 	1, false,  8, '30%', false,  '', 				'' );

		IdcSUAUserDT.LoadUserCfg ( G_USE_ID );


		IdcSUAGroupFilterDT = new C_DataTable ();
		IdcSUAGroupFilterDT.DataSrcType			= 0;
		IdcSUAGroupFilterDT.Ident 				= 'IdcSUAGroupFilterDT';
		IdcSUAGroupFilterDT.Container 			= 'IdcSUAGroupFilterDTContainer';
		IdcSUAGroupFilterDT.CfgParameterName 	= 'SettingsGroupFilterDTProperties';
		IdcSUAGroupFilterDT.DataSrc 			= 'SubFW/database/settings/GetGroupsListDT.php';
		IdcSUAGroupFilterDT.DataFct				= SUAGroupFilterDTGetData;
		IdcSUAGroupFilterDT.SetColReorder 	( true );
		IdcSUAGroupFilterDT.OnSelectChanged	( SUAGroupFilterDTSelectChanged );

		IdcSUAGroupFilterDT.AddColumn ( 'lro_id',				'lro_id', 		0, false,  0,  50,  false, '', 					'' );
		IdcSUAGroupFilterDT.AddColumn ( Translate('Name'),		'name',		 	1, true,   1, '100%', true,  '', 				'' );
		
		IdcSUAGroupFilterDT.LoadUserCfg ( G_USE_ID );

		IdcSUALoginRolePermissionDT = new C_DataTable ();
		IdcSUALoginRolePermissionDT.DataSrcType			= 0;
		IdcSUALoginRolePermissionDT.Ident 				= 'IdcSUALoginRolePermissionDT';
		IdcSUALoginRolePermissionDT.Container 			= 'IdcSUALoginRolePermissionDTContainer';
		IdcSUALoginRolePermissionDT.CfgParameterName 	= 'SettingsLoginRolePermissionDTProperties';
		IdcSUALoginRolePermissionDT.DataSrc 			= 'SubFW/database/settings/GetLoginRolePermissionListDT.php';
		IdcSUALoginRolePermissionDT.DataFct				= SUALoginRolePermissionDTGetData;
		IdcSUALoginRolePermissionDT.SetColReorder 	( true );
		IdcSUALoginRolePermissionDT.OnSelectChanged	( SUALoginRolePermissionDTSelectChanged );

		IdcSUALoginRolePermissionDT.AddColumn ( 'dep_id',					'dep_id', 		0, false,  0,  50,  false, '', 					'' );
		IdcSUALoginRolePermissionDT.AddColumn ( Translate('Institution'),	'instname',	 	1, true,   1, '40%', true,  '', 				'' );
		IdcSUALoginRolePermissionDT.AddColumn ( Translate('Department'),	'depname',	 	1, true,   2, '40%', true,  '', 				'' );
		IdcSUALoginRolePermissionDT.AddColumn ( '',							'selected',	 	1, true,   3,    40, true,  '', 				'', SUALoginRolePermissionValueCBRenderer );

		IdcSUALoginRolePermissionDT.SetColumnDoNotRepeat ( 'instname', true );
		
		IdcSUALoginRolePermissionDT.LoadUserCfg ( G_USE_ID );




		
		IdcSUAPlannedFilterAlertDT = new C_DataTable ();
		IdcSUAPlannedFilterAlertDT.DataSrcType			= 0;
		IdcSUAPlannedFilterAlertDT.Ident 				= 'IdcSUAPlannedFilterAlertDT';
		IdcSUAPlannedFilterAlertDT.Container 			= 'IdcSUAPlannedFilterAlertDTContainer';
		IdcSUAPlannedFilterAlertDT.CfgParameterName 	= 'SettingsPlannedFilterAlertDTProperties';
		IdcSUAPlannedFilterAlertDT.DataSrc 				= 'SubFW/database/settings/GetPlannedFilterAlertListDT.php';
		IdcSUAPlannedFilterAlertDT.DataFct				= SUAPlannedFilterAlertDTGetData;
		IdcSUAPlannedFilterAlertDT.SetColReorder 	( true );
		IdcSUAPlannedFilterAlertDT.OnSelectChanged	( SUAPlannedFilterAlertDTSelectChanged );

		IdcSUAPlannedFilterAlertDT.AddColumn ( 'afg_id',				'afg_id', 		0, false,  0,  50,  false, '', 					'' );
		IdcSUAPlannedFilterAlertDT.AddColumn ( Translate('Name'),		'name',		 	1, true,   1, '100%', true,  '', 				'' );
		
		IdcSUAPlannedFilterAlertDT.LoadUserCfg ( G_USE_ID );


		IdcSUAPlannedAlertGroupPermissionDT = new C_DataTable ();
		IdcSUAPlannedAlertGroupPermissionDT.DataSrcType		= 0;
		IdcSUAPlannedAlertGroupPermissionDT.Ident 				= 'IdcSUAPlannedAlertGroupPermissionDT';
		IdcSUAPlannedAlertGroupPermissionDT.Container 			= 'IdcSUAPlannedAlertGroupPermissionDTContainer';
		IdcSUAPlannedAlertGroupPermissionDT.CfgParameterName 	= 'SUAPlannedAlertGroupDTProperties';
		IdcSUAPlannedAlertGroupPermissionDT.DataSrc 			= 'SubFW/database/settings/GetPlannedAlertGroupPermissionListDT.php';
		IdcSUAPlannedAlertGroupPermissionDT.DataFct				= SUAPlannedFilterAlertPermissionDTGetData;
		IdcSUAPlannedAlertGroupPermissionDT.SetColReorder 	( true );
		// IdcSUAPlannedAlertGroupPermissionDT.OnSelectChanged	( SUALoginRolePermissionDTSelectChanged );

		IdcSUAPlannedAlertGroupPermissionDT.AddColumn ( 'mod_id',					'dep_id', 		0, false,  0,  50,  false, '', 					'' );
		IdcSUAPlannedAlertGroupPermissionDT.AddColumn ( Translate('Institution'),	'instname',	 	1, true,   1, '40%', true,  '', 				'' );
		IdcSUAPlannedAlertGroupPermissionDT.AddColumn ( Translate('Department'),	'depname',	 	1, true,   2, '40%', true,  '', 				'' );
		IdcSUAPlannedAlertGroupPermissionDT.AddColumn ( Translate('Room'),			'roomname',	 	1, true,   3, '40%', true,  '', 				'' );
		IdcSUAPlannedAlertGroupPermissionDT.AddColumn ( Translate('Modality'),		'modname',	 	1, true,   4, '40%', true,  '', 				'' );
		IdcSUAPlannedAlertGroupPermissionDT.AddColumn ( '',							'selected',	 	1, true,   5,   40,  true,  '', 				'', SUAPlannedAlertGroupPermissionValueCBRenderer );


		IdcSUAPlannedAlertGroupPermissionDT.SetColumnDoNotRepeat ( 'instname', true );
		
		IdcSUAPlannedAlertGroupPermissionDT.LoadUserCfg ( G_USE_ID );
			
		$(document).ready(function () 
		{		
			IdcSUAUserSplitter1_2 				= new C_Splitter ( "IdcSUAUserSplitter1_2" 				);
			IdcSUAGroupFilterSplitter1_2		= new C_Splitter ( "IdcSUAGroupFilterSplitter1_2" 		);
			IdcSUAPlannedFilterAlertSplitter1_2	= new C_Splitter ("IdcSUAPlannedFilterAlertSplitter1_2" );

			IdcSUAUserDT.Create ();
			context.attach ( '#IdcSUAUserDT', SettingsUserAccessDTListMenu );
			IdcSUAUserDT.SetRowToSelect ( 'first_row' );

			IdcSUAGroupFilterDT.Create ();
			context.attach ( '#IdcSUAGroupFilterDT', SUAGroupFilterDTListMenu );
			IdcSUAGroupFilterDT.SetRowToSelect ( 'first_row' );

			IdcSUALoginRolePermissionDT.Create ();
			context.attach ( '#IdcSUALoginRolePermissionDT', SUALoginRolePermissionDTListMenu );
			IdcSUALoginRolePermissionDT.SetRowToSelect ( 'first_row' );

			IdcSUAPlannedFilterAlertDT.Create ();
			context.attach ( '#IdcSUAPlannedFilterAlertDT', SUAPlannedFilterAlertDTListMenu );
			IdcSUAPlannedFilterAlertDT.SetRowToSelect ( 'first_row' );

			IdcSUAPlannedAlertGroupPermissionDT.Create ();
			context.attach ( '#IdcSUAPlannedAlertGroupPermissionDT', SUAPlannedAlertGroupPermissionDTListMenu );
			

			FillGroupFilterList ( "IdcSUAUserGroupFilter" );
			FillAlertFilterList ( "IdcSUAUserPlannedAlertFilter" );

			switchLanguage ( eoDACS.CurrentLanguage );
		});
	}

	function SUALoginRolePermissionValueCBRenderer ( data, ident, rowIdx, colIdx )
	{
		let checked = (data ==1)? 'checked' : '';
		let id = "IdcSUALoginRolePermissionCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" '+checked+' data-row_idx='+rowIdx+' data-col_idx='+colIdx+' onclick="OnSUALoginRolePermissionCBClicked(this)"/></div>';
	}

	function SUAPlannedAlertGroupPermissionValueCBRenderer ( data, ident, rowIdx, colIdx )
	{
		let checked = (data ==1)? 'checked' : '';
		let id = "IdcSUAPlannedAlertGroupPermissionCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" '+checked+' data-row_idx='+rowIdx+' data-col_idx='+colIdx+' onclick="OnSUAPlannedAlertGroupPermissionCBClicked(this)"/></div>';
	}

	function OnSUALoginRolePermissionSaveOK ()
	{
		IdcSUALoginRolePermissionDT.Refresh ();
	}
	function OnSUALoginRolePermissionSaveError ()
	{
		
	}
	function OnSUALoginRolePermissionCBClicked ( e )
	{
		console.log ( "OnSUALoginRolePermissionCBClicked..." );

		let rowIdx = $(e).data ( 'row_idx' );

		let dep_id 	= IdcSUALoginRolePermissionDT.GetRowData ( rowIdx ).dep_id;
		let lro_id 	= $('#IdcSUAGroupFilterInformationsDiv').data ( 'lro_id' );
		let chk 	= document.getElementById ( "IdcSUALoginRolePermissionCB_" + rowIdx ).checked;

		let params = "lro_id=" + lro_id;
		params += "&dep_id=" + dep_id;
		params += "&selected=";
		params += (chk==true)? "1" : "0";

		PostASyncData ( "SubFW/database/settings/save_loginrolepermission.php", params, 'application/x-www-form-urlencoded', OnSUALoginRolePermissionSaveOK, OnSUALoginRolePermissionSaveError );
	}

	function OnSUAPlannedAlertGroupPermissionCBClicked ( e )
	{
		let selRowData = IdcSUAPlannedFilterAlertDT.GetSelectedRowData ();

		if ( selRowData != null )
		{
			let rowIdx = $(e).data ( 'row_idx' );

			let mod_id 	= IdcSUAPlannedAlertGroupPermissionDT.GetRowData ( rowIdx ).mod_id;
			let afg_id 	= selRowData.afg_id;
			let chk 	= document.getElementById ( "IdcSUAPlannedAlertGroupPermissionCB_" + rowIdx ).checked;

			let params = "afg_id=" + afg_id;
			params += "&mod_id=" + mod_id;
			params += "&selected=";
			params += (chk==true)? "1" : "0";

			PostASyncData ( "SubFW/database/settings/save_plannedalertgrouppermission.php", params, 'application/x-www-form-urlencoded', function () {IdcSUAPlannedAlertGroupPermissionDT.Refresh ();} );
		}
		
	}

	function SUAUserDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function SUAUserDTSelectChanged ( rowsIdx )
	{
		let acc_id			= -1;
		let login			= "";
		let password		= "";
		let lastname		= "";
		let firstname		= "";
		let email			= "";
		let lro_id			= -1;
		let afg_id			= -1;
		let operator		= 0;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			acc_id			= IdcSUAUserDT.GetRowData ( rowIdx ).acc_id;
			login			= IdcSUAUserDT.GetRowData ( rowIdx ).username;
			password		= IdcSUAUserDT.GetRowData ( rowIdx ).password;
			lastname		= IdcSUAUserDT.GetRowData ( rowIdx ).lastname;
			firstname		= IdcSUAUserDT.GetRowData ( rowIdx ).firstname;
			email			= IdcSUAUserDT.GetRowData ( rowIdx ).mail;
			lro_id			= IdcSUAUserDT.GetRowData ( rowIdx ).lro_id;
			afg_id			= IdcSUAUserDT.GetRowData ( rowIdx ).afg_id;
			operator		= IdcSUAUserDT.GetRowData ( rowIdx ).operator;
		}

		$('#IdcSUAUserInformationsDiv').data ( 'acc_id', acc_id );

		$('#IdcSUAUserLogin').val ( login );
		$('#IdcSUAUserPassword').val ( password );
		$('#IdcSUAUserLastname').val ( lastname );
		$('#IdcSUAUserFirstname').val ( firstname );
		$('#IdcSUAUserEMail').val ( email );
		$('#IdcSUAUserGroupFilter').val ( lro_id );
		$('#IdcSUAUserPlannedAlertFilter').val ( afg_id );
		$('#IdcSUAUserOperator').prop ( 'checked', (operator==1)?true : false );
	}

	function SUAGroupFilterDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function SUAGroupFilterDTSelectChanged ( rowsIdx )
	{
		let lro_id			= -1;
		let name			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			lro_id			= IdcSUAGroupFilterDT.GetRowData ( rowIdx ).lro_id;
			name			= IdcSUAGroupFilterDT.GetRowData ( rowIdx ).name;
		}

		$('#IdcSUAGroupFilterInformationsDiv').data ( 'lro_id', lro_id );
		$('#IdcSUAGroupFilterName').val ( name );

		IdcSUALoginRolePermissionDT.Refresh ();
	}




	function SUALoginRolePermissionDTGetData ( d )
	{
		d.roleid = $('#IdcSUAGroupFilterInformationsDiv').data ( 'lro_id' );

		return $.extend( {}, d );
	}

	function SUALoginRolePermissionDTSelectChanged ( rowsIdx )
	{
	}



	function SUAPlannedFilterAlertDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function SUAPlannedFilterAlertDTSelectChanged ( rowsIdx )
	{
		
		let afg_id			= -1;
		let name			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			afg_id			= IdcSUAPlannedFilterAlertDT.GetRowData ( rowIdx ).afg_id;
			name			= IdcSUAPlannedFilterAlertDT.GetRowData ( rowIdx ).name;
		}

		// $('#IdcSUAGroupFilterInformationsDiv').data ( 'lro_id', lro_id );
		$('#IdcSUAPlannedFilterAlertName').val ( name );

		IdcSUAPlannedAlertGroupPermissionDT.Refresh ();
	}


	function SUAPlannedFilterAlertPermissionDTGetData ( d )
	{
		console.log ( "SUAPlannedFilterAlertPermissionDTGetData..." );

		let selRowData = IdcSUAPlannedFilterAlertDT.GetSelectedRowData ();
		console.log ( " selRowData : ", selRowData );
		if ( selRowData !=null )
			d.afg_id = selRowData.afg_id;

		return $.extend( {}, d );
	}
	
	// ###########################################################################""
	// Add user

	function OnSUAUserAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSUAUserDT.SetRowToSelect ( 'acc_id', response );
			IdcSUAUserDT.Refresh ();
		}
		else
			OnSUAUserAddError ();
	}

	function OnSUAUserAddError ()
	{
		MsgWarning ( Translate("Unable to add user !!!") );
	}

	function SUAUserAdd ()
	{
		let params = "id=-1";
		PostASyncData ( "SubFW/database/settings/save_user.php", params, 'application/x-www-form-urlencoded', OnSUAUserAddOK, OnSUAUserAddError );
	}


	function OnSUAUserDeleteOK ( response )
	{
		if ( response != '-1')
		{
			IdcSUAUserDT.SetRowToSelect ( 'first_row' );
			IdcSUAUserDT.Refresh ();
		}
		else
			OnSUAUserAddError ();
	}

	
	// ###########################################################################""
	// Delete user

	function OnSUAUserDeleteError ()
	{
		MsgWarning ( Translate("Unable to delete user !!!") );
	}
	function DeleteSettingsUser ()
	{
		let selRows = IdcSUAUserDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSUAUserDT.GetRowData ( selRows [0] ).acc_id;

			PostASyncData ( "SubFW/database/settings/delete_user.php", "id="+id, 'application/x-www-form-urlencoded', OnSUAUserDeleteOK, OnSUAUserDeleteError );
		}
	}
	function SUAUserDelete ()
	{
		let selRows = IdcSUAUserDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected user ?"), DeleteSettingsUser );
		else
			MsgWarning ( Translate("No user selected !!!") );
	}


	// ###########################################################################""
	// Save user

	function OnSUAUserSaveOK ( response )
	{
		if ( response != '-1')
		{
			IdcSUAUserDT.SetRowToSelect ( 'acc_id', response );
			IdcSUAUserDT.Refresh ();
		}
		else
			OnSUAUserAddError ();
	}

	function OnSUAUserSaveError ()
	{
		MsgWarning ( Translate("Unable to save user !!!") );
	}

	function SUAUserSave ()
	{
		let acc_id 			= $('#IdcSUAUserInformationsDiv').data ( 'acc_id' );
		let login			= $('#IdcSUAUserLogin').val ();
		let password		= $('#IdcSUAUserPassword').val ();
		let lastname		= $('#IdcSUAUserLastname').val ();
		let firstname		= $('#IdcSUAUserFirstname').val ();
		let email			= $('#IdcSUAUserEMail').val ();
		let lro_id			= $('#IdcSUAUserGroupFilter').val ();
		let afg_id			= $('#IdcSUAUserPlannedAlertFilter').val ();
		let operator		= ($('#IdcSUAUserOperator').prop ('checked'))? 1 : 0;

		let params = "acc_id=" + acc_id;
		params += "&login=" + login;
		params += "&password=" + password;
		params += "&lastname=" + lastname;
		params += "&firstname=" + firstname;
		params += "&email=" + email;
		params += "&lro_id=" + lro_id;
		params += "&operator=" + operator;
		params += "&afg_id=" + afg_id;

		PostASyncData ( "SubFW/database/settings/save_user.php", params, 'application/x-www-form-urlencoded', OnSUAUserSaveOK, OnSUAUserSaveError );
	}




	// ###########################################################################""
	// Add group filter

	function OnSUAGroupFilterAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSUAGroupFilterDT.SetRowToSelect ( 'lro_id', response );
			IdcSUAGroupFilterDT.Refresh ();
		}
		else
			OnSUAGroupFilterAddError ();
	}

	function OnSUAGroupFilterAddError ()
	{
		MsgWarning ( Translate("Unable to add group filter !!!") );
	}

	function SUAGroupFilterAdd ()
	{
		console.log ( "SUAGroupFilterAdd..." );
		let params = "id=-1";
		PostASyncData ( "SubFW/database/settings/save_groupfilter.php", params, 'application/x-www-form-urlencoded', OnSUAGroupFilterAddOK, OnSUAGroupFilterAddError );
	}


	function OnSUAGroupFilterDeleteOK ( response )
	{
		if ( response != '-1')
		{
			IdcSUAGroupFilterDT.SetRowToSelect ( 'first_row' );
			IdcSUAGroupFilterDT.Refresh ();
		}
		else
			OnSUAGroupFilterAddError ();
	}

	
	// ###########################################################################""
	// Delete GroupFilter

	function OnSUAGroupFilterDeleteError ()
	{
		MsgWarning ( Translate("Unable to delete group filter !!!") );
	}
	function DeleteSettingsGroupFilter ()
	{
		let selRows = IdcSUAGroupFilterDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSUAGroupFilterDT.GetRowData ( selRows [0] ).lro_id;

			PostASyncData ( "SubFW/database/settings/delete_groupfilter.php", "id="+id, 'application/x-www-form-urlencoded', OnSUAGroupFilterDeleteOK, OnSUAGroupFilterDeleteError );
		}
	}
	function SUAGroupFilterDelete ()
	{
		let selRows = IdcSUAGroupFilterDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected group filter ?"), DeleteSettingsGroupFilter );
		else
			MsgWarning ( Translate("No group filter selected !!!") );
	}


	// ###########################################################################""
	// Save group filter

	function OnSUAGroupFilterSaveOK ( response )
	{
		if ( response != '-1')
		{
			IdcSUAGroupFilterDT.SetRowToSelect ( 'lro_id', response );
			IdcSUAGroupFilterDT.Refresh ();
		}
		else
			OnSUAGroupFilterAddError ();
	}

	function OnSUAGroupFilterSaveError ()
	{
		MsgWarning ( Translate("Unable to save group filter !!!") );
	}

	function SUAGroupFilterSave ()
	{
		console.log ( "SUAGroupFilterSave" );

		let lro_id 			= $('#IdcSUAGroupFilterInformationsDiv').data ( 'lro_id' );
		let name			= $('#IdcSUAGroupFilterName').val ();
		
		let params = "lro_id=" + lro_id;
		params += "&name=" + name;
		
		PostASyncData ( "SubFW/database/settings/save_groupfilter.php", params, 'application/x-www-form-urlencoded', OnSUAGroupFilterSaveOK, OnSUAGroupFilterSaveError );
	}

	


	function SUAPlannedFilterAlertAdd ()
	{
		console.log ( "SUAPlannedFilterAlerAdd..." );
		let params = "afg_id=-1";
		PostASyncData ( "SubFW/database/settings/save_plannedfilteralert.php", params, 'application/x-www-form-urlencoded', function (response) 
				{ 
					if ( response != -1 )
						IdcSUAPlannedFilterAlertDT.SetRowToSelect ( 'afg_id', response );
					IdcSUAPlannedFilterAlertDT.Refresh (); 
				} 
			);
	}

	function SUAPlannedFilterAlertDelete ()
	{
		let selRowData = IdcSUAPlannedFilterAlertDT.GetSelectedRowData ();
		if ( selRowData != null )
		{
			let afg_id = selRowData.afg_id;

			PostASyncData ( "SubFW/database/settings/delete_plannedfilteralert.php", "afg_id="+afg_id, 'application/x-www-form-urlencoded', function () { IdcSUAPlannedFilterAlertDT.Refresh (); } );
		}
	}

	function SUAPlannedFilterAlertSave ()
	{
		let selRowData = IdcSUAPlannedFilterAlertDT.GetSelectedRowData ();
		if ( selRowData != null )
		{
			let afg_id = selRowData.afg_id;

			let params = "afg_id=" + afg_id + "&name=" + $('#IdcSUAPlannedFilterAlertName').val ();
			PostASyncData ( "SubFW/database/settings/save_plannedfilteralert.php", params, 'application/x-www-form-urlencoded', function (response) 
				{ 
					if ( response != -1 )
						IdcSUAPlannedFilterAlertDT.SetRowToSelect ( 'afg_id', response );
					IdcSUAPlannedFilterAlertDT.Refresh (); 
				} 
			);
		}
	}