<?php

require_once 'SubFW/autoload.php';

?>

<!doctype html>

<html lang="en" style="height: 100%; font-size: 12px;">

	<head>
		<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
		
		<meta charset="utf-8">
		
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<title>
			eoDACS
		</title>
		
		<link rel="icon" href="SubFW/bmp/back.png" type="image/png">

		
		<?php
			$libmanager = new eoLibrariesManagerDACS ();
			$libmanager->init_page();
			$libmanager->render_library ();
		?>


		<script src="<?=$GLOBALS["approot"]?>/eoDACS/SubFW/js/C_TreeView.js"></script>
		<script src="<?=$GLOBALS["approot"]?>/eoDACS/SubFW/js/C_Date.js"></script>

	</head>
	
	
	
	
	<script>
		var G_USE_ID 		= -1;
		var G_UserFullName 	= '';
		var	G_UserAccess	= null;

		var Time3 = 0;
		var AllowColumnsOrderSaving = false;

		/*
		// Default language
		let navLang = navigator.language.substr(0,2);
		if ( navLang != 'fr' && navLang != 'en' && navLang != 'du' )
			CurrentLanguage = 'en';
		else
			CurrentLanguage = navLang;
		*/

		



		function OnLogoutOK ()
		{
			sessionStorage.clear();

			// sessionStorage.setItem ( 'MainPageInitialized', 		false  );
			
			IdcUserDiv.style.display				= "none";
			//IdcMainDiv.style.display				= "block";
			
			G_USE_ID 		= -1;
			G_UserAccess 	= null;

			window.location.href = 'login.php';
		}

		function OnLogoutError ()
		{

		}

		function Logout ()
		{
			PostASyncData ( "SubFW/database/logout.php", "", 'application/x-www-form-urlencoded', OnLogoutOK, OnLogoutError );
		}
		
		function OnUserLogout ()
		{
			MsgYesNo ( Translate ( "Do you want to close your session ?" ), Logout );
		}
		
		function OnUserLogin ()
		{
			$('#IdcUserAccess').modal('show');
		}
		
		function OnAuthorizedAccess ()
		{
			$('#IdcAuthorizedAccess').modal ('show');

			InitAuthorizedAccessDlg ();
		}
		
		function OnHelpHTML ()
		{
		}

		function OnHelpPDF ()
		{
			console.log ( "lang : " + navigator.language );
			window.open ( "Doc/"+eoDACS.CurrentLanguage+"/PDF/eoDACS.pdf",  "_blank" );
		}

		function OnLeftTabWidth ()
		{
			LeftTabs.SwitchMode ();

			switchLanguage ( eoDACS.CurrentLanguage );
		}
		
			
		
		
		// ======================================================================================
		// User access
		
		function AllowedUserAccess ( use_id, userFullName )
		{
			G_USE_ID 		= use_id;
			G_UserFullName	= userFullName;

			localStorage.setItem("UseID", use_id);
			
			InitMainPage ();
			
			IdcMainDiv.style.display				= "none";
			IdcUserDiv.style.display				= "block";
			
			document.getElementById ( "IdcUserName"			).innerHTML = userFullName;
			
			// $('#IdcUserAccess').modal('hide');
		}
		
		/*
		function DeniedUserAccess ()
		{
			IdcUserErrorLogin.style.display ="block";
			IdcUserIdent.value = '';
			IdcUserPassword.value = ''
		}
		
		function OnCheckAccess ( data )
 		{
 			let success 	= JSON.parse ( data ) ['success'];
 			let message 	= JSON.parse ( data ) ['message'];

			let error 	= JSON.parse ( data ) ['error'];
			if ( success == false || error != undefined )
			{
				DeniedUserAccess ();
			}
			else
			{
				let id 			= JSON.parse ( data ) ['id'];		
				let lastname 	= JSON.parse ( data ) ['lastname'];	
				let firstname 	= JSON.parse ( data ) ['firstname'];
				G_UserAccess	= JSON.parse ( data ) ['access'];

				AllowedUserAccess ( id, lastname + ' ' + firstname );
			}
		}

		function OnCheckAccessError ()
 		{
 			DeniedUserAccess ();
		}
			
		function CheckUserAccess ()
		{
			let userIdent 		= IdcUserIdent.value;
			let userPassword 	= IdcUserPassword.value;
			
			PostASyncData ( "SubFW/database/authentification.php", "username="+userIdent+"&password="+userPassword, 'application/x-www-form-urlencoded', OnCheckAccess, OnCheckAccessError );
		}
			*/

		function CloseLoginDlg ()
		{
			IdcUserIdent.value		= '';
			IdcUserPassword.value 	= '';
			IdcUserErrorLogin.style.display ="none";

			$('#IdcUserAccess').modal('hide');
		}

	</script>

	
	
	
	<body>
						
		<div id="IdcMainDiv" class="container-fluid max-vh-100 vh-100 bg-light d-none">
			<div class="h-100 d-flex flex-column m-0 p-0 w-100">
				<div class="row border-bottom m-0 p-0">
						
					<nav id="idnavbar" class="navbar navbar-expand navbar-dark bg-gray1 static-top m-0 p-0 pb-2 pt-2 w-100">
						<a href="http://ximeo.be" class="d-flex align-items-center col-md-3 mb-2 mb-md-0 text-dark text-decoration-none">
							<img src="SubFW/bmp/ximeo.png" alt="XIMEO" style="width: 90px;"></img>
						</a>
													
						<div class="collapse navbar-collapse">
						
							<ul class="nav col-12 col-md-auto mb-2 justify-content-center mb-md-0">
							</ul>

							<div class="container">
								<div id="IdcLanguageDiv" class="row">
								</div>
							</div>

							<div class="w-100 text-end">
								<button type="button" data-langkey="Login..." class="ximeo_button" onclick="OnUserLogin ();"></button>
							</div>
						</div>
					
					</nav>
					
				</div>
							
				<div class="row bg-light flex-grow-1 h-25 p-0">
				
					<div id="IdcWelcomeDiv" class="w-100 h-100 bg-light" style="display: block;">
					
						<div class="pt-2">
							<h1 data-langkey="eoDACS, the Dose Management System by XIMEO">eoDACS, le Système de Gestion Dosimétrique par XIMEO</h1>
						</div>
					
						<div id="IdcWelcomeCarouselDiv" class="carousel slide pt-3 pb-3" data-bs-ride="carousel">
							<div class="carousel-indicators">
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="1" aria-label="Slide 2"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="2" aria-label="Slide 3"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="3" aria-label="Slide 4"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="4" aria-label="Slide 5"></button>
								<button type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide-to="5" aria-label="Slide 6"></button>
							</div>
    
							<div class="carousel-inner h-100">
								<div class="carousel-item  active">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Toute modalité DICOM SR</h1>
											<p>Collecter les doses de l'ensemble de vos modalités compatibles DICOM SR.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..."  href="#"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1 data-langkey="Statistic"></h1>
											<p>Un outil statistique largement paramétrable.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..." href="#"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Dossier dosimétrique patient</h1>
											<p>Visualisation claire et détaillée des informations dosimétriques de vos patients.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..."  href="#"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Alertes</h1>
											<p>Gestion efficace des alertes de dépassement des NRD.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..." href="#"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Multi-sites - multi-départements</h1>
											<p>Gérer vos établissements et/ou départements de manière aisée.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..." href="#"></a></p>
										</div>
									</div>
								</div>
								<div class="carousel-item">
									<svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice" focusable="false"><rect width="100%" height="100%" fill="#7a0058"/></svg>

									<div class="container">
										<div class="carousel-caption text-start">
											<h1>Exportation vers les autorités</h1>
											<p>Effectuez aisément vos exports périodiques vers les autorités de surveillance.</p>
											<p><a class="btn btn-lg btn-primary" data-langkey="Learn more..." href="#"></a></p>
										</div>
									</div>
								</div>
							</div>
							<button class="carousel-control-prev" type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide="prev">
								<span class="carousel-control-prev-icon" aria-hidden="true"></span>
								<span class="visually-hidden">Previous</span>
							</button>
							<button class="carousel-control-next" type="button" data-bs-target="#IdcWelcomeCarouselDiv" data-bs-slide="next">
								<span class="carousel-control-next-icon" aria-hidden="true"></span>
								<span class="visually-hidden">Next</span>
							</button>
						</div>
					
					
						<div class="position-absolute bottom-0" style="width: 98%;">
							<footer class="w-100 py-0 p-0">
								<div class="d-flex justify-content-between py-0 my-0 border-top">
									<p>&copy; 2024 XIMEO SA. All rights reserved.</p>
								</div>
							</footer>
						</div>
						
					</div>	<!-- IdcWelcomeDiv -->
					
				</div>	<!-- row -->
				
			</div>	<!-- flex-column -->
		
		
			<div id="IdcUserAccess"  class="modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
				<div class="modal-dialog modal-sm modal-dialog-centered" role="document">
					<div class="modal-content">
										
						<div class="modal-header p-3 pb-3 pt-3 border-bottom bg-light">
							<h5 class="fw-bold mb-0" data-langkey="Connection to eoDACS"></h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="CloseLoginDlg();"></button>
						</div>
										
						<div class="modal-body">
							<div id="IdcUserErrorLogin" style="display: none;" class="form-floating mb-3">
								<small class="text-danger" data-langkey="Incorrect username or password"></small>
							</div>
									
							<div class="form-floating mb-2">
								<input type="email" class="form-control rounded-4" id="IdcUserIdent" placeholder="name@example.com">
								<label for="IdcUserIdent" data-langkey="Identifier">Identifier</label>
							</div>
							<div class="form-floating mb-3">
								<input type="password" class="form-control rounded-4" id="IdcUserPassword" placeholder="Password">
								<label for="IdcUserPassword" data-langkey="Password">Password</label>
							</div>
						</div>
						
						<div class="modal-footer">
							<button type="button" class="ximeo_button ximeo_bg-dark-2" data-dismiss="modal" data-langkey="Cancel" onclick="CloseLoginDlg();">Cancel</button>
							<button type="button" class="ximeo_button" data-langkey="OK" onclick="CheckUserAccess ();">OK</button>
						</div>
					</div>
				</div>
			</div>

		</div>	<!-- IdcMainDiv -->
		
		
		
		<div id="IdcUserDiv" class="container-fluid max-vh-100 vh-100 p-0 bg-warning overflow-hidden" style="display: block;">
			<div class="row bg-light w-100 h-100 p-0 m-0">
				<div class="col-md-auto w-100 h-100 p-0 m-0">
					<div id="IdcUserContainer" class="container-fluid d-flex flex-column h-100 w-100 p-0 m-0">
						<div id="IdcUserDivRow1" class="row w-100 p-0 m-0 bg-light border-bottom">
							<div class="col w-100 m-0 p-0">
								<nav id="idnavbar" class="navbar navbar-expand navbar-dark ximeo_bg-dark-1 static-top w-100 p-0 m-0 ps-2 pt-1 pb-1">
									<div class="navbar-collapse collapse w-100 order-1 order-md-0 dual-collapse2 p-0 m-0 pt-2 pb-2">
										<div class="row m-0 p-0">
											<div class="col">
												<a href="http://ximeo.be" class="d-flex align-items-center col-md-3 mb-2 mb-md-0 ms-2 p-0 text-dark text-decoration-none h-100">
													<img src="SubFW/bmp/eodacs.png" alt="eoQUAL" style="width: 110px;">
												</a>
											</div>
											<div class="col">
												<img class="imgclickable" src="SubFW/bmp/menu.png" alt="Left tab width" style="width: 25px;" onclick="OnLeftTabWidth();">
											</div>
										</div>

									</div>

									
					
									<div class="navbar-collapse collapse ml-auto order-3 dual-collapse2 me-3">
										<ul class="nav nav-pills ml-auto w-100 m-0 p-0 pe-3">
											<li class="nav-item dropdown">
												
												<a class="nav-link dropdown-toggle text-white fw-bold p-0" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
												
												<img src="SubFW/bmp/person-white.png" style="height:28px; width: auto;">
												<span id="IdcUserName" class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 28px !important;"></span>
												</a>
												
												
												<ul class="dropdown-menu dropdown-menu-end bg-white">
													<li class="h-100 m-0 p-0">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" href="#" onclick="OnAuthorizedAccess();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/access_list_1.png" style="height: 24px; width: auto;">
																<span data-langkey="Authorized access..." class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>

													<li class="h-100 m-0 mt-2 p-0 border-top">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" href="#" onclick="OnUserLogout();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/logout.png" style="height: 24px; width: auto;">
																<span data-langkey="Logout..." class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>
												</ul>
											</li>
										</ul>

										<!--
										<div class="m-0 p-0 ms-5 me-3 text-white">
											<img class="imgclickable" src="SubFW/bmp/manual.png" alt="Manual" style="width: 28px;" onclick="OnHelp();">
										</div>
										-->

										<ul class="nav nav-pills ml-auto w-100 m-0 p-0 ps-4">
											<li class="nav-item dropdown">
												
												<a class="nav-link dropdown-toggle text-white fw-bold p-0" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
													<img src="SubFW/bmp/manual.png" style="height:28px; width: auto;">
												</a>
												
												<ul class="dropdown-menu dropdown-menu-end bg-white">
													<li class="h-100 m-0 p-0">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" onclick="OnHelpHTML();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/html.png" style="height: 24px; width: auto;">
																<span data-langkey="HTML format" class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>

													<li class="h-100 m-0 mt-2 p-0 border-top">
														<a class="dropdown-item h-100 m-0 p-0 ps-2 pe-2" onclick="OnHelpPDF();">
															<div class="h-100 m-0 p-0">
																<img src="SubFW/bmp/pdf.png" style="height: 24px; width: auto;">
																<span data-langkey="PDF format" class="h-100 m-0 p-0 ps-2 align-bottom" style="min-height: 24px !important;"></span>
															</div>
														</a>
													</li>
												</ul>

											</li>
										</ul>

									</div>

									
								</nav>
							</div>	<!-- col -->
						</div>	<!-- row -->
						
						<div id="IdcUserDivRow2" class="row flex-grow-1 w-100 p-0 m-0" style="min-height: 0;">
							
							<div class="col-md-auto h-100 m-0 p-0 eoqual_left_tabs_bg">
								<div class="d-flex flex-column w-100 h-100">
									<div class="row m-0 p-0">
										<div id="IdcLeftTabsContainer" class="col-md-auto h-100 m-0 p-0 pt-2 ximeo_text-light eoqual_left_tabs_bg">
										</div>
									</div>
									<div class="row flex-grow-1 m-0 p-0" style="min-height: 0px;">
										<div class="col mt-auto m-0 p-0 ps-3 pt-3 pb-3 bg-light border-end">
											<a href="http://ximeo.be" class="d-flex align-items-center col-md-3 mb-2 mb-md-0 text-dark text-decoration-none">
												<img src="SubFW/bmp/ximeo.png" alt="XIMEO" style="width: 90px;">
											</a>
										</div>
									</div>
								</div>
							</div>
					
							<div class="col flex-grow-1 h-100 p-0 bg-light" style="min-width: 0px;">

								<div id="IdcUserContentDiv" class="h-100 w-100 p-0 m-0" >
									<div id="IdcDivDashboard"  class="ximeo_bg-light w-100 h-100 p-3 m-0" style="display: none !important"></div>
									<!-- <div id="IdcDivStatisticContainer"  class="ximeo_bg-light w-100 h-100 p-3 m-0" style="display: none !important"></div> -->
									<?php include ("SubFW/html/ExamList.html"); 					?>	<!-- See page_exam_list.js 			-->
									<?php include ("SubFW/html/PatientDosimetry.html");				?>	<!-- See page_patient_dosimetry.js 	-->
									<?php include ("SubFW/html/Statistic.php");						?>	<!-- See page_statistic.js 			-->
									<?php include ("SubFW/html/ExportAuthorities.html");			?>	<!-- See page_export_authorities.js -->
									<?php include ("SubFW/html/Settings.html");						?>	<!-- See page_settings.js			-->
								</div>
										
							</div> <!-- col -->
							
	
						</div> <!-- row flex-grow-1 -->
							
					</div>	<!-- container -->
															
				</div>	<!-- col -->
				
			</div>	<!-- row -->
			
			
			
			<!-- Include msg_dlg.html -->
			<?php include ("SubFW/html/msg_dlg.html");					?>		<!-- See msg_dlg.js 			-->

			<!-- Include waiting.html -->
			<?php include ("SubFW/html/waiting.html");					?>		<!-- See waiting.js 			-->


			<!-- Include DocumentViewer.html -->
			<?php include ("SubFW/html/DocumentViewer.html");			?>		<!-- See DocumentViewer.js 		-->

			
			<!-- Include AuthorizedAccess.html -->
			<?php include ("SubFW/html/AuthorizedAccess.html");			?>		<!-- See AuthorizedAccess.js	-->
									
		</div>	<!-- IdcUserDiv -->

		
		<!-- i18n -->
		<script src='SubFW/js/i18n.js' ></script>
			
		<script>
			
			window.eoDACS = window.eoDACS || {};

			eoDACS.Country					= '<?php echo ($Country); ?>';
			eoDACS.ServerAddress 			= '<?php echo ($config_servernameorip); ?>';
			eoDACS.ServerFolder  			= '<?php echo ($GLOBALS["EODACS_ROOT"]); ?>';
			eoDACS.JasperTemplatesFolder 	= '<?php echo ($GLOBALS["JASPER_TEMPLATES_FOLDER"]); ?>';
			eoDACS.CurrentLanguage 			= '<?=$_SESSION['lang']?>';

			let navLang = navigator.language.substr(0,2);
			
			AddLanguages ();

			switchLanguage ( eoDACS.CurrentLanguage );

			context.init({preventDoubleContext: false});

			window.addEventListener(`contextmenu`, (e) => {
		 		e.preventDefault();
		 	});

		 	sessionStorage.setItem ( 'MainPageInitialized', 		false  );

			AllowedUserAccess ( <?php echo ($_SESSION['id']); ?>, '<?php echo ($_SESSION['username']); ?>' );

		</script>

			
	</body>
	
</html>