--
-- PostgreSQL database dump
--

-- Dumped from database version 16.2
-- Dumped by pg_dump version 16.2

-- Started on 2025-08-28 14:26:57

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 5 (class 2615 OID 2200)
-- Name: public; Type: SCHEMA; Schema: -; Owner: pg_database_owner
--

CREATE SCHEMA public;


ALTER SCHEMA public OWNER TO pg_database_owner;

--
-- TOC entry 5745 (class 0 OID 0)
-- Dependencies: 5
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: pg_database_owner
--

COMMENT ON SCHEMA public IS 'standard public schema';


--
-- TOC entry 410 (class 1255 OID 25106)
-- Name: f_create_login_role_permission(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.f_create_login_role_permission() RETURNS character varying
    LANGUAGE plpgsql
    AS $$ 


  	  	    DECLARE 


  	  			v_admin_id integer; 


  	  	    BEGIN 






  	  		 v_admin_id := 0; 






  	         insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_INSTITUTION'::text as nameid, 'View institution settings' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 


  	         insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_STAFFROLE'::text as nameid, 'View staff role settings' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	         insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_LOGINROLE'::text as nameid, 'View login role settings' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	         insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_STAFFMEMBER'::text as nameid, 'View staff member settings' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	           (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_TAG'::text as nameid, 'View tag settings' as description ,true as def_value, true as value) as rp_data 


  	           where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	         insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_WARNING'::text as nameid, 'View warning settings' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	           (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_DASHBOARD'::text as nameid, 'View dashboard frame' as description ,true as def_value, true as value) as rp_data 


  	           where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	            (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_AUDIT'::text as nameid, 'View audit frame' as description ,true as def_value, true as value) as rp_data 


  	            where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value,working_view,working_view_exist) select login_role_id,ptype,nameid,description,def_value,value,false,true from 


  	            (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_PROCEDURE'::text as nameid, 'View procedure frame' as description ,true as def_value, true as value) as rp_data 


  	            where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	            (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_DEVICE'::text as nameid, 'View device frame' as description ,true as def_value, true as value,false,true) as rp_data 


  	            where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value,working_view,working_view_exist) select login_role_id,ptype,nameid,description,def_value,value,false,true from 


  	              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_EXAMLIST'::text as nameid, 'View exam list frame' as description ,true as def_value, true as value) as rp_data 


  	              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_STAFF'::text as nameid, 'View staff frame' as description ,true as def_value, true as value) as rp_data 


  	              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_DOSIMETRY'::text as nameid, 'View dosimetry frame' as description ,true as def_value, true as value) as rp_data 


  	              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_LEGALDOCUMENT'::text as nameid, 'View legal document frame' as description ,true as def_value, true as value) as rp_data 


  	              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_SCHEDULEDTASK'::text as nameid, 'View scheduled task frame' as description ,true as def_value, true as value) as rp_data 


  	              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 


  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_INCIDENTREPORTING'::text as nameid, 'View incident reporting frame' as description ,true as def_value, true as value) as rp_data 


  	              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 






  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_INSTITUTIONDOCUMENT'::text as nameid, 'View institution document frame' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 




  	           insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_EXAMIDENT'::text as nameid, 'View the exam link frame' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 




  	          insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	          (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_EXAMLINK'::text as nameid, 'View the exam link frame' as description ,true as def_value, true as value) as rp_data 


  	          where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 




              insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


              (select v_admin_id as login_role_id,'VIEW' as ptype, 'VIEW_STATISTIC'::text as nameid, 'View the statistic frame' as description ,true as def_value, true as value) as rp_data 


              where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 




  	         -- insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	         --  (select v_admin_id as login_role_id,'ACTION' as ptype, 'ACTION_ADD_INSTITUTION'::text as nameid,'Can add an institution' as description ,true as def_value, true as value) as rp_data 


  	         --  where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 


  	         -- insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	         --  (select v_admin_id as login_role_id,'ACTION' as ptype, 'ACTION_MODIFY_INSTITUTION'::text as nameid,'Can modify an institution' as description ,true as def_value, true as value) as rp_data 


  	         --  where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 


  	         -- insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value) select login_role_id,ptype,nameid,description,def_value,value from 


  	         --  (select v_admin_id as login_role_id,'ACTION' as ptype, 'ACTION_DELETE_INSTITUTION'::text as nameid,'Can delete an institution' as description ,true as def_value, true as value) as rp_data 


  	         --  where not exists (select * from login_role_permission where v_admin_id = login_role_permission.login_role_id and login_role_permission.nameid = rp_data.nameid); 










  	  	    -- update other role if necessary 


  	  	    insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value,working_view,working_view_exist) 


  	          select roleid,alluserpermission.ptype,alluserpermission.nameid,alluserpermission.description,alluserpermission.def_value,alluserpermission.def_value,alluserpermission.working_view,alluserpermission.working_view_exist from (select login_role.id as roleid,ptype,nameid,description,def_value,value,working_view,working_view_exist from 


  	  	  (select login_role_permission.ptype,nameid,description,def_value,value,working_view,working_view_exist from login_role_permission,login_role where login_role_permission.login_role_id = login_role.id and login_role.id = v_admin_id) as adminpermission,login_role) as alluserpermission 


  	  	   left join login_role_permission on login_role_permission.login_role_id = roleid and  login_role_permission.nameid = alluserpermission.nameid 


  	  	   where id is null; 






  	    		return true; 


  	  	    END 


  	  	$$;


ALTER FUNCTION public.f_create_login_role_permission() OWNER TO postgres;

--
-- TOC entry 370 (class 1255 OID 25107)
-- Name: f_staffmember_equals_staff(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.f_staffmember_equals_staff() RETURNS trigger
    LANGUAGE plpgsql
    AS $$ 
	begin  
		new.staff_member_id := new.staff_id; 
	 
	return new; 
	end; 
$$;


ALTER FUNCTION public.f_staffmember_equals_staff() OWNER TO postgres;

--
-- TOC entry 415 (class 1255 OID 25108)
-- Name: f_tag_link(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.f_tag_link(in_exam_id integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
  	    DECLARE
  			v_list varchar;
  	    BEGIN

  		 v_list := null;
		select STRING_AGG (tag_link.tag_id::text,',') into v_list from tag_link where type = 'examlist' and ext_id = in_exam_id;
		RETURN v_list;

  	    END
  	$$;


ALTER FUNCTION public.f_tag_link(in_exam_id integer) OWNER TO postgres;

--
-- TOC entry 392 (class 1255 OID 25109)
-- Name: trg_init_login_role_permission(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.trg_init_login_role_permission() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  DECLARE
  v_admin_id integer;
  BEGIN

    v_admin_id := 0;
    insert into login_role_permission(login_role_id,ptype,nameid,description,def_value,value,working_view,working_view_exist)
    select NEW.id,ptype,nameid,description,def_value,def_value,working_view,working_view_exist from login_role_permission where login_role_id = v_admin_id;

    RETURN NEW;
  END;
  $$;


ALTER FUNCTION public.trg_init_login_role_permission() OWNER TO postgres;

--
-- TOC entry 382 (class 1255 OID 25110)
-- Name: trg_init_tag_department(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.trg_init_tag_department() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  DECLARE
  tag_id integer;
  site_id integer;
  site_name varchar;
  BEGIN
    select institution.id,institution.name into site_id, site_name from institution,department where institution.id = department.inst_id and department.id = NEW.id;

    insert into tag(type,name,removed) values('OR',site_name || ' ' || NEW.name,false) RETURNING id INTO tag_id;
    insert into tag_link(type,ext_id,tag_id) values('department',NEW.id,tag_id);
    RETURN NEW;
  END;
  $$;


ALTER FUNCTION public.trg_init_tag_department() OWNER TO postgres;

--
-- TOC entry 419 (class 1255 OID 25111)
-- Name: trg_init_tag_department_update(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.trg_init_tag_department_update() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  DECLARE
  tag_id integer;
  site_name varchar;
  site_id integer;
  BEGIN
    select institution.id,institution.name into site_id, site_name from institution,department where institution.id = department.inst_id and department.id = NEW.id;
    update tag set removed = NEW.removed, name = site_name || ' ' || NEW.name from tag_link where tag_link.type = 'department' and tag_link.ext_id = NEW.id and tag_link.tag_id = tag.id;
    RETURN NEW;
  END;
  $$;


ALTER FUNCTION public.trg_init_tag_department_update() OWNER TO postgres;

--
-- TOC entry 407 (class 1255 OID 25112)
-- Name: trg_init_tag_institution(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.trg_init_tag_institution() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  DECLARE
  tag_id integer;
  BEGIN
    insert into tag(type,name,removed) values('OR',NEW.name,false) RETURNING id INTO tag_id;
    insert into tag_link(type,ext_id,tag_id) values('institution',NEW.id,tag_id);
    RETURN NEW;
  END;
  $$;


ALTER FUNCTION public.trg_init_tag_institution() OWNER TO postgres;

--
-- TOC entry 406 (class 1255 OID 25113)
-- Name: trg_init_tag_institution_update(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.trg_init_tag_institution_update() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
  DECLARE
  tag_id integer;
  BEGIN
    update tag set removed = NEW.removed, name = NEW.name from tag_link where tag_link.type = 'institution' and tag_link.ext_id = NEW.id and tag_link.tag_id = tag.id;
    RETURN NEW;
  END;
  $$;


ALTER FUNCTION public.trg_init_tag_institution_update() OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 216 (class 1259 OID 25114)
-- Name: action; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action (
    id integer NOT NULL,
    description character varying,
    status_id integer,
    origine character varying,
    deadline timestamp with time zone,
    enddate timestamp with time zone,
    begdate timestamp with time zone NOT NULL,
    personincharge integer,
    removed boolean DEFAULT false,
    dep_id integer DEFAULT '-1'::integer
);


ALTER TABLE public.action OWNER TO postgres;

--
-- TOC entry 217 (class 1259 OID 25121)
-- Name: action_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.action_id_seq OWNER TO postgres;

--
-- TOC entry 5746 (class 0 OID 0)
-- Dependencies: 217
-- Name: action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.action_id_seq OWNED BY public.action.id;


--
-- TOC entry 218 (class 1259 OID 25122)
-- Name: action_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_link (
    id integer NOT NULL,
    action_id integer NOT NULL,
    ext_id integer NOT NULL,
    scope character varying NOT NULL
);


ALTER TABLE public.action_link OWNER TO postgres;

--
-- TOC entry 219 (class 1259 OID 25127)
-- Name: action_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.action_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.action_link_id_seq OWNER TO postgres;

--
-- TOC entry 5747 (class 0 OID 0)
-- Dependencies: 219
-- Name: action_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.action_link_id_seq OWNED BY public.action_link.id;


--
-- TOC entry 346 (class 1259 OID 26170)
-- Name: action_status_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.action_status_link (
    staff_member_id integer NOT NULL,
    document_id integer NOT NULL,
    last_opened timestamp without time zone,
    action_at timestamp without time zone,
    action_id integer,
    date timestamp without time zone,
    last_reminder timestamp without time zone
);


ALTER TABLE public.action_status_link OWNER TO postgres;

--
-- TOC entry 220 (class 1259 OID 25128)
-- Name: afcnsend; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.afcnsend (
    id integer NOT NULL,
    inst_id integer,
    dep_id integer,
    device_id integer,
    title character varying,
    senddate timestamp with time zone NOT NULL,
    sender integer,
    comment character varying,
    removed boolean DEFAULT false,
    status_id integer
);


ALTER TABLE public.afcnsend OWNER TO postgres;

--
-- TOC entry 221 (class 1259 OID 25134)
-- Name: afcnsend_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.afcnsend_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afcnsend_id_seq OWNER TO postgres;

--
-- TOC entry 5748 (class 0 OID 0)
-- Dependencies: 221
-- Name: afcnsend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.afcnsend_id_seq OWNED BY public.afcnsend.id;


--
-- TOC entry 222 (class 1259 OID 25135)
-- Name: agelist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.agelist (
    id integer NOT NULL,
    label character varying NOT NULL
);


ALTER TABLE public.agelist OWNER TO postgres;

--
-- TOC entry 223 (class 1259 OID 25140)
-- Name: agelist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.agelist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.agelist_id_seq OWNER TO postgres;

--
-- TOC entry 5749 (class 0 OID 0)
-- Dependencies: 223
-- Name: agelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.agelist_id_seq OWNED BY public.agelist.id;


--
-- TOC entry 224 (class 1259 OID 25141)
-- Name: audit; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.audit (
    id integer NOT NULL,
    inst_id integer DEFAULT '-1'::integer,
    dep_id integer DEFAULT '-1'::integer,
    date timestamp with time zone,
    origine integer,
    title character varying,
    comment character varying,
    status_id integer,
    personincharge integer,
    removed boolean DEFAULT false,
    type integer DEFAULT 2 NOT NULL,
    start_date timestamp(0) with time zone,
    end_date timestamp(0) with time zone
);


ALTER TABLE public.audit OWNER TO postgres;

--
-- TOC entry 225 (class 1259 OID 25150)
-- Name: audit_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.audit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.audit_id_seq OWNER TO postgres;

--
-- TOC entry 5750 (class 0 OID 0)
-- Dependencies: 225
-- Name: audit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.audit_id_seq OWNED BY public.audit.id;


--
-- TOC entry 226 (class 1259 OID 25151)
-- Name: audit_record; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.audit_record (
    id integer NOT NULL,
    audit_id integer NOT NULL,
    quaad_point_id integer NOT NULL,
    validated boolean DEFAULT false NOT NULL
);


ALTER TABLE public.audit_record OWNER TO postgres;

--
-- TOC entry 227 (class 1259 OID 25155)
-- Name: audit_record_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.audit_record_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.audit_record_id_seq OWNER TO postgres;

--
-- TOC entry 5751 (class 0 OID 0)
-- Dependencies: 227
-- Name: audit_record_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.audit_record_id_seq OWNED BY public.audit_record.id;


--
-- TOC entry 228 (class 1259 OID 25156)
-- Name: audit_recordprocedure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.audit_recordprocedure (
    id integer NOT NULL,
    audit_record_id integer NOT NULL,
    procedure_id integer NOT NULL,
    doc_id integer NOT NULL,
    remark text,
    status boolean DEFAULT false NOT NULL,
    forcedstatus boolean
);


ALTER TABLE public.audit_recordprocedure OWNER TO postgres;

--
-- TOC entry 229 (class 1259 OID 25162)
-- Name: audit_recordprocedure_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.audit_recordprocedure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.audit_recordprocedure_id_seq OWNER TO postgres;

--
-- TOC entry 5752 (class 0 OID 0)
-- Dependencies: 229
-- Name: audit_recordprocedure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.audit_recordprocedure_id_seq OWNED BY public.audit_recordprocedure.id;


--
-- TOC entry 230 (class 1259 OID 25163)
-- Name: audit_subrecord; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.audit_subrecord (
    id integer NOT NULL,
    audit_record_id integer NOT NULL,
    quaadpoint_tag_id integer NOT NULL,
    scope_id integer NOT NULL,
    scope2_id integer,
    force_doctext text,
    force_docid integer,
    remark text,
    status boolean DEFAULT false NOT NULL,
    forcedstatus boolean,
    doc_id integer NOT NULL,
    force_result character varying
);


ALTER TABLE public.audit_subrecord OWNER TO postgres;

--
-- TOC entry 231 (class 1259 OID 25169)
-- Name: audit_subrecord_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.audit_subrecord_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.audit_subrecord_id_seq OWNER TO postgres;

--
-- TOC entry 5753 (class 0 OID 0)
-- Dependencies: 231
-- Name: audit_subrecord_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.audit_subrecord_id_seq OWNED BY public.audit_subrecord.id;


--
-- TOC entry 232 (class 1259 OID 25170)
-- Name: audit_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.audit_type (
    id integer NOT NULL,
    name character varying NOT NULL,
    removed character varying DEFAULT false NOT NULL,
    maintype character varying
);


ALTER TABLE public.audit_type OWNER TO postgres;

--
-- TOC entry 233 (class 1259 OID 25176)
-- Name: audit_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.audit_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.audit_type_id_seq OWNER TO postgres;

--
-- TOC entry 5754 (class 0 OID 0)
-- Dependencies: 233
-- Name: audit_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.audit_type_id_seq OWNED BY public.audit_type.id;


--
-- TOC entry 349 (class 1259 OID 26769)
-- Name: civilitylist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.civilitylist (
    id integer NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.civilitylist OWNER TO postgres;

--
-- TOC entry 348 (class 1259 OID 26768)
-- Name: civilitylist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.civilitylist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.civilitylist_id_seq OWNER TO postgres;

--
-- TOC entry 5755 (class 0 OID 0)
-- Dependencies: 348
-- Name: civilitylist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.civilitylist_id_seq OWNED BY public.civilitylist.id;


--
-- TOC entry 345 (class 1259 OID 26153)
-- Name: default_action_needed; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.default_action_needed (
    document_type character varying,
    staff_role_id integer,
    department_id integer,
    id integer NOT NULL,
    action integer NOT NULL
);


ALTER TABLE public.default_action_needed OWNER TO postgres;

--
-- TOC entry 347 (class 1259 OID 26186)
-- Name: default_read_needed_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.default_action_needed ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME public.default_read_needed_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 234 (class 1259 OID 25177)
-- Name: department; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.department (
    id integer NOT NULL,
    name character varying NOT NULL,
    inst_id integer,
    removed boolean DEFAULT false
);


ALTER TABLE public.department OWNER TO postgres;

--
-- TOC entry 235 (class 1259 OID 25183)
-- Name: department_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.department_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.department_id_seq OWNER TO postgres;

--
-- TOC entry 5756 (class 0 OID 0)
-- Dependencies: 235
-- Name: department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.department_id_seq OWNED BY public.department.id;


--
-- TOC entry 236 (class 1259 OID 25184)
-- Name: device; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device (
    id integer NOT NULL,
    name character varying,
    brand character varying,
    model character varying,
    serialnumber character varying,
    removed boolean DEFAULT false,
    ris_name character varying,
    pacs_name character varying,
    dacs_name character varying,
    modalitytype character varying DEFAULT 'RX'::character varying NOT NULL,
    photo bytea
);


ALTER TABLE public.device OWNER TO postgres;

--
-- TOC entry 237 (class 1259 OID 25191)
-- Name: device_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.device_id_seq OWNER TO postgres;

--
-- TOC entry 5757 (class 0 OID 0)
-- Dependencies: 237
-- Name: device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_id_seq OWNED BY public.device.id;


--
-- TOC entry 238 (class 1259 OID 25192)
-- Name: device_inspection; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_inspection (
    id integer NOT NULL,
    device_id integer NOT NULL,
    inspection_date timestamp with time zone,
    planned_date timestamp with time zone,
    result integer,
    comment character varying,
    type character varying,
    status_id integer,
    removed boolean DEFAULT false
);


ALTER TABLE public.device_inspection OWNER TO postgres;

--
-- TOC entry 239 (class 1259 OID 25198)
-- Name: device_inspection_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_inspection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.device_inspection_id_seq OWNER TO postgres;

--
-- TOC entry 5758 (class 0 OID 0)
-- Dependencies: 239
-- Name: device_inspection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_inspection_id_seq OWNED BY public.device_inspection.id;


--
-- TOC entry 240 (class 1259 OID 25199)
-- Name: device_installation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_installation (
    id integer NOT NULL,
    device_id integer NOT NULL,
    dep_id integer NOT NULL,
    installdate timestamp with time zone NOT NULL,
    removeddate timestamp with time zone,
    removed boolean DEFAULT false,
    installedby character varying DEFAULT ''::character varying,
    inchargeof character varying DEFAULT ''::character varying,
    comment character varying DEFAULT ''::character varying
);


ALTER TABLE public.device_installation OWNER TO postgres;

--
-- TOC entry 241 (class 1259 OID 25208)
-- Name: device_installation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_installation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.device_installation_id_seq OWNER TO postgres;

--
-- TOC entry 5759 (class 0 OID 0)
-- Dependencies: 241
-- Name: device_installation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_installation_id_seq OWNED BY public.device_installation.id;


--
-- TOC entry 242 (class 1259 OID 25209)
-- Name: device_maintenance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_maintenance (
    id integer NOT NULL,
    device_id integer NOT NULL,
    maintenance_date timestamp with time zone,
    planned_date timestamp with time zone,
    result integer,
    comment character varying,
    type character varying,
    status_id integer,
    removed boolean DEFAULT false
);


ALTER TABLE public.device_maintenance OWNER TO postgres;

--
-- TOC entry 243 (class 1259 OID 25215)
-- Name: device_maintenance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_maintenance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.device_maintenance_id_seq OWNER TO postgres;

--
-- TOC entry 5760 (class 0 OID 0)
-- Dependencies: 243
-- Name: device_maintenance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_maintenance_id_seq OWNED BY public.device_maintenance.id;


--
-- TOC entry 244 (class 1259 OID 25216)
-- Name: document; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.document (
    id integer NOT NULL,
    file character varying,
    realfilename character varying,
    folder character varying NOT NULL,
    type character varying DEFAULT 'PDF'::character varying NOT NULL,
    creation_date timestamp with time zone DEFAULT now() NOT NULL,
    removed boolean DEFAULT false,
    revision integer DEFAULT 1 NOT NULL,
    label character varying DEFAULT ''::character varying,
    comment character varying DEFAULT ''::character varying,
    uploadedby integer NOT NULL,
    doc_master_id integer NOT NULL,
    sourcefile character varying,
    sourcerealfilename character varying,
    extern_link character varying,
    upload_date timestamp with time zone DEFAULT now() NOT NULL,
    valid_until_date timestamp with time zone DEFAULT to_timestamp('29991231235959'::text, 'YYYYMMDDHH24MISS'::text) NOT NULL,
    modification_date timestamp with time zone DEFAULT now()
);


ALTER TABLE public.document OWNER TO postgres;

--
-- TOC entry 245 (class 1259 OID 25229)
-- Name: document_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.document_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.document_id_seq OWNER TO postgres;

--
-- TOC entry 5761 (class 0 OID 0)
-- Dependencies: 245
-- Name: document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.document_id_seq OWNED BY public.document.id;


--
-- TOC entry 246 (class 1259 OID 25230)
-- Name: document_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.document_link (
    id integer NOT NULL,
    type character varying NOT NULL,
    ext_id integer,
    doc_id integer
);


ALTER TABLE public.document_link OWNER TO postgres;

--
-- TOC entry 5762 (class 0 OID 0)
-- Dependencies: 246
-- Name: COLUMN document_link.type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.document_link.type IS 'doit être le nom de la table à lier';


--
-- TOC entry 247 (class 1259 OID 25235)
-- Name: document_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.document_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.document_link_id_seq OWNER TO postgres;

--
-- TOC entry 5763 (class 0 OID 0)
-- Dependencies: 247
-- Name: document_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.document_link_id_seq OWNED BY public.document_link.id;


--
-- TOC entry 248 (class 1259 OID 25236)
-- Name: document_master; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.document_master (
    id integer NOT NULL,
    name character varying NOT NULL,
    removed boolean DEFAULT false
);


ALTER TABLE public.document_master OWNER TO postgres;

--
-- TOC entry 249 (class 1259 OID 25242)
-- Name: document_master_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.document_master_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.document_master_id_seq OWNER TO postgres;

--
-- TOC entry 5764 (class 0 OID 0)
-- Dependencies: 249
-- Name: document_master_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.document_master_id_seq OWNED BY public.document_master.id;


--
-- TOC entry 250 (class 1259 OID 25243)
-- Name: documentstatus; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.documentstatus (
    id integer NOT NULL,
    begdate timestamp with time zone NOT NULL,
    enddate timestamp with time zone DEFAULT '2999-12-31 00:00:00+01'::timestamp with time zone NOT NULL,
    doc_id integer NOT NULL,
    status_id integer NOT NULL
);


ALTER TABLE public.documentstatus OWNER TO postgres;

--
-- TOC entry 251 (class 1259 OID 25247)
-- Name: documentstatus_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.documentstatus_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documentstatus_id_seq OWNER TO postgres;

--
-- TOC entry 5765 (class 0 OID 0)
-- Dependencies: 251
-- Name: documentstatus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.documentstatus_id_seq OWNED BY public.documentstatus.id;


--
-- TOC entry 351 (class 1259 OID 26820)
-- Name: documenttypelist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.documenttypelist (
    id integer NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.documenttypelist OWNER TO postgres;

--
-- TOC entry 350 (class 1259 OID 26819)
-- Name: documenttypelist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.documenttypelist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documenttypelist_id_seq OWNER TO postgres;

--
-- TOC entry 5766 (class 0 OID 0)
-- Dependencies: 350
-- Name: documenttypelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.documenttypelist_id_seq OWNED BY public.documenttypelist.id;


--
-- TOC entry 252 (class 1259 OID 25248)
-- Name: enum_listvalue; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.enum_listvalue (
    scope character varying,
    value integer,
    name character varying,
    lang character varying
);


ALTER TABLE public.enum_listvalue OWNER TO postgres;

--
-- TOC entry 253 (class 1259 OID 25253)
-- Name: examident; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.examident (
    id integer NOT NULL,
    name character varying NOT NULL,
    description character varying NOT NULL,
    removed boolean DEFAULT false
);


ALTER TABLE public.examident OWNER TO postgres;

--
-- TOC entry 254 (class 1259 OID 25259)
-- Name: examident_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.examident_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.examident_id_seq OWNER TO postgres;

--
-- TOC entry 5767 (class 0 OID 0)
-- Dependencies: 254
-- Name: examident_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.examident_id_seq OWNED BY public.examident.id;


--
-- TOC entry 255 (class 1259 OID 25260)
-- Name: examident_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.examident_link (
    exam_id integer,
    examident_id integer
);


ALTER TABLE public.examident_link OWNER TO postgres;

--
-- TOC entry 256 (class 1259 OID 25263)
-- Name: examlist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.examlist (
    id integer NOT NULL,
    modality character varying,
    nameid character varying,
    description character varying,
    removed boolean DEFAULT false
);


ALTER TABLE public.examlist OWNER TO postgres;

--
-- TOC entry 257 (class 1259 OID 25269)
-- Name: examlist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.examlist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.examlist_id_seq OWNER TO postgres;

--
-- TOC entry 5768 (class 0 OID 0)
-- Dependencies: 257
-- Name: examlist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.examlist_id_seq OWNED BY public.examlist.id;


--
-- TOC entry 258 (class 1259 OID 25270)
-- Name: examwarning; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.examwarning (
    id integer NOT NULL,
    title character varying,
    description character varying,
    removed boolean DEFAULT false,
    sex_id integer,
    age_id integer
);


ALTER TABLE public.examwarning OWNER TO postgres;

--
-- TOC entry 259 (class 1259 OID 25276)
-- Name: examwarning_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.examwarning_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.examwarning_id_seq OWNER TO postgres;

--
-- TOC entry 5769 (class 0 OID 0)
-- Dependencies: 259
-- Name: examwarning_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.examwarning_id_seq OWNED BY public.examwarning.id;


--
-- TOC entry 260 (class 1259 OID 25277)
-- Name: examwarning_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.examwarning_link (
    exam_id integer,
    examwarning_id integer
);


ALTER TABLE public.examwarning_link OWNER TO postgres;

--
-- TOC entry 261 (class 1259 OID 25280)
-- Name: external_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.external_link (
    id integer NOT NULL,
    table_name character varying NOT NULL,
    table_id bigint NOT NULL,
    ext_id character varying NOT NULL,
    ext_src integer NOT NULL
);


ALTER TABLE public.external_link OWNER TO postgres;

--
-- TOC entry 262 (class 1259 OID 25285)
-- Name: external_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.external_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.external_link_id_seq OWNER TO postgres;

--
-- TOC entry 5770 (class 0 OID 0)
-- Dependencies: 262
-- Name: external_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.external_link_id_seq OWNED BY public.external_link.id;


--
-- TOC entry 263 (class 1259 OID 25286)
-- Name: external_src; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.external_src (
    id integer NOT NULL,
    src_name character varying NOT NULL
);


ALTER TABLE public.external_src OWNER TO postgres;

--
-- TOC entry 264 (class 1259 OID 25291)
-- Name: external_src_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.external_src_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.external_src_id_seq OWNER TO postgres;

--
-- TOC entry 5771 (class 0 OID 0)
-- Dependencies: 264
-- Name: external_src_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.external_src_id_seq OWNED BY public.external_src.id;


--
-- TOC entry 265 (class 1259 OID 25292)
-- Name: institution; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.institution (
    id integer NOT NULL,
    name character varying NOT NULL,
    removed boolean DEFAULT false
);


ALTER TABLE public.institution OWNER TO postgres;

--
-- TOC entry 266 (class 1259 OID 25298)
-- Name: institution_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.institution_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.institution_id_seq OWNER TO postgres;

--
-- TOC entry 5772 (class 0 OID 0)
-- Dependencies: 266
-- Name: institution_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.institution_id_seq OWNED BY public.institution.id;


--
-- TOC entry 267 (class 1259 OID 25299)
-- Name: legaldocument; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.legaldocument (
    id integer NOT NULL,
    name character varying,
    type character varying,
    comment character varying,
    removed boolean DEFAULT false
);


ALTER TABLE public.legaldocument OWNER TO postgres;

--
-- TOC entry 268 (class 1259 OID 25305)
-- Name: legaldocument_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.legaldocument_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.legaldocument_id_seq OWNER TO postgres;

--
-- TOC entry 5773 (class 0 OID 0)
-- Dependencies: 268
-- Name: legaldocument_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.legaldocument_id_seq OWNED BY public.legaldocument.id;


--
-- TOC entry 269 (class 1259 OID 25306)
-- Name: link_quaad_tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.link_quaad_tag (
    id_quaadpoint integer NOT NULL,
    id_tag integer NOT NULL
);


ALTER TABLE public.link_quaad_tag OWNER TO postgres;

--
-- TOC entry 270 (class 1259 OID 25309)
-- Name: link_scope_view; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.link_scope_view (
    scope character varying NOT NULL,
    view character varying
);


ALTER TABLE public.link_scope_view OWNER TO postgres;

--
-- TOC entry 271 (class 1259 OID 25314)
-- Name: login_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.login_role (
    id integer NOT NULL,
    name character varying,
    removed boolean DEFAULT false
);


ALTER TABLE public.login_role OWNER TO postgres;

--
-- TOC entry 272 (class 1259 OID 25320)
-- Name: login_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.login_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.login_role_id_seq OWNER TO postgres;

--
-- TOC entry 5774 (class 0 OID 0)
-- Dependencies: 272
-- Name: login_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.login_role_id_seq OWNED BY public.login_role.id;


--
-- TOC entry 273 (class 1259 OID 25321)
-- Name: login_role_permission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.login_role_permission (
    id integer NOT NULL,
    ptype character varying DEFAULT ''::character varying,
    nameid character varying NOT NULL,
    description character varying DEFAULT ''::character varying,
    def_value boolean DEFAULT false,
    value boolean DEFAULT false,
    working_view boolean DEFAULT false,
    working_view_exist boolean DEFAULT false,
    login_role_id integer NOT NULL
);


ALTER TABLE public.login_role_permission OWNER TO postgres;

--
-- TOC entry 274 (class 1259 OID 25332)
-- Name: login_role_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.login_role_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.login_role_permission_id_seq OWNER TO postgres;

--
-- TOC entry 5775 (class 0 OID 0)
-- Dependencies: 274
-- Name: login_role_permission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.login_role_permission_id_seq OWNED BY public.login_role_permission.id;


--
-- TOC entry 275 (class 1259 OID 25333)
-- Name: procedure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.procedure (
    id integer NOT NULL,
    name_en character varying,
    name_fr character varying,
    name_nl character varying,
    comment character varying,
    removed boolean DEFAULT false,
    type integer
);


ALTER TABLE public.procedure OWNER TO postgres;

--
-- TOC entry 276 (class 1259 OID 25339)
-- Name: procedure_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.procedure_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.procedure_id_seq OWNER TO postgres;

--
-- TOC entry 5776 (class 0 OID 0)
-- Dependencies: 276
-- Name: procedure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.procedure_id_seq OWNED BY public.procedure.id;


--
-- TOC entry 277 (class 1259 OID 25340)
-- Name: quaad_description; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quaad_description (
    id integer NOT NULL,
    id_quaadpoint integer NOT NULL,
    language character varying NOT NULL,
    description character varying,
    description_summary character varying
);


ALTER TABLE public.quaad_description OWNER TO postgres;

--
-- TOC entry 278 (class 1259 OID 25345)
-- Name: quaad_description_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quaad_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.quaad_description_id_seq OWNER TO postgres;

--
-- TOC entry 5777 (class 0 OID 0)
-- Dependencies: 278
-- Name: quaad_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quaad_description_id_seq OWNED BY public.quaad_description.id;


--
-- TOC entry 279 (class 1259 OID 25346)
-- Name: quaad_nameinscope; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quaad_nameinscope (
    scope_name character varying NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.quaad_nameinscope OWNER TO postgres;

--
-- TOC entry 280 (class 1259 OID 25351)
-- Name: quaad_point; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quaad_point (
    id integer NOT NULL,
    level1 integer DEFAULT '-1'::integer NOT NULL,
    level2 integer DEFAULT '-1'::integer NOT NULL,
    level3 integer DEFAULT '-1'::integer NOT NULL,
    level4 integer DEFAULT '-1'::integer NOT NULL,
    level5 integer DEFAULT '-1'::integer NOT NULL,
    inlevelorder integer DEFAULT 1 NOT NULL,
    istitle boolean DEFAULT false,
    datebeg date,
    dateend date,
    quaadversion integer
);


ALTER TABLE public.quaad_point OWNER TO postgres;

--
-- TOC entry 281 (class 1259 OID 25361)
-- Name: quaad_point_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quaad_point_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.quaad_point_id_seq OWNER TO postgres;

--
-- TOC entry 5778 (class 0 OID 0)
-- Dependencies: 281
-- Name: quaad_point_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quaad_point_id_seq OWNED BY public.quaad_point.id;


--
-- TOC entry 282 (class 1259 OID 25362)
-- Name: quaadpoint_tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quaadpoint_tag (
    id integer NOT NULL,
    procedure_needed character varying,
    documents_needed integer DEFAULT 0 NOT NULL,
    scope character varying NOT NULL,
    additional_param character varying,
    period integer DEFAULT '-1'::integer NOT NULL,
    scope2 character varying,
    where_notagid character varying DEFAULT false NOT NULL,
    isglobalscope boolean DEFAULT false NOT NULL,
    document_scope character varying DEFAULT 'institution'::character varying NOT NULL
);


ALTER TABLE public.quaadpoint_tag OWNER TO postgres;

--
-- TOC entry 283 (class 1259 OID 25372)
-- Name: quaadpoint_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quaadpoint_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.quaadpoint_tag_id_seq OWNER TO postgres;

--
-- TOC entry 5779 (class 0 OID 0)
-- Dependencies: 283
-- Name: quaadpoint_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quaadpoint_tag_id_seq OWNED BY public.quaadpoint_tag.id;


--
-- TOC entry 284 (class 1259 OID 25373)
-- Name: quaadpoint_tag_name; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quaadpoint_tag_name (
    id integer NOT NULL,
    name character varying NOT NULL,
    language character varying DEFAULT 'FR'::character varying NOT NULL,
    id_quaadpoint_tag integer NOT NULL
);


ALTER TABLE public.quaadpoint_tag_name OWNER TO postgres;

--
-- TOC entry 285 (class 1259 OID 25379)
-- Name: quaadpoint_tag_name_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quaadpoint_tag_name_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.quaadpoint_tag_name_id_seq OWNER TO postgres;

--
-- TOC entry 5780 (class 0 OID 0)
-- Dependencies: 285
-- Name: quaadpoint_tag_name_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quaadpoint_tag_name_id_seq OWNED BY public.quaadpoint_tag_name.id;


--
-- TOC entry 286 (class 1259 OID 25380)
-- Name: quaadtag_doc_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quaadtag_doc_link (
    id_quaadtag integer NOT NULL,
    id_doclink integer NOT NULL
);


ALTER TABLE public.quaadtag_doc_link OWNER TO postgres;

--
-- TOC entry 287 (class 1259 OID 25383)
-- Name: report; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.report (
    id integer NOT NULL,
    severity integer DEFAULT 0,
    title character varying,
    reportdate timestamp with time zone NOT NULL,
    closeddate timestamp with time zone,
    reporter integer,
    comment character varying DEFAULT ''::character varying,
    statuscomment character varying DEFAULT ''::character varying,
    status_id integer,
    dep_id integer,
    removed boolean DEFAULT false
);


ALTER TABLE public.report OWNER TO postgres;

--
-- TOC entry 288 (class 1259 OID 25392)
-- Name: report_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_id_seq OWNER TO postgres;

--
-- TOC entry 5781 (class 0 OID 0)
-- Dependencies: 288
-- Name: report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.report_id_seq OWNED BY public.report.id;


--
-- TOC entry 289 (class 1259 OID 25393)
-- Name: sequpdate_state; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sequpdate_state (
    updateid character varying NOT NULL,
    uid double precision
);


ALTER TABLE public.sequpdate_state OWNER TO postgres;

--
-- TOC entry 290 (class 1259 OID 25398)
-- Name: sexlist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sexlist (
    id integer NOT NULL,
    label character varying NOT NULL
);


ALTER TABLE public.sexlist OWNER TO postgres;

--
-- TOC entry 291 (class 1259 OID 25403)
-- Name: sexlist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sexlist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sexlist_id_seq OWNER TO postgres;

--
-- TOC entry 5782 (class 0 OID 0)
-- Dependencies: 291
-- Name: sexlist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sexlist_id_seq OWNED BY public.sexlist.id;


--
-- TOC entry 292 (class 1259 OID 25404)
-- Name: staff_formation; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.staff_formation (
    id integer NOT NULL,
    staff_id integer NOT NULL,
    formation_date timestamp with time zone,
    planned_date timestamp with time zone,
    title character varying,
    comment character varying,
    type character varying,
    status_id integer,
    removed boolean DEFAULT false,
    staff_member_id integer
);


ALTER TABLE public.staff_formation OWNER TO postgres;

--
-- TOC entry 293 (class 1259 OID 25410)
-- Name: staff_formation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.staff_formation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.staff_formation_id_seq OWNER TO postgres;

--
-- TOC entry 5783 (class 0 OID 0)
-- Dependencies: 293
-- Name: staff_formation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.staff_formation_id_seq OWNED BY public.staff_formation.id;


--
-- TOC entry 294 (class 1259 OID 25411)
-- Name: staff_job; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.staff_job (
    id integer NOT NULL,
    dep_id integer NOT NULL,
    staff_id integer NOT NULL,
    begdate timestamp with time zone NOT NULL,
    enddate timestamp with time zone DEFAULT '2999-12-31 00:00:00+01'::timestamp with time zone NOT NULL,
    staff_role_id integer NOT NULL,
    active boolean DEFAULT false,
    removed boolean DEFAULT false
);


ALTER TABLE public.staff_job OWNER TO postgres;

--
-- TOC entry 295 (class 1259 OID 25417)
-- Name: staff_job_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.staff_job_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.staff_job_id_seq OWNER TO postgres;

--
-- TOC entry 5784 (class 0 OID 0)
-- Dependencies: 295
-- Name: staff_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.staff_job_id_seq OWNED BY public.staff_job.id;


--
-- TOC entry 296 (class 1259 OID 25418)
-- Name: staff_member; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.staff_member (
    id integer NOT NULL,
    lastname character varying,
    firstname character varying,
    removed boolean DEFAULT false,
    login character varying NOT NULL,
    password character varying NOT NULL,
    login_role_id integer,
    active boolean DEFAULT false,
    ris_name character varying,
    pacs_name character varying,
    dacs_name character varying,
    photo bytea,
    email character varying,
    civility_id integer
);


ALTER TABLE public.staff_member OWNER TO postgres;

--
-- TOC entry 297 (class 1259 OID 25425)
-- Name: staff_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.staff_member_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.staff_member_id_seq OWNER TO postgres;

--
-- TOC entry 5785 (class 0 OID 0)
-- Dependencies: 297
-- Name: staff_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.staff_member_id_seq OWNED BY public.staff_member.id;


--
-- TOC entry 298 (class 1259 OID 25426)
-- Name: staff_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.staff_role (
    id integer NOT NULL,
    name character varying,
    removed boolean DEFAULT false,
    scope_id integer DEFAULT 1
);


ALTER TABLE public.staff_role OWNER TO postgres;

--
-- TOC entry 5786 (class 0 OID 0)
-- Dependencies: 298
-- Name: TABLE staff_role; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.staff_role IS 'Scope ID : {0 = institution}, {1 = departement}';


--
-- TOC entry 299 (class 1259 OID 25433)
-- Name: staff_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.staff_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.staff_role_id_seq OWNER TO postgres;

--
-- TOC entry 5787 (class 0 OID 0)
-- Dependencies: 299
-- Name: staff_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.staff_role_id_seq OWNED BY public.staff_role.id;


--
-- TOC entry 300 (class 1259 OID 25434)
-- Name: statuslist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.statuslist (
    id integer NOT NULL,
    status_name character varying NOT NULL,
    type character varying
);


ALTER TABLE public.statuslist OWNER TO postgres;

--
-- TOC entry 5788 (class 0 OID 0)
-- Dependencies: 300
-- Name: COLUMN statuslist.type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.statuslist.type IS 'active status for table';


--
-- TOC entry 301 (class 1259 OID 25439)
-- Name: statuslist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.statuslist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.statuslist_id_seq OWNER TO postgres;

--
-- TOC entry 5789 (class 0 OID 0)
-- Dependencies: 301
-- Name: statuslist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.statuslist_id_seq OWNED BY public.statuslist.id;


--
-- TOC entry 302 (class 1259 OID 25440)
-- Name: survey; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.survey (
    id integer NOT NULL,
    title character varying NOT NULL,
    description character varying,
    type integer NOT NULL,
    status integer NOT NULL,
    begindate timestamp(0) with time zone,
    enddate timestamp(0) with time zone,
    comment character varying,
    conclusion character varying,
    removed boolean DEFAULT false
);


ALTER TABLE public.survey OWNER TO postgres;

--
-- TOC entry 303 (class 1259 OID 25446)
-- Name: survey_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.survey_field (
    id integer NOT NULL,
    content character varying,
    type integer NOT NULL,
    survey_id integer NOT NULL,
    "position" integer NOT NULL
);


ALTER TABLE public.survey_field OWNER TO postgres;

--
-- TOC entry 304 (class 1259 OID 25451)
-- Name: survey_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.survey_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.survey_field_id_seq OWNER TO postgres;

--
-- TOC entry 5790 (class 0 OID 0)
-- Dependencies: 304
-- Name: survey_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.survey_field_id_seq OWNED BY public.survey_field.id;


--
-- TOC entry 305 (class 1259 OID 25452)
-- Name: survey_field_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.survey_field_type (
    id integer NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.survey_field_type OWNER TO postgres;

--
-- TOC entry 306 (class 1259 OID 25457)
-- Name: survey_field_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.survey_field_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.survey_field_type_id_seq OWNER TO postgres;

--
-- TOC entry 5791 (class 0 OID 0)
-- Dependencies: 306
-- Name: survey_field_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.survey_field_type_id_seq OWNED BY public.survey_field_type.id;


--
-- TOC entry 307 (class 1259 OID 25458)
-- Name: survey_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.survey_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.survey_id_seq OWNER TO postgres;

--
-- TOC entry 5792 (class 0 OID 0)
-- Dependencies: 307
-- Name: survey_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.survey_id_seq OWNED BY public.survey.id;


--
-- TOC entry 308 (class 1259 OID 25459)
-- Name: survey_resp; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.survey_resp (
    id integer NOT NULL,
    survey_id integer NOT NULL,
    rdate timestamp(0) with time zone
);


ALTER TABLE public.survey_resp OWNER TO postgres;

--
-- TOC entry 309 (class 1259 OID 25462)
-- Name: survey_resp_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.survey_resp_field (
    id integer NOT NULL,
    field_id integer NOT NULL,
    value integer NOT NULL,
    resp_id integer NOT NULL,
    value_text character varying
);


ALTER TABLE public.survey_resp_field OWNER TO postgres;

--
-- TOC entry 310 (class 1259 OID 25467)
-- Name: survey_resp_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.survey_resp_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.survey_resp_field_id_seq OWNER TO postgres;

--
-- TOC entry 5793 (class 0 OID 0)
-- Dependencies: 310
-- Name: survey_resp_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.survey_resp_field_id_seq OWNED BY public.survey_resp_field.id;


--
-- TOC entry 311 (class 1259 OID 25468)
-- Name: survey_resp_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.survey_resp_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.survey_resp_id_seq OWNER TO postgres;

--
-- TOC entry 5794 (class 0 OID 0)
-- Dependencies: 311
-- Name: survey_resp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.survey_resp_id_seq OWNED BY public.survey_resp.id;


--
-- TOC entry 312 (class 1259 OID 25469)
-- Name: survey_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.survey_type (
    id integer NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.survey_type OWNER TO postgres;

--
-- TOC entry 313 (class 1259 OID 25474)
-- Name: survey_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.survey_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.survey_type_id_seq OWNER TO postgres;

--
-- TOC entry 5795 (class 0 OID 0)
-- Dependencies: 313
-- Name: survey_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.survey_type_id_seq OWNED BY public.survey_type.id;


--
-- TOC entry 314 (class 1259 OID 25475)
-- Name: tag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tag (
    id integer NOT NULL,
    type character varying,
    name character varying NOT NULL,
    removed boolean DEFAULT false
);


ALTER TABLE public.tag OWNER TO postgres;

--
-- TOC entry 315 (class 1259 OID 25481)
-- Name: tag_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tag_id_seq OWNER TO postgres;

--
-- TOC entry 5796 (class 0 OID 0)
-- Dependencies: 315
-- Name: tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tag_id_seq OWNED BY public.tag.id;


--
-- TOC entry 316 (class 1259 OID 25482)
-- Name: tag_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tag_link (
    id integer NOT NULL,
    type character varying NOT NULL,
    ext_id integer,
    tag_id integer
);


ALTER TABLE public.tag_link OWNER TO postgres;

--
-- TOC entry 5797 (class 0 OID 0)
-- Dependencies: 316
-- Name: COLUMN tag_link.type; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.tag_link.type IS 'doit être le nom de la table à lier';


--
-- TOC entry 317 (class 1259 OID 25487)
-- Name: tag_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tag_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tag_link_id_seq OWNER TO postgres;

--
-- TOC entry 5798 (class 0 OID 0)
-- Dependencies: 317
-- Name: tag_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tag_link_id_seq OWNED BY public.tag_link.id;


--
-- TOC entry 354 (class 1259 OID 29856)
-- Name: task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task (
    id integer NOT NULL,
    task_master_id integer NOT NULL,
    due_date timestamp with time zone NOT NULL,
    title character varying NOT NULL,
    description character varying,
    comment character varying,
    status_id integer DEFAULT 3,
    removed boolean DEFAULT false,
    closing_date timestamp with time zone
);


ALTER TABLE public.task OWNER TO postgres;

--
-- TOC entry 352 (class 1259 OID 29854)
-- Name: task_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.task_id_seq OWNER TO postgres;

--
-- TOC entry 5799 (class 0 OID 0)
-- Dependencies: 352
-- Name: task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_id_seq OWNED BY public.task.id;


--
-- TOC entry 356 (class 1259 OID 29868)
-- Name: task_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task_link (
    id integer NOT NULL,
    task_id integer NOT NULL,
    staff_member_id integer NOT NULL,
    status_id integer NOT NULL,
    comment character varying,
    status_date timestamp with time zone,
    last_reminder timestamp with time zone,
    last_reminder_staff_id integer
);


ALTER TABLE public.task_link OWNER TO postgres;

--
-- TOC entry 355 (class 1259 OID 29867)
-- Name: task_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.task_link_id_seq OWNER TO postgres;

--
-- TOC entry 5800 (class 0 OID 0)
-- Dependencies: 355
-- Name: task_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_link_id_seq OWNED BY public.task_link.id;


--
-- TOC entry 358 (class 1259 OID 29875)
-- Name: task_master; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task_master (
    id integer NOT NULL,
    title character varying NOT NULL,
    description character varying,
    start_date timestamp with time zone NOT NULL,
    end_date timestamp with time zone DEFAULT '2099-12-31 00:00:00+01'::timestamp with time zone,
    recurrence integer DEFAULT 0 NOT NULL,
    day_of_week character varying DEFAULT '-1'::character varying NOT NULL,
    active boolean DEFAULT true NOT NULL,
    dep_id integer DEFAULT '-1'::integer NOT NULL,
    removed boolean DEFAULT false NOT NULL,
    closing_type integer DEFAULT 0
);


ALTER TABLE public.task_master OWNER TO postgres;

--
-- TOC entry 357 (class 1259 OID 29874)
-- Name: task_master_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_master_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.task_master_id_seq OWNER TO postgres;

--
-- TOC entry 5801 (class 0 OID 0)
-- Dependencies: 357
-- Name: task_master_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_master_id_seq OWNED BY public.task_master.id;


--
-- TOC entry 360 (class 1259 OID 29891)
-- Name: task_master_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task_master_link (
    id integer NOT NULL,
    task_master_id integer NOT NULL,
    staff_member_id integer NOT NULL
);


ALTER TABLE public.task_master_link OWNER TO postgres;

--
-- TOC entry 359 (class 1259 OID 29890)
-- Name: task_master_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_master_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.task_master_link_id_seq OWNER TO postgres;

--
-- TOC entry 5802 (class 0 OID 0)
-- Dependencies: 359
-- Name: task_master_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_master_link_id_seq OWNED BY public.task_master_link.id;


--
-- TOC entry 353 (class 1259 OID 29855)
-- Name: task_task_master_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_task_master_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.task_task_master_id_seq OWNER TO postgres;

--
-- TOC entry 5803 (class 0 OID 0)
-- Dependencies: 353
-- Name: task_task_master_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_task_master_id_seq OWNED BY public.task.task_master_id;


--
-- TOC entry 318 (class 1259 OID 25488)
-- Name: v_alert; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert AS
 SELECT 'device_inspection'::character varying AS type,
    device.name,
        CASE
            WHEN ((now())::date >= (device_inspection.planned_date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (device_inspection.planned_date)::date) THEN 2
            ELSE 1
        END AS level,
    device_inspection.planned_date,
    ''::character varying AS title
   FROM public.device_inspection,
    public.device
  WHERE ((device.id = device_inspection.device_id) AND (device_inspection.status_id = 3) AND (device_inspection.planned_date IS NOT NULL))
UNION ALL
 SELECT 'staff_formation'::character varying AS type,
    (((staff_member.lastname)::text || ' '::text) || (staff_member.firstname)::text) AS name,
        CASE
            WHEN ((now())::date >= (staff_formation.planned_date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (staff_formation.planned_date)::date) THEN 2
            ELSE 1
        END AS level,
    staff_formation.planned_date,
    staff_formation.title
   FROM public.staff_formation,
    public.staff_member
  WHERE ((staff_member.id = staff_formation.staff_id) AND (staff_formation.status_id = 3) AND (staff_formation.planned_date IS NOT NULL))
UNION ALL
 SELECT 'action'::character varying AS type,
    action.description AS name,
        CASE
            WHEN ((now())::date >= (action.deadline)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (action.deadline)::date) THEN 2
            ELSE 1
        END AS level,
    action.deadline AS planned_date,
    action.origine AS title
   FROM public.action
  WHERE ((action.removed = false) AND (action.status_id = 3) AND (action.deadline IS NOT NULL));


ALTER VIEW public.v_alert OWNER TO postgres;

--
-- TOC entry 319 (class 1259 OID 25493)
-- Name: v_alert_action; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_action AS
 SELECT description,
        CASE
            WHEN ((now())::date >= (deadline)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (deadline)::date) THEN 2
            ELSE 1
        END AS level,
    deadline,
    origine AS title,
    dep_id
   FROM public.action
  WHERE ((removed = false) AND (status_id = 3) AND (deadline IS NOT NULL));


ALTER VIEW public.v_alert_action OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 25497)
-- Name: v_alert_afcnsend; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_afcnsend AS
 SELECT afcnsend.id,
        CASE
            WHEN ((now())::date >= (afcnsend.senddate)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (afcnsend.senddate)::date) THEN 2
            ELSE 1
        END AS level,
    afcnsend.senddate,
    afcnsend.comment,
    department.name AS department,
    department.id AS dep_id
   FROM (public.afcnsend
     LEFT JOIN public.department ON ((afcnsend.dep_id = department.id)))
  WHERE ((afcnsend.removed = false) AND (afcnsend.status_id = 3) AND (afcnsend.senddate IS NOT NULL));


ALTER VIEW public.v_alert_afcnsend OWNER TO postgres;

--
-- TOC entry 321 (class 1259 OID 25502)
-- Name: v_alert_audit; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_audit AS
 SELECT id,
        CASE
            WHEN ((now())::date >= (date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (date)::date) THEN 2
            ELSE 1
        END AS level,
    date,
    title,
    inst_id,
    dep_id
   FROM public.audit
  WHERE ((removed = false) AND (status_id = 3) AND (date IS NOT NULL));


ALTER VIEW public.v_alert_audit OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 25506)
-- Name: v_alert_device_inspection; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_device_inspection AS
 SELECT device.id,
    device.name,
        CASE
            WHEN ((now())::date >= (device_inspection.planned_date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (device_inspection.planned_date)::date) THEN 2
            ELSE 1
        END AS level,
    device_inspection.planned_date,
    ''::character varying AS title
   FROM public.device_inspection,
    public.device
  WHERE ((device.removed = false) AND (device_inspection.removed = false) AND (device.id = device_inspection.device_id) AND (device_inspection.status_id = 3) AND (device_inspection.planned_date IS NOT NULL));


ALTER VIEW public.v_alert_device_inspection OWNER TO postgres;

--
-- TOC entry 323 (class 1259 OID 25511)
-- Name: v_alert_device_maintenance; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_device_maintenance AS
 SELECT device.id,
    device.name,
        CASE
            WHEN ((now())::date >= (device_maintenance.planned_date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (device_maintenance.planned_date)::date) THEN 2
            ELSE 1
        END AS level,
    device_maintenance.planned_date,
    ''::character varying AS title
   FROM public.device_maintenance,
    public.device
  WHERE ((device.removed = false) AND (device_maintenance.removed = false) AND (device.id = device_maintenance.device_id) AND (device_maintenance.status_id = 3) AND (device_maintenance.planned_date IS NOT NULL));


ALTER VIEW public.v_alert_device_maintenance OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 25516)
-- Name: v_alert_report; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_report AS
 SELECT title,
    COALESCE(severity, 1) AS severity,
    reportdate,
    dep_id
   FROM public.report
  WHERE ((status_id = 7) AND (removed = false))
  ORDER BY COALESCE(severity, 1) DESC NULLS LAST, reportdate;


ALTER VIEW public.v_alert_report OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 25520)
-- Name: v_alert_staff_formation; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_staff_formation AS
 SELECT (((staff_member.lastname)::text || ' '::text) || (staff_member.firstname)::text) AS name,
        CASE
            WHEN ((now())::date >= (staff_formation.planned_date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (staff_formation.planned_date)::date) THEN 2
            ELSE 1
        END AS level,
    staff_formation.planned_date,
    staff_formation.title,
    staff_member.id AS staff_id
   FROM public.staff_formation,
    public.staff_member
  WHERE ((staff_member.id = staff_formation.staff_id) AND (staff_formation.status_id = 3) AND (staff_formation.planned_date IS NOT NULL) AND (staff_formation.removed = false) AND (staff_member.removed = false));


ALTER VIEW public.v_alert_staff_formation OWNER TO postgres;

--
-- TOC entry 361 (class 1259 OID 29895)
-- Name: v_alert_task; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_alert_task AS
 WITH t1 AS (
         SELECT t.id,
            t.task_master_id,
            t.due_date,
            t.title,
            t.description,
            t.comment,
            t.status_id,
            t.removed,
            tl.id,
            tl.task_id,
            tl.staff_member_id,
            tl.status_id,
            tl.comment,
            tl.status_date,
            tl.last_reminder,
            tl.last_reminder_staff_id
           FROM public.task t,
            public.task_link tl
          WHERE ((t.id = tl.task_id) AND (tl.status_id <> 4))
        )
 SELECT task_id,
    description,
        CASE
            WHEN ((now())::date >= (due_date)::date) THEN 3
            WHEN ((((now())::date + '3 days'::interval))::date >= (due_date)::date) THEN 2
            ELSE 1
        END AS level,
    due_date,
    title,
    staff_member_id,
    task_master_id,
    last_reminder,
    last_reminder_staff_id
   FROM t1 t1(id, task_master_id, due_date, title, description, comment, status_id, removed, id_1, task_id, staff_member_id, status_id_1, comment_1, status_date, last_reminder, last_reminder_staff_id)
  WHERE (removed = false);


ALTER VIEW public.v_alert_task OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 25525)
-- Name: v_bquaad_deviceinspection; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_bquaad_deviceinspection AS
 WITH t4 AS (
         WITH t3 AS (
                 WITH t2 AS (
                         WITH t AS (
                                 SELECT device_inspection.device_id,
                                    device_inspection.id,
CASE
 WHEN (device_inspection.result = 5) THEN 'OK'::text
 ELSE 'KO'::text
END AS result_okko,
                                    device_inspection.result AS inspection_result,
                                    device_inspection.inspection_date,
                                    device_inspection.planned_date,
                                    action.id AS act_id,
                                    action.status_id AS act_status,
                                    action.description AS action_desc,
                                    device_inspection.comment AS inspection_comment
                                   FROM ((public.device_inspection
                                     LEFT JOIN ( SELECT action_link_1.id,
    action_link_1.action_id,
    action_link_1.ext_id,
    action_link_1.scope
   FROM public.action_link action_link_1
  WHERE ((action_link_1.scope)::text = 'device_inspection'::text)) action_link ON ((action_link.ext_id = device_inspection.id)))
                                     LEFT JOIN public.action ON ((action_link.action_id = action.id)))
                                  WHERE ((device_inspection.removed = false) AND ((action.removed = false) OR (action.removed IS NULL)))
                                )
                         SELECT t.id,
                            t.result_okko,
                            t.inspection_result,
                            t.inspection_date,
                            t.planned_date,
                            t.act_id,
                            t.act_status,
                            t.action_desc AS inspection_comment,
                            doc_l.doc_id,
                            t.device_id
                           FROM (t
                             LEFT JOIN ( SELECT document_link.id,
                                    document_link.type,
                                    document_link.ext_id,
                                    document_link.doc_id
                                   FROM public.document_link
                                  WHERE ((document_link.type)::text = 'device_inspection'::text)) doc_l ON ((doc_l.ext_id = t.id)))
                        )
                 SELECT
                        CASE
                            WHEN (t2.result_okko = 'OK'::text) THEN 'OK'::text
                            ELSE
                            CASE
                                WHEN (t2.act_id IS NOT NULL) THEN 'OK'::text
                                ELSE 'KO'::text
                            END
                        END AS force_result,
                    t2.id,
                    t2.result_okko,
                    t2.inspection_result,
                    t2.inspection_date,
                    t2.planned_date,
                    t2.act_id,
                    t2.act_status,
                    t2.inspection_comment,
                    t2.doc_id,
                    t2.device_id
                   FROM t2
                )
         SELECT t3.id,
            t3.device_id,
                CASE
                    WHEN (t3.inspection_date IS NULL) THEN NULL::integer
                    ELSE t3.doc_id
                END AS doc_id,
            t3.force_result,
                CASE
                    WHEN (t3.force_result = 'KO'::text) THEN (('Le contrôle a été effectué le '::text || to_char(t3.inspection_date, 'DD/MM/YYYY'::text)) || ' avec un résultat négatif et aucune tâche n''a été planifiée'::text)
                    WHEN ((t3.result_okko = t3.force_result) AND (t3.result_okko = 'OK'::text)) THEN (('Le contrôle a été effectué le '::text || to_char(t3.inspection_date, 'DD/MM/YYYY'::text)) || ' et le résultat est positif'::text)
                    ELSE ((('Le contrôle a été effectué le '::text || to_char(t3.inspection_date, 'DD/MM/YYYY'::text)) || ' et le résultat est négatif<br><br> La tâche suivante a été planifiée dans le logiciel eoQUAL:<br>'::text) || (t3.inspection_comment)::text)
                END AS force_doctext,
            NULL::text AS force_docid,
            t3.inspection_date,
            t3.planned_date
           FROM t3
          WHERE (t3.inspection_date IS NOT NULL)
        )
 SELECT t4.id,
    t4.device_id,
    t4.doc_id,
    t4.force_result,
    t4.force_doctext,
    t4.force_docid,
    t4.inspection_date,
    t4.planned_date,
    device_installation.id AS v_device_plus_deviceinstallation_devid_id,
    COALESCE(t4.inspection_date, t4.planned_date) AS tocheck_date
   FROM t4,
    public.device_installation
  WHERE (t4.device_id = device_installation.id);


ALTER VIEW public.v_bquaad_deviceinspection OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 25530)
-- Name: v_deptagidbyinsttagid; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_deptagidbyinsttagid AS
 SELECT i.tag_id AS insttagid,
    string_agg((d.tag_id)::text, ','::text) AS tagdepidforinsttagid
   FROM public.tag_link i,
    public.tag_link d,
    public.department
  WHERE (((i.type)::text = 'institution'::text) AND (department.id = d.ext_id) AND ((d.type)::text = 'department'::text) AND (department.inst_id = i.ext_id))
  GROUP BY i.tag_id;


ALTER VIEW public.v_deptagidbyinsttagid OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 25534)
-- Name: v_device_actif_by_deptagid; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_device_actif_by_deptagid AS
 SELECT device_installation.dep_id,
    tag_link.tag_id,
    (((now())::date >= (device_installation.installdate)::date) AND (COALESCE((device_installation.removeddate)::date, (now())::date) >= (now())::date)) AS is_actif,
    department.name AS depname,
    device_installation.device_id,
    device_installation.installdate
   FROM public.device_installation,
    public.department,
    public.tag_link
  WHERE (((tag_link.type)::text = 'department'::text) AND (tag_link.ext_id = department.id) AND (device_installation.dep_id = department.id) AND (device_installation.removed = false));


ALTER VIEW public.v_device_actif_by_deptagid OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 25539)
-- Name: v_device_historyinstallationdeptagidlist; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_device_historyinstallationdeptagidlist AS
 SELECT device_installation.device_id,
    ((('{'::text || string_agg(DISTINCT (tag_link.tag_id)::text, ','::text)) || '}'::text))::integer[] AS deptagidlist,
    ((('{'::text || string_agg(DISTINCT (tag_link.ext_id)::text, ','::text)) || '}'::text))::integer[] AS depidlist
   FROM public.device_installation,
    public.tag_link
  WHERE (((tag_link.type)::text = 'department'::text) AND (tag_link.ext_id = device_installation.dep_id) AND (device_installation.removed = false))
  GROUP BY device_installation.device_id;


ALTER VIEW public.v_device_historyinstallationdeptagidlist OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 25544)
-- Name: v_device_plus_deviceinstallation_devid; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_device_plus_deviceinstallation_devid AS
 SELECT device.id,
    device.brand,
    device.dacs_name,
    device.modalitytype,
    device.model,
    device.name,
    device.pacs_name,
    device.removed,
    device.ris_name,
    device.serialnumber,
    device_installation.id AS install_id,
    device_installation.comment,
    device_installation.dep_id,
    device_installation.inchargeof,
    device_installation.installdate,
    device_installation.installedby,
    device_installation.removed AS inst_removed,
    device_installation.removeddate
   FROM public.device_installation,
    public.device
  WHERE (device.id = device_installation.device_id);


ALTER VIEW public.v_device_plus_deviceinstallation_devid OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 25548)
-- Name: v_device_plus_deviceinstallation_instid; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_device_plus_deviceinstallation_instid AS
 SELECT device.id AS dev_id,
    device.brand,
    device.dacs_name,
    device.modalitytype,
    device.model,
    device.name,
    device.pacs_name,
    device.removed,
    device.ris_name,
    device.serialnumber,
    device_installation.id,
    device_installation.comment,
    device_installation.dep_id,
    device_installation.inchargeof,
    device_installation.installdate,
    device_installation.installedby,
    device_installation.removed AS inst_removed,
    device_installation.removeddate
   FROM public.device_installation,
    public.device
  WHERE (device.id = device_installation.device_id);


ALTER VIEW public.v_device_plus_deviceinstallation_instid OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 25552)
-- Name: v_exam_risk_tag_doc; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_exam_risk_tag_doc AS
SELECT
    NULL::integer AS id,
    NULL::character varying AS modality,
    NULL::character varying AS name,
    NULL::character varying AS description,
    NULL::text AS risklist,
    NULL::character varying AS taglist,
    NULL::integer AS doc_id,
    NULL::integer AS doc_otherdoc_id;


ALTER VIEW public.v_exam_risk_tag_doc OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 25556)
-- Name: v_fullinfo_department; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_fullinfo_department AS
 SELECT ((institution.name)::text || COALESCE((' '::text || (department.name)::text), ''::text)) AS fullname,
    institution.id AS inst_id,
    institution.name AS inst_name,
    department.id AS dep_id,
    department.name AS dep_name,
    (institution.removed OR COALESCE(department.removed, false)) AS instordepremoved
   FROM (public.institution
     LEFT JOIN public.department ON ((department.inst_id = institution.id)));


ALTER VIEW public.v_fullinfo_department OWNER TO postgres;

--
-- TOC entry 334 (class 1259 OID 25560)
-- Name: v_last_documentstatus; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_last_documentstatus AS
 SELECT DISTINCT ON (doc_id) id,
    begdate,
    enddate,
    doc_id,
    status_id
   FROM public.documentstatus
  ORDER BY doc_id, begdate DESC;


ALTER VIEW public.v_last_documentstatus OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 25564)
-- Name: v_notremoveddocument; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_notremoveddocument AS
 SELECT document.id,
    document.file,
    document.realfilename,
    document.folder,
    document.type,
    document.creation_date,
    document.removed,
    document.revision,
    document.label,
    document.comment,
    document.uploadedby,
    document.doc_master_id,
    document.sourcefile,
    document.sourcerealfilename
   FROM public.document,
    public.document_master
  WHERE ((document.removed = false) AND (document_master.removed = false) AND (document.doc_master_id = document_master.id));


ALTER VIEW public.v_notremoveddocument OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 25568)
-- Name: v_staff_member_depaccess; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_staff_member_depaccess AS
 SELECT DISTINCT dp.id AS dep_id,
    idbj.staff_id
   FROM public.department dp,
    ( SELECT DISTINCT
                CASE
                    WHEN (staff_role.scope_id = 0) THEN vfd.inst_id
                    ELSE NULL::integer
                END AS inst_id,
                CASE
                    WHEN (staff_role.scope_id = 0) THEN NULL::integer
                    ELSE vfd.dep_id
                END AS dep_id,
            staff_job.staff_id
           FROM public.staff_job,
            public.staff_role,
            public.v_fullinfo_department vfd
          WHERE ((staff_job.removed = false) AND (staff_role.removed = false) AND (staff_role.id = staff_job.staff_role_id) AND (staff_job.begdate <= now()) AND (now() <= staff_job.enddate) AND (staff_job.dep_id <> '-1'::integer) AND (vfd.dep_id = staff_job.dep_id))
        UNION
         SELECT NULL::integer AS int4,
            vfd.dep_id,
            staff_member.id
           FROM public.staff_member,
            public.v_fullinfo_department vfd
          WHERE ((staff_member.login_role_id = 0) AND (vfd.dep_id <> '-1'::integer))) idbj
  WHERE ((idbj.inst_id = dp.inst_id) OR (idbj.dep_id = dp.id));


ALTER VIEW public.v_staff_member_depaccess OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 25573)
-- Name: v_staff_member_historyjobdeplist; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_staff_member_historyjobdeplist AS
 SELECT DISTINCT vfd.dep_id,
    staff_job.staff_id
   FROM public.staff_job,
    public.staff_role,
    public.v_fullinfo_department vfd
  WHERE ((staff_job.removed = false) AND (staff_role.removed = false) AND (staff_role.id = staff_job.staff_role_id) AND (staff_job.dep_id <> '-1'::integer) AND (vfd.dep_id = staff_job.dep_id));


ALTER VIEW public.v_staff_member_historyjobdeplist OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 25577)
-- Name: v_staff_member_historyjobdeptagidlist; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_staff_member_historyjobdeptagidlist AS
 SELECT v_staff_member_historyjobdeplist.staff_id,
    ((('{'::text || string_agg((tag_link.tag_id)::text, ','::text)) || '}'::text))::integer[] AS deptagidlist,
    ((('{'::text || string_agg((tag_link.ext_id)::text, ','::text)) || '}'::text))::integer[] AS depidlist
   FROM public.v_staff_member_historyjobdeplist,
    public.tag_link
  WHERE (((tag_link.type)::text = 'department'::text) AND (tag_link.ext_id = v_staff_member_historyjobdeplist.dep_id))
  GROUP BY v_staff_member_historyjobdeplist.staff_id;


ALTER VIEW public.v_staff_member_historyjobdeptagidlist OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 25581)
-- Name: v_staffmember_taglistdep_active_staffjob; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_staffmember_taglistdep_active_staffjob AS
 SELECT ((('{'::text || COALESCE(string_agg(DISTINCT (tag_link.tag_id)::text, ','::text), ''::text)) || '}'::text))::integer[] AS taglistdep_id,
    staff_job.staff_id
   FROM public.staff_job,
    public.department,
    public.tag_link
  WHERE ((staff_job.removed = false) AND (department.removed = false) AND (staff_job.begdate <= now()) AND (staff_job.enddate >= now()) AND (department.id = staff_job.dep_id) AND (tag_link.ext_id = department.id) AND ((tag_link.type)::text = 'department'::text))
  GROUP BY staff_job.staff_id;


ALTER VIEW public.v_staffmember_taglistdep_active_staffjob OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 25586)
-- Name: v_survey; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_survey AS
 SELECT survey_field.survey_id,
    survey_field.id AS field_id,
    survey_field.type AS field_type,
    survey_field."position"
   FROM public.survey,
    public.survey_field
  WHERE (survey.id = survey_field.survey_id);


ALTER VIEW public.v_survey OWNER TO postgres;

--
-- TOC entry 341 (class 1259 OID 25590)
-- Name: v_taginfo; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_taginfo AS
 SELECT tt.id,
    tt.link_type,
    tt.ext_id,
    tt.tag_id,
    tt.type,
    tt.alltagidallow,
    tt.name,
    tt.removed,
    (((('{'::text || string_agg(v1.tagdepidforinsttagid, ','::text)) || '}'::text))::integer[] || ((('{'::text || string_agg((v2.insttagid)::text, ','::text)) || '}'::text))::integer[]) AS alltagidinducedallow
   FROM ((( SELECT tag_link.id,
            tag_link.type AS link_type,
            tag_link.ext_id,
            tag_link.tag_id,
            tag.type,
            ((('{'::text || string_agg((tag_link.tag_id)::text, ','::text) OVER (PARTITION BY tag_link.type, tag_link.ext_id)) || '}'::text))::integer[] AS alltagidallow,
            ((('{'::text || string_agg(
                CASE
                    WHEN ((tag.type)::text = 'OR'::text) THEN (tag_link.tag_id)::text
                    ELSE NULL::text
                END, ','::text) OVER (PARTITION BY tag_link.type, tag_link.ext_id)) || '}'::text))::integer[] AS tagtomapinstid,
            tag.name,
            tag.removed
           FROM public.tag_link,
            public.tag
          WHERE (tag.id = tag_link.tag_id)) tt
     LEFT JOIN public.v_deptagidbyinsttagid v1 ON ((v1.insttagid = ANY (tt.alltagidallow))))
     LEFT JOIN public.v_deptagidbyinsttagid v2 ON ((((('{'::text || v2.tagdepidforinsttagid) || '}'::text))::integer[] && tt.tagtomapinstid)))
  GROUP BY tt.id, tt.link_type, tt.ext_id, tt.tag_id, tt.type, tt.alltagidallow, tt.name, tt.removed;


ALTER VIEW public.v_taginfo OWNER TO postgres;

--
-- TOC entry 342 (class 1259 OID 25595)
-- Name: v_taglink_instdep; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.v_taglink_instdep AS
 SELECT v_fullinfo_department.inst_id,
    ti.tag_id AS taginstid,
    v_fullinfo_department.dep_id,
    td.tag_id AS tagdepid,
    v_fullinfo_department.instordepremoved
   FROM public.tag_link ti,
    public.tag_link td,
    public.v_fullinfo_department
  WHERE (((ti.type)::text = 'institution'::text) AND ((td.type)::text = 'department'::text) AND (ti.ext_id = v_fullinfo_department.inst_id) AND (td.ext_id = v_fullinfo_department.dep_id));


ALTER VIEW public.v_taglink_instdep OWNER TO postgres;

--
-- TOC entry 343 (class 1259 OID 25599)
-- Name: xusercfg; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.xusercfg (
    id integer NOT NULL,
    data character varying,
    cfgparameter_id integer NOT NULL
);


ALTER TABLE public.xusercfg OWNER TO postgres;

--
-- TOC entry 344 (class 1259 OID 25604)
-- Name: xusercfgparameter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.xusercfgparameter (
    cfgparameter_id integer NOT NULL,
    vtype integer,
    type integer DEFAULT 1,
    vorder integer,
    variable character varying NOT NULL,
    label character varying NOT NULL,
    description character varying,
    vdefault character varying
);


ALTER TABLE public.xusercfgparameter OWNER TO postgres;

--
-- TOC entry 5137 (class 2604 OID 25610)
-- Name: action id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action ALTER COLUMN id SET DEFAULT nextval('public.action_id_seq'::regclass);


--
-- TOC entry 5140 (class 2604 OID 25611)
-- Name: action_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_link ALTER COLUMN id SET DEFAULT nextval('public.action_link_id_seq'::regclass);


--
-- TOC entry 5141 (class 2604 OID 25612)
-- Name: afcnsend id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.afcnsend ALTER COLUMN id SET DEFAULT nextval('public.afcnsend_id_seq'::regclass);


--
-- TOC entry 5143 (class 2604 OID 25613)
-- Name: agelist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.agelist ALTER COLUMN id SET DEFAULT nextval('public.agelist_id_seq'::regclass);


--
-- TOC entry 5144 (class 2604 OID 25614)
-- Name: audit id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit ALTER COLUMN id SET DEFAULT nextval('public.audit_id_seq'::regclass);


--
-- TOC entry 5149 (class 2604 OID 25615)
-- Name: audit_record id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_record ALTER COLUMN id SET DEFAULT nextval('public.audit_record_id_seq'::regclass);


--
-- TOC entry 5151 (class 2604 OID 25616)
-- Name: audit_recordprocedure id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_recordprocedure ALTER COLUMN id SET DEFAULT nextval('public.audit_recordprocedure_id_seq'::regclass);


--
-- TOC entry 5153 (class 2604 OID 25617)
-- Name: audit_subrecord id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_subrecord ALTER COLUMN id SET DEFAULT nextval('public.audit_subrecord_id_seq'::regclass);


--
-- TOC entry 5155 (class 2604 OID 25618)
-- Name: audit_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_type ALTER COLUMN id SET DEFAULT nextval('public.audit_type_id_seq'::regclass);


--
-- TOC entry 5256 (class 2604 OID 26772)
-- Name: civilitylist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.civilitylist ALTER COLUMN id SET DEFAULT nextval('public.civilitylist_id_seq'::regclass);


--
-- TOC entry 5157 (class 2604 OID 25619)
-- Name: department id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department ALTER COLUMN id SET DEFAULT nextval('public.department_id_seq'::regclass);


--
-- TOC entry 5159 (class 2604 OID 25620)
-- Name: device id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device ALTER COLUMN id SET DEFAULT nextval('public.device_id_seq'::regclass);


--
-- TOC entry 5162 (class 2604 OID 25621)
-- Name: device_inspection id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_inspection ALTER COLUMN id SET DEFAULT nextval('public.device_inspection_id_seq'::regclass);


--
-- TOC entry 5164 (class 2604 OID 25622)
-- Name: device_installation id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_installation ALTER COLUMN id SET DEFAULT nextval('public.device_installation_id_seq'::regclass);


--
-- TOC entry 5169 (class 2604 OID 25623)
-- Name: device_maintenance id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_maintenance ALTER COLUMN id SET DEFAULT nextval('public.device_maintenance_id_seq'::regclass);


--
-- TOC entry 5171 (class 2604 OID 25624)
-- Name: document id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document ALTER COLUMN id SET DEFAULT nextval('public.document_id_seq'::regclass);


--
-- TOC entry 5181 (class 2604 OID 25625)
-- Name: document_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_link ALTER COLUMN id SET DEFAULT nextval('public.document_link_id_seq'::regclass);


--
-- TOC entry 5182 (class 2604 OID 25626)
-- Name: document_master id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_master ALTER COLUMN id SET DEFAULT nextval('public.document_master_id_seq'::regclass);


--
-- TOC entry 5184 (class 2604 OID 25627)
-- Name: documentstatus id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documentstatus ALTER COLUMN id SET DEFAULT nextval('public.documentstatus_id_seq'::regclass);


--
-- TOC entry 5257 (class 2604 OID 26823)
-- Name: documenttypelist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documenttypelist ALTER COLUMN id SET DEFAULT nextval('public.documenttypelist_id_seq'::regclass);


--
-- TOC entry 5186 (class 2604 OID 25628)
-- Name: examident id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examident ALTER COLUMN id SET DEFAULT nextval('public.examident_id_seq'::regclass);


--
-- TOC entry 5188 (class 2604 OID 25629)
-- Name: examlist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examlist ALTER COLUMN id SET DEFAULT nextval('public.examlist_id_seq'::regclass);


--
-- TOC entry 5190 (class 2604 OID 25630)
-- Name: examwarning id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examwarning ALTER COLUMN id SET DEFAULT nextval('public.examwarning_id_seq'::regclass);


--
-- TOC entry 5192 (class 2604 OID 25631)
-- Name: external_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.external_link ALTER COLUMN id SET DEFAULT nextval('public.external_link_id_seq'::regclass);


--
-- TOC entry 5193 (class 2604 OID 25632)
-- Name: external_src id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.external_src ALTER COLUMN id SET DEFAULT nextval('public.external_src_id_seq'::regclass);


--
-- TOC entry 5194 (class 2604 OID 25633)
-- Name: institution id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.institution ALTER COLUMN id SET DEFAULT nextval('public.institution_id_seq'::regclass);


--
-- TOC entry 5196 (class 2604 OID 25634)
-- Name: legaldocument id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.legaldocument ALTER COLUMN id SET DEFAULT nextval('public.legaldocument_id_seq'::regclass);


--
-- TOC entry 5198 (class 2604 OID 25635)
-- Name: login_role id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_role ALTER COLUMN id SET DEFAULT nextval('public.login_role_id_seq'::regclass);


--
-- TOC entry 5200 (class 2604 OID 25636)
-- Name: login_role_permission id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_role_permission ALTER COLUMN id SET DEFAULT nextval('public.login_role_permission_id_seq'::regclass);


--
-- TOC entry 5207 (class 2604 OID 25637)
-- Name: procedure id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.procedure ALTER COLUMN id SET DEFAULT nextval('public.procedure_id_seq'::regclass);


--
-- TOC entry 5209 (class 2604 OID 25638)
-- Name: quaad_description id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_description ALTER COLUMN id SET DEFAULT nextval('public.quaad_description_id_seq'::regclass);


--
-- TOC entry 5210 (class 2604 OID 25639)
-- Name: quaad_point id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_point ALTER COLUMN id SET DEFAULT nextval('public.quaad_point_id_seq'::regclass);


--
-- TOC entry 5218 (class 2604 OID 25640)
-- Name: quaadpoint_tag id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadpoint_tag ALTER COLUMN id SET DEFAULT nextval('public.quaadpoint_tag_id_seq'::regclass);


--
-- TOC entry 5224 (class 2604 OID 25641)
-- Name: quaadpoint_tag_name id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadpoint_tag_name ALTER COLUMN id SET DEFAULT nextval('public.quaadpoint_tag_name_id_seq'::regclass);


--
-- TOC entry 5226 (class 2604 OID 25642)
-- Name: report id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.report ALTER COLUMN id SET DEFAULT nextval('public.report_id_seq'::regclass);


--
-- TOC entry 5231 (class 2604 OID 25643)
-- Name: sexlist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sexlist ALTER COLUMN id SET DEFAULT nextval('public.sexlist_id_seq'::regclass);


--
-- TOC entry 5232 (class 2604 OID 25644)
-- Name: staff_formation id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_formation ALTER COLUMN id SET DEFAULT nextval('public.staff_formation_id_seq'::regclass);


--
-- TOC entry 5234 (class 2604 OID 25645)
-- Name: staff_job id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_job ALTER COLUMN id SET DEFAULT nextval('public.staff_job_id_seq'::regclass);


--
-- TOC entry 5238 (class 2604 OID 25646)
-- Name: staff_member id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_member ALTER COLUMN id SET DEFAULT nextval('public.staff_member_id_seq'::regclass);


--
-- TOC entry 5241 (class 2604 OID 25647)
-- Name: staff_role id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_role ALTER COLUMN id SET DEFAULT nextval('public.staff_role_id_seq'::regclass);


--
-- TOC entry 5244 (class 2604 OID 25648)
-- Name: statuslist id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.statuslist ALTER COLUMN id SET DEFAULT nextval('public.statuslist_id_seq'::regclass);


--
-- TOC entry 5245 (class 2604 OID 25649)
-- Name: survey id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.survey ALTER COLUMN id SET DEFAULT nextval('public.survey_id_seq'::regclass);


--
-- TOC entry 5247 (class 2604 OID 25650)
-- Name: survey_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.survey_field ALTER COLUMN id SET DEFAULT nextval('public.survey_field_id_seq'::regclass);


--
-- TOC entry 5248 (class 2604 OID 25651)
-- Name: survey_field_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.survey_field_type ALTER COLUMN id SET DEFAULT nextval('public.survey_field_type_id_seq'::regclass);


--
-- TOC entry 5249 (class 2604 OID 25652)
-- Name: survey_resp id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.survey_resp ALTER COLUMN id SET DEFAULT nextval('public.survey_resp_id_seq'::regclass);


--
-- TOC entry 5250 (class 2604 OID 25653)
-- Name: survey_resp_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.survey_resp_field ALTER COLUMN id SET DEFAULT nextval('public.survey_resp_field_id_seq'::regclass);


--
-- TOC entry 5251 (class 2604 OID 25654)
-- Name: survey_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.survey_type ALTER COLUMN id SET DEFAULT nextval('public.survey_type_id_seq'::regclass);


--
-- TOC entry 5252 (class 2604 OID 25655)
-- Name: tag id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tag ALTER COLUMN id SET DEFAULT nextval('public.tag_id_seq'::regclass);


--
-- TOC entry 5254 (class 2604 OID 25656)
-- Name: tag_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tag_link ALTER COLUMN id SET DEFAULT nextval('public.tag_link_id_seq'::regclass);


--
-- TOC entry 5258 (class 2604 OID 29859)
-- Name: task id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task ALTER COLUMN id SET DEFAULT nextval('public.task_id_seq'::regclass);


--
-- TOC entry 5259 (class 2604 OID 29860)
-- Name: task task_master_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task ALTER COLUMN task_master_id SET DEFAULT nextval('public.task_task_master_id_seq'::regclass);


--
-- TOC entry 5262 (class 2604 OID 29871)
-- Name: task_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_link ALTER COLUMN id SET DEFAULT nextval('public.task_link_id_seq'::regclass);


--
-- TOC entry 5263 (class 2604 OID 29878)
-- Name: task_master id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_master ALTER COLUMN id SET DEFAULT nextval('public.task_master_id_seq'::regclass);


--
-- TOC entry 5271 (class 2604 OID 29894)
-- Name: task_master_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_master_link ALTER COLUMN id SET DEFAULT nextval('public.task_master_link_id_seq'::regclass);


--
-- TOC entry 5620 (class 0 OID 25114)
-- Dependencies: 216
-- Data for Name: action; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.action VALUES (8, 'BBBBBBBBBBBBBBB', NULL, 'AAAAAAAAAA', '2024-08-16 00:00:00+02', NULL, '2024-08-14 00:00:00+02', NULL, true, -1);
INSERT INTO public.action VALUES (3, 'New task', 3, 'Interne', '2024-08-14 00:00:00+02', NULL, '2023-12-12 00:00:00+01', 0, false, 1);
INSERT INTO public.action VALUES (9, 'New', NULL, NULL, NULL, NULL, '2024-09-30 00:00:00+02', NULL, true, -1);
INSERT INTO public.action VALUES (7, 'New', 4, '', '2024-08-28 00:00:00+02', '2025-03-06 00:00:00+01', '2024-08-13 00:00:00+02', 0, false, 2);
INSERT INTO public.action VALUES (2, 'Remplacer tube RX2000', 3, '', '2021-04-09 00:00:00+02', '2025-03-14 00:00:00+01', '2021-03-22 00:00:00+01', 0, false, 2);


--
-- TOC entry 5622 (class 0 OID 25122)
-- Dependencies: 218
-- Data for Name: action_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.action_link VALUES (19, 7, 8, 'device_inspection');
INSERT INTO public.action_link VALUES (25, 3, 8, 'device_inspection');
INSERT INTO public.action_link VALUES (29, 3, 25, 'report');
INSERT INTO public.action_link VALUES (30, 2, 25, 'report');
INSERT INTO public.action_link VALUES (32, 2, 1, 'survey');
INSERT INTO public.action_link VALUES (35, 7, 5, 'device_inspection');
INSERT INTO public.action_link VALUES (36, 3, 5, 'device_inspection');


--
-- TOC entry 5725 (class 0 OID 26170)
-- Dependencies: 346
-- Data for Name: action_status_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.action_status_link VALUES (15, 330, NULL, NULL, 1, '2025-05-15 09:45:29.923186', NULL);
INSERT INTO public.action_status_link VALUES (12, 330, NULL, NULL, 1, '2025-05-15 09:45:29.912307', NULL);
INSERT INTO public.action_status_link VALUES (15, 329, NULL, NULL, 1, '2025-05-14 17:57:28.908729', NULL);
INSERT INTO public.action_status_link VALUES (12, 329, NULL, NULL, 1, '2025-05-16 16:06:04.610289', '2025-05-16 16:15:07.736839');
INSERT INTO public.action_status_link VALUES (12, 329, NULL, NULL, 0, '2025-05-14 17:56:03.117503', '2025-05-16 16:15:07.736839');
INSERT INTO public.action_status_link VALUES (16, 330, NULL, NULL, 0, '2025-05-12 17:56:17.094', '2025-05-16 16:15:12.306363');
INSERT INTO public.action_status_link VALUES (16, 330, NULL, NULL, 1, '2025-05-15 09:45:29.924615', '2025-05-16 16:15:12.306363');
INSERT INTO public.action_status_link VALUES (14, 329, NULL, NULL, 1, '2025-05-16 16:06:04.62151', '2025-05-16 16:21:07.59762');
INSERT INTO public.action_status_link VALUES (14, 330, NULL, NULL, 0, '2025-05-10 17:56:42.313', '2025-08-26 17:06:23.445833');
INSERT INTO public.action_status_link VALUES (14, 330, NULL, NULL, 1, '2025-05-15 09:45:29.921768', '2025-08-26 17:06:23.445833');
INSERT INTO public.action_status_link VALUES (14, 410, NULL, NULL, 1, '2025-08-27 18:44:30.454505', NULL);
INSERT INTO public.action_status_link VALUES (15, 410, NULL, NULL, 1, '2025-08-27 18:44:30.457574', NULL);
INSERT INTO public.action_status_link VALUES (12, 410, NULL, NULL, 1, '2025-08-27 18:44:30.441853', '2025-08-27 19:12:33.237794');


--
-- TOC entry 5624 (class 0 OID 25128)
-- Dependencies: 220
-- Data for Name: afcnsend; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.afcnsend VALUES (8, NULL, NULL, NULL, 'New sending', '2021-03-11 12:27:13.099173+01', 0, NULL, true, NULL);
INSERT INTO public.afcnsend VALUES (10, 1, 2, NULL, 'Rapport dosimètres', '2021-03-11 00:00:00+01', 0, 'Rapport dosimètres', true, 4);
INSERT INTO public.afcnsend VALUES (11, 1, 2, 11, 'Titre 001', '2025-01-14 00:00:00+01', 0, 'Titre 001', false, 4);
INSERT INTO public.afcnsend VALUES (9, 1, 2, 12, 'rapport dosimétrie 2020', '2020-12-31 00:00:00+01', 0, 'rapport dosimétrie 2020', false, 4);
INSERT INTO public.afcnsend VALUES (12, 2, 6, NULL, 'New sending', '2025-01-15 00:00:00+01', 0, 'New sending', false, 4);
INSERT INTO public.afcnsend VALUES (16, -1, -1, NULL, 'New sending', '2025-02-05 17:21:59.661234+01', 0, NULL, true, 3);
INSERT INTO public.afcnsend VALUES (14, -1, -1, NULL, 'New sending', '2025-01-16 09:18:52.894812+01', 0, NULL, true, 3);
INSERT INTO public.afcnsend VALUES (15, -1, -1, NULL, 'New sending', '2025-01-16 11:38:32.671429+01', 0, NULL, true, 3);
INSERT INTO public.afcnsend VALUES (13, 1, 4, 10, 'New sending', '2025-02-01 00:00:00+01', 0, 'New sending', false, 3);


--
-- TOC entry 5626 (class 0 OID 25135)
-- Dependencies: 222
-- Data for Name: agelist; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.agelist VALUES (0, 'Infant');
INSERT INTO public.agelist VALUES (1, 'Child');
INSERT INTO public.agelist VALUES (2, 'Adult');
INSERT INTO public.agelist VALUES (3, 'All');


--
-- TOC entry 5628 (class 0 OID 25141)
-- Dependencies: 224
-- Data for Name: audit; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.audit VALUES (13, 1, 2, '2023-08-21 00:00:00+02', 1, 'New audit', '', 3, NULL, true, 4, '2023-08-21 00:00:00+02', '2023-08-21 00:00:00+02');
INSERT INTO public.audit VALUES (11, 1, 2, '2023-03-13 00:00:00+01', 2, 'Auto-audit B-QUAADRIL - 2023', '', 4, NULL, false, 1, '2022-04-07 00:00:00+02', '2023-03-13 00:00:00+01');
INSERT INTO public.audit VALUES (16, -1, -1, '2024-08-16 16:28:43.264387+02', 0, 'New audit', NULL, 3, NULL, true, 2, '2024-08-16 16:28:43+02', '2024-08-16 16:28:43+02');
INSERT INTO public.audit VALUES (15, -1, -1, '2024-08-16 16:27:26.638303+02', 0, 'New audit', NULL, 3, NULL, true, 2, '2024-08-16 16:27:27+02', '2024-08-16 16:27:27+02');
INSERT INTO public.audit VALUES (12, 2, 7, '2023-03-20 00:00:00+01', 0, 'Test 001', 'Rem', 3, NULL, true, 4, '2023-03-20 00:00:00+01', '2023-03-20 00:00:00+01');
INSERT INTO public.audit VALUES (17, 1, 4, '2025-03-06 00:00:00+01', 2, 'Test 002', '', 4, NULL, false, 4, '2025-03-06 00:00:00+01', '2025-03-06 00:00:00+01');
INSERT INTO public.audit VALUES (20, 2, 7, '2025-03-06 00:00:00+01', 1, 'Test 003', '', 4, NULL, false, 1, '2025-03-06 00:00:00+01', '2025-03-07 00:00:00+01');
INSERT INTO public.audit VALUES (19, -1, -1, '2025-03-06 11:02:16.790735+01', 0, 'New audit', NULL, 3, NULL, true, 2, '2025-03-06 11:02:17+01', '2025-03-06 11:02:17+01');
INSERT INTO public.audit VALUES (18, -1, -1, '2025-03-06 11:01:45.627996+01', 0, 'New audit', NULL, 3, NULL, true, 2, '2025-03-06 11:01:46+01', '2025-03-06 11:01:46+01');
INSERT INTO public.audit VALUES (14, 1, 2, '2023-09-28 00:00:00+02', 1, 'Audit selon NF S-99-300  - 2023', 'Test remarque.', 3, NULL, false, 4, '2022-12-14 00:00:00+01', '2023-09-28 00:00:00+02');


--
-- TOC entry 5630 (class 0 OID 25151)
-- Dependencies: 226
-- Data for Name: audit_record; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.audit_record VALUES (409, 11, 10, false);
INSERT INTO public.audit_record VALUES (410, 11, 5, false);
INSERT INTO public.audit_record VALUES (411, 11, 62, false);
INSERT INTO public.audit_record VALUES (415, 11, 9, false);
INSERT INTO public.audit_record VALUES (422, 11, 6, true);
INSERT INTO public.audit_record VALUES (412, 11, 4, true);


--
-- TOC entry 5632 (class 0 OID 25156)
-- Dependencies: 228
-- Data for Name: audit_recordprocedure; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.audit_recordprocedure VALUES (111, 422, 6, 326, 'Test.', true, NULL);
INSERT INTO public.audit_recordprocedure VALUES (112, 412, 2, 325, '', true, NULL);


--
-- TOC entry 5634 (class 0 OID 25163)
-- Dependencies: 230
-- Data for Name: audit_subrecord; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.audit_subrecord VALUES (357, 411, 53, 92, -1, '', -1, 'Mis à jour en 07/2023', true, false, 128, NULL);
INSERT INTO public.audit_subrecord VALUES (359, 410, 2, 9, -1, NULL, NULL, 'Disponible au format papier dans la salle', false, true, -1, NULL);
INSERT INTO public.audit_subrecord VALUES (360, 410, 2, 10, -1, NULL, NULL, 'a retrouver', false, false, -1, NULL);
INSERT INTO public.audit_subrecord VALUES (361, 415, 9, 11, -1, NULL, NULL, 'Disponible en papier dans la salle armoire 2', false, true, -1, NULL);
INSERT INTO public.audit_subrecord VALUES (372, 412, 1, 1, -1, NULL, NULL, 'En attente.', false, true, -1, NULL);


--
-- TOC entry 5636 (class 0 OID 25170)
-- Dependencies: 232
-- Data for Name: audit_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.audit_type VALUES (2, 'Other', 'false', NULL);
INSERT INTO public.audit_type VALUES (1, 'B-QUAADRIL(2019/07)', 'false', 'QUAADRIL');
INSERT INTO public.audit_type VALUES (3, 'BQUANUM(2019/07)', 'false', 'QUANUM');
INSERT INTO public.audit_type VALUES (4, 'NF S-99-300', 'false', 'NF S99-300');


--
-- TOC entry 5728 (class 0 OID 26769)
-- Dependencies: 349
-- Data for Name: civilitylist; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.civilitylist VALUES (1, 'Mrs.');
INSERT INTO public.civilitylist VALUES (0, 'Mr.');
INSERT INTO public.civilitylist VALUES (2, 'Miss');
INSERT INTO public.civilitylist VALUES (3, 'Dr.');
INSERT INTO public.civilitylist VALUES (4, 'Prof.');
INSERT INTO public.civilitylist VALUES (5, 'Mx.');


--
-- TOC entry 5724 (class 0 OID 26153)
-- Dependencies: 345
-- Data for Name: default_action_needed; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 2, 4, 200, 0);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 4, 207, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 1, 4, 208, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 1, 209, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 1, 1, 210, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 2, 211, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 1, 2, 212, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 2, 4, 213, 2);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 1, 1, 214, 2);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist_otherdocument', 3, 4, 183, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist_otherdocument', 2, 2, 184, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('procedure', 2, 2, 186, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 1, 1, 193, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 10, 1, 194, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 1, 2, 195, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 1, 7, 196, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 1, 6, 197, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 10, 6, 198, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 2, 1, 18, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 1, 1, 19, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 4, 1, 20, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 3, 1, 21, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 2, 6, 22, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 1, 6, 23, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 4, 6, 24, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('audit', 3, 6, 25, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 2, 4, 26, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 5, 4, 27, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 1, 4, 28, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 4, 4, 29, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 3, 4, 30, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 2, 1, 31, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 5, 1, 32, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 1, 1, 33, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 4, 1, 34, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 3, 1, 35, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 2, 2, 36, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 5, 2, 37, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 1, 2, 38, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 4, 2, 39, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 3, 2, 40, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 2, 7, 41, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 5, 7, 42, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 1, 7, 43, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 4, 7, 44, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 3, 7, 45, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 2, 6, 46, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 5, 6, 47, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 1, 6, 48, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 4, 6, 49, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 3, 6, 50, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 2, 3, 51, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 5, 3, 52, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 1, 3, 53, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 4, 3, 54, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('legaldocument', 3, 3, 55, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 1, 1, 56, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 4, 1, 57, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 3, 1, 58, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 2, 6, 59, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 5, 6, 60, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 1, 6, 61, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('survey', 4, 6, 62, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 3, 4, 63, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 3, 1, 64, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 3, 2, 65, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 3, 7, 66, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 3, 6, 67, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('afcnsend', 3, 3, 68, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 1, 4, 69, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 3, 4, 70, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 1, 1, 71, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 3, 1, 72, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 1, 2, 73, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 3, 2, 74, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 1, 7, 75, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 3, 7, 76, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 1, 6, 77, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 3, 6, 78, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 1, 3, 79, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('device', 3, 3, 80, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('institution', 1, 3, 199, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_formation', 10, 4, 99, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_formation', 10, 1, 100, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_formation', 10, 2, 101, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_formation', 10, 7, 102, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_formation', 10, 6, 103, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_formation', 10, 3, 104, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_member', 10, 4, 105, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_member', 10, 1, 106, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_member', 10, 2, 107, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_member', 10, 7, 108, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_member', 10, 6, 109, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('staff_member', 10, 3, 110, 1);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 4, 201, 0);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 1, 202, 0);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 2, 203, 0);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 7, 204, 0);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 6, 205, 0);
INSERT INTO public.default_action_needed OVERRIDING SYSTEM VALUE VALUES ('examlist', 2, 3, 206, 0);


--
-- TOC entry 5638 (class 0 OID 25177)
-- Dependencies: 234
-- Data for Name: department; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.department VALUES (-1, 'Undef', -1, true);
INSERT INTO public.department VALUES (1, 'Qualité', 1, false);
INSERT INTO public.department VALUES (2, 'Radiologie', 1, false);
INSERT INTO public.department VALUES (4, 'Médecine nucléaire', 1, false);
INSERT INTO public.department VALUES (5, 'New department', 1, true);
INSERT INTO public.department VALUES (6, 'Qualité', 2, false);
INSERT INTO public.department VALUES (3, 'Radiologie', 2, false);
INSERT INTO public.department VALUES (7, 'Médecine nucléaire', 2, false);
INSERT INTO public.department VALUES (8, 'New department', 1, true);
INSERT INTO public.department VALUES (9, 'New departmenttttt', 1, true);
INSERT INTO public.department VALUES (10, 'New department', 5, true);


--
-- TOC entry 5640 (class 0 OID 25184)
-- Dependencies: 236
-- Data for Name: device; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.device VALUES (13, 'New device', NULL, NULL, NULL, false, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (16, 'New device', NULL, NULL, NULL, false, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (17, 'New device', NULL, NULL, NULL, false, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (18, 'New device', NULL, NULL, NULL, false, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (19, 'New device', NULL, NULL, NULL, false, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (20, 'New device', 'Siemens', '', '', true, '2', 'PACS', 'DACS', 'null', NULL);
INSERT INTO public.device VALUES (14, 'New device 001', 'GE', '', '123456', true, '1', '', '', '', NULL);
INSERT INTO public.device VALUES (15, 'New device 0002', 'Toshiba', '', '', true, '', '', '', '', NULL);
INSERT INTO public.device VALUES (24, 'New device', 'Brand', NULL, NULL, true, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (23, 'Brand', '', NULL, NULL, true, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (22, 'New device', 'Ximeo', '', NULL, true, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (21, 'New device', 'Ximeo', '', NULL, true, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (10, 'RX', 'Ximeo', '', '123456', false, '0', 'PACS', 'DACS', 'RX', '\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');
INSERT INTO public.device VALUES (25, 'New device', 'Brand', NULL, NULL, true, NULL, NULL, NULL, 'RX', NULL);
INSERT INTO public.device VALUES (11, 'Scanner', 'Ximeo', '', '123453', false, '1', 'PACS', 'DACS', 'CT', '\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');
INSERT INTO public.device VALUES (12, 'Mammo', 'ximeo', '', '123456', false, '5', 'PACS', 'DACS', 'MG', '\xffd8ffe000104a46494600010100000100010000ffdb008400090607101211121212101010100f10100f0f10100f1010100e101511161615111513181d2820181a251b151321312131292b2e2e2e171f3338332d37282d2e2b010a0a0a0e0d0e1a0f10172d1d151f2b2b2d2d2d2d2d2d2b2b2d2b2d2b2d2d2d372d2b2d3837372b2b2b2d372c2d37372d382b2b2d2b372b2c2b2d2b2c382d2b2bffc000110800e100e103012200021101031101ffc4001c0001000301010101010000000000000000000304050602010708ffc40042100002010202050808030605050000000000010203110421051231417106132251617281b12332337391a1b2c1074282435262b4d1e12453a3c2f014156392a2ffc40017010101010100000000000000000000000000010203ffc4001b11010100020301000000000000000000000001021121314112ffda000c03010002110311003f00fdc4000000000000000000000000023ab5a31f5a4a3c5a57024052a9a4e9afde7c20fcdd8865a5d6ea727c5c57f52eaa6da60c9ffbbcbfcaff0053fb1e9697eba525c2498d536d4052a1a4e9c9d9de0faa4adf3d85d2280000000000000000000000000000000000000c2d37a4e709f3707ab65794928deef625ac9af96f28c7158897ed1be3cd5fe503531b59fa755ac8fa72182ad52a2d695595b5a492d5a57b27b6f18aed2d6bb8c92bdd4d3b37ba4b6abf6acff4b2fc27d36f485469249dafb5adb632f577efebdff13ec6ab3eeb5c7ce97e91545b389e6c7b9fdcf220f2d136124acefe1f15fdc8d9f70afccd218a8abc78c97838b7e6916345629a9283778bf57f85f57020c5ed8f79fd123c611fa587789670ae8c00736800000000000000000000000000000001cae998ff00889f087d289b0d6c88f4ee55df6c22fcd7d88b0f5b34769d39ded5f443e847c7ea669d6a2a51b5dade9adb192d8d195a29f412ea6d7cd9b11d86aa44187a8eee32b29c76db6493d938f63b3cb734d76bb08af8c56b4d6d83cfb8da53f82b4bf498b5b4be229d5a9ad06e394214dc56a454253f48a495db9270be765a996d20d0c736a6af7b6ae5d57be7e3b042b3cb815ea63a5522af14b5b9cbdae9d39c16b59a7b538dcf946792e06744ad1a750970af3f129d1996704c2bd69093493566d6b357d97d476b95b44b9f3d1725eb4d4bd75251e8a8da31b64b2befcdbeb3cf29a8caa50ab08abca74aa462ae95db8592bbcb7985f877a3ab51ab51558386b3a3a9d28b4ece77b6ab7d6be25d706f97e980038ba0000000000000000000000000000000039be56475752abca36d493dc9def1bfc59cfd3d2b453f688fd0a704d34d269e4d3574d76a38fc4726a8ce4df4566f2e6a0d6dd9b8eb8653aae794bdc54d11888ca5349a6a5394e3db16cdf8ac8c7a9c92492b55518feec68a5f3d6188e4dd3515694ef7b6596e7d77357289258d69c54938b6ad24e2f35b1e466fb48d3775774e37cf7b57fb98189d111b37af5534b75471f23d727301cdd4579ce4e29c55e4dc72cae90d95a3899cf9faaacb9b51524f2bb9ba0ef77b7f2a23a33c97045ac77ad37db2fe5ccd84f670411a54665fc03ccc7c3ccd5c0ed2558971ef2f07f621d10fd2c3f4f99ef1efc9f9c48b43fb68f18d89e2faebc007274000000000000000000000000000000000ca4b37c5f99aa6445e6f8bf32c4ab355745787914f18f25de5e4cb35a7d15e1e452c4ddabee525e4ca958b5d67e241a1e3ea3fe08fd289ab3cd91e8a5d1a7dc87d28dc6166693aad3f579cb4b83a31bfcae624249eccd6e7d68d5c67ed78cff9689934f77046916f0db4d9c1ed3170cf3367044ab12d649bb3ea979a3ee029455585afeb2eab1e6b3e92e12f389eb06fd2d3ef2278d3a7001c9b00000000000000000000000000000000086bc60936e31c95ddd23ee26ba845c9a6ed6c976b32abe3a5515b57553b3cde6f8dcb225a9151aad27cdc7357b5a378dd756c32348e02b66e55b1305f975798d44fbaa9d99ab471d532d6945bb6768e5722c66375d6ade0da69da3eb78abf697946160707172b3c4ceb3daa2f98565dbab14fc8a9a2b1b09d49c61ece1654dddf4a3659e66cd1a1abad2c949e57ea57cfe76f8187a1709cdbb5acd2519714acce919ab98b7ed78cff009781954f77045aaf8b8caa57a693bd3d6949e566a5878dadf02a52792e08acad5079f89b58130e8bcd7136b0122558a7ca4c6d6a54f5e8d2e7aa2718a859bba94e29bb2cdff734b00fd2d3dcf5965b6de24751f4bc1f9a24c13f4d4fbe8cb7be35a7540039b4000000000000000000000000000000008f11454e2e2ef67d4ecf233abe8f8c55f9f71f78a9ea7c945bf89f94f2cbf11f1f86c7e270fe8dd2a3514611719d39eaba719a6ea45df3525b8a383fc54a7fb6c24aff00bd4ebc6a37e15230b7c4b11abca2fc48a786c554c2b51ab1a0d45d453e635a4e2a4f5632d6bc6cd59eb7591d3fc4ec3bd54a9e22dbda9539c52e17cfe5c4c1d3da47436909c2a5475a85451d493e635b596e52953535967bf7f0b6263b925a3249cb0fa460a4b371954a52696f7ab78b5f0368eeb17ca9c1555778cad4da4da8ff00d1ce7272dd67d2d5cbf8d714604397b2a5594a4a5520e59bd55094a37db672694b7daf6ed3f3bd211e65da9e339dee4a4d7f42954d23564ace575db18a6bc50fad27cbfa0f09a428e2215abd19a9d3a8a766ae9ab5059493cd3cf63ea187f563c1791f9e7e14c651a78bab2f52a25413cdbe7234a72b3ea569ed3f41c33e8c7babc8d4bb8cd9cad52799aba3a4645366b68d17a22c4df4bc3ee4b82f6d4fbe8af37d2f0fb93609fa5a7df893c69d6a010393600000000000000000000000000000000e47943f871a371b5675eb53a8abd5d5d7ab4ebd58b7ab08c22f51b70ca318af5771c8693fc0da2d7f87c6d583bded5e9c2b2b755e1a96e399fae803f98f94df8658ec1bce546b45ad652a539276d99c671567e2ce66be86c5b8b8f3755ddab2beb2daba9b4b89fd63a634352c4c756a6b2b5ed283b4927b57533169720b08bf3557d9ad15f628fe72d1fc86c4cedce4a145757b49fc165f33add17f87d868a8b70ab889b9af59b54d452ceea36b66d6d6f61fb0692d0987a0a1cdd3576e5772e9376b5b69564f2b1a92337271f8dc1428c610a708528c9ce6e14e118414ba2b6259bb6f2e61df463dd5e47ce5146ce9f767e7114362e0bc8e8e6b54de68d8d1a62d3da8dad184ab1eeabe9fe9fb92e065e9a97bc8f995ebbe9787dcfb8097a6a5ef23e64f1a76e0039360000000000000000000000000000000000000000c6e526ca7c65f630cdde512ca1c65f630e474c7a632ed9ba630caa6ae6938eb2cd64eed3dbbb615e34524975248b78b79c78fd990c8d32aed59af135b45bda64c9f497066a68bde3c23ed67d27c179b3de8ff006d4bde43ea44551f4df05e6c9701eda97bd87d489e34ee11f4039360000000000000000000000000000000000000000c6e523e8c38cbc9183366d72a9da34fbd2f239e954c8e98f4c65da0c53cd71fb321912547b38fd9914d9a65593e93ec5f735f45ec664c17acfb5235745ef1e2c79acfa6f82f364ba3a5e9e97bd87d488313ebbeec7ce449a37dbd2f7b4fea43c577e0038b60000000000000000000000000000000000000000c0e56fab4fbd2f2397aace9f960fa14bbefe939a3a63d317b5694f671fb323a9223c6e32842a53a72a9084ea4ad0529c539cb57d58c5bbb7d28fc56fc8b91a093bdee693489c2d15c73e26868bd8ca18b96ce25dd16f26088f14fa6fbabce44ba31fa7a3ef69fd48ad8d974ff004af364ba2e5e9a8fbea5f5a1e0fd10007174000000000000000000000000000000000000003e37f2039fe59fb3a7ef3fdace569d65b1e5d4ce8f95b8b84e108c5eb38d4bb6b67aad6dde7292573ae3d39e579733cb7e48623178ac357a134a0a31a759eb59d0d59b9738baef7f92f0ed24cc6ab29c64ad26959af1cbfa1e275ea3c9c9d8ba36b189adad2cb62c8d4d10f230e9a36b44bc85e88871efa6fbabcd92e8a7e9e8fbea5f5a20c6be9be0bee4da2bdbd1f7d4beb42f4afd2400716c0000000000000000000000000000000000015749e29d2a529a49b8dad7d8aed2bbeccce57138da953d7937fc3b22bc0ecdab9938ce4fd19bbc75a94bae9be8bfd0eebc8d636466cb5cb62dde3e373319d1e37406262ba3a95d763e6a7f0774fe28c0c4425076a909d27ff920e29f096c7f13a6e563486ac2f6e3f6678748b9187fcdc473a65456d43474622aaa4cb984e8a6db5d5c5bdcbad92ac53c5be9bf02d684a339d7a4a0b5b52a539cddb28c14d36df5649f134f4772627565af56f4a0ecf57f6b25c3f279f623adc160e9d28ea53828476d96f7d6ded6fb4cdc9bd2c2001cda00000000000000000000000000000000000000000f32826acd269ed4d5d3f03d0032313c9bc2cddd53e6a4f7d26e9fff002ba3f233aaf2565f92b5fa954867ff00b47fa1d402ccac4d47214f92f5dbe94e94575c75e6fe0d2f337346684a547a5ebd4ff32766d76456c8ae0698172b492400045000000000000000000000000000000000000000000000000000000000000000000000000000000007ffd9');
INSERT INTO public.device VALUES (26, 'New device', 'Brand', NULL, NULL, true, NULL, NULL, NULL, 'RX', NULL);


--
-- TOC entry 5642 (class 0 OID 25192)
-- Dependencies: 238
-- Data for Name: device_inspection; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.device_inspection VALUES (6, 10, NULL, NULL, -1, NULL, NULL, 3, true);
INSERT INTO public.device_inspection VALUES (7, 11, '2022-03-09 00:00:00+01', '2022-08-08 00:00:00+02', 5, '', 'inspection', 4, false);
INSERT INTO public.device_inspection VALUES (8, 12, '2022-10-04 00:00:00+02', '2022-12-14 00:00:00+01', 5, '', '', 4, false);
INSERT INTO public.device_inspection VALUES (9, 14, '2025-03-07 00:00:00+01', '2025-03-07 00:00:00+01', 5, '', 'Contrôle annuel', 3, false);
INSERT INTO public.device_inspection VALUES (5, 10, '2021-03-02 00:00:00+01', '2021-02-02 00:00:00+01', -1, 'RAS', 'Contrôle annuel', 4, false);


--
-- TOC entry 5644 (class 0 OID 25199)
-- Dependencies: 240
-- Data for Name: device_installation; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.device_installation VALUES (10, 12, 2, '2021-03-24 14:27:20+01', NULL, false, '', '', '');
INSERT INTO public.device_installation VALUES (12, 13, -1, '2022-03-08 11:02:10.199686+01', NULL, false, '', '', '');
INSERT INTO public.device_installation VALUES (11, 11, 2, '2021-01-05 14:27:35+01', '2023-03-31 15:06:31+02', false, '', '', '');
INSERT INTO public.device_installation VALUES (61, 10, -1, '2024-06-12 16:59:51.867526+02', NULL, false, '', '', '');
INSERT INTO public.device_installation VALUES (62, 10, -1, '2024-09-27 11:37:03.925148+02', NULL, false, '', '', '');
INSERT INTO public.device_installation VALUES (63, 10, -1, '2024-09-27 11:37:06.995365+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (64, 14, 3, '2025-03-06 17:20:35+01', '2025-03-07 17:28:06+01', false, '', '', '');
INSERT INTO public.device_installation VALUES (9, 10, 4, '2020-12-01 12:28:52+01', '2024-06-30 16:52:36+02', false, 'yyyyyyy', 'xxx', 'azerty');
INSERT INTO public.device_installation VALUES (13, 10, 7, '2024-06-07 17:29:43+02', NULL, false, 'rrrrrrr', 'gggg', 'kkkkkkkkkkkkkkkkkkk');
INSERT INTO public.device_installation VALUES (19, 10, -1, '2024-06-07 18:03:19.800838+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (20, 10, -1, '2024-06-07 18:03:21.681398+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (17, 10, -1, '2024-06-07 17:56:12.909538+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (16, 10, -1, '2024-06-07 17:44:40.246606+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (15, 10, -1, '2024-06-07 17:33:35.66635+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (21, 10, -1, '2024-06-07 18:03:23.300045+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (18, 10, -1, '2024-06-07 18:02:48.990268+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (14, 10, -1, '2024-06-07 17:33:05.666069+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (27, 10, -1, '2024-06-10 11:36:53.074703+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (24, 10, -1, '2024-06-10 11:29:49.881918+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (23, 10, -1, '2024-06-10 11:27:58.143581+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (25, 10, -1, '2024-06-10 11:34:39.122889+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (26, 10, -1, '2024-06-10 11:35:57.017304+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (28, 10, -1, '2024-06-10 11:38:05.280453+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (22, 10, -1, '2024-06-10 11:25:24.813331+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (33, 10, -1, '2024-06-10 14:54:42.478017+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (32, 10, -1, '2024-06-10 14:53:39.336398+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (31, 10, -1, '2024-06-10 14:49:30.159721+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (30, 10, -1, '2024-06-10 13:56:48.477928+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (29, 10, -1, '2024-06-10 11:43:31.686073+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (40, 10, -1, '2024-06-10 16:05:06.765154+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (37, 10, -1, '2024-06-10 15:04:23.154162+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (39, 10, -1, '2024-06-10 16:04:22.8477+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (38, 10, -1, '2024-06-10 16:02:39.503565+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (35, 10, -1, '2024-06-10 15:00:59.447726+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (34, 10, -1, '2024-06-10 15:00:38.107823+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (36, 10, -1, '2024-06-10 15:02:13.693898+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (47, 10, -1, '2024-06-10 16:19:38.47234+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (49, 10, -1, '2024-06-10 16:20:17.502251+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (45, 10, -1, '2024-06-10 16:13:00.39569+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (48, 10, -1, '2024-06-10 16:20:13.665552+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (44, 10, -1, '2024-06-10 16:11:23.56868+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (41, 10, -1, '2024-06-10 16:06:08.42954+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (42, 10, -1, '2024-06-10 16:08:10.960582+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (43, 10, -1, '2024-06-10 16:10:33.363239+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (59, 10, -1, '2024-06-10 16:25:30.932162+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (56, 10, -1, '2024-06-10 16:25:29.222963+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (57, 10, -1, '2024-06-10 16:25:29.62949+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (54, 10, -1, '2024-06-10 16:25:27.209746+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (55, 10, -1, '2024-06-10 16:25:28.558113+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (52, 10, -1, '2024-06-10 16:25:17.031008+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (53, 10, -1, '2024-06-10 16:25:18.132693+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (46, 10, -1, '2024-06-10 16:18:55.724211+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (50, 10, -1, '2024-06-10 16:25:13.660449+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (51, 10, -1, '2024-06-10 16:25:15.782679+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (58, 10, -1, '2024-06-10 16:25:30.261555+02', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (60, 10, -1, '2024-06-12 16:56:34.090711+02', NULL, false, '', '', '');
INSERT INTO public.device_installation VALUES (65, 14, -1, '2025-03-06 17:28:11.425125+01', NULL, true, '', '', '');
INSERT INTO public.device_installation VALUES (66, 25, 3, '2025-04-16 14:05:22+02', NULL, false, '', '', '');
INSERT INTO public.device_installation VALUES (67, 11, 2, '2025-04-16 14:08:02+02', '2026-10-01 14:22:25+02', false, '', '', '');


--
-- TOC entry 5646 (class 0 OID 25209)
-- Dependencies: 242
-- Data for Name: device_maintenance; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.device_maintenance VALUES (3, 10, NULL, NULL, NULL, '', 'Corrective', 3, false);
INSERT INTO public.device_maintenance VALUES (4, 12, NULL, NULL, NULL, NULL, NULL, 3, false);
INSERT INTO public.device_maintenance VALUES (5, 10, NULL, NULL, NULL, NULL, NULL, 3, true);
INSERT INTO public.device_maintenance VALUES (7, 10, '2025-03-06 00:00:00+01', '2025-03-06 00:00:00+01', NULL, '', 'Corrective', 4, false);
INSERT INTO public.device_maintenance VALUES (6, 10, NULL, '2025-03-06 00:00:00+01', NULL, '', 'Preventive', 3, false);


--
-- TOC entry 5648 (class 0 OID 25216)
-- Dependencies: 244
-- Data for Name: document; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.document VALUES (291, 'legaldocument_291.pdf', 'PQ-001_Maitrise_des_documents.pdf', 'legaldocument', 'pdf', '2024-09-17 17:30:17+02', false, 1, '', '', 0, 264, NULL, NULL, '', '2024-09-17 17:30:17.035287+02', '2024-09-25 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (290, 'legaldocument_290.pdf', 'XIM_QUA_01.00_CLA.0_Classification.pdf', 'legaldocument', 'pdf', '2024-09-16 09:24:42+02', false, 1, 'Doc label 002', '', 0, 263, NULL, NULL, '', '2024-09-16 09:24:42.629794+02', '2024-10-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (295, 'legaldocument_295.pdf', 'PQ-006_Examen.pdf', 'legaldocument', 'pdf', '2024-09-17 17:35:04+02', false, 1, '', '', 0, 268, NULL, NULL, '', '2024-09-17 17:35:04.592429+02', '2024-09-29 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (296, 'legaldocument_296.pdf', '20190710_b-quaadril_fr_juillet_2019.pdf', 'legaldocument', 'pdf', '2024-09-18 08:23:34+02', false, 1, '', '', 0, 269, NULL, NULL, '', '2024-09-18 08:23:34.492074+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (300, 'institution_300.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'institution', 'pdf', '2024-09-18 11:35:53+02', false, 1, '', '', 0, 272, NULL, NULL, '', '2024-09-18 11:35:53.835485+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (304, 'procedure_304.pdf', 'GUIDE N° 11 Indice 2 • Version du 07.10.2009 • MAJ juillet 2015.pdf', 'procedure', 'pdf', '2024-09-18 11:54:01+02', false, 1, '', '', 0, 274, NULL, NULL, '', '2024-09-18 11:54:01.053547+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (308, 'examlist_308.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'examlist', 'pdf', '2024-09-18 17:46:17+02', false, 1, '', '', 0, 278, NULL, NULL, '', '2024-09-18 17:46:17.93195+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (312, 'staff_formation_312.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'staff_formation', 'pdf', '2024-09-19 09:14:50+02', false, 1, '', '', 0, 282, NULL, NULL, '', '2024-09-19 09:14:50.880571+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (316, 'device_maintenance_316.pdf', 'Décision n° 2019-DC-0660 de l''ASN du 15 janvier 2019 .pdf', 'device_maintenance', 'pdf', '2024-09-19 18:03:41+02', false, 1, '', '', 0, 286, NULL, NULL, '', '2024-09-19 18:03:41.717567+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (320, 'afcnsend_320.pdf', '2013-59-EURATOM.pdf', 'afcnsend', 'pdf', '2024-09-24 17:36:05.545135+02', false, 1, 'Test', 'Test', 0, 290, NULL, NULL, NULL, '2024-09-24 17:36:05.545135+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (324, 'afcnsend_324.pdf', 'Décision n° 2019-DC-0660 de l''ASN du 15 janvier 2019 .pdf', 'afcnsend', 'pdf', '2024-09-25 09:59:21.877554+02', false, 1, '', '', 0, 294, NULL, NULL, NULL, '2024-09-25 09:59:21.877554+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (325, 'procedure_325.pdf', '20190710_b-quaadril_fr_juillet_2019.pdf', 'procedure', 'pdf', '2024-10-03 19:00:27+02', false, 1, '', '', 0, 295, NULL, NULL, '', '2024-10-03 19:00:27.04642+02', '2024-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (327, 'report_327.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'report', 'pdf', '2024-10-04 16:19:38+02', false, 1, '', '', 0, 297, NULL, NULL, '', '2024-10-04 16:19:38.420038+02', '2024-10-04 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (333, 'procedure_333.pdf', 'PQ-005_Incident.pdf', 'procedure', 'pdf', '2025-01-08 14:28:00+01', false, 1, '', '', 0, 301, NULL, NULL, '', '2025-01-08 14:28:00.070366+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (337, 'survey_337.pdf', 'XIM_PQ05.6_IT.pdf', 'survey', 'pdf', '2025-02-19 18:31:17+01', false, 1, 'Conclusion enquête', 'RAS', 0, 304, NULL, NULL, '', '2025-02-19 18:31:17.533498+01', '2025-02-28 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (289, 'legaldocument_289.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'legaldocument', 'pdf', '2024-09-13 18:03:14+02', false, 4, 'Label doc rev4', '', 0, 262, NULL, NULL, '', '2024-09-13 18:03:14.104987+02', '2025-03-29 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (343, 'legaldocument_343.pdf', 'PACS Displays How to Select the.pdf', 'legaldocument', 'pdf', '2025-03-06 10:32:45+01', false, 1, '', '', 0, 310, NULL, NULL, '', '2025-03-06 10:32:45.584891+01', '2025-03-31 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (345, 'procedure_345.pdf', 'PQ-005_Incident.pdf', 'procedure', 'pdf', '2025-03-07 14:12:01+01', false, 1, 'PQ-005', '', 0, 311, NULL, NULL, '', '2025-03-07 14:12:01.328538+01', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (286, 'legaldocument_286.pdf', '2013-59-EURATOM.pdf', 'legaldocument', 'pdf', '2024-09-13 17:35:51+02', false, 1, '', '', 0, 262, NULL, NULL, '', '2024-09-13 17:35:51.107904+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (297, 'legaldocument_297.pdf', 'Décision n° 2019-DC-0660 de l''ASN du 15 janvier 2019 .pdf', 'legaldocument', 'pdf', '2024-09-18 08:43:42+02', false, 2, 'BQUAAD 002', '', 0, 269, NULL, NULL, '', '2024-09-18 08:43:42.233255+02', '2024-09-20 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (301, 'legaldocument_301.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'legaldocument', 'pdf', '2024-09-18 11:37:04+02', false, 2, 'Inst 002', '', 0, 272, NULL, NULL, '', '2024-09-18 11:37:04.096001+02', '2024-09-24 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (305, 'procedure_305.pdf', 'Décision n° 2019-DC-0660 de l''ASN du 15 janvier 2019 .pdf', 'procedure', 'pdf', '2024-09-18 11:55:37+02', false, 1, '', '', 0, 275, NULL, NULL, '', '2024-09-18 11:55:37.219531+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (313, 'device_313.pdf', '20190710_b-quaadril_fr_juillet_2019.pdf', 'device', 'pdf', '2024-09-19 17:41:21+02', false, 1, '', '', 0, 283, NULL, NULL, '', '2024-09-19 17:41:21.252237+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (317, 'report_317.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'report', 'pdf', '2024-09-19 18:15:59+02', false, 1, '', '', 0, 287, NULL, NULL, '', '2024-09-19 18:15:59.063135+02', '2024-09-22 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (321, 'afcnsend_321.pdf', 'Décision n° 2019-DC-0660 de l''ASN du 15 janvier 2019 .pdf', 'afcnsend', 'pdf', '2024-09-24 17:36:43.263317+02', false, 1, '', '', 0, 291, NULL, NULL, NULL, '2024-09-24 17:36:43.263317+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (326, 'procedure_326.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'procedure', 'pdf', '2024-10-03 19:30:41+02', false, 1, '', '', 0, 296, NULL, NULL, '', '2024-10-03 19:30:41.830562+02', '2024-10-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (328, 'report_328.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'report', 'pdf', '2024-10-04 16:20:47+02', false, 1, '', '', 0, 298, NULL, NULL, '', '2024-10-04 16:20:47.730232+02', '2024-10-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (292, 'legaldocument_292.pdf', 'PQ-002_Radioprotection-dosimétrie.pdf', 'legaldocument', 'pdf', '2024-09-17 17:32:01+02', false, 1, '', '', 0, 265, NULL, NULL, '', '2024-09-17 17:32:01.361481+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (344, 'legaldocument_344.pdf', 'Five Levels of PACS Modularity Integrating 3D.pdf', 'legaldocument', 'pdf', '2025-03-06 10:33:23+01', false, 2, 'New Doc', '', 0, 310, NULL, NULL, '', '2025-03-06 10:33:23.043614+01', '2025-05-31 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (334, 'procedure_334.pdf', 'PQ-006_Examen.pdf', 'procedure', 'pdf', '2025-01-08 14:28:28+01', false, 1, '', '', 0, 302, NULL, NULL, '', '2025-01-08 14:28:28.684442+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (287, 'legaldocument_287.pdf', '20190710_b-quaadril_fr_juillet_2019.pdf', 'legaldocument', 'pdf', '2024-09-13 17:36:14+02', false, 2, '', '', 0, 262, NULL, NULL, '', '2024-09-13 17:36:14.278934+02', '2024-10-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (293, 'legaldocument_293.pdf', 'PQ-007_Plateau-technique.pdf', 'legaldocument', 'pdf', '2024-09-17 17:32:35+02', false, 1, '', '', 0, 266, NULL, NULL, '', '2024-09-17 17:32:35.905287+02', '2024-09-27 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (302, 'institution_302.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'institution', 'pdf', '2024-09-18 11:42:19+02', false, 1, '', '', 0, 273, NULL, NULL, '', '2024-09-18 11:42:19.113298+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (306, 'department_306.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'department', 'pdf', '2024-09-18 14:13:01+02', false, 1, 'Dep 001', '', 0, 276, NULL, NULL, '', '2024-09-18 14:13:01.285133+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (314, 'device_installation_314.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'device_installation', 'pdf', '2024-09-19 17:49:00+02', false, 1, '', '', 0, 284, NULL, NULL, '', '2024-09-19 17:49:00.043971+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (318, 'audit_318.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'audit', 'pdf', '2024-09-19 18:23:30+02', false, 1, '', '', 0, 288, NULL, NULL, '', '2024-09-19 18:23:30.786746+02', '2024-09-23 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (322, 'afcnsend_322.pdf', '2013-59-EURATOM.pdf', 'afcnsend', 'pdf', '2024-09-24 17:39:58.785928+02', false, 1, '', '', 0, 292, NULL, NULL, NULL, '2024-09-24 17:39:58.785928+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (335, 'procedure_335.pdf', 'PQ-007_Plateau-technique.pdf', 'procedure', 'pdf', '2025-01-08 14:29:28+01', false, 2, 'PQ007', '', 0, 295, NULL, NULL, '', '2025-01-08 14:29:28.12827+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (298, 'legaldocument_298.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'legaldocument', 'pdf', '2024-09-19 09:34:05+02', false, 1, '', '', 0, 270, NULL, NULL, '', '2024-09-18 11:26:21.348212+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (331, 'procedure_331.pdf', 'PQ-003_RH.pdf', 'procedure', 'pdf', '2025-01-08 14:26:45+01', false, 1, '', '', 0, 299, NULL, NULL, '', '2025-01-08 14:26:45.164564+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (288, 'legaldocument_288.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'legaldocument', 'pdf', '2024-09-13 17:39:58+02', false, 3, '', '', 0, 262, NULL, NULL, '', '2024-09-13 17:39:58.317692+02', '2024-11-30 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (336, 'examlist_otherdocument_336.pdf', 'Produit de contraste.pdf', 'examlist_otherdocument', 'pdf', '2025-01-14 09:56:03+01', false, 1, 'Fiche patient', '', 0, 303, NULL, NULL, '', '2025-01-14 09:56:03.160914+01', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (330, 'procedure_330.pdf', 'PQ-002_Radioprotection-dosimétrie.pdf', 'procedure', 'pdf', '2025-01-08 14:26:13+01', false, 2, 'PQ002', '', 0, 296, NULL, NULL, '', '2025-01-08 14:26:13.836719+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (329, 'procedure_329.pdf', 'PQ-001_Maitrise_des_documents.pdf', 'procedure', 'pdf', '2025-01-08 14:25:36+01', false, 2, 'PQ001', '', 0, 275, NULL, NULL, '', '2025-01-08 14:25:36.87464+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (294, 'legaldocument_294.pdf', 'PQ-005_Incident.pdf', 'legaldocument', 'pdf', '2024-09-17 17:34:29+02', false, 1, '', '', 0, 267, NULL, NULL, '', '2024-09-17 17:34:29.522617+02', '2024-09-28 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (299, 'legaldocument_299.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'legaldocument', 'pdf', '2024-09-18 11:27:08+02', false, 1, '', '', 0, 271, NULL, NULL, '', '2024-09-18 11:27:08.445566+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (303, 'institution_303.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'institution', 'pdf', '2024-09-18 11:42:43+02', false, 2, 'Inst 002', '', 0, 273, NULL, NULL, '', '2024-09-18 11:42:43.419745+02', '2024-09-29 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (307, 'department_307.pdf', 'GUIDE N° 11 Indice 2 • Version du 07.10.2009 • MAJ juillet 2015.pdf', 'department', 'pdf', '2024-09-18 14:30:59+02', false, 1, '', '', 0, 277, NULL, NULL, '', '2024-09-18 14:30:59.266564+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (311, 'staff_member_311.pdf', 'GUIDE N° 11 Indice 2 • Version du 07.10.2009 • MAJ juillet 2015.pdf', 'staff_member', 'pdf', '2024-09-18 18:12:31+02', false, 1, '', '', 0, 281, NULL, NULL, '', '2024-09-18 18:12:31.691952+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (315, 'device_inspection_315.pdf', 'GUIDE N° 11 Indice 2 • Version du 07.10.2009 • MAJ juillet 2015.pdf', 'device_inspection', 'pdf', '2024-09-19 17:58:16+02', false, 1, '', '', 0, 285, NULL, NULL, '', '2024-09-19 17:58:16.58904+02', '2024-09-29 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (323, 'afcnsend_323.pdf', 'Décision n° 2019-DC-0660 de l''ASN du 15 janvier 2019 .pdf', 'afcnsend', 'pdf', '2024-09-24 17:42:05.666194+02', false, 1, '', '', 0, 293, NULL, NULL, NULL, '2024-09-24 17:42:05.666194+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (332, 'procedure_332.pdf', 'PQ-004_Audit.pdf', 'procedure', 'pdf', '2025-01-08 14:27:30+01', false, 1, '', '', 0, 300, NULL, NULL, '', '2025-01-08 14:27:30.288584+01', '2045-01-08 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (319, 'audit_319.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'audit', 'pdf', '2024-09-19 18:29:30+02', false, 1, '', '', 0, 289, NULL, NULL, '', '2024-09-19 18:29:30.109945+02', '2024-09-29 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (378, NULL, NULL, 'procedure', 'docx', '2025-05-07 12:21:41+02', false, 1, '', '', 0, 349, 'procedure378.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 12:21:41.355682+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (379, NULL, NULL, 'procedure', 'docx', '2025-05-07 12:22:43+02', false, 1, '', '', 0, 350, 'procedure379.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 12:22:43.778424+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (354, 'examlist_354.pdf', '7_2_Le B Quaadril quelles implication pour nos services.pdf', 'examlist', 'pdf', '2025-05-05 15:50:09+02', false, 1, '', '', 0, 320, NULL, NULL, '', '2025-05-05 15:50:09.574296+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (347, 'examlist_347.pdf', 'examlist_3.pdf', 'examlist', 'pdf', '2025-04-25 15:00:15+02', false, 1, 'AAAAAAAAAAAAA', 'AAAAAAAAAAAAAAAAA', 0, 313, NULL, NULL, '', '2025-04-25 15:00:15.964429+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (309, 'examlist_309.pdf', 'plaquette de synthèse guide n° 11 MAJ juillet 2015.pdf', 'examlist', 'pdf', '2024-09-18 17:53:57+02', false, 1, 'Rev. 1', '', 0, 279, NULL, NULL, '', '2024-09-18 17:53:57.510407+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (355, 'examlist_355.docx', 'Reception eoDACS.docx', 'examlist', 'docx', '2025-05-05 18:43:03+02', false, 1, '', '', 0, 321, NULL, NULL, '', '2025-05-05 18:43:03.299708+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (356, 'examlist_356.docx', 'Reception eoDACS.docx', 'examlist', 'docx', '2025-05-05 18:46:05+02', false, 1, '', '', 0, 322, NULL, NULL, '', '2025-05-05 18:46:05.469794+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (357, 'examlist_357.docx', 'Reception eoDACS.docx', 'examlist', 'docx', '2025-05-05 18:49:19+02', false, 1, '', '', 0, 323, NULL, NULL, '', '2025-05-05 18:49:19.574573+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (358, 'procedure_358.docx', 'Reception eoDACS.docx', 'procedure', 'docx', '2025-05-05 19:34:46+02', false, 1, '', '', 0, 324, NULL, NULL, '', '2025-05-05 19:34:46.000551+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (359, 'procedure_359.docx', 'Reception eoDACS.docx', 'procedure', 'docx', '2025-05-05 19:35:29+02', false, 1, '', '', 0, 325, NULL, NULL, '', '2025-05-05 19:35:29.033476+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (360, 'procedure_360.docx', 'Reception eoDACS.docx', 'procedure', 'docx', '2025-05-06 09:20:34+02', false, 1, '', '', 0, 326, NULL, NULL, '', '2025-05-06 09:20:34.044711+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (363, 'procedure363docx', 'Reception eoDACS.docx', 'procedure', 'docx', '2025-05-06 10:33:38+02', false, 1, '', '', 0, 333, NULL, NULL, NULL, '2025-05-06 10:33:38.457528+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (364, 'procedure364docx', 'Reception eoDACS.docx', 'procedure', 'docx', '2025-05-06 10:34:52+02', false, 1, '', '', 0, 334, NULL, NULL, NULL, '2025-05-06 10:34:52.971649+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (365, 'procedure365.docx', 'Reception eoDACS.docx', 'procedure', 'docx', '2025-05-06 10:44:41+02', false, 1, '', '', 0, 336, NULL, NULL, NULL, '2025-05-06 10:44:41.258942+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (368, NULL, NULL, 'procedure', 'docx', '2025-05-06 17:42:28+02', false, 1, '', '', 0, 339, 'procedure368.docx', 'Reception eoDACS.docx', NULL, '2025-05-06 17:42:28.252727+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (369, NULL, NULL, 'procedure', 'docx', '2025-05-06 17:49:13+02', false, 1, '', '', 0, 340, 'procedure369.docx', 'Reception eoDACS.docx', NULL, '2025-05-06 17:49:13.829841+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (371, NULL, NULL, 'procedure', 'docx', '2025-05-07 11:48:39+02', false, 1, '', '', 0, 342, 'procedure371.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 11:48:39.41671+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (372, NULL, NULL, 'procedure', 'docx', '2025-05-07 11:54:49+02', false, 1, '', '', 0, 343, 'procedure372.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 11:54:49.192593+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (346, 'examlist_346.pdf', 'examlist_32.pdf', 'examlist', 'pdf', '2025-04-24 11:16:12+02', false, 1, 'Test', '', 0, 312, NULL, NULL, '', '2025-04-24 11:16:12.921006+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (310, 'examlist_otherdocument_310.pdf', 'recommandations_en_matiere_de_prescription_de_limagerie_medicale_pc.pdf', 'examlist_otherdocument', 'pdf', '2024-09-18 17:54:35+02', false, 1, '', '', 0, 280, NULL, NULL, '', '2024-09-18 17:54:35.553462+02', '2024-09-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (348, 'examlist_348.pdf', 'examlist_4.pdf', 'examlist', 'pdf', '2025-04-30 10:30:00+02', false, 1, 'Test', '', 0, 314, NULL, NULL, '', '2025-04-30 10:30:00.545389+02', '2054-04-30 23:59:59+02', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (349, 'institution_349.pdf', 'examlist_3.pdf', 'institution', 'pdf', '2025-04-30 17:28:24+02', false, 1, 'Inst 001', '', 0, 315, NULL, NULL, '', '2025-04-30 17:28:24.58462+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (350, 'examlist_otherdocument_350.docx', 'Reception eoDACS.docx', 'examlist_otherdocument', 'docx', '2025-05-05 15:35:44+02', false, 1, '', '', 0, 316, NULL, NULL, '', '2025-05-05 15:35:44.537751+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (351, 'examlist_otherdocument_351.pdf', '7_2_Le B Quaadril quelles implication pour nos services.pdf', 'examlist_otherdocument', 'pdf', '2025-05-05 15:36:27+02', false, 1, '', '', 0, 317, NULL, NULL, '', '2025-05-05 15:36:27.601351+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (352, 'examlist_otherdocument_352.pdf', '7_2_Le B Quaadril quelles implication pour nos services.pdf', 'examlist_otherdocument', 'pdf', '2025-05-05 15:37:16+02', false, 1, '', '', 0, 318, NULL, NULL, '', '2025-05-05 15:37:16.446289+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (353, 'examlist_353.pdf', '7_2_Le B Quaadril quelles implication pour nos services.pdf', 'examlist', 'pdf', '2025-05-05 15:38:50+02', false, 1, '', '', 0, 319, NULL, NULL, '', '2025-05-05 15:38:50.094295+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (373, NULL, NULL, 'procedure', 'docx', '2025-05-07 11:57:31+02', false, 1, '', '', 0, 344, 'procedure373.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 11:57:31.298598+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (374, NULL, NULL, 'procedure', 'docx', '2025-05-07 12:09:21+02', false, 1, '', '', 0, 345, 'procedure374.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 12:09:21.623452+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (375, NULL, NULL, 'procedure', 'docx', '2025-05-07 12:13:20+02', false, 1, '', '', 0, 346, 'procedure375.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 12:13:20.777315+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (376, NULL, NULL, 'procedure', 'docx', '2025-05-07 12:17:00+02', false, 1, '', '', 0, 347, 'procedure376.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 12:17:00.826046+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (377, NULL, NULL, 'procedure', 'docx', '2025-05-07 12:20:02+02', false, 1, '', '', 0, 348, 'procedure377.docx', 'Reception eoDACS.docx', NULL, '2025-05-07 12:20:02.29944+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (380, 'procedure380.pdf', NULL, 'procedure', 'docx', '2025-05-07 12:29:28+02', false, 1, '', '', 0, 351, 'procedure380.docx', 'Reception eoDACS.docx', '', '2025-05-07 12:29:28.581092+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (383, NULL, NULL, 'procedure', 'docx', '2025-05-07 16:46:46+02', false, 1, '', '', 0, 354, 'procedure383.docx', 'PQ-001_Maitrise_des_documents.docx', NULL, '2025-05-07 16:46:46.161753+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (381, 'procedure381.pdf', NULL, 'procedure', 'docx', '2025-05-07 15:44:12+02', false, 1, '', '', 0, 352, 'procedure381.docx', 'PQ-001_Maitrise_des_documents.docx', '', '2025-05-07 15:44:12.815743+02', '2025-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (384, NULL, NULL, 'procedure', 'docx', '2025-05-07 16:49:34+02', false, 1, '', '', 0, 355, 'procedure384.docx', 'PQ-002_Radioprotection-dosimétrie.docx', NULL, '2025-05-07 16:49:34.046926+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (370, NULL, NULL, 'procedure', 'docx', '2025-05-07 11:44:43+02', false, 1, '', '', 0, 341, 'procedure370.docx', 'Reception eoDACS.docx', '', '2025-05-07 11:44:43.292064+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (385, 'procedure385.pdf', NULL, 'procedure', 'docx', '2025-05-07 16:52:24+02', false, 1, '', '', 0, 356, 'procedure385.docx', 'PQ-002_Radioprotection-dosimétrie.docx', '', '2025-05-07 16:52:24.874162+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (382, 'procedure382.pdf', NULL, 'procedure', 'docx', '2025-05-07 16:01:47+02', false, 1, '', '', 0, 353, 'procedure382.docx', 'PQ-001_Maitrise_des_documents.docx', '', '2025-05-07 16:01:47.767047+02', '2999-12-31 23:59:59+01', '2025-08-27 18:13:57.640807+02');
INSERT INTO public.document VALUES (386, 'examlist386.pdf', NULL, 'examlist', 'docx', '2025-05-07 18:14:36+02', false, 1, '', '', 0, 357, 'examlist386.docx', 'IT-138_TDM_rachis_lombo_sacré.docx', '', '2025-05-07 18:14:36.670294+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (387, 'examlist_otherdocument387.pdf', NULL, 'examlist_otherdocument', 'docx', '2025-05-07 18:27:15+02', false, 1, '', '', 0, 358, 'examlist_otherdocument387.docx', 'MQ.0_Manuel_qualité.docx', '', '2025-05-07 18:27:15.195478+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (388, NULL, NULL, 'institution', 'docx', '2025-05-07 18:33:20+02', false, 1, 'Rev 0', '', 0, 359, 'institution388.docx', 'MQ.0_Manuel_qualité.docx', NULL, '2025-05-07 18:33:20.949262+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (405, 'procedure405.pdf', NULL, 'procedure', 'docx', '2025-05-12 09:26:57+02', false, 1, '', '', 0, 376, 'procedure405.docx', 'PQ-005_Incident.docx', '', '2025-05-12 09:26:57.367025+02', '2999-12-31 23:59:59+01', '2025-05-12 09:26:57.367025+02');
INSERT INTO public.document VALUES (389, 'institution389.pdf', NULL, 'institution', 'docx', '2025-05-07 18:40:27+02', false, 1, '', '', 0, 360, 'institution389.docx', 'PQ-005_Incident.docx', '', '2025-05-07 18:40:27.550977+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (390, 'legaldocument390.pdf', NULL, 'legaldocument', 'docx', '2025-05-07 18:50:05+02', false, 1, 'Test 0011', '', 0, 361, 'legaldocument390.docx', 'PQ-005_Incident.docx', '', '2025-05-07 18:50:05.635564+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (391, 'procedure391.pdf', 'PQ-003_RH.pdf', 'procedure', 'pdf', '2025-05-09 14:24:08+02', false, 1, 'aaaaaaaaaaa', '', 0, 362, NULL, NULL, '', '2025-05-09 14:24:08.274331+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (392, NULL, NULL, 'procedure', 'docx', '2025-05-09 14:53:44+02', false, 1, 'aaaaaaaaaaaaaaaaaaaaa', '', 0, 363, 'procedure392.docx', '', NULL, '2025-05-09 14:53:44.921454+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (393, NULL, NULL, 'procedure', 'docx', '2025-05-09 15:35:29+02', false, 1, 'bbbbbbbbbbbbbbbb', '', 0, 364, 'procedure393.docx', '', NULL, '2025-05-09 15:35:29.151943+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (394, NULL, NULL, 'procedure', 'xlsx', '2025-05-09 15:41:09+02', false, 1, 'FFFFFFFFFFFFFF', '', 0, 365, 'procedure394.xlsx', '', NULL, '2025-05-09 15:41:09.314425+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (395, NULL, NULL, 'procedure', 'xlsx', '2025-05-09 15:44:04+02', false, 1, 'GGGGGGGGGGGGGGG', '', 0, 366, 'procedure395.xlsx', '', NULL, '2025-05-09 15:44:04.160139+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (396, NULL, NULL, 'procedure', 'docx', '2025-05-09 16:00:41+02', false, 1, 'hhhhhhhhhhhhhhhhhhh', '', 0, 367, 'procedure396.docx', '', NULL, '2025-05-09 16:00:41.032799+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (397, NULL, NULL, 'procedure', 'xlsx', '2025-05-09 16:02:02+02', false, 1, '', '', 0, 368, 'procedure397.xlsx', '', NULL, '2025-05-09 16:02:02.911829+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (398, NULL, NULL, 'procedure', 'docx', '2025-05-09 16:05:49+02', false, 1, 'JJJJJJJJJJJJJJJJJJJJJJJJ', '', 0, 369, 'procedure398.docx', 'PQ-004_Audit.docx', NULL, '2025-05-09 16:05:49.141336+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (402, NULL, NULL, 'procedure', 'docx', '2025-05-09 16:19:26+02', false, 1, '', '', 0, 373, 'procedure402.docx', 'PQ-004_Audit.docx', NULL, '2025-05-09 16:19:26.267076+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (403, 'procedure403.pdf', NULL, 'procedure', 'docx', '2025-05-09 16:43:43+02', false, 1, '', '', 0, 374, 'procedure403.docx', 'PQ-006_Examen.docx', '', '2025-05-09 16:43:43.717841+02', '2999-12-31 23:59:59+01', '2025-05-10 11:08:33.244896+02');
INSERT INTO public.document VALUES (400, 'procedure400.xlsx', NULL, 'procedure', 'xlsx', '2025-05-09 16:10:49+02', false, 1, 'Rev 1', '', 0, 371, 'procedure400.xlsx', 'PQ-004_Audit.docx', '', '2025-05-09 16:10:49.100677+02', '2999-12-31 23:59:59+01', '2025-05-10 11:35:20.782963+02');
INSERT INTO public.document VALUES (404, 'procedure404.pdf', NULL, 'procedure', 'docx', '2025-05-12 09:23:51+02', false, 1, '', '', 0, 375, 'procedure404.docx', '', '', '2025-05-12 09:23:51.4487+02', '2999-12-31 23:59:59+01', '2025-05-12 09:24:28.164245+02');
INSERT INTO public.document VALUES (399, 'procedure399.pdf', NULL, 'procedure', 'docx', '2025-05-09 16:09:53+02', false, 1, 'Rev 1', '', 0, 370, 'procedure399.docx', 'PQ-004_Audit.docx', '', '2025-05-09 16:09:53.702122+02', '2999-12-31 23:59:59+01', '2025-08-27 18:21:38.029177+02');
INSERT INTO public.document VALUES (401, 'procedure401.pdf', NULL, 'procedure', 'docx', '2025-08-27 18:36:17+02', false, 1, 'Test 003 - Rev 1', '', 0, 372, 'procedure401.docx', 'PQ-004_Audit.docx', '', '2025-05-09 16:13:58.16611+02', '2025-08-31 23:59:59+02', '2025-05-16 17:02:04.451547+02');
INSERT INTO public.document VALUES (406, 'procedure406.pdf', NULL, 'procedure', 'docx', '2025-05-12 09:57:58+02', false, 1, '', '', 0, 377, 'procedure406.docx', 'PQ-005_Incident.docx', '', '2025-05-12 09:57:58.564033+02', '2999-12-31 23:59:59+01', '2025-05-12 09:57:58.564033+02');
INSERT INTO public.document VALUES (410, 'procedure410.pdf', NULL, 'procedure', 'docx', '2025-08-27 18:41:52+02', false, 2, '', '', 0, 377, 'procedure410.docx', '', '', '2025-08-27 18:41:52.19961+02', '2999-12-31 23:59:59+01', '2025-08-27 18:43:06.695475+02');


--
-- TOC entry 5650 (class 0 OID 25230)
-- Dependencies: 246
-- Data for Name: document_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.document_link VALUES (276, 'legaldocument', 1, 286);
INSERT INTO public.document_link VALUES (277, 'legaldocument', 1, 287);
INSERT INTO public.document_link VALUES (278, 'legaldocument', 1, 288);
INSERT INTO public.document_link VALUES (279, 'legaldocument', 1, 289);
INSERT INTO public.document_link VALUES (280, 'legaldocument', 1, 290);
INSERT INTO public.document_link VALUES (281, 'legaldocument', 1, 291);
INSERT INTO public.document_link VALUES (282, 'legaldocument', 1, 292);
INSERT INTO public.document_link VALUES (283, 'legaldocument', 1, 293);
INSERT INTO public.document_link VALUES (284, 'legaldocument', 1, 294);
INSERT INTO public.document_link VALUES (285, 'legaldocument', 1, 295);
INSERT INTO public.document_link VALUES (286, 'legaldocument', 2, 296);
INSERT INTO public.document_link VALUES (287, 'legaldocument', 2, 297);
INSERT INTO public.document_link VALUES (288, 'legaldocument', 1, 298);
INSERT INTO public.document_link VALUES (289, 'legaldocument', 2, 299);
INSERT INTO public.document_link VALUES (290, 'institution', 1, 300);
INSERT INTO public.document_link VALUES (291, 'legaldocument', 1, 301);
INSERT INTO public.document_link VALUES (292, 'institution', 1, 302);
INSERT INTO public.document_link VALUES (293, 'institution', 1, 303);
INSERT INTO public.document_link VALUES (294, 'procedure', -1, 304);
INSERT INTO public.document_link VALUES (295, 'procedure', 1, 305);
INSERT INTO public.document_link VALUES (296, 'department', 2, 306);
INSERT INTO public.document_link VALUES (297, 'department', 1, 307);
INSERT INTO public.document_link VALUES (298, 'examlist', -1, 308);
INSERT INTO public.document_link VALUES (299, 'examlist', 102, 309);
INSERT INTO public.document_link VALUES (300, 'examlist_otherdocument', 103, 310);
INSERT INTO public.document_link VALUES (301, 'staff_member', 14, 311);
INSERT INTO public.document_link VALUES (302, 'staff_formation', 5, 312);
INSERT INTO public.document_link VALUES (303, 'device', 10, 313);
INSERT INTO public.document_link VALUES (304, 'device_installation', 9, 314);
INSERT INTO public.document_link VALUES (305, 'device_inspection', 5, 315);
INSERT INTO public.document_link VALUES (306, 'device_maintenance', 4, 316);
INSERT INTO public.document_link VALUES (307, 'report', 5, 317);
INSERT INTO public.document_link VALUES (308, 'audit', -1, 318);
INSERT INTO public.document_link VALUES (309, 'audit', 14, 319);
INSERT INTO public.document_link VALUES (310, 'afcnsend', -1, 320);
INSERT INTO public.document_link VALUES (311, 'afcnsend', -1, 321);
INSERT INTO public.document_link VALUES (312, 'afcnsend', 9, 322);
INSERT INTO public.document_link VALUES (313, 'afcnsend', 10, 323);
INSERT INTO public.document_link VALUES (314, 'afcnsend', 9, 324);
INSERT INTO public.document_link VALUES (315, 'procedure', 2, 325);
INSERT INTO public.document_link VALUES (316, 'procedure', 6, 326);
INSERT INTO public.document_link VALUES (317, 'report', 22, 327);
INSERT INTO public.document_link VALUES (318, 'report', 25, 328);
INSERT INTO public.document_link VALUES (319, 'procedure', 1, 329);
INSERT INTO public.document_link VALUES (320, 'procedure', 6, 330);
INSERT INTO public.document_link VALUES (321, 'procedure', 5, 331);
INSERT INTO public.document_link VALUES (322, 'procedure', 8, 332);
INSERT INTO public.document_link VALUES (323, 'procedure', 7, 333);
INSERT INTO public.document_link VALUES (324, 'procedure', 3, 334);
INSERT INTO public.document_link VALUES (325, 'procedure', 2, 335);
INSERT INTO public.document_link VALUES (326, 'examlist_otherdocument', 102, 336);
INSERT INTO public.document_link VALUES (327, 'survey', 1, 337);
INSERT INTO public.document_link VALUES (328, 'legaldocument', 28, 343);
INSERT INTO public.document_link VALUES (329, 'legaldocument', 28, 344);
INSERT INTO public.document_link VALUES (330, 'procedure', 22, 345);
INSERT INTO public.document_link VALUES (331, 'examlist', 103, 346);
INSERT INTO public.document_link VALUES (332, 'examlist', 144, 347);
INSERT INTO public.document_link VALUES (333, 'examlist', 119, 348);
INSERT INTO public.document_link VALUES (334, 'institution', 2, 349);
INSERT INTO public.document_link VALUES (335, 'examlist_otherdocument', 102, 350);
INSERT INTO public.document_link VALUES (336, 'examlist_otherdocument', 102, 351);
INSERT INTO public.document_link VALUES (337, 'examlist_otherdocument', 102, 352);
INSERT INTO public.document_link VALUES (338, 'examlist', 118, 353);
INSERT INTO public.document_link VALUES (339, 'examlist', 118, 354);
INSERT INTO public.document_link VALUES (340, 'examlist', 121, 355);
INSERT INTO public.document_link VALUES (341, 'examlist', 121, 356);
INSERT INTO public.document_link VALUES (342, 'examlist', 121, 357);
INSERT INTO public.document_link VALUES (343, 'procedure', 24, 358);
INSERT INTO public.document_link VALUES (344, 'procedure', 24, 359);
INSERT INTO public.document_link VALUES (345, 'procedure', 25, 360);
INSERT INTO public.document_link VALUES (346, 'procedure', 26, NULL);
INSERT INTO public.document_link VALUES (347, 'procedure', 26, 364);
INSERT INTO public.document_link VALUES (348, 'procedure', 26, 365);
INSERT INTO public.document_link VALUES (349, 'procedure', 27, 368);
INSERT INTO public.document_link VALUES (350, 'procedure', 27, 369);
INSERT INTO public.document_link VALUES (351, 'procedure', -1, 370);
INSERT INTO public.document_link VALUES (352, 'procedure', 24, 371);
INSERT INTO public.document_link VALUES (353, 'procedure', 24, 372);
INSERT INTO public.document_link VALUES (354, 'procedure', 24, 373);
INSERT INTO public.document_link VALUES (355, 'procedure', 24, 374);
INSERT INTO public.document_link VALUES (356, 'procedure', 24, 375);
INSERT INTO public.document_link VALUES (357, 'procedure', 24, 376);
INSERT INTO public.document_link VALUES (358, 'procedure', 24, 377);
INSERT INTO public.document_link VALUES (359, 'procedure', 24, 378);
INSERT INTO public.document_link VALUES (360, 'procedure', 24, 379);
INSERT INTO public.document_link VALUES (361, 'procedure', 24, 380);
INSERT INTO public.document_link VALUES (362, 'procedure', 28, 381);
INSERT INTO public.document_link VALUES (363, 'procedure', 28, 382);
INSERT INTO public.document_link VALUES (364, 'procedure', 24, 383);
INSERT INTO public.document_link VALUES (365, 'procedure', 24, 384);
INSERT INTO public.document_link VALUES (366, 'procedure', 29, 385);
INSERT INTO public.document_link VALUES (367, 'examlist', 143, 386);
INSERT INTO public.document_link VALUES (368, 'examlist_otherdocument', 143, 387);
INSERT INTO public.document_link VALUES (369, 'institution', 2, 388);
INSERT INTO public.document_link VALUES (370, 'institution', 1, 389);
INSERT INTO public.document_link VALUES (371, 'legaldocument', 28, 390);
INSERT INTO public.document_link VALUES (372, 'procedure', 24, 391);
INSERT INTO public.document_link VALUES (373, 'procedure', 30, 392);
INSERT INTO public.document_link VALUES (374, 'procedure', 24, 393);
INSERT INTO public.document_link VALUES (375, 'procedure', 31, 394);
INSERT INTO public.document_link VALUES (376, 'procedure', 32, 395);
INSERT INTO public.document_link VALUES (377, 'procedure', 33, 396);
INSERT INTO public.document_link VALUES (378, 'procedure', 34, 397);
INSERT INTO public.document_link VALUES (379, 'procedure', 35, 398);
INSERT INTO public.document_link VALUES (380, 'procedure', 27, 399);
INSERT INTO public.document_link VALUES (381, 'procedure', 36, 400);
INSERT INTO public.document_link VALUES (382, 'procedure', 37, 401);
INSERT INTO public.document_link VALUES (383, 'procedure', 38, 402);
INSERT INTO public.document_link VALUES (384, 'procedure', 39, 403);
INSERT INTO public.document_link VALUES (385, 'procedure', 40, 404);
INSERT INTO public.document_link VALUES (386, 'procedure', 41, 405);
INSERT INTO public.document_link VALUES (387, 'procedure', 42, 406);
INSERT INTO public.document_link VALUES (388, 'procedure', 42, 410);


--
-- TOC entry 5652 (class 0 OID 25236)
-- Dependencies: 248
-- Data for Name: document_master; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.document_master VALUES (266, 'Test 1002', true);
INSERT INTO public.document_master VALUES (269, 'BQUAAD 001', false);
INSERT INTO public.document_master VALUES (271, 'Test Inst 1000', false);
INSERT INTO public.document_master VALUES (273, 'Test Inst 1000', false);
INSERT INTO public.document_master VALUES (277, 'Dep 001', false);
INSERT INTO public.document_master VALUES (281, 'CV', false);
INSERT INTO public.document_master VALUES (282, 'Formation 001', false);
INSERT INTO public.document_master VALUES (284, 'Device install 001', false);
INSERT INTO public.document_master VALUES (286, 'Device maintenance 001', false);
INSERT INTO public.document_master VALUES (288, 'Audit 001', true);
INSERT INTO public.document_master VALUES (290, 'Test', true);
INSERT INTO public.document_master VALUES (292, 'Test001111', false);
INSERT INTO public.document_master VALUES (294, 'Test002', false);
INSERT INTO public.document_master VALUES (295, 'Autorisation', false);
INSERT INTO public.document_master VALUES (297, '', false);
INSERT INTO public.document_master VALUES (301, 'PQ005', false);
INSERT INTO public.document_master VALUES (304, 'Conclusion enquête', false);
INSERT INTO public.document_master VALUES (305, 'Doc 001', false);
INSERT INTO public.document_master VALUES (307, 'Doc 002', false);
INSERT INTO public.document_master VALUES (309, 'Doc004', false);
INSERT INTO public.document_master VALUES (311, 'PQ-005', false);
INSERT INTO public.document_master VALUES (299, 'PQ003', false);
INSERT INTO public.document_master VALUES (267, 'Test 1003', true);
INSERT INTO public.document_master VALUES (276, 'Dep 001', true);
INSERT INTO public.document_master VALUES (278, 'Exam 001', false);
INSERT INTO public.document_master VALUES (283, 'Device info 001', false);
INSERT INTO public.document_master VALUES (285, 'Device inspect 001', false);
INSERT INTO public.document_master VALUES (287, 'Incident 001', false);
INSERT INTO public.document_master VALUES (291, 'Test1', true);
INSERT INTO public.document_master VALUES (293, 'Test002', false);
INSERT INTO public.document_master VALUES (298, 'Incident 123', false);
INSERT INTO public.document_master VALUES (300, 'PQ004', false);
INSERT INTO public.document_master VALUES (262, 'Doc 1.4', false);
INSERT INTO public.document_master VALUES (306, 'Doc 001', false);
INSERT INTO public.document_master VALUES (308, 'Doc003', false);
INSERT INTO public.document_master VALUES (289, 'Audit 001', false);
INSERT INTO public.document_master VALUES (302, 'PQ006', false);
INSERT INTO public.document_master VALUES (341, 'Gestion documentaire', false);
INSERT INTO public.document_master VALUES (353, 'Gestion documentaire', false);
INSERT INTO public.document_master VALUES (275, 'Proc 001', false);
INSERT INTO public.document_master VALUES (313, 'AAAAAAA', false);
INSERT INTO public.document_master VALUES (352, '', true);
INSERT INTO public.document_master VALUES (370, '', false);
INSERT INTO public.document_master VALUES (351, '', true);
INSERT INTO public.document_master VALUES (354, '', true);
INSERT INTO public.document_master VALUES (372, 'Test 003', false);
INSERT INTO public.document_master VALUES (356, '', false);
INSERT INTO public.document_master VALUES (357, '', false);
INSERT INTO public.document_master VALUES (358, '', false);
INSERT INTO public.document_master VALUES (359, 'Inst 002', false);
INSERT INTO public.document_master VALUES (312, 'Test', false);
INSERT INTO public.document_master VALUES (280, 'Patient sheet 001', false);
INSERT INTO public.document_master VALUES (314, 'Test', false);
INSERT INTO public.document_master VALUES (303, 'Fiche patient', false);
INSERT INTO public.document_master VALUES (270, 'Test Inst 1000', true);
INSERT INTO public.document_master VALUES (272, 'Test Inst 1000000', true);
INSERT INTO public.document_master VALUES (268, 'Test 10033', true);
INSERT INTO public.document_master VALUES (265, 'Test 1001', true);
INSERT INTO public.document_master VALUES (264, 'Test 1000', true);
INSERT INTO public.document_master VALUES (263, 'Doc 0022', true);
INSERT INTO public.document_master VALUES (315, 'Inst 001', false);
INSERT INTO public.document_master VALUES (360, '', false);
INSERT INTO public.document_master VALUES (377, 'Test 008', false);
INSERT INTO public.document_master VALUES (316, 'eoDACS', false);
INSERT INTO public.document_master VALUES (317, '', false);
INSERT INTO public.document_master VALUES (318, '', false);
INSERT INTO public.document_master VALUES (319, 'eoDACS', true);
INSERT INTO public.document_master VALUES (310, 'Doc 00555', true);
INSERT INTO public.document_master VALUES (355, '', true);
INSERT INTO public.document_master VALUES (320, 'eoDACS 1', false);
INSERT INTO public.document_master VALUES (279, 'Exam 00112', false);
INSERT INTO public.document_master VALUES (321, 'eoDACS', false);
INSERT INTO public.document_master VALUES (322, 'eoDACS', false);
INSERT INTO public.document_master VALUES (323, '', false);
INSERT INTO public.document_master VALUES (324, 'eoDACS', true);
INSERT INTO public.document_master VALUES (326, 'Test', false);
INSERT INTO public.document_master VALUES (327, 'Test', false);
INSERT INTO public.document_master VALUES (328, 'Test', false);
INSERT INTO public.document_master VALUES (329, 'Test', false);
INSERT INTO public.document_master VALUES (330, 'Test', false);
INSERT INTO public.document_master VALUES (331, 'Test', false);
INSERT INTO public.document_master VALUES (332, 'Test', false);
INSERT INTO public.document_master VALUES (333, 'Test', false);
INSERT INTO public.document_master VALUES (334, 'Test', true);
INSERT INTO public.document_master VALUES (335, 'Test', false);
INSERT INTO public.document_master VALUES (337, '', false);
INSERT INTO public.document_master VALUES (338, '', false);
INSERT INTO public.document_master VALUES (339, '', true);
INSERT INTO public.document_master VALUES (336, 'Test', true);
INSERT INTO public.document_master VALUES (274, 'Proc 001', true);
INSERT INTO public.document_master VALUES (325, 'eoDACS', true);
INSERT INTO public.document_master VALUES (342, '', true);
INSERT INTO public.document_master VALUES (343, '', true);
INSERT INTO public.document_master VALUES (344, '', true);
INSERT INTO public.document_master VALUES (345, '', true);
INSERT INTO public.document_master VALUES (346, '', true);
INSERT INTO public.document_master VALUES (347, '', true);
INSERT INTO public.document_master VALUES (348, '', true);
INSERT INTO public.document_master VALUES (349, '', true);
INSERT INTO public.document_master VALUES (350, '', true);
INSERT INTO public.document_master VALUES (361, 'Test 0011', false);
INSERT INTO public.document_master VALUES (363, '', false);
INSERT INTO public.document_master VALUES (362, '', true);
INSERT INTO public.document_master VALUES (364, '', false);
INSERT INTO public.document_master VALUES (365, '', false);
INSERT INTO public.document_master VALUES (366, '', false);
INSERT INTO public.document_master VALUES (367, '', false);
INSERT INTO public.document_master VALUES (368, '', false);
INSERT INTO public.document_master VALUES (369, '', false);
INSERT INTO public.document_master VALUES (340, '', true);
INSERT INTO public.document_master VALUES (373, '', false);
INSERT INTO public.document_master VALUES (374, '', false);
INSERT INTO public.document_master VALUES (371, '', false);
INSERT INTO public.document_master VALUES (376, '', false);
INSERT INTO public.document_master VALUES (375, '', false);
INSERT INTO public.document_master VALUES (296, 'Radioprotection', false);


--
-- TOC entry 5654 (class 0 OID 25243)
-- Dependencies: 250
-- Data for Name: documentstatus; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.documentstatus VALUES (298, '2024-09-13 17:36:14.275361+02', '2999-12-31 00:00:00+01', 286, 2);
INSERT INTO public.documentstatus VALUES (300, '2024-09-13 17:39:58.306765+02', '2999-12-31 00:00:00+01', 287, 2);
INSERT INTO public.documentstatus VALUES (302, '2024-09-13 18:03:14.102167+02', '2999-12-31 00:00:00+01', 288, 2);
INSERT INTO public.documentstatus VALUES (311, '2024-09-18 08:43:42.230785+02', '2999-12-31 00:00:00+01', 296, 2);
INSERT INTO public.documentstatus VALUES (316, '2024-09-18 11:37:04.092036+02', '2999-12-31 00:00:00+01', 300, 2);
INSERT INTO public.documentstatus VALUES (319, '2024-09-18 11:42:43.417744+02', '2999-12-31 00:00:00+01', 302, 2);
INSERT INTO public.documentstatus VALUES (346, '2025-01-08 14:25:36.837761+01', '2999-12-31 00:00:00+01', 305, 2);
INSERT INTO public.documentstatus VALUES (348, '2025-01-08 14:26:13.827383+01', '2999-12-31 00:00:00+01', 326, 2);
INSERT INTO public.documentstatus VALUES (354, '2025-01-08 14:29:28.125902+01', '2999-12-31 00:00:00+01', 325, 2);
INSERT INTO public.documentstatus VALUES (359, '2025-03-06 10:33:23.036646+01', '2999-12-31 00:00:00+01', 343, 2);
INSERT INTO public.documentstatus VALUES (297, '2024-09-13 17:35:51.117004+02', '2024-09-13 17:36:14.275361+02', 286, 14);
INSERT INTO public.documentstatus VALUES (299, '2024-09-13 17:36:14.286246+02', '2024-09-13 17:39:58.306765+02', 287, 14);
INSERT INTO public.documentstatus VALUES (301, '2024-09-13 17:39:58.342484+02', '2024-09-13 18:03:14.102167+02', 288, 14);
INSERT INTO public.documentstatus VALUES (303, '2024-09-13 18:03:14.113488+02', '2999-12-31 00:00:00+01', 289, 14);
INSERT INTO public.documentstatus VALUES (304, '2024-09-16 09:24:42.671424+02', '2999-12-31 00:00:00+01', 290, 14);
INSERT INTO public.documentstatus VALUES (305, '2024-09-17 17:30:17.062224+02', '2999-12-31 00:00:00+01', 291, 14);
INSERT INTO public.documentstatus VALUES (306, '2024-09-17 17:32:01.370536+02', '2999-12-31 00:00:00+01', 292, 14);
INSERT INTO public.documentstatus VALUES (307, '2024-09-17 17:32:35.91538+02', '2999-12-31 00:00:00+01', 293, 14);
INSERT INTO public.documentstatus VALUES (308, '2024-09-17 17:34:29.530639+02', '2999-12-31 00:00:00+01', 294, 14);
INSERT INTO public.documentstatus VALUES (309, '2024-09-17 17:35:04.602741+02', '2999-12-31 00:00:00+01', 295, 14);
INSERT INTO public.documentstatus VALUES (310, '2024-09-18 08:23:34.524069+02', '2024-09-18 08:43:42.230785+02', 296, 14);
INSERT INTO public.documentstatus VALUES (312, '2024-09-18 08:43:42.242855+02', '2999-12-31 00:00:00+01', 297, 14);
INSERT INTO public.documentstatus VALUES (313, '2024-09-18 11:26:21.357335+02', '2999-12-31 00:00:00+01', 298, 14);
INSERT INTO public.documentstatus VALUES (314, '2024-09-18 11:27:08.452999+02', '2999-12-31 00:00:00+01', 299, 14);
INSERT INTO public.documentstatus VALUES (315, '2024-09-18 11:35:53.848721+02', '2024-09-18 11:37:04.092036+02', 300, 14);
INSERT INTO public.documentstatus VALUES (317, '2024-09-18 11:37:04.102702+02', '2999-12-31 00:00:00+01', 301, 14);
INSERT INTO public.documentstatus VALUES (318, '2024-09-18 11:42:19.126112+02', '2024-09-18 11:42:43.417744+02', 302, 14);
INSERT INTO public.documentstatus VALUES (320, '2024-09-18 11:42:43.425651+02', '2999-12-31 00:00:00+01', 303, 14);
INSERT INTO public.documentstatus VALUES (321, '2024-09-18 11:54:01.06323+02', '2999-12-31 00:00:00+01', 304, 14);
INSERT INTO public.documentstatus VALUES (323, '2024-09-18 14:13:01.298608+02', '2999-12-31 00:00:00+01', 306, 14);
INSERT INTO public.documentstatus VALUES (324, '2024-09-18 14:30:59.277302+02', '2999-12-31 00:00:00+01', 307, 14);
INSERT INTO public.documentstatus VALUES (325, '2024-09-18 17:46:17.950065+02', '2999-12-31 00:00:00+01', 308, 14);
INSERT INTO public.documentstatus VALUES (326, '2024-09-18 17:53:57.520698+02', '2999-12-31 00:00:00+01', 309, 14);
INSERT INTO public.documentstatus VALUES (327, '2024-09-18 17:54:35.568684+02', '2999-12-31 00:00:00+01', 310, 14);
INSERT INTO public.documentstatus VALUES (328, '2024-09-18 18:12:31.706018+02', '2999-12-31 00:00:00+01', 311, 14);
INSERT INTO public.documentstatus VALUES (329, '2024-09-19 09:14:50.904832+02', '2999-12-31 00:00:00+01', 312, 14);
INSERT INTO public.documentstatus VALUES (330, '2024-09-19 17:41:21.27163+02', '2999-12-31 00:00:00+01', 313, 14);
INSERT INTO public.documentstatus VALUES (331, '2024-09-19 17:49:00.054856+02', '2999-12-31 00:00:00+01', 314, 14);
INSERT INTO public.documentstatus VALUES (332, '2024-09-19 17:58:16.603142+02', '2999-12-31 00:00:00+01', 315, 14);
INSERT INTO public.documentstatus VALUES (333, '2024-09-19 18:03:41.736573+02', '2999-12-31 00:00:00+01', 316, 14);
INSERT INTO public.documentstatus VALUES (334, '2024-09-19 18:15:59.072386+02', '2999-12-31 00:00:00+01', 317, 14);
INSERT INTO public.documentstatus VALUES (335, '2024-09-19 18:23:30.79973+02', '2999-12-31 00:00:00+01', 318, 14);
INSERT INTO public.documentstatus VALUES (336, '2024-09-19 18:29:30.11831+02', '2999-12-31 00:00:00+01', 319, 14);
INSERT INTO public.documentstatus VALUES (337, '2024-09-24 17:36:05.579301+02', '2999-12-31 00:00:00+01', 320, 14);
INSERT INTO public.documentstatus VALUES (338, '2024-09-24 17:36:43.273163+02', '2999-12-31 00:00:00+01', 321, 14);
INSERT INTO public.documentstatus VALUES (339, '2024-09-24 17:39:58.796504+02', '2999-12-31 00:00:00+01', 322, 14);
INSERT INTO public.documentstatus VALUES (340, '2024-09-24 17:42:05.675704+02', '2999-12-31 00:00:00+01', 323, 14);
INSERT INTO public.documentstatus VALUES (341, '2024-09-25 09:59:21.903144+02', '2999-12-31 00:00:00+01', 324, 14);
INSERT INTO public.documentstatus VALUES (344, '2024-10-04 16:19:38.444917+02', '2999-12-31 00:00:00+01', 327, 14);
INSERT INTO public.documentstatus VALUES (345, '2024-10-04 16:20:47.739968+02', '2999-12-31 00:00:00+01', 328, 14);
INSERT INTO public.documentstatus VALUES (322, '2024-09-18 11:55:37.235086+02', '2025-01-08 14:25:36.837761+01', 305, 14);
INSERT INTO public.documentstatus VALUES (349, '2025-01-08 14:26:13.870615+01', '2025-05-14 17:51:16.277688+02', 330, 14);
INSERT INTO public.documentstatus VALUES (343, '2024-10-03 19:30:41.843106+02', '2025-01-08 14:26:13.827383+01', 326, 14);
INSERT INTO public.documentstatus VALUES (350, '2025-01-08 14:26:45.174006+01', '2025-08-27 15:28:40.770301+02', 331, 14);
INSERT INTO public.documentstatus VALUES (351, '2025-01-08 14:27:30.300431+01', '2999-12-31 00:00:00+01', 332, 14);
INSERT INTO public.documentstatus VALUES (352, '2025-01-08 14:28:00.079709+01', '2999-12-31 00:00:00+01', 333, 14);
INSERT INTO public.documentstatus VALUES (353, '2025-01-08 14:28:28.700293+01', '2999-12-31 00:00:00+01', 334, 14);
INSERT INTO public.documentstatus VALUES (342, '2024-10-03 19:00:27.075848+02', '2025-01-08 14:29:28.125902+01', 325, 14);
INSERT INTO public.documentstatus VALUES (355, '2025-01-08 14:29:28.136397+01', '2999-12-31 00:00:00+01', 335, 14);
INSERT INTO public.documentstatus VALUES (356, '2025-01-14 09:56:03.200415+01', '2999-12-31 00:00:00+01', 336, 14);
INSERT INTO public.documentstatus VALUES (357, '2025-02-19 18:31:17.557342+01', '2999-12-31 00:00:00+01', 337, 14);
INSERT INTO public.documentstatus VALUES (358, '2025-03-06 10:32:45.597766+01', '2025-03-06 10:33:23.036646+01', 343, 14);
INSERT INTO public.documentstatus VALUES (360, '2025-03-06 10:33:23.049252+01', '2999-12-31 00:00:00+01', 344, 14);
INSERT INTO public.documentstatus VALUES (361, '2025-03-07 14:12:01.348183+01', '2999-12-31 00:00:00+01', 345, 14);
INSERT INTO public.documentstatus VALUES (362, '2025-04-24 11:16:12.941133+02', '2999-12-31 00:00:00+01', 346, 14);
INSERT INTO public.documentstatus VALUES (363, '2025-04-25 15:00:15.986289+02', '2999-12-31 00:00:00+01', 347, 14);
INSERT INTO public.documentstatus VALUES (364, '2025-04-30 10:30:00.574927+02', '2999-12-31 00:00:00+01', 348, 14);
INSERT INTO public.documentstatus VALUES (365, '2025-04-30 17:28:24.59754+02', '2999-12-31 00:00:00+01', 349, 14);
INSERT INTO public.documentstatus VALUES (366, '2025-05-05 15:35:44.557291+02', '2999-12-31 00:00:00+01', 350, 1);
INSERT INTO public.documentstatus VALUES (367, '2025-05-05 15:36:27.609904+02', '2999-12-31 00:00:00+01', 351, 1);
INSERT INTO public.documentstatus VALUES (368, '2025-05-05 15:37:16.454912+02', '2999-12-31 00:00:00+01', 352, 1);
INSERT INTO public.documentstatus VALUES (369, '2025-05-05 15:38:50.103631+02', '2999-12-31 00:00:00+01', 353, 1);
INSERT INTO public.documentstatus VALUES (370, '2025-05-05 15:50:09.583015+02', '2025-05-05 16:16:58.303422+02', 354, 1);
INSERT INTO public.documentstatus VALUES (371, '2025-05-05 16:16:58.303422+02', '2025-05-05 16:17:16.33181+02', 354, 10);
INSERT INTO public.documentstatus VALUES (372, '2025-05-05 16:17:16.33181+02', '2999-12-31 00:00:00+01', 354, 11);
INSERT INTO public.documentstatus VALUES (373, '2025-05-05 18:49:19.589434+02', '2999-12-31 00:00:00+01', 357, 10);
INSERT INTO public.documentstatus VALUES (374, '2025-05-05 19:34:46.010205+02', '2999-12-31 00:00:00+01', 358, 10);
INSERT INTO public.documentstatus VALUES (375, '2025-05-05 19:35:29.045345+02', '2999-12-31 00:00:00+01', 359, 10);
INSERT INTO public.documentstatus VALUES (376, '2025-05-06 09:20:34.070396+02', '2999-12-31 00:00:00+01', 360, 10);
INSERT INTO public.documentstatus VALUES (377, '2025-05-06 10:34:53.05182+02', '2999-12-31 00:00:00+01', 364, 10);
INSERT INTO public.documentstatus VALUES (378, '2025-05-06 10:44:41.342326+02', '2999-12-31 00:00:00+01', 365, 10);
INSERT INTO public.documentstatus VALUES (379, '2025-05-06 17:42:28.316474+02', '2999-12-31 00:00:00+01', 368, 10);
INSERT INTO public.documentstatus VALUES (380, '2025-05-06 17:49:13.898434+02', '2999-12-31 00:00:00+01', 369, 10);
INSERT INTO public.documentstatus VALUES (381, '2025-05-07 11:44:43.37793+02', '2999-12-31 00:00:00+01', 370, 10);
INSERT INTO public.documentstatus VALUES (382, '2025-05-07 11:48:39.497191+02', '2999-12-31 00:00:00+01', 371, 10);
INSERT INTO public.documentstatus VALUES (383, '2025-05-07 11:54:49.258989+02', '2999-12-31 00:00:00+01', 372, 10);
INSERT INTO public.documentstatus VALUES (384, '2025-05-07 11:57:31.360801+02', '2999-12-31 00:00:00+01', 373, 10);
INSERT INTO public.documentstatus VALUES (385, '2025-05-07 12:09:21.697345+02', '2999-12-31 00:00:00+01', 374, 10);
INSERT INTO public.documentstatus VALUES (386, '2025-05-07 12:13:20.846533+02', '2999-12-31 00:00:00+01', 375, 10);
INSERT INTO public.documentstatus VALUES (387, '2025-05-07 12:17:00.9+02', '2999-12-31 00:00:00+01', 376, 10);
INSERT INTO public.documentstatus VALUES (388, '2025-05-07 12:20:02.37798+02', '2999-12-31 00:00:00+01', 377, 10);
INSERT INTO public.documentstatus VALUES (389, '2025-05-07 12:21:41.423292+02', '2999-12-31 00:00:00+01', 378, 10);
INSERT INTO public.documentstatus VALUES (390, '2025-05-07 12:22:43.84996+02', '2999-12-31 00:00:00+01', 379, 10);
INSERT INTO public.documentstatus VALUES (391, '2025-05-07 12:29:28.65177+02', '2025-05-07 12:48:25.722984+02', 380, 10);
INSERT INTO public.documentstatus VALUES (392, '2025-05-07 12:48:25.722984+02', '2025-05-07 13:59:17.74303+02', 380, 14);
INSERT INTO public.documentstatus VALUES (393, '2025-05-07 13:59:17.74303+02', '2025-05-07 13:59:26.414897+02', 380, 10);
INSERT INTO public.documentstatus VALUES (394, '2025-05-07 13:59:26.414897+02', '2025-05-07 14:57:07.377149+02', 380, 14);
INSERT INTO public.documentstatus VALUES (395, '2025-05-07 14:57:07.377149+02', '2025-05-07 15:30:07.681829+02', 380, 10);
INSERT INTO public.documentstatus VALUES (396, '2025-05-07 15:30:07.681829+02', '2025-05-07 15:32:17.701336+02', 380, 14);
INSERT INTO public.documentstatus VALUES (397, '2025-05-07 15:32:17.701336+02', '2025-05-07 15:32:27.742909+02', 380, 10);
INSERT INTO public.documentstatus VALUES (398, '2025-05-07 15:32:27.742909+02', '2025-05-07 15:33:12.159291+02', 380, 14);
INSERT INTO public.documentstatus VALUES (399, '2025-05-07 15:33:12.159291+02', '2025-05-07 15:42:52.115474+02', 380, 10);
INSERT INTO public.documentstatus VALUES (400, '2025-05-07 15:42:52.115474+02', '2999-12-31 00:00:00+01', 380, 14);
INSERT INTO public.documentstatus VALUES (401, '2025-05-07 15:44:12.887101+02', '2025-05-07 15:46:47.769833+02', 381, 10);
INSERT INTO public.documentstatus VALUES (402, '2025-05-07 15:46:47.769833+02', '2999-12-31 00:00:00+01', 381, 14);
INSERT INTO public.documentstatus VALUES (403, '2025-05-07 16:01:47.871675+02', '2025-05-07 16:02:27.731267+02', 382, 10);
INSERT INTO public.documentstatus VALUES (405, '2025-05-07 16:46:46.23142+02', '2999-12-31 00:00:00+01', 383, 10);
INSERT INTO public.documentstatus VALUES (406, '2025-05-07 16:49:34.123256+02', '2999-12-31 00:00:00+01', 384, 10);
INSERT INTO public.documentstatus VALUES (404, '2025-05-07 16:02:27.731267+02', '2025-05-07 16:51:19.600142+02', 382, 14);
INSERT INTO public.documentstatus VALUES (407, '2025-05-07 16:51:19.600142+02', '2025-05-07 16:51:27.49364+02', 382, 10);
INSERT INTO public.documentstatus VALUES (409, '2025-05-07 16:52:24.9426+02', '2025-05-07 16:52:51.804338+02', 385, 10);
INSERT INTO public.documentstatus VALUES (410, '2025-05-07 16:52:51.804338+02', '2999-12-31 00:00:00+01', 385, 14);
INSERT INTO public.documentstatus VALUES (411, '2025-05-07 18:14:36.730265+02', '2025-05-07 18:24:45.184956+02', 386, 10);
INSERT INTO public.documentstatus VALUES (412, '2025-05-07 18:24:45.184956+02', '2999-12-31 00:00:00+01', 386, 14);
INSERT INTO public.documentstatus VALUES (413, '2025-05-07 18:27:15.254299+02', '2025-05-07 18:27:38.907544+02', 387, 10);
INSERT INTO public.documentstatus VALUES (414, '2025-05-07 18:27:38.907544+02', '2999-12-31 00:00:00+01', 387, 14);
INSERT INTO public.documentstatus VALUES (415, '2025-05-07 18:33:21.01581+02', '2999-12-31 00:00:00+01', 388, 10);
INSERT INTO public.documentstatus VALUES (416, '2025-05-07 18:40:27.609398+02', '2025-05-07 18:42:23.187284+02', 389, 10);
INSERT INTO public.documentstatus VALUES (417, '2025-05-07 18:42:23.187284+02', '2999-12-31 00:00:00+01', 389, 14);
INSERT INTO public.documentstatus VALUES (418, '2025-05-07 18:50:05.701525+02', '2025-05-07 18:56:51.138747+02', 390, 10);
INSERT INTO public.documentstatus VALUES (419, '2025-05-07 18:56:51.138747+02', '2999-12-31 00:00:00+01', 390, 14);
INSERT INTO public.documentstatus VALUES (408, '2025-05-07 16:51:27.49364+02', '2025-05-09 08:14:38.790438+02', 382, 14);
INSERT INTO public.documentstatus VALUES (421, '2025-05-09 14:24:08.346481+02', '2025-05-09 14:24:38.450722+02', 391, 10);
INSERT INTO public.documentstatus VALUES (422, '2025-05-09 14:24:38.450722+02', '2999-12-31 00:00:00+01', 391, 12);
INSERT INTO public.documentstatus VALUES (423, '2025-05-09 14:53:44.983956+02', '2999-12-31 00:00:00+01', 392, 10);
INSERT INTO public.documentstatus VALUES (424, '2025-05-09 15:35:29.232226+02', '2999-12-31 00:00:00+01', 393, 10);
INSERT INTO public.documentstatus VALUES (425, '2025-05-09 15:41:09.383933+02', '2999-12-31 00:00:00+01', 394, 10);
INSERT INTO public.documentstatus VALUES (426, '2025-05-09 15:44:04.231119+02', '2999-12-31 00:00:00+01', 395, 10);
INSERT INTO public.documentstatus VALUES (347, '2025-01-08 14:25:36.903572+01', '2025-05-14 12:54:12.358857+02', 329, 14);
INSERT INTO public.documentstatus VALUES (427, '2025-05-09 16:00:41.10999+02', '2999-12-31 00:00:00+01', 396, 10);
INSERT INTO public.documentstatus VALUES (428, '2025-05-09 16:02:02.97852+02', '2999-12-31 00:00:00+01', 397, 10);
INSERT INTO public.documentstatus VALUES (429, '2025-05-09 16:05:49.203316+02', '2999-12-31 00:00:00+01', 398, 10);
INSERT INTO public.documentstatus VALUES (432, '2025-05-09 16:13:58.225504+02', '2025-05-09 16:14:35.048829+02', 401, 10);
INSERT INTO public.documentstatus VALUES (434, '2025-05-09 16:19:26.331483+02', '2999-12-31 00:00:00+01', 402, 14);
INSERT INTO public.documentstatus VALUES (435, '2025-05-09 16:43:43.816914+02', '2025-05-09 16:44:19.585202+02', 403, 10);
INSERT INTO public.documentstatus VALUES (436, '2025-05-09 16:44:19.585202+02', '2999-12-31 00:00:00+01', 403, 14);
INSERT INTO public.documentstatus VALUES (431, '2025-05-09 16:10:49.159941+02', '2025-05-10 11:35:28.821846+02', 400, 10);
INSERT INTO public.documentstatus VALUES (437, '2025-05-10 11:35:28.821846+02', '2999-12-31 00:00:00+01', 400, 14);
INSERT INTO public.documentstatus VALUES (438, '2025-05-12 09:23:51.541841+02', '2025-05-12 09:24:48.875463+02', 404, 10);
INSERT INTO public.documentstatus VALUES (439, '2025-05-12 09:24:48.875463+02', '2999-12-31 00:00:00+01', 404, 14);
INSERT INTO public.documentstatus VALUES (440, '2025-05-12 09:26:57.534872+02', '2025-05-12 09:27:08.89168+02', 405, 14);
INSERT INTO public.documentstatus VALUES (441, '2025-05-12 09:27:08.89168+02', '2025-05-12 09:27:31.883418+02', 405, 10);
INSERT INTO public.documentstatus VALUES (442, '2025-05-12 09:27:31.883418+02', '2025-05-12 09:28:14.070288+02', 405, 14);
INSERT INTO public.documentstatus VALUES (444, '2025-05-12 09:57:58.722493+02', '2025-05-12 09:59:20.446816+02', 406, 10);
INSERT INTO public.documentstatus VALUES (445, '2025-05-12 09:59:20.446816+02', '2025-05-12 10:06:51.127472+02', 406, 14);
INSERT INTO public.documentstatus VALUES (443, '2025-05-12 09:28:14.070288+02', '2025-05-13 19:12:24.73387+02', 405, 10);
INSERT INTO public.documentstatus VALUES (447, '2025-05-13 19:12:24.73387+02', '2999-12-31 00:00:00+01', 405, 11);
INSERT INTO public.documentstatus VALUES (446, '2025-05-12 10:06:51.127472+02', '2025-05-13 19:22:59.997705+02', 406, 10);
INSERT INTO public.documentstatus VALUES (448, '2025-05-13 19:22:59.997705+02', '2025-05-13 19:23:26.584499+02', 406, 11);
INSERT INTO public.documentstatus VALUES (420, '2025-05-09 08:14:38.790438+02', '2025-05-13 19:47:00.639839+02', 382, 10);
INSERT INTO public.documentstatus VALUES (450, '2025-05-13 19:47:00.639839+02', '2025-05-13 20:06:49.985293+02', 382, 12);
INSERT INTO public.documentstatus VALUES (451, '2025-05-13 20:06:49.985293+02', '2025-05-13 20:07:10.685724+02', 382, 10);
INSERT INTO public.documentstatus VALUES (452, '2025-05-13 20:07:10.685724+02', '2025-05-13 20:08:23.565809+02', 382, 11);
INSERT INTO public.documentstatus VALUES (453, '2025-05-13 20:08:23.565809+02', '2999-12-31 00:00:00+01', 382, 10);
INSERT INTO public.documentstatus VALUES (454, '2025-05-14 12:54:12.358857+02', '2025-05-14 17:43:35.445084+02', 329, 10);
INSERT INTO public.documentstatus VALUES (455, '2025-05-14 17:43:35.445084+02', '2025-05-14 17:57:28.821857+02', 329, 11);
INSERT INTO public.documentstatus VALUES (456, '2025-05-14 17:51:16.277688+02', '2025-05-15 09:45:29.838502+02', 330, 11);
INSERT INTO public.documentstatus VALUES (433, '2025-05-09 16:14:35.048829+02', '2025-05-16 16:39:41.445378+02', 401, 14);
INSERT INTO public.documentstatus VALUES (460, '2025-08-27 15:28:40.770301+02', '2999-12-31 00:00:00+01', 331, 2);
INSERT INTO public.documentstatus VALUES (458, '2025-05-15 09:45:29.838502+02', '2025-08-27 15:40:24.619809+02', 330, 14);
INSERT INTO public.documentstatus VALUES (461, '2025-08-27 15:40:24.619809+02', '2999-12-31 00:00:00+01', 330, 2);
INSERT INTO public.documentstatus VALUES (457, '2025-05-14 17:57:28.821857+02', '2025-08-27 18:18:48.28644+02', 329, 14);
INSERT INTO public.documentstatus VALUES (462, '2025-08-27 18:18:48.28644+02', '2025-08-27 18:19:14.593533+02', 329, 10);
INSERT INTO public.documentstatus VALUES (463, '2025-08-27 18:19:14.593533+02', '2025-08-27 18:19:25.380105+02', 329, 14);
INSERT INTO public.documentstatus VALUES (464, '2025-08-27 18:19:25.380105+02', '2999-12-31 00:00:00+01', 329, 2);
INSERT INTO public.documentstatus VALUES (430, '2025-05-09 16:09:53.764607+02', '2025-08-27 18:31:15.005562+02', 399, 10);
INSERT INTO public.documentstatus VALUES (465, '2025-08-27 18:31:15.005562+02', '2999-12-31 00:00:00+01', 399, 14);
INSERT INTO public.documentstatus VALUES (459, '2025-05-16 16:39:41.445378+02', '2025-08-27 18:36:17.774592+02', 401, 10);
INSERT INTO public.documentstatus VALUES (466, '2025-08-27 18:36:17.774592+02', '2999-12-31 00:00:00+01', 401, 14);
INSERT INTO public.documentstatus VALUES (449, '2025-05-13 19:23:26.584499+02', '2025-08-27 18:40:34.026453+02', 406, 10);
INSERT INTO public.documentstatus VALUES (467, '2025-08-27 18:40:34.026453+02', '2025-08-27 18:41:52.097911+02', 406, 14);
INSERT INTO public.documentstatus VALUES (468, '2025-08-27 18:41:52.097911+02', '2999-12-31 00:00:00+01', 406, 2);
INSERT INTO public.documentstatus VALUES (469, '2025-08-27 18:41:52.247647+02', '2025-08-27 18:43:15.341062+02', 410, 10);
INSERT INTO public.documentstatus VALUES (470, '2025-08-27 18:43:15.341062+02', '2999-12-31 00:00:00+01', 410, 14);


--
-- TOC entry 5730 (class 0 OID 26820)
-- Dependencies: 351
-- Data for Name: documenttypelist; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.documenttypelist VALUES (0, 'External document link');
INSERT INTO public.documenttypelist VALUES (3, 'Excel document ( .xlsx )');
INSERT INTO public.documenttypelist VALUES (2, 'Word document ( .docx )');
INSERT INTO public.documenttypelist VALUES (1, 'PDF document ( .pdf )');


--
-- TOC entry 5656 (class 0 OID 25248)
-- Dependencies: 252
-- Data for Name: enum_listvalue; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.enum_listvalue VALUES ('jobrolescope', 0, 'Institution', 'en');
INSERT INTO public.enum_listvalue VALUES ('jobrolescope', 1, 'Department', 'en');


--
-- TOC entry 5657 (class 0 OID 25253)
-- Dependencies: 253
-- Data for Name: examident; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.examident VALUES (1, '451010', 'Radiographie de l''abdomen', false);
INSERT INTO public.examident VALUES (4, 'New exam ident', 'Description', true);
INSERT INTO public.examident VALUES (5, 'XXXXXXXXXXXXX', 'Description', false);


--
-- TOC entry 5659 (class 0 OID 25260)
-- Dependencies: 255
-- Data for Name: examident_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.examident_link VALUES (8, 1);
INSERT INTO public.examident_link VALUES (75, 1);
INSERT INTO public.examident_link VALUES (118, 1);
INSERT INTO public.examident_link VALUES (119, 5);
INSERT INTO public.examident_link VALUES (103, 1);
INSERT INTO public.examident_link VALUES (115, 5);
INSERT INTO public.examident_link VALUES (102, 1);
INSERT INTO public.examident_link VALUES (102, 5);


--
-- TOC entry 5660 (class 0 OID 25263)
-- Dependencies: 256
-- Data for Name: examlist; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.examlist VALUES (21, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (20, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (25, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (51, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (68, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (22, 'RX', 'New exam', 'XXX', true);
INSERT INTO public.examlist VALUES (23, 'RX', 'Test001', 'Test 001', true);
INSERT INTO public.examlist VALUES (24, 'RX', 'YYY', '', true);
INSERT INTO public.examlist VALUES (54, 'TDM', 'Massif facial traumatisme maxillo-facial', '', true);
INSERT INTO public.examlist VALUES (29, 'RX', 'Cholangiographie', '', true);
INSERT INTO public.examlist VALUES (4, 'RX', 'Sialographie', 'Sialographie', true);
INSERT INTO public.examlist VALUES (34, 'RX', 'Rachis lombo-sacré', '', true);
INSERT INTO public.examlist VALUES (70, 'RX', 'Discographie arthrographie facettaires lombaires infiltrations foraminales', '', true);
INSERT INTO public.examlist VALUES (52, 'TDM', 'Massif facial dysfonctionnement rhino-sinus chronique', '', true);
INSERT INTO public.examlist VALUES (67, 'TDM', 'Exploration limitée thorax', '', true);
INSERT INTO public.examlist VALUES (63, 'TDM', 'Aorte thoraco-abdominale', '', true);
INSERT INTO public.examlist VALUES (10, 'RX', 'Estomac', 'Radiographie du colon', true);
INSERT INTO public.examlist VALUES (35, 'RX', 'Bassin standard', '', true);
INSERT INTO public.examlist VALUES (45, 'TDM', 'Lésions hépatiques hypervasculaires', '', true);
INSERT INTO public.examlist VALUES (6, 'TDM', 'Abdo-pelv standard', '', true);
INSERT INTO public.examlist VALUES (39, 'RX', 'UIV contrôle simple', '', true);
INSERT INTO public.examlist VALUES (36, 'RX', 'Abdomen sans préparation', '', true);
INSERT INTO public.examlist VALUES (69, 'RX', 'Myélographie saccoradiculographie épidurographie', '', true);
INSERT INTO public.examlist VALUES (31, 'RX', 'Radio standard au lit', '', true);
INSERT INTO public.examlist VALUES (50, 'TDM', 'Encéphale standard', '', true);
INSERT INTO public.examlist VALUES (60, 'TDM', 'Vaisseaux pulmonaires', '', true);
INSERT INTO public.examlist VALUES (14, 'TDM', 'Pancréas standard', 'Scanner du pancréas standard', true);
INSERT INTO public.examlist VALUES (66, 'TDM', 'Carotide cervicale', '', true);
INSERT INTO public.examlist VALUES (59, 'TDM', 'Vaisseaux médiastinaux', '', true);
INSERT INTO public.examlist VALUES (13, 'TDM', 'Hépatique standard', 'Scanner hépatique standard', true);
INSERT INTO public.examlist VALUES (65, 'TDM', 'Contrôle endoprothèse aortique', '', true);
INSERT INTO public.examlist VALUES (2, 'RX', 'Thorax face', 'Radiographie du thorax de face', true);
INSERT INTO public.examlist VALUES (16, 'TDM', 'Pancréatique - pancréas non-tumoral', 'Scanner pancréatique - pancréas non-tumoral', true);
INSERT INTO public.examlist VALUES (62, 'TDM', 'Aorte abdominale', '', true);
INSERT INTO public.examlist VALUES (44, 'RX', 'Colpocystodéfécographie', '', true);
INSERT INTO public.examlist VALUES (11, 'RX', 'Intestin grêle', 'Radiographie de l''intestin grêle', true);
INSERT INTO public.examlist VALUES (42, 'RX', 'Cystographie suspubienne homme', '', true);
INSERT INTO public.examlist VALUES (41, 'RX', 'Cystographie rétrograde femme', '', true);
INSERT INTO public.examlist VALUES (40, 'RX', 'Urétrocystographie rétrograde homme', '', true);
INSERT INTO public.examlist VALUES (46, 'TDM', 'Ostéo-articulaire', '', true);
INSERT INTO public.examlist VALUES (43, 'RX', 'Hystérosalpingographie', '', true);
INSERT INTO public.examlist VALUES (53, 'TDM', 'Massif facial pathologie tumorale', '', true);
INSERT INTO public.examlist VALUES (32, 'RX', 'Rachis cervical', '', true);
INSERT INTO public.examlist VALUES (9, 'RX', 'Colon', 'Radiographie du colon', true);
INSERT INTO public.examlist VALUES (7, 'TDM', 'Abdomen non-traumatique aigu standard', '', true);
INSERT INTO public.examlist VALUES (38, 'RX', 'UIV avec étude mictionnelle', '', true);
INSERT INTO public.examlist VALUES (15, 'TDM', 'Pancréatique - lésions hypervasculaires', 'Scanner pancréatique - lésions hypervasculaires', true);
INSERT INTO public.examlist VALUES (48, 'TDM', 'Arthroscanner genou hanche épaule', '', true);
INSERT INTO public.examlist VALUES (26, 'RX', 'Rachis lombaire', '', true);
INSERT INTO public.examlist VALUES (12, 'TDM', 'Thorax haute résolution', 'Scanner du thorax haute résolution', true);
INSERT INTO public.examlist VALUES (57, 'TDM', 'Rénal', '', true);
INSERT INTO public.examlist VALUES (61, 'TDM', 'Artères rénales', '', true);
INSERT INTO public.examlist VALUES (19, 'Mammographie', 'Mammographie', 'Mammographie', true);
INSERT INTO public.examlist VALUES (30, 'RX', 'Thorax profil', '', true);
INSERT INTO public.examlist VALUES (49, 'TDM', 'Pelvimétrie', '', true);
INSERT INTO public.examlist VALUES (47, 'TDM', 'Rachis cervical', '', true);
INSERT INTO public.examlist VALUES (3, 'RX', 'Sinus', 'Radiographie des sinus', true);
INSERT INTO public.examlist VALUES (17, 'TDM', 'Vaisseaux hépatiques', 'Scanner des vaisseaux hépatiques', true);
INSERT INTO public.examlist VALUES (28, 'RX', 'Genou', '', true);
INSERT INTO public.examlist VALUES (37, 'RX', 'UIV standard', '', true);
INSERT INTO public.examlist VALUES (33, 'RX', 'Rachis thoracique', '', true);
INSERT INTO public.examlist VALUES (1, 'TDM', 'Thorax standard', 'Scanner thorax standard', true);
INSERT INTO public.examlist VALUES (5, 'RX', 'Panoramique dentaire', 'Panoramique dentaire', true);
INSERT INTO public.examlist VALUES (18, 'TDM', 'Rochers', 'Scanner des rochers', true);
INSERT INTO public.examlist VALUES (64, 'TDM', 'Bilan endoprothèse aortique', '', true);
INSERT INTO public.examlist VALUES (55, 'TDM', 'Cou en cancérologie', '', true);
INSERT INTO public.examlist VALUES (27, 'RX', 'Hanche', '', true);
INSERT INTO public.examlist VALUES (56, 'TDM', 'Dentaire', '', true);
INSERT INTO public.examlist VALUES (58, 'TDM', 'Tractus urinaire (sans contraste)', '', true);
INSERT INTO public.examlist VALUES (8, 'RX', 'Abdomen sans préparation', 'Radiographie de l''abdomen sans préparation', true);
INSERT INTO public.examlist VALUES (71, 'Radiographie', 'RX SINUS', 'RX SINUS', false);
INSERT INTO public.examlist VALUES (72, 'Radiographie', 'RX sialographie', 'RX sialographie', false);
INSERT INTO public.examlist VALUES (73, 'Radiographie', 'RX Pano dentaire', 'RX Pano dentaire', false);
INSERT INTO public.examlist VALUES (74, 'Radiographie', 'Rx thorax Face', 'Rx thorax Face', false);
INSERT INTO public.examlist VALUES (75, 'Radiographie', 'Rx abdomen à blanc', 'Rx abdomen à blanc', false);
INSERT INTO public.examlist VALUES (77, 'Radiographie', 'RX intestin grele', 'RX intestin grele', false);
INSERT INTO public.examlist VALUES (76, 'Radiographie', 'RX estomac', 'RX estomac', false);
INSERT INTO public.examlist VALUES (78, 'Radiographie', 'RX colon', 'RX colon', false);
INSERT INTO public.examlist VALUES (79, 'Radiographie', 'RX rachis cervical', 'RX rachis cervical', false);
INSERT INTO public.examlist VALUES (84, 'Radiographie', 'RX rachis dorsal', 'RX rachis dorsal', false);
INSERT INTO public.examlist VALUES (83, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (85, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (82, 'Radiographie', 'IN Discographie arthrographies_facettaires lombaires infiltrations foraminales', 'IN Discographie arthrographies_facettaires lombaires infiltrations foraminales', false);
INSERT INTO public.examlist VALUES (81, 'Radiographie', 'IN Myélographie saccoradiculographie épidurographie', 'IN Myélographie saccoradiculographie épidurographie', false);
INSERT INTO public.examlist VALUES (90, 'Radiographie', 'RX Uretrocystographie retrograde homme', 'RX Uretrocystographie retrograde homme', false);
INSERT INTO public.examlist VALUES (80, 'Radiographie', 'RX rachis lombaire', 'RX rachis lombaire', false);
INSERT INTO public.examlist VALUES (86, 'Radiographie', 'RX rachis lombaire', 'RX rachis lombaire', true);
INSERT INTO public.examlist VALUES (87, 'Radiographie', 'RX urographie intraveineuse', '', false);
INSERT INTO public.examlist VALUES (88, 'Radiographie', 'RX urographie intraveineuse mictionelle', 'RX urographie intraveineuse mictionelle', false);
INSERT INTO public.examlist VALUES (89, 'Radiographie', 'RX urographie intraveineuse contrôle simple', 'RX urographie intraveineuse contrôle simple', false);
INSERT INTO public.examlist VALUES (91, 'Radiographie', 'RX Cystographie suspubienne', 'RX Cystographie suspubien', false);
INSERT INTO public.examlist VALUES (92, 'Radiographie', 'RX Hysterosalpingographie', 'RX Hysterosalpingographie', false);
INSERT INTO public.examlist VALUES (93, 'Radiographie', 'RX colpocystodefecographie', 'RX colpocystodefecographie', false);
INSERT INTO public.examlist VALUES (94, 'Radiographie', 'IN rachis lombaire bloc op', 'IN rachis lombaire bloc op', false);
INSERT INTO public.examlist VALUES (95, 'Radiographie', 'IN hanche bloc op', 'IN hanche bloc op', false);
INSERT INTO public.examlist VALUES (96, 'Radiographie', 'IN cholangiographie bloc op', 'IN cholangiographie bloc op', false);
INSERT INTO public.examlist VALUES (97, 'Radiographie', 'RX radio standard au lit', 'RX radio standard au lit', false);
INSERT INTO public.examlist VALUES (98, 'Radiographie', 'RX thorax profil', 'RX thorax profil', false);
INSERT INTO public.examlist VALUES (99, 'TDM', 'CT thorax', 'CT thorax', false);
INSERT INTO public.examlist VALUES (100, 'TDM', 'CT thorax HD', 'CT thorax HD', false);
INSERT INTO public.examlist VALUES (101, 'TDM', 'CT thorax exploration limitée', 'CT thorax exploration limitée', false);
INSERT INTO public.examlist VALUES (104, 'TDM', 'CT hépatique', 'CT hépatique', false);
INSERT INTO public.examlist VALUES (105, 'TDM', 'CT pancreas', 'CT pancréas', false);
INSERT INTO public.examlist VALUES (106, 'TDM', 'CT pancréas lésions hypervascularisées', 'CT pancréas lésions hypervascularisées', false);
INSERT INTO public.examlist VALUES (107, 'TDM', 'CT vaisseaux hépatiques', 'CT vaisseaux hépatiques', false);
INSERT INTO public.examlist VALUES (108, 'TDM', 'CT encéphale standard', 'CT encéphale standard', false);
INSERT INTO public.examlist VALUES (109, 'TDM', 'CT Massif facial pour dysfonctionnement rhino-sinusien chronique', 'CT Massif facial pour dysfonctionnement rhino-sinusien chronique', false);
INSERT INTO public.examlist VALUES (110, 'TDM', 'CT massif facial pour tumeur', 'CT massif facial pour tumeur', false);
INSERT INTO public.examlist VALUES (111, 'TDM', 'CT massif facial trauma', 'CT massif facial trauma', false);
INSERT INTO public.examlist VALUES (112, 'TDM', 'CT rochers', 'CT rochers', false);
INSERT INTO public.examlist VALUES (113, 'TDM', 'CT dentaire', 'CT dentaire', false);
INSERT INTO public.examlist VALUES (114, 'TDM', 'CT cou onco', 'CT cou onco', false);
INSERT INTO public.examlist VALUES (116, 'TDM', 'CT urinaire sans contraste', 'CT urinaire sans contraste', false);
INSERT INTO public.examlist VALUES (117, 'TDM', 'CT vaisseaux intestinaux', 'CT vaisseaux intestinaux', false);
INSERT INTO public.examlist VALUES (123, 'TDM', 'CT controle stent', 'CT controle stent', false);
INSERT INTO public.examlist VALUES (122, 'TDM', 'CT aorte thoraco-abdominale endoprothèse', 'CT aorte thoraco-abdominale endoprothèse', false);
INSERT INTO public.examlist VALUES (124, 'TDM', 'CT angioscanner carotidien', 'CT angioscanner carotidien', false);
INSERT INTO public.examlist VALUES (125, 'TDM', 'CT rachis cervical', 'CT rachis cervical', false);
INSERT INTO public.examlist VALUES (127, 'TDM', 'CT arthroscan', 'CT arthroscan', false);
INSERT INTO public.examlist VALUES (128, 'TDM', 'CT pelvimétrie', 'CT pelvimétrie', false);
INSERT INTO public.examlist VALUES (129, 'Mammographie', 'MG mammographie', 'MG mammographie', false);
INSERT INTO public.examlist VALUES (130, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (121, 'TDM', 'CT aorte thoraco-abdominale', 'CT aorte thoraco-abdominale', false);
INSERT INTO public.examlist VALUES (120, 'TDM', 'CT aorte abdominale standard', 'CT aorte abdominale standard', false);
INSERT INTO public.examlist VALUES (103, 'TDM', 'CT abdo aigu non traumatique', 'CT abdo aigu non traumatique', false);
INSERT INTO public.examlist VALUES (119, 'TDM', 'CT angioscan rénal', 'CT angioscan rénal', false);
INSERT INTO public.examlist VALUES (131, 'TDM', 'Exam_test', 'Exam de test sans document', true);
INSERT INTO public.examlist VALUES (132, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (134, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (135, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (133, '', 'test', '', true);
INSERT INTO public.examlist VALUES (102, 'TDM', 'CT abdo-pelv', 'CT abdo-pelv', false);
INSERT INTO public.examlist VALUES (137, 'Radiographie', 'Test', '', true);
INSERT INTO public.examlist VALUES (138, 'TDM', 'New exam', 'bbbbbbbbbbb', true);
INSERT INTO public.examlist VALUES (139, NULL, 'New exam', NULL, true);
INSERT INTO public.examlist VALUES (136, 'RX', 'New 001', 'aaaaaaaaaaaa', true);
INSERT INTO public.examlist VALUES (140, 'TDM', 'New exam', 'Test', true);
INSERT INTO public.examlist VALUES (141, 'TDM', 'New exam', 'Test', false);
INSERT INTO public.examlist VALUES (142, NULL, 'New exam', NULL, false);
INSERT INTO public.examlist VALUES (144, 'RX', 'New exam 001', 'Test 1', false);
INSERT INTO public.examlist VALUES (118, 'TDM', 'CT angioscan thoracique', 'CT angioscan thoracique', false);
INSERT INTO public.examlist VALUES (115, 'TDM', 'CT abdo pelvien urinaire', 'CT abdo pelvien urinaire', false);
INSERT INTO public.examlist VALUES (126, 'TDM', 'CT Lombaire', 'CT Lombaire', true);
INSERT INTO public.examlist VALUES (145, NULL, 'New exam', NULL, false);
INSERT INTO public.examlist VALUES (146, NULL, 'New exam', NULL, false);
INSERT INTO public.examlist VALUES (147, NULL, 'New exam', NULL, false);
INSERT INTO public.examlist VALUES (143, 'TDM', 'CT Lombaire', 'CT Lombaire', false);


--
-- TOC entry 5662 (class 0 OID 25270)
-- Dependencies: 258
-- Data for Name: examwarning; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.examwarning VALUES (1, 'Rayonnements ionisants', 'Les rayonnements ionisants utilisés durant les examens radiologiques peuvent ...', false, 2, 3);
INSERT INTO public.examwarning VALUES (4, '', NULL, true, -1, -1);
INSERT INTO public.examwarning VALUES (7, 'aaaaaaaaaaaaaaassssssssssssss', NULL, true, -1, -1);
INSERT INTO public.examwarning VALUES (5, 'a000', '', true, -1, -1);
INSERT INTO public.examwarning VALUES (6, 'azerty', '', true, -1, -1);
INSERT INTO public.examwarning VALUES (3, 'Rayonnements ionsiant et grossesse', 'Test.', false, 1, 2);
INSERT INTO public.examwarning VALUES (2, 'Allergie produit de contraste', 'L''injection de produit de contraste iodé peut provoquée une réaction allergoïde allant d''une simple sensation de démangeaison jusqu''au choc anaphylactique et à l’œdème de Quincke pouvant comporter un risque pour le patient.', false, 2, 3);
INSERT INTO public.examwarning VALUES (8, 'New Warning', NULL, true, -1, -1);
INSERT INTO public.examwarning VALUES (9, 'New Warning gggggggg', '', true, NULL, NULL);
INSERT INTO public.examwarning VALUES (10, 'New Warning', NULL, true, -1, -1);
INSERT INTO public.examwarning VALUES (11, 'New Warninggggggggggggg', '', true, NULL, NULL);


--
-- TOC entry 5664 (class 0 OID 25277)
-- Dependencies: 260
-- Data for Name: examwarning_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.examwarning_link VALUES (1, 1);
INSERT INTO public.examwarning_link VALUES (2, 1);
INSERT INTO public.examwarning_link VALUES (3, 1);
INSERT INTO public.examwarning_link VALUES (4, 1);
INSERT INTO public.examwarning_link VALUES (5, 1);
INSERT INTO public.examwarning_link VALUES (1, 2);
INSERT INTO public.examwarning_link VALUES (6, 1);
INSERT INTO public.examwarning_link VALUES (6, 2);
INSERT INTO public.examwarning_link VALUES (7, 1);
INSERT INTO public.examwarning_link VALUES (7, 2);
INSERT INTO public.examwarning_link VALUES (8, 1);
INSERT INTO public.examwarning_link VALUES (9, 1);
INSERT INTO public.examwarning_link VALUES (10, 1);
INSERT INTO public.examwarning_link VALUES (11, 1);
INSERT INTO public.examwarning_link VALUES (12, 1);
INSERT INTO public.examwarning_link VALUES (13, 1);
INSERT INTO public.examwarning_link VALUES (14, 1);
INSERT INTO public.examwarning_link VALUES (15, 1);
INSERT INTO public.examwarning_link VALUES (16, 1);
INSERT INTO public.examwarning_link VALUES (17, 1);
INSERT INTO public.examwarning_link VALUES (18, 1);
INSERT INTO public.examwarning_link VALUES (19, 1);
INSERT INTO public.examwarning_link VALUES (39, 2);
INSERT INTO public.examwarning_link VALUES (39, 1);
INSERT INTO public.examwarning_link VALUES (71, 1);
INSERT INTO public.examwarning_link VALUES (72, 2);
INSERT INTO public.examwarning_link VALUES (72, 1);
INSERT INTO public.examwarning_link VALUES (73, 1);
INSERT INTO public.examwarning_link VALUES (74, 1);
INSERT INTO public.examwarning_link VALUES (75, 1);
INSERT INTO public.examwarning_link VALUES (76, 1);
INSERT INTO public.examwarning_link VALUES (77, 1);
INSERT INTO public.examwarning_link VALUES (78, 1);
INSERT INTO public.examwarning_link VALUES (79, 1);
INSERT INTO public.examwarning_link VALUES (80, 1);
INSERT INTO public.examwarning_link VALUES (81, 2);
INSERT INTO public.examwarning_link VALUES (81, 1);
INSERT INTO public.examwarning_link VALUES (82, 2);
INSERT INTO public.examwarning_link VALUES (82, 1);
INSERT INTO public.examwarning_link VALUES (84, 1);
INSERT INTO public.examwarning_link VALUES (86, 1);
INSERT INTO public.examwarning_link VALUES (87, 2);
INSERT INTO public.examwarning_link VALUES (87, 1);
INSERT INTO public.examwarning_link VALUES (88, 2);
INSERT INTO public.examwarning_link VALUES (88, 1);
INSERT INTO public.examwarning_link VALUES (89, 2);
INSERT INTO public.examwarning_link VALUES (89, 1);
INSERT INTO public.examwarning_link VALUES (90, 2);
INSERT INTO public.examwarning_link VALUES (90, 1);
INSERT INTO public.examwarning_link VALUES (91, 2);
INSERT INTO public.examwarning_link VALUES (91, 1);
INSERT INTO public.examwarning_link VALUES (92, 2);
INSERT INTO public.examwarning_link VALUES (92, 1);
INSERT INTO public.examwarning_link VALUES (93, 1);
INSERT INTO public.examwarning_link VALUES (94, 1);
INSERT INTO public.examwarning_link VALUES (95, 1);
INSERT INTO public.examwarning_link VALUES (96, 1);
INSERT INTO public.examwarning_link VALUES (97, 1);
INSERT INTO public.examwarning_link VALUES (98, 1);
INSERT INTO public.examwarning_link VALUES (99, 1);
INSERT INTO public.examwarning_link VALUES (100, 1);
INSERT INTO public.examwarning_link VALUES (101, 1);
INSERT INTO public.examwarning_link VALUES (102, 2);
INSERT INTO public.examwarning_link VALUES (103, 2);
INSERT INTO public.examwarning_link VALUES (103, 1);
INSERT INTO public.examwarning_link VALUES (104, 2);
INSERT INTO public.examwarning_link VALUES (104, 1);
INSERT INTO public.examwarning_link VALUES (105, 2);
INSERT INTO public.examwarning_link VALUES (105, 1);
INSERT INTO public.examwarning_link VALUES (106, 1);
INSERT INTO public.examwarning_link VALUES (107, 2);
INSERT INTO public.examwarning_link VALUES (107, 1);
INSERT INTO public.examwarning_link VALUES (108, 1);
INSERT INTO public.examwarning_link VALUES (109, 1);
INSERT INTO public.examwarning_link VALUES (110, 2);
INSERT INTO public.examwarning_link VALUES (110, 1);
INSERT INTO public.examwarning_link VALUES (111, 1);
INSERT INTO public.examwarning_link VALUES (112, 1);
INSERT INTO public.examwarning_link VALUES (113, 1);
INSERT INTO public.examwarning_link VALUES (114, 2);
INSERT INTO public.examwarning_link VALUES (114, 1);
INSERT INTO public.examwarning_link VALUES (115, 2);
INSERT INTO public.examwarning_link VALUES (115, 1);
INSERT INTO public.examwarning_link VALUES (116, 1);
INSERT INTO public.examwarning_link VALUES (117, 2);
INSERT INTO public.examwarning_link VALUES (117, 1);
INSERT INTO public.examwarning_link VALUES (118, 2);
INSERT INTO public.examwarning_link VALUES (119, 2);
INSERT INTO public.examwarning_link VALUES (119, 1);
INSERT INTO public.examwarning_link VALUES (120, 2);
INSERT INTO public.examwarning_link VALUES (120, 1);
INSERT INTO public.examwarning_link VALUES (121, 2);
INSERT INTO public.examwarning_link VALUES (121, 1);
INSERT INTO public.examwarning_link VALUES (122, 2);
INSERT INTO public.examwarning_link VALUES (122, 1);
INSERT INTO public.examwarning_link VALUES (123, 2);
INSERT INTO public.examwarning_link VALUES (123, 1);
INSERT INTO public.examwarning_link VALUES (124, 2);
INSERT INTO public.examwarning_link VALUES (124, 1);
INSERT INTO public.examwarning_link VALUES (125, 1);
INSERT INTO public.examwarning_link VALUES (126, 1);
INSERT INTO public.examwarning_link VALUES (127, 1);
INSERT INTO public.examwarning_link VALUES (128, 1);
INSERT INTO public.examwarning_link VALUES (129, 1);
INSERT INTO public.examwarning_link VALUES (136, 3);
INSERT INTO public.examwarning_link VALUES (138, 1);
INSERT INTO public.examwarning_link VALUES (137, 3);
INSERT INTO public.examwarning_link VALUES (137, 2);


--
-- TOC entry 5665 (class 0 OID 25280)
-- Dependencies: 261
-- Data for Name: external_link; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 5667 (class 0 OID 25286)
-- Dependencies: 263
-- Data for Name: external_src; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 5669 (class 0 OID 25292)
-- Dependencies: 265
-- Data for Name: institution; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.institution VALUES (-1, 'Undef', true);
INSERT INTO public.institution VALUES (3, 'Aaaaaaaaaaaaaaaaaaaa', true);
INSERT INTO public.institution VALUES (4, 'New Institutionnnnnnnnnnnnn', true);
INSERT INTO public.institution VALUES (5, 'New Institution', true);
INSERT INTO public.institution VALUES (1, 'Site eoQUAL 1', false);
INSERT INTO public.institution VALUES (2, 'Site eoQUAL 2', false);


--
-- TOC entry 5671 (class 0 OID 25299)
-- Dependencies: 267
-- Data for Name: legaldocument; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.legaldocument VALUES (1, '2013-59 EURATOM', 'Directive', 'Normes de base relatives à la protection sanitaire contre les dangers résultant de
l''exposition aux rayonnements ionisants', false);
INSERT INTO public.legaldocument VALUES (2, 'B-QUAADRIL', 'Manuel', 'Manuel belge pour les audits cliniques en imagerie médicale', false);
INSERT INTO public.legaldocument VALUES (4, 'Signalement d’événements de radioprotection significatifs', 'Guide ASN', '', false);
INSERT INTO public.legaldocument VALUES (5, 'Signalement d’événements de radioprotection significatifs', 'Synthèse', '', false);
INSERT INTO public.legaldocument VALUES (6, 'Recommandations', 'Recommandation', 'Recommandation en matière de prescription d''imagerie médical', false);
INSERT INTO public.legaldocument VALUES (3, '2019-DC-0660', 'Décision', 'Obligations d’assurance de la qualité 
en imagerie médicale mettant en œuvre des rayonnements ionisants', true);
INSERT INTO public.legaldocument VALUES (7, 'Newtest', '', '', true);
INSERT INTO public.legaldocument VALUES (8, 'Test', '', '', true);
INSERT INTO public.legaldocument VALUES (28, 'Test 0011', '', '', false);


--
-- TOC entry 5673 (class 0 OID 25306)
-- Dependencies: 269
-- Data for Name: link_quaad_tag; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.link_quaad_tag VALUES (4, 1);
INSERT INTO public.link_quaad_tag VALUES (7, 4);
INSERT INTO public.link_quaad_tag VALUES (5, 2);
INSERT INTO public.link_quaad_tag VALUES (6, 3);
INSERT INTO public.link_quaad_tag VALUES (8, 8);
INSERT INTO public.link_quaad_tag VALUES (9, 9);
INSERT INTO public.link_quaad_tag VALUES (10, 10);
INSERT INTO public.link_quaad_tag VALUES (11, 11);
INSERT INTO public.link_quaad_tag VALUES (12, 12);
INSERT INTO public.link_quaad_tag VALUES (13, 13);
INSERT INTO public.link_quaad_tag VALUES (15, 14);
INSERT INTO public.link_quaad_tag VALUES (16, 15);
INSERT INTO public.link_quaad_tag VALUES (17, 16);
INSERT INTO public.link_quaad_tag VALUES (18, 17);
INSERT INTO public.link_quaad_tag VALUES (20, 18);
INSERT INTO public.link_quaad_tag VALUES (21, 19);
INSERT INTO public.link_quaad_tag VALUES (22, 20);
INSERT INTO public.link_quaad_tag VALUES (23, 21);
INSERT INTO public.link_quaad_tag VALUES (24, 22);
INSERT INTO public.link_quaad_tag VALUES (25, 23);
INSERT INTO public.link_quaad_tag VALUES (27, 24);
INSERT INTO public.link_quaad_tag VALUES (28, 25);
INSERT INTO public.link_quaad_tag VALUES (29, 26);
INSERT INTO public.link_quaad_tag VALUES (31, 27);
INSERT INTO public.link_quaad_tag VALUES (32, 28);
INSERT INTO public.link_quaad_tag VALUES (33, 29);
INSERT INTO public.link_quaad_tag VALUES (34, 30);
INSERT INTO public.link_quaad_tag VALUES (35, 31);
INSERT INTO public.link_quaad_tag VALUES (36, 32);
INSERT INTO public.link_quaad_tag VALUES (37, 33);
INSERT INTO public.link_quaad_tag VALUES (38, 34);
INSERT INTO public.link_quaad_tag VALUES (40, 35);
INSERT INTO public.link_quaad_tag VALUES (41, 36);
INSERT INTO public.link_quaad_tag VALUES (42, 37);
INSERT INTO public.link_quaad_tag VALUES (43, 38);
INSERT INTO public.link_quaad_tag VALUES (44, 39);
INSERT INTO public.link_quaad_tag VALUES (47, 41);
INSERT INTO public.link_quaad_tag VALUES (46, 40);
INSERT INTO public.link_quaad_tag VALUES (49, 42);
INSERT INTO public.link_quaad_tag VALUES (50, 43);
INSERT INTO public.link_quaad_tag VALUES (51, 44);
INSERT INTO public.link_quaad_tag VALUES (53, 45);
INSERT INTO public.link_quaad_tag VALUES (54, 46);
INSERT INTO public.link_quaad_tag VALUES (55, 47);
INSERT INTO public.link_quaad_tag VALUES (56, 48);
INSERT INTO public.link_quaad_tag VALUES (57, 49);
INSERT INTO public.link_quaad_tag VALUES (58, 50);
INSERT INTO public.link_quaad_tag VALUES (59, 51);
INSERT INTO public.link_quaad_tag VALUES (61, 52);
INSERT INTO public.link_quaad_tag VALUES (62, 53);
INSERT INTO public.link_quaad_tag VALUES (63, 54);
INSERT INTO public.link_quaad_tag VALUES (64, 55);
INSERT INTO public.link_quaad_tag VALUES (65, 56);
INSERT INTO public.link_quaad_tag VALUES (66, 57);
INSERT INTO public.link_quaad_tag VALUES (67, 58);
INSERT INTO public.link_quaad_tag VALUES (68, 59);
INSERT INTO public.link_quaad_tag VALUES (69, 60);
INSERT INTO public.link_quaad_tag VALUES (70, 61);
INSERT INTO public.link_quaad_tag VALUES (72, 62);
INSERT INTO public.link_quaad_tag VALUES (73, 63);
INSERT INTO public.link_quaad_tag VALUES (74, 64);
INSERT INTO public.link_quaad_tag VALUES (75, 65);
INSERT INTO public.link_quaad_tag VALUES (76, 66);
INSERT INTO public.link_quaad_tag VALUES (77, 67);
INSERT INTO public.link_quaad_tag VALUES (78, 68);
INSERT INTO public.link_quaad_tag VALUES (79, 69);
INSERT INTO public.link_quaad_tag VALUES (80, 70);
INSERT INTO public.link_quaad_tag VALUES (81, 71);
INSERT INTO public.link_quaad_tag VALUES (82, 72);
INSERT INTO public.link_quaad_tag VALUES (83, 73);
INSERT INTO public.link_quaad_tag VALUES (84, 74);
INSERT INTO public.link_quaad_tag VALUES (85, 75);
INSERT INTO public.link_quaad_tag VALUES (86, 76);
INSERT INTO public.link_quaad_tag VALUES (87, 77);
INSERT INTO public.link_quaad_tag VALUES (88, 78);
INSERT INTO public.link_quaad_tag VALUES (89, 79);
INSERT INTO public.link_quaad_tag VALUES (90, 80);
INSERT INTO public.link_quaad_tag VALUES (91, 81);
INSERT INTO public.link_quaad_tag VALUES (92, 82);
INSERT INTO public.link_quaad_tag VALUES (94, 83);
INSERT INTO public.link_quaad_tag VALUES (95, 84);
INSERT INTO public.link_quaad_tag VALUES (96, 85);
INSERT INTO public.link_quaad_tag VALUES (98, 86);
INSERT INTO public.link_quaad_tag VALUES (99, 27);
INSERT INTO public.link_quaad_tag VALUES (100, 87);
INSERT INTO public.link_quaad_tag VALUES (101, 88);
INSERT INTO public.link_quaad_tag VALUES (102, 89);
INSERT INTO public.link_quaad_tag VALUES (103, 90);
INSERT INTO public.link_quaad_tag VALUES (104, 91);
INSERT INTO public.link_quaad_tag VALUES (105, 92);
INSERT INTO public.link_quaad_tag VALUES (106, 93);
INSERT INTO public.link_quaad_tag VALUES (107, 94);
INSERT INTO public.link_quaad_tag VALUES (109, 95);
INSERT INTO public.link_quaad_tag VALUES (110, 96);
INSERT INTO public.link_quaad_tag VALUES (111, 97);
INSERT INTO public.link_quaad_tag VALUES (112, 98);
INSERT INTO public.link_quaad_tag VALUES (113, 99);
INSERT INTO public.link_quaad_tag VALUES (114, 100);
INSERT INTO public.link_quaad_tag VALUES (115, 101);
INSERT INTO public.link_quaad_tag VALUES (116, 102);
INSERT INTO public.link_quaad_tag VALUES (117, 103);
INSERT INTO public.link_quaad_tag VALUES (118, 104);
INSERT INTO public.link_quaad_tag VALUES (119, 105);
INSERT INTO public.link_quaad_tag VALUES (188, 174);
INSERT INTO public.link_quaad_tag VALUES (189, 175);
INSERT INTO public.link_quaad_tag VALUES (190, 176);
INSERT INTO public.link_quaad_tag VALUES (191, 177);
INSERT INTO public.link_quaad_tag VALUES (192, 178);
INSERT INTO public.link_quaad_tag VALUES (193, 179);
INSERT INTO public.link_quaad_tag VALUES (194, 180);
INSERT INTO public.link_quaad_tag VALUES (195, 181);
INSERT INTO public.link_quaad_tag VALUES (196, 182);
INSERT INTO public.link_quaad_tag VALUES (197, 183);
INSERT INTO public.link_quaad_tag VALUES (198, 184);
INSERT INTO public.link_quaad_tag VALUES (199, 185);
INSERT INTO public.link_quaad_tag VALUES (200, 186);
INSERT INTO public.link_quaad_tag VALUES (201, 187);
INSERT INTO public.link_quaad_tag VALUES (202, 188);
INSERT INTO public.link_quaad_tag VALUES (203, 189);
INSERT INTO public.link_quaad_tag VALUES (204, 190);
INSERT INTO public.link_quaad_tag VALUES (205, 191);
INSERT INTO public.link_quaad_tag VALUES (206, 192);
INSERT INTO public.link_quaad_tag VALUES (207, 193);
INSERT INTO public.link_quaad_tag VALUES (208, 194);
INSERT INTO public.link_quaad_tag VALUES (209, 195);
INSERT INTO public.link_quaad_tag VALUES (210, 196);
INSERT INTO public.link_quaad_tag VALUES (211, 197);
INSERT INTO public.link_quaad_tag VALUES (212, 198);
INSERT INTO public.link_quaad_tag VALUES (213, 199);
INSERT INTO public.link_quaad_tag VALUES (214, 200);
INSERT INTO public.link_quaad_tag VALUES (215, 201);
INSERT INTO public.link_quaad_tag VALUES (216, 202);
INSERT INTO public.link_quaad_tag VALUES (217, 203);
INSERT INTO public.link_quaad_tag VALUES (218, 204);
INSERT INTO public.link_quaad_tag VALUES (219, 205);
INSERT INTO public.link_quaad_tag VALUES (220, 206);
INSERT INTO public.link_quaad_tag VALUES (221, 207);
INSERT INTO public.link_quaad_tag VALUES (222, 208);
INSERT INTO public.link_quaad_tag VALUES (223, 209);
INSERT INTO public.link_quaad_tag VALUES (224, 210);
INSERT INTO public.link_quaad_tag VALUES (225, 211);
INSERT INTO public.link_quaad_tag VALUES (226, 212);
INSERT INTO public.link_quaad_tag VALUES (227, 213);
INSERT INTO public.link_quaad_tag VALUES (229, 214);
INSERT INTO public.link_quaad_tag VALUES (230, 215);
INSERT INTO public.link_quaad_tag VALUES (231, 216);
INSERT INTO public.link_quaad_tag VALUES (232, 217);
INSERT INTO public.link_quaad_tag VALUES (233, 218);
INSERT INTO public.link_quaad_tag VALUES (234, 219);
INSERT INTO public.link_quaad_tag VALUES (235, 220);
INSERT INTO public.link_quaad_tag VALUES (236, 221);
INSERT INTO public.link_quaad_tag VALUES (237, 222);
INSERT INTO public.link_quaad_tag VALUES (238, 223);
INSERT INTO public.link_quaad_tag VALUES (239, 224);
INSERT INTO public.link_quaad_tag VALUES (240, 225);
INSERT INTO public.link_quaad_tag VALUES (242, 226);
INSERT INTO public.link_quaad_tag VALUES (243, 227);
INSERT INTO public.link_quaad_tag VALUES (244, 228);
INSERT INTO public.link_quaad_tag VALUES (245, 229);
INSERT INTO public.link_quaad_tag VALUES (246, 230);
INSERT INTO public.link_quaad_tag VALUES (247, 231);
INSERT INTO public.link_quaad_tag VALUES (248, 232);
INSERT INTO public.link_quaad_tag VALUES (249, 233);
INSERT INTO public.link_quaad_tag VALUES (250, 234);
INSERT INTO public.link_quaad_tag VALUES (251, 235);
INSERT INTO public.link_quaad_tag VALUES (252, 236);
INSERT INTO public.link_quaad_tag VALUES (253, 237);
INSERT INTO public.link_quaad_tag VALUES (120, 107);
INSERT INTO public.link_quaad_tag VALUES (121, 108);
INSERT INTO public.link_quaad_tag VALUES (122, 109);
INSERT INTO public.link_quaad_tag VALUES (123, 110);
INSERT INTO public.link_quaad_tag VALUES (124, 111);
INSERT INTO public.link_quaad_tag VALUES (125, 112);
INSERT INTO public.link_quaad_tag VALUES (126, 113);
INSERT INTO public.link_quaad_tag VALUES (127, 114);
INSERT INTO public.link_quaad_tag VALUES (128, 115);
INSERT INTO public.link_quaad_tag VALUES (129, 116);
INSERT INTO public.link_quaad_tag VALUES (130, 117);
INSERT INTO public.link_quaad_tag VALUES (131, 118);
INSERT INTO public.link_quaad_tag VALUES (132, 119);
INSERT INTO public.link_quaad_tag VALUES (134, 121);
INSERT INTO public.link_quaad_tag VALUES (135, 122);
INSERT INTO public.link_quaad_tag VALUES (136, 123);
INSERT INTO public.link_quaad_tag VALUES (137, 124);
INSERT INTO public.link_quaad_tag VALUES (138, 125);
INSERT INTO public.link_quaad_tag VALUES (139, 126);
INSERT INTO public.link_quaad_tag VALUES (140, 127);
INSERT INTO public.link_quaad_tag VALUES (141, 128);
INSERT INTO public.link_quaad_tag VALUES (142, 129);
INSERT INTO public.link_quaad_tag VALUES (143, 130);
INSERT INTO public.link_quaad_tag VALUES (144, 131);
INSERT INTO public.link_quaad_tag VALUES (145, 132);
INSERT INTO public.link_quaad_tag VALUES (146, 133);
INSERT INTO public.link_quaad_tag VALUES (147, 134);
INSERT INTO public.link_quaad_tag VALUES (148, 135);
INSERT INTO public.link_quaad_tag VALUES (149, 136);
INSERT INTO public.link_quaad_tag VALUES (150, 137);
INSERT INTO public.link_quaad_tag VALUES (151, 138);
INSERT INTO public.link_quaad_tag VALUES (152, 139);
INSERT INTO public.link_quaad_tag VALUES (154, 141);
INSERT INTO public.link_quaad_tag VALUES (155, 142);
INSERT INTO public.link_quaad_tag VALUES (156, 143);
INSERT INTO public.link_quaad_tag VALUES (157, 144);
INSERT INTO public.link_quaad_tag VALUES (158, 145);
INSERT INTO public.link_quaad_tag VALUES (159, 146);
INSERT INTO public.link_quaad_tag VALUES (160, 147);
INSERT INTO public.link_quaad_tag VALUES (161, 148);
INSERT INTO public.link_quaad_tag VALUES (162, 149);
INSERT INTO public.link_quaad_tag VALUES (163, 150);
INSERT INTO public.link_quaad_tag VALUES (164, 151);
INSERT INTO public.link_quaad_tag VALUES (165, 152);
INSERT INTO public.link_quaad_tag VALUES (166, 153);
INSERT INTO public.link_quaad_tag VALUES (167, 154);
INSERT INTO public.link_quaad_tag VALUES (168, 155);
INSERT INTO public.link_quaad_tag VALUES (169, 156);
INSERT INTO public.link_quaad_tag VALUES (170, 157);
INSERT INTO public.link_quaad_tag VALUES (171, 158);
INSERT INTO public.link_quaad_tag VALUES (172, 159);
INSERT INTO public.link_quaad_tag VALUES (173, 160);
INSERT INTO public.link_quaad_tag VALUES (174, 161);
INSERT INTO public.link_quaad_tag VALUES (175, 162);
INSERT INTO public.link_quaad_tag VALUES (176, 163);
INSERT INTO public.link_quaad_tag VALUES (177, 164);
INSERT INTO public.link_quaad_tag VALUES (178, 165);
INSERT INTO public.link_quaad_tag VALUES (179, 166);
INSERT INTO public.link_quaad_tag VALUES (180, 167);
INSERT INTO public.link_quaad_tag VALUES (181, 168);
INSERT INTO public.link_quaad_tag VALUES (182, 169);
INSERT INTO public.link_quaad_tag VALUES (187, 173);
INSERT INTO public.link_quaad_tag VALUES (186, 172);
INSERT INTO public.link_quaad_tag VALUES (185, 171);
INSERT INTO public.link_quaad_tag VALUES (184, 170);
INSERT INTO public.link_quaad_tag VALUES (254, 238);
INSERT INTO public.link_quaad_tag VALUES (255, 239);
INSERT INTO public.link_quaad_tag VALUES (256, 240);
INSERT INTO public.link_quaad_tag VALUES (257, 241);
INSERT INTO public.link_quaad_tag VALUES (258, 242);
INSERT INTO public.link_quaad_tag VALUES (260, 243);
INSERT INTO public.link_quaad_tag VALUES (261, 244);
INSERT INTO public.link_quaad_tag VALUES (262, 245);
INSERT INTO public.link_quaad_tag VALUES (263, 246);
INSERT INTO public.link_quaad_tag VALUES (265, 247);
INSERT INTO public.link_quaad_tag VALUES (266, 248);
INSERT INTO public.link_quaad_tag VALUES (267, 249);
INSERT INTO public.link_quaad_tag VALUES (268, 250);
INSERT INTO public.link_quaad_tag VALUES (269, 251);
INSERT INTO public.link_quaad_tag VALUES (270, 252);
INSERT INTO public.link_quaad_tag VALUES (273, 253);
INSERT INTO public.link_quaad_tag VALUES (275, 254);
INSERT INTO public.link_quaad_tag VALUES (279, 255);
INSERT INTO public.link_quaad_tag VALUES (280, 256);
INSERT INTO public.link_quaad_tag VALUES (281, 257);
INSERT INTO public.link_quaad_tag VALUES (283, 258);
INSERT INTO public.link_quaad_tag VALUES (284, 259);
INSERT INTO public.link_quaad_tag VALUES (285, 260);
INSERT INTO public.link_quaad_tag VALUES (286, 261);
INSERT INTO public.link_quaad_tag VALUES (287, 262);
INSERT INTO public.link_quaad_tag VALUES (288, 263);
INSERT INTO public.link_quaad_tag VALUES (289, 264);
INSERT INTO public.link_quaad_tag VALUES (293, 266);
INSERT INTO public.link_quaad_tag VALUES (298, 270);
INSERT INTO public.link_quaad_tag VALUES (300, 271);
INSERT INTO public.link_quaad_tag VALUES (301, 272);
INSERT INTO public.link_quaad_tag VALUES (304, 273);
INSERT INTO public.link_quaad_tag VALUES (305, 274);
INSERT INTO public.link_quaad_tag VALUES (306, 275);
INSERT INTO public.link_quaad_tag VALUES (307, 276);
INSERT INTO public.link_quaad_tag VALUES (308, 277);
INSERT INTO public.link_quaad_tag VALUES (309, 278);
INSERT INTO public.link_quaad_tag VALUES (310, 279);
INSERT INTO public.link_quaad_tag VALUES (311, 280);
INSERT INTO public.link_quaad_tag VALUES (312, 281);
INSERT INTO public.link_quaad_tag VALUES (313, 282);
INSERT INTO public.link_quaad_tag VALUES (315, 283);
INSERT INTO public.link_quaad_tag VALUES (316, 284);
INSERT INTO public.link_quaad_tag VALUES (317, 285);
INSERT INTO public.link_quaad_tag VALUES (318, 286);
INSERT INTO public.link_quaad_tag VALUES (319, 287);
INSERT INTO public.link_quaad_tag VALUES (321, 288);
INSERT INTO public.link_quaad_tag VALUES (324, 289);
INSERT INTO public.link_quaad_tag VALUES (327, 290);
INSERT INTO public.link_quaad_tag VALUES (328, 291);
INSERT INTO public.link_quaad_tag VALUES (330, 292);
INSERT INTO public.link_quaad_tag VALUES (333, 293);
INSERT INTO public.link_quaad_tag VALUES (334, 294);
INSERT INTO public.link_quaad_tag VALUES (335, 295);
INSERT INTO public.link_quaad_tag VALUES (291, 265);
INSERT INTO public.link_quaad_tag VALUES (294, 267);
INSERT INTO public.link_quaad_tag VALUES (295, 268);
INSERT INTO public.link_quaad_tag VALUES (296, 269);


--
-- TOC entry 5674 (class 0 OID 25309)
-- Dependencies: 270
-- Data for Name: link_scope_view; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.link_scope_view VALUES ('device', 'VIEW_DEVICE');
INSERT INTO public.link_scope_view VALUES ('staff', 'VIEW_STAFF');
INSERT INTO public.link_scope_view VALUES ('staff_role', 'VIEW_STAFFROLE');
INSERT INTO public.link_scope_view VALUES ('examlist', 'VIEW_EXAMLIST');
INSERT INTO public.link_scope_view VALUES ('legaldocument', 'VIEW_LEGALDOCUMENT');
INSERT INTO public.link_scope_view VALUES ('institution', 'VIEW_INSTITUTIONDOCUMENT');
INSERT INTO public.link_scope_view VALUES ('department', 'VIEW_INSTITUTIONDOCUMENT');
INSERT INTO public.link_scope_view VALUES ('staff_member', 'VIEW_STAFF');
INSERT INTO public.link_scope_view VALUES ('staff_formation', 'VIEW_STAFF');


--
-- TOC entry 5675 (class 0 OID 25314)
-- Dependencies: 271
-- Data for Name: login_role; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.login_role VALUES (0, 'admin', false);
INSERT INTO public.login_role VALUES (2, 'User 2', true);
INSERT INTO public.login_role VALUES (3, 'Administrateur', false);
INSERT INTO public.login_role VALUES (4, 'New login role', false);
INSERT INTO public.login_role VALUES (5, '', true);
INSERT INTO public.login_role VALUES (1, 'Accès en lecture', false);


--
-- TOC entry 5677 (class 0 OID 25321)
-- Dependencies: 273
-- Data for Name: login_role_permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.login_role_permission VALUES (1, 'VIEW', 'VIEW_INSTITUTION', 'View institution settings', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (2, 'VIEW', 'VIEW_STAFFROLE', 'View staff role settings', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (3, 'VIEW', 'VIEW_LOGINROLE', 'View login role settings', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (4, 'VIEW', 'VIEW_STAFFMEMBER', 'View staff member settings', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (5, 'VIEW', 'VIEW_TAG', 'View tag settings', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (6, 'VIEW', 'VIEW_WARNING', 'View warning settings', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (8, 'VIEW', 'VIEW_AUDIT', 'View audit frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (9, 'VIEW', 'VIEW_PROCEDURE', 'View procedure frame', true, true, false, true, 0);
INSERT INTO public.login_role_permission VALUES (10, 'VIEW', 'VIEW_DEVICE', 'View device frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (11, 'VIEW', 'VIEW_EXAMLIST', 'View exam list frame', true, true, false, true, 0);
INSERT INTO public.login_role_permission VALUES (12, 'VIEW', 'VIEW_STAFF', 'View staff frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (13, 'VIEW', 'VIEW_DOSIMETRY', 'View dosimetry frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (15, 'VIEW', 'VIEW_SCHEDULEDTASK', 'View scheduled task frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (16, 'VIEW', 'VIEW_INCIDENTREPORTING', 'View incident reporting frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (22, 'VIEW', 'VIEW_STAFF', 'View staff frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (25, 'VIEW', 'VIEW_STAFFMEMBER', 'View staff member settings', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (20, 'VIEW', 'VIEW_STAFFROLE', 'View staff role settings', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (19, 'VIEW', 'VIEW_TAG', 'View tag settings', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (29, 'VIEW', 'VIEW_WARNING', 'View warning settings', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (14, 'VIEW', 'VIEW_LEGALDOCUMENT', 'View legal document frame', true, true, false, true, 0);
INSERT INTO public.login_role_permission VALUES (23, 'VIEW', 'VIEW_INSTITUTION', 'View institution settings', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (40, 'VIEW', 'VIEW_AUDIT', 'View audit frame', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (48, 'VIEW', 'VIEW_LEGALDOCUMENT', 'View legal document frame', true, true, false, true, 2);
INSERT INTO public.login_role_permission VALUES (42, 'VIEW', 'VIEW_DEVICE', 'View device frame', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (50, 'VIEW', 'VIEW_INSTITUTIONDOCUMENT', 'View institution document frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (45, 'VIEW', 'VIEW_DOSIMETRY', 'View dosimetry frame', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (43, 'VIEW', 'VIEW_EXAMLIST', 'View exam list frame', true, false, false, true, 2);
INSERT INTO public.login_role_permission VALUES (47, 'VIEW', 'VIEW_INCIDENTREPORTING', 'View incident reporting frame', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (33, 'VIEW', 'VIEW_INSTITUTION', 'View institution settings', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (54, 'VIEW', 'VIEW_INSTITUTIONDOCUMENT', 'View institution document frame', true, true, false, false, 2);
INSERT INTO public.login_role_permission VALUES (35, 'VIEW', 'VIEW_LOGINROLE', 'View login role settings', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (46, 'VIEW', 'VIEW_SCHEDULEDTASK', 'View scheduled task frame', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (44, 'VIEW', 'VIEW_STAFF', 'View staff frame', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (36, 'VIEW', 'VIEW_STAFFMEMBER', 'View staff member settings', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (34, 'VIEW', 'VIEW_STAFFROLE', 'View staff role settings', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (37, 'VIEW', 'VIEW_TAG', 'View tag settings', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (38, 'VIEW', 'VIEW_WARNING', 'View warning settings', true, false, false, false, 2);
INSERT INTO public.login_role_permission VALUES (41, 'VIEW', 'VIEW_PROCEDURE', 'View procedure frame', true, false, true, true, 2);
INSERT INTO public.login_role_permission VALUES (55, 'VIEW', 'VIEW_EXAMIDENT', 'View the exam link frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (56, 'VIEW', 'VIEW_EXAMLINK', 'View the exam link frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (57, 'VIEW', 'VIEW_EXAMLINK', 'View the exam link frame', true, true, false, false, 2);
INSERT INTO public.login_role_permission VALUES (58, 'VIEW', 'VIEW_EXAMIDENT', 'View the exam link frame', true, true, false, false, 2);
INSERT INTO public.login_role_permission VALUES (61, 'VIEW', 'VIEW_STATISTIC', 'View the statistic frame', true, true, false, false, 0);
INSERT INTO public.login_role_permission VALUES (63, 'VIEW', 'VIEW_STATISTIC', 'View the statistic frame', true, true, false, false, 2);
INSERT INTO public.login_role_permission VALUES (64, 'VIEW', 'VIEW_INSTITUTION', 'View institution settings', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (65, 'VIEW', 'VIEW_STAFFROLE', 'View staff role settings', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (66, 'VIEW', 'VIEW_LOGINROLE', 'View login role settings', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (67, 'VIEW', 'VIEW_STAFFMEMBER', 'View staff member settings', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (68, 'VIEW', 'VIEW_TAG', 'View tag settings', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (69, 'VIEW', 'VIEW_WARNING', 'View warning settings', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (71, 'VIEW', 'VIEW_AUDIT', 'View audit frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (73, 'VIEW', 'VIEW_DEVICE', 'View device frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (75, 'VIEW', 'VIEW_STAFF', 'View staff frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (76, 'VIEW', 'VIEW_DOSIMETRY', 'View dosimetry frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (77, 'VIEW', 'VIEW_SCHEDULEDTASK', 'View scheduled task frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (78, 'VIEW', 'VIEW_INCIDENTREPORTING', 'View incident reporting frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (80, 'VIEW', 'VIEW_INSTITUTIONDOCUMENT', 'View institution document frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (81, 'VIEW', 'VIEW_EXAMIDENT', 'View the exam link frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (82, 'VIEW', 'VIEW_EXAMLINK', 'View the exam link frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (83, 'VIEW', 'VIEW_STATISTIC', 'View the statistic frame', true, true, false, false, 3);
INSERT INTO public.login_role_permission VALUES (60, 'VIEW', 'VIEW_EXAMLINK', 'View the exam link frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (53, 'VIEW', 'VIEW_INSTITUTIONDOCUMENT', 'View institution document frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (59, 'VIEW', 'VIEW_EXAMIDENT', 'View the exam link frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (62, 'VIEW', 'VIEW_STATISTIC', 'View the statistic frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (28, 'VIEW', 'VIEW_DOSIMETRY', 'View dosimetry frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (31, 'VIEW', 'VIEW_DEVICE', 'View device frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (32, 'VIEW', 'VIEW_EXAMLIST', 'View exam list frame', true, false, true, true, 1);
INSERT INTO public.login_role_permission VALUES (21, 'VIEW', 'VIEW_AUDIT', 'View audit frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (84, 'VIEW', 'VIEW_INSTITUTION', 'View institution settings', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (85, 'VIEW', 'VIEW_STAFFROLE', 'View staff role settings', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (86, 'VIEW', 'VIEW_LOGINROLE', 'View login role settings', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (87, 'VIEW', 'VIEW_STAFFMEMBER', 'View staff member settings', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (88, 'VIEW', 'VIEW_TAG', 'View tag settings', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (89, 'VIEW', 'VIEW_WARNING', 'View warning settings', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (91, 'VIEW', 'VIEW_AUDIT', 'View audit frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (95, 'VIEW', 'VIEW_STAFF', 'View staff frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (27, 'VIEW', 'VIEW_SCHEDULEDTASK', 'View scheduled task frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (18, 'VIEW', 'VIEW_LOGINROLE', 'View login role settings', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (17, 'VIEW', 'VIEW_PROCEDURE', 'View procedure frame', true, false, true, true, 1);
INSERT INTO public.login_role_permission VALUES (72, 'VIEW', 'VIEW_PROCEDURE', 'View procedure frame', true, true, true, true, 3);
INSERT INTO public.login_role_permission VALUES (94, 'VIEW', 'VIEW_EXAMLIST', 'View exam list frame', true, true, true, true, 4);
INSERT INTO public.login_role_permission VALUES (92, 'VIEW', 'VIEW_PROCEDURE', 'View procedure frame', true, true, true, true, 4);
INSERT INTO public.login_role_permission VALUES (96, 'VIEW', 'VIEW_DOSIMETRY', 'View dosimetry frame', true, false, false, false, 4);
INSERT INTO public.login_role_permission VALUES (93, 'VIEW', 'VIEW_DEVICE', 'View device frame', true, false, false, false, 4);
INSERT INTO public.login_role_permission VALUES (97, 'VIEW', 'VIEW_SCHEDULEDTASK', 'View scheduled task frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (74, 'VIEW', 'VIEW_EXAMLIST', 'View exam list frame', true, true, true, true, 3);
INSERT INTO public.login_role_permission VALUES (79, 'VIEW', 'VIEW_LEGALDOCUMENT', 'View legal document frame', true, true, true, true, 3);
INSERT INTO public.login_role_permission VALUES (7, 'VIEW', 'VIEW_DASHBOARD', 'View dashboard frame', true, true, false, true, 0);
INSERT INTO public.login_role_permission VALUES (39, 'VIEW', 'VIEW_DASHBOARD', 'View dashboard frame', true, false, false, true, 2);
INSERT INTO public.login_role_permission VALUES (70, 'VIEW', 'VIEW_DASHBOARD', 'View dashboard frame', true, true, false, true, 3);
INSERT INTO public.login_role_permission VALUES (90, 'VIEW', 'VIEW_DASHBOARD', 'View dashboard frame', true, true, false, true, 4);
INSERT INTO public.login_role_permission VALUES (30, 'VIEW', 'VIEW_DASHBOARD', 'View dashboard frame', true, false, true, true, 1);
INSERT INTO public.login_role_permission VALUES (98, 'VIEW', 'VIEW_INCIDENTREPORTING', 'View incident reporting frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (100, 'VIEW', 'VIEW_INSTITUTIONDOCUMENT', 'View institution document frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (101, 'VIEW', 'VIEW_EXAMIDENT', 'View the exam link frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (102, 'VIEW', 'VIEW_EXAMLINK', 'View the exam link frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (103, 'VIEW', 'VIEW_STATISTIC', 'View the statistic frame', true, true, false, false, 4);
INSERT INTO public.login_role_permission VALUES (99, 'VIEW', 'VIEW_LEGALDOCUMENT', 'View legal document frame', true, true, true, true, 4);
INSERT INTO public.login_role_permission VALUES (104, 'VIEW', 'VIEW_INSTITUTION', 'View institution settings', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (105, 'VIEW', 'VIEW_STAFFROLE', 'View staff role settings', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (106, 'VIEW', 'VIEW_LOGINROLE', 'View login role settings', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (107, 'VIEW', 'VIEW_STAFFMEMBER', 'View staff member settings', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (108, 'VIEW', 'VIEW_TAG', 'View tag settings', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (109, 'VIEW', 'VIEW_WARNING', 'View warning settings', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (111, 'VIEW', 'VIEW_AUDIT', 'View audit frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (112, 'VIEW', 'VIEW_PROCEDURE', 'View procedure frame', true, true, false, true, 5);
INSERT INTO public.login_role_permission VALUES (113, 'VIEW', 'VIEW_DEVICE', 'View device frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (114, 'VIEW', 'VIEW_EXAMLIST', 'View exam list frame', true, true, false, true, 5);
INSERT INTO public.login_role_permission VALUES (115, 'VIEW', 'VIEW_STAFF', 'View staff frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (116, 'VIEW', 'VIEW_DOSIMETRY', 'View dosimetry frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (117, 'VIEW', 'VIEW_SCHEDULEDTASK', 'View scheduled task frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (118, 'VIEW', 'VIEW_INCIDENTREPORTING', 'View incident reporting frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (119, 'VIEW', 'VIEW_LEGALDOCUMENT', 'View legal document frame', true, true, false, true, 5);
INSERT INTO public.login_role_permission VALUES (120, 'VIEW', 'VIEW_INSTITUTIONDOCUMENT', 'View institution document frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (121, 'VIEW', 'VIEW_EXAMIDENT', 'View the exam link frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (122, 'VIEW', 'VIEW_EXAMLINK', 'View the exam link frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (123, 'VIEW', 'VIEW_STATISTIC', 'View the statistic frame', true, true, false, false, 5);
INSERT INTO public.login_role_permission VALUES (24, 'VIEW', 'VIEW_LEGALDOCUMENT', 'View legal document frame', true, false, true, true, 1);
INSERT INTO public.login_role_permission VALUES (26, 'VIEW', 'VIEW_INCIDENTREPORTING', 'View incident reporting frame', true, false, false, false, 1);
INSERT INTO public.login_role_permission VALUES (110, 'VIEW', 'VIEW_DASHBOARD', 'View dashboard frame', true, true, false, true, 5);


--
-- TOC entry 5679 (class 0 OID 25333)
-- Dependencies: 275
-- Data for Name: procedure; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.procedure VALUES (9, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (10, 'Test', 'Test', 'Nieuwe procedure', '', true, 1);
INSERT INTO public.procedure VALUES (11, 'Test', 'Test', 'Nieuwe procedure', '', true, 1);
INSERT INTO public.procedure VALUES (12, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (14, 'New procedure', 'ggdfg', 'Nieuwe procedure', '', true, 1);
INSERT INTO public.procedure VALUES (13, 'New procedure', 'test', 'Nieuwe procedure', '', true, 1);
INSERT INTO public.procedure VALUES (15, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (17, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (18, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (20, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (19, '', 'Nouvelle procédure', '', 'aaa', true, 4);
INSERT INTO public.procedure VALUES (16, '', 'Procédure test', '', 'Test.', true, 2);
INSERT INTO public.procedure VALUES (7, '', 'PQ-005 Incidents', '', '', true, 7);
INSERT INTO public.procedure VALUES (6, '', 'PQ-002 Radioprotection - dosimétrie', '', '', false, 4);
INSERT INTO public.procedure VALUES (5, '', 'PQ-003 Ressources humaines', '', '', false, 2);
INSERT INTO public.procedure VALUES (8, '', 'PQ-004 Audit', '', 'Audit interne, externe, auto-évaluation', false, 5);
INSERT INTO public.procedure VALUES (3, '', 'PQ-006 Examen', '', 'Gestion des examens', false, 6);
INSERT INTO public.procedure VALUES (2, '', 'PQ-007 Plateau technique', '', 'Installations matériel', false, 3);
INSERT INTO public.procedure VALUES (21, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (23, 'New procedure', 'Nouvelle procédure', 'Nieuwe procedure', NULL, true, NULL);
INSERT INTO public.procedure VALUES (25, '', 'Nouvelle procédure', '', '', true, 7);
INSERT INTO public.procedure VALUES (27, '', 'Test 001', '', '', false, 6);
INSERT INTO public.procedure VALUES (26, '', 'Nouvelle procédure', '', '', true, 2);
INSERT INTO public.procedure VALUES (28, '', 'Gestion documentaire', '', '', false, 1);
INSERT INTO public.procedure VALUES (29, '', 'Radioprotection', '', '', false, 4);
INSERT INTO public.procedure VALUES (33, '', 'Nouvelle procédure    HHHHHHHHHHHH', '', '', true, 1);
INSERT INTO public.procedure VALUES (31, '', 'Nouvelle procédure  FFFFFFF', '', '', true, 3);
INSERT INTO public.procedure VALUES (34, '', 'Nouvelle procédure IIIIIIIIIIIIIIII', '', '', true, 7);
INSERT INTO public.procedure VALUES (35, '', 'Nouvelle procédure JJJJJJJJJJJJJJ', '', '', true, 1);
INSERT INTO public.procedure VALUES (32, '', 'Nouvelle procédure GGGG', '', '', true, 3);
INSERT INTO public.procedure VALUES (30, '', 'Nouvelle procédure CCCCCCCC', '', '', true, 1);
INSERT INTO public.procedure VALUES (24, '', 'Nouvelle procédure', '', '', true, 4);
INSERT INTO public.procedure VALUES (36, '', 'Test 002', '', '', false, 1);
INSERT INTO public.procedure VALUES (37, '', 'Test 003', '', '', false, 1);
INSERT INTO public.procedure VALUES (38, '', 'Test 004', '', '', false, 3);
INSERT INTO public.procedure VALUES (39, '', 'Test 005', '', '', false, 6);
INSERT INTO public.procedure VALUES (40, '', 'Test 006', '', '', false, 2);
INSERT INTO public.procedure VALUES (41, '', 'Test 007', '', '', false, 7);
INSERT INTO public.procedure VALUES (42, '', 'Test 008', '', '', false, 4);
INSERT INTO public.procedure VALUES (1, '', 'PQ-001 Gestion documentaire', '', '', false, 1);
INSERT INTO public.procedure VALUES (22, '', 'PQ-005 Incident', '', '', false, 7);
INSERT INTO public.procedure VALUES (43, '', 'Test 009', '', '', true, 1);


--
-- TOC entry 5681 (class 0 OID 25340)
-- Dependencies: 277
-- Data for Name: quaad_description; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.quaad_description VALUES (2, 4, 'FR', '<b>L''établissement dispose:<br>



• d''une autorisation de création et d''exploitation couvrant le parc radiologique au sein de l''établissement;</b><i style="color: #999999;"><br>



• d''un PV de réception favorable pour les installations, avant la mise en service des appareils;



<br>• d''un service de contrôle physique (interne ou externe).



</i>', 'Autorisation de création et d''exploitation');
INSERT INTO public.quaad_description VALUES (1, 1, 'FR', '1. Installation et appareils', 'Installation et appareils');
INSERT INTO public.quaad_description VALUES (3, 5, 'FR', '<b>L''établissement dispose:</b><br><i style="color: #999999;">



• d''une autorisation de création et d''exploitation couvrant le parc radiologique au sein de l''établissement;</b></i><br><b>



• d''un PV de réception favorable pour les installations, avant la mise en service des appareils;</b>



<br><i style="color: #999999;">• d''un service de contrôle physique (interne ou externe).



</i>', 'PV de réception avant mise en service');
INSERT INTO public.quaad_description VALUES (4, 6, 'FR', '<b>L''établissement dispose:</b><br><i style="color: #999999;">



• d''une autorisation de création et d''exploitation couvrant le parc radiologique au sein de l''établissement;<br>



• d''un PV de réception favorable pour les installations, avant la mise en service des appareils;</i><b>



<br><b>• d''un service de contrôle physique (interne ou externe).</b>



', 'Service de contrôle physique');
INSERT INTO public.quaad_description VALUES (5, 7, 'FR', 'Tous les appareils sont <b>marqués CE.</b>', 'Marquage CE appareil');
INSERT INTO public.quaad_description VALUES (6, 8, 'FR', 'Tous les appareils à rayonnement ionisant ont, avant la première mise en service, subi avec succès un <b>test d''acceptation</b> réalisé par un expert agréé en radiophysique médicale (domaine de radiologie) agréé par l''AFCN.', 'Test d''acceptation');
INSERT INTO public.quaad_description VALUES (7, 9, 'FR', '<b>Avant la première mise en service d''un appareil à rayonnement ionisant,</b> des valeurs de base <b>qui serviront de valeurs de référence pour les contrôles qualité ultérieurs</b> sont mesurées.', 'Valeurs de référence');
INSERT INTO public.quaad_description VALUES (8, 10, 'FR', 'La qualité des appareils à rayonnement ionisant continue à faire l''objet d''un suivi après leur mise en service, au moins une fois par an, dans le cadre de contrôles de qualité périodiques effectués par un expert en radiophysique médicale agréé par l''AFCN (domaine de radiologie). 

Si la qualité constatée est insuffisante, des actions (correctives) sont prises.', 'Contrôle qualité périodique');
INSERT INTO public.quaad_description VALUES (9, 11, 'FR', '<b>Tous les appareils à rayonnement ionisant (à l''exception des appareils de radiographie dentaire intra-buccal et des appareils de mesure de la densité osseuse) sont équipés d''un système approprié permettant de déterminer la dose reçue par le patient au cours de la procédure radiologique (par exemple, système de mesure du PDS (Produit Dose Surface) ou indicateur de la dose intégré dans l''appareil). </b><br>

<i style="color: #999999;">Tous les appareils de fluoroscopie sont munis d''un dispositif d’affichage du débit de dose.</i>', 'Présence d''un système indicateur de dose');
INSERT INTO public.quaad_description VALUES (11, 13, 'FR', 'Tous les appareils d’imagerie médicale considérés <b>comme des appareils médicaux lourds</b> sont notifiés au SPF Santé publique, Sécurité de la Chaîne alimentaire et Environnement conformément à la procédure décrite sur le site web du SPF SPSCAE.<br>

Cet enregistrement est obligatoire pour les types d’appareils suivants :<br>

    • CT<br>

    • PET, y compris les PET-CT et PET-IRM<br>

    • SPECT-CT<br>

    • IRM<br>', 'Notification appareil médical lourd');
INSERT INTO public.quaad_description VALUES (12, 14, 'FR', '2. Demande', 'Demande');
INSERT INTO public.quaad_description VALUES (13, 15, 'FR', 'Les <b>recommandations de radiologie</b> (notamment publiées sur le site web du SPF SPSCAE) sont rapidement disponibles (en version papier ou électronique) dans le service.', 'Recommandations de radiologie');
INSERT INTO public.quaad_description VALUES (14, 16, 'FR', 'Il est vérifié que <b>le formulaire de demande</b> au contenu standardisé est correct et complet. Dans le cas contraire, contact est pris avec le référent.', 'Vérification du formulaire de demande');
INSERT INTO public.quaad_description VALUES (10, 12, 'FR', '<i style="color: #999999;">Tous les appareils à rayonnement ionisant (à l''exception des appareils de radiographie dentaire intra-buccal et des appareils de mesure de la densité osseuse) sont équipés d''un système approprié permettant de déterminer la dose reçue par le patient au cours de la procédure radiologique (par exemple, système de mesure du PDS (Produit Dose Surface) ou indicateur de la dose intégré dans l''appareil). <br>

</i><b>Tous les appareils de fluoroscopie sont munis d''un dispositif d’affichage du débit de dose.</b>', 'Affichage du débit de dose (Fluoroscopie)');
INSERT INTO public.quaad_description VALUES (15, 17, 'FR', 'À la lumière de la demande de diagnostic et sur la base du contexte clinique, un médecin spécialiste en radiodiagnostic effectue l''<b>examen le plus approprié</b>, éventuellement en <b>remplaçant</b> un ou plusieurs examens proposés par le référent par un autre examen. Toute substitution est expliquée dans le protocole.<br>

Lors de la détermination de l''examen le plus indiqué, il est tenu compte des examens pertinents déjà effectués dont on a connaissance.', 'Réalisation de l''examen le plus approprié');
INSERT INTO public.quaad_description VALUES (16, 18, 'FR', 'Toute exposition aux rayonnements ionisants est <b>justifiée</b>, en tenant compte de l''efficacité ainsi que des avantages et des risques inhérents aux autres techniques disponibles qui ont le même objectif, mais entraînent une exposition moindre ou nulle aux rayonnements ionisants.', 'Justification de l''utilisation de rayonnement ionisant');
INSERT INTO public.quaad_description VALUES (18, 19, 'FR', '3. Préparation et soins de suivi', 'Préparation et soins de suivi');
INSERT INTO public.quaad_description VALUES (19, 20, 'FR', 'Contrôle systématique de l''<b>identité du patient</b>', 'Contrôle d''identité du patient');
INSERT INTO public.quaad_description VALUES (20, 21, 'FR', '<b>Préalablement à l''examen</b>, les conditions suivantes sont recherchées de manière systématique:<br>

    • <b>conditions qui peuvent rendre l''examen radiologique potentiellement dangereux pour le patient</b>, comme l''hypersensibilité aux produits de contraste, les allergies, l''insuffisance rénale, les matériaux incompatibles avec une IRM, l''usage d''anticoagulants, l''état de grossesse, etc.</br>

    • <b>conditions qui ne permettent pas de garantir un examen radiologique sûr et sans risque</b>, comme l''âge, les infections (p. ex. germes multirésistants), une mobilité réduite, la sédation, l''anesthésie, etc.', 'Recherche systématique de contre indications');
INSERT INTO public.quaad_description VALUES (21, 22, 'FR', 'Avant l''examen, le patient est <b>informé</b> :<br>

    • de la préparation de l''examen;<br>

    • des avantages et des inconvénients de l''examen;<br>

    • des risques liés aux produits de contraste;<br>

    • des risques liés à l''irradiation.<br>

La méthode de transfert de l''information (orale, brochures, ...) est déterminée en fonction du type d’examen.', 'Informations données au patient avant examen');
INSERT INTO public.quaad_description VALUES (22, 23, 'FR', 'Les prestataires de soins et le patient sont informés des <b>soins de suivi nécessaires liés à l''examen et/ou au traitement </b>(par exemple : soins de suivi en cas d’angio, examens/traitements interventionnels, …)', 'Information de soins de suivi nécessaires');
INSERT INTO public.quaad_description VALUES (23, 24, 'FR', 'Le <b>patient</b> a l''occasion <b>de poser des questions </b>avant l''examen <b>et/ou de refuser l''examen</b>.', 'Questions et refus d''examen');
INSERT INTO public.quaad_description VALUES (25, 25, 'FR', 'Le service prévoit des coordonnées (numéro de téléphone, adresse mail,…) auprès duquel <b>les patients</b> peuvent demander des <b>informations.</b>', 'Disponibilité des coordonnées');
INSERT INTO public.quaad_description VALUES (26, 26, 'FR', '4. Techniques d''examen', 'Techniques d''examen');
INSERT INTO public.quaad_description VALUES (27, 27, 'FR', 'Tous les examens sont réalisés en application de et dans <b>le respect des directives et procédures</b> du service d''hygiène hospitalière ou d''un service similaire pour la prévention des infections et les procédures stériles (politique relative aux infections, à l''hygiène et à la propreté, aux déchets et aux objets tranchants, techniques aseptiques et stériles, stérilisation …).', 'Respect des directives et procédures');
INSERT INTO public.quaad_description VALUES (34, 34, 'FR', 'L''introduction de nouvelles techniques/technologies est soutenue par des informations et un <b>training</b> adéquat pour les futurs utilisateurs.', 'Training');
INSERT INTO public.quaad_description VALUES (28, 28, 'FR', 'Tous les examens sont <b>optimisés en termes de qualité d''image clinique pertinente</b>, en collaboration avec l''ensemble des intervenants concernés (notamment le radiologue, le technologue en imagerie médicale, l''infirmier et assimilé, et l''expert agréé en radiophysique médicale).<br>

Tous les examens de radiographie sont du reste optimisés en termes de dose selon le <b>principe ALARA</b>. ', 'Optimisation de qualité d''image clinique pertinente');
INSERT INTO public.quaad_description VALUES (29, 29, 'FR', 'Lors de chaque examen réalisé, les données suivantes sont <b>enregistrées</b> (sous forme électronique): <br>

    a. les données du patient;<br>

    b. l''exécutant (médecins, infirmiers, technologues en imagerie médicale ou assimilés);<br>

    c. les données d''identification de l''appareil utilisé;<br>

    d. le produit de contraste et les médicaments administrés éventuels (nature, site d''injection, débit, quantité) si divergence par rapport à la procédure standard;<br>

    e. les limitations éventuels, les effets secondaires, la sédation, …;<br>

    f. la dose ou les paramètres nécessaires à l''évaluation rétrospective de la dose du patient;<br>

    g. les doses individuelles pour les examens pédiatriques et les examens réalisés dans la région pelvienne chez des femmes en âge de procréer.', 'Enregistrement de données obligatoire');
INSERT INTO public.quaad_description VALUES (30, 30, 'FR', '5. Personnel', 'Personnel');
INSERT INTO public.quaad_description VALUES (35, 35, 'FR', 'Le personnel exposé à des rayonnements ionisants bénéficie, quel que soit son statut, y compris les indépendants, des <b>mesures</b> nécessaires de <b>protection</b> collective et individuelle.', 'Mesures de protection contres les rayonnements ionisants');
INSERT INTO public.quaad_description VALUES (36, 36, 'FR', 'Le personnel exposé à des rayonnements ionisants porte un <b>dosimètre approprié</b> à hauteur de la poitrine.', 'Port du dosimètre');
INSERT INTO public.quaad_description VALUES (43, 43, 'FR', 'Dans le rapport, les points suivants <b>sont mentionnés:</b><br>

    a. les informations cliniques et les questions soumises par la personne référente;<br>

    b. la partie du corps examinée et la latéralité éventuelle;<br>

    c. la procédure de l''examen;<br>

    d. la motivation pour une éventuelle substitution;<br>

    e. les observations (y compris les conclusions secondaires non pertinentes par rapport au problème clinique);<br>

    f. la comparaison avec d’éventuels examens précédents ou examens complémentaires;<br>

    g. la conclusion (pour autant qu’elle soit complémentaire aux conclusions mentionnées au point e.) et un avis quant à un éventuel suivi (examens, périodicité, …);<br>

    h. les effets secondaires éventuels, incidents, etc.;<br>

    i. la signature (électronique) du médecin auteur du rapport.', 'Mentions obligatoires');
INSERT INTO public.quaad_description VALUES (31, 31, 'FR', 'Tous les intervenants concernés (médecins, technologues en imagerie médicale, infirmiers, assimilés, experts en radiophysique médicale,...) sont titulaires des<b> diplômes</b> adéquats, des <b>agréments</b>, des <b>autorisations</b>, des <b>visas</b>, etc. en vue de l''exercice de leur profession respective.', 'Diplômes, Agréments, autorisations');
INSERT INTO public.quaad_description VALUES (32, 32, 'FR', 'Tous les membres du personnel garantissent <b>la qualité et la sécurité</b> des examens/traitements d''imagerie médicale dans le respect de la vie privée du patient.', 'Garantie qualité et sécurité des examens');
INSERT INTO public.quaad_description VALUES (33, 33, 'FR', 'Tous les membres du personnel suivent une <b>formation continue</b>. Le contenu, la durée et la périodicité de la formation continue, pour les différentes professions agréées, sont déterminées par la loi et la réglementation en vigueur. Le contenu de l''activité de formation ou du programme suivi(e) contribue à la professionnalisation des compétences et des missions des membres du personnel et à la promotion d''un exercice professionnel de qualité.', 'Formation continue');
INSERT INTO public.quaad_description VALUES (37, 37, 'FR', 'Lorsque le service chargé du contrôle physique constate la présence d''un <b>risque accru</b> de dépassement des limites de dose, l''intervenant porte un ou plusieurs <b>dosimètre(s) supplémentaire(s).</b>', 'Dosimètre supplémentaire en cas de risque accru');
INSERT INTO public.quaad_description VALUES (38, 38, 'FR', 'Le personnel exposé à des rayonnements ionisants est placé sous la <b>surveillance médicale</b> d''un médecin du travail agréé à cet effet par l''AFCN.', 'Surveillance d''un médecin du travail');
INSERT INTO public.quaad_description VALUES (39, 39, 'FR', '6. Etablissement du rapport', 'Etablissement du rapport');
INSERT INTO public.quaad_description VALUES (40, 40, 'FR', 'Le rapport s’effectue dans des <b>conditions optimales de présentation des images </b>(tant dans le service que dans le cadre de la téléradiologie).', 'Condition optimales de présentation des images');
INSERT INTO public.quaad_description VALUES (41, 41, 'FR', 'Pour le rapport, <b>les images et les comptes rendus disponibles d''éventuels examens précédents sont consultés.</b>', 'Prise en compte de l''historique du patient');
INSERT INTO public.quaad_description VALUES (42, 42, 'FR', 'Le rapport radiologique <b>identifie correctement</b><br>

    a. le patient;<br>

    b. la date de l''examen;<br>

    c. le référent;<br>

    d. le médecin auteur du rapport.', 'Identification de l''examen et du patient');
INSERT INTO public.quaad_description VALUES (44, 44, 'FR', 'Une concertation a lieu sans délai avec le référent (ou un collègue du référent) au sujet des <b>conclusions susceptibles d''avoir des répercussions thérapeutiques immédiates</b>. Le nom du référent (ou du collègue du référent), la date et l''heure de la concertation sont notifiés.

', 'Concertation avec le référent');
INSERT INTO public.quaad_description VALUES (46, 45, 'FR', '7. Notification d''incidents et d''accidents', 'Notification d ''incidents et d''accidents');
INSERT INTO public.quaad_description VALUES (47, 46, 'FR', 'Il existe une politique, directive ou procédure spécifique en matière de notification des <b>incidents de sécurité</b>, avec déclaration (centralisée), enregistrement, analyse, actions et feed-back.', 'Procédure spécifique pour les incidents de sécurité');
INSERT INTO public.quaad_description VALUES (48, 47, 'FR', 'À partir des incidents notifiés, des actions (correctives) sont prises dans le but de <b>renforcer la qualité</b>.', 'Actions correctives en cas d''incidents');
INSERT INTO public.quaad_description VALUES (49, 48, 'FR', '8. Conservation des documents', 'Conservation des documents');
INSERT INTO public.quaad_description VALUES (50, 49, 'FR', 'Les demandes, les images et les rapports sont au moins <b>archivés</b> dans le service ou à l''hôpital pendant la durée de conservation légalement prévue.', 'Archive des documents');
INSERT INTO public.quaad_description VALUES (73, 69, 'FR', 'Les qualifications individuelles de tous les membres du personnel visés au point 5.1. sont conservées dans un <b>registre</b> tenu à jour.', 'Registre des qualifications individuelles');
INSERT INTO public.quaad_description VALUES (51, 50, 'FR', 'Ces documents:<br>

    a. sont <b>protégés</b> de façon à en interdire l''accès aux personnes non habilitées;<br>

    b. peuvent être facilement et rapidement <b>consultés</b> via un système d''indexation.', 'Confidentialité et accessibilité des documents');
INSERT INTO public.quaad_description VALUES (169, 156, 'FR', 'Toutes les SOP’s sont-elles revues au minimum tous les 3 ans et si nécessaire adaptées ?', 'Révision des SOP');
INSERT INTO public.quaad_description VALUES (170, 157, 'FR', 'Le service dispose-t-il d’un manuel de qualité ?', 'Manuel qualité');
INSERT INTO public.quaad_description VALUES (52, 51, 'FR', 'Tous les <b>rapports établis par les experts en radiophysique médicale</b> agréés en radiologie, de même que les données de dosimétrie enregistrées dans le cadre des études obligatoires de dose administrée aux patients, sont conservés par l''exploitant pendant 30 ans.', 'Conservation des rapports et données dosimétriques en radiologie');
INSERT INTO public.quaad_description VALUES (54, 52, 'FR', '9. Exposition médicale, principes de dosimétrie et dosimétrie du patient', 'Exposition médicale, principes de dosimétrie et dosimétrie du patient');
INSERT INTO public.quaad_description VALUES (55, 53, 'FR', '<b>Évaluation de la dose administrée au patient:<br>

    • des indicateurs de dose pour des examens fréquents sont comparés à des niveaux de référence diagnostique ("Diagnostic Reference Levels" ou DRL);<br>

</b><i style="color: #999999;">    • si ces indicateurs de dose dépassent les DRL de manière systématique, on en recherche la cause et (si possible) des actions correctives sont prises.</i>', 'Comparaison avec les DRL');
INSERT INTO public.quaad_description VALUES (65, 63, 'FR', 'Pour les <b>populations spécifiques</b> (par exemple patients pédiatriques ou femmes enceintes): <br>

    a. des directives et des procédures écrites sont disponibles pour la réalisation d''examens radiologiques appropriés;<br>

    b. un contrôle de l’application des directives et des procédures est effectué.', 'Populations spécifiques: disponibilité et application des directives ');
INSERT INTO public.quaad_description VALUES (56, 54, 'FR', '<b>Évaluation de la dose administrée au patient:<br></b><i style="color: #999999;">

    • des indicateurs de dose pour des examens fréquents sont comparés à des niveaux de référence diagnostique ("Diagnostic Reference Levels" ou DRL);<br></i>

<b>    • si ces indicateurs de dose dépassent les DRL de manière systématique, on en recherche la cause et (si possible) des actions correctives sont prises.</b>', 'Actions correctives en cas de dépassement DRL');
INSERT INTO public.quaad_description VALUES (57, 55, 'FR', 'Exposition en cas de (possible) <b>grossesse</b>:<br>

    a. des avertissements destinés aux femmes enceintes sont affichés dans la salle d''attente et/ou les vestiaires;<br>

    b. la question de la présence d''une grossesse est systématiquement posée, et certainement lors d''examens au niveau de l''abdomen ou de la région pelvienne;<br>

    c. le personnel connaît les procédures pour patientes enceintes (voir point 10.3 ci-dessous) et les applique;<br>

    d. en cas de grossesse confirmée pour des examens au niveau de l''abdomen ou de la région pelvienne des estimations de la dose fœtale sont effectuées et documentées par le physicien.<br>', 'Exposition et grossesse');
INSERT INTO public.quaad_description VALUES (58, 56, 'FR', 'Exposition chez l''<b>enfant</b>: le personnel connaît les procédures pour patients pédiatriques (voir point 10.3 ci-dessous) et les applique.

', 'Exposition chez l''enfant');
INSERT INTO public.quaad_description VALUES (59, 57, 'FR', 'Des <b>mesures de radioprotection</b> adéquates (tablier de plomb notamment) sont prévues pour les personnes qui, librement et en connaissance de cause mais pas à titre professionnel, portent aide et assistance aux patients (les parents, par exemple).', 'Mesures de radioprotection pour accompagnant');
INSERT INTO public.quaad_description VALUES (60, 58, 'FR', 'Le service prend part aux <b>études de doses périodiques</b> de l''AFCN pour les examens décrits dans les annexes de l''arrêté de l''AFCN concernant la dosimétrie des patients.', 'Exports AFCN');
INSERT INTO public.quaad_description VALUES (61, 59, 'FR', 'Le service dispose de l''assistance d''un <b>expert agréé en radiophysique médical</b>e agréé par l''AFCN (<b>domaine de radiologie</b>) pour organiser et appliquer les mesures qui s''imposent pour garantir la radioprotection des personnes exposées à des fins médicales.', 'Assistance d''un expert en radiophysique');
INSERT INTO public.quaad_description VALUES (62, 60, 'FR', '10. Documentation et directives', 'Documentation et directives');
INSERT INTO public.quaad_description VALUES (63, 61, 'FR', 'Les résultats de tests d''acceptation, les rapports des contrôles périodiques de qualité et les valeurs de base des appareils actuellement opérationnels sont <b>consultables</b> en version papier ou électronique.', 'Accessibilité des rapports de tests et contrôles');
INSERT INTO public.quaad_description VALUES (64, 62, 'FR', 'Dans le service:<br>

    a. des <b>instructions de travail et procédures (SOP) écrites</b> sont disponibles pour tous les examens réalisés dans le service ;<br>

    b. ces instructions de travail et procédures sont disponibles en permanence pour tous les collaborateurs.', 'Présence et accessibilité des SOP pour tous les examens

');
INSERT INTO public.quaad_description VALUES (66, 64, 'FR', '<b>Les documents suivants sont consultables dans le service, en version papier ou sur support électronique :<br>

    a. manuels d''utilisateur et instructions pour les appareils utilisés;<br></b>

   <i style="color: #999999;"> b. calendrier des contrôles de qualité des appareils et résultats desdits contrôles;<br>

    c. interventions éventuelles des fabricants (journal des mises à niveau, réparations, …) ;<br>

    d. inventaire de tous les équipements de protection individuelle disponibles dans le service (tabliers de plomb, écrans de radioprotection mobiles,…).</i>

', 'Disponibilité  des manuels utilisateurs');
INSERT INTO public.quaad_description VALUES (67, 65, 'FR', '<b>Les documents suivants sont consultables dans le service, en version papier ou sur support électronique :<br></b>

   <i style="color: #999999;"> a. manuels d''utilisateur et instructions pour les appareils utilisés;<br></i>

<b>    b. calendrier des contrôles de qualité des appareils et résultats desdits contrôles;<br></b>

<i style="color: #999999;">    c. interventions éventuelles des fabricants (journal des mises à niveau, réparations, …) ;<br>

    d. inventaire de tous les équipements de protection individuelle disponibles dans le service (tabliers de plomb, écrans de radioprotection mobiles,…).</i>

', 'Disponibilité du calendrier des contrôles qualité');
INSERT INTO public.quaad_description VALUES (68, 66, 'FR', '<b>Les documents suivants sont consultables dans le service, en version papier ou sur support électronique :<br></b>

   <i style="color: #999999;"> a. manuels d''utilisateur et instructions pour les appareils utilisés;<br>

    b. calendrier des contrôles de qualité des appareils et résultats desdits contrôles;<br></i>

<b>   c. interventions éventuelles des fabricants (journal des mises à niveau, réparations, …) ;<br></b><i style="color: #999999;"> 

    d. inventaire de tous les équipements de protection individuelle disponibles dans le service (tabliers de plomb, écrans de radioprotection mobiles,…).</i>

', 'Intervention des fabricants');
INSERT INTO public.quaad_description VALUES (69, 67, 'FR', '<b>Les documents suivants sont consultables dans le service, en version papier ou sur support électronique :<br></b>

   <i style="color: #999999;"> a. manuels d''utilisateur et instructions pour les appareils utilisés;<br>

    b. calendrier des contrôles de qualité des appareils et résultats desdits contrôles;<br>

   c. interventions éventuelles des fabricants (journal des mises à niveau, réparations, …) ;<br></i><b>

    d. inventaire de tous les équipements de protection individuelle disponibles dans le service (tabliers de plomb, écrans de radioprotection mobiles,…).</b>

', 'Inventaire protection individuelle');
INSERT INTO public.quaad_description VALUES (105, 94, 'FR', 'La responsabilité finale d''une procédure de médecine nucléaire
incombe-t-elle à un médecin spécialiste en médecine nucléaire
autorisé par l’AFCN ?', 'Responsabilité procédure NM');
INSERT INTO public.quaad_description VALUES (70, 68, 'FR', 'Pour tous les documents précités, il existe une politique de gestion des versions à l''échelle du service répondant aux caractéristiques suivantes :<br>
    • elles sont pourvues d''une date de création ou de révision ;<br>
    • un responsable est désigné pour leur mise à jour ;<br>
    • les modifications sont communiquées à l''ensemble des intervenants en vue de leur mise en œuvre.<br>', 'Gestion de version des documents');
INSERT INTO public.quaad_description VALUES (75, 71, 'FR', '1. Stratégies et politiques', 'Stratégies et politiques');
INSERT INTO public.quaad_description VALUES (77, 73, 'FR', 'Est-ce que la déclaration de mission du service tient compte de la mission et des objectifs de l''hôpital', 'Lien missions service/hôpital');
INSERT INTO public.quaad_description VALUES (76, 72, 'FR', 'Le service possède-t-il une déclaration de mission ?', 'Déclaration de mission du service');
INSERT INTO public.quaad_description VALUES (78, 74, 'FR', '<b>Le service-t-il défini pour les prochaines années un plan stratégique pluriannuel concernant<br>a. la conduite médicale ? </b><i style="color: #999999;"> <br>b. la conduite financière ?</i>', 'Plan stratégique médical');
INSERT INTO public.quaad_description VALUES (80, 76, 'FR', '<b>Le service prépare t-il chaque année un plan politique ?</b><i style="color: #999999;">
<br>&nbsp;&nbsp;&nbsp;1) Des objectifs de qualité y sont-ils formulés ?
<br>&nbsp;&nbsp;&nbsp;2) Le service possède t-il un système pour suivre ces
objectifs de qualité et si nécessaire les corriger ?</i>', 'Plan politique');
INSERT INTO public.quaad_description VALUES (81, 77, 'FR', '<i style="color: #999999;">Le service prépare t-il chaque année un plan politique ?</i>
<br><b>&nbsp;&nbsp;&nbsp;1) Des objectifs de qualité y sont-ils formulés ?</b><i style="color: #999999;">
<br>&nbsp;&nbsp;&nbsp;2) Le service possède t-il un système pour suivre ces
objectifs de qualité et si nécessaire les corriger ?</i>', 'Plan politique: objectifs de qualité');
INSERT INTO public.quaad_description VALUES (90, 84, 'FR', '<b>Y a-t-il des accords clairs concernant le fonctionnement du service<br>
a. en cas de demandes urgentes ?<br></b>
<i style="color: #999999;">b. en dehors des heures normales de travail ?<br>
c. en cas de maladie des différentes catégories de membres du
personnel ?<br>
d. en cas de congé des différentes catégories de membres du
personnel ?<br></i>', 'Fonctionnement service NM: demande urgente');
INSERT INTO public.quaad_description VALUES (83, 79, 'FR', 'Le service prépare t-il chaque année un rapport annuel ?', 'Rapport annuel');
INSERT INTO public.quaad_description VALUES (82, 78, 'FR', '<i style="color: #999999;">Le service prépare t-il chaque année un plan politique ?
<br>&nbsp;&nbsp;&nbsp;1) Des objectifs de qualité y sont-ils formulés ?</i>
<b><br>&nbsp;&nbsp;&nbsp;2) Le service possède t-il un système pour suivre ces
objectifs de qualité et si nécessaire les corriger ?</b>', 'Plan politique: suivi');
INSERT INTO public.quaad_description VALUES (91, 85, 'FR', '<b>Y a-t-il des accords clairs concernant le fonctionnement du service<br></b>
<i style="color: #999999;">a. en cas de demandes urgentes ?<br></i><b>
b. en dehors des heures normales de travail ?<br></b>
<i style="color: #999999;">c. en cas de maladie des différentes catégories de membres du
personnel ?<br>
d. en cas de congé des différentes catégories de membres du
personnel ?<br></i>', 'Fonctionnement service NM: hors horaire');
INSERT INTO public.quaad_description VALUES (92, 86, 'FR', '<b>Y a-t-il des accords clairs concernant le fonctionnement du service<br></b>
<i style="color: #999999;">a. en cas de demandes urgentes ?<br>
b. en dehors des heures normales de travail ?<br></i>
<b>c. en cas de maladie des différentes catégories de membres du
personnel ?<br></b>
<i style="color: #999999;">d. en cas de congé des différentes catégories de membres du
personnel ?<br></i>', 'Fonctionnement service NM: maladie');
INSERT INTO public.quaad_description VALUES (79, 75, 'FR', '<b>Le service-t-il défini pour les prochaines années un plan stratégique pluriannuel concernant<br></b>
<i style="color: #999999;"> a. la conduite médicale ? </i>
<b> <br>b. la conduite financière ?</b>', 'Plan stratégique financier');
INSERT INTO public.quaad_description VALUES (95, 83, 'FR', '<i style="color: #999999;">a. Le service dispose t-il d’un organigramme écrit ?<br>b. Est-il à jour ?<br></i>
<b>c. Mentionne-t-il les canaux de communication au sein du service ?</b>', 'Organigramme écrit: canaux de communication');
INSERT INTO public.quaad_description VALUES (87, 81, 'FR', '<b>a. Le service dispose t-il d’un organigramme écrit ?<br></b>
<i style="color: #999999;">b. Est-il à jour ?<br>
c. Mentionne-t-il les canaux de communication au sein du
service ?</i>', 'Organigramme écrit');
INSERT INTO public.quaad_description VALUES (100, 91, 'FR', '<i style="color: #999999;">a. Si le service ne propose pas une gamme complète de
procédures de médecine nucléaire, y a-t-il alors un accord de
coopération avec d’autres services de médecine nucléaire où
les patients peuvent être redirigés ?</i><br><b>
b. Ces accords de coopération précisent-ils clairement les
responsabilités des deux services ?</b>', 'Redirection vers d''autres services NM: responsabilités');
INSERT INTO public.quaad_description VALUES (94, 82, 'FR', '<i style="color: #999999;">a. Le service dispose t-il d’un organigramme écrit ?<br></i>
<b>b. Est-il à jour ?<br></b>
<i style="color: #999999;">c. Mentionne-t-il les canaux de communication au sein du service ?</i>', 'Organigramme écrit: à jour');
INSERT INTO public.quaad_description VALUES (98, 89, 'FR', '<b>Y a-t-il des accords clairs avec<br></b>
<i style="color: #999999;">a. les autres services cliniques<br></i><b>
b. le service technique
de l’hôpital et qui précisent les tâches et responsabilités de
chacun ?</b>', 'Accords avec service technique');
INSERT INTO public.quaad_description VALUES (97, 88, 'FR', '<b>Y a-t-il des accords clairs avec<br>
a. les autres services cliniques<br></b>
<i style="color: #999999;">b. le service technique
de l’hôpital et qui précisent les tâches et responsabilités de
chacun ?</i>', 'Accords avec autres services');
INSERT INTO public.quaad_description VALUES (99, 90, 'FR', '<b>a. Si le service ne propose pas une gamme complète de
procédures de médecine nucléaire, y a-t-il alors un accord de
coopération avec d’autres services de médecine nucléaire où
les patients peuvent être redirigés ?</b><br>
<i style="color: #999999;">b. Ces accords de coopération précisent-ils clairement les
responsabilités des deux services ?</i>', 'Redirection vers d''autres services NM');
INSERT INTO public.quaad_description VALUES (101, 92, 'FR', 'Si certaines procédures cliniques sont exécutées pour d’autres
services de médecine nucléaires, les responsabilités relatives des
services exécutant et demandeur sont elles clairement décrites
dans un accord de coopération ?', 'Redirection depuis d''autres services NM: responsabilités');
INSERT INTO public.quaad_description VALUES (103, 93, 'FR', '2. Administration et management', 'Administration et management');
INSERT INTO public.quaad_description VALUES (85, 80, 'FR', 'Y a-t-il concertation entre le service et la direction hospitalière
concernant la gamme de procédures cliniques offerte par le
service ?', 'Concertation concernant la gamme de procédures du service');
INSERT INTO public.quaad_description VALUES (74, 70, 'FR', 'L''hôpital possède-t-il une déclaration de mission ?', 'Déclaration de mission de l''hôpital');
INSERT INTO public.quaad_description VALUES (93, 87, 'FR', '<b>Y a-t-il des accords clairs concernant le fonctionnement du service<br></b>
<i style="color: #999999;">a. en cas de demandes urgentes ?<br>
b. en dehors des heures normales de travail ?<br>
c. en cas de maladie des différentes catégories de membres du
personnel ?<br></i>
<b>d. en cas de congé des différentes catégories de membres du
personnel ?<br></b>', 'Fonctionnement service NM: congé');
INSERT INTO public.quaad_description VALUES (176, 163, 'FR', 'Le  service  effectue-t-il  bien  au  moins  1  fois  l’an une  auto-évaluation ou audit ?', 'Auto-évaluation ou audit périodique');
INSERT INTO public.quaad_description VALUES (292, 272, 'FR', 'New point', '3. Exigences médico-techniques');
INSERT INTO public.quaad_description VALUES (112, 100, 'FR', 'Toutes les personnes professionnellement exposées actives dans
le service ont-elles suivi une formation de base en
radioprotection :<br>
a. médecin spécialiste en médecine nucléaire ?<br>
b. technologue ?<br>
c. infirmier(e)s ?<br>
d. radiophysicien médical (interne ou externe) agréé en
médecine nucléaire ?<br>
e. expert contrôle physique (interne ou externe) ?<br>
f. radiopharmacien/pharmacien hospitalier ?<br>
g. technicien de surface, service technique, brancardiers ?<br>
h. autres (ex : secrétariat, doctorants, stagiaire, etc.) ?', 'Formation de base en radioprotection');
INSERT INTO public.quaad_description VALUES (108, 97, 'FR', '3. Ressources humaines', 'Ressources humaines');
INSERT INTO public.quaad_description VALUES (119, 107, 'FR', 'Le personnel a-t-il accès à la documentation/littérature professionnelle scientifique via e-learning, magazines ou livres récents ?', 'Accès à la documentation');
INSERT INTO public.quaad_description VALUES (120, 108, 'FR', '4. Radioprotection du personnel et de l''environnement', 'Radioprotection du personnel et de l''environnement');
INSERT INTO public.quaad_description VALUES (121, 109, 'FR', 'a. Le service possède-t-il une autorisation d’établissement et
d’exploitation délivrée par l’AFCN ?<br>
b. Est-elle à jour ?', 'Autorisation d’établissement et d’exploitation');
INSERT INTO public.quaad_description VALUES (106, 95, 'FR', '<b>Existe-t-il une SOP décrivant comment traiter un cas si<br>
a. le formulaire de demande est manquant ?<br></b>
<i style="color: #999999;">b. le formulaire de demande est incomplet ?</i>', 'Formulaire de demande manquant');
INSERT INTO public.quaad_description VALUES (107, 96, 'FR', '<b>Existe-t-il une SOP décrivant comment traiter un cas si</b><br>
<i style="color: #999999;">a. le formulaire de demande est manquant ?<br></i>
<b>b. le formulaire de demande est incomplet ?</b>', 'Formulaire de demande incomplet');
INSERT INTO public.quaad_description VALUES (113, 101, 'FR', 'Lors de leur entrée en fonction, les personnes professionnellement exposées reçoivent-elles une formation et des instructions quant aux procédures locales et mesures de précautions concernant la radioprotection du patient et du personnel ?', 'Formation d''entrée aux procédures et radioprotection');
INSERT INTO public.quaad_description VALUES (114, 102, 'FR', 'Y a-t-il une déclaration signée de toutes les personnes professionnellement exposées actives dans le service reconnaissant avoir lu et compris les règles locales de radioprotection ?', 'Déclaration individuelle règles locales de radioprotection');
INSERT INTO public.quaad_description VALUES (115, 103, 'FR', 'Toutes les personnes actives dans le service suivent-elles des
formations continues générales :<br>
a. médecin spécialiste en médecine nucléaire ?<br>
b. technologue ?<br>
c. infirmier(e)s ?<br>
d. radiophysicien médical (interne ou externe) agréé en
médecine nucléaire ?<br>
e. expert contrôle physique (interne ou externe) ?<br>
f. radiopharmacien/pharmacien hospitalier ?<br>
g. technicien de surface, service technique, brancardiers ?<br>
h. autres (ex : secrétariat, doctorants, stagiaire, etc.) ?', 'Formation continue générale');
INSERT INTO public.quaad_description VALUES (116, 104, 'FR', 'Toutes les personnes professionnellement exposées actives dans
le service suivent-elles une formation continue en radioprotection:
a. médecin spécialiste en médecine nucléaire ?<br>
b. technologue ?<br>
c. infirmier(e)s ?<br>
d. radiophysicien médical (interne ou externe) agréé en
médecine nucléaire?<br>
e. expert contrôle physique (interne ou externe) ?<br>
f. radiopharmacien/pharmacien hospitalier ?<br>
g. technicien de surface, service technique, brancardiers ?<br>
h. autres (ex : secrétariat, doctorants, stagiaire, etc.) ?', 'Formation continue en radioprotection');
INSERT INTO public.quaad_description VALUES (117, 105, 'FR', 'Les formations en radioprotection suivies sont-elles enregistrées
au niveau du service, de l’hôpital ou national pour toutes les
personnes professionnellement exposées actives dans le service :<br>
a médecin spécialiste en médecine nucléaire ?<br>
b technologue ?<br>
c infirmier(e)s ?<br>
d radiophysicien médical (interne ou externe) agréé en
médecine nucléaire?<br>
e expert contrôle physique (interne ou externe) ?<br>
f radiopharmacien/pharmacien hospitalier ?<br>
g technicien de surface, service technique, brancardiers ?<br>
h autres (ex : secrétariat, doctorants, stagiaire, etc.) ?', 'Enregistrement de la formation continue en radioprotection');
INSERT INTO public.quaad_description VALUES (118, 106, 'FR', 'Existe-t-il une structure au sein de l’hôpital pour l’identification
des besoins de formation du personnel ?', 'Identification des besoins de formation du personnel NM');
INSERT INTO public.quaad_description VALUES (123, 110, 'FR', 'Les plans du bâtiment sont-ils visiblement affichés à l’entrée des
locaux de la zone contrôlée ?', 'Affichage du plan d''établissement');
INSERT INTO public.quaad_description VALUES (124, 111, 'FR', 'Les plans affichés mentionnent-ils bien<br>
a. les zones contrôlées ?<br>
b. l’emplacement des sources fixes de rayonnements ionisants ?<br>
c. les sorties normales ?<br>
d. les sorties de secours ?', 'Plans affichés: sources de rayonnement, sorties, zones contrôlées');
INSERT INTO public.quaad_description VALUES (125, 112, 'FR', 'Les symboles visibles de rayonnements sont-ils présents à l’entrée
des zones contrôlées et supervisées (dans la langue locale/les
langues locales) ?', 'Symboles de rayonnement à l''entrée NM');
INSERT INTO public.quaad_description VALUES (126, 113, 'FR', 'Y a-t-il des avertissements bien visibles dans le service qui
demandent de rapporter une grossesse éventuelle avant
l’administration du produit radiopharmaceutique ?', 'Avertissement grossesse visible NM ');
INSERT INTO public.quaad_description VALUES (127, 114, 'FR', 'a. Y a-t-il des règles locales écrites concernant la
radioprotection ?<br>
b. Sont-elles conformes aux directives nationales ou
internationales ?', 'Règles locales de radioprotection conformes aux directives');
INSERT INTO public.quaad_description VALUES (128, 115, 'FR', '<b>En dehors des moments d’utilisation, peut-on empêcher l’accès
des locaux suivants aux personnes non autorisées:<br>
a. toutes les zones du labo chaud ?<br></b>
<i style="color: #999999;">b. le local des déchets radioactifs ?</i>', 'Contrôle d''accès labo chaud');
INSERT INTO public.quaad_description VALUES (129, 116, 'FR', '<b>En dehors des moments d’utilisation, peut-on empêcher l’accès
des locaux suivants aux personnes non autorisées:<br>
<i style="color: #999999;">a. toutes les zones du labo chaud ?<br></i>
<b>b. le local des déchets radioactifs ?</b>', 'Contrôle d''accès local déchets NM');
INSERT INTO public.quaad_description VALUES (130, 117, 'FR', '<b>Toutes les sources radioactives sont-elles<br>
a. identifiées<br></b>
<i style="color: #999999;">b. stockées dans un local approprié<br>
c. enregistrées dans l’inventaire d’une manière approuvée par le service de contrôle physique (interne ou externe) ?</i>', 'Identification des sources radioactives');
INSERT INTO public.quaad_description VALUES (131, 118, 'FR', '<b>Toutes les sources radioactives sont-elles<br></b><i style="color: #999999;">
a. identifiées<br></i>
<b>b. stockées dans un local approprié<br></b>
<i style="color: #999999;">c. enregistrées dans l’inventaire d’une manière approuvée par le service de contrôle physique (interne ou externe) ?</i>', 'Stockage approprié des sources radioactives');
INSERT INTO public.quaad_description VALUES (132, 119, 'FR', '<b>Toutes les sources radioactives sont-elles<br></b><i style="color: #999999;">
a. identifiées<br>
b. stockées dans un local approprié<br></i>
<b>c. enregistrées dans l’inventaire d’une manière approuvée par le service de contrôle physique (interne ou externe) ?</b>', 'Inventaire des sources radioactives');
INSERT INTO public.quaad_description VALUES (171, 158, 'FR', 'Le radiophysicien médical (interne ou externe) agréé en médecine nucléaire  effectue-t-il  un  contrôle  
annuel  des  parties  pour  lui pertinentes du manuel de qualité ?', 'Contrôle du manuel qualité par un radiophysicien');
INSERT INTO public.quaad_description VALUES (133, 120, 'FR', 'Le service de contrôle physique (interne ou externe) a-t-il
approuvé les espaces d’administration et les mesures de
radioprotection collective correspondantes pour l’administration
des :<br>
a. produits radiopharmaceutiques pour le diagnostic ?<br>
b. produits radiopharmaceutiques pour la thérapie ?<br>
c. aérosols radioactifs ?<br>
d. gaz radioactifs ?', 'Approbation du service de contrôle physique');
INSERT INTO public.quaad_description VALUES (109, 98, 'FR', 'Toutes les personnes actives dans le service (y compris le
médecin spécialiste en médecine nucléaire indépendant)
disposent-elles d’une description de fonction écrite dans laquelle
les tâches et responsabilités sont clairement décrites ?', 'Description de fonction');
INSERT INTO public.quaad_description VALUES (135, 122, 'FR', 'Le  service  de  contrôle  physique  (interne  ou  externe)  a-t-il approuvé le type et quantité de moyens 
de protection personnelle (vêtements protecteurs, gants, protège-seringues, pinces, etc.) ?', 'Moyens de protection personnelle');
INSERT INTO public.quaad_description VALUES (136, 123, 'FR', 'Des  instruments  de  mesure  calibrés  et  fonctionnels sont-ils présents dans le service pour la détection 
d’une contamination de tous les radio-isotopes repris dans l’autorisation d’établissement et d’exploitation délivrée par l’AFCN ?', 'Instruments de détection de contamination');
INSERT INTO public.quaad_description VALUES (138, 125, 'FR', 'Les  personnes  professionnellement exposées  actives  dans  le service portent-elles un dosimètre sur la 
poitrine délivré et lu par un service de dosimétrie agréé par l’AFCN?', 'Dosimètre de poitrine');
INSERT INTO public.quaad_description VALUES (141, 128, 'FR', 'Des mesures du rayonnement diffusé autour d’un système DEXA sont-elles faites annuellement pour la 
vérification du respect des limites de doses pour le personnel et le public ?', 'Rayonnement autour des système DEXA');
INSERT INTO public.quaad_description VALUES (142, 129, 'FR', 'Le  service  de  contrôle  physique  (interne  ou  externe)  a-t-il approuvé les  installations  sanitaires 
(sans/avec citerne) pour les patients radioactifs ?', 'Installations sanitaires');
INSERT INTO public.quaad_description VALUES (143, 130, 'FR', 'Y a-t-il une toilette séparée pour le personnel ?', 'Toilette pour le personnel');
INSERT INTO public.quaad_description VALUES (144, 131, 'FR', 'Y a-t-il  une SOP disant comment un déchet radioactif solide  ou liquide doit être géré ? ', 'Gestion des déchets radioactifs');
INSERT INTO public.quaad_description VALUES (145, 132, 'FR', 'Y a-t-il  une  SOP décrivant comment des  échantillons  radioactifs de patients (sang, urine, etc.) doivent être manipulés ?', 'Gestion des échantillons radioactifs de patients');
INSERT INTO public.quaad_description VALUES (137, 124, 'FR', 'Avant l’introduction d’une procédure clinique d’un type nouveau<br>
a. cette  procédure  est-elle  rapportée  et  approuvée  auprès  du service de contrôle physique (interne ou externe) ?<br>
b. une analyse formelle des risques concernant la radioprotection du service et des moyens de protection présents a-t-elle été effectuée  par  le  service  de  contrôle  physique  (interne  ou externe) si ce service le trouve nécessaire ?', 'Nouvelle procédure clinique');
INSERT INTO public.quaad_description VALUES (140, 127, 'FR', 'Un dosimètre électronique est-il porté par<br>
 a.le personnel administrant l’injection<br>
 b.le personnel du labo<br> 
chaud si jugé nécessaire par le service de contrôle physique (interne ou externe) ?', 'Dosimètre électronique');
INSERT INTO public.quaad_description VALUES (147, 134, 'FR', 'Toutes  les  demandes  sont-elles  examinées,  justifiées  et approuvées  avant  l’exécution  de  la  procédure  clinique  par  un médecin  spécialiste  en  médecine  nucléaire  autorisé par  l’AFCN pour<br>
<b>a. les procédures de diagnostic ? </b><br>
b. les procédures de thérapie ?', 'Examen des demandes de procédures de diagnostic');
INSERT INTO public.quaad_description VALUES (149, 136, 'FR', '<b>a. Pour les procédures de diagnostic, l’activité  de  chaque  préparation  individuelle  est-elle mesurée avant l''administration. Cette mesure est-elle enregistrée ?</b><br>
b. Pour les procédures de thérapie, l’activité  de  chaque  préparation  individuelle  est-elle mesurée avant l''administration. Cette mesure est-elle enregistrée ?', 'Mesure de l''activité avant administration - proc. diagnostiques');
INSERT INTO public.quaad_description VALUES (148, 135, 'FR', 'Toutes  les  demandes  sont-elles  examinées,  justifiées  et approuvées  avant  l’exécution  de  la  procédure  clinique  par  un médecin  spécialiste  en  médecine  nucléaire  autorisé par  l’AFCN pour<br>
a. les procédures de diagnostic ?<br>
<b>b. les procédures de thérapie ?</b>', 'Examen des demandes de procédures de thérapie');
INSERT INTO public.quaad_description VALUES (150, 137, 'FR', 'a. Pour les procédures de diagnostic, l’activité  de  chaque  préparation  individuelle  est-elle mesurée avant l''administration. Cette mesure est-elle enregistrée ?<br>
<b>b. Pour les procédures de thérapie, l’activité  de  chaque  préparation  individuelle  est-elle mesurée avant l''administration. Cette mesure est-elle enregistrée ?</b>', 'Mesure de l''activité avant administration - proc. thérapeutiques');
INSERT INTO public.quaad_description VALUES (151, 138, 'FR', 'Les  activités  administrées  sont-elles  conformes  aux  valeurs  de référence nationales ou internationales pour<br>
<b>a. les procédures de diagnostic ? </b><br>
b. les procédures de thérapie ?', 'Conformité aux valeurs de référence - procédures diagnostiques');
INSERT INTO public.quaad_description VALUES (152, 139, 'FR', 'Les  activités  administrées  sont-elles  conformes  aux  valeurs  de référence nationales ou internationales pour<br>
a. les procédures de diagnostic ?<br>
<b>b. les procédures de thérapie ?</b>', 'Conformité aux valeurs de référence - procédures thérapeutiques');
INSERT INTO public.quaad_description VALUES (153, 140, 'FR', 'Dans le cas de patient pédiatrique, l’activité administrée est-elle adaptée   conformément   aux   
prescriptions   nationales   ou internationales pour<br>
<b>a. les procédures de diagnostic ? </b><br>
b. les procédures de thérapie ?', 'Adaptation patient pédiatrique - proc. diagnostiques');
INSERT INTO public.quaad_description VALUES (200, 187, 'FR', 'A-t-on  défini  des  niveaux  d’action  et  responsabilité  déterminant quand un équipement doit être<br>
a.réparé ?<br>
b.remplacé ?<br> 
c.retiré du service ?', 'Réparation, remplacement, retrait des matériels');
INSERT INTO public.quaad_description VALUES (146, 133, 'FR', '5. Radioprotection du patient et de son environnement direct', 'Radioprotection du patient et de son environnement direct');
INSERT INTO public.quaad_description VALUES (161, 148, 'FR', 'A-t-on reçu du patient le consentement éclairé écrit (ou de son tuteur légal) avant le début de la thérapie par radionucléides ?', 'Consentement du patient');
INSERT INTO public.quaad_description VALUES (162, 149, 'FR', 'Y a-t-il un radiophysicien médical (interne ou externe) agréé en médecine  nucléaire  disponible  qui  
peut calculer  la dose  efficace après administration du produit radiopharmaceutique ?', 'Calcul de dose après administration');
INSERT INTO public.quaad_description VALUES (165, 152, 'FR', 'Avant administration du produit radiopharmaceutique, contrôle-t-on auprès de chaque patient s’il a peu 
auparavant déjà subi un examen radio-isotopique ou radiologique similaire ?', 'Examen similaire');
INSERT INTO public.quaad_description VALUES (167, 154, 'FR', 'Le service  dispose-t-il de  SOP pour  toutes  les  tâches exécutées par le service ?', 'Existence de procédures pour chaque tâche');
INSERT INTO public.quaad_description VALUES (172, 159, 'FR', 'Le pharmacien hospitalier ou le radiopharmacien agréé par l’AFCN effectue-il un contrôle annuel des 
parties pour lui pertinentes du manuel de qualité ?', 'Contrôle du manuel qualité par un pharmacien');
INSERT INTO public.quaad_description VALUES (175, 162, 'FR', 'a.Tous  les  résultats  des  programmes  d’assurance  qualité mentionnés ci-dessus sont-ils enregistrés ?<br> 
b.Une analyse de ces résultats est-elle faite ?<br> 
c.Si nécessaire, des actions correctives sont-elles apportées ?', 'Enregistrement des résultats du SMQ');
INSERT INTO public.quaad_description VALUES (156, 143, 'FR', 'Si  le  médecin  spécialiste  en  médecine  nucléaire  décide d’administrer à un patient individuel une 
activité divergeant de la valeur de référence, la justification de cette décision est-elle notée pour<br> 
a. les procédures de diagnostic ?<br>
<b>b. les procédures de thérapie ?</b>', 'Ecart avec les valeurs de référence - proc. thérapeutiques');
INSERT INTO public.quaad_description VALUES (163, 150, 'FR', 'Avant l’administration du produit radiopharmaceutique<br> 
a.demande-t-on au patient ses noms et date de naissance ?<br> 
b.l’identité  du  patient  est-elle  contrôlée à  l’aide  du  bracelet d’identification ?', 'Identification des patients');
INSERT INTO public.quaad_description VALUES (173, 160, 'FR', 'Est-ce que<br>  
a.les médecins spécialistes en médecine nucléaire<br> 
b.les technologues<br> 
c.les infirmier(e)s<br> 
d.le  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire<br>  
e.le service de contrôle physique (interne ou externe)<br> 
f.le radiopharmacien/pharmacien hospitalier<br> 
g.le secrétariat au  courant  et  participent-ils  activement  au  système  d’assurance de qualité du service ? ', 'Personnel participant au SMQ');
INSERT INTO public.quaad_description VALUES (174, 161, 'FR', 'Y a-t-il un système d’assurance qualité conforme aux prescriptions nationales ou internationales pour a.activimètres ?<br> 
b.compteurs bêta et gamma ?<br> 
c.moniteurs de contamination ?<br> 
d.caméras gamma planaires ?<br> 
e.scanners SPECT et SPECT/CT ? f.scanners PET et PET/CT ?<br> 
g.compteurs thyroïdiens ?<br> 
h.sondes pour ganglion sentinelle ?<br> 
i.systèmes de dispensation d’aérosols ?<br> 
j.systèmes de ventilation de gaz radioactifs ?<br> 
k.système DEXA ? ', 'Matériels concerné par le SMQ');
INSERT INTO public.quaad_description VALUES (178, 165, 'FR', 'a.Y  a-t-il  un  moyen  d’évaluer  le  degré  de  satisfaction  du patient ?<br> 
<b>b.Y  a-t-il  un  moyen  d’évaluer  le  degré  de  satisfaction  du médecin référent ?</b>', 'Evaluation du degré de satisfaction du médecin référent');
INSERT INTO public.quaad_description VALUES (179, 166, 'FR', 'a.Y a-t-il un contrôle annuel du délai écoulé entre la prise de rendez-vous,  l’exécution  de  l’examen  et  le  rapport  aux médecins référents ?<br> 
b.Un rapport a-t-il été effectué à ce sujet ?<br> 
c.Ceci a-t-il été discuté avec les médecins référents ?<br> 
d.Si nécessaire, des actions correctives sont-elles entreprises ?', 'Contrôle annuel du flux de réalisation d''examens');
INSERT INTO public.quaad_description VALUES (166, 153, 'FR', '6. Système d''assurance de qualité', 'Système d''assurance de qualité');
INSERT INTO public.quaad_description VALUES (182, 169, 'FR', 'N’achète-t-on que des appareils marqués CE ?', 'Appareil marqués CE');
INSERT INTO public.quaad_description VALUES (185, 172, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 <b>c. moniteurs de contamination ?</b><br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  moniteurs de contamination');
INSERT INTO public.quaad_description VALUES (186, 173, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 <b>d. caméras gamma planaires ?</b><br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  caméras gamma planaires');
INSERT INTO public.quaad_description VALUES (187, 174, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 <b>e. scanners SPECT et SPECT/CT ?</b><br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  scanners SPECT et SPECT/CT');
INSERT INTO public.quaad_description VALUES (188, 175, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 <b>f. scanners PET et PET/CT ?</b><br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  scanners PET et PET/CT');
INSERT INTO public.quaad_description VALUES (189, 176, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 <b>g. compteurs thyroïdiens ?</b><br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  compteurs thyroïdiens');
INSERT INTO public.quaad_description VALUES (201, 188, 'FR', 'Une inspection visuelle journalière est-elle faite<br>
<b>a.des têtes des scanners ?</b><br>
b.des collimateurs ?', 'Inspection visuelle journalière des têtes des scanners');
INSERT INTO public.quaad_description VALUES (160, 147, 'FR', 'Avant  sont  départ  de  l’hôpital/institut,  le  patient  (ou  son  tuteur légal)   reçoit-il   des   instructions   
écrites   concernant   la radioprotection pour<br> 
a. les procédures de diagnostic ?<br> 
<b>b. les procédures de thérapie ?</b>', 'Instructions écrites patient avant départ - proc. thérapeutiques');
INSERT INTO public.quaad_description VALUES (190, 177, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 <b>h. sondes pour ganglion sentinelle ?</b><br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  sondes pour ganglion sentinelle');
INSERT INTO public.quaad_description VALUES (191, 178, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 <b>i. systèmes de dispensation d’aérosols ?</b><br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien  systèmes de dispensation d’aérosols');
INSERT INTO public.quaad_description VALUES (177, 164, 'FR', '<b>a.Y a-t-il  un  moyen  d’évaluer  le  degré  de  satisfaction  du patient ?</b><br> 
b.Y  a-t-il  un  moyen  d’évaluer  le  degré  de  satisfaction  du médecin référent ?', 'Evaluation du degré de satisfaction du patient');
INSERT INTO public.quaad_description VALUES (164, 151, 'FR', 'Avant l''administration du produit radiopharmaceutique, demande-t-on  aux femmes en âge de procréer<br>   
a.si elles sont enceintes?<br> 
b.si elles allaitent?', 'Femmes en age de procréer');
INSERT INTO public.quaad_description VALUES (192, 179, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 <b>j. systèmes de ventilation de gaz radioactifs ?</b><br>
 k. système DEXA ?', 'Contrat d''entretien  systèmes de ventilation de gaz radioactifs');
INSERT INTO public.quaad_description VALUES (195, 182, 'FR', 'a.Le  service  utilise-t-il  un  système  de  notification  d’incidents (presqu’incidents) centralisé  (au  niveau  du  service,    de l’hôpital, national ou international ?<br>
b.Ces notifications donnent-elles lieu à des mesures correctives et recommandations ?', 'Système de notification d''incidents');
INSERT INTO public.quaad_description VALUES (198, 185, 'FR', 'Y  a-t-il  des  documents  contenant  les  résultats  des  contrôles  de qualité de  
<b>a.les équipements d’imagerie ? </b><br>
b.activimètres ?', 'Contrôle qualité des équipements d''imagerie');
INSERT INTO public.quaad_description VALUES (194, 181, 'FR', 'Le service participe-t-il à des programmes de gestion de la qualité extérieurs à l’hôpital ?', 'Programmes de gestion de la qualité extérieurs à l''hôpital');
INSERT INTO public.quaad_description VALUES (197, 184, 'FR', 'Les SOP’s concernant les opérations, l’assurance et contrôle de la qualité  des  équipements  d’imagerie  
et  activimètres sont-elles conformes aux manuels des fabricants ? ', 'Conformité des SOP''s avec les manuels des fabricants');
INSERT INTO public.quaad_description VALUES (181, 168, 'FR', 'Avant l’achat d’un appareil, l’avis est-il toujours demandé<br>   
a.d’un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire?<br> 
b.du service contrôle physique (interne ou externe)?', 'Avis avant achat de matériel');
INSERT INTO public.quaad_description VALUES (184, 171, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 <b>b. compteurs bêta et gamma ?</b><br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien compteurs bêta et gamma');
INSERT INTO public.quaad_description VALUES (199, 186, 'FR', 'Y  a-t-il  des  documents  contenant  les  résultats  des  contrôles  de qualité de  
a.les équipements d’imagerie ?<br> 
<b>b.activimètres ?</b>', 'Contrôle qualité des activimètres');
INSERT INTO public.quaad_description VALUES (196, 183, 'FR', '7. Contrôle de la qualité de l''équipement d''imagerie et activimètres', 'Contrôle de la qualité de l''équipement d''imagerie et activimètres				');
INSERT INTO public.quaad_description VALUES (203, 190, 'FR', 'Un  contrôle  est-il  effectué  annuellement  en  ce qui  concernel''uniformité  intrinsèque  et  l''uniformité  
extrinsèque  de  tous  les collimateurs par  un  radiophysicien  médical  (interne  ou  externe) agréé en médecine nucléaire ?', 'Contrôle annuel des collimateurs');
INSERT INTO public.quaad_description VALUES (204, 191, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires  est-elle  effectuée  en  ce  qui  
concerne  l''uniformité par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Analyse des tendances des contrôles d''uniformité');
INSERT INTO public.quaad_description VALUES (207, 194, 'FR', 'Un  contrôle  est-il  effectué  annuellement  en  ce  qui  concerne  la linéarité  spatiale  (distorsion)  par  
un  radiophysicien  médical (interne ou externe) agréé en médecine nucléaire ?', 'Contrôle annuel de la linéarité spatiale');
INSERT INTO public.quaad_description VALUES (208, 195, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires  est-elle  effectuée  en  ce  qui 
concerne  la  linéarité spatiale  (distorsion) par  un  radiophysicien  médical  (interne  ou externe) agréé en médecine nucléaire ?', 'Analyse des tendances des contrôles de linéarité spatiale');
INSERT INTO public.quaad_description VALUES (209, 196, 'FR', 'Un  contrôle  est-il  effectué  annuellement  en  ce  qui  concerne  la sensibilité par  un  radiophysicien  
médical  (interne  ou  externe) agréé en médecine nucléaire ?', 'Contrôle annuel de la sensibilité');
INSERT INTO public.quaad_description VALUES (210, 197, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui 
concerne la sensibilitépar  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Analyse des tendances des contrôles de sensibilité');
INSERT INTO public.quaad_description VALUES (214, 201, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a. géométrie<br>
 b. centre de rotation (COR)<br>
 c. homogénéité corps<br>
 <b>d. alignement SPECT-CT<br>
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?</b>', 'Contrôle annuel de l''alignement SPECT-CT');
INSERT INTO public.quaad_description VALUES (213, 200, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a. géométrie<br>
 b. centre de rotation (COR)<br>
 <b>c. homogénéité corps</b><br>
 d. alignement SPECT-CT<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Contrôle annuel de l''homogénéité corps');
INSERT INTO public.quaad_description VALUES (218, 205, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui 
concerne<br> 
  e. géométrie<br>
  f. centre de rotation (COR)<br>
  g. homogénéité corps<br>
  <b>h. alignement SPECT-CT<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?</b>', 'Analyse des tendances des contrôle annuel de l''alignement SPECT-CT');
INSERT INTO public.quaad_description VALUES (217, 204, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui 
concerne<br> 
  e. géométrie<br>
  f. centre de rotation (COR)<br>
  <b>g. homogénéité corps</b><br>
  h. alignement SPECT-CT<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Analyse des tendances des contrôle annuel de l''homogénéité corps');
INSERT INTO public.quaad_description VALUES (219, 206, 'FR', 'Avant une série d’examens cliniques avec un système DEXA, un examen avec un fantôme 
anthropomorphe de la colonne lombaire est-il effectué ?', 'DEXA - fantôme antropomorphe');
INSERT INTO public.quaad_description VALUES (220, 207, 'FR', 'Un contrôle est-il effectué annuellement pour les systèmes DEXA par  un  radiophysicien  médical  
(interne  ou  externe) agréé  en radiologie ?', 'DEXA -contrôle annuel ');
INSERT INTO public.quaad_description VALUES (202, 189, 'FR', 'Une inspection visuelle journalière est-elle faite<br>  
a.des têtes des scanners ?<br> 
<b>b.des collimateurs ?</b>', 'Inspection visuelle journalière des collimateurs');
INSERT INTO public.quaad_description VALUES (205, 192, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br>  
a.la résolution spatiale<br> 
b.la résolution spatiale du système<br>
    b.1. qualitative<br>
    b.2. quantitative<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Contrôle annuel de la résolution spatiale');
INSERT INTO public.quaad_description VALUES (206, 193, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui 
concerne<br>
 a. la résolution spatiale<br>
 b. la résolution spatiale du système<br>
    b.1. qualitative<br>
    b.2. quantitative<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Analyse des tendances des contrôles de résolution spatiale');
INSERT INTO public.quaad_description VALUES (211, 198, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 <b>a. géométrie</b><br>
 b. centre de rotation (COR)<br>
 c. homogénéité corps<br>
 d. alignement SPECT-CT<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Contrôle annuel de la géométrie');
INSERT INTO public.quaad_description VALUES (212, 199, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a. géométrie<br>
 <b>b. centre de rotation (COR)</b><br>
 c. homogénéité corps<br>
 d. alignement SPECT-CT<br>
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Contrôle annuel du centre de rotation');
INSERT INTO public.quaad_description VALUES (215, 202, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui 
concerne<br> 
  <b>e. géométrie</b><br>
  f. centre de rotation (COR)<br>
  g. homogénéité corps<br>
  h. alignement SPECT-CT<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Analyse des tendances des contrôle annuel de la géométrie');
INSERT INTO public.quaad_description VALUES (216, 203, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui 
concerne<br> 
  e. géométrie
  <b>f. centre de rotation (COR)</b><br>
  g. homogénéité corps<br>
  h. alignement SPECT-CT<br>
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire ?', 'Analyse des tendances des contrôle annuel du centre de rotation');
INSERT INTO public.quaad_description VALUES (221, 208, 'FR', 'Un  contrôle  et  une  analyse  des  tendances  des  résultats  est-il effectué  annuellement  pour  les  
systèmes  DEXA  en  ce  qui concerne<br>
 <b>a.la qualité du faisceau (HVL)</b><br>
 b.la qualité de l’image<br>
 c.BMD (Bone Mineral Density)<br>
 d.la dose au patient (dose entrant sur la peau) en comparaison avec les doses de références nationales ou internationales 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en radiologie ? ', 'DEXA - contrôle de la qualité du faisceau');
INSERT INTO public.quaad_description VALUES (245, 232, 'FR', 'Y-a-t-il  des  accords  (au  niveau  du  service  ou  de  l’hôpital)  sur l’’achat et l’acceptation de mises à niveau du<br>
 a.hard ware<br>
 <b>b.soft ware d’imagerie et traitement de l’image ?</b>', 'Accords sur l''achat et l''acceptation de mises à niveau du software');
INSERT INTO public.quaad_description VALUES (224, 211, 'FR', 'Un  contrôle  et  une  analyse  des  tendances  des  résultats  est-il effectué  annuellement  pour  les  
systèmes  DEXA  en  ce  qui concerne<br>
 a.la qualité du faisceau (HVL)<br>
 b.la qualité de l’image<br>
 c.BMD (Bone Mineral Density)<br>
 <b>d.la dose au patient (dose entrant sur la peau) en comparaison avec les doses de références nationales ou internationales 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en radiologie ?</b>', 'DEXA - contrôle de la dose au patient');
INSERT INTO public.quaad_description VALUES (228, 215, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 b.bruit de fond de l’arrière-plan<br>
 c.synchronisation de l’horloge<br>
 <b>d.constance</b><br>
 e.énergie de la réponse<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.sensibilité ISO<br> 
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle de la constance');
INSERT INTO public.quaad_description VALUES (229, 216, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 b.bruit de fond de l’arrière-plan<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 <b>e.énergie de la réponse</b><br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.sensibilité ISO<br> 
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle de l''énergie de la réponse');
INSERT INTO public.quaad_description VALUES (230, 217, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 b.bruit de fond de l’arrière-plan<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.énergie de la réponse<br>
 <b>f.linéarité<br>
 g.reproductibilité</b><br>
 h.sensibilité ISO<br>
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle de la linéarité');
INSERT INTO public.quaad_description VALUES (231, 218, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 b.bruit de fond de l’arrière-plan<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.énergie de la réponse<br>
 f.linéarité<br>
 <b>g.reproductibilité</b><br>
 h.sensibilité ISO<br> 
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle de la reproductibilité');
INSERT INTO public.quaad_description VALUES (155, 142, 'FR', 'Si  le  médecin  spécialiste  en  médecine  nucléaire  décide d’administrer à un patient individuel une 
activité divergeant de la valeur de référence, la justification de cette décision est-elle notée pour<br> 
<b>a. les procédures de diagnostic ? </b><br>
b. les procédures de thérapie ?', 'Ecart avec les valeurs de référence - proc. diagnostiques');
INSERT INTO public.quaad_description VALUES (232, 219, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 b.bruit de fond de l’arrière-plan<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.énergie de la réponse<br>
 f.linéarité<br>
 g.reproductibilité<br>
 <b>h.sensibilité ISO</b><br> 
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle de la sensibilité ISO');
INSERT INTO public.quaad_description VALUES (134, 121, 'FR', 'Le  service  de  contrôle  physique  (interne  ou  externe)  a-t-il approuvé  les  espaces  et  les  mesures  de 
 protection  collective correspondantes  où les patients séjournent après administration des<br> 
a. produits radiopharmaceutiques pour le diagnostic des<br> 
   a.1patients ambulatoires ?<br>
   a.2patients hospitalisés ?<br>
b.produits radiopharmaceutiques pour la thérapie des<br>
   b.1patients ambulatoires ?<br>
   b.2patients hospitalisés ?', 'Espaces de séjours des patients');
INSERT INTO public.quaad_description VALUES (154, 141, 'FR', 'Dans le cas de patient pédiatrique, l’activité administrée est-elle adaptée   conformément   aux   
prescriptions   nationales   ou internationales pour<br>
a. les procédures de diagnostic ?<br> 
<b>b. les procédures de thérapie ?</b>', 'Adaptation patient pédiatrique - proc. thérapeutiques');
INSERT INTO public.quaad_description VALUES (139, 126, 'FR', 'Un dosimètre de doigt ou poignet est-il porté par <br>a.le personnel administrant l’injection <br>b.le personnel 
du labo chaud si jugé nécessaire par le service de contrôle physique (interne ou externe) ?', 'Dosimètre de doigt / poignet');
INSERT INTO public.quaad_description VALUES (226, 213, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 <b>b.bruit de fond de l’arrière-plan</b><br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.énergie de la réponse<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.sensibilité ISO<br> 
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle du bruit de fond de l''arrière plan');
INSERT INTO public.quaad_description VALUES (227, 214, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 a.bruit de fond électronique<br>
 b.bruit de fond de l’arrière-plan<br>
 <b>c.synchronisation de l’horloge</b><br>
 d.constance<br>
 e.énergie de la réponse<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.sensibilité ISO<br> 
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle de la synchronisation de l''horloge');
INSERT INTO public.quaad_description VALUES (180, 167, 'FR', 'a.Y a-t-il un contrôle annuel du délai écoulé entre la prise de rendez-vous et l’exécution de la thérapie à radionucléide ?<br> 
b.Un rapport a-t-il été effectué à ce sujet ?<br> 
c.Ceci a-t-il été discuté avec les médecins référents ?<br> 
d.Si nécessaire, des actions correctives sont-elles entreprises ?', 'Contrôle annuel du flux de thérapie à radionucléides');
INSERT INTO public.quaad_description VALUES (223, 210, 'FR', 'Un  contrôle  et  une  analyse  des  tendances  des  résultats  est-il effectué  annuellement  pour  les  
systèmes  DEXA  en  ce  qui concerne<br>
 a.la qualité du faisceau (HVL)<br>
 b.la qualité de l’image<br>
 <b>c.BMD (Bone Mineral Density)</b><br>
 d.la dose au patient (dose entrant sur la peau) en comparaison avec les doses de références nationales ou internationales 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en radiologie ? ', 'DEXA - contrôle de la BMD');
INSERT INTO public.quaad_description VALUES (225, 212, 'FR', 'Un contrôle est-il effectué annuellement en ce qui concerne<br> 
 <b>a.bruit de fond électronique</b><br>
 b.bruit de fond de l’arrière-plan<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.énergie de la réponse<br>
 f.linéarité<br> 
 g.reproductibilité<br>
 h.sensibilité ISO<br>
par  un  radiophysicien  médical  (interne  ou  externe)  agréé  en médecine nucléaire ?', 'DEXA - contrôle du bruit de fond électronique');
INSERT INTO public.quaad_description VALUES (252, 235, 'FR', ' Y a-t-il des contrats d’entretien (interne ou externe) pour?<br>
 a.hardware<br>
 <b>b.software d’imagerie et traitement de l’image ?</b>', 'Contrats d''entretien pour le software');
INSERT INTO public.quaad_description VALUES (183, 170, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
<b> a. activimètres ?</b><br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 k. système DEXA ?', 'Contrat d''entretien des activimètres');
INSERT INTO public.quaad_description VALUES (193, 180, 'FR', 'Y a-t-il un contrat d’entretien (interne ou externe) pour<br>  
 a. activimètres ?<br>
 b. compteurs bêta et gamma ?<br>
 c. moniteurs de contamination ?<br>
 d. caméras gamma planaires ?<br>
 e. scanners SPECT et SPECT/CT ?<br>
 f. scanners PET et PET/CT ?<br>
 g. compteurs thyroïdiens ?<br>
 h. sondes pour ganglion sentinelle ?<br>
 i. systèmes de dispensation d’aérosols ?<br>
 j. systèmes de ventilation de gaz radioactifs ?<br>
 <b>k. système DEXA ?</b>', 'Contrat d''entretien système DEXA');
INSERT INTO public.quaad_description VALUES (222, 209, 'FR', 'Un  contrôle  et  une  analyse  des  tendances  des  résultats  est-il effectué  annuellement  pour  les  
systèmes  DEXA  en  ce  qui concerne<br>
 a.la qualité du faisceau (HVL)<br>
 <b>b.la qualité de l’image</b><br>
 c.BMD (Bone Mineral Density)<br>
 d.la dose au patient (dose entrant sur la peau) en comparaison avec les doses de références nationales ou internationales 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en radiologie ? ', 'DEXA - contrôle de la qualité de l''image');
INSERT INTO public.quaad_description VALUES (233, 220, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 <b>a.bruit électronique</b><br>
 b.bruit de fond<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.réponse en énergie<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances du bruit de fond électronique');
INSERT INTO public.quaad_description VALUES (234, 221, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 <b>b.bruit de fond</b><br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.réponse en énergie<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances du bruit de fond de l''arrière plan');
INSERT INTO public.quaad_description VALUES (235, 222, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 b.bruit de fond<br>
 <b>c.synchronisation de l’horloge</b><br>
 d.constance<br>
 e.réponse en énergie<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances de la synchronisation de l''horloge');
INSERT INTO public.quaad_description VALUES (236, 223, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 b.bruit de fond<br>
 c.synchronisation de l’horloge<br>
 <b>d.constance</b><br>
 e.réponse en énergie<br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances de la constance');
INSERT INTO public.quaad_description VALUES (246, 233, 'FR', 'Y  a-t-il un système de gestion de qualité pour les logiciels produits in-house ?', 'SMQ pour les logiciels in-house');
INSERT INTO public.quaad_description VALUES (237, 224, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 b.bruit de fond<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 <b>e.réponse en énergie</b><br>
 f.linéarité<br>
 g.reproductibilité<br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances de l''énergie de la réponse');
INSERT INTO public.quaad_description VALUES (238, 225, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 b.bruit de fond<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.réponse en énergie<br>
 <b>f.linéarité</b><br>
 g.reproductibilité<br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances de la linéarité');
INSERT INTO public.quaad_description VALUES (239, 226, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 b.bruit de fond<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.réponse en énergie<br>
 f.linéarité<br>
 <b>g.reproductibilité</b><br>
 h.isosensibilité<br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances de la reproductibilité');
INSERT INTO public.quaad_description VALUES (240, 227, 'FR', 'Une  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concernene  analyse  des  tendances  des  résultats  des  contrôles intermédiaires est-elle effectuée en ce qui concerne<br>
 a.bruit électronique<br>
 b.bruit de fond<br>
 c.synchronisation de l’horloge<br>
 d.constance<br>
 e.réponse en énergie<br>
 f.linéarité<br>
 g.reproductibilité<br>
 <b>h.isosensibilité</b><br> 
par  un  radiophysicien  médical  (interne  ou  externe) agréé  en médecine nucléaire?', 'DEXA - analyse des tendances de la sensibilité ISO');
INSERT INTO public.quaad_description VALUES (242, 229, 'FR', 'Y-a-t-il  des  accords  (au  niveau  du  service  ou  de  l’hôpital)  sur l''achat et l’acceptation du<br>
 <b>a.hard ware</b><br>
 b.soft ware d’imagerie et traitement de l’image ?<br>', 'Acords sur l''achat et l''acceptation du hardware');
INSERT INTO public.quaad_description VALUES (243, 230, 'FR', 'Y-a-t-il  des  accords  (au  niveau  du  service  ou  de  l’hôpital)  sur l''achat et l’acceptation du<br>
 a.hard ware<br>
 <b>b.soft ware d’imagerie et traitement de l’image ?</b><br>', 'Accords sur l''achat du software d''imagerie et de traitement de l''image');
INSERT INTO public.quaad_description VALUES (244, 231, 'FR', 'Y-a-t-il  des  accords  (au  niveau  du  service  ou  de  l’hôpital)  sur l’’achat et l’acceptation de mises à niveau du<br>
 <b>a.hard ware</b><br>
 b.soft ware d’imagerie et traitement de l’image ?', 'Accords sur l''achat et l''acceptation de mises à niveau du harware');
INSERT INTO public.quaad_description VALUES (251, 234, 'FR', ' Y a-t-il des contrats d’entretien (interne ou externe) pour?<br>
 <b>a.hardware</b><br>
 b.software d’imagerie et traitement de l’image ?', 'Contrats d''entretien pour le hardware');
INSERT INTO public.quaad_description VALUES (253, 236, 'FR', 'Une évaluation de l’intégrité des données est-elle effectuée après révision importante d’un logiciel en ce qui concerne<br>
 <b>a. des pertes du taux de comptage ?</b><br>
 b. du tramage de l''information ?<br>
 c. de la quantification du traitement de l''image ?<br>
 d. du calcul de l''image ?<br>
 e. du calcul de la courbe activité - temps ?', 'Intégrité des données - pertes du taux de comptage');
INSERT INTO public.quaad_description VALUES (254, 237, 'FR', 'Une évaluation de l’intégrité des données est-elle effectuée après révision importante d’un logiciel en ce qui concerne<br>
 a. des pertes du taux de comptage ?<br>
 <b>b. du tramage de l''information ?</b><br>
 c. de la quantification du traitement de l''image ?<br>
 d. du calcul de l''image ?<br>
 e. du calcul de la courbe activité - temps ?', 'Intégrité des données - tramage de l''information');
INSERT INTO public.quaad_description VALUES (255, 238, 'FR', 'Une évaluation de l’intégrité des données est-elle effectuée après révision importante d’un logiciel en ce qui concerne<br>
 a. des pertes du taux de comptage ?<br>
 b. du tramage de l''information ?<br>
 <b>c. de la quantification du traitement de l''image ?</b><br>
 d. du calcul de l''image ?<br>
 e. du calcul de la courbe activité - temps ?', 'Intégrité des données - quantification du traitement de l''image');
INSERT INTO public.quaad_description VALUES (256, 239, 'FR', 'Une évaluation de l’intégrité des données est-elle effectuée après révision importante d’un logiciel en ce qui concerne<br>
 a. des pertes du taux de comptage ?<br>
 b. du tramage de l''information ?<br>
 c. de la quantification du traitement de l''image ?<br>
 <b>d. du calcul de l''image ?</b><br>
 e. du calcul de la courbe activité - temps ?', 'Intégrité des données - calcul de l''image');
INSERT INTO public.quaad_description VALUES (257, 240, 'FR', 'Une évaluation de l’intégrité des données est-elle effectuée après révision importante d’un logiciel en ce qui concerne<br>
 a. des pertes du taux de comptage ?<br>
 b. du tramage de l''information ?<br>
 c. de la quantification du traitement de l''image ?<br>
 d. du calcul de l''image ?<br>
 <b>e. du calcul de la courbe activité - temps ?</b>', 'Intégrité des données - calcul de l''activite - temps');
INSERT INTO public.quaad_description VALUES (241, 228, 'FR', '8. Systèmes informatiques et traitement des données', 'Systèmes informatiques et traitement des données');
INSERT INTO public.quaad_description VALUES (258, 241, 'FR', '9. Tests d''acceptation', 'Tests d''acceptation');
INSERT INTO public.quaad_description VALUES (259, 242, 'FR', 'Les  spécifications  de  l’appareil  demandées  dans  le cahier  des charges sont-elles utilisées pour les 
tests d’acceptation ?', 'Prise en compte des spécifications');
INSERT INTO public.quaad_description VALUES (260, 243, 'FR', 'Les tests d’acceptation sont-ils exécutés  ou bien par un radiophysicien médical (interne ou externe) 
agréé en médecine nucléaire  ou bien par le fabricant et contrôlés par un radiophysicien médical (interne ou externe) agréé en médecine nucléaire ?', 'Responsable des tests');
INSERT INTO public.quaad_description VALUES (261, 244, 'FR', 'Des procédures NEMA intrinsèques sont-elles exécutées pour<br> 
 <b>a.la résolution en fonction de l’énergie<br></b>
 b.l''uniformité du flood field ?<br>
 c.la résolution spatiale ?<br>
 d.la linéarité spatiale ?<br>
 e.la performance du taux de comptage et le taux de comptage maximum ?<br>
 f.l''enregistrement spatial multifenêtres ?', 'NEMA intrinsèques - résolution en fonction de l''énergie');
INSERT INTO public.quaad_description VALUES (262, 245, 'FR', 'Des procédures NEMA intrinsèques sont-elles exécutées pour<br> 
 a.la résolution en fonction de l’énergie<br>
 <b>b.l''uniformité du flood field ?</b><br>
 c.la résolution spatiale ?<br>
 d.la linéarité spatiale ?<br>
 e.la performance du taux de comptage et le taux de comptage maximum ?<br>
 f.l''enregistrement spatial multifenêtres ?', 'NEMA intrinsèques - uniformité du flood field');
INSERT INTO public.quaad_description VALUES (263, 246, 'FR', 'Des procédures NEMA intrinsèques sont-elles exécutées pour<br> 
 a.la résolution en fonction de l’énergie<br>
 b.l''uniformité du flood field ?<br>
 <b>c.la résolution spatiale ?</b><br>
 d.la linéarité spatiale ?<br>
 e.la performance du taux de comptage et le taux de comptage maximum ?<br>
 f.l''enregistrement spatial multifenêtres ?', 'NEMA intrasèques - résolution spatiale');
INSERT INTO public.quaad_description VALUES (264, 247, 'FR', 'Des procédures NEMA intrinsèques sont-elles exécutées pour<br> 
 a.la résolution en fonction de l’énergie<br>
 b.l''uniformité du flood field ?<br>
 c.la résolution spatiale ?<br>
 <b>d.la linéarité spatiale ?</b><br>
 e.la performance du taux de comptage et le taux de comptage maximum ?<br>
 f.l''enregistrement spatial multifenêtres ?', 'NEMA intrasèques - linéarité spatiale');
INSERT INTO public.quaad_description VALUES (265, 248, 'FR', 'Des procédures NEMA intrinsèques sont-elles exécutées pour<br> 
 a.la résolution en fonction de l’énergie<br>
 b.l''uniformité du flood field ?<br>
 c.la résolution spatiale ?<br>
 d.la linéarité spatiale ?<br>
 <b>e.la performance du taux de comptage et le taux de comptage maximum ?</b><br>
 f.l''enregistrement spatial multifenêtres ?', 'NEMA intrasèques - taux de comptage');
INSERT INTO public.quaad_description VALUES (266, 249, 'FR', 'Des procédures NEMA intrinsèques sont-elles exécutées pour<br> 
 a.la résolution en fonction de l’énergie<br>
 b.l''uniformité du flood field ?<br>
 c.la résolution spatiale ?<br>
 d.la linéarité spatiale ?<br>
 e.la performance du taux de comptage et le taux de comptage maximum ?<br>
 <b>f.l''enregistrement spatial multifenêtres ?</b>', 'NEMA intrasèques - enregistrement spatial');
INSERT INTO public.quaad_description VALUES (267, 250, 'FR', 'Les   procédures   NEMA   (système)   extrinsèques   sont-elles appliquées pour<br>   
 <b>a.l''uniformité du flood field ?</b><br>
 b.la résolution spatiale avec et sans diffusion ?<br>
 c.la sensibilité de chaque collimateur ?<br>
 d.le blindage de la tête du détecteur ?', 'NEMA extrinsèques - uniformité du flood field');
INSERT INTO public.quaad_description VALUES (268, 251, 'FR', 'Les   procédures   NEMA   (système)   extrinsèques   sont-elles appliquées pour<br>   
 a.l''uniformité du flood field ?</b>
 <2>b.la résolution spatiale avec et sans diffusion ?</b><br>
 c.la sensibilité de chaque collimateur ?<br>
 d.le blindage de la tête du détecteur ?', 'NEMA extrasèques - résolution spatiale');
INSERT INTO public.quaad_description VALUES (269, 252, 'FR', 'Les   procédures   NEMA   (système)   extrinsèques   sont-elles appliquées pour<br>   
 a.l''uniformité du flood field ?</b>
 b.la résolution spatiale avec et sans diffusion ?<br>
 <b>c.la sensibilité de chaque collimateur ?</b><br>
 d.le blindage de la tête du détecteur ?', 'NEMA extrasèques - sensibilité des collimateurs');
INSERT INTO public.quaad_description VALUES (270, 253, 'FR', 'Les   procédures   NEMA   (système)   extrinsèques   sont-elles appliquées pour<br>   
 a.l''uniformité du flood field ?</b>
 b.la résolution spatiale avec et sans diffusion ?<br>
 c.la sensibilité de chaque collimateur ?<br>
<b> d.le blindage de la tête du détecteur ?</b>', 'NEMA extrasèques - blindage de la tête du détecteur');
INSERT INTO public.quaad_description VALUES (271, 254, 'FR', 'Les  tests  d’acceptation  suivants  sont-ils  exécutés  pour  la tomographie par émission de photon unique (SPECT) (Non-NEMA) : 
 a.centre de rotation SPECT ?
 b.erreurs angulaires de linéarité ?
 c.uniformité ?
   c.1. l''uniformité de coupe tomographique ?<br>
   c.2. l''uniformité rotationnelle ?<br>
 d.sensibilité du volume du système (NEMA) ?<br>
 e.la résolution tomographique ?<br>
   e.1. dans l''air (NEMA) ?<br> 
   e.2. dans un milieu de diffusant (NEMA) ?<br>
 f.test d''épaisseur de coupe (AIEA) ?<br>
 g.contrôle  de  la  performance  totale  (fantôme  du  spectre  des données)  (American  Association  of  Physicists  in  Medicine (AAPM)) ?<br>
   g.1. uniformité tomographique ?<br>
   g.2. résolution tomographique  (sphères et barres) ?
   g.3. contraste ?', 'Tests d''acceptation SPECT');
INSERT INTO public.quaad_description VALUES (272, 255, 'FR', 'Des  tests  spécifiques  sont-ils  exécutés  pour  les  systèmes  à détecteurs multiples :<br> 
 <b>a.enregistrement du détecteur multiple ?</b><br>
 b.concordance de la sensibilité ?<br>
 c.concordance de la qualité des pixels ?<br>
 d.concordance du centre de rotation ?', 'Tests détecteurs multiples - enregistrement');
INSERT INTO public.quaad_description VALUES (273, 256, 'FR', 'Des  tests  spécifiques  sont-ils  exécutés  pour  les  systèmes  à détecteurs multiples :<br> 
 a.enregistrement du détecteur multiple ?<br>
 <b>b.concordance de la sensibilité ?</b><br>
 c.concordance de la qualité des pixels ?<br>
 d.concordance du centre de rotation ?', 'Tests détecteurs multiples - sensibilité');
INSERT INTO public.quaad_description VALUES (274, 257, 'FR', 'Des  tests  spécifiques  sont-ils  exécutés  pour  les  systèmes  à détecteurs multiples :<br> 
 a.enregistrement du détecteur multiple ?<br>
 b.concordance de la sensibilité ?<br>
 <b>c.concordance de la qualité des pixels ?</b><br>
 d.concordance du centre de rotation ?', 'Tests détecteurs multiples - qualité des pixels');
INSERT INTO public.quaad_description VALUES (275, 258, 'FR', 'Des  tests  spécifiques  sont-ils  exécutés  pour  les  systèmes  à détecteurs multiples :<br> 
 a.enregistrement du détecteur multiple ?<br>
 b.concordance de la sensibilité ?<br>
 c.concordance de la qualité des pixels ?<br>
 <b>d.concordance du centre de rotation ?</b>', 'Tests détecteurs multiples - centre de rotation');
INSERT INTO public.quaad_description VALUES (276, 259, 'FR', '10. Aspects généraux - Diagnostic', 'Aspects généraux - Diagnostic');
INSERT INTO public.quaad_description VALUES (278, 261, 'FR', 'Une surveillance visuelle du patient est-elle prévue pendant son séjour dans le service de médecine 
nucléaire ?', 'Surveillance visuelle du patient');
INSERT INTO public.quaad_description VALUES (279, 262, 'FR', 'Les  mesures  spécifiques  aux  patients  pédiatriques  (ex : adaptation de la dose, anesthésie, etc.) 
sont-elles décrites dans les SOP’s cliniques ?', 'Patients pédiatriques - SOP''s cliniques');
INSERT INTO public.quaad_description VALUES (280, 263, 'FR', 'Un médecin est-il présent dans le service lors de l’administration des diurétiques, inhibiteurs ECA, 
agents de contraste, etc. ?', 'Présence d''un médecin');
INSERT INTO public.quaad_description VALUES (281, 264, 'FR', '11. Aspects généraux - Thérapie par radionucléides', 'Aspects généraux - Thérapie par radionucléides');
INSERT INTO public.quaad_description VALUES (282, 265, 'FR', 'Pendant les heures de fonctionnement du service, y a-t-il toujours un médecin disponible pour 
répondre aux questions du patient ?', 'Présence d''un médecin');
INSERT INTO public.quaad_description VALUES (283, 266, 'FR', 'Une surveillance visuelle du patient est-elle prévue pendant son séjour dans le service de médecine 
nucléaire ?', 'Surveillance visuelle du patient');
INSERT INTO public.quaad_description VALUES (284, 267, 'FR', 'Les  mesures  spécifiques  aux  patients  pédiatriques  (ex : adaptation de la dose, anesthésie, etc.) 
sont-elles décrites dans les SOP’s cliniques ?', 'Mesures spécifiques aux patients pédiatriques');
INSERT INTO public.quaad_description VALUES (285, 268, 'FR', 'Les  SOP’s  pour  les  divers  types  de  thérapie  par  radionucléides, mentionnent-elles les valeurs à ne 
pas dépasser pour la libération (hors hôpital) du patient ?', 'Valeurs maximales avant libération du patient');
INSERT INTO public.quaad_description VALUES (286, 269, 'FR', 'La dose venant du patient a-t-elle été mesurée à 1m et à hauteur du thorax, et notée dans le dossier du 
patient avant sa libération du service ?', 'Mesure de dose avant libération');
INSERT INTO public.quaad_description VALUES (287, 270, 'FR', 'Un suivi clinique multidisciplinaire de ces patients est-il prévu?', 'Suivi clinique multidisciplinaire');
INSERT INTO public.quaad_description VALUES (110, 99, 'FR', 'Toutes les personnes actives dans le service ont-elles suivi une
formation adaptée pour pouvoir satisfaire à leur description de
fonction ?', 'Diplôme et Formation');
INSERT INTO public.quaad_description VALUES (277, 260, 'FR', 'Pendant les heures de fonctionnement du service, y a-t-il toujours un médecin disponible pour répondre 
aux questions du patient ?', 'Présence d''un médecin');
INSERT INTO public.quaad_description VALUES (158, 145, 'FR', 'Avant  son  départ  de  l’hôpital/institut,  le  patient  (ou  son  tuteur légal)   reçoit-il   des   instructions   
orales   concernant   la radioprotection pour<br> 
a. les procédures de diagnostic ?<br> 
<b>b. les procédures de thérapie ?</b>', 'Instructions orales patient avant départ - proc thérapeutiques');
INSERT INTO public.quaad_description VALUES (157, 144, 'FR', 'Avant  son  départ  de  l’hôpital/institut,  le  patient  (ou  son  tuteur légal)   reçoit-il   des   instructions   
orales   concernant   la radioprotection pour<br> 
<b>a. les procédures de diagnostic ? </b><br>
b. les procédures de thérapie ?', 'Instructions orales patient avant départ - proc diagnostiques');
INSERT INTO public.quaad_description VALUES (159, 146, 'FR', 'Avant  sont  départ  de  l’hôpital/institut,  le  patient  (ou  son  tuteur légal)   reçoit-il   des   instructions   
écrites   concernant   la radioprotection pour<br> 
<b>a. les procédures de diagnostic ?</b><br>
b. les procédures de thérapie ?', 'Instructions écrites patient avant départ - proc. diagnostiques');
INSERT INTO public.quaad_description VALUES (168, 155, 'FR', 'Les  SOP’s  des  procédures  cliniques  exécutées  par  le  service, comportent-elles   les   données   minimales   suivantes   (si d’application) :<br> 
a.objectif de l’examen ou problème clinique ?<br> 
b.principe du fonctionnement ?<br>
c.indications et contre-indications ?<br> 
d.fixation d’un rendez-vous ?<br> 
e.préparation du patient ?<br> 
f.planning ?<br> 
g.accueil du patient ?<br> 
h.préparation du produit radiopharmaceutique ?<br> 
i.administration du produit radiopharmaceutique ? <br>
j.exécution de l’examen ? <br>
k.reconstruction et traitement ?  <br>
l.surveillance post-traitement ? <br>
m.évaluation/protocole ? <br>
n.références ? <br>
o.version ? <br>
p.personne qui valide ? <br>
q.personne qui approuve ?', 'SOP des procédures cliniques');
INSERT INTO public.quaad_description VALUES (293, 273, 'FR', 'La structure d’IM détermine et s’assure qu’elle dispose des compétences nécessaires à la sécurité, à la bonne 
prise en charge des patients et à la bonne maîtrise des actes d’IM qu’elle réalise. Pour cela, elle détermine et 
fournit les ressources humaines nécessaires à la mise en œuvre de son système de management de la qualité 
(SMQ). 
La structure d’IM dispose d’une procédure documentée pour la gestion de l’équipe. Le rôle et les 
responsabilités de toutes les catégories de professionnels sont définis et documentés dans des définitions de 
fonctions. La composition détaillée de l''équipe, les habilitations de chacun, ainsi que celle des ressources 
extérieures mobilisées, tels que le recours à une structure de téléradiologie, sont traçées et suivies au fil des 
mouvements et des modifications. 
Les conditions de management des ressources humaines et la qualité de vie au travail sont des préoccupations 
de la structure d''IM et des actions sont mises en place et suivies. La qualité de l’ambiance au travail, qui 
constitue un facteur de sécurité de la pratique médicale, est recherchée.', 'Ressources humaines');
INSERT INTO public.quaad_description VALUES (297, 279, 'FR', 'La structure d’IM organise la formation continue de l’ensemble des professionnels pour maintenir et si besoin 
mettre à niveau leurs compétences.', 'Qualifications - Formation continue');
INSERT INTO public.quaad_description VALUES (295, 275, 'FR', 'La structure d’IM s’assure des qualifications et autorisations d’exercice de tous les professionnels. Elle dispose 
des documents qui prouvent que chaque professionnel possède la compétence nécessaire et la maîtrise des 
actes qu’il réalise pour répondre aux exigences de qualité des soins et de sécurité des patients pris en charge 
dans la structure d’IM.', 'Qualifications - Autorisations et compétences');
INSERT INTO public.quaad_description VALUES (298, 280, 'FR', 'Pour toute acquisition de dispositif médical, des formations initiales et périodiques sont définies, et adaptées 
à sa complexité, aux pratiques et au nombre d’utilisateurs concernés. Tout fournisseur de ce type 
d’équipement, répondant à un appel d’offre, doit intégrer dans son offre un programme et une durée de 
formation suffisante des professionnels. Ces formations doivent être rendues obligatoires, tracées et évaluées 
avec des supports de formation remis aux référents locaux.', 'Qualifications - Nouveau dispositif médical');
INSERT INTO public.quaad_description VALUES (299, 281, 'FR', 'Les délégations d''activité s''inscrivent dans des processus respectant la règlementation en vigueur.', 'Qualifications - Délégations d''activité');
INSERT INTO public.quaad_description VALUES (301, 283, 'FR', 'Document décrivant les activités (catégories de types d’actes d’IM) assurées par la structure d’IM.', 'Habilitation - Activités');
INSERT INTO public.quaad_description VALUES (302, 284, 'FR', 'Fiches de poste qui décrivent les compétences spécifiques, responsabilités et tâches des catégories de 
professionnel nécessaires à la réalisation de chacune de ces activités, et le temps de tutorat nécessaire 
pour l’habilitation du professionnel nouvellement recruté. L’ensemble de ces fiches permet de rechercher 
l’adéquation entre les effectifs et les activités assurées. Ces fiches sont le support des habilitations 
individuelles.', 'Fiches de poste');
INSERT INTO public.quaad_description VALUES (303, 285, 'FR', 'Documents attestant les qualifications du professionnel.', 'Habilitation - Qualification');
INSERT INTO public.quaad_description VALUES (304, 286, 'FR', 'Formation initiale comprenant les diplômes et la formation continue conformément à la réglementation 
en vigueur. La structure d’IM s’assure du respect des titres et diplômes des professionnels travaillant dans 
la structure d’IM en fonction de la réglementation nationale en vigueur.', 'Habilitation - Formation initial et continue');
INSERT INTO public.quaad_description VALUES (305, 287, 'FR', 'Validation des compétences acquises par l’expérience en fonction de la règlementation en vigueur.', 'Habilitation - Validation des compétences acquises');
INSERT INTO public.quaad_description VALUES (306, 288, 'FR', 'Documents d’habilitation pour chaque professionnel listant les postes et activités sur lesquels il peut être 
affecté. Des habilitations spécifiques peuvent être nécessaires.', 'Habilitation - Listing des postes et activités');
INSERT INTO public.quaad_description VALUES (333, 318, 'FR', 'Une procédure documentée décrit l’organisation et la mise en œuvre du nettoyage régulier des DM tels que 
les tables télécommandées, le lit et le statif du scanner, les antennes d’IRM, ….<br>
Une procédure documentée décrit l’organisation et la mise en œuvre du nettoyage et de la désinfection des 
sondes d’échographie, conformément aux règles de bonnes pratiques en vigueur.<br>
Une procédure documentée décrit l’organisation et la mise en œuvre du nettoyage et de la désinfection du 
petit matériel réutilisable tels que: boîtes à hystérographie, canules de lavements, matériels sensibles à usage 
multiples.<br>
Le type et la périodicité du nettoyage sont adaptés au mode d’utilisation du matériel et des équipements 
d''imagerie.<br>
Le matériel nécessaire au respect des règles d’hygiène est disponible, suffisant et adapté.<br>
Il existe un suivi et une traçabilité du matériel médico-chirurgical désinfecté ou stérilisé.<br>
Il existe un contrôle formalisé des stocks du matériel stérile et des dates de péremption des consommables à usage unique, notamment des produits de nettoyage et de désinfection (vérification des dates de péremption).', 'Nettoyage des DM');
INSERT INTO public.quaad_description VALUES (307, 289, 'FR', '- L’intégration des professionnels nouveaux arrivants et des personnes en formation (médecins, étudiants 
en médecine, étudiants manipulateurs en électroradiologie médicale, etc.) est organisée par la structure 
d’IM, s’il y a lieu avec les sites concernés de l''établissement de santé. (et ce, pour les établissements de 
santé, en articulation les modalités générales d’intégration propres au site).<br> 
- Les personnes en formation sont encadrées en permanence par des seniors. Un programme pédagogique 
spécifique est élaboré en lien avec les structures de formation concernées (universités, écoles, …). Leur 
rôle et leurs responsabilités dans la structure d’IM sont définis. Le niveau de délégation est précisé par le 
responsable de la structure d’IM conformément à la règlementation nationale en vigueur. La progression 
de chaque personne en formation est suivie et tracée.', 'Nouveaux arrivants et personnes en formation');
INSERT INTO public.quaad_description VALUES (310, 293, 'FR', 'Les équipements et matériels nécessaires pour assurer une prise en charge de qualité, sécurisée et adaptée 
aux actes médicaux sont présents dans la structure d’IM, ainsi que pour le travail des professionnels.<br> 
La structure d’IM dispose d’un inventaire écrit de ses équipements, matériels et logiciels. Le choix des 
matériels et équipements répond à des cahiers des charges définis en fonction de l’état de l’art, des activités 
médicales envisagées et leurs performances. Ils sont établis avec les professionnels concernés par l''utilisation 
de ces matériels et équipements.', 'Dispositifs médicaux (DM), autres produits de santé et équipements non DM');
INSERT INTO public.quaad_description VALUES (337, 324, 'FR', 'Le respect de la règlementation en matière de radioprotection des patients et des travailleurs est un prérequis.<br> 
Une procédure documentée décrit la mise en œuvre du principe de justification.<br> 
Une procédure documentée décrit la mise en œuvre du principe d’optimisation.<br> 
Une procédure documentée décrit la conduite à tenir en cas d’exposition accidentelle d''une femme enceinte.<br> 
Une procédure documentée décrit la conduite à tenir en cas d''examen avec rayons X à réaliser chez une femme enceinte ou susceptible de l''être. <br>
Une procédure documentée décrit la conduite à tenir en cas de travailleuse enceinte.<br> 
Une procédure documentée décrit la gestion des événements significatifs de radioprotection.', 'Gestion la radioprotection des travailleurs et des patients,  conformément à la règlementation en vigueur');
INSERT INTO public.quaad_description VALUES (339, 327, 'FR', 'Le respect de la règlementation en matière de magnétoprotection est un prérequis.<br> 
Une procédure documentée décrit les règles de protection contre les champs électromagnétiques.<br> 
Les équipements des zones à risque sont magnéto-compatibles tels que brancards et fauteuils roulants amagnétiques, pieds à perfusion non ferromagnétiques, ….<br> 
La recherche de contre-indication est systématiquement faite pour toute personne susceptible d’entrer dans la salle de l’aimant. <br>
<b>EXEMPLES</b> Patient, soignant, accompagnant, personnel de nettoyage, personnel technique.<br> 
Une procédure documentée décrit la conduite à tenir en cas d''IRM à faire à un patient porteur d''un pacemaker.', 'Sécurité des professionnels et des patients en IRM');
INSERT INTO public.quaad_description VALUES (318, 301, 'FR', 'Les systèmes d’information de la structure d’IM, DM ou non, répondent aux spécifications et obligations 
préconisées en matière de données de santé et des réglementations en vigueur. Ils disposent d’une 
organisation pour garantir leur fonctionnement adapté, en particulier leur fiabilité pour la prise en charge des 
patients et leur maintien en conditions opérationnelles et de sécurité.', 'Respect des obligations en matière de données de santé');
INSERT INTO public.quaad_description VALUES (319, 304, 'FR', 'L’assurance qualité, sécurité et fiabilité des systèmes numériques est mise en œuvre selon la réglementation 
en vigueur.', 'Assurance qualité, sécurité et fiabilité en vigueur.');
INSERT INTO public.quaad_description VALUES (320, 305, 'FR', 'La structure d’IM se dote également d’une organisation visant à garantir la sécurité des accès à ses logiciels 
métiers et aux données personnelles des patients, avec une authentification adaptée des accès.<br>Les 
habilitations d’accès sont définies selon la qualité des professionnels concernés. Les connexions sont tracées 
et accessibles a posteriori.', 'Sécurité des accès aux logiciels métiers et aux données patients');
INSERT INTO public.quaad_description VALUES (315, 298, 'FR', 'La structure d’IM dispose d’une politique de sécurité et de sûreté des systèmes d’information.<br>En 
établissement de santé, celle-ci est intégrée à la politique générale de l''établissement de santé.<br>L’organisation 
de la structure d’IM permet de garantir la disponibilité, l''intégrité, la confidentialité des données personnelles 
des patients, des équipements numériques nécessaires à la prise en charge des patients et des systèmes 
d’information de gestion des ressources humaines, selon la réglementation en vigueur.', 'Politique de sécurité et de sûreté');
INSERT INTO public.quaad_description VALUES (317, 300, 'FR', 'Hors établissement de santé, un correspondant à la sécurité numérique ou un délégué à la protection des 
données est nommé par le responsable de la structure d’IM.<br>En établissement de santé, le délégué à la 
protection des données de l''établissement travaille avec un correspondant de la structure d''IM. Il dispose des 
compétences nécessaires et des connaissances actualisées. Il est garant de la mise en œuvre des mesures de 
sécurité numérique, notamment par des actions de sensibilisation et de formation des professionnels.', 'Correspondant à la sécurité numérique');
INSERT INTO public.quaad_description VALUES (314, 297, 'FR', 'New point', '3.4. Les systèmes d''information');
INSERT INTO public.quaad_description VALUES (335, 321, 'FR', 'Une procédure documentée décrit l’organisation et la mise en œuvre de la gestion des déchets et rejets de la 
structure d’IM pour lutter contre les infections.<br> 
Les règles de gestion des déchets et rejets sont conformes à la réglementation en vigueur.<br> 
Les déchets sont triés :<br> 
- déchets ménagers ordinaires recyclables ou non,<br> 
- déchets d''activité de soins à risque infectieux,<br> 
- déchets piquants et coupants,<br> 
- déchets à filière d''élimination particulière : films radio, résidus des récupérateurs d''argent, déchets d’équipements électriques et électroniques, cartouches d’encre, toners,….,<br> 
Pour prévenir les risques de contamination, les déchets d''activité de soins, (seringues, pansements, compresses, déchets piquants et coupants, petit matériel médical) suivent un circuit de tri, de stockage et d''élimination particulier distinct de celui des déchets ménagers ordinaires :<br> 
- piquants et coupants dans des containers spéciaux,<br> 
- sacs poubelles reconnaissables (une couleur particulière),<br> 
- stockage dans un endroit isolé,<br> 
- filière spéciale de transport et de traitement par un organisme spécialisé,<br> 
- certificat de collecte et de destruction.<br>', 'Prise en charge des déchets et rejets');
INSERT INTO public.quaad_description VALUES (341, 329, 'FR', 'New point', '4. Parcours du patient pour la réalisation d''un acte d''IM');
INSERT INTO public.quaad_description VALUES (312, 295, 'FR', 'Les DM et les médicaments adaptés aux actes d’IM sont choisis par la structure d''IM en fonction des besoins et d''autres critères prédéfinis. <br>
Leur approvisionnement et leur accessibilité par les professionnels est assuré y compris la nuit et le week-end. <br>
Le stockage, la traçabilité et les règles d''élimination des produits de santé sont organisés conformément à la réglementation en vigueur et aux préconisations. <br>
<b>EXEMPLES</b> Conditions de température, luminosité, sécurisation des accès. <br>
Ces règles de stockage sont appliquées pour tous les produits de santé: vérification des lots, des dates de péremption, contrôle des conditions de stockage. <br>
<b>EXEMPLE</b> Température des réfrigérateurs. <br>
La matériovigilance et la pharmacovigilance sont assurées. Une procédure formalise les responsabilités respectives et les règles de fonctionnement entre la structure d’IM et la pharmacie si nécessaire.', 'Les produits de santé (médicaments, dispositifs médicaux (DM) implantables ou non)');
INSERT INTO public.quaad_description VALUES (313, 296, 'FR', 'La structure d’IM met à disposition les moyens de communication entre professionnels de santé et avec les patients, entre autres à une bonne prise en charge des urgences, les moyens de lecture et de traitement des images tels que des postes informatiques avec écrans adaptés à la résolution et au contraste requis selon le 
type d’imagerie analysé et des logiciels adaptés.<br>
Dans les établissements de santé, le système d’information ne dépend pas que de l’IM. <br>
<b>EXEMPLE</b> SIH et son interface indispensable. <br>
La structure d’IM met à disposition tout autre matériel nécessaire à l’activité. <br>
<b>EXEMPLES</b> Bureau, chaises, tables de réunion.', 'Les équipements ou matériels non DM');
INSERT INTO public.quaad_description VALUES (321, 306, 'FR', 'Les éventuels fichiers complémentaires de bases de données patients sont sécurisés et déclarés 
conformément à la règlementation en vigueur.', 'Bases de données');
INSERT INTO public.quaad_description VALUES (322, 307, 'FR', 'La structure est en capacité d’échanger et de partager ses images selon les standards de qualité.<br>Ces échanges 
se font dans le respect de la règlementation en vigueur sur la protection des données et avec le respect du 
consentement du patient.<br>
La diffusion des images et des comptes rendus est assurée de façon maitrisée à la fois dans les secteurs de 
soins et vers les patients et les professionnels de santé extérieurs à la structure d’IM qui ont besoin d’accéder 
à ces données. Les mises en partage et les échanges de données personnelles confidentielles sont sécurisées 
selon des règles définies, conformes à la réglementation, connues des professionnels concernés et réellement 
mises en œuvre.', 'Echange et partage des images et des comptes rendus');
INSERT INTO public.quaad_description VALUES (323, 308, 'FR', 'Dans les établissements de santé, le système d''information de la structure d''IM est intégré dans celui de 
l''établissement; en lien étroit avec la direction des systèmes d''information.', 'Intégration du système d''information de la structure d''IM');
INSERT INTO public.quaad_description VALUES (324, 309, 'FR', 'En cas d’interopérabilité avec une ou plusieurs structures extérieures, la structure d''IM s’assure d’une 
organisation garantissant la sécurité des données.', 'Interopérabilité avec des structures extérieures');
INSERT INTO public.quaad_description VALUES (325, 310, 'FR', 'Un plan de continuité et de reprise de l’activité numérique est défini et appliqué. Les procédures de sauvegarde 
et de restauration des données sont testées périodiquement. Un fonctionnement en mode dégradé est prévu 
et testé périodiquement.', 'Plan de continuité');
INSERT INTO public.quaad_description VALUES (326, 311, 'FR', 'Les données des patients sont sauvegardées et archivées et leur confidentialité est respectée conformément à 
la règlementation en vigueur.', 'Sauvegarde et archivage des données patients');
INSERT INTO public.quaad_description VALUES (327, 312, 'FR', 'Dès lors qu''il existe un dossier médical partagé accessible du patient, son contenu est pris en compte à toutes 
les étapes de sa prise en charge et le compte-rendu de l''examen y est intégré.', 'Dossier médical partagé');
INSERT INTO public.quaad_description VALUES (328, 313, 'FR', 'L''accès par l''extérieur au système informatique pour réaliser des maintenances ou pour travailler hors de la 
structure d’IM est protégé selon les bonnes pratiques en vigueur.<br>Le système d’information est protégé contre 
les intrusions. Ces conditions de sécurité sont vérifiées et testées selon une méthode éprouvée et une 
périodicité définie au sein de la structure d’IM ou de l’établissement de santé dont elle dépend.<br>La structure 
d’IM s’engage à réaliser des audits d''intrusion conformément à la réglementation en vigueur et à mettre en 
œuvre les actions correctives qui s''avèreraient nécessaires.', 'Accès extérieur au système informatique');
INSERT INTO public.quaad_description VALUES (329, 314, 'FR', 'New point', '3.5. La maitrise de l''hygiène');
INSERT INTO public.quaad_description VALUES (331, 316, 'FR', 'Une procédure documentée décrit l’organisation de la prise en charge des patients infectés et/ou 
immunodéprimés, selon les types de germes.<br> 
Dans les établissements de santé, une procédure documentée décrit le circuit d’information qui permet aux 
services cliniques d’informer la structure d’IM sur l’état de contagiosité et/ou d’immunodépression d’un 
patient.<br>
Une procédure documentée décrit la conduite à tenir en cas d’exposition au risque biologique d’un 
professionnel.', 'Prise en charge des patients infectés et/ou immunodéprimés');
INSERT INTO public.quaad_description VALUES (330, 315, 'FR', 'Une procédure documentée décrit la technique et les indications de l’hygiène des mains (lavage, friction par 
solution hydroalcoolique).<br>
Une procédure documentée décrit la technique des autres gestes aseptiques réalisés dans la structure d’IM 
tels que les conditions de réalisation technique des ponctions vasculaires, conditions de réalisation technique 
d’un geste aseptique comme une biopsie ou une ponction articulaire, la préparation cutanée du patient à la 
réalisation d’un geste aseptique, la préparation du radiologue à la réalisation d’un geste aseptique, la 
préparation du matériel nécessaire à la réalisation d’un geste aseptique.', 'Maîtrise de l’hygiène liée aux actes d’imagerie et aux soins fournis');
INSERT INTO public.quaad_description VALUES (332, 317, 'FR', 'Une procédure documentée décrit l’organisation et la mise en œuvre de l’entretien des locaux de la structure 
d’IM.<br>
Le mode et la périodicité du nettoyage sont adaptés à la fonction du local et au flux de patients.<br> 
La propreté des locaux est contrôlée régulièrement.<br>
Les conditions du contrôle de l’état de propreté des locaux sont définies et mises en œuvre : mode de contrôle, 
fréquence, responsabilité.', 'Entretien et le nettoyage des locaux');
INSERT INTO public.quaad_description VALUES (334, 319, 'FR', 'Une procédure documentée décrit l’organisation et la mise en œuvre de la gestion du linge pour lutter contre 
les infections :<br>
- circuits linge propre et linge sale distincts,<br> 
- règles de stockage et de transport du linge propre et du linge sale,<br> 
- règles de traitement du linge sale,<br> 
- conditions du contrôle de l’état du linge propre.', 'Gestion du linge');
INSERT INTO public.quaad_description VALUES (336, 323, 'FR', 'New point', '3.6. Radioprotection');
INSERT INTO public.quaad_description VALUES (338, 325, 'FR', 'New point', '3.7. Sécurité en IRM');
INSERT INTO public.quaad_description VALUES (340, 328, 'FR', 'L’identité du patient est vérifiée à chaque étape de sa prise en charge.<br> 
Une procédure documentée décrit les règles d’organisation de l’identitovigilance des patients. Ces règles sont établies par la structure d''IM et/ou par la cellule d''identitovigilance dans les établissements de santé.', 'La structure d''IM assure l''identitovigilance');
INSERT INTO public.quaad_description VALUES (342, 330, 'FR', 'Chaque demande d’acte d’IM est écrite et authentifiée par le médecin demandeur. La structure d’IM maîtrise la validation de cette demande : <br>
- le contenu attendu de la demande précise : <br>
- sa date (et l''heure si nécessaire) ;<br> 
- les données administratives du patient ;<br> 
- les nom, prénom et fonction du demandeur ;<br> 
- l’acte d’IM attendu avec la région anatomique concernée ;<br> 
- le motif (histoire clinique, tous renseignements cliniques pertinents) et la finalité (question posée) de l’acte d’IM, les éventuelles circonstances particulières ;<br> 
<b>EXEMPLES</b> Grossesse, handicap. <br>
- les facteurs de risques et les contre-indications ; <br>
- l''historique des actes d''IM ; <br>
- au besoin le degré d’urgence ; <br>
- au besoin la date souhaitée de réalisation de l’acte d’IM demandé. <br>
Les règles de validation de cette demande s''appuient sur le principe de justification et prennent en compte : <br>
- le contexte clinique, les facteurs de risque et les actes d’IM antérieurs ; <br>
- l’accessibilité à la bonne modalité d’IM ; <br>
- l’appréciation de la demande par un médecin de la structure d’IM. Celui-ci valide, refuse ou propose une substitution par un autre acte d’IM plus approprié.<br> Il informe le patient et le médecin demandeur des motifs de la substitution ; <br>
- l’éventuelle nécessité d’une validation pluri professionnelle au cours d’une réunion ; <br>
- la nécessité d’une consultation avant réalisation d''un acte d''imagerie nterventionnelle ; <br>
- la nécessité d’une consultation pré anesthésique en tant que de besoin ; <br>
- la possibilité de circuits courts de validation des demandes pour traiter des demandes urgentes ; <br>
- la prescription si nécessaire d''examens préalables (biologie, autre examen d''imagerie) et/ou d’un médicament (produit de contraste, autre médicament nécessaire à la réalisation de l’examen). <br>
Certaines demandes peuvent devoir être complétées par des échanges avec le demandeur d’examen et/ou le patient.', 'Demande d''acte d''IM et validation');
INSERT INTO public.quaad_description VALUES (343, 332, 'FR', 'New point', '4.2. Information du patient et prise de rendez-vous');
INSERT INTO public.quaad_description VALUES (344, 333, 'FR', 'L''information du patient se fait selon les règles de la déontologie médicale et selon la règlementation en vigueur. <br>
L''information du patient, le recueil de son consentement, le respect du secret professionnel, et des règles de partage de l’information entre les professionnels de santé et les autres professionnels concourant à sa prise en charge au sein de la structure d’imagerie, sont conformes aux dispositions règlementaires en vigueur. <br>
Le patient est informé de manière claire, loyale et appropriée sur l’acte d’IM prévu, ses objectifs, sa préparation, son déroulement, son suivi, ses éventuels risques et les manifestations qu’il lui faudrait signaler, les risques qu’il prendrait dans l’hypothèse où il refuserait l’acte d’IM, le tarif de l’acte d’IM et l’éventuel reste à charge. <br>
Hors urgence vitale, le consentement du patient est recherché avant la réalisation de l’acte d’IM conformément à la réglementation en vigueur. <br>
Les gestes d''imagerie interventionnelle qui le justifient sont précédés d''une consultation.<br> 
Le patient est informé de son droit à refuser cet acte d’IM, ou encore à demander un temps de réflexion supplémentaire. <br>
Il est informé de la façon de joindre la structure d’IM dans l’hypothèse où il en aurait besoin. <br>
Les mineurs ou majeurs protégés reçoivent une information adaptée à leur niveau de compréhension et participent à la prise de décision les concernant ; le consentement requis est celui des titulaires de l''autorité.', 'Information du patient');
INSERT INTO public.quaad_description VALUES (345, 334, 'FR', 'L''organisation mise en place par la structure d’IM pour l’attribution des rendez-vous comprend : <br>
- le recueil de l’identité du patient (dans le respect des règles d’identitovigilance), et autres données utiles (adresse, …) ; <br>
- le recueil de l’identité du demandeur ; <br>
- la recherche d’éventuels facteurs de risque et de contre-indications ; <br>
- l’attribution d’un rendez-vous en prenant en compte le degré d’urgence ;<br> 
- la délivrance des informations sur les bénéfices et risques de l’acte d’IM, ainsi que sur les aspects pratiques ; <br>
<b>EXEMPLES</b> Préparation, déroulement et durée prévisible de l''acte d’IM, consignes post-acte d’IM selon des modes d’information adaptés au patient. <br>
- la recherche d’actes d’IM antérieurs et pertinents qu’il conviendra, dans la mesure du possible, d’avoir à disposition lors de la réalisation de l’acte d’IM et de son interprétation sous réserve du consentement du patient ; <br>
- s’il y a lieu, la remise au patient d’ordonnance ; <br>
<b>EXEMPLE</b> Pour réaliser des examens de biologie médicale préalables, pour l’achat d’un produit de contraste. <br>
- la délivrance d’informations autres que médicales ;<br>
<b>EXEMPLE</b> Information sur le règlement et la prise en charge financière des actes, reste à charge pour le patient, conditions d’accessibilité du site. <br>
- s’il y a lieu, la convocation à un rendez-vous de consultation préalable ; <br>
<b>EXEMPLES</b> Consultation avant la réalisation d''un acte d''imagerie interventionnelle, pré anesthésique. <br>
- en cas de besoin, l''organisation de l’accueil du patient en post-acte d''IM dans une structure adaptée, sur place ou par convention. <br>
L’ensemble de ce processus respecte les exigences de confidentialité des informations échangées et le secret professionnel.', 'Prise de rendez-vous');
INSERT INTO public.quaad_description VALUES (347, 336, 'FR', 'New point', '4.3. Arrivée du patient');
INSERT INTO public.quaad_description VALUES (311, 294, 'FR', 'Chaque DM d’imagerie est choisi en fonction du projet médical et des actes que la structure d’IM réalise. <br>
L’acquisition d’un nouveau DM d’imagerie est associée à un plan de formation adapté au besoin de la structure et intégré dans le cahier des charges. <br>
Lors de son installation, chaque nouveau DM d’imagerie fait l’objet d’une recette afin de s’assurer qu''il corresponde bien aux descriptifs du contrat d’achat ou de location et qu''il réponde aux mesures de sécurité. <br>
Selon les besoins, cette recette est réalisée avec le physicien médical et/ou le service biomédical. L''appui du responsable de sécurité des systèmes d''information (RSSI) peut également s''avérer nécessaire. <br>
Les démarches administratives relatives à ces DM d’imagerie sont réalisées conformément à la réglementation en vigueur. <br>
La structure d’IM met en œuvre le contrôle qualité interne et externe de ses DM d’imagerie conformément à la réglementation en vigueur. <br>
La structure d’IM a un programme documenté de maintenance préventive qui, au minimum, observe les instructions du fabricant, ainsi que de maintenance curative conformément à la réglementation en vigueur. Le matériel est entretenu dans un état de fonctionnement exempt de danger et en état de marche. Un registre 
sécurité/qualité/maintenance trace les pannes et toutes les opérations de maintenance et les contrôles de qualité pour chaque DM d’imagerie, selon la réglementation en vigueur. <br>
Une procédure documentée décrit la conduite à tenir en cas de panne, lors des maintenances et changements de version de logiciel des DM d’imagerie. Cette procédure est connue de tous les professionnels concernés.<br>', 'Les DM d’imagerie');
INSERT INTO public.quaad_description VALUES (346, 335, 'FR', 'La structure d’IM met en place une organisation pour l’accueil du patient qui comprend : <br>
- un circuit adapté pour les demandes urgentes, les patients sous main de justice, les patients nécessitant des mesures d’isolement infectieux ; <br>
- l’accueil des personnes qui nécessitent une prise en charge particulière est formalisé ; <br>
<b>EXEMPLES</b> Enfants, femmes enceintes, personnes en situation de handicap, personnes âgées et détenus. <br>
- le respect de l''intimité du patient, de sa dignité, de sa sécurité et de la confidentialité qui lui est due ; <br>
- la vérification de l’identité du patient : identitovigilance (recherche des homonymies notamment) ;<br> 
- dans les cas où une consultation avant réalisation d''un acte d''imagerie interventionnelle a été nécessaire, la vérification de la validation de l’indication de l’acte et de la technique utilisée par des praticiens compétents ; <br>
- dans les cas où une consultation pré-anesthésique a été nécessaire, la vérification de l’accord de l’anesthésiste pour l’acte ; <br>
- dans les cas où un bilan biologique a été nécessaire, la vérification des résultats des examens ; <br>
- dans le cas où une préparation spécifique du patient a été nécessaire, la vérification du respect de ces modalités de préparation avant l’acte d’IM ; <br>
<b>EXEMPLES</b> Arrêt ou substitution d’un traitement avant l’acte d’IM, régime spécifique. <br>
- la validation de la bonne compréhension du patient pour l’acte prévu, de sa durée prévisible, de l’absence de contre-indication formelle, et la vérification de la prise en compte d’éventuels facteurs de risque (notamment grossesse) ; <br>
- le recueil du consentement éclairé du patient ; <br>
- l''information du patient de la possibilité qu''il a de recevoir toute information dont le résultat de l''examen lors d''un entretien avec le médecin d''IM sur simple demande ; <br>
- l’installation du patient en attente de l’acte d’IM ; son information régulière en cas de délai d''attente anormalement prolongé ; <br>
- la seconde vérification de l’identité du patient lors de sa prise en charge pour sa préparation immédiatement avant l’acte d’IM ; <br>
- la préparation du patient et le respect de son confort tout au long de sa prise en charge, avant, pendant et après la réalisation de l’acte d’IM à proprement parler ; <br>
<b>EXEMPLES</b> Déshabillage, injection, sédation. <br>
- la sécurité des biens du patient est assurée tout au long de sa prise en charge.<br>', 'Arrivée du patient dans la structure d’IM');
INSERT INTO public.quaad_description VALUES (308, 291, 'FR', 'La structure d’IM détermine, fournit et entretient les locaux nécessaires pour l’obtention de la qualité et de la sécurité des actes d’IM qu’elle délivre, conformément à la réglementation en vigueur.<br>
Les locaux de la structure d’IM et leur agencement sont en adéquation avec les activités d’IM qui y sont réalisées, proportionnés aux flux de patients et dimensionnés pour répondre au besoin de confidentialité et d’espace lors des différentes situations cliniques concernées.<br> 
<b>EXEMPLES</b> Invalidité, alitement, urgence, trouble cognitif.<br> 
Un espace adapté à la réalisation de chacune de ces activités est défini afin de garantir la qualité, la sécurité et l’efficacité des actes d’IM offerts aux patients, ainsi que la santé et la sécurité des professionnels de la structure d’IM.<br>
La structure d’IM répond aux exigences d’hygiène et de sécurité adaptées en fonction du type d’acte réalisé, d’accessibilité, de confidentialité et de respect de l’intimité ainsi qu’aux obligations réglementaires en vigueur en matière de sécurité des établissements recevant du public (notamment sécurité incendie et sécurité électrique).<br>
L’aménagement des locaux prend en compte les besoins de régulation thermique, à la fois pour les patients souvent dévêtus et pour les professionnels, de ventilation et d’éclairage (notamment dans les zones d’interprétation des examens). 
La structure d’IM respecte en outre la règlementation en vigueur concernant l’aménagement et l''implantation des installations. <br>
La structure d’IM comprend : <br>
- des accès adaptés à la situation du patient et s''il y a lieu différentiés selon les catégories de patients ; <br>
<b>EXEMPLES</b> Patients valides ou couchés, consultants ou hospitalisés. <br>
- un espace d’accueil du public qui assure la confidentialité des patients et, le cas échéant, de leur accompagnant ; <br>
- des espaces d’attente assurant leur confort et adaptés ; <br>
- des espaces pour la réalisation des actes d’IM avec notamment des salles d’examen, des salles de préparation et de surveillance des patients, des salles d’interprétation… ; <br>
- des espaces distincts et sécurisés pour le stockage ; <br>
<b>EXEMPLES</b> Documents, médicaments. <br>
- un local de gestion des déchets ; <br>
- un espace de bureaux ; <br>
- l’accès à un (ou à des) espace(s) de réunion, qui permettent l’étude des dossiers et la tenue des réunions pluridisciplinaires ; <br>
- un espace pour les professionnels, proportionnel à la taille de l’équipe et comprenant des sanitaires, des vestiaires, un espace de repos, et éventuellement, en fonction des horaires de travail, un espace de repas et de douche ; <br>
- des signalétiques attendues conformes aux règlementations nationales en vigueur. <br>
Lors des périodes de fermeture et aux heures de fonctionnement partiel, l’accès aux locaux est, sécurisé et limité aux personnes autorisées. Des mesures sont prises pour maîtriser les risques de vol et de détérioration. <br>
L''approvisionnement énergétique et télématique offre des conditions de fonctionnement adaptées. <br>
<b>EXEMPLES</b> Onduleur, débit internet, accès téléphonique.', 'Locaux et conditions environnementales');
INSERT INTO public.quaad_description VALUES (348, 337, 'FR', 'New point', '3.8. Identitovigilance');


--
-- TOC entry 5683 (class 0 OID 25346)
-- Dependencies: 279
-- Data for Name: quaad_nameinscope; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.quaad_nameinscope VALUES ('institution', 'name');
INSERT INTO public.quaad_nameinscope VALUES ('device', 'name');
INSERT INTO public.quaad_nameinscope VALUES ('staff_member', 'lastname||'' ''||firstname');
INSERT INTO public.quaad_nameinscope VALUES ('examlist', 'modality||'' - ''||nameid');
INSERT INTO public.quaad_nameinscope VALUES ('department', 'name');
INSERT INTO public.quaad_nameinscope VALUES ('v_device_plus_deviceinstallation_instid', 'name');
INSERT INTO public.quaad_nameinscope VALUES ('v_device_plus_deviceinstallation_devid', 'name');


--
-- TOC entry 5684 (class 0 OID 25351)
-- Dependencies: 280
-- Data for Name: quaad_point; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.quaad_point VALUES (4, 1, 1, 1, -1, -1, 1, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (5, 1, 1, 1, -1, -1, 2, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (6, 1, 1, 1, -1, -1, 3, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (1, 1, 1, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (7, 1, 1, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (8, 1, 1, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (9, 1, 1, 4, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (10, 1, 1, 5, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (11, 1, 1, 6, -1, -1, 1, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (12, 1, 1, 6, -1, -1, 2, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (13, 1, 1, 7, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (14, 1, 2, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (15, 1, 2, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (16, 1, 2, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (17, 1, 2, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (18, 1, 2, 4, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (19, 1, 3, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (20, 1, 3, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (21, 1, 3, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (22, 1, 3, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (23, 1, 3, 4, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (24, 1, 3, 5, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (25, 1, 3, 6, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (26, 1, 4, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (27, 1, 4, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (28, 1, 4, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (29, 1, 4, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (30, 1, 5, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (31, 1, 5, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (32, 1, 5, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (33, 1, 5, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (34, 1, 5, 4, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (35, 1, 5, 5, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (36, 1, 5, 6, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (37, 1, 5, 7, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (38, 1, 5, 8, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (39, 1, 6, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (40, 1, 6, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (41, 1, 6, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (42, 1, 6, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (43, 1, 6, 4, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (44, 1, 6, 5, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (45, 1, 7, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (46, 1, 7, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (47, 1, 7, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (48, 1, 8, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (49, 1, 8, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (50, 1, 8, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (51, 1, 8, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (52, 1, 9, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (53, 1, 9, 1, -1, -1, 1, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (54, 1, 9, 1, -1, -1, 2, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (55, 1, 9, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (56, 1, 9, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (57, 1, 9, 4, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (58, 1, 9, 5, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (59, 1, 9, 6, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (60, 1, 10, -1, -1, -1, 0, true, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (61, 1, 10, 1, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (62, 1, 10, 2, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (63, 1, 10, 3, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (64, 1, 10, 4, -1, -1, 1, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (65, 1, 10, 4, -1, -1, 2, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (66, 1, 10, 4, -1, -1, 3, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (67, 1, 10, 4, -1, -1, 4, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (68, 1, 10, 5, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (69, 1, 10, 6, -1, -1, 0, false, '2019-01-07', NULL, 1);
INSERT INTO public.quaad_point VALUES (84, 1, 1, 6, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (85, 1, 1, 6, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (86, 1, 1, 6, -1, -1, 3, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (95, 1, 2, 2, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (74, 1, 1, 2, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (72, 1, 1, 1, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (73, 1, 1, 1, -1, -1, 3, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (78, 1, 1, 3, 1, -1, 3, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (79, 1, 1, 3, 2, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (87, 1, 1, 6, -1, -1, 4, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (96, 1, 2, 2, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (97, 1, 3, -1, -1, -1, 0, true, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (82, 1, 1, 5, -1, -1, 2, false, '2019-01-07', '2019-01-07', 3);
INSERT INTO public.quaad_point VALUES (81, 1, 1, 5, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (88, 1, 1, 7, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (89, 1, 1, 7, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (90, 1, 1, 8, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (91, 1, 1, 8, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (92, 1, 1, 9, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (93, 1, 2, -1, -1, -1, 0, true, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (71, 1, 1, -1, -1, -1, 0, true, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (94, 1, 2, 1, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (99, 1, 3, 2, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (100, 1, 3, 3, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (101, 1, 3, 4, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (102, 1, 3, 5, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (103, 1, 3, 6, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (104, 1, 3, 7, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (105, 1, 3, 8, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (106, 1, 3, 9, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (107, 1, 3, 10, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (75, 1, 1, 2, -1, -1, 2, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (83, 1, 1, 5, -1, -1, 3, false, '2019-01-07', '2019-01-07', 3);
INSERT INTO public.quaad_point VALUES (98, 1, 3, 1, -1, -1, 0, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (70, 1, 1, 1, -1, -1, 1, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (77, 1, 1, 3, 1, -1, 2, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (76, 1, 1, 3, 1, -1, 1, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (109, 1, 4, 1, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (108, 1, 4, -1, -1, -1, 0, true, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (110, 1, 4, 2, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (111, 1, 4, 3, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (112, 1, 4, 4, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (113, 1, 4, 5, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (114, 1, 4, 6, -1, -1, 0, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (115, 1, 4, 7, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (116, 1, 4, 7, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (117, 1, 4, 8, -1, -1, 1, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (118, 1, 4, 8, -1, -1, 2, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (119, 1, 4, 8, -1, -1, 3, false, '2019-01-07', NULL, 3);
INSERT INTO public.quaad_point VALUES (178, 1, 6, 16, -1, -1, 9, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (179, 1, 6, 16, -1, -1, 10, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (180, 1, 6, 16, -1, -1, 11, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (185, 1, 7, 2, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (182, 1, 6, 18, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (181, 1, 6, 17, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (184, 1, 7, 1, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (80, 1, 1, 4, -1, -1, 0, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (122, 1, 4, 11, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (123, 1, 4, 12, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (125, 1, 4, 14, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (126, 1, 4, 15, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (128, 1, 4, 17, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (129, 1, 4, 18, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (130, 1, 4, 19, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (131, 1, 4, 20, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (132, 1, 4, 21, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (183, 1, 7, -1, -1, -1, 0, true, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (146, 1, 5, 7, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (148, 1, 5, 8, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (149, 1, 5, 9, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (152, 1, 5, 12, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (154, 1, 6, 1, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (156, 1, 6, 3, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (157, 1, 6, 4, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (158, 1, 6, 5, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (159, 1, 6, 6, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (163, 1, 6, 10, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (169, 1, 6, 15, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (173, 1, 6, 16, -1, -1, 4, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (174, 1, 6, 16, -1, -1, 5, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (175, 1, 6, 16, -1, -1, 6, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (176, 1, 6, 16, -1, -1, 7, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (177, 1, 6, 16, -1, -1, 8, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (190, 1, 7, 5, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (191, 1, 7, 6, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (194, 1, 7, 9, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (195, 1, 7, 10, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (196, 1, 7, 11, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (197, 1, 7, 12, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (201, 1, 7, 13, -1, -1, 4, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (202, 1, 7, 14, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (205, 1, 7, 14, -1, -1, 4, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (208, 1, 7, 17, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (206, 1, 7, 15, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (207, 1, 7, 16, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (151, 1, 5, 11, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (211, 1, 7, 17, -1, -1, 4, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (124, 1, 4, 13, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (127, 1, 4, 16, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (136, 1, 5, 2, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (137, 1, 5, 2, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (139, 1, 5, 3, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (138, 1, 5, 3, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (140, 1, 5, 4, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (141, 1, 5, 4, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (142, 1, 5, 5, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (143, 1, 5, 5, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (144, 1, 5, 6, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (145, 1, 5, 6, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (147, 1, 5, 7, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (164, 1, 6, 11, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (150, 1, 5, 10, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (167, 1, 6, 13, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (155, 1, 6, 2, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (160, 1, 6, 7, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (161, 1, 6, 8, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (162, 1, 6, 9, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (165, 1, 6, 11, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (170, 1, 6, 16, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (168, 1, 6, 14, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (121, 1, 4, 10, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (172, 1, 6, 16, -1, -1, 3, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (171, 1, 6, 16, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (186, 1, 7, 2, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (188, 1, 7, 4, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (187, 1, 7, 3, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (189, 1, 7, 4, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (198, 1, 7, 13, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (192, 1, 7, 7, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (193, 1, 7, 8, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (199, 1, 7, 13, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (200, 1, 7, 13, -1, -1, 3, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (203, 1, 7, 14, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (204, 1, 7, 14, -1, -1, 3, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (209, 1, 7, 17, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (210, 1, 7, 17, -1, -1, 3, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (133, 1, 5, -1, -1, -1, 0, true, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (120, 1, 4, 9, -1, -1, -1, false, '2019-01-07', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (134, 1, 5, 1, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (268, 1, 11, 4, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (254, 1, 9, 5, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (259, 1, 10, -1, -1, -1, 0, true, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (260, 1, 10, 1, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (261, 1, 10, 2, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (262, 1, 10, 3, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (263, 1, 10, 4, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (264, 1, 11, -1, -1, -1, 0, true, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (166, 1, 6, 12, -1, -1, 0, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (240, 1, 8, 5, -1, -1, 5, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (244, 1, 9, 3, -1, -1, 1, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (245, 1, 9, 3, -1, -1, 2, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (246, 1, 9, 3, -1, -1, 3, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (247, 1, 9, 3, -1, -1, 4, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (248, 1, 9, 3, -1, -1, 5, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (249, 1, 9, 3, -1, -1, 6, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (250, 1, 9, 4, -1, -1, 1, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (251, 1, 9, 4, -1, -1, 2, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (252, 1, 9, 4, -1, -1, 3, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (253, 1, 9, 4, -1, -1, 4, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (255, 1, 9, 6, -1, -1, 1, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (256, 1, 9, 6, -1, -1, 2, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (266, 1, 11, 2, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (233, 1, 8, 3, -1, -1, 0, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (257, 1, 9, 6, -1, -1, 3, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (258, 1, 9, 6, -1, -1, 4, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (153, 1, 6, -1, -1, -1, 0, true, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (228, 1, 8, -1, -1, -1, 0, true, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (241, 1, 9, -1, -1, -1, 0, true, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (242, 1, 9, 1, -1, -1, 0, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (243, 1, 9, 2, -1, -1, 0, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (270, 1, 11, 6, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (135, 1, 5, 1, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (212, 1, 7, 18, -1, -1, 1, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (213, 1, 7, 18, -1, -1, 2, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (214, 1, 7, 18, -1, -1, 3, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (215, 1, 7, 18, -1, -1, 4, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (216, 1, 7, 18, -1, -1, 5, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (217, 1, 7, 18, -1, -1, 6, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (218, 1, 7, 18, -1, -1, 7, false, '2021-09-13', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (219, 1, 7, 18, -1, -1, 8, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (220, 1, 7, 19, -1, -1, 1, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (221, 1, 7, 19, -1, -1, 2, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (222, 1, 7, 19, -1, -1, 3, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (223, 1, 7, 19, -1, -1, 4, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (224, 1, 7, 19, -1, -1, 5, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (225, 1, 7, 19, -1, -1, 6, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (226, 1, 7, 19, -1, -1, 7, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (227, 1, 7, 19, -1, -1, 8, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (229, 1, 8, 1, -1, -1, 1, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (230, 1, 8, 1, -1, -1, 2, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (231, 1, 8, 2, -1, -1, 1, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (232, 1, 8, 2, -1, -1, 2, false, '2021-09-14', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (234, 1, 8, 4, -1, -1, 1, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (235, 1, 8, 4, -1, -1, 2, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (236, 1, 8, 5, -1, -1, 1, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (237, 1, 8, 5, -1, -1, 2, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (238, 1, 8, 5, -1, -1, 3, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (239, 1, 8, 5, -1, -1, 4, false, '2021-09-15', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (265, 1, 11, 1, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (269, 1, 11, 5, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (267, 1, 11, 3, -1, -1, 0, false, '2021-09-16', '2999-12-31', 3);
INSERT INTO public.quaad_point VALUES (273, 1, 3, 1, -1, -1, 0, false, '2023-08-21', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (279, 1, 3, 1, 1, -1, 2, false, '2023-08-21', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (275, 1, 3, 1, 1, -1, 1, false, '2023-08-21', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (280, 1, 3, 1, 1, -1, 3, false, '2023-08-21', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (281, 1, 3, 1, 1, -1, 4, false, '2023-08-21', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (272, 1, 3, -1, -1, -1, -1, true, '2023-08-21', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (283, 1, 3, 1, 2, -1, 1, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (284, 1, 3, 1, 2, -1, 2, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (285, 1, 3, 1, 2, -1, 3, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (286, 1, 3, 1, 2, -1, 4, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (287, 1, 3, 1, 2, -1, 5, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (288, 1, 3, 1, 2, -1, 6, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (312, 1, 3, 4, -1, -1, 12, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (313, 1, 3, 4, -1, -1, 13, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (297, 1, 3, 4, -1, -1, 0, true, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (301, 1, 3, 4, -1, -1, 3, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (304, 1, 3, 4, -1, -1, 4, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (305, 1, 3, 4, -1, -1, 5, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (289, 1, 3, 1, 3, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (294, 1, 3, 3, 1, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (293, 1, 3, 3, -1, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (298, 1, 3, 4, -1, -1, 1, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (300, 1, 3, 4, -1, -1, 2, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (306, 1, 3, 4, -1, -1, 6, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (307, 1, 3, 4, -1, -1, 7, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (308, 1, 3, 4, -1, -1, 8, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (309, 1, 3, 4, -1, -1, 9, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (310, 1, 3, 4, -1, -1, 10, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (311, 1, 3, 4, -1, -1, 11, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (314, 1, 3, 5, -1, -1, -1, true, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (318, 1, 3, 5, 4, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (315, 1, 3, 5, 1, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (316, 1, 3, 5, 2, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (317, 1, 3, 5, 3, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (319, 1, 3, 5, 5, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (321, 1, 3, 5, 6, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (323, 1, 3, 6, -1, -1, -1, true, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (324, 1, 3, 6, -1, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (325, 1, 3, 7, -1, -1, -1, true, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (327, 1, 3, 7, -1, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (329, 1, 4, -1, -1, -1, -1, true, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (330, 1, 4, 1, -1, -1, 0, false, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (332, 1, 4, 2, -1, -1, -1, true, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (333, 1, 4, 2, 1, -1, 0, false, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (334, 1, 4, 2, 2, -1, 0, false, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (291, 1, 3, 2, -1, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (295, 1, 3, 3, 2, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (296, 1, 3, 3, 3, -1, 0, false, '2023-09-28', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (328, 1, 3, 8, -1, -1, 0, false, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (336, 1, 4, 3, -1, -1, -1, true, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (335, 1, 4, 3, -1, -1, 0, false, '2023-09-29', '2999-12-31', 4);
INSERT INTO public.quaad_point VALUES (337, 1, 3, 8, -1, -1, -1, true, '2023-09-29', '2999-12-31', 4);


--
-- TOC entry 5686 (class 0 OID 25362)
-- Dependencies: 282
-- Data for Name: quaadpoint_tag; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.quaadpoint_tag VALUES (257, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (258, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (259, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (260, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (261, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (262, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (263, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (264, '1', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (270, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (271, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (272, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''SOFT''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (273, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (274, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (275, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (276, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (277, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (278, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (279, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (280, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (281, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (282, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (283, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (284, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (285, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (286, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (287, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (288, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (289, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (290, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (291, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (292, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (293, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (294, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (295, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (265, '1', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (266, '1', 0, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (267, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (268, '1', 0, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (269, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (3, '3', -1, 'institution', NULL, -1, NULL, 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (14, '3', 1, 'legaldocument', '', -1, '', 'false', true, 'legaldocument');
INSERT INTO public.quaadpoint_tag VALUES (59, '1', -1, 'institution', '', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (30, '2', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (255, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (256, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (15, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (16, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (17, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (18, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (19, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (20, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (21, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (22, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (23, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (24, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (25, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (28, '6', -1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (31, '4', -1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (32, '4', -1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (34, '2', -1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (36, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (37, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (38, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (40, '7', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (41, '7', -1, 'report', 'and dep_id=___dep_id___  ', -1, 'action', 'false', false, 'action');
INSERT INTO public.quaadpoint_tag VALUES (42, '1', -1, 'report', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'report');
INSERT INTO public.quaadpoint_tag VALUES (44, '1', -1, 'report', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'report');
INSERT INTO public.quaadpoint_tag VALUES (46, '4', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (47, '4', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (48, '4', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (50, '4', 1, 'afcnsend', 'and dep_id=___dep_id___  ', 12, '', 'true', false, 'afcnsend');
INSERT INTO public.quaadpoint_tag VALUES (51, '4', 0, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (52, '1', 0, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (54, '6', 0, 'department', 'and dep_id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (66, '1', 1, 'department', 'and department.id=___dep_id___', 12, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (62, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (63, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (64, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (65, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (81, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (67, '1', 1, 'department', 'and department.id=___dep_id___', 12, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (68, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (69, '1', 1, 'department', 'and department.id=___dep_id___', 12, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (70, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (71, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (72, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (74, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (75, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (76, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (77, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (78, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (79, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (82, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (83, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (80, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (84, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (85, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (88, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (97, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (106, '4', 1, 'scope', '/bquaadril-config.php?standard_version=1', -1, 'scope2', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (61, '1', 1, 'institution', 'and institution.id=___ins_id___', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (1, '3', 1, 'institution', 'and institution.id=___ins_id___', -1, NULL, 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (4, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype!=''US'' and dep_id=___dep_id___  and inst_removed=false', -1, NULL, 'false', false, 'device');
INSERT INTO public.quaadpoint_tag VALUES (8, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype!=''US'' and dep_id=___dep_id___  and inst_removed=false', -1, NULL, 'false', false, 'device');
INSERT INTO public.quaadpoint_tag VALUES (12, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''RI'' and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device');
INSERT INTO public.quaadpoint_tag VALUES (11, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype!=''US'' and dep_id=___dep_id___  and inst_removed=false', -1, '', 'false', false, 'device');
INSERT INTO public.quaadpoint_tag VALUES (26, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (93, '1', 0, 'institution', 'and institution.id=___inst_id___', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (29, '2', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (151, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (33, '4', -1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (35, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (39, '6', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (43, '1', -1, 'report', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'report');
INSERT INTO public.quaadpoint_tag VALUES (45, '4', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (49, '4', -1, 'department', 'and dep_id=___dep_id___  ', -1, '', 'false', false, 'institution');
INSERT INTO public.quaadpoint_tag VALUES (53, '6', 1, 'examlist', 'and id in (select ext_id from tag_link tl  where tag_id in (select tagdepid from v_taglink_instdep vti  where dep_id=___dep_id___) and type=''examlist'') and removed=false', -1, '', 'true', false, 'examlist');
INSERT INTO public.quaadpoint_tag VALUES (58, '4', 0, 'department', 'and dep_id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (60, '2', -1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (73, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (86, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (87, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (89, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (90, '1', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (91, '1', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (92, '1', 0, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, '', 'false', false, 'staff_member');
INSERT INTO public.quaadpoint_tag VALUES (94, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (95, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (96, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (98, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (99, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (100, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (101, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (102, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (103, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (104, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (105, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (107, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (108, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (109, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (110, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (111, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (112, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (113, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (114, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (116, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (117, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (118, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (119, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (120, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (121, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (122, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (123, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (124, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (125, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (126, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (127, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (128, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (129, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (130, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (131, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (132, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (133, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (134, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (135, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (136, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (137, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (138, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (139, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (140, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (141, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (145, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (146, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (147, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (148, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (149, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (150, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (152, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (153, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (154, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (155, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (156, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (157, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (158, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (159, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (160, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (161, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (162, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (163, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (164, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (165, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (166, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (168, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (169, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (170, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (171, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (172, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (173, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (174, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (175, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (176, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (177, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (178, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (179, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (180, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (181, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (182, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (183, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (184, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (185, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (186, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (187, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (188, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (189, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (190, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (191, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (192, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (27, '2', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');
INSERT INTO public.quaadpoint_tag VALUES (144, '1', 1, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (143, '1', 1, 'examlist', 'and id in (select ext_id from tag_link tl  where tag_id in (select tagdepid from v_taglink_instdep vti  where dep_id=___dep_id___) and type=''examlist'') and removed=false', 36, '', 'false', false, 'examlist');
INSERT INTO public.quaadpoint_tag VALUES (142, '1', 1, 'examlist', 'and id in (select ext_id from tag_link tl  where tag_id in (select tagdepid from v_taglink_instdep vti  where dep_id=___dep_id___) and type=''examlist'') and removed=false', -1, '', 'false', false, 'examlist');
INSERT INTO public.quaadpoint_tag VALUES (206, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (207, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (208, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (209, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (210, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (211, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (212, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (213, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (214, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (215, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (202, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (200, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (194, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (196, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (216, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (217, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (218, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (219, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (221, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (222, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (223, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (224, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (225, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (226, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (227, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (228, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (229, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (230, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (231, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (232, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (233, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (234, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (235, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (236, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (237, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (238, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (239, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (240, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (241, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (242, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (243, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (244, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (245, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (246, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (247, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (248, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (249, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (250, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (251, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (252, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (55, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (13, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and (modalitytype=''CT'' OR modalitytype=''MR'' OR modalitytype=''PET'' OR modalitytype=''PET-CT'' OR modalitytype=''PET-IRM'' OR modalitytype=''SPECT-CT'' OR modalitytype=''IRM'') and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device');
INSERT INTO public.quaadpoint_tag VALUES (115, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (167, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (198, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (199, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (197, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (195, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (205, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (204, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (193, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (220, '1', 0, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''SOFT''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (10, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype!=''US'' and dep_id=___dep_id___  and inst_removed=false', -1, 'v_bquaad_deviceinspection', 'true', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (2, '3', 1, 'v_device_plus_deviceinstallation_instid', 'and modalitytype!=''US'' and dep_id=___dep_id___  and inst_removed=false', -1, NULL, 'false', false, 'device_installation');
INSERT INTO public.quaadpoint_tag VALUES (9, '3', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype!=''US'' and dep_id=___dep_id___  and inst_removed=false', -1, NULL, 'false', false, 'device');
INSERT INTO public.quaadpoint_tag VALUES (203, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (201, '1', 1, 'v_device_plus_deviceinstallation_devid', 'and modalitytype=''DEXA''  and dep_id=___dep_id___   and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', 12, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (57, '3', -1, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_maintenance');
INSERT INTO public.quaadpoint_tag VALUES (56, '3', -1, 'v_device_plus_deviceinstallation_devid', 'and dep_id=___dep_id___  and (removeddate is null or removeddate > to_date(''___start_date___'',''YYYY-MM-DD HH24:MI:SS''))', -1, '', 'false', false, 'device_inspection');
INSERT INTO public.quaadpoint_tag VALUES (253, '1', 0, 'department', 'and department.id=___dep_id___', -1, '', 'false', false, 'department');
INSERT INTO public.quaadpoint_tag VALUES (254, '1', 1, 'staff_member', 'and  id in (select staff_id from staff_job where dep_id=___dep_id___)', -1, 'staff_formation', 'false', false, 'staff_formation');


--
-- TOC entry 5688 (class 0 OID 25373)
-- Dependencies: 284
-- Data for Name: quaadpoint_tag_name; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.quaadpoint_tag_name VALUES (1, 'Autorisation de création et d''exploitation', 'FR', 1);
INSERT INTO public.quaadpoint_tag_name VALUES (2, 'PV de réception', 'FR', 2);
INSERT INTO public.quaadpoint_tag_name VALUES (3, 'Service de contrôle physique', 'FR', 3);
INSERT INTO public.quaadpoint_tag_name VALUES (4, 'Marquage CE', 'FR', 4);
INSERT INTO public.quaadpoint_tag_name VALUES (8, 'Test d''acceptation', 'FR', 8);
INSERT INTO public.quaadpoint_tag_name VALUES (9, 'Valeurs de référence', 'FR', 9);
INSERT INTO public.quaadpoint_tag_name VALUES (10, 'Contrôle qualité périodique', 'FR', 10);
INSERT INTO public.quaadpoint_tag_name VALUES (11, 'Présence d''un système indicateur de dose', 'FR', 11);
INSERT INTO public.quaadpoint_tag_name VALUES (12, 'Affichage du débit de dose (Fluoroscopie)', 'FR', 12);
INSERT INTO public.quaadpoint_tag_name VALUES (13, 'Notification d''appareil médical lourd', 'FR', 13);
INSERT INTO public.quaadpoint_tag_name VALUES (14, 'Recommandations de radiologie', 'FR', 14);
INSERT INTO public.quaadpoint_tag_name VALUES (15, 'Vérification du formulaire de demande', 'FR', 15);
INSERT INTO public.quaadpoint_tag_name VALUES (16, 'Réalisation de l''examen le plus approprié', 'FR', 16);
INSERT INTO public.quaadpoint_tag_name VALUES (17, 'Justification de l''utilisation de rayonnement ionisant', 'FR', 17);
INSERT INTO public.quaadpoint_tag_name VALUES (18, 'Contrôle de l''identité du patient', 'FR', 18);
INSERT INTO public.quaadpoint_tag_name VALUES (19, 'Recherche de contre indication', 'FR', 19);
INSERT INTO public.quaadpoint_tag_name VALUES (20, 'Informations données au patient avant examen', 'FR', 20);
INSERT INTO public.quaadpoint_tag_name VALUES (23, 'Informations soins de suivi nécessaires', 'FR', 21);
INSERT INTO public.quaadpoint_tag_name VALUES (24, 'Questions patient / Refus d''examen', 'FR', 22);
INSERT INTO public.quaadpoint_tag_name VALUES (25, 'Disponibilité des coordonnées', 'FR', 23);
INSERT INTO public.quaadpoint_tag_name VALUES (26, 'Respect des directives et procédures', 'FR', 24);
INSERT INTO public.quaadpoint_tag_name VALUES (27, 'Optimisation de qualité d''image clinique pertinente', 'FR', 25);
INSERT INTO public.quaadpoint_tag_name VALUES (28, 'Enregistrement des données obligatoires', 'FR', 26);
INSERT INTO public.quaadpoint_tag_name VALUES (30, 'Garantie qualité et sécurité des examens', 'FR', 28);
INSERT INTO public.quaadpoint_tag_name VALUES (31, 'Formation continue', 'FR', 29);
INSERT INTO public.quaadpoint_tag_name VALUES (32, 'Training nouvelle technique', 'FR', 30);
INSERT INTO public.quaadpoint_tag_name VALUES (33, 'Mesures de protection (rayonnement ionisant)', 'FR', 31);
INSERT INTO public.quaadpoint_tag_name VALUES (34, 'Port du dosimètre', 'FR', 32);
INSERT INTO public.quaadpoint_tag_name VALUES (35, 'Dosimètre supplémentaire (risque ++)', 'FR', 33);
INSERT INTO public.quaadpoint_tag_name VALUES (36, 'Surveillance d''un médecin du travail', 'FR', 34);
INSERT INTO public.quaadpoint_tag_name VALUES (37, 'Conditions optimales de présentation des images', 'FR', 35);
INSERT INTO public.quaadpoint_tag_name VALUES (38, 'Consultation de l''historique patient', 'FR', 36);
INSERT INTO public.quaadpoint_tag_name VALUES (39, 'Identification patient et visite (rapport)', 'FR', 37);
INSERT INTO public.quaadpoint_tag_name VALUES (40, 'Mention obligatoires dans le rapport', 'FR', 38);
INSERT INTO public.quaadpoint_tag_name VALUES (41, 'Concertation avec le référent', 'FR', 39);
INSERT INTO public.quaadpoint_tag_name VALUES (42, 'Prodécure: incidents de sécurité', 'FR', 40);
INSERT INTO public.quaadpoint_tag_name VALUES (43, 'Actions correctives', 'FR', 41);
INSERT INTO public.quaadpoint_tag_name VALUES (44, 'Archivage des documents', 'FR', 42);
INSERT INTO public.quaadpoint_tag_name VALUES (45, 'Confidentialité et accessibilité des documents', 'FR', 43);
INSERT INTO public.quaadpoint_tag_name VALUES (46, 'Conservation des rapports et données dosimétriques', 'FR', 44);
INSERT INTO public.quaadpoint_tag_name VALUES (48, 'Comparaison avec les DRL', 'FR', 45);
INSERT INTO public.quaadpoint_tag_name VALUES (49, 'Action corrective en cas de dépassement de DRL', 'FR', 46);
INSERT INTO public.quaadpoint_tag_name VALUES (51, 'Exposition et grossesse', 'FR', 47);
INSERT INTO public.quaadpoint_tag_name VALUES (52, 'Exposition chez l''enfant', 'FR', 48);
INSERT INTO public.quaadpoint_tag_name VALUES (53, 'Mesures de radioprotection pour accompagnant', 'FR', 49);
INSERT INTO public.quaadpoint_tag_name VALUES (54, 'Exports AFCN', 'FR', 50);
INSERT INTO public.quaadpoint_tag_name VALUES (55, 'Assistance d''un expert en radiophysique', 'FR', 51);
INSERT INTO public.quaadpoint_tag_name VALUES (56, 'Accessibilité des rapports de tests et contrôles', 'FR', 52);
INSERT INTO public.quaadpoint_tag_name VALUES (57, 'Présence et accessibilité des SOP pour tous les examens', 'FR', 53);
INSERT INTO public.quaadpoint_tag_name VALUES (58, 'Populations spécifiques: disponibilité et application des directives', 'FR', 54);
INSERT INTO public.quaadpoint_tag_name VALUES (59, 'Manuel utilisateur', 'FR', 55);
INSERT INTO public.quaadpoint_tag_name VALUES (60, 'Accessibilité calendrier contrôle qualité + résultat', 'FR', 56);
INSERT INTO public.quaadpoint_tag_name VALUES (61, 'Intervention fabricant', 'FR', 57);
INSERT INTO public.quaadpoint_tag_name VALUES (63, 'Equipement de protection individuelle', 'FR', 58);
INSERT INTO public.quaadpoint_tag_name VALUES (64, 'Politique de versioning', 'FR', 59);
INSERT INTO public.quaadpoint_tag_name VALUES (65, 'Qualification personnel', 'FR', 60);
INSERT INTO public.quaadpoint_tag_name VALUES (70, 'Plan stratégique financier service NM', 'FR', 65);
INSERT INTO public.quaadpoint_tag_name VALUES (69, 'Plan stratégique médical service NM', 'FR', 64);
INSERT INTO public.quaadpoint_tag_name VALUES (68, 'Lien missions service NM/hôpital', 'FR', 63);
INSERT INTO public.quaadpoint_tag_name VALUES (71, 'Plan politique service NM', 'FR', 66);
INSERT INTO public.quaadpoint_tag_name VALUES (72, 'Plan politique service NM: objectifs qualité', 'FR', 67);
INSERT INTO public.quaadpoint_tag_name VALUES (73, 'Plan politique service NM: suivi', 'FR', 68);
INSERT INTO public.quaadpoint_tag_name VALUES (74, 'Rapport annuel service NM', 'FR', 69);
INSERT INTO public.quaadpoint_tag_name VALUES (75, 'Concertation gamme de procédures service NM', 'FR', 70);
INSERT INTO public.quaadpoint_tag_name VALUES (77, 'Organigramme service NM: à jour', 'FR', 72);
INSERT INTO public.quaadpoint_tag_name VALUES (78, 'Organigramme service NM: canaux de communication', 'FR', 73);
INSERT INTO public.quaadpoint_tag_name VALUES (76, 'Organigramme service NM', 'FR', 71);
INSERT INTO public.quaadpoint_tag_name VALUES (79, 'Fonctionnement service NM: demandes urgentes', 'FR', 74);
INSERT INTO public.quaadpoint_tag_name VALUES (80, 'Fonctionnement service NM: hors horaire', 'FR', 75);
INSERT INTO public.quaadpoint_tag_name VALUES (81, 'Fonctionnement service NM: maladie', 'FR', 76);
INSERT INTO public.quaadpoint_tag_name VALUES (82, 'Fonctionnement service NM: congé pers.', 'FR', 77);
INSERT INTO public.quaadpoint_tag_name VALUES (83, 'NM: accord avec autres services', 'FR', 78);
INSERT INTO public.quaadpoint_tag_name VALUES (84, 'NM: accord avec service technique', 'FR', 79);
INSERT INTO public.quaadpoint_tag_name VALUES (85, 'Redirection vers d''autres services NM', 'FR', 80);
INSERT INTO public.quaadpoint_tag_name VALUES (86, 'Redirection vers d''autres services NM: responsabilités', 'FR', 81);
INSERT INTO public.quaadpoint_tag_name VALUES (87, 'Redirection depuis d''autres services NM: responsabilités', 'FR', 82);
INSERT INTO public.quaadpoint_tag_name VALUES (88, 'Responsabilité procédure NM', 'FR', 83);
INSERT INTO public.quaadpoint_tag_name VALUES (89, 'NM Formulaire de demande manquant', 'FR', 84);
INSERT INTO public.quaadpoint_tag_name VALUES (90, 'NM Formulaire de demande incomplet', 'FR', 85);
INSERT INTO public.quaadpoint_tag_name VALUES (91, 'NM Description de fonction', 'FR', 86);
INSERT INTO public.quaadpoint_tag_name VALUES (96, 'Formation continue générale NM', 'FR', 90);
INSERT INTO public.quaadpoint_tag_name VALUES (92, 'Formation de base en radioprotection NM', 'FR', 87);
INSERT INTO public.quaadpoint_tag_name VALUES (93, 'Formation d''entrée procédures locales et radioprotection NM', 'FR', 88);
INSERT INTO public.quaadpoint_tag_name VALUES (97, 'Formation continue en radioprotection NM', 'FR', 91);
INSERT INTO public.quaadpoint_tag_name VALUES (98, 'Formation continue en radioprotection NM: enregistrement', 'FR', 92);
INSERT INTO public.quaadpoint_tag_name VALUES (99, 'Identification des besoins de formation du personnel NM', 'FR', 93);
INSERT INTO public.quaadpoint_tag_name VALUES (100, 'Accès à la documentation NM', 'FR', 94);
INSERT INTO public.quaadpoint_tag_name VALUES (102, 'Affichage du plan du bâtiment (NM)', 'FR', 96);
INSERT INTO public.quaadpoint_tag_name VALUES (103, 'Plans affichés NM: mention zones, sorties, sources de rayonnement', 'FR', 97);
INSERT INTO public.quaadpoint_tag_name VALUES (104, 'Symboles de rayonnement visibles entrée zones contrôlées', 'FR', 98);
INSERT INTO public.quaadpoint_tag_name VALUES (105, 'Avertissement visible grossesse NM', 'FR', 99);
INSERT INTO public.quaadpoint_tag_name VALUES (106, 'Règles locales de radioprotection conformes aux directives NM', 'FR', 100);
INSERT INTO public.quaadpoint_tag_name VALUES (107, 'Contrôle d''accès labo chaud NM', 'FR', 101);
INSERT INTO public.quaadpoint_tag_name VALUES (108, 'Contrôle d''accès local déchets NM', 'FR', 102);
INSERT INTO public.quaadpoint_tag_name VALUES (109, 'Identification des sources radioactives NM', 'FR', 103);
INSERT INTO public.quaadpoint_tag_name VALUES (67, 'Déclaration de mission service NM', 'FR', 62);
INSERT INTO public.quaadpoint_tag_name VALUES (101, 'Autorisation d''établissement et d''exploitation NM', 'FR', 95);
INSERT INTO public.quaadpoint_tag_name VALUES (110, 'Stockage approprié des sources radioactives NM', 'FR', 104);
INSERT INTO public.quaadpoint_tag_name VALUES (94, 'Déclaration de compréhension des règles locales de radioprotection NM', 'FR', 89);
INSERT INTO public.quaadpoint_tag_name VALUES (111, 'Enregistrement dans un inventaire des sources radioactives NM', 'FR', 105);
INSERT INTO public.quaadpoint_tag_name VALUES (66, 'Déclaration de mission hôpital', 'FR', 61);
INSERT INTO public.quaadpoint_tag_name VALUES (29, 'Diplôme, formation', 'FR', 27);
INSERT INTO public.quaadpoint_tag_name VALUES (113, 'Approbation espaces patient et radioprot. collective NM', 'FR', 108);
INSERT INTO public.quaadpoint_tag_name VALUES (112, 'Approbation espaces d''administration et radioprot. collective NM', 'FR', 107);
INSERT INTO public.quaadpoint_tag_name VALUES (114, 'Approbation des moyens de protection personnelle NM', 'FR', 109);
INSERT INTO public.quaadpoint_tag_name VALUES (115, 'Présence d''instruments de mesure NM', 'FR', 110);
INSERT INTO public.quaadpoint_tag_name VALUES (116, 'Introduction d''une nouvelle procédure clinique NM', 'FR', 111);
INSERT INTO public.quaadpoint_tag_name VALUES (118, 'Port d''un dosimètre de doigt/poignet NM', 'FR', 113);
INSERT INTO public.quaadpoint_tag_name VALUES (119, 'Port d''un dosimètre électronique NM', 'FR', 114);
INSERT INTO public.quaadpoint_tag_name VALUES (117, 'Port d''un dosimètre de poitrine NM', 'FR', 112);
INSERT INTO public.quaadpoint_tag_name VALUES (120, 'Mesures annuelles de rayonnement DEXA NM', 'FR', 115);
INSERT INTO public.quaadpoint_tag_name VALUES (121, 'Approbation des installations sanitaires NM', 'FR', 116);
INSERT INTO public.quaadpoint_tag_name VALUES (122, 'Présence d''une toilette séparée pour le personnel NM', 'FR', 117);
INSERT INTO public.quaadpoint_tag_name VALUES (123, 'Gestion des déchets radioactifs (solide / liquide) NM', 'FR', 118);
INSERT INTO public.quaadpoint_tag_name VALUES (124, 'Gestion des échantillons patient radioactifs NM', 'FR', 119);
INSERT INTO public.quaadpoint_tag_name VALUES (129, 'Mesure activité av. administration - proc thérap. NM', 'FR', 124);
INSERT INTO public.quaadpoint_tag_name VALUES (126, 'Examen des demandes de proc. diagnostic NM', 'FR', 121);
INSERT INTO public.quaadpoint_tag_name VALUES (127, 'Examen des demandes de proc. thérapie NM', 'FR', 122);
INSERT INTO public.quaadpoint_tag_name VALUES (128, 'Mesure activité av. administration - proc diagn. NM', 'FR', 123);
INSERT INTO public.quaadpoint_tag_name VALUES (130, 'Conformité valeurs de référence - proc diagn. NM', 'FR', 125);
INSERT INTO public.quaadpoint_tag_name VALUES (131, 'Conformité valeurs de référence - proc thérap. NM', 'FR', 126);
INSERT INTO public.quaadpoint_tag_name VALUES (132, 'Adaptation activité - cas pédiatrie- proc. diagn. NM', 'FR', 127);
INSERT INTO public.quaadpoint_tag_name VALUES (133, 'Adaptation activité - cas pédiatrie- proc. thérap. NM', 'FR', 128);
INSERT INTO public.quaadpoint_tag_name VALUES (134, 'Ecart valeurs référence - proc. diagn. NM', 'FR', 129);
INSERT INTO public.quaadpoint_tag_name VALUES (135, 'Ecart valeurs référence - proc. thérap. NM', 'FR', 130);
INSERT INTO public.quaadpoint_tag_name VALUES (136, 'Instructions orales patient av. départ - proc. diagn. NM', 'FR', 131);
INSERT INTO public.quaadpoint_tag_name VALUES (137, 'Instructions orales patient av. départ - proc. thérap. NM', 'FR', 132);
INSERT INTO public.quaadpoint_tag_name VALUES (138, 'Instructions écrites patient av. départ - proc. diagn. NM', 'FR', 133);
INSERT INTO public.quaadpoint_tag_name VALUES (139, 'Instructions écrites patient av. départ - proc. thérap. NM', 'FR', 134);
INSERT INTO public.quaadpoint_tag_name VALUES (140, 'Consentement du patient NM', 'FR', 135);
INSERT INTO public.quaadpoint_tag_name VALUES (141, 'Disponibilité radiophys. calcul dose après admin. NM', 'FR', 136);
INSERT INTO public.quaadpoint_tag_name VALUES (142, 'Identification patient (bracelet) avant administration NM', 'FR', 137);
INSERT INTO public.quaadpoint_tag_name VALUES (159, 'Contrôle annuel flux de thérapie à radionucléides NM', 'FR', 154);
INSERT INTO public.quaadpoint_tag_name VALUES (143, 'Vérification grossesse/allaitement avant administration NM', 'FR', 138);
INSERT INTO public.quaadpoint_tag_name VALUES (144, 'Contrôle examen similaire avant administration NM', 'FR', 139);
INSERT INTO public.quaadpoint_tag_name VALUES (146, 'SOP pour toutes les tâches effectuées NM', 'FR', 141);
INSERT INTO public.quaadpoint_tag_name VALUES (147, 'SOP procédures cliniques NM', 'FR', 142);
INSERT INTO public.quaadpoint_tag_name VALUES (148, 'Révision des SOP (3 ans) NM', 'FR', 143);
INSERT INTO public.quaadpoint_tag_name VALUES (149, 'Manuel qualité service NM', 'FR', 144);
INSERT INTO public.quaadpoint_tag_name VALUES (160, 'Avis avant achat matériel NM', 'FR', 155);
INSERT INTO public.quaadpoint_tag_name VALUES (155, 'Auto-évaluation annuelle NM', 'FR', 150);
INSERT INTO public.quaadpoint_tag_name VALUES (161, 'Marquage CE NM', 'FR', 156);
INSERT INTO public.quaadpoint_tag_name VALUES (166, 'Contrat entretien SPECT SPECT/CT NM', 'FR', 161);
INSERT INTO public.quaadpoint_tag_name VALUES (165, 'Contrat entretien cameras gamma planaire NM', 'FR', 160);
INSERT INTO public.quaadpoint_tag_name VALUES (182, 'Analyse tendance controles uniformité NM', 'FR', 177);
INSERT INTO public.quaadpoint_tag_name VALUES (152, 'Participation du personnel au SMQ NM', 'FR', 147);
INSERT INTO public.quaadpoint_tag_name VALUES (181, 'Contrôle annuel collimateurs NM', 'FR', 176);
INSERT INTO public.quaadpoint_tag_name VALUES (153, 'Conformité SMQ pour les devices NM', 'FR', 148);
INSERT INTO public.quaadpoint_tag_name VALUES (150, 'Contrôle annuel manuel qualité radiophysicien NM', 'FR', 145);
INSERT INTO public.quaadpoint_tag_name VALUES (151, 'Contrôle annuel manuel qualité radiopharmacien NM', 'FR', 146);
INSERT INTO public.quaadpoint_tag_name VALUES (154, 'Enregistrement des résultats SMQ NM', 'FR', 149);
INSERT INTO public.quaadpoint_tag_name VALUES (156, 'Evaluation satisfaction patient NM', 'FR', 151);
INSERT INTO public.quaadpoint_tag_name VALUES (157, 'Evaluation satisfaction référent NM', 'FR', 152);
INSERT INTO public.quaadpoint_tag_name VALUES (158, 'Contrôle annuel des flux de réalisation examen NM', 'FR', 153);
INSERT INTO public.quaadpoint_tag_name VALUES (164, 'Contrat entretien moniteurs de contamination NM', 'FR', 159);
INSERT INTO public.quaadpoint_tag_name VALUES (163, 'Contrat entretien compt. Beta Gamma NM', 'FR', 158);
INSERT INTO public.quaadpoint_tag_name VALUES (162, 'Contrat entretien activimètre NM', 'FR', 157);
INSERT INTO public.quaadpoint_tag_name VALUES (175, 'Conformité SOPS avec manuels fabricants NM', 'FR', 170);
INSERT INTO public.quaadpoint_tag_name VALUES (174, 'Système de notification d''incidents', 'FR', 169);
INSERT INTO public.quaadpoint_tag_name VALUES (173, 'Programme gestion qualité extérieurs à l''hopital NM', 'FR', 168);
INSERT INTO public.quaadpoint_tag_name VALUES (172, 'Contrat entretien DEXA', 'FR', 167);
INSERT INTO public.quaadpoint_tag_name VALUES (171, 'Contrat entretien ventilation gaz radioactifs NM', 'FR', 166);
INSERT INTO public.quaadpoint_tag_name VALUES (170, 'Contrat entretien système aérosols NM', 'FR', 165);
INSERT INTO public.quaadpoint_tag_name VALUES (169, 'Contrat entretien sondes glanglion sentinelle NM', 'FR', 164);
INSERT INTO public.quaadpoint_tag_name VALUES (168, 'Contrat entretien compteurs thyroidiens NM', 'FR', 163);
INSERT INTO public.quaadpoint_tag_name VALUES (167, 'Contrat entretien PET PET/CT NM', 'FR', 162);
INSERT INTO public.quaadpoint_tag_name VALUES (187, 'Analyse tendance linéarité spatiale NM', 'FR', 181);
INSERT INTO public.quaadpoint_tag_name VALUES (184, 'Analyse tendance résolution spatiale NM', 'FR', 179);
INSERT INTO public.quaadpoint_tag_name VALUES (183, 'Contrôle annuel résolution spatiale NM', 'FR', 178);
INSERT INTO public.quaadpoint_tag_name VALUES (180, 'Inspection vis journalière collimateurs NM', 'FR', 175);
INSERT INTO public.quaadpoint_tag_name VALUES (179, 'Inspection vis journalière têtes scan NM', 'FR', 174);
INSERT INTO public.quaadpoint_tag_name VALUES (178, 'Réparation matériel NM', 'FR', 173);
INSERT INTO public.quaadpoint_tag_name VALUES (177, 'Controle qualité activimètres NM', 'FR', 172);
INSERT INTO public.quaadpoint_tag_name VALUES (176, 'Contrôle qualité equipements imagerie NM', 'FR', 171);
INSERT INTO public.quaadpoint_tag_name VALUES (185, 'Controle annuel linéarité spatiale NM', 'FR', 180);
INSERT INTO public.quaadpoint_tag_name VALUES (188, 'Controle annuel sensibilité NM', 'FR', 182);
INSERT INTO public.quaadpoint_tag_name VALUES (189, 'Analyse tendance sensibilité NM', 'FR', 183);
INSERT INTO public.quaadpoint_tag_name VALUES (190, 'Controle annuel géométrie NM', 'FR', 184);
INSERT INTO public.quaadpoint_tag_name VALUES (191, 'Controle annuel centre de rotation NM', 'FR', 185);
INSERT INTO public.quaadpoint_tag_name VALUES (192, 'Controle annuel homogénéité corps NM', 'FR', 186);
INSERT INTO public.quaadpoint_tag_name VALUES (193, 'Controle annuel alignement SPECT-CT NM', 'FR', 187);
INSERT INTO public.quaadpoint_tag_name VALUES (194, 'Analyse tendance géométrie NM', 'FR', 188);
INSERT INTO public.quaadpoint_tag_name VALUES (195, 'Analyse tendance centre de rotation NM', 'FR', 189);
INSERT INTO public.quaadpoint_tag_name VALUES (196, 'Analyse tendance homogénéité corps NM', 'FR', 190);
INSERT INTO public.quaadpoint_tag_name VALUES (197, 'Analyse tendance alignement SPECT-CT NM', 'FR', 191);
INSERT INTO public.quaadpoint_tag_name VALUES (198, 'DEXA - fantome antropomorphe', 'FR', 192);
INSERT INTO public.quaadpoint_tag_name VALUES (199, 'DEXA - contrôle annuel', 'FR', 193);
INSERT INTO public.quaadpoint_tag_name VALUES (200, 'DEXA - contrôle qualité du faisceau', 'FR', 194);
INSERT INTO public.quaadpoint_tag_name VALUES (201, 'DEXA - controle qualité de l''image', 'FR', 195);
INSERT INTO public.quaadpoint_tag_name VALUES (202, 'DEXA - contrôle BMD', 'FR', 196);
INSERT INTO public.quaadpoint_tag_name VALUES (203, 'DEXA - contrôle dose patient', 'FR', 197);
INSERT INTO public.quaadpoint_tag_name VALUES (204, 'DEXA - controle bruit électronique', 'FR', 198);
INSERT INTO public.quaadpoint_tag_name VALUES (205, 'DEXA - contrôle bruit arrière plan', 'FR', 199);
INSERT INTO public.quaadpoint_tag_name VALUES (206, 'DEXA - contrôle sync horloge', 'FR', 200);
INSERT INTO public.quaadpoint_tag_name VALUES (244, 'Tests d''acceptation SPECT NM', 'FR', 238);
INSERT INTO public.quaadpoint_tag_name VALUES (245, 'Test détecteurs multiples - enregistrement NM', 'FR', 239);
INSERT INTO public.quaadpoint_tag_name VALUES (246, 'Test détecteurs multiples - sensibilité NM', 'FR', 240);
INSERT INTO public.quaadpoint_tag_name VALUES (247, 'Test détecteurs multiples - qualité pixels NM', 'FR', 241);
INSERT INTO public.quaadpoint_tag_name VALUES (248, 'Test détecteurs multiples - centre de rotation NM', 'FR', 242);
INSERT INTO public.quaadpoint_tag_name VALUES (249, 'Présence médecin service NM', 'FR', 243);
INSERT INTO public.quaadpoint_tag_name VALUES (250, 'Surveillance visuelle patient NM', 'FR', 244);
INSERT INTO public.quaadpoint_tag_name VALUES (251, 'Pédiatrie - SOPs cliniques NM', 'FR', 245);
INSERT INTO public.quaadpoint_tag_name VALUES (207, 'DEXA - contrôle constance', 'FR', 201);
INSERT INTO public.quaadpoint_tag_name VALUES (208, 'DEXA - contrôle énergie de réponse', 'FR', 202);
INSERT INTO public.quaadpoint_tag_name VALUES (209, 'DEXA - contrôle linéarité', 'FR', 203);
INSERT INTO public.quaadpoint_tag_name VALUES (210, 'DEXA - contrôle reproductibilité', 'FR', 204);
INSERT INTO public.quaadpoint_tag_name VALUES (252, 'Présence médecin administration produits NM', 'FR', 246);
INSERT INTO public.quaadpoint_tag_name VALUES (212, 'DEXA - analyse bruit électronique', 'FR', 206);
INSERT INTO public.quaadpoint_tag_name VALUES (213, 'DEXA - analyse bruit arrière plan', 'FR', 207);
INSERT INTO public.quaadpoint_tag_name VALUES (214, 'DEXA - analyse sync horloge', 'FR', 208);
INSERT INTO public.quaadpoint_tag_name VALUES (215, 'DEXA - analyse constance', 'FR', 209);
INSERT INTO public.quaadpoint_tag_name VALUES (216, 'DEXA - analyse énergie réponse', 'FR', 210);
INSERT INTO public.quaadpoint_tag_name VALUES (217, 'DEXA - analyse linéarité', 'FR', 211);
INSERT INTO public.quaadpoint_tag_name VALUES (218, 'DEXA - analyse reproductibilité', 'FR', 212);
INSERT INTO public.quaadpoint_tag_name VALUES (219, 'DEXA - analyse isosensibilité', 'FR', 213);
INSERT INTO public.quaadpoint_tag_name VALUES (211, 'DEXA - contrôle isosensibilité', 'FR', 205);
INSERT INTO public.quaadpoint_tag_name VALUES (220, 'Accord achat hardware NM', 'FR', 214);
INSERT INTO public.quaadpoint_tag_name VALUES (221, 'Accord achat software image NM', 'FR', 215);
INSERT INTO public.quaadpoint_tag_name VALUES (222, 'Accord achat update hardware NM', 'FR', 216);
INSERT INTO public.quaadpoint_tag_name VALUES (223, 'Accord achat update software NM', 'FR', 217);
INSERT INTO public.quaadpoint_tag_name VALUES (224, 'SMQ software in-house NM', 'FR', 218);
INSERT INTO public.quaadpoint_tag_name VALUES (225, 'Contrat entretien hardware NM', 'FR', 219);
INSERT INTO public.quaadpoint_tag_name VALUES (226, 'Contrat entretien software NM', 'FR', 220);
INSERT INTO public.quaadpoint_tag_name VALUES (227, 'Intégrité données - perte taux comptage NM', 'FR', 221);
INSERT INTO public.quaadpoint_tag_name VALUES (228, 'Intégrité données - tramage info NM', 'FR', 222);
INSERT INTO public.quaadpoint_tag_name VALUES (229, 'Intégrité données quantification traitement image NM', 'FR', 223);
INSERT INTO public.quaadpoint_tag_name VALUES (230, 'Intégrité données - calcul image NM', 'FR', 224);
INSERT INTO public.quaadpoint_tag_name VALUES (231, 'Intégrité données - calcul activité-temps NM', 'FR', 225);
INSERT INTO public.quaadpoint_tag_name VALUES (232, 'Test acceptation - prise en compte spécifications NM', 'FR', 226);
INSERT INTO public.quaadpoint_tag_name VALUES (233, 'Responsable test acceptation NM', 'FR', 227);
INSERT INTO public.quaadpoint_tag_name VALUES (234, 'NEMA intr. - résolution en fonction énergie NM', 'FR', 228);
INSERT INTO public.quaadpoint_tag_name VALUES (235, 'NEMA intr. - uniformité flood field NM', 'FR', 229);
INSERT INTO public.quaadpoint_tag_name VALUES (236, 'NEMA intr. - résolution spatiale NM', 'FR', 230);
INSERT INTO public.quaadpoint_tag_name VALUES (237, 'NEMA intr. - linéarité spatiale NM', 'FR', 231);
INSERT INTO public.quaadpoint_tag_name VALUES (238, 'NEMA intr. - taux de comptage (performance) NM', 'FR', 232);
INSERT INTO public.quaadpoint_tag_name VALUES (239, 'NEMA intr. - enregistrement spatial NM', 'FR', 233);
INSERT INTO public.quaadpoint_tag_name VALUES (240, 'NEMA extr. - uniformité flood field NM', 'FR', 234);
INSERT INTO public.quaadpoint_tag_name VALUES (241, 'NEMA extr. - résolution spatiale NM', 'FR', 235);
INSERT INTO public.quaadpoint_tag_name VALUES (242, 'NEMA extr. - sensibilité collimateurs NM', 'FR', 236);
INSERT INTO public.quaadpoint_tag_name VALUES (253, 'Présence médecin radio thérapie NM', 'FR', 247);
INSERT INTO public.quaadpoint_tag_name VALUES (243, 'NEMA extr. - blindage tête détecteur NM', 'FR', 237);
INSERT INTO public.quaadpoint_tag_name VALUES (254, 'Surveillance visuelle patient radio thérapie NM', 'FR', 248);
INSERT INTO public.quaadpoint_tag_name VALUES (255, 'Mesures spécifiques pédiatrie radio thérapie NM', 'FR', 249);
INSERT INTO public.quaadpoint_tag_name VALUES (256, 'Valeurs max avant libération patient radioth. NM', 'FR', 250);
INSERT INTO public.quaadpoint_tag_name VALUES (257, 'Mesure de dose avant libération patient radioth. NM', 'FR', 251);
INSERT INTO public.quaadpoint_tag_name VALUES (258, 'Suivi clinique multidisciplinaire radioth. NM', 'FR', 252);
INSERT INTO public.quaadpoint_tag_name VALUES (260, 'Autorisations et compétences', 'FR', 254);
INSERT INTO public.quaadpoint_tag_name VALUES (259, 'Ressources humaines', 'FR', 253);
INSERT INTO public.quaadpoint_tag_name VALUES (261, 'Formation continue', 'FR', 255);
INSERT INTO public.quaadpoint_tag_name VALUES (262, 'Formations nouveau dispositif médical', 'FR', 256);
INSERT INTO public.quaadpoint_tag_name VALUES (263, 'Délégation d''activité', 'FR', 257);
INSERT INTO public.quaadpoint_tag_name VALUES (264, 'Description des activités IM', 'FR', 258);
INSERT INTO public.quaadpoint_tag_name VALUES (265, 'Fiches de poste', 'FR', 259);
INSERT INTO public.quaadpoint_tag_name VALUES (266, 'Preuve de qualification', 'FR', 260);
INSERT INTO public.quaadpoint_tag_name VALUES (268, 'Validation des compétences acquises', 'FR', 262);
INSERT INTO public.quaadpoint_tag_name VALUES (269, 'Habilitation individuelle - postes affectables', 'FR', 263);
INSERT INTO public.quaadpoint_tag_name VALUES (296, 'IRM: sécurité des patients et professionnels', 'FR', 290);
INSERT INTO public.quaadpoint_tag_name VALUES (267, 'Formation initiale et continue', 'FR', 261);
INSERT INTO public.quaadpoint_tag_name VALUES (272, 'Inventaire des DM', 'FR', 266);
INSERT INTO public.quaadpoint_tag_name VALUES (274, 'Produits de santé: exigences', 'FR', 268);
INSERT INTO public.quaadpoint_tag_name VALUES (275, 'Equipement ou matériels non DM: exigences', 'FR', 269);
INSERT INTO public.quaadpoint_tag_name VALUES (276, 'Politique de sécurité et de sûreté', 'FR', 270);
INSERT INTO public.quaadpoint_tag_name VALUES (277, 'Correspondant à la sécurité numérique (+fiche de poste corresp.)', 'FR', 271);
INSERT INTO public.quaadpoint_tag_name VALUES (278, 'SI: respect des obligations de santé. Organisation garante', 'FR', 272);
INSERT INTO public.quaadpoint_tag_name VALUES (279, 'Assurance qualité, sécurité et fiabilité', 'FR', 273);
INSERT INTO public.quaadpoint_tag_name VALUES (281, 'Sécurisation et conformité des fichiers complémentaires de BDD patient', 'FR', 275);
INSERT INTO public.quaadpoint_tag_name VALUES (282, 'Echange et diffusions des images/comptes-rendus', 'FR', 276);
INSERT INTO public.quaadpoint_tag_name VALUES (283, 'Intégration du SI de la structure d''IM', 'FR', 277);
INSERT INTO public.quaadpoint_tag_name VALUES (284, 'Interopérabilité avec des structures extérieures', 'FR', 278);
INSERT INTO public.quaadpoint_tag_name VALUES (285, 'Plan de continuité', 'FR', 279);
INSERT INTO public.quaadpoint_tag_name VALUES (287, 'Dossier médical partagé: prise en compte', 'FR', 281);
INSERT INTO public.quaadpoint_tag_name VALUES (286, 'Sauvegarde et archivage des données patients', 'FR', 280);
INSERT INTO public.quaadpoint_tag_name VALUES (288, 'Accès extérieur au SI', 'FR', 282);
INSERT INTO public.quaadpoint_tag_name VALUES (289, 'Techniques d''hygiène et gestes aseptiques', 'FR', 283);
INSERT INTO public.quaadpoint_tag_name VALUES (290, 'Prise en charge patients infectés/immunodéprimés', 'FR', 284);
INSERT INTO public.quaadpoint_tag_name VALUES (291, 'Entretien et nettoyage des locaux', 'FR', 285);
INSERT INTO public.quaadpoint_tag_name VALUES (292, 'Nettoyage des DM', 'FR', 286);
INSERT INTO public.quaadpoint_tag_name VALUES (293, 'Gestion du linge', 'FR', 287);
INSERT INTO public.quaadpoint_tag_name VALUES (294, 'Prise en charge des déchets et rejets', 'FR', 288);
INSERT INTO public.quaadpoint_tag_name VALUES (295, 'Radioprodection des patients et travailleurs', 'FR', 289);
INSERT INTO public.quaadpoint_tag_name VALUES (270, 'Accueil-Formation des arrivants / personnes en formation', 'FR', 264);
INSERT INTO public.quaadpoint_tag_name VALUES (297, 'Identitovigilance', 'FR', 291);
INSERT INTO public.quaadpoint_tag_name VALUES (298, 'Demande d''acte et validation', 'FR', 292);
INSERT INTO public.quaadpoint_tag_name VALUES (280, 'Sécurité des accès logiciel métiers et données patients', 'FR', 274);
INSERT INTO public.quaadpoint_tag_name VALUES (299, 'Information du patient', 'FR', 293);
INSERT INTO public.quaadpoint_tag_name VALUES (300, 'Prise de rendez-vous', 'FR', 294);
INSERT INTO public.quaadpoint_tag_name VALUES (301, 'Accueil du patient', 'FR', 295);
INSERT INTO public.quaadpoint_tag_name VALUES (271, 'Locaux et conditions environnementales', 'FR', 265);
INSERT INTO public.quaadpoint_tag_name VALUES (273, 'DM: procédures associées', 'FR', 267);


--
-- TOC entry 5690 (class 0 OID 25380)
-- Dependencies: 286
-- Data for Name: quaadtag_doc_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.quaadtag_doc_link VALUES (14, 281);
INSERT INTO public.quaadtag_doc_link VALUES (14, 283);
INSERT INTO public.quaadtag_doc_link VALUES (14, 284);
INSERT INTO public.quaadtag_doc_link VALUES (14, 280);
INSERT INTO public.quaadtag_doc_link VALUES (14, 285);
INSERT INTO public.quaadtag_doc_link VALUES (14, 286);
INSERT INTO public.quaadtag_doc_link VALUES (14, 287);
INSERT INTO public.quaadtag_doc_link VALUES (45, 289);
INSERT INTO public.quaadtag_doc_link VALUES (45, 290);
INSERT INTO public.quaadtag_doc_link VALUES (47, 290);
INSERT INTO public.quaadtag_doc_link VALUES (14, 291);
INSERT INTO public.quaadtag_doc_link VALUES (45, 292);
INSERT INTO public.quaadtag_doc_link VALUES (46, 293);
INSERT INTO public.quaadtag_doc_link VALUES (3, 296);
INSERT INTO public.quaadtag_doc_link VALUES (3, 297);
INSERT INTO public.quaadtag_doc_link VALUES (142, 298);
INSERT INTO public.quaadtag_doc_link VALUES (60, 301);
INSERT INTO public.quaadtag_doc_link VALUES (27, 302);
INSERT INTO public.quaadtag_doc_link VALUES (4, 303);
INSERT INTO public.quaadtag_doc_link VALUES (2, 304);
INSERT INTO public.quaadtag_doc_link VALUES (10, 305);
INSERT INTO public.quaadtag_doc_link VALUES (57, 306);
INSERT INTO public.quaadtag_doc_link VALUES (42, 307);
INSERT INTO public.quaadtag_doc_link VALUES (1, 315);
INSERT INTO public.quaadtag_doc_link VALUES (2, 315);
INSERT INTO public.quaadtag_doc_link VALUES (4, 315);
INSERT INTO public.quaadtag_doc_link VALUES (8, 315);
INSERT INTO public.quaadtag_doc_link VALUES (3, 316);
INSERT INTO public.quaadtag_doc_link VALUES (14, 282);
INSERT INTO public.quaadtag_doc_link VALUES (1, 288);
INSERT INTO public.quaadtag_doc_link VALUES (1, 328);
INSERT INTO public.quaadtag_doc_link VALUES (1, 329);
INSERT INTO public.quaadtag_doc_link VALUES (40, 330);
INSERT INTO public.quaadtag_doc_link VALUES (18, 324);
INSERT INTO public.quaadtag_doc_link VALUES (16, 324);
INSERT INTO public.quaadtag_doc_link VALUES (19, 324);
INSERT INTO public.quaadtag_doc_link VALUES (27, 321);
INSERT INTO public.quaadtag_doc_link VALUES (142, 299);
INSERT INTO public.quaadtag_doc_link VALUES (59, 319);


--
-- TOC entry 5691 (class 0 OID 25383)
-- Dependencies: 287
-- Data for Name: report; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.report VALUES (18, -1, 'New incident', '2024-10-04 00:00:00+02', NULL, 0, '', '', 7, 4, false);
INSERT INTO public.report VALUES (10, -1, 'New incident', '0001-01-01 00:00:00+00:09:21 BC', NULL, 0, '', '', 7, -1, true);
INSERT INTO public.report VALUES (11, -1, 'New incident', '0001-01-01 00:00:00+00:09:21 BC', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (12, -1, 'New incident', '0001-01-01 00:00:00+00:09:21 BC', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (13, -1, 'New incident', '0001-01-01 00:00:00+00:09:21 BC', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (14, -1, 'New incident', '0001-01-01 00:00:00+00:09:21 BC', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (15, -1, 'New incident', '0001-01-01 00:00:00+00:09:21 BC', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (16, -1, 'New incident', '2024-10-04 00:00:00+02', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (17, -1, 'New incident', '2024-10-04 00:00:00+02', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (21, -1, 'New incident', '2024-10-04 00:00:00+02', NULL, 0, '', '', 7, 4, false);
INSERT INTO public.report VALUES (24, 2, 'Incident 123', '2024-10-01 00:00:00+02', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (23, 2, 'Incident 123', '2024-10-04 00:00:00+02', NULL, 0, '', '', 7, 4, true);
INSERT INTO public.report VALUES (5, 2, 'New incident 321', '2022-03-07 00:00:00+01', NULL, 0, '', '', 8, 4, false);
INSERT INTO public.report VALUES (19, NULL, 'New incident', '2024-10-04 00:00:00+02', NULL, 0, 'Description', 'Status comment', 7, 4, false);
INSERT INTO public.report VALUES (22, 2, 'New incident', '2024-10-04 00:00:00+02', '2024-10-05 00:00:00+02', 0, '', '', 7, 4, false);
INSERT INTO public.report VALUES (25, 3, 'Incident 123', '2024-10-01 00:00:00+02', '2024-10-04 00:00:00+02', 0, '', '', 8, 4, false);
INSERT INTO public.report VALUES (26, 2, 'aaaaaaaaaaaaaaaa', '2024-10-04 00:00:00+02', NULL, 0, 'Test new incident...						', '', 7, 4, false);
INSERT INTO public.report VALUES (27, 1, 'aa', '2025-02-11 00:00:00+01', NULL, 0, '												', '', 7, 4, true);
INSERT INTO public.report VALUES (20, NULL, 'New incident', '2024-10-03 00:00:00+02', '2025-03-06 00:00:00+01', 0, '', '', 8, 4, false);
INSERT INTO public.report VALUES (29, 2, 'Test Incident 001', '2025-03-06 00:00:00+01', '2025-03-06 00:00:00+01', 0, '', '', 8, 4, false);
INSERT INTO public.report VALUES (30, 2, 'Test 001', '2025-03-06 00:00:00+01', NULL, 0, 'Test...					', '', 7, 4, false);


--
-- TOC entry 5693 (class 0 OID 25393)
-- Dependencies: 289
-- Data for Name: sequpdate_state; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.sequpdate_state VALUES ('create_sequpdate_state', 1);
INSERT INTO public.sequpdate_state VALUES ('addbquadvirtualpoint', 2);
INSERT INTO public.sequpdate_state VALUES ('addmulticlient', 3);
INSERT INTO public.sequpdate_state VALUES ('fixdashboardalert', 4);
INSERT INTO public.sequpdate_state VALUES ('user_cfg', 5);
INSERT INTO public.sequpdate_state VALUES ('survey', 6);
INSERT INTO public.sequpdate_state VALUES ('survey removed column', 7);
INSERT INTO public.sequpdate_state VALUES ('staff_member photo column', 8);
INSERT INTO public.sequpdate_state VALUES ('device photo column', 9);
INSERT INTO public.sequpdate_state VALUES ('read status', 10);
INSERT INTO public.sequpdate_state VALUES ('staff member email', 11);
INSERT INTO public.sequpdate_state VALUES ('civility list', 12);
INSERT INTO public.sequpdate_state VALUES ('document file not null', 13);
INSERT INTO public.sequpdate_state VALUES ('document type list', 14);
INSERT INTO public.sequpdate_state VALUES ('document modification date', 15);
INSERT INTO public.sequpdate_state VALUES ('read_status_link action field', 15);
INSERT INTO public.sequpdate_state VALUES ('action_status_link last_reminder field', 16);
INSERT INTO public.sequpdate_state VALUES ('tasks tables and view', 17);


--
-- TOC entry 5694 (class 0 OID 25398)
-- Dependencies: 290
-- Data for Name: sexlist; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.sexlist VALUES (0, 'Male');
INSERT INTO public.sexlist VALUES (1, 'Female');
INSERT INTO public.sexlist VALUES (2, 'All');


--
-- TOC entry 5696 (class 0 OID 25404)
-- Dependencies: 292
-- Data for Name: staff_formation; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.staff_formation VALUES (5, 0, NULL, NULL, 'New formation', NULL, NULL, 3, false, 0);
INSERT INTO public.staff_formation VALUES (4, 12, '2020-12-31 00:00:00+01', '2020-10-13 00:00:00+02', 'formation radioprotection', 'Test.', 'formation radioprotection', 4, false, 12);
INSERT INTO public.staff_formation VALUES (3, 12, '2025-03-06 00:00:00+01', '2023-03-27 00:00:00+02', 'formation radioprotection', '', 'formation 2', 4, false, 12);


--
-- TOC entry 5698 (class 0 OID 25411)
-- Dependencies: 294
-- Data for Name: staff_job; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.staff_job VALUES (1, 1, 1, '2019-12-10 00:00:00+01', '2999-12-31 00:00:00+01', 1, false, false);
INSERT INTO public.staff_job VALUES (5, 1, 1, '1990-10-01 00:00:00+01', '2999-12-31 00:00:00+01', 2, false, false);
INSERT INTO public.staff_job VALUES (15, 2, 12, '2021-03-11 00:00:00+01', '2999-12-31 00:00:00+01', 3, false, false);
INSERT INTO public.staff_job VALUES (17, 4, 12, '2021-07-28 00:00:00+02', '2999-12-31 00:00:00+01', 3, false, false);
INSERT INTO public.staff_job VALUES (21, 2, 0, '2022-03-01 00:00:00+01', '2999-12-31 00:00:00+01', 1, false, false);
INSERT INTO public.staff_job VALUES (19, 2, 15, '2021-12-03 00:00:00+01', '2999-12-31 00:00:00+01', 1, false, false);
INSERT INTO public.staff_job VALUES (18, 2, 14, '2021-12-03 00:00:00+01', '2999-12-31 00:00:00+01', 3, false, false);
INSERT INTO public.staff_job VALUES (20, 2, 16, '2021-12-03 00:00:00+01', '2999-12-31 00:00:00+01', 2, false, false);
INSERT INTO public.staff_job VALUES (29, 2, 14, '2024-08-23 00:00:00+02', '2999-12-31 00:00:00+01', 3, false, true);
INSERT INTO public.staff_job VALUES (30, 7, 14, '2024-08-23 00:00:00+02', '2999-12-31 00:00:00+01', 5, false, true);
INSERT INTO public.staff_job VALUES (31, -1, 14, '2024-08-23 18:03:08.090529+02', '2999-12-31 00:00:00+01', -1, false, true);
INSERT INTO public.staff_job VALUES (32, 8, 14, '2024-08-28 00:00:00+02', '2999-12-31 00:00:00+01', 2, false, true);
INSERT INTO public.staff_job VALUES (33, 3, 16, '2024-11-26 00:00:00+01', '2999-12-31 00:00:00+01', 2, false, false);
INSERT INTO public.staff_job VALUES (16, 3, 13, '2021-07-28 00:00:00+02', '2999-12-31 00:00:00+01', 2, false, false);
INSERT INTO public.staff_job VALUES (36, -1, 0, '2025-01-31 14:30:17.749693+01', '2999-12-31 00:00:00+01', -1, false, true);
INSERT INTO public.staff_job VALUES (35, 4, 13, '2025-01-15 00:00:00+01', '2022-12-31 00:00:00+01', 2, false, false);
INSERT INTO public.staff_job VALUES (34, 3, 13, '2025-01-10 00:00:00+01', '2999-12-31 00:00:00+01', 2, false, true);
INSERT INTO public.staff_job VALUES (37, 6, 15, '2025-04-24 00:00:00+02', '2999-12-31 00:00:00+01', 1, false, false);
INSERT INTO public.staff_job VALUES (22, 7, 0, '2022-03-01 00:00:00+01', '2025-05-06 00:00:00+02', 1, false, false);


--
-- TOC entry 5700 (class 0 OID 25418)
-- Dependencies: 296
-- Data for Name: staff_member; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.staff_member VALUES (1, 'XIMEO', 'XIMEO', true, 'ximeo', 'eGltZW8yMDIx', 0, false, '', '', '', NULL, NULL, NULL);
INSERT INTO public.staff_member VALUES (14, 'Bernier', 'Manon', false, 'mbernier', 'bWJlcm5pZXI=', 1, true, 'null', '', '', '\xffd8ffe000104a46494600010101006000600000fffe003b43524541544f523a2067642d6a7065672076312e3020287573696e6720494a47204a50454720763632292c207175616c697479203d2038320affdb0043000604040504040605050506060607090e0909080809120d0d0a0e1512161615121414171a211c17181f1914141d271d1f2223252525161c292c28242b21242524ffdb00430106060609080911090911241814182424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424ffc000110802d501f403012200021101031101ffc4001c0000010501010100000000000000000000000103040506020708ffc400451000010302040305050701070304020300010002030411051221310641511322617181073291a1b114234252c1d1f0e1152433627282f10816a2254392c253b2173464ffc4001a010100030101010000000000000000000000010203040506ffc4002c11010100020202020202020103050000000001021103211231044122511332051461237191425281a1c1ffda000c03010002110311003f00faa12a1080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080421080f4423d10804210804882828042108045d08405d2a44a8042108042108042108042108042108042108042108042108042108042108042108042108042108042108112a108042108042108042108042108112a10804210804210804210804210804210804895080422e8402125d2a01084201010840244a840895084021084021084021084021084021084021084021084021092e8150b93235bbb80f35c1a984027b56586e6fb2075099655c1238b59346e70dc070253a0823428150909005eeab315e25c2b066935b590c440be573b541688580abf6cdc3b4ef2d8e492568d3b468d09e83aa863db760b973ba1a96c79ac1f905879ea9b5bc6bd2d0bcee8fdb3e0550e735ee2dcbcec45c7aad7619c4d85e2cc6ba92ae292e2f6cda8446aad90901045c10414a88084210084210084210084210084210084210174212205421080421080421080ba108402109102a122102a12254021084021084021084021225402108402108402108402108402108ba0108420109aa8a98a9617cd33dac8d82ee713a00bc6f8e3db4be3a97d1e10c06102d9cbf2993d790517293dad8e172f4f55c67882830480d45755c5044ddf36e7c02f33e25f6e7053bcc78453492b6d6ed5c32e53d350bc5f88b8babb1e90cd595d24f338e918b96b00dac360b3ef7ca599a52e3e0e71b91e5758e5cbfa7463c33ede9957ed6b1396499f50e6caf78ee8cda309db95f4df4eaabe1f6918c96b9ceae9d8fcb95ad04116f3b82b0113e37684b183727529c6c8640431ff00a7d42af9d6be11b18f8df1ab871aa01d724b81b3afa6b61cf45aec03db0e2987c8d151299e170b10f37703d579244658f52e26fe2085303e2934248b0dd877f45332aa5c257b9d6fb68a66538746e7932774b4824b0e86fe5fd5795715f12b313c47495d2f6873074aeea4e9e3a5afaacc3cc97ecdcf25a7500ea131306cadece501e1a6e09bdda55bf915fe292f4b39f11a291992903f3802f366b36f7d6da5cfc9551c6aa186d13f3b6fb5b43e2792e0d2340ced944b9468c3a0637d37515b89c513886b9ee20fe01603e0a654e93a2c6a7739c5ed6800dec05aff00257983f1254514f1cb4d2cb04a5d7bb5d6ff00959f86ba37bcba67340d887ea6ff0015329aa21790e0d68f16e9f2e6ad15b1eb9c1dedb6bb0d94438ab1b534e4ea59dd7b7d0e87e4bdb387f8ab09e25a613e1b571cc3f101a169e841d97c7d332273c965dbae846c3d3f6f829584e2f8cf0e55b2bb0da89639233a6437cde1d0f915652e1b7d9e85e55ecefdb8e13c4c21a0c59c28313f72ceb864a7c2fb1f05ea8d7070b820852cacd150842202108402108ba010842010912a010848815084201084201084201084201084202f642442012a44bc90084210084210084210084210084210084210084210084210084209402a8c7389b0ec029a4a8ad9db0b183de7681c7f2b7a9f00a878f3da3d0708c2d8f309aaa4b86c2d3af99e817cddc69c7d578ed53aaaa673238df2b41ee463a347eab3cb924f4d70e2b9777d343c77ed22b789b109226cf2b69812191e60d637cfa95e7d5b5cd738b40924909b1264b01e9baac7d554566afcad634e86d7fe8ba65cb086175fa36c2febfb2c2eef75d735ad43e1f3dac058f20c22deb64db22676844f2b85f520687e7bae64aa731a581d73d46c4a8b24958f368c86b4fbce7bbfe52446f49e64a685ba8b9bdadb9d135f6a1a96c4f237be529875303106cb511bdf6ffdbbeff1b260c3135b76cac711ff00e40ee7e5fbabc915b954b756497690e747e36b2911d5b86f2e971dfb0baac6cf574cd2d8b23a33f858eb83f1fdd306be506d242e613a5f9faab78cfa565bf6baa8ae2d7863c5db7eec8dd8ae0d44d1bc1610e36d5a79f250a924ed18e66f6ea342a4cd14af809690034e5df51ff2a962d29ded046dbb336a6f92fb788f14d4f4d1bded9e10d6161d5aed89dc1b725cb242f8835c40737f1734d996489a63cadcd979f4d424e8bd996d3194dfed54af7743a11f0054c8a96a69da1ec943472746fbdfd0aac6b6a3b62c64ceb03d34b2991cf519cc8e36682032e34b79eeb58c97b4f55da38f6ac64836cccd159c458e8839a735ce8d3a5bf75434d5113ecda88a4a798ea2466a08fe755362336b690c77f75edf71fe04722af0d9daea2ed25cec22299ba87026dfcbaf49f661eda710c0eb5985f12cb2cf48e2182779b98f903e4bcf0d539ec0d9a9dc0fbbb6e926a364d0e76d881a8d356f879259a352becfa4ac82be9a3a9a595934320ccd7b0dc109f5f337b28f6a355c2750cc331291d2618e758876ae82ff0088750be92a3aca7c42962aaa595b2c32b4398f69b820a4ac72c747d1cd0852a8421080421080421080421080084210225284201010840210840210840884a8408942e5748042108042108042108042108042108042108042108042108109b0baf37f693ed529f86e964a6c3a5865adbe4d4df21f2f0fe734dfb58f6a94fc294d261b44f6bebded399c0e90f8f9af98318c7e6c46a5f2173a599eeb9791a79d9679e7f51bf1f16fba97c41c4b535f5b23e5a874d55312e92479cceb79aa06c2e78ed6773dd7be568d49f01d1774b485e4bc92f3b92e3ba596ac536b1bc7785dd26c6c34b37a2c1bdff938efb88c3ea5a0023b9103b79f35c32592a5dd9b486026c4345b28e77f1f055cfab9ea5c0d3b1d99db69b78f9ffca95d9ba923eca3bc9216fde496d07503a2b78ebda3cb7e925d2c50ddacc85e399d48fdfe414692aa62ccb9ede676511f2ba31958d6f892edfcd45789247eb9493c81b953a454b7ca1ba39c5daed73afc548a690c9b92d60e6ed75e9755a681d60e7b641cc685391d4454defc65badb3751d0f8abcc15b92f25a00d8bed11beedd9c5a7eaa652c34150dec26698e402e0e5043be03e8b37fda3514e4cb4f2ba4841ef379d95941594b5313448dcadfc25ba1171a796aaf223699f648e9a50d6b9b25fdd75b71fcb276ba1b471be027bed17f4ff0082abe4719f3343bfd279877f3f552e9aa657c0e64accae88101bd4df7f2bd956c5e5564ac30ea7425d7b78149239cf635c2d70083e5fc28ad6398fcce3a67d7c75014efb039d3b5b112d68602e23a5cdfe4ab7136a6829ea8b9cf2d03f2f740e7ba9d4d354b747c4d900d32b40364db7057b9ef2fb025db9772f82951d29a60d6345cf81b9579199f82ae1cfd9b6330c8efc2f072bbd36564d73a9ddddcccd3566e3d0aad8ab8348023b027517bb4fa1dbd158d2d60682eccd3cbb3909b26e2d254c864328c8cbb24e87f10e83f6f8279b3494cc0726769d48b5be8b8ed2396ce0d8dad1b585bf6b7aa72295ec94c6e26e7dd711bfaab4cbea971fd3931d3d546c9a97335edd46bee9e9e4bd37d8efb4a760552303c51ce14b34804649bf64e3fa15e515ed9692675452b9b949bbe32080a4d2bce29136a6039658859cd276fe9e2ab7aa6bca6abed26b839a08370754abcabd8f7b41fed385b80625293570b7ee5ee3abda391f11f30bd555dcd94b2ea84210880842100842100842100842100842100842100842100842101742108112a44a8042108042108042108042108042108042108042108058ef68fc774dc1d814f50e78ed882d8c07004bbc16aab2aa1a2a692a27786471b4b9ce26c000355f1d7b58e3ba9e3ae24732227ecb1131c2c1b01d7d5533cb51a71e1e559ac6b1cace27c5a6aa99c7bee2f7746a8b1c6c73c3756476d5c79fa272380471f60c3dd1ac8ff14c54d5b22cadb5f26c3a9e8b9f6ecb35db9c46b594ec0d0d392f97234eae2ab24aa82aa7119648e2d272b03c16f96daf9a87354c9553121c5c49b5c7d0782b9a6c3bfb2e08e494035336ac61d4b5bd4f8f45acc753b6572da5c54b161b4dda4b29fb5cc2e491ac6dfd0950a71206662446ce406a5775350216824e79ddaef7caa03a19667667dee75d4eaa96ed69351db476a6f1be475bc45fe655ad1d345235a6595d7b6ad7920fedf05069e3747a3bb302f6fbc7d87d484f553cc70de48a1ca767b2436f42416fcd6b8e2ada97262468dd922399bfe7767f4b1fa281558c36a5c5bd9c6c71d0b2ddd7feca0cb3b9db3cbbcc72e8991df390b6ed3a83656dabecf09d903c3a201baf4d4781ea176d76e18329009b5b6b6a97fb3dcd2ebfba2dbf3bdd74da7730df5b3af6bf4d946cd2539ed19434dc119f4f1e5f156d0b9ae635e1babe2bbdc7c49007d543828646be0616b893b34f3b14f554269e9d94d13cbdac2e0e775fe5d42f223622c3330cacf74dac7c77fa2b0a7a88a3aa7c5af7606b1ce1d43039c7e65469e30d8638dd7c8c682ebee74fd87cd44a612f6d23dc0812b8123f9c94a34b0a89f2ddf20633bee6b1b979036cc7e69b6564514a0b9cf79b968d6c3d073f8a813c7286b6f21ed1ced0f8dc6be5bfc1754d353b2accd62eb7bba6c06df25655675d1bcc79a5cc091700002dfceaab1d23e98865e4eb7bede9e4b4148c6e210171d4b8ef26fe5fceaaab15c38c64bcb0ddda8d37f1f0f5519c26c50e353070ccd8b283ab9e0016e8791f9ad350d6d35634b40b8b6ad26e0797f45e793444dcb9deeecd1aa770dc564a099bdf2597d43b423c966bcaf4b11f74676b4df637d40d879aa8aba4970aa835b44f7d9da96b7f15b7fea3d42b4c12b69717859925cd2022edb6a74fafd53f5948d69cc09742f1f877f023c46bf4e8b49768b3ee1bc271622a20c468a5ecaa63735ffee0745f5370471347c5380c15c0b44b6cb2b5a7dd70dd7c7f2d33b0d9fb78db9a176af03637fc43cfe4bd53d90f1a3305c69b4d5350e6d3540c8f2ef75dd1de639aacfc6f6ae78f94dcf6fa31091a438020820a55a3982108402108402108402108402108402108402108402108408845d080ba5489500842100842100842100842100842100842100909005ca555d8ee251e15874d5323c3035a4dcf2d3741e45ff503ed123c370c7e034731fb44c476c5a761f97e9fc0be758617b631ada69ae49fcad56fc5b8b1e26e28aaacb38459c9009bd80db555d2bcea7419f73d1a3fe3e5e2b973cb75ddc7878c47aeac8e9600180966e3abcff559daaa873e431b88ed1c3bf63a345bdd4fe2359dad437293777b83f237af991af926e82884933448d2efc6f1e1e3e6af8e3aed5cf2df49985450d2537dba46b4e5368d96f78faf91fe594b33485afa8aa19aa65b1b016b0e42cb8a1736b67ed5ecbd3c1a936d0b8f4fe6d64d5654f7ee3bf338902dcbc07969aa9b76630d39af73fa39db926c029704347470992a5cd91cefc2e076f8aa7a9ac9a177674f2132b747b9a3dd3d07eea55046cabb1a93da3bc8dfe2af8e3a56e5b43adeca691c699f901e4d3a25a48aa9a1c1ad05aedc5b42aee2c1d9da8023b5b5b399adbcecaea87017b0b64b678cf202d6f8a8cb2d2d8616d651942e2e0030b49e4a7e1b8609a4731e2d6072bba15b53c341d6781f86c74d469a28edc27b295ce0c75dc7b82dcf4fd07d553cda7f1290d07dcd3b9c6f9ae5e3e5fa229f0a355551b09eec601b7f395d69e7a10e82389acf71b94003529da7c39d6bb23041234b6fa7d1479c5a71ab3b38d92b46425ef168eff85b7d5de66df343f0e776c32c59c839f28d4bada0b8f31f35a4870774ae2fcb771b02e037214a8f86de0e58b33331b3cdeee7f813d145cd69c758b9f069e523230973b57bb7b7afd524b864a1d60fcb16c411a13d57a2c3c325c0309395bc9a2c2ffba72a785982237681d1adfa1eaabfcb16bc35e375b87b98e39017126c2e08f928f1523e30d6765a1d4e961a2f4aabe1e95ef39a22e8efa37604fa7250a6c322a5cae9591c79b7b30e6f892af33db2bc7a6468e67c45ac3eedfdd69d09f1037f2d95acef85d44e639c33b9d6d773ea96a69200e736312b8837b061b28d4f864d34d9a26c85c3625d6d7d56b8de99dc74a1c4e81800700f1e0eb6ea9e4a6005ddabb9750b695386995ceede5b966ba025a3d79aa4adc388d18d05dcefa93e5d556aba56e1789d561b50d7c5239b94defd57ab60f89c18cd309207b193b85df01370e77569f1dffadefe533d0d4c0038b41e603aca7e078b4b87bc4ccb86b1c33b79b7c7c94a25d3d2a4a6ed83e3759ac9058075bb8ee9e47ebe6a9e99f361ef11bc16398e16ea0f223c34b2b8a0af8b14a5edc963b38b48072f1098c4e904f0b9ed24cd08b3c7e61b5fe9ebe6a6df28b6b55f487b2de2a1c4bc350996e27a7fba7e6e765b45f33fb20e2c9704c5a180c81f0cce0d78077e847f3905f4b31ed7b1af6905ae170473538ddc61cb878d74842159904210804210804210804210804210804210804210812e84a840895225402108402108402108402108402108402108402f2bf6fbc52dc1785cd131c3b7acee01cc37f9f45ea6e2036e760be4bf6d7c5438978ca6645266a7a5023674b8dff9e2a9c996a35e1c7cb260230eb35a05cc9bf80eaa0e2b562ef886c05de474e9eb6b2b271149148f7580b6e3f28594ab9a499a493dfa87971ff2b46dfcf05861375d59dd4243785b2554a334b20ee0e82fba921af652358c2e74f54f39bc5a343fa8f5515b29642e945dcf7383621e2341f0d0fc15c6134cd931386226ec8d823bb79b5a4924799b9f55ad633b4dad6b708c320a36801c7ef2537dc917fa2a07cef862fb4824492771800d4753f0f99f05798e0fb54e2fa3a4706dc9d00beb7f9fc957329a9eb6aaf9cb5ad3958d3b81fcf9a99d2f502870d7ba6bb9b620ad9e1384c8e7b5edca4dae2c3e5fc29fc2b879b2b58eca6db6fa2da61585b226b4016b75dd65c9cba6dc7c1b575360ad2e00076503517b85794384b1ac3a7cb65631421ba65f0f25329e30d1a0b85c79f35af430e191022a024e52dbdfc134fc0724c5ed36bf25a08a16b4dc295d807b01b0bace7255ef1c6722c05af04651d1c46f6e8a741c3ed710c0d0d8f4bf53fb2bca7a7cadef0d54e8e20dd401757fe4aa7848aa66151c2006b400d161d13906165fef1cad1ae800bab66c409b9d57794016eaab72a6b48aca18e3b59b7e9cd7335235c351e8a788fe294459b751b19cacc18480eed0793552621c330965c44f2799257a01a6046ca1555187dc005dd405a639d8a592bc76bb861a1ef0c89e0df769d7e9faa8470f652b432d2100f7896968f2e4bd56b28835afce3bbbd9a37595c599112631037272b8d7f55be3c8c6f16d889dd13a4d6521dc81b000f8283554221067fbd2e3adcad43a95ac75db1065b9003f6512aa17d4ca4b436fd08b95b4cd95e365aa4bab23c997b470d9b668b7d167aa207d04f9c332bb62d75c661cc6fafa2d862386bdaebb1b62376dac6fe8aaab2315703a19a2748f6e9a9ef0fdd5e561963a73c338d0c3ab444d24c2fbba3693f10b7bdb0ccd95a33348e7f89847f07c3a2f1f6b4d3543435f719aed27420f8af49c02b854d23449ab762d3bf30425babb30ee6835cec271265440eb30bf336dc8ee17d41ecd7899bc4381309783245a5b6d3fe6e17ccd534c258dec0731bd8781e5f5f9f82dff00b0ae25fb162b250543cb735c804dae34b8b786fe853d65b57926f1ff00b3e8a42469b8bdd2ad5c8108420108420108420108420108420108420108420108b21022548840baa11aa3540235421008d50840210840211aa3540211aa44197f691c42de1be13afaccf95e232c658eb98e82cbe352e7d5544d2c8e2e2e71249f0fe7c97bb7fd49f10bb352e131bc656032bc03cf95c2f0b8db96841b77a422de5cff0045cdcb96ee9dbc18eb1da0639386d1865ece78b5ba3459679ef222cd7bbb2003d75fd4a9b8e4fdab9ec682086dff009f2512aed13d82da34e6b796cad84d4573bba5a77b59344e786e4a7cc6dd4803f63f05a6e17a673a89d55210488893e399c5645a1df6660fc525dc7c89b7eebd030a87ff00446c4c16925b345f96dfba9f7749c229eadb76baa250ecad69b0ea4e9f3d57584d1cb512879c8ce7ded3eaa4638c11b5b00716f7c0700dfca2df5ba9982d336f95b3484696d374cee97c26eb538152767943833cc05a9a78b6ca47a2a5c298d6868b9dadb2be8360375c3cb5e970e295077c6ba290de402659670046853ec691eab9eba6449a70363cd4f81b6002850341236d15847c82ac46475ad21c2dd54b8ede1b28ecb01e29f8c6ba68af19d76c1bae9bbedaa5166ecba63ae55957401b724e35ab969b0d92b5c3601114e800f9a6e48efb1b2e81bf2b782e4b88dc2b6d5d2beb2919234f2fa2a1abc318e395b95be42c56a641985aca14d481e6e091e8a36b4622af861a35616dcf32154d7f0f4a3431b481cec05fe4bd0a4a37f5bf8f3506ae239487643e165333a5c6579ad65318ecc9ee583402c3f6bacb63147134b648835a4ea0837b1f35e8f8cd1b082e1196b8f85c2c3e310ddd6732c4e85d7f9aece2e4df4e4e5e3d76c06280b2612651981b90b5bc2b58c792c71b1003c01cd6671c8decbe61a8bdec8c06bcc352cc87dc7165cf31fc2b6d6e3925d64f4c9e3634878170ededf31f15068b119b07c660afa77163e378b91d473f51f5535c3b4a7b97dac09b8e846fe9aaadaacc6f16979001702e2e2ffd7e4a3dc697dbebce11c6a2c7b00a4af89e1c2460bf81e63d0ab95e1fff004fdc599992e073bc00ebc910ff0030f787f3a2f70d56b8ddc717263e3968591aa3546aa540846a8d500846a8d501aa11aa3540211aa3540211aa3540244a8d501aa11aa102254895008421008421008421008421008421009b9e41144f90fe104a7164fda5710ffdbdc2b5950d7304ae19181c7727fa5d45ba9b4e33774f977da5e2f3e37c5b5b254939a494d9b7f758361f0f9acd56ca62ecd9cc9161d2da9fafc949966755e272d4c84bdc49b93d49b95518b4fd9191e5c4b8020799b05c72eebd1f58b3af99d515d2bc5dc06c0f3d47f44988c99eae568fc208fd3f74612dbd5b8bf61727c537efd7cbfe6972fcecba1ca99165ed5cc2dff0b2b47a5eff00a2de508ec22a569bd83980f8e96fa9f92c461b1194c921d6f281ea755b585e5b3c919682d81f1b85fcaea3edae3e9535ff00de71476d9331700ed48d56930aa77d984f2e960a8e36e6ae99f6bdddfcfaad561a010d25d6beb9565cb93a78b15f50300b1d7556d0968f15594c2f6b38853d8dca7737eab873aefc26961172b29cc6dc02a1c201680372ac23659bd4ac6d6cea316361653a9fa735158c26c54a85a41d522b954b6b754e8363e09b61246daa72c4f92d233a3b4d729baef365217396db2eda35f153b43bcda5d74d200bf5e69001b14a06e74165282926f66d928bd92b5a4ecbacb77220d38109b2c24a94e61b6eb9ca115da23e3dd459e9daf1d7cd58be3cde4a24b1e5b90ab6af19dc468d9202db924741b2c4e3b85445b25c723636faaf46a971b1bb41f92cee29490cec713180ee44ad38f3d5573c371e09c451be37383ace1b5d53e1795952c0d21d9de75f4d96c78e70d304cf7b19669dc75f10b0d87b8b2ba060e72177c82f4b0bb8f2b926b27b061d3ba6c3a2716dcb411703c07edf35025efbc3982db01e60ff00c29180ca63630dac2ee6d8f88bfe89badcd1ce434869cddd1e9fd0aacba6d66d2383b1c3c3fc474f5719b35b283fcf4fa2fb030fab65751c35319bb2560783d415f12d5c796b839a6c1ff7817d39ec4389c63bc28da57bf34d42eeccebbb4eadf969e8ad85ef4e7e7c7adbd190842d5ca10842010842010842010842010842010846a80d508420e574b94bc902a10840210840210840210840210840975e11ff0050f8e31cfa7c36392ee8c5dcd07f13bc3ad87cd7bac8e0c697136005caf933dab6273e27c5324af7b9d0bcba689b6b59b7e9fedb2cb9aeb16ff1f1de5b6229c18e94c84d8bddcfe2b318d4c44c1a79c9a8f2d7f65a0ac99cda7ee9b002dea77fa7cd6531c90098b8f5b8f53fb5963c73776e9e5bd39c100bcaf7901a18e713d058a8b4dfe3b0ff009eff003d14985a60c3aa1d722e4463c77bfd146841ede368d35173d355b39da2c26130c2d6b80d64ed09f880b4145276d555a001dd9c027a8008fd953d087961739b6b7c069b7a5d4ea094b6aaa9a00cc6627e40aae2da7458a491f56e23417b8216970b06edb924e8566b0b6191d9af7277f2e8b518631f9c5868b9f92bb38634f49a0b10ace18c103455d48c2e0db5f6d55b53c646e171e55db12e9e326da2b38c00075299a78c580b2991c237baa693686336d0a90c6f7b548c1b009d0083a2b4883cc601e09db58689b61bf54e03aeda2b694ae0bae48b27237902e79f249946a6c96c09b8e4a746fa3875b1bec9d89974d36c2de2a753b4380d402ad22995d476da6bf441a70d1cb452db6b2e5fde16202d7c269cfe7504b75b58a6dcc2a698ada91fd144a891adb9b851705a6665ed3651e68f71d573257359b9f802a2c98b44dd1cf67ff258dc5b431551b9a091627cd53ccd323ec496f98b82aea4a98e76dda41ba813c6d02ced3c551ac79a7b41c1049492481ac6900f780b7c978b420b3178dbb969202fa378b28daec365b924652be787c6d871e6b5bb17903e617a1f1b3dcd3cef97c7ab2bd2b0698454962729244a01e81cd1ff00d8a73888180c5391726d9bfd42e47ebf151e9196c3237d8922291b7b78b0d94bc72d5184d3d4117b8cc35e62d71f0715b59d339ed5d56fed18d95a5aeecd86c47316b8fd17a07b0ce286e0dc5505348fcb4f5e0c0f04e81fbb4fc6e3d579a53bff00ba10e3a47789d6e62c45fe0a461150fa4a96cb1bf2c90bc107a387fc2a6fbda3292cd3edf1b25559c378a3718c1292b5af6bbb58dae246d7b2b35d2f3c210840210840210840210840210840210840210841cdd74364852a0108420108420108420108420108420a4e2fae928701ab7c39bb4730b4387e1d353e82ebe3dc56bdf8962ae91c0ddc0817e4365f4dfb62c564c3785ea5ec95a338ecf213ef5cd89b750be5aa4776d512c8e768d245edc86a7f9e0b9b9ef7a76fc69f8ed558e4bd97dd0d35595c51ddad4868000bec792d062cebbdc46fa91aacc56bbb6ae7d8e97b0f85938a68e5bdac6ae2b5052b1ef6b49ccf3adefb0e5eaa13406ccc8dad2e7bdc06bb053b1163218e3bb81744069feeb7e8142c381971085c7521d9bcec2eb4fa67f7a6a617d9ee69366f699401b5af6fd3e69696431e25500778999cdf336d1340063e3692752de5cec4fe8a1d4caea7c56471b0ed035df2baae3eb6d2fb6af0d8fb69a4cba77c9bdb91d7f9e6b6185c0c1949b6816070bc61ad706b1bddbd9ce3caeb558562bd990647f3b120d87eb758e78daece2ca46da929ee41b7c55b53b5acb5ecb2d4fc43116ea6e391b5c1fd559458bc2f6df3b7d6ff00ad9735e3aea9c91a48df675859496bafb959ea7c6212eb7680103c029f1e2b0db5918ab71d2eb88cb6fb5fc53e1c08b8dd53c788b09b35cdd3929515487381daea34559c66e53ba6aa0b65b5b5521b36b63a2b4574916b04a1ba5f65c34dc84e8b804f24b10e0120ea9e8a7c9650e69830937db7f055d36350c6ecbda0b9d85d5a4459b699b5c39d82e65c41918b970b78ac0e29c7547400074c0b9c0e568d49f4075583c6fda81738881a0b5d7bbc9045bcb55b638e55865e33dbdb2b38b692006f231d6e4b3d8871f50824922c34bdc0f99b05e0d57c4388621219193c91b1fc813a0ebb8014da1c2712c5e768a68669d9ef59cdca41ebd16ffc73eeb0997fed8f51978ea1aa696c6c731a4f749d7d5545771130827b76cae236cc6fe5ba8f87fb33ada86679e497b471bdc4845bc96869bd9a7650e4708c83a9cc6e7c552f87d35c6e5f6cf418f7d9ee0490c45a36ed05afe802b3c3f8d29eac88e6730389b35ec2083a74dd4ea8f668e93ba266867e50c0aba4f6693c2f748c96d7dc036bf8580b2c72c30ad71cf24bc62764d86ca45882db83d5780d6d397711d390379b6f55eeaec32a2930f9e9a569cad6d86b71b755e39574c598fc2f1f85ee3f0054f04d547c9fcb18d1b5fd9e13870680dedda5c45f7d07eca5cbf7980c27ddcaec879fbc2c4fcbe4aa5f211478453385bb305baf8edf32ac3b40ec31f4ceb825ed37bf50e5d77b8e2fb53501244ac3bba36bede20d8fe8b98df6943afa3bbae07a8d3f65d523b35680e19438bc13e0e6dfea028f33c919f4cc0dedd48feab2ff0084fd3ea3f6098cb2b7857ec3da677d33afb5b424e9f11f35ea0be6cffa7bc7850f13cd42e79ecab2025a0ec0b4deff0003f25f49ae8c2ee38b971d6410842b3308421008421008421008421008421008421022548950084210084210084210084210090e812ae25788e373dda002e507847fd44e3ad8e1a5c3587bd6ed9e3cf41faaf10a51f66c30b9def4b66dfcf527e00adafb66c70639c5756e8f58a22d859aed61affe571e8b0d8913153430836764cc7c337f40b8b92ef27a5c53c708ced6cbda4a07e67001515333b6ab8b4e773fcf4561572fdf00d3a80483d0db451b0b1df041b39eeca0f468d4fe8b6c26a30cfba4c565bd47661c480df89bdd7784439a671dacdb03e66ca0d538cb5648b9bbf457380c42495ad1a87398c07c09feaa72f48c7dad672c63ee776ce4fa00eb2adc664cd5109d2c22680473d6df4522a64ccc96fa13adfcff00e5449dff006b86073b4b8cbe448fe898fa5f214534da96903c8d8ab78710a9800310bbada93a91f053b85f01a69638df334e63a9175e8787e0340e8dad30b3e01679e723a38f8ad797b71ec52304b242d3bdcb37f5b2e0711e3dda5db3766eb58ddbf5d2ebd766e10c36761bc4d1e4aa6af8169c8218fb8f1b1518f2e3f69cb832fdbcfe9b8b3138a42d966cae06c48d01fa2bd6713544a19791b63bea6c3d549aaf67cf22ed792dfca4055f2f04d631d760cb61d495373c2931e48bec3b8aa4824689240f6ded99a6e5bf3d96bb0be2664c1b9df707675d7997f61d5416cf1ea0e85a36f8a9d41513533c07b4b0dc116d9659cc6ce9b619652f6f61a5c4fb43626eace1aa0f22fc979de178d87340cd622cb5786d6890375bdd735e9d93b9b6b20efb41054a22cc50a8087582b1ecf4d15a31cef6a1c5a4732275b4241baf37afede4aa7b9ce78d796f6b7f3d07aaf55c4a00e6125646ab0f8c3dce36d54ccbc6925b3a79f54e172d4bccbd95de746879bf95faff004b2891f03cef7992a089a670fc57cad3e5e0bd08c104249d2fd556d6e354d44eb1377ee1a352b5c7932bd6319e5c78cef2a8b80703d25280f9ed34a777386de000d82df61b87d252b5a228dadb7416baf2977b4602a5d146e860c875331dbe00a930fb4681b674b8e53b0070cc194cf758117fcc2e6fa2b7f17265ed9ff371cea3da219d9181720294d99ae16165e0751ed55c6b1a22ad125333f1f62e6e7f2d4f2fa95a7c17da8d354c8d0f2035a35734dc0f31b85178f3c7e899e197aaf572e07926640d737654f43c414d5cd698e66b83b6b1565da5c68565725fc54d8d53b4c52586e0af07c5a8fb2c5e4711a3739ffc4afa0ebda248de3c178af16527635af207e3d7d7453c77592d9cde2c954d5173e8f2fe07b72dbcd593aa80a695cc3ffbadca7c2e4aa30f1db43aea3bc6de1afe89c1507ecd1906fda069d7fd3fb85d7b70d9da7549315492dd0b9848b78ec98ae7304a4b7dd90e61e171fd53a48923a7946b6b30f3d6f71f229bab8cc9491c96d447b788247d2cabf69be9a1f67d8dbb04e20c3ab81b0866c9203cd87ba7e4becda699b3c11cad20873415f07e1551692ed36bd9dfcf815f66fb39c4ce27c2b48f7822588764f07a80351e0775af1fe9cdcf3a95a84210b573042108042108042108042108042108042108112a44a80421080421080421080421080553c5189330ac0eb2b1e6cd8a32efe9fa2b65e75edc315141c1d2c3ddbcee0dd4eba6ba7c1572ba9b5b09bca47cc788c8facc51ed241739f77106e0ff002eaaf1b9b3cd31bdeddd1e405829b4b2ff007a9e57682260d3a9d495515e4ba3ce77702f2b8a7b7a57d3375325ea1ee1be5234f22b8c3da43dce045a3606f9927fe5213732c9d0380f3b7fcaea91c21a52e75bbce1a787f02ea8e5bed0e4b3253f98fc82bdc02ecec9c35b3f379eb659f92e6a1e4ee345a4a00ea7a685c4e51a1fdff455cd387b47af98b69e5693aea1311cb7a58ec2c5c2e3fd4137893c8a73aeff00bdd374ee2ea6658681e6c7cf97c94cf49b7b6e785ebb2451c6e3b0b05b8a5c5db0b353601798e0d30606a938fe3cea78d94f4cefbc934be61dd1d56370b957563c9309b6ef10e37a7a222f337c4730a9ea7da544c707439a4ca76bee3a1fe725e6b143555f5222ed1d238bb4001b7995758af09556154104f505c1d338868e82cb49c38c9db2bf272caf4db527b4e64bacac744d71194e50ee7adf5f557741c61435e3eeea68e47176911718e417ff005003e6bc26b22753b9ad2f76a2fbecb60ee1fc161e12c2f13a4e211558ace5ff0069a160b3a940be524f3bd87c55e70e194de94ff6339978efb7ab455b435ee311b4335af91e2c7cc751e215363940d85a5ed1f05572f0171350f0d5263b4d3be4a39a36cad6b86ac3e1d363fd549c1b1d38f50494f50c02a621627f32c39787c2f4ebe1e7f39daae8f11314e00773b15e8dc3358248da1c415e4124ae871573395f65e85c275443da1db2e4e4e9dbc577d3d7f07943b292af262c36cb6599c226bc6dcaaf58fee0baae17a53931ed031390c6c3e4b198a563c13ae8b5d8b77a3d166eb30933c4d2d1de79569ed38dd463313c5a48865602e91fa347558dac38ae2733a9f0dcee6ea25a86b6e5dd403d17a154f0a3f1ea97524713a4c8350c06f25b5f801faad570960b414985c94d1470b6478efbac35d36f25e8f0c9ae9c1f237f6f962ad925217ddd96c6da6eb478170cd1625c178963951c454105652ccd8e2c32403b79c1cbde677af6198f23ee9569c73c25361d8a4f492c39752637f278bdc58ace61bc35319ef0c724d25c0cadd4efc95ae7e3b97db0fe2b6cb8fa693823d9f4fc5c6ae06caf64d1343daee446ca0f11f0663fc2d3659e0b44d25bda462f7f45eb5ecd6ba9381b07aaabaf7e7ad9ec1b1016c8d1f995663d5388f16d5ba60eeca0713dd6e8e23a6a3453729319bf663c59659dfd339ecdf1aecea3b07486370b684fbc6ff55ed186d676ec1adfc560301e0ca78a4ed4c033d85eed170b7b87503e00d68712005c3c9e36ee3bb09719aab2922cf11b8baf29e37a102598dad6b1f9af5c8d8eca41d96178df0fce24b37df691eab2deac6d84dee3c3668c44e9dd6f71ba7ab87e854464dfdca0e8c9037e24feeadb188b2070d8bedfafeeb3b0c85f472b79fbe07910bb31bb8e0e49aabfa291a699edfca5aebfc94a9431f4d91ae24b5ee61bee37fd40557864d9c8683a381055886d8cb63b86c9e5637517d91030d003e2b9b0b9615f58fb10c5c57f0f08cbf33f235c47423b847fe23e2be4b25cc9a561d0b5f71e97fd82fa03fe9e71521d253b9d6647296fa48d047fe4cf9ad71bf930e59bc1eff74210b671842108042108042108042108042108042108112a44a80421080421080421080421081095e01ff50b8c99f12a2c2daeeeb1ae91f7e7736ffea57bf9b597ca9ed3b109f11e2faeadb96c71931c67c01b69f33f158f35d62e8f8d3796d819096d34aeca03a520fa9ff85438cd408c3da36cb657f5afeec62f7bb8bbe1a2ca62920792791d75e7fcb2e7c3dbaf3ea2a9c348e2fc44fccff45c17831e51ee8b91e3b21ce36cff008ac7e25352774d87e5dbd574c725aea288cf571b5bbcae1afc8feab4758591c31b5a32e620dbc37fa2a7c0e1edaa4122e5a0b45fabbf854faf7f6920b6c5a48f5dbeaa997b69c73adabf167014d137adbe88c323ed0f6407be05bcf92e719b76ad8da6ed6b8fe8159f0e509a8ae6b2c6cd68bf85b7fd55be8c66f23b4ac9184060d48bd9375546e967cd2169bd8977e5f8ad7d3e10db97b9bcba7828d558439ce07291adf6549948e8bc7b71804585b3266bc12b4fbee1dd7f895b9c670e8f887877ecf0d440f9a222485d98589b6d7f159ec2f0381f159ccbb8ee7aab5ffb3daf60ece7918e26e4b5d6d7f65139b1df6bff0005b1e69896013005950d2c958750ed08577c19c112e23571c3999142e377cd29cad60e66e77f25b31c33534f246c152e7b0df35ee4ab6c2f008e998e73c07b9e46afef683c1567249f7d2dfc16ddc9dbd26bb8c386b0ae1c6605459ab041108816b2ecd0580bf9af9fff00b2aaa8f1a9eb591f6113aeeca741bf25e96608a998e6c6c194ea0580b795964f8966258ed6e4f8a9e4e6f338be34e29d31154f1538b195a37372b6dc30ecb3b2fcecb1b4f4b69cb8ad7f0fb48a88c01cd71f2de9d9c13b7b06066f1b4efa2beddb60b3d81bb246d16e4b42cd5ab3e39d2dcbed02adb985940998eec8b469d15bcece6a23e30e04157bd552317517a7aa909ed617126e63711fcdfe6b355704d14ee969669a27bcdcb838dfccaf48adc21b3ea000eb5953cf81f7ec5965a639ebd2de38e5ed87a8a2c42b1acedeadf54d07dd94dc1d55ae0fc342290b5b247135f1e6397bbaf306dd415a38b03693ab74e46cace930200821ce1a5b757fe6aa5e1c22ba878530ea70248b3092d7195c74e7637dfd55ac383c24d844d02dc8680a9d4f863a223bc4dbaab0860ca2c6c552e76fb57527a44870c6463ba360a4c3164df92961800d123986db2855cdc00a8789295b5148f396e5a2eaf1cdcaa0d630491b9a40d967955f09aaf9e789a8becef91a00b4721b7fa797cacb10d776523996b02f703e442f59e36c3443883a323fc56103cc6dfa2f28ae616540be80e87cd75f15dc737c9c754fe1137672b58e1a8362afa1bbe668fced2cf88b7d42ccd33ad52d713a3acefdd69695cc718de486dba75fe0f9abe4c3042aa169e391f6cf2652e03cadf5baf52f60b5c0711c940ebe5aa86cd20ea248ce7691ea1797e2ccca4bc681929601e1b8faadcfb20c4a9e9389e95ce0c1299a3746f26d6bbac47c1df257c6faacf29d58fafe370731ae1b1175d2e63b6516d974ba1c2108420108420108420108420108420108ba1073baeacb95d5901645908405916422c80b22c8b21008b2116415bc4588370bc1aaea9ceb648cdbcd7c8d8fe252d7d7cee90bb2bde1e41e67fa5cfc57d21ed7312652f0e494f9f2cb358307e62481fa95f30e2123dd532768fccf73ae48e64ea4ae6e6cbbd3b7e36335b546232011bdc0fb8d0c1e7cd64f1493bb61cc5bf9f05a2c5a419401a12493f41f42b2d58eed2470e40854e369c95126ddade4355c3c17ca4004e96d13b296b1d62dbb801b9d364c891f2388274e9b05bb9eae3028cb013ccb5ced3c8dbe9f35dceecd55e00fc2daaef0b6b18d7bf3775add0f5d80fa28cf73876ae3bd88bf99ff00959fbad67510a7bcf531b46ef36b7995b0e0a844b2d45464d1c4869f33fb2c6878156d70d9af16f42bd0380a1b51c3a7bceb8f8856ceea2dc33793694f876760eed89f9292cc10c832e5d55ae1b133b3008d4abaa7a4175c5966f531e365a1c025a7d5a159434d52d162c5a46d2dec32a7bec83a68b1b9349d334ca59dce05cdb5948652b86e6caefeca6f6cba143a8ec2f649926b3b58cb348bd962b1e00388dd6f71468635d61b2f3ec69f9a5214cc9371e94d0440bef65a4c000fb5b05b9aa5858010aef0421b54cbed754ca984d57ade0e018983a85a185bdd59bc09f9a36dba2d2437c9babf1fa67cbedc4b1df7506666575c00ac6516d0a8b2343c10ad933c2998c07e9d124b44d935b0ba56465a5480ed2ca91a5ff8571a6c8ed35013f19cb6b04f388217000e4a4d6fd9e6380082f171ad936d6a7638c1dd5b6a78c8718736e138d04dee1751c61746c15b4a234c2fa594399a0e8a6c9a12a2ca3723759e4d318f35f68d427b215006ac21dfcfe725e1f8bc404f2b41d8e60be8fe31a76d4e1d335c37690be74c59bfde2c6d9812d3e77feab7f8f7a61f267aaad84ddcd24ec6df15a5a22d96963737576622de3b85986019cb7620decaff000796ec2d3c9c2c3e23f65d1938f1f6918a445f1cbadc92d92de5a153b81aa9b06330b6425b70e6875f625a7293feeb28f5203df7ca40731cdb1f03750f0599d458ad3383bbc1e35f10531f465edf7660f54daec3296a9a6e2689b27c402a6ace7b3fa8351c2f48d7105f097c4e23c1c6df2b2d1ae99e9e7d9aa2c84214a05916422c80b22c845900842101645908405908b21026c952592a02c8b2116402122102a2c91081505221c6cd24f2083c83db162026c46281a5a5b491191e4dcd9c741b2f9feb1cd134ac63ae18490eb5afcaff0025eb5ed26adf3d65539b21636598173f6686f4f95fd578dcb2019cef99da03d3f817172ddd7a5c3358a9b14907680924e51b787f2eb3b62f738ff9ae55be28fb891daeba0fe7c55439dd9425d6dc9f96aaf829c88952e06590f579b7c7fa2e216e675c8ee8dd1302646b7724dfe69d8d9773626ea49b1f12b560baa7776185926c1cfb7cf5506725ac633aea7d14ca91922821b5ada9f82af9e43da5fc2c3f9eaa98c6d95d44366b332dcddfaaf56e1080c54910b6a1a2de0bcbe8e2ed6b6165f73afc57ae70f90c8c1b7a2a73dd46df126eb738558b5bc969e9180d966b086f75a4ebcd69a945ed6365e7dbdbd7935162c8ef6006e9dfb3d8229812058a9434d4ecad233b4d369c5b6b28f3c3604d95936ce0a255b6cc23c2c962256331db343acbce71678ed6e7915e85c4b2e46bec3cd797e25519ea3203724a88db27709cc458ab9c21a0d437cd54d2445b6bad160b4f7903956a23d1f878fdd335e4b5700ee0593c0585a00f00b61003d90babf1b2e635293750e47104853e560b5d4099ae20dbd15b2530113c11627509c2406eea15df19b90ba74877baa35d1d73ba2e001b5f54df684a71841d54a74799aa950b2d6b7c1468b52ac2959722eaf8b1cee8eb1b66eda26e5214c73406e8542986ba2bd9a638ddd429de5b750df25cefa29738d157caecb72172e57b75e33a53710f7e8e51bf74af9cb1a01d5b2bafa895c08f5fe8be8ac71d9a925e7dd2be76c5417d4cd71626627eaba7e37aae6f95f514ed70ed46fe6adf0739ae34d5877f0d7f454ae25b3e9f995b61ddd90907bb9adf3d975e5e9c13daf2e5c6393a5fd7707e8a98de3a90f1a16b81f51a7e8ada95d78e789d7ccd73b29f5baafad618dd23c0ee87826fd0955c16c9f60fb27c461acc14362ce098a190b5c2daf661a48eb72d5bbb2f24f6075c2a3008185b95d1c4621a7be1a6e4ff00e417adae9c7d383926b208b210aca0b2108405908420116421008b2108042108112a428e481517488401421080421080517159bb0c36a65bdb2c4e3f252955714cbd96095367069780cb9e57517d267b7cf3c715b23a8678c4976be596ed1a001b95a0e9cc9365e5d5771616be504dfc7fe16c78b6a659269236b9a2cf7324b3b4be72e3a7c3e4b15547422f61afc3f965c39dede9e13519dc4dda88fa9baaaab20421a39e9f3fe8a7553ccb52e3cb6502a5b9a66460e8353e416d8c61c88eeb31c24e76b37f752b098b3d5c77d9a0b8eaa13dddaca2d70d1a01e0adb0a6db3bfa0b5d5f2f4a63dd39592992671e40587d4aaf97bd57133f33ad6fe79a9533f3bc9e572e51a26b5f8b400e833341f8ea98ad9bbc241fb7c7b0d743d17a9e06f600d6b5d7039f55e5b875db54db8d5abd270090d9a6fe6b9fe43b3e13d230920b42d2d26c0ac86113dac0ad5d0c80b46ba2e0fb7ab674bba7782010a534ddb72d55b0cb96dcd4f8e56903c56d8d63943ecd35e4a1620f635a5db689f926ca3cd50e3f5c20a77b89e4a6a24ed89e34c59b4ed78beab0b85c1f6b95f52fd75b351c598a3eaeadc335c02a660600a38bcaeab66a34b77523b2c8468b4980b2e069e2a95c1b9812af706958d2db5afb2cf46fb6e309ee58ad861ceed232de7658dc2de0b410569e82a326caf87b67cd3712a5658db928ce8eeeb27e5943ee7629a6b867175a309d19969865b9d9409a1735a40dc6cae1ee69075f45024dddd0aae53a6bc792a1d3e43676e9d8276bb99b28989598e242854f5767d89b2ce3a75b9b69e092e458ab08aa2cc2085414d51703553e1a9be855e5d30cf1dacfed24f329b7cdbdd30240764875e6ad6b398c849dd70abaa35b952e73e2abea64cad2b9f2f6df150e3f2e4a39c836b30fd1780553c4d5b2b7425a46de44af73e2793261352f3f90af0099e595356e1705aeb69f0fa15d9f167e2e3f977f2915b51a39e7a382b3a47e532db62187d556d51ee487997053a175b2ff00980f90feabaab877daf291e5d58e6bb5cc0d87a0fea926689a610dc074cc2c17d012351e49b6bb2e210b9bcda1df54ed7f70c6fb5dcc70779d89fd02a63d569674f7ff00fa7c98ff006053ce4584750617137fc43eb70d5ee575f387b06c45efa4c4e83338362ab8aa5a3adddafc97d1ed3702cba70f4e1e5fec5ba44b742b3225d2a2e840896e912dd0174896e8ba02e912a440b7422e840852a44a804884a81108420108420152716e47e1ed8a4ff0dcf19bc0004fe8aed62fda806bb0020b88738968d76b8372a32f4b6337647cd18fd407493c99812e95d6bb6c74b6a564f167f671c84e84e82dfce9657f8e9c950d8ae1c33971f10b2b8e4d9e56c57d85cf9ae09775ea653514e5b6ef137bea556ceebbdcebf2d559d490c8adccfd1544bdfcd6e766ae8c5cb9d711e9736df4055d403b0c35a4e8f909f82a88d99e4646cd6e6c15d569682c681a3000029c91844371b0bf23cbc0284c90fdabb4db290a554b80cc3f28ca14285b727cd5b132f69d48f636aaef3ab8dc0eab7381d59006abcde794b2663c1b5cad8e13563230dfc965cd8ee37f8d9eae9e9d85568711aad7619541c06abcc70cadb01adb9dd6c308aebb1a412b872c1ec639ee3710ca41d0a9f14b6ef5c2cfd1d497347794efb606b757249a4558d455b5ad26e2eb09c618c06c4f6076aa7e318ce5696446eeeab0f8b896a6ee7926fd55e446f4c755e69ea5ce3a8255ee092b7b1111362d50e4a500edaae5ac747a8b855b08d14f514f0b6f2cad6f994b8762d03a5fb999afb742b2f531cf2dc8909bf52a1c50d453cc1f1dc381dc2d31d2977b7b66078a82e02fa15b3a2aa6968b15e35c398d3ecd6ced2d775e4b738662a5ee0d0feea9f19116dbedb1a8ac6c4d2e73b40b3d5dc495ad93253442d7ddcad208db52d05eebf85d3f161f00398462e9b46324f68b8654e2356d0fa8688da7e2acae09ca13ac8eda5ac174d6b41b2a6516dc53e274d76120725929e5752ce6fa8dd7a1cf03646ebaacee2d82c4f05cd1aaa58bf1f26ba41c3f106bac7368aea1a86bf62b192d24d46e2f8ef979b55b6195c4800dd434b36d54726894cbd1438650e6e853b21d39a963a74e7e6ba815773717520bfcd4792c6e552c4b1fc7cfecf019da342459783be4b45393a9927bdfc2ff00f0bd97da956f61853e307ded3f45e2b300046db5b4cff1d7f65ddc13583cff0093779a2d592227123de70b7c14e88e67c4478e8a1d60f7180eca440407b1dd0d96d7d39a7b5cdecea47df52c03e054cadff0da4723cfd3f75066ca2385dfe507e6ac2a1ae7c5769d6da11e9fb2c5b3d27d81cacfed6af84c8d0e92316cc750013aafa7689e24a485e0deec06fe8be57f6310be1c6a79e3bb9e291ce01a7fcd6b2fa8b079db538653cad0407301b1e4ba78fd38b9e769a8ba10b4602e8ba1080421080ba108405d084202e842102254852f240884a84088414140211c90805e79ed664edb0fa7a56921d238dbc2e0807e6bd08af20f69b5afabac92265ce463b264be62efe9754e4bd35e19bc9e058c4ad7d7cef36cb98806fa00b2352f35359238dec095a3c76668748ecb6b9b0b2cd173a312bedadec3cd71e31e864815ae19c8d836fbf3b2ac93bad17e66e54babbe61e27e8a2546e07e5173e257463e9cb91fc3632fa9693b36eef829d3beefbdfdd1989f1e498c35a032471e8180f87328a87dc1e45e6fe4145f69c7a88b2bae3e69a88585f9a598df64add8792bc551aaf476da7257980d507c396fab0aa0a87932007984fe1157f67ac683eebf4299cdc38f2d65b7a461d500d86be2b5983553b335bcbe8b0f86bc777c569b0998c73b7312015c593d7e3c9e8b419cc7b9462957f658b31dce80277040268c3aea27175348c8e391809b3b60165bedd1a57c7199812fd495598846d04b6db2bea36092983ad96c163f1dc7218eadd4c5c1af1c8f3533751959119f0095fa689c3406daa669aa9848371756b04ac78173bebaa8a8568c3ee7656187e08c91c333375614d0c6643702eae68a38d8e692d0a3c97c70d8c3386236b9af2db782bcfecf6404646daca652e4ca2c4593ee65df62ad29e2770e6b9b63bab989a6d72aba9064b5c1fd9593656816babc8c73dedd037d920b5ef7d53725432307550e4c458d900cc07928566353e57777c15656ccdc96beaa3e258fd25140e965998c6b45c973ad6581aff685f6f7b86174d25546d3fe2b059b7f03cd3c6df4b63d3552e59896e86eab18e14b5a233a03b2a5c3b88e77c8d74f4ef8c3f9595acb20a89e278d2cb2bd3a316aa8c9ca0837531dab6ea0500b4614c0fcb70544677d9990104eba265ee01a492bb9650e3942acc5ab5b434724af360d692adaddd2b5e4fed5f151515eca269d2e01f2d6ebcea4944b5ce70170361d3c15a71162a713c5e5abb9ef0b3473005c92a969ac5cf90dec5d65e8638f8e323cacf2f2cb649877bb427537b27d8e0cecedad8fcd44aa92eef13f21fc2a4c36735a0a9c99cf6b89ef6632d6ee023e20ab386cf848b902c6fe97fdd563dd77c6072605674273399adaee22de05635bc7a2fb1090b316a880b1b99f0921cedc119ad6f55f4b70e171c1a94bb42597b74beabe6af645186f11c81af197b07d87897002fea57d2f80d3ba9709a681edcae630348bdf65d3c7e9c7cfed60842168e708421008423440210840210840211a210214bc908402108b20428b21080e4808e48e4811db2f05f699571c55b521d23d960f8eed76ba1e5e796de8bdececbe62f6cb33a1c72a8e7b02f2d0dbf21cfebf158f35d4747c79bc9e538bc85d20b6b99d72a86a9d6d1a740ad6b65cc72936b5b5e975515a2cd7f2be8b0c5d79556d41399a6fab469e6545905e503a6a9f95d9de4f53a04d45acce79e44903cbfaade4e9cd92c618888191ec09b93d345166797c8f3d34014c9018291a49b3b2aaf1eedc732a276bd3321e5d4aebf0ec91e0e84754a4da327a5d59440aa3f7ceb6c2c026b3963c11cb509ca917792135bf749f22aeceb77815609e18df7d79ad7c0c2f8c3da750345e5dc3f887d92ac472e8d7f74df91e4bd3b09a80581b7d6cb8b971d57a7f1b3f28dc706e2e337652b8dfc56e6b295b5b48eb6f95790c323a86a9950c361cc78af51e1bc55b5b46d24dcf35cb9cef6ef97719e84c94cc7c330ca41b2c171c70e32acfda199b3f50bd6b1da08ded323458ac56211b8c4e63b5b722a71cacf48cb1dfb7910abc670a7774f6ec6e991e35f42ae709e2d33c64c8c746e61b381d6cae2af0e8dee37685573e051ca486775c47bcddd74e3665ed9ff167ef0ad250e3c4b1b25ecd70041215cc18e975aef16e8b2b434cea0c33b3a9ccf31b7de6b77f45aec228e9f10a1120683dcbec9fc73f47fb19f1ff0078bba2e286820102de6ae19c4113803adc8e6b9c0f84686a69e37c9134dc0d568bfeccc2a9d914bd98d5c2f77120a4e1da6ff90e3fb8a68b1e7484b6363deee41a2ea540ec52b65eca2a5941dfbdddb7c56df0ec3a828e30238e268f00024afafa1a0a80e91f1b2ecf52b59c31cd7e7dcaeb0c5943c398b3a46b669591877304b8fe8abf8828e8f87453bb10ac99c277e4686b49b9b5ff00082558e3dc6a5ef63681b72d76ae2342b355f59558a4a1f59217db61c828b30c7d3af87e2fc9e5d5e4be33ff00b64f88b008b88b17350f74bf6166511c19880e239bbd56b387f87628601f7400b5800360bac370f334cd36bb42d752d306b001a01c973f2725cba8df931c3867860c8e2582322612c6586fb28f4b4e4482e35165b1ad803d8410a85d4c239f6b6ab9eab865b59d28c9105d4d280085c446cdb725c385cd8a98cededc817373c979afb5ae286d1519a28aee92417cad3adee2dfcf05bdc57128f0da492579000175f36f1b6372e318dce439c46805b9b8f21f15d3f1f8f776e4f93cbe38ea2a03de58647b817c84b058e840d49fd3c827e11f777d75d5477d84ed88105b13328b75fe5d4992d1301bfba365d95c18a24ee2e9ac391b29f10d80b7455d00cf30bebadcab5a660925887523f52ab918ac59675491e5f453e98d8c647e13a7c0aae82cea8bf57d958503dbdb87385da1c0dafb85958da3d1bd994d251713df21bcd1961074cf770d17d4786eb48c279dcf95caf967842adb257d13cb88609db7d6e43ae00e5b58d97d4d87383a99b60001c82df8fd397e44f55290842d5cc108420108420108420108420108420429522102a44a92e80e6845d080e484210238d9a4f45f24fb5dc50e25c5d5992c18c765b5efa81fd17d39c658db300e1cadae738073232197fcc765f1ce25546bf14967949efbb3382e7e7bf4eaf8d8fbacfd738b5c58458daff154f573075380fb8ce4d88e43456389bf3d4bac3287036fd15355b8ba1d360e207c94611b674c4ec7452ebb6a411b15c5234936e6481faa42f7199d737040247252291a1b34206e492474bd96ac127117e639058f21e4a0bc650d1d02913bb34ae76c2f6fd14698defe1b2ac8bd72fd9a2db123e8b87b7eedcbb7ddcf69e46e52381ca478ab2b55cfdcdd32edd48919a951dc75b2b33a18e2d7020eab7fc278d0ac8446f77df45a11d4755e7ca5e1959250d6473b1c41691cf754cf0f28bf0f25c32dbdc6078a886e4f257fc33893a965ecef669e4b03c3f8dc75f4ed7b1d63b39bcda56969e6ecdc1cd3cc2e2cb0af638f925ee3d2e7aa13d393be8b275d949713a152f0ec4f3c41a5ca062cfd4ac35a74ed9cc47eee4246c4aae924ec5c1cd3bab4aa02569bee155c8cfc2750b48ce6565dc5be1d332a800fd49f92d0515198f485c466d0db458ea40f81e1cdbd96a70bc4090038d96d8e55e970f2619cd64d6e175f518752b216bb33636e505d73b754e5763d8a545308a39628ace6bf36424e86f6d4f3b2834b3b1ccf45218e88026d707aad25a9bf17e3ef7714d8b88f12ecf2991b7ead6aea46d4623674ce73ddb6a5418a5636da006ea7455121b65d146ff69f0e3e3ef8f1909250b69a3ef017519948ea892c0003aab1746672d0e75d4ea7a66420002e163c97f4c73f91a9dfb14344d818d0079ab4680d68b68a3c6093709fb9cb62b28f3f2cbcaeea3d53811655b2c41eebd9584e039d651cb480ab56951c00d6d8f24c4f208c1713b272790379eab31c4b8c7d9a9ded69d4ef657c70da9965a623da6f17e48dd0c5259a3a732bc8607973e4ad95da0072f8badbfd158f1256cb8862352e79360f360792a19a52616c6341c82f470c649a791cb9db7753f0b6f6d2891da92e2e3e83faa7eb0dc868db75d61f0f654a7ad8007f9e69ba975c0236b2b1eb17146dbb9c6dc8ab3a76d9d987e16ff4fd557d0ff82e3e365671b432071eba7c15324e3e9228d9f78d2ed8baeac28e170702f16cda8f2d540a705a5b7d7dd6dbaff345654f3c8dabcc0dacdb790b59676358dd70bb8c0c64ec717b23c8e208b0b8734efe817d5184baf0e9eee56907adc5eebe57c02599d80454f1cad63667b8169ddfeef2dcf82fa7785aa5b558452cb6cae313411e4d03f45af1b9fe47a8ba4210b572842108042108042108042108042108112a44a8048950810a10840210b31c7bc614fc27825454b9edfb464b46df13b28b75369c65b751e59edfb8e6391f1e0147287906f358e97e8bc4df190c73dc2c2f61a2b47cd263b8bcd89d5bae493724ed7bedf35031590ebb0616581b0be9a7e8171e57caeebd2c3198cd465b18700e73c1beb60a8a677dd5c13abdc2fe8d56b8a485ed2edefdefd154d40feeec73ae3be4f9edfb2d78d9727b36db66ce74716e9d0a7691d6aa61d6e096fd1460ecd207723c9750499278c9db31f45ac6493a9bdc6b727e69970cda754eb9da9b1e8b965c1711a585eea1246069ee116248b1bec94b0768de97175c47de75d3d0eb2b3cd128b554a585e6da02ab1edb4842d95651de8fb50def3e5240f01afecb273c459553348f709055d9e48da21bba5035b20028a2e700c525c3ea43d8e36bea3910bd3b0cc522ada76491bb4b6a3985e434970f5a4c23109a89d78ce97b91d5639cdbb3833b8bd5e8ab4c4f1d14daba96cf103a9594c3f11655c4d735d636d47456f0d4f7030ec5736783d1c79371c4b704a8c62ed0f8a94fb11a1bdb64ac849b39ab35cd4111bdacad69232cb16dc5f926e9e9f3eb6f256b4900bea15a65a5b1dcbb87e9e62c00653d14a8ea0b8e5ecdc392ee1a7035014b8e36df6d53c9b4e6cc434f2901c00b2b2a5824d09d1710b8d8651a295139e4d8055dab972677dd4d86202c54b6b6c45f651a06bc8d94e861738824155f6c6bb8db71a05d38651aa7db1e51b2667dedc92a92eea34875bf250aaa6c9b291532658c95455b54e964ec99af928c66ea6d315956e712d6eeb27c42d26191ce37b05ae7d23a38c93b9dd67389200ca4949d34d56b2f7d29675b781d70124d5727f9dc554c2cede46721987d55857b9ed133f917dafea7f650a9cb5a438022c6e42efc5e4e5ed741ed652df62e04e8a14d202dca072dd393bcb616027668098985c1e975317caa550b6d0b2e37372acd8c6ba36b7fca49f9a8145de8a3eb62558c44b9ed6e9622fe972a2cda67a771b8ba7691f84feca5b0963a691c7dd680a2525fb504f52a580e0c99c7504dd65945f1af45e1ba68db84d2d4e7b3db3d834d8d9a35b0e775f447024ef7d0ba12d2c6c2f2c603bdb92f02e0002a3871b2cae843692ba27b8b87780bb46fd355ef7c1b5114b555fd9b8657c8646006e2c5c755a62c797b95adba103642d1ca1174210225ba1080ba108402108405d0842044a90a540244a910084210335750da4a692776cc692be5df69bc435bc4b8d881ceb02e24348f7403a6bfcdd7d2dc46f2cc12adc05ce436f35f2a714077f6d624d735a240fbb9c34b6c6f6e5d161cceaf8d3dd41a686386962ca432d1e77e53704dff006faace711cc6294b4e86c410391e607c95e9796f66d98b58d0c60b5b4cbd4fc564718a81575ceb1b8cc493c960eb54d510400e3a0d0dbc1566242cd6341b9cbf0d6e3ea14f75e59991b772401e172a062a6f5048d89d3cb60b6c239f3a8d137335b61a8d170ed0f96a9f80650d077b94dceccaf75b6be9e4aece9f0fcedb8f3f54e3c011b8fe6b28b13f42de60a90f378da3c14a639846a7a2762d0b48dee928db99ed8f9927e29d8599ded16d0b87d428dadf4b864cd0da46175c46c73dd7ff0068593eddee6d41b34895c4d8b76d791e4afeafeefb6782746160d76e5f523e0a832fdc5f6cc6c3cb9fd568cf2f6824d9eba737be47aae5c35b8d93845c348e8a2a90f528ef2b8a55554adbbb4e6ada9c5acb2cdd1c4b8a0aa929dcd2c7596ae8ab454306b95cb1d00b2b6a298c646ba2cf6ebc7af4d3b24d729e8ac6888780373b154704dda3402ad28252c3ae8b2e4c35dba30c9a0a6a66b85959d2d359daaada59816def65694b5003c077a2e6b5d322ca9a061dc2990d131cff0077451e0707d80d0eeace9ac0db9a896a6a4d351460001a2cac21a38afeea62175aca64530d8ad246396d2a3a3601b5bd1762268b2464e2dba574cd02c2cb49a6176e647003455f50f23552279802555d6d4868363af20a992f8cd20e25547fc369d4a66868c001c7776e961a73349da49bdd59c50b58c160a252a2cf0fe10b27c60d0cc3673d1a56d9ec1626cb19c6401c3aa2f6f74fd15b1f68b7a7cdf8e0788637916123b96da0feaaba03948bec77571c4c0de9a2e595cfb799d3e402a66020eabd29e9e4e5fd96139ed6016e657328fba16e5bf8ae6126463a2b807978a48dce0c731db03cd4c85ab0a024361d3420ab18db6bbbf2b00fd557e1e330841d2ceb7a5d4c3200d92da5da0fc95b49d9ea67775aee6e71564d6092268272071373d2ea9e9a43d9b5df946815ac3238c0e075363f1b2cb38be15bbf67b2c0e8ea69e673bb36bdafcc0803bae06e6ebe85e1c647498844d6b9b99d3cb1388d3701edfa15f39fb3dec856626d92944c442c91a01d89234b7aafa2a88c72d250e2cdd2e69a593c8b72ff00f63f04c59f256e10906c9568e60842101a2108402108402108406884210214bc92254089508081094208420cdfb41c49b86f0c55499807b806b05ed7375f30e24d93b6ae7005c5c2f23b938023417e96f8af71f6935d2e29889c221b68cf7afeefe6b0eb6d178ef193461d33d94ae736199bab79b6fb93e19815cfcb5d9c13518bafaaed5ce0c2e767686dce9ad965a798f68f02d720ecacea6621ee373a8ca0782a47cb9dd2116e61b659631be54919cad7c837b860f555d59de91bd2eac1ef0d87b3d34b12ab6590be43e256d8b1c9dc400ca790b9f9259e3194ea2ebb8631dd6df7b049502d1b9c41b916568a2bc3ad2dc69add4bed2cd6db4d2ea1b7524f4521873792521f83bb30e5670fdd4fa38cba4beb61a9b798501ba482fb107e8ad70f3943aedf7d845fa051f6bfd2162ae2f93b2b5816f7be3755f56031b92f6cad00f99d7f9e4acb1719710c928b3486978f00d04aa3aa9dcf792ed4925ce3d495ac6391a9001603cd74077024634bed7df74ec91e48dbd4a221ea4d0ab8a66661a2aca68ec010aea91976ac737471449846da29d10b59311b34014889a7758bae458534e5a40255ad2d45dc038efcd51c66c41532292e429ded69d35747556b071d0e8ae20973002f7b2c8d256016649b0d8abca4abcb621c0dd63971ba30e46b28a6bb877b557d4af6d81bac85154b1e416bb5e8ae20ac0cdc9595c34dbcb6d1894b75165d36a41360755550e20c732c5c10dac6071d46aa64517f04f7dc94e99837bdcd50ff0068345ac4dc2ed92d4d468d05a3a952a54eaaac1b0372a208dd3b81374f4548196bddce3b92a64708dac8a5cb4629e988209d94ac8d68bd85d7562d1b12b826fc8a85368f29b5c7258be340d761f333f30b12b6930cd73a2c3f1c10ca62013e2a71f69be9e07c56237624f0d168d81ac1f0544e8435da1f8e8b478f50c8f71a9703966cce07c01b2a89e99fd9b642e0e3b1d57a78ddc7979ced148bb411a38735219209b578b3868eea88a32597001e454677dd496b96b81d0f8742ad15ab7a1610e1670730ea084e549c999f6bb485594f3ba27768d3b1b900ecaddc45402c6904385c5b62af10e61b8611b5c69f3fdd4fa2973656f890ab05dac0c3a16776ea4d338c6f05c7476c7c5679ce97c2b6bc1334b071242d89c4999993bbfafc17d438247f68c0eaa176471742ecad8cdc0235b0f5217cadc3152ca4c770f9de0766d99a4fa95f53f0a98a07c91b3386c81e5a00d2e0d8dbd0b5530395b0a39854d2c530d9ec0ef884f28d86c622a28a31b30650a4ad1ca1084202c842100842100842100842101b2117b2101645908408523ce5613d05d294c574c20a592471b001079571307475b356bbeedb1f7a72ddf30ef1df91247c02f1be25cf594df69398cb5123df25bf05f911f1fe15ebfed13138e8a84cf1c02495f26591bcb2daeebe9e65797e21466830d18831e0baed396e347dee45bc03469e2b9f29dbbb0f5b796e2c432a34b1686db454f16b36a0650159e38f2da8747a663de36e44db4556cb35ec66f778f555934b5a62693246e24dc9d5448c5ce63f15dcceed1f94ec0ea42e991e963a01a9fd969274cef75d30822f6b5f6f24d574c4b4334165dbdd94dcfc132632f7073afebcd5a2299b648fc53d482c1e08bdc5c787f355c6432c995bb05329a2fbc61b1ca343e2888328ed483bb5a08f90fd55b50c7da9647d4e5bff00b4aad7c64ce74d6dadb96aae70b191ec940f74978f3d87d5567b69f4a9e219bed389d7319a9ed4b633d1b7dbe4154454ce73032d7075f25a5381c95133a52d377124f892ac63e1e2db3e4162770bb31e1ae4b94da830cc064ab7d9add8127c943ac8af2065ad9797aaf5dc17869b4f4377b75a8041206a001fae83ccaf3bc6f0f752e352d3c82c46eb4e6e0bc784bfb4716732cb4aea786d941e6ae2821bb5451065ca00370af30ea6bb341b15e6e77a7a1c78ba8e9afc93eda5db9a991416e414b8e949e4b0b5d522b5b4c4754eb232d3756aca436d42475258deca254e9118c5369dd232c5a485c369c8d94da786e76536a644aa4a97b5c090ade0ac91e00ca545a6a469b1215c5152036161659dad252c22592d6245d5952e1cf900cee713d148a5a36b48beaade9e26b6d61b2aecb4d51e1ad880246aac5acca345d31ba275b1dfcd196dcc0c24929feced603d52c6ccba10bb2331e8115b4d9db28b26dec2ff0004f8000b2e5e437a5d13b56cf1bc5c8d7cd6338be02f81d7d4dac06c16ee7d7a5966b1fa71359b6bdc80abeaad3b791e29850a8c28c400ed230ecabcdeb23969e419a325dae84e83c17b8e2d85ba27e42c75afbb7cf9ac4717f0cbcd2cb34170ef79d6e61767072fd573fc8e1ebca30d85b9f5156c616b4079cb623456b8e70bd4d3778c79091980e442a6c0bb476314a2c406cadd3c6ebe988f8428789706a791f1d9dd9fbcd1de1fd2ebd4e0e09c92fede6727278fb7cbc1af89d620b5c34b156b87d4e66d88b399eedbe6b6bc61ecee7c32a5ec922361b39bcd62a4c2e7a47fbc3bba8e442cf3c2e17556c7297b872a2c7bed17b8bae617f72dadda574d2268b700f4f15c472085d6905c1d1dd42a2fe9a7c22704309d40d6d75f4a70863b13aa69aaa23276521602c3adb3b5a3ff00d82f9630ba96b241183a72f15ee5ecd716655d0f63348c676618c24bad621f76b8f86ab09355a65dcdbe88a42d02460766c8f20f873fd54855180d71ae7d4485b95ae0c7b7c6edd4f968add6ae3a2c84590804210804590840210840210840895225402442473dac697388006e4a05bacff1862d1d06192074b1c799a6c5ce02c56538f3db061f80364a6c3deda8a80082e07ba0feabe7ce27f6855f8f54cd254cb76df775ecd1e02f60b2cf964ea3a38f82def26d7da1f1661957805316d63649ccee123233b5f6d3c41f92a1e28e37c0ea709fb351c52f6cd6b32bcbb507210e2eebb8b2f39c52bf3c31b33fba33017e6a33aa58ea233168bbbba3cb9aa4dd6f649d2055cdf6896499d6199da001416bcb666bae058df5e49da892cd69bdafcba0443068d965160750d3cd5fc54d9b74392579e798d87aa6f380eca0ddd63aaeaba5bd4ca1bb971f4d54760b107a1f8a9915d95a4175c5afe295cccc0ddc3c7992baecc97656827c969386380f18e2195869a94b2376a24934681d7cbc4e8af871e59dd6311965319baa5a3a30f1721dafb8c68b979570ec225c3d8c33479657fbac3f87cfcbf65ba8b87287872565351bfedd88b1969328b08fc6e7dd1b6a753cafcabaaf0a7baa649aa0e6924d80f2e43a0fdd7a13e27863dfb61fcfbbd7a612aa9fb29c01d39eeaf305a37492c51b5b72e716fc07f550f166b0e2121691922b071eae2b6feceb0b6d5d499dcdb471b331b8e6e37fff005b2e2e1e3f3e5d3a33cfc70da7d070f8cbda3980306be6548fec76cf551c4d8cbdee360005aaa99218810d007800acb8470435150fad9db61b0d355eef84934f2bcafb468b05ece91a4dc36f93c834171b785c05e2fc674ce7715d5b5edb18c341f3b037f9afa8e5a084d33610059ac0d02df89e7f40be72e3c884bc698b3e317609ac08e8000b93fc8f24bc71bfc19bceb310d28777b70af30fa6b462e2d75c52519360459aae20805834357819d7b9863a730d2dc5958c14a1a751a2729a974f7755674f460b751758655d1223368f336e1a123b0f397656d1d2db609f34a1c392aed6d33628ac7dd0a4c34763d159ba96df84aee3a7171a26cd0a5a70eb02ae28e0cba01eaa3c14f6b156d490f35512a9a30ac628da1b73ba87036ce53d960d53229957434f24fb7bb65c31a08b2ec8d4594b33ccb5b543bc365cb6e46a139616d907175c48dcdae5095da1b85c8d4208eed490005518c53b9ccd05adb2b895a45dcdd4a815ad74acb06bbcd56ad8fb50d440d95a5c753a2a0e23c2f3d34b92c05b6216b5f4e7280db7aaaec62973533efb5882ab8f55adee69f3ac90b30fc65a1a3bce985bc05d7d59ecfe1b61f24121bf67dc03fcbb8faaf9738887638e92740d901f9afa8b809e1f4f1b81ff0016263fe56fd17d07c0cfdc787f3b0d44ec6700a7af81f0cac05df85c752bc9b8b7d9b3d8e7c94f1975b5ca37f45eef3439b7502b2884ccb3803e257a56639cd64f371cf2c6f4f926bf0334f396e431bb969bfa2ada8a091a6fb9e6015f4271b701458bd33dd14662a81ab5ccd6c578ed46078ad2c92455b46e7b986d99ad2095c5cbf1b2c6fe3dc7671f3cca76ccb1ae8b2917b8dbcd7a1f01714370cac63de2ec9064902c7d56152b01731c47564a2df351e9657d3485a5ae6b86ab8b3c2ba70c9f6e70456c358d7be9df9a12dee8bfbbaedf35ab5f3bfb0ae3e8d95edc3eb9ed8cbd85ad71d9fb5bd57d10082010a232e49aa54210a5984244a8042108048952205d10842044a9104d85f640d54d4c5490be699ed8e360bb9ce36002f03f6a9ed92690ba830a92d09b82187bd279f40a5fb66f69137dadf8161af272f724cbcddd1784e378a8c26499b4efedaa9d70f988d197e43a95cf9e76dd47671714c679646ebb149eaaa5d595b313ae6c9b79582ce5554cb3b8be5d636eb62742ac29e9a7c567688e07c92bcdf29d6dd3315ec982fb2ae18e1fc362ade20c461a9ad1673a980cc1bccd80e7f4518e2be593c2a3a7abac8439b04cfb1f7b2e8b9ac64f133b37c4f636db1165f41710fb40e1ea2a57d1e0bc36c903a2eccc951a007c00fe8bcaf8bb16adc7286182a228ded86e2311b0348bf2b8dfd55a29bdc622031ba412541ee81dd6f55cd5d799ea031848be807452a4c325934646f63bc75013f84f07e238856b590479cb8eaeb68d5b6377d46796e775590d24d573b9b146e7bdce26c078abdc3b82eaaa49754caca66345cb8d8dbcd6c21f6498961d4a666d680fe7a5aeafb86382df485b535f83c75d1c66ee32c8ef8869ee95e8f0fc2b7fbc7367f224f5549c33c1d82c6f61ec2ab119c5886b184ebe2d1cbcec3c56e26838871563b0f8228f0da23a3bb28fbe00eb6b81e7771e965aec0f14c3710070fc3a923c3f27bd0b98d639de40696f250f8b313751ba1c130b7035739b1ca346df99f00bd2e2e3c71fc647167cb9657b65aae928308a5349450b64119bcd2b892e9e4e97dcf52b21c4b56fc2b0c0e2fcf59563ba6c2e013b01c82d8e2eda5c2281d33a6060a76f79efd3b57733e1aaf3aae926c5e3ace25aa691133eee8e37f33c8dbf9cba2e5f999ea78e3edd3f1f0dddd64d91495358ca78f5717dadd4f3fd97b470a61eea0c3b2b185d2ca6e5dcba0f4b2c1fb3fe1c7e235e272dfba87bce90ea09e417b2505216b033468680340b9be0716a79d6bf2f93ff004998b0d7b6d9802f775d495bfc0f0efb35008dc35cad1eae361f205546158676d52c7381ca0ecb5b4ccfba63ec5a2ef96d7e40656aede4c9c28552c0ecd2875ace925b0e794650be74c4e94cf8ad6cc5a6cf9dee17e972be98fb1068ca760d6456ff00c9cbc2f15c3fb2ada8046a2477d5799fe473fc648f4bfc6632e596d98829b201a6aaca9a9fc02e9b06bb29f4b0ecbc7cabd990e5241c885630436e5a2e608edaa9f0301f32b2ad616082e9e107827a36582eb207155a94274009b592369c37929a6220a0c22ea250dc4cb725614edb0d028ec8c0d94e85b601599d3f134952d8c360988af6dd4a6ec2ca55a7236dc279ad03926e3bdee5381dd02991529f05d0d9721b7f04a01bee14e914db9c07aa4d00d176f6dcae4b75dd5432e049f04ccacb5d492db2e5d1e61add3499553237bdb2afc663b5148eb9bd95d490d9c4dd5563a32e1f2792ae9acc9f36f168b6332f8397d23ecf6a1bf66a1d6e3b3319f911f52be72e2f6ffea9215ee7eccaadefc3a80b8f78c51c9f200fc8af63e065ace4fdbccf9d37857aec8cb9ba608b1b2923296b48d744dcadb1b80bd595e2a2cb491ca2e5a151e23c3b13de646c4d2ef11bad2b4724af6070b595f1e4b8a2cdb0557c1d85e27116d45244e3b7bb62b1d8efb1612b4bf0c98b08d446fd47c57ae6214fd937b560f34c5154879b157e4c31e4c77618726585eabe65aac271ae10af6b6b22969ded75d8f1b1b73079afa4fd917b55878a68e2c2f12958cc4a36d9ae3a09c0e63c7c15857e038763b46ea6aea58a789dbb5e2f6f2e8bcbb883d91e29c3d53fda5c3133e78d8ecff6771b491db5ee9e6bc9e5e1f1bbc7d3bf0e599cd64fa4c1050bcefd9a7b496e3f0330bc5898714886539c65ed2dd47272f4458166ba08d108d110344234420108d1080d108d1080557c455b3d16133be9633254b9b92268fcc79f90dd4aacaf8691a4bdc33720b1988f103f13a97c34a7b8c3df9390f01e2af8e1beefa47969e59fff0016d55457cb5b8c622c13cee24765de2dbf9f3df556f877b1fe17a7cb2d4d1beb246dce6a8909d77d868b67352b65a5240b1690ebfe24f1a28cc794875adb1712af8f0632ee272e6cafbacf3b07c2b0d616535253c22daf66d00acae36d8da1cd11b893ee696baddd45139e5dd9b459bd1754fc354f1c665aa6b5cf3ab89e5e0a72e3f2ea186731eebc6a6e189eb6ce9b386bb50d6d806f99506ab83c3090ca921dc80ef2f71fec186a9c4414ed6c67f1b869e8176301a2c2eee1135ef3f8c8b9098fc5dadfed69f36635c3d8bd146e97ecb3491b79b59f3470d71c57e00d739b411d544c3770232bbd485f4c52d276ad70c81ede845d799fb51f65f056533b1cc24b696b986ee8e36d9b203a5c81cd6b3e35c2f971ded5ff006267d671070df69f8263c638bb534933dc018e6000badcbe602923a7a7702e2d1ab756dbaaf11c338670be2212d155b451e2d07bcc03deea4751f35c8c638c7d9a54e573c56e1ac75d81c4bd96e80eed3e057a187c8cb1c65e49d7ee39b3e1c6dd637b7acf18d4516138289dd9593dbeedcd167e658dc0eaaab0a69c47192e73eadb7133cddcc6721e6565e3f69147c538d43262ed7414f1f78444121cee4175c45c47ff007257b28e0a96d350dfef2426d9873b03b0f0e69c9f2f098ef1bba71f065bd54ba89a4e3cc5257cb288302a37dac5c00948f1e9fce8a9788b12ff00b8b15a7c230a8c0a688f6718636c0f8f95bf54b8c57d1c8c8b09e1d8a5712007cad26c4e9b0e656df80f82060710abac687d6cadb9075ecefe3d7fe1716af2e5e3ff009bff00e3abca71cdff00e173c29803307c3a2a6659c40cd23bf33bfa2d651513def361a1b14986d18735b7d87cd5b8708323582ef7681a1777526a386db6eead30ea41142f70b67b581f12acbb3747f74d1603b3887d4ae6829bb3a7635c2ee2466279dcfec9e198fde116d1f2dbcf40b0cb2ed1a3464748c2e2770f93e3dd0bc8b1e801c46adc36ed5df55ec9d8860cbd32b3e1a95e558d52fd9f12a96386bda13f1d7f55e6fcff00e934f4ff00c5f59e5b654d310ed47c94aa786c41e4a5ba9f5b8d93914366dba15e45af6dc4719d829900ca963885b409f898156ad1d30dfc93d1b42047dd4e888803c3aaaa5c96585c2e5adb9ef2901a0ee91acb941cb5a2e149898426ec02911d95999d8d4861d028cdd0a7038f242c480e036f8a75afbe8a287586e138c793b29da9a4a69b7a2526e9a687102e97301d4ab456bbd7a2081b940be541048ba955c381ba3f0a56f42755de5008411256d86cb3dc484b685fe456a6568209e4b27c5aec94927882a2c6987b7cefc544bb1197cd7b6f018107f63444d9af8a388f8e66ff0050bc571e699716737f33c05edb8547d87d99ccd3ecf94b7d069f40bbfe2db329639be44dcb1ebb4b730341dc0b14e3d970a3d054365ce46d989f43aa9b957b35e0230162bbcb98257b102f6ba8d88f56c269dedb5f459ca73d8d411b8256ac80e041d8859d969bb09de0f23a15d1c3975633ca2de8e5d3a29c1d71d55550bb3b6fc82b8a760781a2c392495a62a7c6785b0dc6f2cb2c661aa66aca987bb234f237e7eab51c3d515428d94d5f3b67a88c65ed40b7683a91d546ec40e4b974446ad3b2e4cb8e5f4da7259d568d0a920c46780e57f7c78eeaca9ebe19ec03b2bba15cf971e58b4994a93a211a142a2c108420108420f30e2bc4ea2363626487b490d89e8a26167b08446dd87ccf54de3ce335512350d5c6199b238e62b5fedc9afa46b58eda0a0904cc7b1fb90534eafec40824be7d8151e91c62a9612e361609fc4a8819dae68b070d3cd77e18cb34e7caeaed32060cacb7337524d3f6cf1da1b81f87928b45218e564320b69a1536593b2783751e1a4791feec6ce42caaa539ea0be4d59c85f529f9a77cefb44081d4aea3a70d3988bbdc772ad3a56a33cc96b42deccbb73e0ab71e05d8555324d7b8755a07c39197f9aa4c729c4d413ef703aad38ef715c9e11c5f83cad9862b42ec95ac05c08362ef0f03fb78aa0ffba2b788298415115a73dd7803def1b2de71b54431b3b28c02ed801b95d609ec9e9dd451d6622e91955377cc6d360d0791f15af26194cb78fdb4c339afc9e692e054f5754c8f0fa4c8fb00f3aefd4f4f25754decbea2adc0cb532462c2c3b23f55eb984f06d0612dfeef158f371373f156f0d0470f7834171fc4775cf3e261bde4d2fc9cbd62c570bf00e1bc3ad12b22ed2a08b1964173e8392d241017c96dc03af8a9efa724e896388443c39ade4c719a8c6e572bba798442c0c6fbc45cd9595051647b65782e95e74bfe10abe8d8e9642fb5ee740b454f46e82132ccf06470d01d9aab95426472da06bdba921ef1e5ee84fd81764e599acf468b951992459fb30d22c638bf52ba1382d2ebea58e7fab8d82e7b11b385d99973b96b9fff00c8d87c960f8ce94478909c0b0945c7a1b2f40635ae7dafa676b7d1a2e56638ca84cb450cc077a3363ea015cbf2b1f2e2b1dbf073f1e58c288f6d34e69c6436778290c8c586d729e1101cb55e13e82d32d82e34e69d14ddd07a7452238f4d53b92c145222b4fc93ed032d92f663743632ab76bca46b7a6c9436faaef21b2e9ac2469ba6915c96251ddd4208234375d65b0d068acaca4ed0e6e89c125f4d134e89bbea940d37d942f4f35c01d54889fc80b2880152a0b1f02a59549666234d92b46a4271adb04358015a45280d364a469aa798cd3648e1653a5366832c2eb9cd63a6cba792469a04d1eef922607baf7e8b17c6d5023a57f92d848f6869d579e71ed5b7b091b750be1ede3158d755e351b23177be56b5be775ee744036c0804936b7c8fd578ae1167713d113ffe769f9af72c120edaa439fab5a1c7e2d27f45dff166ec8e6f93752d6df85a491d4113de0e622c6fd42d002a930899995ec6ed9c3bff00931a7f42ae986ebd7c9e15f6570bae2d629c5c96aaa74e1cdbaa6c7a09408a58ed6be577e8af72e898ab804d0ba33b3869e0af865e376a58a9c3deeb08edf05a0a57f66d01e2cdeaab30aa639c5c6a0d95acadb0b7451c996ee969128904051a67e44c8a87c5bea3a2e25a86c8db836bf22a98e29b5cbaa1ce3a04ad91c4a6e26673716b294c8811e2a7284a721c46a202066cc3a39595362f0cba49f76ef1d95449196a649b158e5c52f6bccec6b1ae0e170411d52acd53564d4c7eede6df94ecade97148a7b35fdc778ec573e7c5716933953ac8497050b25de5f574f981b0bdca670f8723cb48b02ace6678265b0e4782bb31c3bdb3b975a315313a3bb9ba13aab770353470c83716502b5b78895370978968729d4b4d974e3d76c722544cc635ae2d39da6c3c57514725439af949b0d9bc828b526f582368b9defd15bc0c0d88122fa29c9570e688c580d4f209e8597b5f52534e69cd73b952201cd5285a868b5967f886a1b498062552e3dd8a227d792b7c4f11869627173866b68150cc462745f67a98b340f70739846b2106f63e1b79ad38e5ead4560b8338566c4ea1b8f63113bb30735342f1ef1fcc7c3a2de399989240bf927ec47bc2c06800d804dc92b06db2dee7ba8d380cf4091ed1b725c9a8172000b9739ee360d71f20ab6832017b051a6639ee0c6e973aa5a8ac828585d553c34e2dbcb206aa6a8e3ce1ea07973abfed05bf869d85df3d926395f513b8dce1342d821ed1c14ebb5e5c09d6ed6fc7fa0f9af26a8f6e34cdcaca4c2ea241b7dec81bf2175ea3843e5970ea79ea98d6d4491f6ef6b766b9da347c167c98658f744a195d77db6cf2fe8170699c1c1836cd147f0d4a951c4d07203ddbb63f46ea5759865ce77b17fab8d82c7cff0048d2342f7865cfe26bdc3cdceb2e7138456d14ccb0209701e9a0fa2984336fcae0c1e4dd4fcd730c7681ad3bdae6fd5572d651a71dd5963cd648bb379165d81cc7a05638ed28a5ac91b6d0bae3d5416b01b00be7b931f1cac7d2f1df2c6645008094b8d97606ab8710b2ad63a6d88436f7d1739c3468bb86404eaa127446e70b009e8a2077d1751b439bb291147aabc8cee460c17e575cba301ba29a584f25c98c74d15b4aca82e8838588d537d9db4d2ea748cb0b80a249dce7aaad8d366ad94f9a934a2eed4d94671b73d53b444bdfe0a368b3a5a36d602c9f635b6174d88c809e8ec06ab6c630c8a4e9a2420730891cd6b6c1361f7dc6aa76ac8e1ecb9ba62661b58294f371ba8f21cb7d6eab578aaad7398d2412bcc38e2a6ed72f4bc5261d9b86da2f27e337df3dcaafdb6c7d321c31189388a1908b88cb9e7e1a7cecbd9b0699c5dd9b7736d7c839794f07503a6a9a9a80d39610dbf993a7d17a7e01266aa6345af7cbf2217a5f166acae1f93772c7a061ec314b186fbae6b05fa90c0af627dcd953e1797b389c4dcfdd5fd5965634f2676b5e0597af977d3c4a9f6bea90a569d2e8b2cd30834ba08ba12ee858ea9a3687b88b5d2ca754913b2497ea893555fb1c3999daa3be9c9b296dd9286a9de8311d38634db45d4733a236777875e6138fd026773aa9defd9a3cf91af692d3e6a23bdfba70c46f99a6c537d9c8c37d0853348a798c0e17082dca514cf69394e9d3c5487b0054bed2e1959511b72b657590b9eccf82157c22de5552f8eeeba1d10214acb7499343e0a61502a23fba2b9c1de2391d1f552a46660410ab617fd9f106b49d095ae3e95ab3a889905744fb692bb29f82b18da03493cb40a35634b9b0cb6f7241f03a7eaa601963b28aac4778bb804f3ae2275bd13405dc4a7e4788a173dda002e5415e7b89415d59c42da76c849b1701c82eebb14c57099c533a9e195c1a09736edd15af0c5f15c6abb1223b8c3d930fd559d6e18da9a87c8e6dc95d58e78ccb562b77f4ca33882be506f40cbf8c84a8755c458946eb369295be6d27f55b26e0f1869eeaa7c630a6b4dc342d71cf0b7d2976a1389e353c7dd9591ffa231faaa6c52a71991c43ebea6c7935d947c96ea8e822318baadc5e8236b1d66ec2eb6c72c77ad2baaf22c5696473cba4739eeeae372abc4444456b31e898d2481659d919dc3609965236c66dcf0ae18713e22c3e91adcdda543011e17b9f92fa89b93fc4bf7493211d1add1a3e2be5cc17119707c529ebe0243e17e61e2398f82fa4f08c4e9b1ba082b295df753b5bddbfb8c68b9bfaae3e7ddd5fa5b29a5976b9185bf883433fdce373f25cb651248083dd3213fed60fdd447c8f1f785ba80e9cf99d1a1391c4fb1881d435b003e27572c3c628994cc2f0ccda1c85c7cdc53a74362b889d70f900b07bbbbfe91a04efbe331df9acad6919ae2ba6bb63a903fca7f459d601a15b9c529855d1cb10d6e2e3cd79fcaf3192db10415e3fcfc3c73f2fdbdcff001f9f961e3fa4a240e69979b7928e66246850d974b2f3ee4f46627af98586853d0b482091ba61a750029901371f351b2c4ea76e805ec14c8a3b9dca8d0169b15363202df17365b8e8466fadacb97b2d6d3cc279835ea0ae647340d7457b15887280db8e7c956d53f2eb65633b80b9d95455bf7bacb26d8c44927ef1b9565870b0bf55472383a4d0abfc35a1b10bace775a67358ada27ddba9d92ba40145ed4306eb8edb5bdfd16de5a73f8a439dccae1afdc95c825da941d352146d3a0f7929b79ccddf54104ae24195a48dd3669498cc81b1b8745e45c5b55dace580af48e29c41b042f17b68bcba3a29b1dc5db4f18273bae4fe56f32af8e3bbd2dbd4dd6b780f086c581432b9b77d5cce95dd7b36580f9dd5a616c928f19647234825e0d8f5bdcfd568387b0d8e86aa08ec042c81a48fcad00903e36f8a97c4183b1af655c42d2462c4f8d8b9dfa2f7b8f86784d7d3c5e4e7fcecbf6b9a0ccca26bdce00ff7770d7717b28957c7185e0358ea2ac3307b0eb688d87efe893879efaded7393fddc31a078f686df50b19c7e66c4719a897b30d8e2718d997981a5cf9af43838e679595c1c9d3d330be34c0715cb1d3d7c59cecc71ca4fa1d55d82d780e63839bd42f98e489cc76d65a2e1ce37c6387dcd6c7319e9c5bee6524803c0f25af27c1fbc2ab327bcdee80b35c37c79877106585c1d4d5245f23f99f03cd696fe47c970e585c6eb25e5d876a941cc3c5221b7cdbe8aab1d68d12936096d6174dbddaaa0e1e6e520f149bb92b77d55be87605c2e1ee02eba26cd2a1d44d736512071a438689e8e72d367ea3e8a343a04e1b5d5aa12eedea10a1ea851a3b236c4d97796e170c4eb365558c3e3dc73545884663a90f1a5968a56e975538845da3491a90b5e3f6ad59c0e1514ade7a02a5bcda3f455b83baf4c77d14f73aed0a32f688e226ddde9754dc6f8aff6660926536924ee355e442c6eb09c4121e21e31a2c299de86077692f90fe7cd5f8e6eeff48ad3f09e1a70cc0a089c2d23db9de7fcc75568e1a94eb181ac6b46c136edd67bddd8e4000154b8db6f11b2bcd2c55462cdbc27aad38ef68a8143de8c8eaa36294c5ed26db85230d214ea8843dae045d6f32d64a58f28c7b0e759ddd3a2cb4d48e6b765ebd8ae10d95a4e5dc2c95460799f94355f2bb6985d3ce5d13984e8b53c0dc732f0bd41a4a92e7504c6cfb0b98ee45c8f0ea13f5dc34f634b830acc5761ef85ceb8d8aad97c5a6e655f49e1d88d26311c73d3cb1c91c8eed0e4702031bb0fa29b0b1c5ec69be62d74874fc4edbe4be67c2b1ac4b05766a2aa961077683dd7798d97a4f0b7b6191d594d4d8bc71b237dc4d557e7639740341b5f75cd71b674ade3b1ead2bd90b402400d1a285257c8e75a3d075511b88458ac6da882563a37dcb72b810478109c81b9a4ca9319276aa7c17319711bee3f558ce23c3cd357bcb4775fde0b70c3d9d8117551c4943dad3768d17319f92e0f9bc5e7c775f4eff81cbfc7c93fe588ecc0d4a4c96d94c7476162374c3d9a68be7ac7d24b0cb5e01d4d94a86a6fa0511d1d8eb7254aa68892340aba4d934b2a69f6bab163b3006f6502080345eca531f63e4b6c2d8e6ce4a9cc7db625733116363e69acda6e9a7cba6ae5b793298a3d4383469b5b72a9710940b9beaacaae4e4a83119acd22eb0caba78f1478e52ea81adc5d69a96402317e8b25460992eb4d48dccd6d957169c91348326abb64240defc939047a0d2ea5361f05ac9b72dcbe8d4717c57663bee9decc8e602e647b5ad5798ab7236e01a2fb2a5c5f106c11b8e60004f6278a3206386604af3ae26c7cc9998d7dfc94e96c65bed57c478a495d398a2bb893600735a6e0ae1fa5a481d1ce07dae5b39efbfe1dcb42afe07e16a8c5ea9b56f8eee76adcdb34755e9f49c1eda2adfb431c2a5a222cc874398db51e1baf47e2705bf9570fcbf938e33c55f8440e7d4cd50e6131b899353bb46c3e3f45795144e96130969738d99e6f76ae3f056315236962ec994e72b591c772390d49dd42aec69ac90c6c8b3c82473adb345f417eba2f5b096f58c78b9e7bbba8f846182944b3bc5bb6ef067f9b3dc0f21655b8b70fb6661bb6e6d72b41439e4b3a4373c85b41e4a5cf00934b2d70cef1e4cf2fcbb7905770bbb31cac3baac9b8727889fbb2bda060f1b8dcb414d5460113813902e9ff00727a56635e3d0d1c94d6241690770b5fc3fc7557492b296b01a9889b66fc43f75618b70db6c72b755981844b156b3ba6c1ca99d99b48f59a5ac8aae36be370b1e453aedfa2a5c0c16c4d6bbe6af0c5600b1d61d0ecb8b2925e9695db64cccb1dd36e2b80fb1ef34b0fc414a7755d24a35403a9497b26df2650892cd286b4eaa09717b924f35ee2fb94b0b39f356d684b8fdd4aedd23365d5ae55426c85d654204636e34dd39b6cb88082d07aa748e655472ff755755b32dcee0a9ef26c54675a4bb1dcd5f0eaab460e3287376054cbdec028b431f66f23929234791d34539fb5638afaa65050cb50f200630958ef6714cfaea9afc72604baa242c8c9fca37f9fd13bed2f1474186c74109fbea970600375a4e1bc35b84e0f4b48d16ecd801f13ccfc6eaffd78ff00ee2d0f3e89b70dd3b6d134edd631243636f255b8936f0bbc558f20a15737ee8857c6f6551d01cb25bc55c801ed07ae8a929ce5aab725770d8b16995418a9a5ccc3a6ca924a01db02405a6900c97eaab6667de37cd2642154608c969dddd049586c7f8772bde437e4bd6a28c7636f05498c61cd91ae39770b4c392deaa3d5dbc46b30c3183a6cab1ec319b2f4ac4f05167d9bc962f15c38c46e0155b8ebb8e8c72dfb77c39c555fc3d2e6a77e7809bbe07ead77ec7c42f6de0be24a3e29a77cf4f999246435f1bf76123e6343af82f9e2c5b75a3e08e297f0be311d43aeea696cc9d839b6fb8f11baadbe50cb0fb7d0ef6ae5ec15103a17eba683a84dd356435b4f1d453c8d92291a1cd703a10762ba7120870362365859b8a4baac6d6c3f6699f1bf42d36515ed015ff125235ce65481a3b47781544f692340be73e471f867717d2fc7e5f3c2648e2304ecac2860b900d933130bac2cad686000acb1c775ae796a1ffb3e5668a3b9963ae8ac5e06c143945cecb4cb1d31c72b4c9706a8af7f79c6ebb9ee05d4296476b60b2b5b63899a87801daeaa92abbeeeaacea6e2f6d4951191173b50b2b76e8c668d52531033595de1f76db32e29e9c581d34e6a5c3177afcbaabe319e796fa5bd38bb411d13c5b6d7928d4cf01bd53b2cba5d7563e9c77d9aa99c31aa8b13c5c42c3deb1f04fe255ad89aebbb45e7d8f6320660d728b5a618c738e63ee25e1afdd5770b60355c598bb630d26306ef7725030dc3ab388b128a92998e7be475b4e4be83e0fe13a6e19c3594b1b43a622f2c96dcf41e0ba7e37079dddf4e7f97f267163e33d9fc2704830aa76c14ed0000039d6f7bfa2b58a3ca027bb30de4b879cadbaf5e5eb51e065bb7750314a9ec20758ea7659ba48fb494bdda92acf199b39caa3e1b0e737b68bbb8e78e0c6f756d48ccbc94c6b2f65c53c560a4b5bae8b933cbb692118cb7c1385808b25b582559ed6d20d551b6404d952cf8330c80e55a57db62997b01216b867622c55d253f656002b1bf7404858005c38d92dda1d39d601704f3484ae1cf0d1e69a58492586ea14f3a59a6b7350c92f70d15a446ce460bddaeca6c6db59354f09dd4e8a226da28b5308d6e89c6c649d93cc86fc93960cd1677249a11f8a13b60851ba29f0ca8ede2690ac770b2dc37584b3212b52c37015f283878eea80e0449eaaca51a5d40736d26aa714549a6b68ba7b83647924586ab9806aaa38b31518561b533136765d3e0ad26ee946543bfee8e3f6fe2a7a119cf4bf2f9fd17a6462ccd3c960bd9761e461f362528fbdac90baffe51b7eab7edd0b479a735ef53e930ae4c388b271e764d1e6b38b10f351aab561f2520f4f04c4c2ecba9833927ddd48215cd3bb346d3cd53e20324c0f8ab3c3df9e302eaf69a4c78392dd14295b9a669f153f4b0e8428a59f783c1368d27c2342131590e7045b929318b342266e61e8ab2eaa193ada20fcd70b258de0f9dba357a2d4c00df45515b421ec1a745b4c89d3c5f12c3dd03dc6da2aff74dbc17a2e3d82dc3cb5ab0d88513e9e6769b2a59aedd1865b6e3d9971b0c3a566115f25a9a57110bdc7fc371e47c0fc8af601ae8755f2e31c416f506ebdabd99f198c6289b8756cb7aba71604ef23073f31b1f8aadefb573c3edb1c420ede9648ed7d2e3cc2ca6525c015b578045b98d966eae95aca97868b0be8bcaff0021c7bd64f47fc7f2eb78547820ea2eaca9c651a724c42d036f24f0200d375e7e334efcaeceb9e06bc8a8cfbee06e9dbf50b9205d4e489748734798150e4808be8ad08cc6c46c98959e8b1cb16d8e4a792024ea17115390edaead4c61fb6a959001b8d967e1db4f3330422dafc1488e2d76d128658e9a271ad20f82d71c59654e3406b6c145acaa6c519bbae9c9e7114675596c73196c11b8122eb58ce4daab88f172d0e6e6b780582aaa87d64f91b77171b003729ec67153533101d7baf4af64fecf03591e3f8ac3de3dea689c36ff0039fd169c5c57932d1cdcd38b0dd68fd9a7043386b0d15954cbe2152d05c08ff0da7f0feeb791332375df9ae63666398ec364e13a15ebcc6633c63e7f9392e795cb272f3a283593e46952647dbd151e23505c7282b7e2c3758e5506726792c3aab5c3e97b360d146a1a5cc73395d43106b405bf2f275a8ae38bb636c13a021a10572352a425175c93ba0479d536774ae3ae8b8255a443871d0a6dc76f14ae26c9a71b2bc5439f651e792c2cba7c9a150a67971b2bc8387bc929da7849d4ae628739b95694f4f60995d26414f0d8053591809238ec0689d68b2c72bb5a401b609a79bb93af758263f128853836421bb2146879c6095060ab2c279ade533c39835dd79c38fd9b1236daeb77844fda40dbeeb7ca22d593c5c28530b3aea6a8f3b2ea98f457509b0d792f30f69789c95d894384c04974b235b61e2bd1e69db4f4ef79360d175e5781467887da0d455bc668a9bbc3cf60b7c26a5c949edea580d0b2830ea7a560b3636068f156c3def44c5332c029045892b9b2bdac664dca6ff50bb90a6afb78298904ede49a9358ecbb71df55cb868a6259fc5db6b393f8549dd6a3166de2365170892d717d8ab517db8db50b96b6f32561bdbc42ee36f781ba842445eeaea41721245a37d52bf52a116214cdbdd459600e2029afe7e6b87305f45694d33f88d03658dd71bac2711609fe239add82f53969c3a33a2a3c5b0d12b24161a8e8b5c6efa25d3c36a21741258853703c426c36be9eaa9de592c6fccd215b711e0e6095c434e8167a0fbb91a0f258727e2ece3b328fa4787719831fc2e2ab8ac1ce167b3f2b86e1378ac169049d742bcc780b889d83d531af71fb3cba3c74e8e5eb958c1534a5cdd6e2e2cb9f971fe4c2c38ffe972cfd28db7be86cbbba6ae43ac7aae9ce2765e2fa7b13f6703ee6c7708ba68f8aeb4206ea369d3bb006f7d536eb3b4b25248d17371cbd5454c7190b0e897501248fd764ad75c0e41574b5a42d3bee91f2656ae9f2003c15562788b208ceb6568aa263189b29e370ccbccf8871b74d239b9b753f8931c2e739ad72ade0be15abe35c7994cd0e14ac21d3cbf95bd3ccabe38dcaf8c4e594c31f2c9a0f655c06ee24af18b62115f0ea7768d77fef3fa790e6bdee28c0b35adb306899c2f0ca6c2e8a1a2a389b1410b431ad0a7068685ec7171ce3c751e07c8e7bcb96efa1a34582e1ee4ae759469a5ca09bad319b616a3564f91a6c555c6c334974ed43dd33ac14ca4a6c82f6d575cd6119fb3f4d006342971b745cb1b61b276d65cd6edac80e8909d104eab9254246e170e2ba5c3ceaa621cb8ea9b71d3c974e3f24d3dd6f55788ae1efd2c9891fa2e9ef51a575cabc8ab89245c3232e75d01a5c7cd4da7836b8536e8750416234560c8ec02e5918be89e02c563965b5e15a175ba4d92936175549a908bee9a06e512bd711bb55793a5767c1d10910a349798e351f63581c375a5e1ba8cf1004e9654bc551767235f6e69ee19a80d70693b2e8b3711f4dc35da2e64032ae627e60174f3605dd1628acaf1b62830ec2a5b1ef3859537b32c3845472d6b87de54bf35fc0683f5557ed22b9f55590d0466ee7b80b7aadbf0a52329a8e18582cd63405d19dd61a4633eda7a71dd09c90d86e88c06b531512ea42e49dd58cc8fb8d1717b1f9ae0bee6fe0903acef92d110e1373e6876c3c9723570f04aff76ca1640ae66689e3c152e1cec9505a7aad0d436ed23c166c0ec6badd54ed31a585d76b4a90d6dbe2a1d33af1e8a681727c9420eb39a576dea91bfa05d3f6f54115e3def35c8f782ea41eff009ae7f10520cb767aa62a69c3d8ed2ea481a0f35d65bb76e692e916303c4b83096390e5e4bccb13a1752d46da05eed8a5109639345e71c53835bb4706dac15f39e58afc59eab3585cbde68baf5de05c7c55d2ff0067543af244dee12776ff0045e354d782a2c74b05a9c1ebe4a39e2a988f7986e3c7c170e396b2d3bb3c7cf17a55645d8d43996b6a98f152ea268f10a4a7ae84dd9232c49fd7c7f650efe2bcbf91878f258eef8f9f9e1295f62129758689b73b4d423369aac36db4e81b8dd0e240d1365c3aa4ed34b0d7cd45a990af71b25cd9426cbc8e69a9aa4323beba28dad639aaab6b185d7f0584e26c73b36b8076aacf1ec61b1c66c579be2157518ad6b29a06ba496570631addc9255a769d6bd92830fafe28c5e2a1a18dd24b2bade0d1d4f82fa5383f85293853088a8699adcf606592dabddccaa4f663c04ce13c37b7a8cb262150017badee8e816e9adb2f5fe3f0ff001cddf6f13e67c9fe4be33d15a32dc81b2471bae8e83c530e7582e89db89cc8fb5d56d5cf7bb41dd48a896c375058c32cbaecb7e3c75da96bba58331cc55946cd9710c41a2ca4b5b60ab9e5bab48500045f5438db65c93baa2c39a43cd1be88409b26dc576ee6136e3a05310e1e6daf54c4aed17723b551657f35ae315ae1ef4c3bbc4daeba71ba7218893af35643aa78892345610c760375cc11016d36525adb6dc965964b485685d8482c125c92a8b3a27543cd814806ab990e850a872bf74913ae46a9ba8758ae627865dced00d56dae99ed266ac8e070638eb6ba1350c3db34cb2004bcdf5e43921478c46eb35c614d9a8dcf68d46ab3d805500f63afbe8478adb63f4bdb513c5b92f34c2e634d5d240e2416bae16b8fa5e7a7ab51c99e269f04e55c819038936002afc1e61242dd75b287c6b89ff65e093497b3b290153c77969579bba7fed8e3673c9bc74f777edf32bd5f871a0c45de365e43c09199bed75cfb9323f283e5afeabd6785e5cd4aed767593932de5a5f5a8d03e50d0abe696e6f7f05d54cf6ba8998b8f9aae334abbcd71e45743527e29ae9e3a2719ad8fa210fb352ef8ae9c2f7f101711ec3e09cb73e86ca126256ddab358930c754d778ad4bc6847459ec6a3b3afd11689f40fcd18566ce43c15361525d802b98f50df2429e1cbc974fd8f9ae5bf857525ec7cc2ad418907bc9be77f04e3f675faa6edf4561d347ba9d60dbcd3435ca9e8f66f9a06278b3b1da73598e20c3c4d14961a9d16b9cdeedbc5576234e248ce82e4abe355d3c4f18a134f54f396d64fe1f28cad0b4bc4b855cbc81cd6529da6299cd3a59727c8c3c72dc7a3c19f94d57a2705d7f6f4f5185bddbde48afc88dc2b071735c41d2cb1385d5be8ab229e3367348705b9ac0c9432a22ff0e7687b7f51f15cbf3b8f784e48dbe1e7e39de3ae0bc1d9705e46a6d64deac1ba473810bc8b5ea6885c4ebcc256bedb95c6520f55d0613751b4c91d17e56df75518bd7882171bab0a87766c2161b8ab13ecd8e6e6f5489c7166b8871974b2b980eeb73ec63818cf27fdc78844726a299ae1bf22e581e16c066e2fe2382858098dcecd2b87e160dff6f55f50d050c5414b15340d0d8e2686b5a06c02f4fe170eff003af37fc8f3f8cfe3c7ed21adb6abb1e293643880ddf75e83c67123b4bdd469df61ba7257285532585aeb4c3145a625717bac9fa68728ba6e08cb8dc853a36f82d32cbe9121c6379a72e800342e0eeb25c13748b92ed52f82051a04876413a5fd1724ee3a204794d3ddc974f7744c3dfaf92bc883734814473b5d5752bf52b868248d345ace942c4cbbb556114361b26a9e1b29cd6acf2c9690ad6d8aef628082566b0252209b25081468570f3a15d2e1e54c8857553946cddac91c1f98dddfe90a4d6b34ba83839334b2543bf11cadf00174e13adb2aba6b7416b212b2f6d10b24a3d547da46e6f50bc838a2376158df6c059ae76ebd99e342bce7da4e1066a4eda36f79bae8ad8d5f1f6b9e15ac1510b0b4df4598f6cb89186921a669b673aa67d9c63399ff006779ef30d953fb6599d3e31490037cc2c3cc95a4fda35f96965c1d4bf67c12981162f19cfaeab5fc2f5c22aa929dc7426e152e15008e8e3637f0b400baed8d156b271a0bac5ad6e9ec2f37be8810fc8a8d475a2a210411aa9ad70d6dd1199aecec3c8dd38d6d81f0d52efa782ef2f77cc284900b5fe29cbee3c570d3b792e99a91e2811e3def254d8c459984abbb5c79e8ab31465e270e88457e1525b457f4e6f956670d765948279ad2529eeb42272892dd9a95e7ba7cd233979a1fa83e6a106de34778a6c8d0f9275db1f45c1d9de4a40342df24eb34b5d34d1d7a27872f2405b4b79a6a5607340f14eedf05cdaf6f2443318c508919eedf55e7989d198262eb6e6cbd76b69c3da16171ec3ee2f6ea53931f3c5b70e7e354101f77c96d787aa3ed9854b4a4932539ed19fe93a11f1b158aa7690fb5b9abbc06bbec18a5339e6d13c98e4f2768b29879f15c6b6cb2f0e49945f968b58eeb9ec8eea5cd1164ae67e5363e29036e392f9dcb0b2eabdc996e6d15ad37294346f72a476403924ad01b7b593c4f25263353d8c2e3e0bc9b8971174f3b9b7b6abd0f8b2bbb181c01e5baf3de1ac224e2ce2ca5a000963e4cd21e8c1a9fdbd55b8f0f2ca48bdce638db5ec9ec63851b846003129a3b555759f770d5acfc23f5f55e8e1334d0329608e189a1ac8da1a00e89f0bddc7198cf18f98e5e4bc995ca8e6b998800792ef9a8f3bc6a55a4ed4332bb280a0bbbef1e29da892fa5d734f1dcdcade7515fb49863ca00529adb725c31b6171cd745cb2b76b40e3aae2f724242eb948dd91253bf82eb72b9e76eaba1d5281dae839a6c9d2ebb71d2dd132e768a644570e728b349bd9392c9947928523f368169222b9b171ebaa974f0edd1334f1926eaca188354e55123b8d96013cdd120097c1636ae09d52210804b63640175d01a20e0dec9995c1a2e54870b951aa1998595b156abf149b2d2b8b4f79fdd6f995c61ec1131ac1b01651eab31a9c87dd885ede254aa2d6cba75ac596fb593469ba12b5b703442c17724e6165538ed0b6b28a48dc01b82ac20903da0defa2e6b05e22adeaa36f0464b270bf1382496c4f758f9129de30a818a71361badc35c09f4d7f452fda5d2b048651a381dd67703a938956d3cee377c2d2d77c3456b978ef16f2797e4f56c321bd2b4f826b11a62e8cd86bba9f8333350b08e613b53066d2da289e95df6afc1b11744046f3b2d253d6878b5f559434ae867774bdd4ba6a974728049d53486b1925f73c93e1d99a3554cdaa21a1d7dd4ea7a80e60b155b04c68b0f5b258f4b2463ae0f9a502c4f82841cfc3eaa0d733344fd3653b7b82a3d5b6f1bc782259a8065aa23c568e8cdc33cd671c3255deeb4142eb86f9a85aa7b35b79a43b11e2866d7f141d8f9a2ae1db3bd170efc4bb7ecef12172ed3379a90a39f9272d63e8b803de5ddfba7cc28a03cfc920dcf920fe2d3a20f3f40a4712b333478059cc628f3c674fc2569dc2e1de4a057419e3769caca6525d3cc2aa2fb354349dad74b30d74e5a8569c434790b9c07ba156b46689a49b9b59471f56c6fc977256de9a735d414d540eaf600eb7e61a15d06dceaaab846a73c15340e1ab3ef99faab8b0beabc6f9bc7e3c9bfdbd2f89c9e5c7afd1032dd0a66b0b5b1937b689f26c4dd5463b5629e95e6e0582e5d3a67b79b71de25a98c13aad87b07e1cec68aa71c9a319e73d9c648d4306f6f33f40bccab993f10f10434105dd24f28637c2e77f45f4c60184c382e114b87c2db3218c37cec1767c2e2ddb95737f90e6d63309f6b161eabb09bb6abb057a363c5744d9a4a8350fb10de9a2973becd03aaabaa9497abf1cdd29a79cefb2994ecb00a353b0937561136cd56ce921cf75a9b7bb75d3cdade6992ef92a2db2137f55d376bae474f82e80d8f55287437b2eaf75c1fa252512e5e7429991d6694e48eb349eaa15449dd0ad8a299a890929a89b9dde4b827b471b6b72a6d2426c4957bd2becf53c56b78a9ac1dd0b98d96e49c595ab40842e8016509200972a54a8100425484a02d74c5434b4070e49ecc137516744e6df716538fb572676a090d7bddbbdc4fa297878bb03942c55c1b33621c958d00b400aeccff00aed8cf6b06bcb4590983de3742e6d34da878731766214714ac370e175772bb344ebaf3da03270d7104d873c914f338be1bf23cc2dc455025849baeae5c24bb9e99caf24f6a6d31c6f3c960b832723177460e8e8c9217a67b52a51351c8e03501791f084dd971236326d9a3705cdcf8fe52bab86ee3e86e1a767c36237e562ac9d18712b3fc21541d4663e6d759691ae05d65597a4653b439e8838deca0cb4641161b15a0c80f2d932ea7049d02b6d0af6ddd0dba2ee8e72c7652548ec328206b7519d096c9709bd9a5dc32dc294c37bf92a7a694db55674efb916f250848dcf984dd40b8f309c6f2f82495bdc17f2503295ad2ca9bf257587c976b6dd556626cb4a4f45330a7dc37cd16fa5d47b0f3293a8f14b18d079a4fdd150ed8f9ae1dcfcd74763fea48753ea81473f34b7dfcc2e5bfaa51c9485dc79941dbcca182f6f3ba568eeb6fe2a361391f35ccacccc23d1760683cd16b81e6a46531fa1ed629401bac7c20b4163b704af4cafa7120371b9582afa3304f296b4d838dcfcd5b0f7b5b7f8e861157f61c460a826c03831fe2d3a15b19181af736f7b1dfaac09394e8b6f864ff006dc369e6b873c0ecde7c469fb2e4ff0021c5bc3ca7d3abe1f26b3d7eddb85c5ede0b0fc79880a7a47f7b5b68b7351f751922c178c7b4cc44998c2d37be9a2f1b4f5b0eeae3d87608714c7eab1a98666528c91923f13b7f97d57bd35637d9570f7fdbbc1d4713da0544edede5eb776b6f4165b2d97b3c58786123c3f93cbfc9c96ba011b22fd117dfaab313152fb3bc82aa712f7f352ea65bb5ceeaa353b73383bd56f8cd4425d3c7a052f609a89800d974f3f259dbb5a397bae5364ea8bdc9f117081aebd54a1d0165d05c6c7cb45d6de6102df5ba0e82fd12247bacdf9208f3bacc2157d44ba81d148aa934239a84d699642b5c6229fa58b358ab582301be6a3d34366a9cd166954caa615a10355d01a250151240dd575640413608045d70e7e8b9ce83b2e5c975d739b5484dd343acdaae5f624244dccfca0bba056c676a65e995c4270fc65ed0760b414a2d037c96369a7fb5e3950e06e03ecb691f758d0bb79e78c918e176ef642e1ef1990b9b4d59de2fc1bfb5a845553e951177d8e1d4289c3d8c8aba1198d9e3baf07915278431d662944d8deebbad620aa0e20a5770e633f6b8c114952eb3c0d9aeeabaf8eee785ff00e14ca6aecc71c91352bc6f705788467fb3788a9aa36689329f23a7eabd971fa81534aed6fdd5e3d8ed3fdebf96b70b2f918fe31af0d7ad70de2429ea002eeebd6ea96a1b2588375e11c33c48d9a264533f2cb1e84feabd3301c71af0d6bdc2f6f8ae2deab7b8efb6f2290103c53a2d6f35594b502402c77535aff1f05ab1b3477b3d2e98921bdf4d53e1fa58aeec1e7c50da035991ca6534963e4b9922e6b98c16dd12b58dd7bf9aea5f748f14cc0ebfa8ba72670ca7c45d56fb428b148ee5c57184bbbc074526b1bda35ceb283871c953954fdad3d34919ee8f32badfe29b84f747995d8dfd515046dfea5c8dc79a537d3cd20fc3e6500de5eaba67e13e0570dd0b7c938c1a0f24a068d3d128d001d12b7ffaa53bfa2a6c2345c0bf4483f0f9ae86fe89398f253286e566603d564315a61f6899b63a80ef8dc7e8b6645ede4b3b8ac56ac975b5e167ff00b39698518ba980c64ad0707d4e76d452388d84ad1e5a150eb29735c28f82ca70dc6a9e423b85d91dfe93a157e4c7cf1b2ad865e3656971690414cf79d2c178c53d09e2ee3ea2a0f7e274c1cfff0043753f20bd4f8f6b461d874a7301a2cb7b0ac20d662389f104cdb867f77889ea7577cadf15e1f1716f9247b19f2f8715c9ed2c688d8d634001a2c2dd177982658ebdca76cbd3af0b6507543ce5638f825684dd63f23437d53ef4b2b2a9d7218148a58f2f2d859448c76d3171d868aca16e504f4d0ad32bd261c1dd6d932f7697e8bb7bad6039a689b8d79e8552249b7a15d0dac93979688bdb4e8ad50506e7cd757b9bae06e2de6bbb7cd4053a0f24cccfb34f8aedeeb00792835129ca45f656c66c459a42f72914707551a18fb47eaade08b23469b2be57483b1b2c05ba279a340b96353802c562d9045b44a91c542484d826dee16291ef4d39f72ad22bb765cb90e5c0375d006eadad0e91cd280529161e2abb34424345d56e295220a29a426d6692a6543f2b564b8eb13fb2e10f89a7bf27742e8e0c3cb28cb92aab831a6aaa649dc3df90b96f09ca0f82ca702d276544c791f86eb4d3c996326faadbe45de7a570f46b313720f342e63be41e2859f4bbce6a209f84719133337d96577a356bf136d3f10e0ceb80f0e66bfba938ce170e294af86568371a1590c1ab66c0310761b584f6674613cc29c1397719b9259298cb43507bf1e8d27f13791587e218467710345e9dc69855dcda9806bef308e63a2f3bc52d530b8dace1a10b5e6fcb1d9c575589fb53e8ab58f61b026c4755bee1fc5a4c8d39891f45e738982dab8d837ce16f300a67474ad2ee6179395d576e3dbd4387f88838b1923f5daeb6705436568b104af16826742eb8256c387b898b1cd8a7769b02adc7c9f4af271fdc7a0b5d63affc2798eb587f02894b3b6a1a1cd75f9f98529a35f21f25d0e73ba3bd775c166b6b250eb0277fd42eef7f31f35083b4db37cec8a99435a05fc1361f903be214695ee91c0f2fa224af19984155ad6f655408e655a007279287571e5943b95ee89956f4c6ec69f34f0dc79951a8f58daa4b7423d54209d127308076f2497d079290a34b792719fa26cedfed4e36dadba28be87634f824e7e881fa209b1f45400fd1201a8f25d0b5fd120ffea817a792a3c64b59537fcd4e7e447eeaf3a792ce7111fef8d6ff00fe679ffc9aafc7ec56ba3bb73150e6a112c9ddbe97d46eac41cd101a6a13b4b10ed8170d0ad91b607dafe2ce6d052b6e6f51135de7c8fcc15e85ecc304182704e1d039b965959dbc971f89daebe960b17c77c2cfc7f15e1b8077a215aea79401f80da41f20f5ebb1b1b131ac6d835a0003a2e39c5e39e57f6e9e6e699716184741b65d0480f34be0aee476c1aa81894d7360a7170631ce3b05512132cdde3cee54e13bda69da48ec35e7ba9a34614d44cb36e4782ede72b4750995dd59c48ebfd5704dc0f1484dfe1709335cfd15a41d03f3dd2df55c8372ba0dd7ea83b68ca7c92bcd811f046c7c93733c01becab0353ca00f30a048735d3d3bee6d7d124715ecb49d07292136b9b5d593028f4ecd07c14c63740a995ec8568b2ec24d92172a2439d629a7bf7d7648f92daa8cf92f7569368b5d3df73a2e41ccb9d49faa7a38cdd5fd05636e53a1b64a0002c90b9676a4a481b265f280574e3a2835f531d1d3c93ca40630124ab638ed1689e5cef201d86abcd78b6b0e258cc54ac376b4ec168f07c69f578756d6497b35c48f2e4b23c391bb15c71f527519eebd4e0e3f0ddbf4e6cb2dbd1b03a614d87b1b6b689ca99333c307aa7ee208401c82834c7b7a973ada02b96f76e4bcea27c6cee0d109e60b36d742cbc96d22ccdb1599e25c21988425edeecd1eac778ad64adb855754cdc595b1a96269ea8d751ba8aa74959a0bf22bce789e9cd04ef7ec2f6705e91c414669a5fb5c22c79d96238ed82b30b75547ef81de1d56f95fc7649dbca71378757c520dbb46dfe2bd5a9a94474d1e51a650bc6ea26d4b09d770bdcb01b56e0b473117cf1349f82f2792eddd87484e8c8431ee8dc0836565252ea405cff66b9edb80b97767a6ad170a71198e4653ccfee9d012bd069e512b6e0df985e1eced68e7d6e2c57a3709e3c2a236c5238676fcc2ece1e5f2eab9b978f5dc6bed6dbcc240e2351e9fb2edae0fd079a4cb7b5b9ea174b9f46dd770b72e4ba6b40b69ba73274f3095cdbdfc750a12468d8f4d0a66ae2b8f1054802e7cc224199be6102d1691b7cd4c02f63e6a2530cad03fcca5b7f52ab43796c3d0ae6dddff006aefa79208ee9ff4a6c72763e413834bae4b743e4174e6d83bcc26c17ef1f24a7527c971adcf904a4eae4b0764fbde4906c7c923b671f44037bf9595743b1bfa2a1c7e22faf800fc54f2374eb769fd0abd26d7503148c9a9a3940f725ca7c9cd23eb656c3aa8acd8932b5a36e4a7539077e698c628dd0075b91e499c3eab3b46ba85d5aeb6aaf70f8d9f6fefb1a4d83d84f270b83f22adda735c954d4cf0c9e9e4ff0031613e63fa2ba0345cf9fb1d0d92b4ea8e48bdc2cc7355206436ebfcfa28103735ddf9b44ed6bcbe40c074e4ba899668f1569d458e8d1baae257dac3a257bf5b1f22a3cb2d8efb24892b9df249bedb725c333382758df9ab0ed83af34e81ccf915c3473eba2eafa79aa508e75aff00350ea24b903a276593f62a31bbdde2ad20e72976b6dd4a63371d3648c66a07229e8dbafa594da1e85ba7c0a91b05c443280ba71d1669239c9b2fd12b9d729a73ba2443891f73ba65def78271c75b0d6c86b35f25a20b0c77d4eca50195246c0d6ae952dda610eab8360529759379d4692247582c77b429dcde1b9c309177b41b74bad5cae59fe29a2fb7e152c1d4b4fc085d3c1d6736cb3f4c955d48c23828b2f692a0003c54cf6758798e984ee1abb559de32a9fb4e21498645ab2200103aaf43e1ea614385b34b59abd0e5bac3feec27b4bc42a32b4b41d764b85c7963cc79aad7486aaacb46caf60608d81be0b8b39e334da76741d1090349f142c96720dc6aa0558d0a1098fb19bc7181d4f203d0af2ec6a4221963fc2744216b97f55f078de3cdfb3d4bc3391d17b8f03b8ffdb387dcdfee1a842f2b2f6eac5696bc96f156f4b030c37b74421530f6be7e90f10c3a2923738e842acc22a64a3af6e43b3ade684299d67347bc5eaf864ee958c277b2b261b8f242177388e5ade852e5161e684291c8ff00ec95da83e0e421074c16bf8393e0ebfee2842a5096dbc8a3f0ff00b50840bf9bc82e8f3f3084281c81afa848e1bf9a10ac03b1f3480efe684241d13727cd45c4bffebb5dcdb3467e0e084263ee229bc52164d1b8100697f92c8519315718c7ba4fea842e8e2bd28d15cfd9dc41b65b387a10b40d3703c50859f225d0d921bb6f6e4842c7ec442334ce4f721e210857ab430f79bf9e8a36a5cebf22842b252231cbc2e9d02df0421568ec73f2bae243a7a5d0855111e733b5e69c6340d7a14215c3d6b7a27231de23c4210ab7d092365c38dc1421512e39fa268ea5085788720683e29f8da344214641db6891c74421424cbd36374215e208f17baa8c69d929c5b994216bc5fda299fa793613ff00a97144b2cc751215eab58ffb3e1bdc16d2c842f43e47f6c630c513026090ba576aebabe6ee1085c7cbfdab5c7d1d68d10842c1a3ffd9', 'm.bernier@eoqual.be', 1);
INSERT INTO public.staff_member VALUES (13, 'Robillard', 'Carole', false, 'crobillard', 'Y3JvYmlsbGFyZA==', 0, true, 'null', '', '', '\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', '', 3);
INSERT INTO public.staff_member VALUES (15, 'LeBatelier', 'Octave', false, 'olebatelier', 'cHBhcmlz', 3, true, 'null', '', '', '\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', '', 3);
INSERT INTO public.staff_member VALUES (12, 'Couture', 'Mallory', false, 'mcouture', 'bWNvdXR1cmU=', 1, true, 'null', '', '', '\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', '', 4);
INSERT INTO public.staff_member VALUES (0, 'admin', 'admin', false, 'admin', 'YWRtaW40YWxs', 0, true, 'null', '', '', '\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', '', 0);
INSERT INTO public.staff_member VALUES (16, 'Masson', 'Estelle', false, 'emasson', 'ZW1hc3Nvbg==', 1, true, 'null', '', '', '\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', 'e.masson@eoqual.be', 3);


--
-- TOC entry 5702 (class 0 OID 25426)
-- Dependencies: 298
-- Data for Name: staff_role; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.staff_role VALUES (-1, 'Undef', true, 1);
INSERT INTO public.staff_role VALUES (2, 'Radiologue', false, 1);
INSERT INTO public.staff_role VALUES (3, 'Technologue', false, 1);
INSERT INTO public.staff_role VALUES (4, 'Secrétaire', false, 1);
INSERT INTO public.staff_role VALUES (1, 'Responsable qualité', false, 1);
INSERT INTO public.staff_role VALUES (5, 'Radiologue remplaçant', false, 0);
INSERT INTO public.staff_role VALUES (7, 'Test', true, 1);
INSERT INTO public.staff_role VALUES (8, 'New job role', true, -1);
INSERT INTO public.staff_role VALUES (9, 'New job role', true, -1);
INSERT INTO public.staff_role VALUES (6, 'Test 2', true, 0);
INSERT INTO public.staff_role VALUES (10, 'Responsable RH', false, 0);


--
-- TOC entry 5704 (class 0 OID 25434)
-- Dependencies: 300
-- Data for Name: statuslist; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.statuslist VALUES (-1, '', '|device_inspection_result|device|');
INSERT INTO public.statuslist VALUES (1, 'Actif', '|device|');
INSERT INTO public.statuslist VALUES (5, 'OK', '|device_inspection_result|');
INSERT INTO public.statuslist VALUES (6, 'KO', '|device_inspection_result|');
INSERT INTO public.statuslist VALUES (7, 'Open', '|report|');
INSERT INTO public.statuslist VALUES (4, 'Completed', '|device_inspection|staff_formation|action|audit|device_maintenance|');
INSERT INTO public.statuslist VALUES (3, 'Planned', '|device_inspection|staff_formation|action|audit|device_maintenance|survey|');
INSERT INTO public.statuslist VALUES (8, 'Closed', '|report|survey|');
INSERT INTO public.statuslist VALUES (9, 'In progress', '|survey|');
INSERT INTO public.statuslist VALUES (10, 'Draft', '|document|');
INSERT INTO public.statuslist VALUES (11, 'Pending approval', '|document|');
INSERT INTO public.statuslist VALUES (12, 'Approved', '|document|');
INSERT INTO public.statuslist VALUES (2, 'Obsolete', '|device|document|');
INSERT INTO public.statuslist VALUES (13, 'Deleted', '|document|');
INSERT INTO public.statuslist VALUES (14, 'Published', '|document|');


--
-- TOC entry 5706 (class 0 OID 25440)
-- Dependencies: 302
-- Data for Name: survey; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.survey VALUES (1, 'Enquête de satisfaction', '<p><strong>Madame,&nbsp;Monsieur,&nbsp;</strong></p><p>Vos&nbsp;appréciations&nbsp;sur&nbsp;l’ensemble&nbsp;de&nbsp;votre&nbsp;séjour&nbsp;sont&nbsp;essentielles&nbsp;pour&nbsp;améliorer&nbsp;la&nbsp;qualité&nbsp;du&nbsp;service&nbsp;que&nbsp;nous&nbsp;offrons&nbsp;aux&nbsp;patients.&nbsp;Nous&nbsp;vous&nbsp;invitons&nbsp;à&nbsp;remplir&nbsp;ce&nbsp;questionnaire&nbsp;en&nbsp;cochant&nbsp;votre&nbsp;choix&nbsp;pour&nbsp;chaque&nbsp;question.</p><p><strong>Si&nbsp;vous&nbsp;n&#39;êtes&nbsp;pas&nbsp;concerné(e)&nbsp;par&nbsp;l&#39;une&nbsp;des&nbsp;questions,&nbsp;merci&nbsp;de&nbsp;ne&nbsp;pas&nbsp;y&nbsp;répondre.</strong>&nbsp;</p><p>Vous&nbsp;retrouvez&nbsp;également&nbsp;à&nbsp;la&nbsp;fin&nbsp;de&nbsp;ce&nbsp;questionnaire&nbsp;un&nbsp;espace&nbsp;commentaires,&nbsp;qui&nbsp;vous&nbsp;permettra&nbsp;d&#39;apporter&nbsp;des&nbsp;précisions&nbsp;sur&nbsp;votre&nbsp;séjour.</p>', 1, 3, '2025-02-14 00:00:00+01', '2025-02-28 00:00:00+01', '', '<p><strong>Les&nbsp;conclusions&nbsp;de&nbsp;cette&nbsp;enquête&nbsp;sont&nbsp;:</strong></p><ul><li>un&nbsp;degré&nbsp;de&nbsp;satisfaction&nbsp;élevé&nbsp;sur&nbsp;les&nbsp;conditions&nbsp;d&#39;accueil.</li><li>un&nbsp;niveau&nbsp;de&nbsp;satisfaction&nbsp;insuffisant&nbsp;sur&nbsp;la&nbsp;communication&nbsp;avec&nbsp;les&nbsp;médecins.</li><li>un&nbsp;accès&nbsp;aux&nbsp;informations&nbsp;satisfaisant&nbsp;pour&nbsp;55%&nbsp;des&nbsp;patients.&nbsp;</li></ul><p></p><p>Des&nbsp;actions&nbsp;vont&nbsp;être&nbsp;planifiées&nbsp;pour&nbsp;améliorer&nbsp;la&nbsp;situation.</p>', false);
INSERT INTO public.survey VALUES (4, 'New survey', NULL, 1, 3, '2025-03-05 15:00:54+01', '2025-03-05 15:00:54+01', NULL, NULL, true);
INSERT INTO public.survey VALUES (3, 'New survey', '<p></p>', 1, 3, '2025-03-05 00:00:00+01', '2025-03-05 00:00:00+01', '', '<p></p>', true);
INSERT INTO public.survey VALUES (5, 'New survey', '<p></p>', 1, 3, '2025-03-06 00:00:00+01', '2025-03-07 00:00:00+01', '', '<p></p>', false);
INSERT INTO public.survey VALUES (2, 'Enquête qualité des soins', '', 1, 3, '2025-03-01 00:00:00+01', '2025-03-15 00:00:00+01', '<p>Test</p>', '', false);


--
-- TOC entry 5707 (class 0 OID 25446)
-- Dependencies: 303
-- Data for Name: survey_field; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.survey_field VALUES (33, '- du calme de la chambre ?', 3, 1, 32);
INSERT INTO public.survey_field VALUES (34, '- de la température de la chambre?', 3, 1, 33);
INSERT INTO public.survey_field VALUES (35, '- de l''adaptation des locaux à votre état de santé ?', 3, 1, 34);
INSERT INTO public.survey_field VALUES (39, 'Votre nom (facultatif) : ', 7, 2, 0);
INSERT INTO public.survey_field VALUES (40, 'Vos commentaires :', 8, 2, 1);
INSERT INTO public.survey_field VALUES (41, 'VOTRE AVIS COMPTE', 1, 1, 35);
INSERT INTO public.survey_field VALUES (42, 'N''hésitez pas à nous faire part de vos remarques :', 8, 1, 36);
INSERT INTO public.survey_field VALUES (43, 'Votre nom (facultatif) :', 7, 1, 37);
INSERT INTO public.survey_field VALUES (2, 'VOTRE ACCUEIL', 1, 1, 0);
INSERT INTO public.survey_field VALUES (1, 'Que pensez-vous :', 5, 1, 1);
INSERT INTO public.survey_field VALUES (3, '- de l''accessibilité de l''établissement (transport/ parking) ?', 3, 1, 2);
INSERT INTO public.survey_field VALUES (4, '- du fléchage et des indications pour parvenir au(x) service(s)?', 3, 1, 3);
INSERT INTO public.survey_field VALUES (5, 'Que pensez-vous de l''accueil :', 5, 1, 4);
INSERT INTO public.survey_field VALUES (6, '- au bureau des consultations et des hospitalisations ?', 3, 1, 5);
INSERT INTO public.survey_field VALUES (7, '- dans le(s) service(s) de soins ?', 3, 1, 6);
INSERT INTO public.survey_field VALUES (8, 'Que pensez-vous des informations données en amont de votre séjour sur :', 5, 1, 7);
INSERT INTO public.survey_field VALUES (9, '- les consignes à respecter (ex : être à jeun, accompagné, 
horaires...) ?', 3, 1, 8);
INSERT INTO public.survey_field VALUES (10, '- les documents à apporter (ex: convocations, examens...) ?', 3, 1, 9);
INSERT INTO public.survey_field VALUES (11, 'VOTRE PRISE EN CHARGE', 1, 1, 10);
INSERT INTO public.survey_field VALUES (12, 'Durant votre séjour, avez-vous obtenu spontanément des informations claires et 
suffisantes, concernant :', 6, 1, 11);
INSERT INTO public.survey_field VALUES (13, '- votre état de santé ?', 2, 1, 12);
INSERT INTO public.survey_field VALUES (14, '- le déroulement des soins ?', 2, 1, 13);
INSERT INTO public.survey_field VALUES (15, 'Le personnel a-t-il répondu à vos questions ?', 4, 1, 14);
INSERT INTO public.survey_field VALUES (16, 'Si oui, est-ce que les réponses apportées ont été claires et 
suffisantes ?', 2, 1, 15);
INSERT INTO public.survey_field VALUES (17, 'Estimez-vous que votre intimité et dignité ont été respectées 
durant votre séjour?
', 4, 1, 16);
INSERT INTO public.survey_field VALUES (18, 'Pensez-vous que la confidentialité de vos informations a été 
respectée ?', 4, 1, 17);
INSERT INTO public.survey_field VALUES (19, 'Prise en charge de votre douleur ', 5, 1, 18);
INSERT INTO public.survey_field VALUES (20, '- comment la jugez-vous ?', 3, 1, 19);
INSERT INTO public.survey_field VALUES (21, 'Globalement, comment évaluez-vous la qualité de votre prise en charge par :', 5, 1, 20);
INSERT INTO public.survey_field VALUES (22, '- les médecins/ chirurgiens ?', 3, 1, 21);
INSERT INTO public.survey_field VALUES (23, '- les paramédicaux (infirmier, aide-soignant) ?', 3, 1, 22);
INSERT INTO public.survey_field VALUES (24, '- les kinésithérapeutes ?', 3, 1, 23);
INSERT INTO public.survey_field VALUES (25, '- les diététiciens ?', 3, 1, 24);
INSERT INTO public.survey_field VALUES (26, '- les assistants sociaux ?', 3, 1, 25);
INSERT INTO public.survey_field VALUES (27, '- les psychologues ?', 3, 1, 26);
INSERT INTO public.survey_field VALUES (28, 'Avez-vous trouvé le temps d''attente convenable au moment du 
transfert?', 4, 1, 27);
INSERT INTO public.survey_field VALUES (29, 'CHAMBRE ET REPAS', 1, 1, 28);
INSERT INTO public.survey_field VALUES (30, 'Etes-vous satisfait :', 5, 1, 29);
INSERT INTO public.survey_field VALUES (31, '- de la propreté de la chambre ?', 3, 1, 30);
INSERT INTO public.survey_field VALUES (32, '- des prestations complémentaires proposées par la conciergerie 
(télévision, téléphone, internet) ?', 3, 1, 31);


--
-- TOC entry 5709 (class 0 OID 25452)
-- Dependencies: 305
-- Data for Name: survey_field_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.survey_field_type VALUES (2, 'Yes-No');
INSERT INTO public.survey_field_type VALUES (3, '5 smileys');
INSERT INTO public.survey_field_type VALUES (4, 'Header Yes-No');
INSERT INTO public.survey_field_type VALUES (5, 'Header 5 smileys');
INSERT INTO public.survey_field_type VALUES (1, 'Main header');
INSERT INTO public.survey_field_type VALUES (6, 'Header');
INSERT INTO public.survey_field_type VALUES (7, 'String');
INSERT INTO public.survey_field_type VALUES (8, 'Text');


--
-- TOC entry 5712 (class 0 OID 25459)
-- Dependencies: 308
-- Data for Name: survey_resp; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.survey_resp VALUES (8, 1, '2025-02-17 15:34:44+01');
INSERT INTO public.survey_resp VALUES (9, 1, '2025-02-17 15:35:44+01');
INSERT INTO public.survey_resp VALUES (10, 1, '2025-02-17 15:36:34+01');
INSERT INTO public.survey_resp VALUES (11, 1, '2025-02-20 17:27:17+01');
INSERT INTO public.survey_resp VALUES (12, 1, '2025-02-20 17:30:38+01');
INSERT INTO public.survey_resp VALUES (13, 1, '2025-02-20 17:31:35+01');


--
-- TOC entry 5713 (class 0 OID 25462)
-- Dependencies: 309
-- Data for Name: survey_resp_field; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.survey_resp_field VALUES (17, 3, 2, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (18, 4, 2, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (19, 6, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (20, 7, 4, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (21, 9, 1, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (22, 10, 4, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (23, 13, 1, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (24, 14, 1, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (25, 15, 1, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (26, 16, 0, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (27, 17, 0, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (28, 18, 1, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (29, 20, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (30, 22, 4, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (31, 23, 2, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (32, 24, 2, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (33, 25, 1, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (34, 26, 4, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (35, 27, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (36, 28, 0, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (37, 31, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (38, 32, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (39, 33, 4, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (40, 34, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (41, 35, 3, 8, NULL);
INSERT INTO public.survey_resp_field VALUES (42, 3, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (43, 4, 2, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (44, 6, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (45, 7, 2, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (46, 9, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (47, 10, 2, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (48, 13, 0, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (49, 14, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (50, 15, 0, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (51, 16, 0, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (52, 17, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (53, 18, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (54, 20, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (55, 22, 4, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (56, 23, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (57, 24, 2, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (58, 25, 4, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (59, 26, 2, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (60, 27, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (61, 28, 1, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (62, 31, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (63, 32, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (64, 33, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (65, 34, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (66, 35, 3, 9, NULL);
INSERT INTO public.survey_resp_field VALUES (67, 3, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (68, 4, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (69, 6, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (70, 7, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (71, 9, 4, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (72, 10, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (73, 13, 0, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (74, 14, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (75, 15, 0, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (76, 16, 0, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (77, 17, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (78, 18, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (79, 20, 3, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (80, 22, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (81, 23, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (82, 24, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (83, 25, 4, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (84, 26, 3, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (85, 27, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (86, 28, 1, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (87, 31, 3, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (88, 32, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (89, 33, 3, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (90, 34, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (91, 35, 2, 10, NULL);
INSERT INTO public.survey_resp_field VALUES (92, 3, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (93, 4, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (94, 6, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (95, 7, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (96, 9, 3, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (97, 10, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (98, 13, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (99, 14, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (100, 15, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (101, 16, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (102, 17, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (103, 18, 0, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (104, 20, 3, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (105, 22, 3, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (106, 23, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (107, 24, 3, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (108, 25, 3, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (109, 26, 4, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (110, 27, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (111, 28, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (112, 31, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (113, 32, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (114, 33, 1, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (115, 34, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (116, 35, 2, 11, NULL);
INSERT INTO public.survey_resp_field VALUES (117, 3, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (118, 4, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (119, 6, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (120, 7, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (121, 9, 3, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (122, 10, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (123, 13, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (124, 14, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (125, 15, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (126, 16, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (127, 17, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (128, 18, 0, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (129, 20, 3, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (130, 22, 3, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (131, 23, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (132, 24, 3, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (133, 25, 3, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (134, 26, 4, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (135, 27, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (136, 28, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (137, 31, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (138, 32, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (139, 33, 1, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (140, 34, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (141, 35, 2, 12, NULL);
INSERT INTO public.survey_resp_field VALUES (143, 3, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (144, 4, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (145, 6, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (146, 7, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (147, 9, 3, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (148, 10, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (149, 13, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (150, 14, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (151, 15, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (152, 16, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (153, 17, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (154, 18, 0, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (155, 20, 3, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (156, 22, 3, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (157, 23, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (158, 24, 3, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (159, 25, 3, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (160, 26, 4, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (161, 27, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (162, 28, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (163, 31, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (164, 32, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (165, 33, 1, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (166, 34, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (167, 35, 2, 13, NULL);
INSERT INTO public.survey_resp_field VALUES (168, 42, -1, 13, 'RAS.');


--
-- TOC entry 5716 (class 0 OID 25469)
-- Dependencies: 312
-- Data for Name: survey_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.survey_type VALUES (1, 'Patient');


--
-- TOC entry 5718 (class 0 OID 25475)
-- Dependencies: 314
-- Data for Name: tag; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.tag VALUES (2, 'OR', 'XIMEO Qualité', false);
INSERT INTO public.tag VALUES (3, 'OR', 'XIMEO Radiologie', false);
INSERT INTO public.tag VALUES (4, 'AND', 'Thorax', false);
INSERT INTO public.tag VALUES (7, 'AND', 'Scanner', false);
INSERT INTO public.tag VALUES (8, 'AND', 'Radiographie', false);
INSERT INTO public.tag VALUES (13, 'OR', 'Centre de radiologie XIMEO Médecine nucléaire', false);
INSERT INTO public.tag VALUES (14, 'OR', 'XIMEO 1 New department', true);
INSERT INTO public.tag VALUES (15, 'OR', 'XIMEO 2 Qualité', false);
INSERT INTO public.tag VALUES (12, 'OR', 'site eoQUAL 2 Radiologie', false);
INSERT INTO public.tag VALUES (16, 'OR', 'site eoQUAL 2 Médecine nucléaire', false);
INSERT INTO public.tag VALUES (24, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (23, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (19, 'AND', 'ccccccccccccccccccccc', true);
INSERT INTO public.tag VALUES (20, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (17, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (9, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (18, 'AND', 'bbbbb', true);
INSERT INTO public.tag VALUES (21, 'AND', 'aaaa', true);
INSERT INTO public.tag VALUES (22, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (6, 'AND', 'ORL', false);
INSERT INTO public.tag VALUES (25, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (26, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (10, 'AND', 'Mammographie', false);
INSERT INTO public.tag VALUES (27, 'AND', 'New taghhhhhhhhhhhhhhh', true);
INSERT INTO public.tag VALUES (5, 'AND', 'Abdomen', false);
INSERT INTO public.tag VALUES (28, 'AND', 'aaaa', true);
INSERT INTO public.tag VALUES (29, 'OR', 'Aaaaaaaaaaaaaaaaaaaa', true);
INSERT INTO public.tag VALUES (30, 'OR', 'New Institutionnnnnnnnnnnnn', true);
INSERT INTO public.tag VALUES (31, 'OR', 'site eoQUAL 1 New department', true);
INSERT INTO public.tag VALUES (32, 'OR', 'site eoQUAL 1 New departmenttttt', true);
INSERT INTO public.tag VALUES (34, 'OR', 'New Institution New department', true);
INSERT INTO public.tag VALUES (33, 'OR', 'New Institution', true);
INSERT INTO public.tag VALUES (35, 'AND', 'New tag', true);
INSERT INTO public.tag VALUES (36, 'AND', 'New tagggggggggggggggggg', true);
INSERT INTO public.tag VALUES (1, 'OR', 'Site eoQUAL 1', false);
INSERT INTO public.tag VALUES (11, 'OR', 'Site eoQUAL 2', false);


--
-- TOC entry 5720 (class 0 OID 25482)
-- Dependencies: 316
-- Data for Name: tag_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.tag_link VALUES (1, 'institution', 1, 1);
INSERT INTO public.tag_link VALUES (2, 'department', 1, 2);
INSERT INTO public.tag_link VALUES (3, 'department', 2, 3);
INSERT INTO public.tag_link VALUES (8, 'examlist', 2, 4);
INSERT INTO public.tag_link VALUES (9, 'examlist', 2, 8);
INSERT INTO public.tag_link VALUES (15, 'examlist', 3, 3);
INSERT INTO public.tag_link VALUES (16, 'examlist', 3, 6);
INSERT INTO public.tag_link VALUES (17, 'examlist', 3, 8);
INSERT INTO public.tag_link VALUES (18, 'examlist', 4, 3);
INSERT INTO public.tag_link VALUES (19, 'examlist', 4, 6);
INSERT INTO public.tag_link VALUES (20, 'examlist', 4, 8);
INSERT INTO public.tag_link VALUES (21, 'examlist', 5, 3);
INSERT INTO public.tag_link VALUES (22, 'examlist', 5, 6);
INSERT INTO public.tag_link VALUES (23, 'examlist', 5, 8);
INSERT INTO public.tag_link VALUES (24, 'examlist', 1, 3);
INSERT INTO public.tag_link VALUES (25, 'examlist', 1, 4);
INSERT INTO public.tag_link VALUES (26, 'examlist', 1, 7);
INSERT INTO public.tag_link VALUES (27, 'examlist', 6, 3);
INSERT INTO public.tag_link VALUES (28, 'examlist', 6, 5);
INSERT INTO public.tag_link VALUES (29, 'examlist', 6, 7);
INSERT INTO public.tag_link VALUES (30, 'examlist', 7, 3);
INSERT INTO public.tag_link VALUES (31, 'examlist', 7, 5);
INSERT INTO public.tag_link VALUES (32, 'examlist', 7, 7);
INSERT INTO public.tag_link VALUES (37, 'examlist', 8, 3);
INSERT INTO public.tag_link VALUES (38, 'examlist', 8, 5);
INSERT INTO public.tag_link VALUES (39, 'examlist', 8, 8);
INSERT INTO public.tag_link VALUES (40, 'examlist', 9, 3);
INSERT INTO public.tag_link VALUES (41, 'examlist', 9, 5);
INSERT INTO public.tag_link VALUES (42, 'examlist', 9, 8);
INSERT INTO public.tag_link VALUES (43, 'examlist', 10, 3);
INSERT INTO public.tag_link VALUES (44, 'examlist', 10, 5);
INSERT INTO public.tag_link VALUES (45, 'examlist', 10, 8);
INSERT INTO public.tag_link VALUES (46, 'examlist', 11, 3);
INSERT INTO public.tag_link VALUES (47, 'examlist', 11, 5);
INSERT INTO public.tag_link VALUES (48, 'examlist', 11, 8);
INSERT INTO public.tag_link VALUES (49, 'examlist', 12, 3);
INSERT INTO public.tag_link VALUES (50, 'examlist', 12, 4);
INSERT INTO public.tag_link VALUES (51, 'examlist', 12, 7);
INSERT INTO public.tag_link VALUES (52, 'examlist', 13, 5);
INSERT INTO public.tag_link VALUES (53, 'examlist', 13, 7);
INSERT INTO public.tag_link VALUES (54, 'examlist', 14, 3);
INSERT INTO public.tag_link VALUES (55, 'examlist', 14, 5);
INSERT INTO public.tag_link VALUES (56, 'examlist', 14, 7);
INSERT INTO public.tag_link VALUES (57, 'examlist', 15, 3);
INSERT INTO public.tag_link VALUES (58, 'examlist', 15, 5);
INSERT INTO public.tag_link VALUES (59, 'examlist', 15, 7);
INSERT INTO public.tag_link VALUES (60, 'examlist', 16, 5);
INSERT INTO public.tag_link VALUES (61, 'examlist', 16, 7);
INSERT INTO public.tag_link VALUES (64, 'examlist', 17, 3);
INSERT INTO public.tag_link VALUES (65, 'examlist', 17, 7);
INSERT INTO public.tag_link VALUES (66, 'examlist', 18, 3);
INSERT INTO public.tag_link VALUES (67, 'examlist', 18, 6);
INSERT INTO public.tag_link VALUES (69, 'examlist', 19, 3);
INSERT INTO public.tag_link VALUES (70, 'examlist', 19, 10);
INSERT INTO public.tag_link VALUES (71, 'examlist', 24, 3);
INSERT INTO public.tag_link VALUES (72, 'examlist', 26, 3);
INSERT INTO public.tag_link VALUES (73, 'examlist', 27, 3);
INSERT INTO public.tag_link VALUES (74, 'examlist', 28, 3);
INSERT INTO public.tag_link VALUES (75, 'examlist', 29, 3);
INSERT INTO public.tag_link VALUES (76, 'examlist', 30, 3);
INSERT INTO public.tag_link VALUES (77, 'examlist', 31, 3);
INSERT INTO public.tag_link VALUES (78, 'examlist', 32, 3);
INSERT INTO public.tag_link VALUES (79, 'examlist', 33, 3);
INSERT INTO public.tag_link VALUES (80, 'examlist', 34, 3);
INSERT INTO public.tag_link VALUES (81, 'examlist', 35, 3);
INSERT INTO public.tag_link VALUES (82, 'examlist', 36, 3);
INSERT INTO public.tag_link VALUES (83, 'examlist', 37, 3);
INSERT INTO public.tag_link VALUES (84, 'examlist', 38, 3);
INSERT INTO public.tag_link VALUES (85, 'examlist', 39, 3);
INSERT INTO public.tag_link VALUES (86, 'examlist', 40, 3);
INSERT INTO public.tag_link VALUES (87, 'examlist', 41, 3);
INSERT INTO public.tag_link VALUES (88, 'examlist', 42, 3);
INSERT INTO public.tag_link VALUES (89, 'examlist', 43, 3);
INSERT INTO public.tag_link VALUES (90, 'examlist', 44, 3);
INSERT INTO public.tag_link VALUES (91, 'examlist', 45, 3);
INSERT INTO public.tag_link VALUES (92, 'examlist', 46, 3);
INSERT INTO public.tag_link VALUES (93, 'examlist', 47, 3);
INSERT INTO public.tag_link VALUES (94, 'examlist', 48, 3);
INSERT INTO public.tag_link VALUES (95, 'examlist', 49, 3);
INSERT INTO public.tag_link VALUES (96, 'examlist', 50, 3);
INSERT INTO public.tag_link VALUES (97, 'examlist', 52, 3);
INSERT INTO public.tag_link VALUES (98, 'examlist', 53, 3);
INSERT INTO public.tag_link VALUES (99, 'examlist', 54, 3);
INSERT INTO public.tag_link VALUES (100, 'examlist', 55, 3);
INSERT INTO public.tag_link VALUES (101, 'examlist', 56, 3);
INSERT INTO public.tag_link VALUES (102, 'examlist', 57, 3);
INSERT INTO public.tag_link VALUES (103, 'examlist', 58, 3);
INSERT INTO public.tag_link VALUES (104, 'examlist', 59, 3);
INSERT INTO public.tag_link VALUES (105, 'examlist', 60, 3);
INSERT INTO public.tag_link VALUES (106, 'examlist', 61, 3);
INSERT INTO public.tag_link VALUES (107, 'examlist', 62, 3);
INSERT INTO public.tag_link VALUES (108, 'examlist', 63, 3);
INSERT INTO public.tag_link VALUES (109, 'examlist', 64, 3);
INSERT INTO public.tag_link VALUES (110, 'examlist', 65, 3);
INSERT INTO public.tag_link VALUES (111, 'examlist', 66, 3);
INSERT INTO public.tag_link VALUES (112, 'examlist', 67, 3);
INSERT INTO public.tag_link VALUES (113, 'examlist', 69, 3);
INSERT INTO public.tag_link VALUES (114, 'examlist', 70, 3);
INSERT INTO public.tag_link VALUES (115, 'examlist', 71, 3);
INSERT INTO public.tag_link VALUES (116, 'examlist', 71, 8);
INSERT INTO public.tag_link VALUES (117, 'examlist', 72, 3);
INSERT INTO public.tag_link VALUES (118, 'examlist', 72, 6);
INSERT INTO public.tag_link VALUES (119, 'examlist', 72, 8);
INSERT INTO public.tag_link VALUES (120, 'examlist', 73, 3);
INSERT INTO public.tag_link VALUES (121, 'examlist', 73, 6);
INSERT INTO public.tag_link VALUES (122, 'examlist', 74, 3);
INSERT INTO public.tag_link VALUES (123, 'examlist', 74, 4);
INSERT INTO public.tag_link VALUES (124, 'examlist', 75, 3);
INSERT INTO public.tag_link VALUES (125, 'examlist', 75, 8);
INSERT INTO public.tag_link VALUES (126, 'examlist', 76, 3);
INSERT INTO public.tag_link VALUES (127, 'examlist', 76, 8);
INSERT INTO public.tag_link VALUES (128, 'examlist', 77, 3);
INSERT INTO public.tag_link VALUES (129, 'examlist', 77, 8);
INSERT INTO public.tag_link VALUES (130, 'examlist', 78, 3);
INSERT INTO public.tag_link VALUES (131, 'examlist', 78, 8);
INSERT INTO public.tag_link VALUES (132, 'examlist', 79, 3);
INSERT INTO public.tag_link VALUES (133, 'examlist', 79, 8);
INSERT INTO public.tag_link VALUES (134, 'examlist', 80, 3);
INSERT INTO public.tag_link VALUES (135, 'examlist', 80, 8);
INSERT INTO public.tag_link VALUES (136, 'examlist', 81, 3);
INSERT INTO public.tag_link VALUES (137, 'examlist', 82, 3);
INSERT INTO public.tag_link VALUES (138, 'examlist', 84, 3);
INSERT INTO public.tag_link VALUES (139, 'examlist', 84, 8);
INSERT INTO public.tag_link VALUES (140, 'examlist', 86, 3);
INSERT INTO public.tag_link VALUES (141, 'examlist', 86, 8);
INSERT INTO public.tag_link VALUES (142, 'examlist', 87, 3);
INSERT INTO public.tag_link VALUES (143, 'examlist', 87, 8);
INSERT INTO public.tag_link VALUES (144, 'examlist', 88, 3);
INSERT INTO public.tag_link VALUES (145, 'examlist', 88, 8);
INSERT INTO public.tag_link VALUES (146, 'examlist', 89, 3);
INSERT INTO public.tag_link VALUES (147, 'examlist', 89, 8);
INSERT INTO public.tag_link VALUES (148, 'examlist', 90, 3);
INSERT INTO public.tag_link VALUES (149, 'examlist', 90, 8);
INSERT INTO public.tag_link VALUES (150, 'examlist', 91, 3);
INSERT INTO public.tag_link VALUES (151, 'examlist', 91, 8);
INSERT INTO public.tag_link VALUES (152, 'examlist', 92, 3);
INSERT INTO public.tag_link VALUES (153, 'examlist', 92, 8);
INSERT INTO public.tag_link VALUES (154, 'examlist', 93, 3);
INSERT INTO public.tag_link VALUES (155, 'examlist', 93, 8);
INSERT INTO public.tag_link VALUES (156, 'examlist', 94, 3);
INSERT INTO public.tag_link VALUES (157, 'examlist', 94, 8);
INSERT INTO public.tag_link VALUES (158, 'examlist', 95, 3);
INSERT INTO public.tag_link VALUES (159, 'examlist', 95, 8);
INSERT INTO public.tag_link VALUES (160, 'examlist', 96, 3);
INSERT INTO public.tag_link VALUES (161, 'examlist', 96, 8);
INSERT INTO public.tag_link VALUES (162, 'examlist', 97, 3);
INSERT INTO public.tag_link VALUES (163, 'examlist', 98, 3);
INSERT INTO public.tag_link VALUES (164, 'examlist', 98, 8);
INSERT INTO public.tag_link VALUES (165, 'examlist', 99, 3);
INSERT INTO public.tag_link VALUES (166, 'examlist', 99, 4);
INSERT INTO public.tag_link VALUES (167, 'examlist', 99, 7);
INSERT INTO public.tag_link VALUES (168, 'examlist', 100, 4);
INSERT INTO public.tag_link VALUES (169, 'examlist', 100, 7);
INSERT INTO public.tag_link VALUES (170, 'examlist', 101, 3);
INSERT INTO public.tag_link VALUES (171, 'examlist', 101, 4);
INSERT INTO public.tag_link VALUES (172, 'examlist', 101, 7);
INSERT INTO public.tag_link VALUES (176, 'examlist', 103, 3);
INSERT INTO public.tag_link VALUES (177, 'examlist', 103, 5);
INSERT INTO public.tag_link VALUES (178, 'examlist', 103, 7);
INSERT INTO public.tag_link VALUES (179, 'examlist', 104, 3);
INSERT INTO public.tag_link VALUES (180, 'examlist', 104, 5);
INSERT INTO public.tag_link VALUES (181, 'examlist', 104, 7);
INSERT INTO public.tag_link VALUES (182, 'examlist', 105, 3);
INSERT INTO public.tag_link VALUES (183, 'examlist', 105, 5);
INSERT INTO public.tag_link VALUES (184, 'examlist', 105, 7);
INSERT INTO public.tag_link VALUES (185, 'examlist', 106, 3);
INSERT INTO public.tag_link VALUES (186, 'examlist', 106, 5);
INSERT INTO public.tag_link VALUES (187, 'examlist', 106, 7);
INSERT INTO public.tag_link VALUES (188, 'examlist', 107, 3);
INSERT INTO public.tag_link VALUES (189, 'examlist', 107, 5);
INSERT INTO public.tag_link VALUES (190, 'examlist', 107, 7);
INSERT INTO public.tag_link VALUES (191, 'examlist', 108, 3);
INSERT INTO public.tag_link VALUES (192, 'examlist', 108, 7);
INSERT INTO public.tag_link VALUES (193, 'examlist', 109, 3);
INSERT INTO public.tag_link VALUES (194, 'examlist', 109, 6);
INSERT INTO public.tag_link VALUES (195, 'examlist', 109, 7);
INSERT INTO public.tag_link VALUES (196, 'examlist', 110, 3);
INSERT INTO public.tag_link VALUES (197, 'examlist', 110, 6);
INSERT INTO public.tag_link VALUES (198, 'examlist', 110, 7);
INSERT INTO public.tag_link VALUES (199, 'examlist', 111, 3);
INSERT INTO public.tag_link VALUES (200, 'examlist', 111, 6);
INSERT INTO public.tag_link VALUES (201, 'examlist', 111, 7);
INSERT INTO public.tag_link VALUES (202, 'examlist', 112, 3);
INSERT INTO public.tag_link VALUES (203, 'examlist', 112, 6);
INSERT INTO public.tag_link VALUES (204, 'examlist', 112, 7);
INSERT INTO public.tag_link VALUES (205, 'examlist', 113, 3);
INSERT INTO public.tag_link VALUES (206, 'examlist', 113, 6);
INSERT INTO public.tag_link VALUES (207, 'examlist', 113, 7);
INSERT INTO public.tag_link VALUES (208, 'examlist', 114, 3);
INSERT INTO public.tag_link VALUES (209, 'examlist', 114, 6);
INSERT INTO public.tag_link VALUES (210, 'examlist', 114, 7);
INSERT INTO public.tag_link VALUES (214, 'examlist', 116, 3);
INSERT INTO public.tag_link VALUES (215, 'examlist', 116, 5);
INSERT INTO public.tag_link VALUES (216, 'examlist', 116, 7);
INSERT INTO public.tag_link VALUES (217, 'examlist', 117, 3);
INSERT INTO public.tag_link VALUES (218, 'examlist', 117, 5);
INSERT INTO public.tag_link VALUES (219, 'examlist', 117, 7);
INSERT INTO public.tag_link VALUES (226, 'examlist', 120, 3);
INSERT INTO public.tag_link VALUES (233, 'examlist', 122, 4);
INSERT INTO public.tag_link VALUES (234, 'examlist', 122, 5);
INSERT INTO public.tag_link VALUES (235, 'examlist', 122, 7);
INSERT INTO public.tag_link VALUES (236, 'examlist', 123, 3);
INSERT INTO public.tag_link VALUES (237, 'examlist', 123, 4);
INSERT INTO public.tag_link VALUES (238, 'examlist', 123, 5);
INSERT INTO public.tag_link VALUES (239, 'examlist', 123, 7);
INSERT INTO public.tag_link VALUES (240, 'examlist', 124, 3);
INSERT INTO public.tag_link VALUES (241, 'examlist', 124, 6);
INSERT INTO public.tag_link VALUES (242, 'examlist', 124, 7);
INSERT INTO public.tag_link VALUES (243, 'examlist', 125, 3);
INSERT INTO public.tag_link VALUES (244, 'examlist', 125, 7);
INSERT INTO public.tag_link VALUES (245, 'examlist', 126, 3);
INSERT INTO public.tag_link VALUES (246, 'examlist', 126, 7);
INSERT INTO public.tag_link VALUES (247, 'examlist', 127, 3);
INSERT INTO public.tag_link VALUES (248, 'examlist', 127, 7);
INSERT INTO public.tag_link VALUES (249, 'examlist', 128, 3);
INSERT INTO public.tag_link VALUES (250, 'examlist', 128, 7);
INSERT INTO public.tag_link VALUES (251, 'examlist', 129, 3);
INSERT INTO public.tag_link VALUES (252, 'examlist', 129, 10);
INSERT INTO public.tag_link VALUES (253, 'institution', 2, 11);
INSERT INTO public.tag_link VALUES (254, 'department', 3, 12);
INSERT INTO public.tag_link VALUES (255, 'department', 4, 13);
INSERT INTO public.tag_link VALUES (256, 'examlist', 131, 3);
INSERT INTO public.tag_link VALUES (257, 'department', 5, 14);
INSERT INTO public.tag_link VALUES (258, 'examlist', 120, 1);
INSERT INTO public.tag_link VALUES (259, 'examlist', 121, 11);
INSERT INTO public.tag_link VALUES (264, 'department', 6, 15);
INSERT INTO public.tag_link VALUES (270, 'examlist', 103, 1);
INSERT INTO public.tag_link VALUES (271, 'examlist', 115, 3);
INSERT INTO public.tag_link VALUES (272, 'examlist', 115, 1);
INSERT INTO public.tag_link VALUES (273, 'examlist', 119, 3);
INSERT INTO public.tag_link VALUES (274, 'examlist', 119, 1);
INSERT INTO public.tag_link VALUES (279, 'department', 7, 16);
INSERT INTO public.tag_link VALUES (280, 'institution', 3, 29);
INSERT INTO public.tag_link VALUES (281, 'institution', 4, 30);
INSERT INTO public.tag_link VALUES (282, 'department', 8, 31);
INSERT INTO public.tag_link VALUES (283, 'department', 9, 32);
INSERT INTO public.tag_link VALUES (284, 'institution', 5, 33);
INSERT INTO public.tag_link VALUES (285, 'department', 10, 34);
INSERT INTO public.tag_link VALUES (286, 'procedure', 16, 4);
INSERT INTO public.tag_link VALUES (287, 'procedure', 16, 1);
INSERT INTO public.tag_link VALUES (293, 'examlist', 136, 10);
INSERT INTO public.tag_link VALUES (294, 'examlist', 136, 8);
INSERT INTO public.tag_link VALUES (295, 'procedure', 19, 1);
INSERT INTO public.tag_link VALUES (297, 'procedure', 6, 2);
INSERT INTO public.tag_link VALUES (298, 'procedure', 6, 3);
INSERT INTO public.tag_link VALUES (299, 'procedure', 7, 2);
INSERT INTO public.tag_link VALUES (310, 'procedure', 1, 1);
INSERT INTO public.tag_link VALUES (311, 'procedure', 6, 13);
INSERT INTO public.tag_link VALUES (312, 'procedure', 5, 2);
INSERT INTO public.tag_link VALUES (313, 'procedure', 8, 2);
INSERT INTO public.tag_link VALUES (314, 'procedure', 3, 3);
INSERT INTO public.tag_link VALUES (315, 'procedure', 3, 13);
INSERT INTO public.tag_link VALUES (316, 'procedure', 2, 2);
INSERT INTO public.tag_link VALUES (317, 'procedure', 2, 3);
INSERT INTO public.tag_link VALUES (318, 'examlist', 118, 8);
INSERT INTO public.tag_link VALUES (319, 'examlist', 118, 10);
INSERT INTO public.tag_link VALUES (321, 'examlist', 102, 7);
INSERT INTO public.tag_link VALUES (322, 'examlist', 102, 3);
INSERT INTO public.tag_link VALUES (324, 'examlist', 102, 16);
INSERT INTO public.tag_link VALUES (325, 'examlist', 102, 5);
INSERT INTO public.tag_link VALUES (332, 'examlist', 137, 13);
INSERT INTO public.tag_link VALUES (333, 'examlist', 137, 10);
INSERT INTO public.tag_link VALUES (334, 'examlist', 136, 13);
INSERT INTO public.tag_link VALUES (335, 'procedure', 22, 1);
INSERT INTO public.tag_link VALUES (339, 'examlist', 102, 1);
INSERT INTO public.tag_link VALUES (340, 'examlist', 140, 1);
INSERT INTO public.tag_link VALUES (341, 'examlist', 141, 11);
INSERT INTO public.tag_link VALUES (342, 'examlist', 144, 2);
INSERT INTO public.tag_link VALUES (343, 'examlist', 144, 16);
INSERT INTO public.tag_link VALUES (344, 'examlist', 118, 13);
INSERT INTO public.tag_link VALUES (345, 'examlist', 118, 12);
INSERT INTO public.tag_link VALUES (346, 'examlist', 115, 15);
INSERT INTO public.tag_link VALUES (347, 'procedure', 1, 3);
INSERT INTO public.tag_link VALUES (348, 'procedure', 24, 3);
INSERT INTO public.tag_link VALUES (349, 'procedure', 24, 1);
INSERT INTO public.tag_link VALUES (350, 'procedure', 25, 3);
INSERT INTO public.tag_link VALUES (351, 'procedure', 25, 1);
INSERT INTO public.tag_link VALUES (352, 'procedure', 26, 12);
INSERT INTO public.tag_link VALUES (353, 'procedure', 26, 11);
INSERT INTO public.tag_link VALUES (354, 'procedure', 27, 2);
INSERT INTO public.tag_link VALUES (355, 'procedure', 27, 1);
INSERT INTO public.tag_link VALUES (356, 'procedure', 28, 1);
INSERT INTO public.tag_link VALUES (357, 'procedure', 29, 11);
INSERT INTO public.tag_link VALUES (358, 'examlist', 126, 12);
INSERT INTO public.tag_link VALUES (359, 'examlist', 143, 3);
INSERT INTO public.tag_link VALUES (360, 'examlist', 143, 12);
INSERT INTO public.tag_link VALUES (361, 'procedure', 30, 1);
INSERT INTO public.tag_link VALUES (362, 'procedure', 31, 1);
INSERT INTO public.tag_link VALUES (363, 'procedure', 32, 1);
INSERT INTO public.tag_link VALUES (364, 'procedure', 33, 1);
INSERT INTO public.tag_link VALUES (365, 'procedure', 34, 1);
INSERT INTO public.tag_link VALUES (366, 'procedure', 35, 1);
INSERT INTO public.tag_link VALUES (367, 'procedure', 36, 1);
INSERT INTO public.tag_link VALUES (368, 'procedure', 37, 1);
INSERT INTO public.tag_link VALUES (369, 'procedure', 38, 11);
INSERT INTO public.tag_link VALUES (370, 'procedure', 39, 1);
INSERT INTO public.tag_link VALUES (371, 'procedure', 40, 1);
INSERT INTO public.tag_link VALUES (372, 'procedure', 41, 16);
INSERT INTO public.tag_link VALUES (373, 'procedure', 42, 1);
INSERT INTO public.tag_link VALUES (374, 'procedure', 1, 16);
INSERT INTO public.tag_link VALUES (375, 'procedure', 1, 11);
INSERT INTO public.tag_link VALUES (376, 'procedure', 43, 1);
INSERT INTO public.tag_link VALUES (377, 'procedure', 43, 11);
INSERT INTO public.tag_link VALUES (379, 'procedure', 22, 3);


--
-- TOC entry 5733 (class 0 OID 29856)
-- Dependencies: 354
-- Data for Name: task; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 5735 (class 0 OID 29868)
-- Dependencies: 356
-- Data for Name: task_link; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 5737 (class 0 OID 29875)
-- Dependencies: 358
-- Data for Name: task_master; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 5739 (class 0 OID 29891)
-- Dependencies: 360
-- Data for Name: task_master_link; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 5722 (class 0 OID 25599)
-- Dependencies: 343
-- Data for Name: xusercfg; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.xusercfg VALUES (1, '{"IdcPDPatientListDT": {"Ident": "IdcPDPatientListDT", "Columns": [{"Data": "pat_id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "id", "Width": "25%", "Visible": true, "Position": 1}, {"Data": "name", "Width": "36.25%", "Visible": true, "Position": 2}, {"Data": "birthdate", "Width": "21.25%", "Visible": true, "Position": 3}, {"Data": "age", "Width": "16.25%", "Visible": true, "Position": 4}, {"Data": "accessionnumber", "Width": "16.25%", "Visible": true, "Position": 5}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcPatientDosimetryDT": {"Ident": "IdcPatientDosimetryDT", "Columns": [{"Data": "stu_id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "modalitytitle", "Width": "12.5%", "Visible": true, "Position": 1}, {"Data": "date", "Width": "12.5%", "Visible": true, "Position": 2}, {"Data": "groupname", "Width": "21%", "Visible": false, "Position": 3}, {"Data": "accessionnumber", "Width": "16.25%", "Visible": true, "Position": 4}, {"Data": "description", "Width": "37.5%", "Visible": true, "Position": 5}], "Properties": {"RowHeight": 40, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}}', 110);
INSERT INTO public.xusercfg VALUES (16, '{"IdcTaskDT": {"Ident": "IdcTaskDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "actionlinkid", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "personincharge", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "shortcut_pin", "Width": "40px", "Visible": false, "Position": 5}, {"Data": "begdate", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "Link", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "deadline", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "closeddate", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "status_name", "Width": "10%", "Visible": true, "Position": 10}, {"Data": "department", "Width": "15%", "Visible": true, "Position": 11}, {"Data": "origine", "Width": "15%", "Visible": true, "Position": 12}, {"Data": "description", "Width": "15%", "Visible": true, "Position": 13}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcLDDocumentDT_DT": {"Ident": "IdcLDDocumentDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 40, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcExamsListWorkingDT": {"Ident": "IdcExamsListWorkingDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "nameid", "Width": "113px", "Visible": true, "Position": 1}, {"Data": "modality", "Width": "20%", "Visible": true, "Position": 2}, {"Data": "description", "Width": "80%", "Visible": true, "Position": 3}, {"Data": "staff_member_id", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "read_doc_at", "Width": "50px", "Visible": false, "Position": 5}, {"Data": "read_otherdoc_at", "Width": "50px", "Visible": false, "Position": 6}, {"Data": "riskv", "Width": "40px", "Visible": false, "Position": 7}, {"Data": "taglist", "Width": "40px", "Visible": false, "Position": 8}, {"Data": "doc_id", "Width": "40px", "Visible": false, "Position": 9}, {"Data": "doc_otherdoc_id", "Width": "40px", "Visible": false, "Position": 10}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcProcedureWorkingDT": {"Ident": "IdcProcedureWorkingDT", "Columns": [{"Data": "doc_id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "doc_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "name", "Width": "45%", "Visible": true, "Position": 2}, {"Data": "comment", "Width": "65%", "Visible": true, "Position": 3}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}}', 110);
INSERT INTO public.xusercfg VALUES (1, '{"IdcPatientDosimetrySplitter1_2": {"Ident": "IdcPatientDosimetrySplitter1_2", "Properties": {"Ratio": 0.4088098918083462}}}', 100);
INSERT INTO public.xusercfg VALUES (13, '{"IdcTaskDT": {"Ident": "IdcTaskDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "actionlinkid", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "personincharge", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "shortcut_pin", "Width": "40px", "Visible": false, "Position": 5}, {"Data": "begdate", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "Link", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "deadline", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "closeddate", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "status_name", "Width": "10%", "Visible": true, "Position": 10}, {"Data": "department", "Width": "15%", "Visible": true, "Position": 11}, {"Data": "origine", "Width": "15%", "Visible": true, "Position": 12}, {"Data": "description", "Width": "15%", "Visible": true, "Position": 13}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcExamsListWorkingDT": {"Ident": "IdcExamsListWorkingDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "nameid", "Width": "82px", "Visible": true, "Position": 1}, {"Data": "modality", "Width": "20%", "Visible": true, "Position": 2}, {"Data": "description", "Width": "80%", "Visible": true, "Position": 3}, {"Data": "riskv", "Width": "40px", "Visible": false, "Position": 4}, {"Data": "taglist", "Width": "40px", "Visible": false, "Position": 5}, {"Data": "doc_id", "Width": "40px", "Visible": false, "Position": 6}, {"Data": "doc_otherdoc_id", "Width": "40px", "Visible": false, "Position": 7}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcProcedureWorkingDT": {"Ident": "IdcProcedureWorkingDT", "Columns": [{"Data": "doc_id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "doc_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "name", "Width": "45%", "Visible": true, "Position": 2}, {"Data": "comment", "Width": "65%", "Visible": true, "Position": 3}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcLegalDocumentWorkingDT": {"Ident": "IdcLegalDocumentWorkingDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "35%", "Visible": true, "Position": 1}, {"Data": "type", "Width": "20%", "Visible": true, "Position": 2}, {"Data": "comment", "Width": "45%", "Visible": true, "Position": 3}], "Properties": {"RowHeight": 30, "RowFontSize": 11, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}}', 110);
INSERT INTO public.xusercfg VALUES (0, '{"IdcTaskDT": {"Ident": "IdcTaskDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "actionlinkid", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "personincharge", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "shortcut_pin", "Width": "40px", "Visible": false, "Position": 5}, {"Data": "begdate", "Width": "8.714285714285715%", "Visible": true, "Position": 6}, {"Data": "Link", "Width": "12.142857142857144%", "Visible": false, "Position": 7}, {"Data": "deadline", "Width": "8.285714285714286%", "Visible": true, "Position": 8}, {"Data": "closeddate", "Width": "7.857142857142858%", "Visible": true, "Position": 9}, {"Data": "status_name", "Width": "8.428571428571429%", "Visible": true, "Position": 10}, {"Data": "department", "Width": "13%", "Visible": true, "Position": 11}, {"Data": "origine", "Width": "17.14285714285714%", "Visible": true, "Position": 12}, {"Data": "description", "Width": "17.14285714285714%", "Visible": true, "Position": 13}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcAuditDT": {"Ident": "IdcAuditDT", "Columns": [{"Data": "afcnsend.id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "inst_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "audit_type", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "status", "Width": "11%", "Visible": true, "Position": 6}, {"Data": "institution", "Width": "17.875%", "Visible": true, "Position": 7}, {"Data": "department", "Width": "12.75%", "Visible": true, "Position": 8}, {"Data": "title", "Width": "15.25%", "Visible": true, "Position": 9}, {"Data": "origine", "Width": "12.75%", "Visible": true, "Position": 10}, {"Data": "comment", "Width": "12.75%", "Visible": true, "Position": 11}, {"Data": "start_date", "Width": "12.75%", "Visible": true, "Position": 12}, {"Data": "end_date", "Width": "12.75%", "Visible": true, "Position": 13}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSurveyDT": {"Ident": "IdcSurveyDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "type", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "status", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "status_name", "Width": "10%", "Visible": true, "Position": 3}, {"Data": "survey_type", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "begindate", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "enddate", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "title", "Width": "20%", "Visible": true, "Position": 7}, {"Data": "description", "Width": "40%", "Visible": false, "Position": 8}, {"Data": "comment", "Width": "40%", "Visible": false, "Position": 9}, {"Data": "conclusion", "Width": "40%", "Visible": false, "Position": 10}, {"Data": "listofactiondescription", "Width": "50px", "Visible": false, "Position": 11}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcIncidentDT": {"Ident": "IdcIncidentDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "severity", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "statuscomment", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "reportdate", "Width": "9.5%", "Visible": true, "Position": 5}, {"Data": "closeddate", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "status_name", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "department", "Width": "15%", "Visible": true, "Position": 8}, {"Data": "reporterby", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "title", "Width": "15%", "Visible": true, "Position": 10}, {"Data": "comment", "Width": "15%", "Visible": true, "Position": 11}, {"Data": "listofactiondescription", "Width": "20px", "Visible": false, "Position": 12}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDosimetryDT": {"Ident": "IdcDosimetryDT", "Columns": [{"Data": "afcnsend.id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "inst_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "dev_id", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "senddate", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "status", "Width": "13.142857142857142%", "Visible": true, "Position": 6}, {"Data": "institution", "Width": "13.428571428571429%", "Visible": true, "Position": 7}, {"Data": "department", "Width": "13.285714285714288%", "Visible": true, "Position": 8}, {"Data": "device", "Width": "8.285714285714286%", "Visible": true, "Position": 9}, {"Data": "title", "Width": "13.285714285714288%", "Visible": true, "Position": 10}, {"Data": "sender", "Width": "13.285714285714288%", "Visible": false, "Position": 11}, {"Data": "comment", "Width": "13.285714285714288%", "Visible": false, "Position": 12}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcExamsListDT": {"Ident": "IdcExamsListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "nameid", "Width": "106px", "Visible": true, "Position": 1}, {"Data": "modality", "Width": "20%", "Visible": true, "Position": 2}, {"Data": "description", "Width": "80%", "Visible": true, "Position": 3}, {"Data": "riskv", "Width": "40px", "Visible": false, "Position": 4}, {"Data": "taglist", "Width": "40px", "Visible": false, "Position": 5}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcProcedureDT": {"Ident": "IdcProcedureDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "type", "Width": "40px", "Visible": false, "Position": 1}, {"Data": "name_fr", "Width": "23%", "Visible": true, "Position": 2}, {"Data": "comment", "Width": "38.5%", "Visible": true, "Position": 3}, {"Data": "alltagidallow", "Width": "38.5%", "Visible": false, "Position": 4}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcStaffListDT": {"Ident": "IdcStaffListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "fullname", "Width": "40%", "Visible": true, "Position": 1}, {"Data": "job", "Width": "60%", "Visible": true, "Position": 2}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDeviceListDT": {"Ident": "IdcDeviceListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "ris_name", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "pacs_name", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "dacs_name", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "type", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "name", "Width": "15%", "Visible": true, "Position": 5}, {"Data": "brand", "Width": "15%", "Visible": true, "Position": 6}, {"Data": "model", "Width": "15%", "Visible": true, "Position": 7}, {"Data": "serialnumber", "Width": "15%", "Visible": true, "Position": 8}, {"Data": "modalitytype", "Width": "60px", "Visible": false, "Position": 9}, {"Data": "typename", "Width": "15%", "Visible": true, "Position": 10}, {"Data": "institution_name", "Width": "40%", "Visible": true, "Position": 11}, {"Data": "depname", "Width": "40%", "Visible": true, "Position": 12}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDocReadingDT": {"Ident": "IdcDocReadingDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "fullname", "Width": "31.5%", "Visible": true, "Position": 1}, {"Data": "job", "Width": "21.5%", "Visible": true, "Position": 2}, {"Data": "institution", "Width": "21.5%", "Visible": true, "Position": 3}, {"Data": "department", "Width": "21.5%", "Visible": true, "Position": 4}, {"Data": "read_at_fmt", "Width": "14%", "Visible": true, "Position": 5}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcSettingsTagDT": {"Ident": "IdcSettingsTagDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 1}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSurveyFieldDT": {"Ident": "IdcSurveyFieldDT", "Columns": [{"Data": "shortcut", "Width": "50px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "type", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "type_name", "Width": "20%", "Visible": true, "Position": 3}, {"Data": "content", "Width": "80%", "Visible": true, "Position": 4}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcLDDocumentDT_DT": {"Ident": "IdcLDDocumentDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "12.222222222222221%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "12.222222222222221%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "12.222222222222221%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "6%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "12.222222222222221%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "6.111111111111111%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "6%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "12.222222222222221%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "12.222222222222221%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "6.555555555555555%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 40, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcLegalDocumentDT": {"Ident": "IdcLegalDocumentDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "32.5%", "Visible": true, "Position": 1}, {"Data": "type", "Width": "22.5%", "Visible": true, "Position": 2}, {"Data": "comment", "Width": "45%", "Visible": true, "Position": 3}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSurveyResponseDT": {"Ident": "IdcSurveyResponseDT", "Columns": [{"Data": "id", "Width": "10%", "Visible": true, "Position": 0}, {"Data": "rdate", "Width": "90%", "Visible": true, "Position": 1}], "Properties": {"RowHeight": 25, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcAudtiDocListDT_DT": {"Ident": "IdcAudtiDocListDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcInstDocInstListDT": {"Ident": "IdcInstDocInstListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 1}], "Properties": {"RowHeight": 40, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcInstDocumentDT_DT": {"Ident": "IdcInstDocumentDT_DT", "Columns": [{"Data": "shortcut", "Width": "140px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "status_id", "Width": "10%", "Visible": false, "Position": 4}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "author", "Width": "10%", "Visible": false, "Position": 9}, {"Data": "status_name", "Width": "10%", "Visible": true, "Position": 10}, {"Data": "comment", "Width": "10%", "Visible": false, "Position": 11}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 12}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcProcDocumentDT_DT": {"Ident": "IdcProcDocumentDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsJobRoleDT": {"Ident": "IdcSettingsJobRoleDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "scope_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 2}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsWarningDT": {"Ident": "IdcSettingsWarningDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "sex_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "age_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "title", "Width": "40%", "Visible": true, "Position": 3}, {"Data": "description", "Width": "60%", "Visible": true, "Position": 4}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsDocumentDT": {"Ident": "IdcSettingsDocumentDT", "Columns": [{"Data": "type", "Width": "100%", "Visible": true, "Position": 0}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDosimetryFilesDT_DT": {"Ident": "IdcDosimetryFilesDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 8}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsExamIdentDT": {"Ident": "IdcSettingsExamIdentDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "30%", "Visible": true, "Position": 1}, {"Data": "description", "Width": "70%", "Visible": true, "Position": 2}], "Properties": {"RowHeight": 25, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsExamsListDT": {"Ident": "IdcSettingsExamsListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "nameid", "Width": "30%", "Visible": true, "Position": 1}, {"Data": "modality", "Width": "20%", "Visible": true, "Position": 2}, {"Data": "description", "Width": "50%", "Visible": true, "Position": 3}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsLoginRoleDT": {"Ident": "IdcSettingsLoginRoleDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "scope_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 2}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcInstDepDocumentDT_DT": {"Ident": "IdcInstDepDocumentDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcStaffFormationListDT": {"Ident": "IdcStaffFormationListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "status_name", "Width": "100px", "Visible": true, "Position": 2}, {"Data": "planned_date", "Width": "100px", "Visible": true, "Position": 3}, {"Data": "formation_date", "Width": "100px", "Visible": true, "Position": 4}, {"Data": "title", "Width": "100px", "Visible": true, "Position": 5}, {"Data": "type", "Width": "100px", "Visible": true, "Position": 6}, {"Data": "comment", "Width": "100px", "Visible": true, "Position": 7}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcExamsListDocListDT_DT": {"Ident": "IdcExamsListDocListDT_DT", "Columns": [{"Data": "shortcut", "Width": "140px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10.3%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10.3%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10.3%", "Visible": false, "Position": 3}, {"Data": "name", "Width": "10.3%", "Visible": true, "Position": 4}, {"Data": "revision", "Width": "7%", "Visible": true, "Position": 5}, {"Data": "label", "Width": "10.3%", "Visible": true, "Position": 6}, {"Data": "date", "Width": "10.3%", "Visible": true, "Position": 7}, {"Data": "author", "Width": "10.3%", "Visible": false, "Position": 8}, {"Data": "status_name", "Width": "10.3%", "Visible": true, "Position": 9}, {"Data": "comment", "Width": "10.3%", "Visible": false, "Position": 10}, {"Data": "valid_until_date", "Width": "10.3%", "Visible": true, "Position": 11}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "normal"}}, "IdcSettingsInstitutionDT": {"Ident": "IdcSettingsInstitutionDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 1}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsStaffMemberDT": {"Ident": "IdcSettingsStaffMemberDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "lastname", "Width": "50%", "Visible": true, "Position": 1}, {"Data": "firstname", "Width": "50%", "Visible": true, "Position": 2}, {"Data": "login", "Width": "50%", "Visible": false, "Position": 3}, {"Data": "password", "Width": "50%", "Visible": false, "Position": 4}, {"Data": "login_role_id", "Width": "50%", "Visible": false, "Position": 5}, {"Data": "active", "Width": "50%", "Visible": false, "Position": 6}, {"Data": "ris_name", "Width": "50%", "Visible": false, "Position": 7}, {"Data": "pacs_name", "Width": "50%", "Visible": false, "Position": 8}, {"Data": "dacs_name", "Width": "50%", "Visible": false, "Position": 9}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDeviceInspectionListDT": {"Ident": "IdcDeviceInspectionListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "result", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "comment", "Width": "50px", "Visible": false, "Position": 3}, {"Data": "listofactiondescription", "Width": "50px", "Visible": false, "Position": 4}, {"Data": "status_name", "Width": "16%", "Visible": true, "Position": 5}, {"Data": "planned_date", "Width": "18.5%", "Visible": true, "Position": 6}, {"Data": "inspection_date", "Width": "18.5%", "Visible": true, "Position": 7}, {"Data": "result_name", "Width": "18.5%", "Visible": true, "Position": 8}, {"Data": "type", "Width": "28.5%", "Visible": true, "Position": 9}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDeviceMaintenanceListDT": {"Ident": "IdcDeviceMaintenanceListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "status_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "comment", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "status_name", "Width": "22%", "Visible": true, "Position": 3}, {"Data": "planned_date", "Width": "26%", "Visible": true, "Position": 4}, {"Data": "maintenance_date", "Width": "26%", "Visible": true, "Position": 5}, {"Data": "type", "Width": "26%", "Visible": true, "Position": 6}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcInstDocDepartmentListDT": {"Ident": "IdcInstDocDepartmentListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 1}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsInsDepartmentDT": {"Ident": "IdcSettingsInsDepartmentDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "inst_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "name", "Width": "100%", "Visible": true, "Position": 2}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDeviceInstallationListDT": {"Ident": "IdcDeviceInstallationListDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "department", "Width": "25%", "Visible": true, "Position": 2}, {"Data": "installdate", "Width": "14%", "Visible": true, "Position": 3}, {"Data": "removeddate", "Width": "14%", "Visible": true, "Position": 4}, {"Data": "installedby", "Width": "24%", "Visible": true, "Position": 5}, {"Data": "inchargeof", "Width": "24%", "Visible": false, "Position": 6}, {"Data": "comment", "Width": "49%", "Visible": false, "Position": 7}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsStaffMemberJobDT": {"Ident": "IdcSettingsStaffMemberJobDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "staff_role_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "dep_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "institutionname", "Width": "49.25%", "Visible": true, "Position": 3}, {"Data": "departmentname", "Width": "49.25%", "Visible": true, "Position": 4}, {"Data": "rolename", "Width": "49.25%", "Visible": true, "Position": 5}, {"Data": "begdate", "Width": "33%", "Visible": true, "Position": 6}, {"Data": "enddate", "Width": "29.25%", "Visible": true, "Position": 7}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsExamsLinkedListDT": {"Ident": "IdcSettingsExamsLinkedListDT", "Columns": [{"Data": "", "Width": "60px", "Visible": true, "Position": 0}, {"Data": "exam_id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "examident_id", "Width": "50px", "Visible": false, "Position": 2}, {"Data": "name", "Width": "30%", "Visible": true, "Position": 3}, {"Data": "description", "Width": "70%", "Visible": true, "Position": 4}], "Properties": {"RowHeight": 25, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcStaffFormationDocListDT_DT": {"Ident": "IdcStaffFormationDocListDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDeviceInspectionDocListDT_DT": {"Ident": "IdcDeviceInspectionDocListDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 20, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsExamsNotLinkedListDT": {"Ident": "IdcSettingsExamsNotLinkedListDT", "Columns": [{"Data": "", "Width": "60px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "name", "Width": "30%", "Visible": true, "Position": 2}, {"Data": "description", "Width": "70%", "Visible": true, "Position": 3}], "Properties": {"RowHeight": 25, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcDeviceDescriptionDocListDT_DT": {"Ident": "IdcDeviceDescriptionDocListDT_DT", "Columns": [{"Data": "shortcut", "Width": "110px", "Visible": true, "Position": 0}, {"Data": "id", "Width": "10%", "Visible": false, "Position": 1}, {"Data": "doc_master_id", "Width": "10%", "Visible": false, "Position": 2}, {"Data": "doc_master_groupid", "Width": "10%", "Visible": false, "Position": 3}, {"Data": "revision", "Width": "10%", "Visible": true, "Position": 4}, {"Data": "label", "Width": "10%", "Visible": true, "Position": 5}, {"Data": "date", "Width": "10%", "Visible": true, "Position": 6}, {"Data": "author", "Width": "10%", "Visible": true, "Position": 7}, {"Data": "name", "Width": "10%", "Visible": true, "Position": 8}, {"Data": "comment", "Width": "10%", "Visible": true, "Position": 9}, {"Data": "valid_until_date", "Width": "10%", "Visible": true, "Position": 10}], "Properties": {"RowHeight": 25, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}, "IdcSettingsLoginRolePermissionDT": {"Ident": "IdcSettingsLoginRolePermissionDT", "Columns": [{"Data": "id", "Width": "50px", "Visible": false, "Position": 0}, {"Data": "working_view_exist", "Width": "50px", "Visible": false, "Position": 1}, {"Data": "ptype", "Width": "15%", "Visible": true, "Position": 2}, {"Data": "description", "Width": "55%", "Visible": true, "Position": 3}, {"Data": "value", "Width": "15%", "Visible": true, "Position": 4}, {"Data": "working_view", "Width": "15%", "Visible": true, "Position": 5}], "Properties": {"RowHeight": 30, "RowFontSize": 12, "HeaderFontSize": 14, "HeaderFontWeight": "bold"}}}', 110);
INSERT INTO public.xusercfg VALUES (16, '{"IdcSLRSplitter1_2": {"Ident": "IdcSLRSplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcTaskSplitter1_2": {"Ident": "IdcTaskSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcSurveySplitter1_2": {"Ident": "IdcSurveySplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcSurveySplitter3_4": {"Ident": "IdcSurveySplitter3_4", "Properties": {"Ratio": 0.43973214285714285}}, "IdcSurveySplitter5_6": {"Ident": "IdcSurveySplitter5_6", "Properties": {"Ratio": 0.6}}, "IdcSurveySplitter7_8": {"Ident": "IdcSurveySplitter7_8", "Properties": {"Ratio": 0.3}}, "IdcExamsListSplitter1_2": {"Ident": "IdcExamsListSplitter1_2", "Properties": {"Ratio": 0.30427763505954053}}, "IdcExamsListSplitter3_4": {"Ident": "IdcExamsListSplitter3_4", "Properties": {"Ratio": 0.42395498392282954}}, "IdcExamsListSplitter5_6": {"Ident": "IdcExamsListSplitter5_6", "Properties": {"Ratio": 0.727972027972028}}, "IdcProcedureSplitter1_2": {"Ident": "IdcProcedureSplitter1_2", "Properties": {"Ratio": 0.4711561306496346}}, "IdcExamsListWorkingSplitter1_2": {"Ident": "IdcExamsListWorkingSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcExamsListWorkingSplitter2_3": {"Ident": "IdcExamsListWorkingSplitter2_3", "Properties": {"Ratio": 0.5}}, "IdcProcedureWorkingSplitter1_2": {"Ident": "IdcProcedureWorkingSplitter1_2", "Properties": {"Ratio": 0.472708488656939}}, "IdcLegalDocumentWorkingSplitter1_2": {"Ident": "IdcLegalDocumentWorkingSplitter1_2", "Properties": {"Ratio": 0.4668460493052785}}}', 100);
INSERT INTO public.xusercfg VALUES (0, '{"IdcBQSplitter1_2": {"Ident": "IdcBQSplitter1_2", "Properties": {"Ratio": 0.3}}, "IdcSDSplitter1_2": {"Ident": "IdcSDSplitter1_2", "Properties": {"Ratio": 0.41311394441931154}}, "IdcSISplitter1_2": {"Ident": "IdcSISplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcSISplitter3_4": {"Ident": "IdcSISplitter3_4", "Properties": {"Ratio": 0.5999999999999999}}, "IdcSTSplitter1_2": {"Ident": "IdcSTSplitter1_2", "Properties": {"Ratio": 0.39999999999999997}}, "IdcSWSplitter1_2": {"Ident": "IdcSWSplitter1_2", "Properties": {"Ratio": 0.39999999999999997}}, "IdcSEISplitter1_2": {"Ident": "IdcSEISplitter1_2", "Properties": {"Ratio": 0.39999999999999997}}, "IdcSELSplitter1_2": {"Ident": "IdcSELSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcSELSplitter3_4": {"Ident": "IdcSELSplitter3_4", "Properties": {"Ratio": 0.5}}, "IdcSJRSplitter1_2": {"Ident": "IdcSJRSplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcSLRSplitter1_2": {"Ident": "IdcSLRSplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcSSMSplitter1_2": {"Ident": "IdcSSMSplitter1_2", "Properties": {"Ratio": 0.31993881129193624}}, "IdcSSMSplitter3_4": {"Ident": "IdcSSMSplitter3_4", "Properties": {"Ratio": 0.6010809626219136}}, "IdcTaskSplitter1_2": {"Ident": "IdcTaskSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcAuditSplitter1_2": {"Ident": "IdcAuditSplitter1_2", "Properties": {"Ratio": 0.43485853282183623}}, "IdcAuditSplitter3_4": {"Ident": "IdcAuditSplitter3_4", "Properties": {"Ratio": 0.4}}, "IdcStaffSplitter1_2": {"Ident": "IdcStaffSplitter1_2", "Properties": {"Ratio": 0.29301811331676053}}, "IdcStaffSplitter3_4": {"Ident": "IdcStaffSplitter3_4", "Properties": {"Ratio": 0.4}}, "IdcStaffSplitter5_6": {"Ident": "IdcStaffSplitter5_6", "Properties": {"Ratio": 0.6}}, "IdcDeviceSplitter1_2": {"Ident": "IdcDeviceSplitter1_2", "Properties": {"Ratio": 0.4605710237957896}}, "IdcSurveySplitter1_2": {"Ident": "IdcSurveySplitter1_2", "Properties": {"Ratio": 0.4233055885850178}}, "IdcSurveySplitter3_4": {"Ident": "IdcSurveySplitter3_4", "Properties": {"Ratio": 0.5324695730247406}}, "IdcSurveySplitter5_6": {"Ident": "IdcSurveySplitter5_6", "Properties": {"Ratio": 0.6}}, "IdcSurveySplitter7_8": {"Ident": "IdcSurveySplitter7_8", "Properties": {"Ratio": 0.3}}, "IdcInstDocSplitter1_2": {"Ident": "IdcInstDocSplitter1_2", "Properties": {"Ratio": 0.43953077146639924}}, "IdcInstDocSplitter3_4": {"Ident": "IdcInstDocSplitter3_4", "Properties": {"Ratio": 0.3517401547998709}}, "IdcInstDocSplitter5_6": {"Ident": "IdcInstDocSplitter5_6", "Properties": {"Ratio": 0.5}}, "IdcIncidentSplitter1_2": {"Ident": "IdcIncidentSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcIncidentSplitter3_4": {"Ident": "IdcIncidentSplitter3_4", "Properties": {"Ratio": 0.6}}, "IdcDosimetrySplitter1_2": {"Ident": "IdcDosimetrySplitter1_2", "Properties": {"Ratio": 0.614764644860582}}, "IdcDosimetrySplitter3_4": {"Ident": "IdcDosimetrySplitter3_4", "Properties": {"Ratio": 0.6497854077253219}}, "IdcExamsListSplitter1_2": {"Ident": "IdcExamsListSplitter1_2", "Properties": {"Ratio": 0.2999999999999999}}, "IdcExamsListSplitter3_4": {"Ident": "IdcExamsListSplitter3_4", "Properties": {"Ratio": 0.35}}, "IdcExamsListSplitter5_6": {"Ident": "IdcExamsListSplitter5_6", "Properties": {"Ratio": 0.5}}, "IdcProcedureSplitter1_2": {"Ident": "IdcProcedureSplitter1_2", "Properties": {"Ratio": 0.4711561306496345}}, "IdcTaskMasterSplitter1_2": {"Ident": "IdcTaskMasterSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcLegalDocumentSplitter1_2": {"Ident": "IdcLegalDocumentSplitter1_2", "Properties": {"Ratio": 0.35092385529493025}}, "IdcDeviceInspectionSplitter1_2": {"Ident": "IdcDeviceInspectionSplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcDeviceInspectionSplitter3_4": {"Ident": "IdcDeviceInspectionSplitter3_4", "Properties": {"Ratio": 0.6}}, "IdcExamsListWorkingSplitter1_2": {"Ident": "IdcExamsListWorkingSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcExamsListWorkingSplitter2_3": {"Ident": "IdcExamsListWorkingSplitter2_3", "Properties": {"Ratio": 0.6674364896073903}}, "IdcProcedureWorkingSplitter1_2": {"Ident": "IdcProcedureWorkingSplitter1_2", "Properties": {"Ratio": 0.42292682926829267}}, "IdcDeviceMaintenanceSplitter1_2": {"Ident": "IdcDeviceMaintenanceSplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcDeviceMaintenanceSplitter3_4": {"Ident": "IdcDeviceMaintenanceSplitter3_4", "Properties": {"Ratio": 0.6}}, "IdcDeviceInstallationSplitter1_2": {"Ident": "IdcDeviceInstallationSplitter1_2", "Properties": {"Ratio": 0.4}}, "IdcDeviceInstallationSplitter3_4": {"Ident": "IdcDeviceInstallationSplitter3_4", "Properties": {"Ratio": 0.6}}, "IdcLegalDocumentWorkingSplitter1_2": {"Ident": "IdcLegalDocumentWorkingSplitter1_2", "Properties": {"Ratio": 0.4668460493052785}}}', 100);
INSERT INTO public.xusercfg VALUES (13, '{"IdcSDSplitter1_2": {"Ident": "IdcSDSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcSSMSplitter1_2": {"Ident": "IdcSSMSplitter1_2", "Properties": {"Ratio": 0.25}}, "IdcSSMSplitter3_4": {"Ident": "IdcSSMSplitter3_4", "Properties": {"Ratio": 0.6000000000000001}}, "IdcTaskSplitter1_2": {"Ident": "IdcTaskSplitter1_2", "Properties": {"Ratio": 0.5}}, "IdcInstDocSplitter1_2": {"Ident": "IdcInstDocSplitter1_2", "Properties": {"Ratio": 0.3}}, "IdcInstDocSplitter3_4": {"Ident": "IdcInstDocSplitter3_4", "Properties": {"Ratio": 0.35}}, "IdcInstDocSplitter5_6": {"Ident": "IdcInstDocSplitter5_6", "Properties": {"Ratio": 0.5}}, "IdcExamsListSplitter1_2": {"Ident": "IdcExamsListSplitter1_2", "Properties": {"Ratio": 0.29999999999999993}}, "IdcExamsListSplitter3_4": {"Ident": "IdcExamsListSplitter3_4", "Properties": {"Ratio": 0.35}}, "IdcExamsListSplitter5_6": {"Ident": "IdcExamsListSplitter5_6", "Properties": {"Ratio": 0.5}}, "IdcProcedureSplitter1_2": {"Ident": "IdcProcedureSplitter1_2", "Properties": {"Ratio": 0.4378624326710377}}}', 100);


--
-- TOC entry 5723 (class 0 OID 25604)
-- Dependencies: 344
-- Data for Name: xusercfgparameter; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.xusercfgparameter VALUES (110, 4, 5, 11000, 'DataTableConfiguration', 'DataTableConfiguration', 'DataTableConfiguration', '{}');
INSERT INTO public.xusercfgparameter VALUES (100, 4, 5, 10000, 'SplitterConfiguration', 'SplitterConfiguration', 'SplitterConfiguration', NULL);


--
-- TOC entry 5804 (class 0 OID 0)
-- Dependencies: 217
-- Name: action_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_id_seq', 9, true);


--
-- TOC entry 5805 (class 0 OID 0)
-- Dependencies: 219
-- Name: action_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.action_link_id_seq', 36, true);


--
-- TOC entry 5806 (class 0 OID 0)
-- Dependencies: 221
-- Name: afcnsend_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.afcnsend_id_seq', 16, true);


--
-- TOC entry 5807 (class 0 OID 0)
-- Dependencies: 223
-- Name: agelist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.agelist_id_seq', 1, false);


--
-- TOC entry 5808 (class 0 OID 0)
-- Dependencies: 225
-- Name: audit_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.audit_id_seq', 20, true);


--
-- TOC entry 5809 (class 0 OID 0)
-- Dependencies: 227
-- Name: audit_record_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.audit_record_id_seq', 426, true);


--
-- TOC entry 5810 (class 0 OID 0)
-- Dependencies: 229
-- Name: audit_recordprocedure_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.audit_recordprocedure_id_seq', 112, true);


--
-- TOC entry 5811 (class 0 OID 0)
-- Dependencies: 231
-- Name: audit_subrecord_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.audit_subrecord_id_seq', 372, true);


--
-- TOC entry 5812 (class 0 OID 0)
-- Dependencies: 233
-- Name: audit_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.audit_type_id_seq', 3, true);


--
-- TOC entry 5813 (class 0 OID 0)
-- Dependencies: 348
-- Name: civilitylist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.civilitylist_id_seq', 1, false);


--
-- TOC entry 5814 (class 0 OID 0)
-- Dependencies: 347
-- Name: default_read_needed_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.default_read_needed_id_seq', 214, true);


--
-- TOC entry 5815 (class 0 OID 0)
-- Dependencies: 235
-- Name: department_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.department_id_seq', 10, true);


--
-- TOC entry 5816 (class 0 OID 0)
-- Dependencies: 237
-- Name: device_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_id_seq', 26, true);


--
-- TOC entry 5817 (class 0 OID 0)
-- Dependencies: 239
-- Name: device_inspection_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_inspection_id_seq', 9, true);


--
-- TOC entry 5818 (class 0 OID 0)
-- Dependencies: 241
-- Name: device_installation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_installation_id_seq', 67, true);


--
-- TOC entry 5819 (class 0 OID 0)
-- Dependencies: 243
-- Name: device_maintenance_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_maintenance_id_seq', 7, true);


--
-- TOC entry 5820 (class 0 OID 0)
-- Dependencies: 245
-- Name: document_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.document_id_seq', 410, true);


--
-- TOC entry 5821 (class 0 OID 0)
-- Dependencies: 247
-- Name: document_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.document_link_id_seq', 388, true);


--
-- TOC entry 5822 (class 0 OID 0)
-- Dependencies: 249
-- Name: document_master_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.document_master_id_seq', 377, true);


--
-- TOC entry 5823 (class 0 OID 0)
-- Dependencies: 251
-- Name: documentstatus_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.documentstatus_id_seq', 470, true);


--
-- TOC entry 5824 (class 0 OID 0)
-- Dependencies: 350
-- Name: documenttypelist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.documenttypelist_id_seq', 1, false);


--
-- TOC entry 5825 (class 0 OID 0)
-- Dependencies: 254
-- Name: examident_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.examident_id_seq', 5, true);


--
-- TOC entry 5826 (class 0 OID 0)
-- Dependencies: 257
-- Name: examlist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.examlist_id_seq', 147, true);


--
-- TOC entry 5827 (class 0 OID 0)
-- Dependencies: 259
-- Name: examwarning_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.examwarning_id_seq', 11, true);


--
-- TOC entry 5828 (class 0 OID 0)
-- Dependencies: 262
-- Name: external_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.external_link_id_seq', 1, false);


--
-- TOC entry 5829 (class 0 OID 0)
-- Dependencies: 264
-- Name: external_src_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.external_src_id_seq', 1, false);


--
-- TOC entry 5830 (class 0 OID 0)
-- Dependencies: 266
-- Name: institution_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.institution_id_seq', 5, true);


--
-- TOC entry 5831 (class 0 OID 0)
-- Dependencies: 268
-- Name: legaldocument_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.legaldocument_id_seq', 28, true);


--
-- TOC entry 5832 (class 0 OID 0)
-- Dependencies: 272
-- Name: login_role_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.login_role_id_seq', 5, true);


--
-- TOC entry 5833 (class 0 OID 0)
-- Dependencies: 274
-- Name: login_role_permission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.login_role_permission_id_seq', 123, true);


--
-- TOC entry 5834 (class 0 OID 0)
-- Dependencies: 276
-- Name: procedure_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.procedure_id_seq', 43, true);


--
-- TOC entry 5835 (class 0 OID 0)
-- Dependencies: 278
-- Name: quaad_description_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.quaad_description_id_seq', 348, true);


--
-- TOC entry 5836 (class 0 OID 0)
-- Dependencies: 281
-- Name: quaad_point_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.quaad_point_id_seq', 338, true);


--
-- TOC entry 5837 (class 0 OID 0)
-- Dependencies: 283
-- Name: quaadpoint_tag_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.quaadpoint_tag_id_seq', 108, true);


--
-- TOC entry 5838 (class 0 OID 0)
-- Dependencies: 285
-- Name: quaadpoint_tag_name_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.quaadpoint_tag_name_id_seq', 112, true);


--
-- TOC entry 5839 (class 0 OID 0)
-- Dependencies: 288
-- Name: report_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.report_id_seq', 30, true);


--
-- TOC entry 5840 (class 0 OID 0)
-- Dependencies: 291
-- Name: sexlist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sexlist_id_seq', 1, false);


--
-- TOC entry 5841 (class 0 OID 0)
-- Dependencies: 293
-- Name: staff_formation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.staff_formation_id_seq', 5, true);


--
-- TOC entry 5842 (class 0 OID 0)
-- Dependencies: 295
-- Name: staff_job_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.staff_job_id_seq', 37, true);


--
-- TOC entry 5843 (class 0 OID 0)
-- Dependencies: 297
-- Name: staff_member_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.staff_member_id_seq', 22, true);


--
-- TOC entry 5844 (class 0 OID 0)
-- Dependencies: 299
-- Name: staff_role_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.staff_role_id_seq', 10, true);


--
-- TOC entry 5845 (class 0 OID 0)
-- Dependencies: 301
-- Name: statuslist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.statuslist_id_seq', 9, true);


--
-- TOC entry 5846 (class 0 OID 0)
-- Dependencies: 304
-- Name: survey_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.survey_field_id_seq', 43, true);


--
-- TOC entry 5847 (class 0 OID 0)
-- Dependencies: 306
-- Name: survey_field_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.survey_field_type_id_seq', 7, true);


--
-- TOC entry 5848 (class 0 OID 0)
-- Dependencies: 307
-- Name: survey_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.survey_id_seq', 5, true);


--
-- TOC entry 5849 (class 0 OID 0)
-- Dependencies: 310
-- Name: survey_resp_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.survey_resp_field_id_seq', 168, true);


--
-- TOC entry 5850 (class 0 OID 0)
-- Dependencies: 311
-- Name: survey_resp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.survey_resp_id_seq', 13, true);


--
-- TOC entry 5851 (class 0 OID 0)
-- Dependencies: 313
-- Name: survey_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.survey_type_id_seq', 1, true);


--
-- TOC entry 5852 (class 0 OID 0)
-- Dependencies: 315
-- Name: tag_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tag_id_seq', 36, true);


--
-- TOC entry 5853 (class 0 OID 0)
-- Dependencies: 317
-- Name: tag_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.tag_link_id_seq', 379, true);


--
-- TOC entry 5854 (class 0 OID 0)
-- Dependencies: 352
-- Name: task_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_id_seq', 1, false);


--
-- TOC entry 5855 (class 0 OID 0)
-- Dependencies: 355
-- Name: task_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_link_id_seq', 1, false);


--
-- TOC entry 5856 (class 0 OID 0)
-- Dependencies: 357
-- Name: task_master_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_master_id_seq', 1, false);


--
-- TOC entry 5857 (class 0 OID 0)
-- Dependencies: 359
-- Name: task_master_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_master_link_id_seq', 1, false);


--
-- TOC entry 5858 (class 0 OID 0)
-- Dependencies: 353
-- Name: task_task_master_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_task_master_id_seq', 1, false);


--
-- TOC entry 5275 (class 2606 OID 25668)
-- Name: action_link action_link_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_link
    ADD CONSTRAINT action_link_pk PRIMARY KEY (id);


--
-- TOC entry 5277 (class 2606 OID 25670)
-- Name: action_link action_link_un; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_link
    ADD CONSTRAINT action_link_un UNIQUE (action_id, ext_id, scope);


--
-- TOC entry 5273 (class 2606 OID 25672)
-- Name: action action_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action
    ADD CONSTRAINT action_pkey PRIMARY KEY (id);


--
-- TOC entry 5279 (class 2606 OID 25674)
-- Name: afcnsend afcnsend_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.afcnsend
    ADD CONSTRAINT afcnsend_pkey PRIMARY KEY (id);


--
-- TOC entry 5281 (class 2606 OID 25676)
-- Name: agelist agelist_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.agelist
    ADD CONSTRAINT agelist_pkey PRIMARY KEY (id);


--
-- TOC entry 5283 (class 2606 OID 25678)
-- Name: audit audit_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit
    ADD CONSTRAINT audit_pkey PRIMARY KEY (id);


--
-- TOC entry 5285 (class 2606 OID 25680)
-- Name: audit_record audit_record_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_record
    ADD CONSTRAINT audit_record_pk PRIMARY KEY (id);


--
-- TOC entry 5287 (class 2606 OID 25682)
-- Name: audit_record audit_record_un; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_record
    ADD CONSTRAINT audit_record_un UNIQUE (quaad_point_id, audit_id);


--
-- TOC entry 5289 (class 2606 OID 25684)
-- Name: audit_recordprocedure audit_recordprocedure_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_recordprocedure
    ADD CONSTRAINT audit_recordprocedure_pk PRIMARY KEY (id);


--
-- TOC entry 5291 (class 2606 OID 25686)
-- Name: audit_subrecord audit_subrecord_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_subrecord
    ADD CONSTRAINT audit_subrecord_pk PRIMARY KEY (id);


--
-- TOC entry 5293 (class 2606 OID 25688)
-- Name: audit_type audit_type_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_type
    ADD CONSTRAINT audit_type_pk PRIMARY KEY (id);


--
-- TOC entry 5295 (class 2606 OID 25690)
-- Name: department department_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department
    ADD CONSTRAINT department_pkey PRIMARY KEY (id);


--
-- TOC entry 5299 (class 2606 OID 25692)
-- Name: device_inspection device_inspection_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_inspection
    ADD CONSTRAINT device_inspection_pkey PRIMARY KEY (id);


--
-- TOC entry 5301 (class 2606 OID 25694)
-- Name: device_installation device_installation_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_installation
    ADD CONSTRAINT device_installation_pkey PRIMARY KEY (id);


--
-- TOC entry 5303 (class 2606 OID 25696)
-- Name: device_maintenance device_maintenance_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_maintenance
    ADD CONSTRAINT device_maintenance_pkey PRIMARY KEY (id);


--
-- TOC entry 5297 (class 2606 OID 25698)
-- Name: device device_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device
    ADD CONSTRAINT device_pkey PRIMARY KEY (id);


--
-- TOC entry 5307 (class 2606 OID 25700)
-- Name: document_link document_link_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_link
    ADD CONSTRAINT document_link_pkey PRIMARY KEY (id);


--
-- TOC entry 5309 (class 2606 OID 25702)
-- Name: document_master document_master_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_master
    ADD CONSTRAINT document_master_pkey PRIMARY KEY (id);


--
-- TOC entry 5305 (class 2606 OID 25704)
-- Name: document document_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document
    ADD CONSTRAINT document_pkey PRIMARY KEY (id);


--
-- TOC entry 5311 (class 2606 OID 25706)
-- Name: documentstatus documentstatus_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documentstatus
    ADD CONSTRAINT documentstatus_pkey PRIMARY KEY (id);


--
-- TOC entry 5383 (class 2606 OID 26827)
-- Name: documenttypelist documenttypelist_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documenttypelist
    ADD CONSTRAINT documenttypelist_pkey PRIMARY KEY (id);


--
-- TOC entry 5314 (class 2606 OID 25708)
-- Name: examident examident_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examident
    ADD CONSTRAINT examident_pkey PRIMARY KEY (id);


--
-- TOC entry 5316 (class 2606 OID 25710)
-- Name: examlist examlist_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examlist
    ADD CONSTRAINT examlist_pkey PRIMARY KEY (id);


--
-- TOC entry 5318 (class 2606 OID 25712)
-- Name: examwarning examwarning_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examwarning
    ADD CONSTRAINT examwarning_pkey PRIMARY KEY (id);


--
-- TOC entry 5320 (class 2606 OID 25714)
-- Name: external_link external_link_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.external_link
    ADD CONSTRAINT external_link_pk PRIMARY KEY (id);


--
-- TOC entry 5322 (class 2606 OID 25716)
-- Name: external_src external_src_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.external_src
    ADD CONSTRAINT external_src_pk PRIMARY KEY (id);


--
-- TOC entry 5324 (class 2606 OID 25718)
-- Name: institution institution_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.institution
    ADD CONSTRAINT institution_pkey PRIMARY KEY (id);


--
-- TOC entry 5326 (class 2606 OID 25720)
-- Name: legaldocument legaldocument_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.legaldocument
    ADD CONSTRAINT legaldocument_pkey PRIMARY KEY (id);


--
-- TOC entry 5328 (class 2606 OID 25722)
-- Name: link_quaad_tag link_quaad_tag_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.link_quaad_tag
    ADD CONSTRAINT link_quaad_tag_pk PRIMARY KEY (id_quaadpoint, id_tag);


--
-- TOC entry 5330 (class 2606 OID 25724)
-- Name: login_role login_role_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_role
    ADD CONSTRAINT login_role_name_key UNIQUE (name);


--
-- TOC entry 5334 (class 2606 OID 25726)
-- Name: login_role_permission login_role_permission_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_role_permission
    ADD CONSTRAINT login_role_permission_pkey PRIMARY KEY (id);


--
-- TOC entry 5332 (class 2606 OID 25728)
-- Name: login_role login_role_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_role
    ADD CONSTRAINT login_role_pkey PRIMARY KEY (id);


--
-- TOC entry 5336 (class 2606 OID 25730)
-- Name: procedure procedure_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.procedure
    ADD CONSTRAINT procedure_pkey PRIMARY KEY (id);


--
-- TOC entry 5338 (class 2606 OID 25732)
-- Name: quaad_description quaad_description_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_description
    ADD CONSTRAINT quaad_description_pk PRIMARY KEY (id);


--
-- TOC entry 5340 (class 2606 OID 25734)
-- Name: quaad_description quaad_description_un; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_description
    ADD CONSTRAINT quaad_description_un UNIQUE (id_quaadpoint, language);


--
-- TOC entry 5342 (class 2606 OID 25736)
-- Name: quaad_nameinscope quaad_nameinscope_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_nameinscope
    ADD CONSTRAINT quaad_nameinscope_pk PRIMARY KEY (scope_name);


--
-- TOC entry 5344 (class 2606 OID 25738)
-- Name: quaad_point quaad_point_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_point
    ADD CONSTRAINT quaad_point_pk PRIMARY KEY (id);


--
-- TOC entry 5346 (class 2606 OID 25740)
-- Name: quaad_point quaad_point_un; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_point
    ADD CONSTRAINT quaad_point_un UNIQUE (level1, level2, level3, level4, level5, inlevelorder, quaadversion);


--
-- TOC entry 5350 (class 2606 OID 25742)
-- Name: quaadpoint_tag_name quaadpoint_tag_name_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadpoint_tag_name
    ADD CONSTRAINT quaadpoint_tag_name_pk PRIMARY KEY (id);


--
-- TOC entry 5352 (class 2606 OID 25744)
-- Name: quaadpoint_tag_name quaadpoint_tag_name_un; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadpoint_tag_name
    ADD CONSTRAINT quaadpoint_tag_name_un UNIQUE (id_quaadpoint_tag);


--
-- TOC entry 5348 (class 2606 OID 25746)
-- Name: quaadpoint_tag quaadpoint_tag_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadpoint_tag
    ADD CONSTRAINT quaadpoint_tag_pk PRIMARY KEY (id);


--
-- TOC entry 5354 (class 2606 OID 25748)
-- Name: quaadtag_doc_link quaadtag_doc_link_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadtag_doc_link
    ADD CONSTRAINT quaadtag_doc_link_pk PRIMARY KEY (id_doclink, id_quaadtag);


--
-- TOC entry 5381 (class 2606 OID 26898)
-- Name: action_status_link read_status_link_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_status_link
    ADD CONSTRAINT read_status_link_pk UNIQUE (staff_member_id, document_id, action_id);


--
-- TOC entry 5356 (class 2606 OID 25750)
-- Name: report report_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.report
    ADD CONSTRAINT report_pkey PRIMARY KEY (id);


--
-- TOC entry 5358 (class 2606 OID 25752)
-- Name: sequpdate_state sequpdate_state_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sequpdate_state
    ADD CONSTRAINT sequpdate_state_pkey PRIMARY KEY (updateid);


--
-- TOC entry 5360 (class 2606 OID 25754)
-- Name: sexlist sexlist_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sexlist
    ADD CONSTRAINT sexlist_pkey PRIMARY KEY (id);


--
-- TOC entry 5362 (class 2606 OID 25756)
-- Name: staff_formation staff_formation_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_formation
    ADD CONSTRAINT staff_formation_pkey PRIMARY KEY (id);


--
-- TOC entry 5364 (class 2606 OID 25758)
-- Name: staff_job staff_job_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_job
    ADD CONSTRAINT staff_job_pkey PRIMARY KEY (id);


--
-- TOC entry 5366 (class 2606 OID 25760)
-- Name: staff_member staff_member_login_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_member
    ADD CONSTRAINT staff_member_login_key UNIQUE (login);


--
-- TOC entry 5368 (class 2606 OID 25762)
-- Name: staff_member staff_member_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_member
    ADD CONSTRAINT staff_member_pkey PRIMARY KEY (id);


--
-- TOC entry 5370 (class 2606 OID 25764)
-- Name: staff_role staff_role_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_role
    ADD CONSTRAINT staff_role_pkey PRIMARY KEY (id);


--
-- TOC entry 5372 (class 2606 OID 25766)
-- Name: statuslist statuslist_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.statuslist
    ADD CONSTRAINT statuslist_pkey PRIMARY KEY (id);


--
-- TOC entry 5376 (class 2606 OID 25768)
-- Name: tag_link tag_link_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tag_link
    ADD CONSTRAINT tag_link_pkey PRIMARY KEY (id);


--
-- TOC entry 5374 (class 2606 OID 25770)
-- Name: tag tag_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tag
    ADD CONSTRAINT tag_pkey PRIMARY KEY (id);


--
-- TOC entry 5387 (class 2606 OID 29889)
-- Name: task_master task_master_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_master
    ADD CONSTRAINT task_master_pk PRIMARY KEY (id);


--
-- TOC entry 5385 (class 2606 OID 29866)
-- Name: task task_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task
    ADD CONSTRAINT task_pk PRIMARY KEY (id);


--
-- TOC entry 5378 (class 2606 OID 25772)
-- Name: xusercfgparameter xusercfgparameter_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.xusercfgparameter
    ADD CONSTRAINT xusercfgparameter_pk PRIMARY KEY (cfgparameter_id);


--
-- TOC entry 5312 (class 1259 OID 25773)
-- Name: laststatus_per_document_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX laststatus_per_document_index ON public.documentstatus USING btree (doc_id, begdate DESC);


--
-- TOC entry 5379 (class 1259 OID 25774)
-- Name: xusercfgparameteridx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX xusercfgparameteridx ON public.xusercfgparameter USING btree (variable);


--
-- TOC entry 5608 (class 2618 OID 25555)
-- Name: v_exam_risk_tag_doc _RETURN; Type: RULE; Schema: public; Owner: postgres
--

CREATE OR REPLACE VIEW public.v_exam_risk_tag_doc AS
 SELECT allexam.id,
    allexam.modality,
    allexam.nameid AS name,
    allexam.description,
    allexam.riskv AS risklist,
    allexam.taglist,
    allexamwithdoc.doc_id,
    allexamwithotherdoc.doc_otherdoc_id
   FROM ((( SELECT examlist.id,
            examlist.modality,
            examlist.nameid,
            examlist.description,
            string_agg((examwarning_link.examwarning_id)::text, ','::text) AS riskv,
            public.f_tag_link(examlist.id) AS taglist
           FROM (public.examlist
             LEFT JOIN public.examwarning_link ON ((examwarning_link.exam_id = examlist.id)))
          WHERE ((examlist.removed = false) AND ((examwarning_link.examwarning_id IS NULL) OR (examwarning_link.examwarning_id IS NOT NULL)))
          GROUP BY examlist.id, examlist.nameid, examlist.description) allexam
     LEFT JOIN ( SELECT document_link.doc_id,
            document_link.ext_id
           FROM public.v_last_documentstatus,
            public.document_link
          WHERE ((v_last_documentstatus.status_id = 1) AND (v_last_documentstatus.doc_id = document_link.doc_id) AND ((document_link.type)::text = 'examlist'::text))) allexamwithdoc ON ((allexamwithdoc.ext_id = allexam.id)))
     LEFT JOIN ( SELECT document_link.doc_id AS doc_otherdoc_id,
            document_link.ext_id
           FROM public.v_last_documentstatus,
            public.document_link
          WHERE ((v_last_documentstatus.status_id = 1) AND (v_last_documentstatus.doc_id = document_link.doc_id) AND ((document_link.type)::text = 'examlist_otherdocument'::text))) allexamwithotherdoc ON ((allexamwithotherdoc.ext_id = allexam.id)))
  ORDER BY allexam.id, allexamwithdoc.doc_id;


--
-- TOC entry 5445 (class 2620 OID 25776)
-- Name: department calltrg_init_init_tag_department; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER calltrg_init_init_tag_department AFTER INSERT ON public.department FOR EACH ROW EXECUTE FUNCTION public.trg_init_tag_department();


--
-- TOC entry 5446 (class 2620 OID 25777)
-- Name: department calltrg_init_init_tag_department_update; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER calltrg_init_init_tag_department_update AFTER UPDATE ON public.department FOR EACH ROW EXECUTE FUNCTION public.trg_init_tag_department_update();


--
-- TOC entry 5447 (class 2620 OID 25778)
-- Name: institution calltrg_init_init_tag_institution; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER calltrg_init_init_tag_institution AFTER INSERT ON public.institution FOR EACH ROW EXECUTE FUNCTION public.trg_init_tag_institution();


--
-- TOC entry 5448 (class 2620 OID 25779)
-- Name: institution calltrg_init_init_tag_institution_update; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER calltrg_init_init_tag_institution_update AFTER UPDATE ON public.institution FOR EACH ROW EXECUTE FUNCTION public.trg_init_tag_institution_update();


--
-- TOC entry 5449 (class 2620 OID 25780)
-- Name: login_role calltrg_init_login_role_permission; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER calltrg_init_login_role_permission AFTER INSERT ON public.login_role FOR EACH ROW EXECUTE FUNCTION public.trg_init_login_role_permission();


--
-- TOC entry 5450 (class 2620 OID 25781)
-- Name: staff_formation f_staffmember_equals_staff; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER f_staffmember_equals_staff BEFORE INSERT OR UPDATE ON public.staff_formation FOR EACH ROW EXECUTE FUNCTION public.f_staffmember_equals_staff();


--
-- TOC entry 5390 (class 2606 OID 25782)
-- Name: action_link action_link_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_link
    ADD CONSTRAINT action_link_fk FOREIGN KEY (action_id) REFERENCES public.action(id);


--
-- TOC entry 5388 (class 2606 OID 25787)
-- Name: action action_personincharge_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action
    ADD CONSTRAINT action_personincharge_fkey FOREIGN KEY (personincharge) REFERENCES public.staff_member(id);


--
-- TOC entry 5389 (class 2606 OID 25792)
-- Name: action action_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action
    ADD CONSTRAINT action_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5391 (class 2606 OID 25797)
-- Name: afcnsend afcnsend_dep_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.afcnsend
    ADD CONSTRAINT afcnsend_dep_id_fkey FOREIGN KEY (dep_id) REFERENCES public.department(id);


--
-- TOC entry 5392 (class 2606 OID 25802)
-- Name: afcnsend afcnsend_device_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.afcnsend
    ADD CONSTRAINT afcnsend_device_id_fkey FOREIGN KEY (device_id) REFERENCES public.device(id);


--
-- TOC entry 5393 (class 2606 OID 25807)
-- Name: afcnsend afcnsend_inst_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.afcnsend
    ADD CONSTRAINT afcnsend_inst_id_fkey FOREIGN KEY (inst_id) REFERENCES public.institution(id);


--
-- TOC entry 5394 (class 2606 OID 25812)
-- Name: afcnsend afcnsend_sender_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.afcnsend
    ADD CONSTRAINT afcnsend_sender_fkey FOREIGN KEY (sender) REFERENCES public.staff_member(id);


--
-- TOC entry 5395 (class 2606 OID 25817)
-- Name: audit audit_dep_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit
    ADD CONSTRAINT audit_dep_id_fkey FOREIGN KEY (dep_id) REFERENCES public.department(id);


--
-- TOC entry 5396 (class 2606 OID 25822)
-- Name: audit audit_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit
    ADD CONSTRAINT audit_fk FOREIGN KEY (type) REFERENCES public.audit_type(id);


--
-- TOC entry 5397 (class 2606 OID 25827)
-- Name: audit audit_inst_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit
    ADD CONSTRAINT audit_inst_id_fkey FOREIGN KEY (inst_id) REFERENCES public.institution(id);


--
-- TOC entry 5398 (class 2606 OID 25832)
-- Name: audit audit_personincharge_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit
    ADD CONSTRAINT audit_personincharge_fkey FOREIGN KEY (personincharge) REFERENCES public.staff_member(id);


--
-- TOC entry 5400 (class 2606 OID 25837)
-- Name: audit_record audit_record_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_record
    ADD CONSTRAINT audit_record_fk FOREIGN KEY (audit_id) REFERENCES public.audit(id);


--
-- TOC entry 5401 (class 2606 OID 25842)
-- Name: audit_record audit_record_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_record
    ADD CONSTRAINT audit_record_fk_1 FOREIGN KEY (quaad_point_id) REFERENCES public.quaad_point(id);


--
-- TOC entry 5402 (class 2606 OID 25847)
-- Name: audit_recordprocedure audit_recordprocedure_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_recordprocedure
    ADD CONSTRAINT audit_recordprocedure_fk FOREIGN KEY (audit_record_id) REFERENCES public.audit_record(id);


--
-- TOC entry 5403 (class 2606 OID 25852)
-- Name: audit_recordprocedure audit_recordprocedure_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_recordprocedure
    ADD CONSTRAINT audit_recordprocedure_fk_1 FOREIGN KEY (procedure_id) REFERENCES public.procedure(id);


--
-- TOC entry 5404 (class 2606 OID 25857)
-- Name: audit_recordprocedure audit_recordprocedure_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_recordprocedure
    ADD CONSTRAINT audit_recordprocedure_fk_2 FOREIGN KEY (doc_id) REFERENCES public.document(id);


--
-- TOC entry 5399 (class 2606 OID 25862)
-- Name: audit audit_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit
    ADD CONSTRAINT audit_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5405 (class 2606 OID 25867)
-- Name: audit_subrecord audit_subrecord_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_subrecord
    ADD CONSTRAINT audit_subrecord_fk FOREIGN KEY (audit_record_id) REFERENCES public.audit_record(id);


--
-- TOC entry 5406 (class 2606 OID 25872)
-- Name: audit_subrecord audit_subrecord_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.audit_subrecord
    ADD CONSTRAINT audit_subrecord_fk_1 FOREIGN KEY (quaadpoint_tag_id) REFERENCES public.quaadpoint_tag(id);


--
-- TOC entry 5441 (class 2606 OID 26160)
-- Name: default_action_needed default_read_needed_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.default_action_needed
    ADD CONSTRAINT default_read_needed_fk FOREIGN KEY (department_id) REFERENCES public.department(id);


--
-- TOC entry 5442 (class 2606 OID 26165)
-- Name: default_action_needed default_read_needed_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.default_action_needed
    ADD CONSTRAINT default_read_needed_fk_1 FOREIGN KEY (staff_role_id) REFERENCES public.staff_role(id);


--
-- TOC entry 5407 (class 2606 OID 25877)
-- Name: department department_inst_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department
    ADD CONSTRAINT department_inst_id_fkey FOREIGN KEY (inst_id) REFERENCES public.institution(id);


--
-- TOC entry 5408 (class 2606 OID 25882)
-- Name: device_inspection device_inspection_device_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_inspection
    ADD CONSTRAINT device_inspection_device_id_fkey FOREIGN KEY (device_id) REFERENCES public.device(id);


--
-- TOC entry 5409 (class 2606 OID 25887)
-- Name: device_inspection device_inspection_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_inspection
    ADD CONSTRAINT device_inspection_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5410 (class 2606 OID 25892)
-- Name: device_installation device_installation_dep_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_installation
    ADD CONSTRAINT device_installation_dep_id_fkey FOREIGN KEY (dep_id) REFERENCES public.department(id);


--
-- TOC entry 5411 (class 2606 OID 25897)
-- Name: device_installation device_installation_device_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_installation
    ADD CONSTRAINT device_installation_device_id_fkey FOREIGN KEY (device_id) REFERENCES public.device(id);


--
-- TOC entry 5412 (class 2606 OID 25902)
-- Name: device_maintenance device_maintenance_device_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_maintenance
    ADD CONSTRAINT device_maintenance_device_id_fkey FOREIGN KEY (device_id) REFERENCES public.device(id);


--
-- TOC entry 5413 (class 2606 OID 25907)
-- Name: device_maintenance device_maintenance_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_maintenance
    ADD CONSTRAINT device_maintenance_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5414 (class 2606 OID 25912)
-- Name: document document_doc_master_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document
    ADD CONSTRAINT document_doc_master_id_fkey FOREIGN KEY (doc_master_id) REFERENCES public.document_master(id);


--
-- TOC entry 5416 (class 2606 OID 25917)
-- Name: document_link document_link_doc_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_link
    ADD CONSTRAINT document_link_doc_id_fkey FOREIGN KEY (doc_id) REFERENCES public.document(id);


--
-- TOC entry 5415 (class 2606 OID 25922)
-- Name: document document_uploadedby_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document
    ADD CONSTRAINT document_uploadedby_fkey FOREIGN KEY (uploadedby) REFERENCES public.staff_member(id);


--
-- TOC entry 5417 (class 2606 OID 25927)
-- Name: documentstatus documentstatus_doc_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documentstatus
    ADD CONSTRAINT documentstatus_doc_id_fkey FOREIGN KEY (doc_id) REFERENCES public.document(id);


--
-- TOC entry 5418 (class 2606 OID 25932)
-- Name: documentstatus documentstatus_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documentstatus
    ADD CONSTRAINT documentstatus_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5419 (class 2606 OID 25937)
-- Name: examwarning_link examwarning_link_exam_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examwarning_link
    ADD CONSTRAINT examwarning_link_exam_id_fkey FOREIGN KEY (exam_id) REFERENCES public.examlist(id);


--
-- TOC entry 5420 (class 2606 OID 25942)
-- Name: examwarning_link examwarning_link_examwarning_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.examwarning_link
    ADD CONSTRAINT examwarning_link_examwarning_id_fkey FOREIGN KEY (examwarning_id) REFERENCES public.examwarning(id);


--
-- TOC entry 5421 (class 2606 OID 25947)
-- Name: external_link external_link_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.external_link
    ADD CONSTRAINT external_link_fk FOREIGN KEY (ext_src) REFERENCES public.external_src(id);


--
-- TOC entry 5422 (class 2606 OID 25952)
-- Name: link_quaad_tag link_quaad_tag_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.link_quaad_tag
    ADD CONSTRAINT link_quaad_tag_fk FOREIGN KEY (id_tag) REFERENCES public.quaadpoint_tag(id);


--
-- TOC entry 5423 (class 2606 OID 25957)
-- Name: link_quaad_tag link_quaad_tag_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.link_quaad_tag
    ADD CONSTRAINT link_quaad_tag_fk_1 FOREIGN KEY (id_quaadpoint) REFERENCES public.quaad_point(id);


--
-- TOC entry 5424 (class 2606 OID 25962)
-- Name: login_role_permission login_role_permission_login_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.login_role_permission
    ADD CONSTRAINT login_role_permission_login_role_id_fkey FOREIGN KEY (login_role_id) REFERENCES public.login_role(id);


--
-- TOC entry 5425 (class 2606 OID 25967)
-- Name: quaad_description quaad_description_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_description
    ADD CONSTRAINT quaad_description_fk FOREIGN KEY (id_quaadpoint) REFERENCES public.quaad_point(id);


--
-- TOC entry 5426 (class 2606 OID 25972)
-- Name: quaad_point quaad_point_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaad_point
    ADD CONSTRAINT quaad_point_fk FOREIGN KEY (quaadversion) REFERENCES public.audit_type(id);


--
-- TOC entry 5427 (class 2606 OID 25977)
-- Name: quaadpoint_tag_name quaadpoint_tag_name_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadpoint_tag_name
    ADD CONSTRAINT quaadpoint_tag_name_fk FOREIGN KEY (id_quaadpoint_tag) REFERENCES public.quaadpoint_tag(id);


--
-- TOC entry 5428 (class 2606 OID 25982)
-- Name: quaadtag_doc_link quaadtag_doc_link_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadtag_doc_link
    ADD CONSTRAINT quaadtag_doc_link_fk FOREIGN KEY (id_doclink) REFERENCES public.document_link(id);


--
-- TOC entry 5429 (class 2606 OID 25987)
-- Name: quaadtag_doc_link quaadtag_doc_link_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quaadtag_doc_link
    ADD CONSTRAINT quaadtag_doc_link_fk_1 FOREIGN KEY (id_quaadtag) REFERENCES public.quaadpoint_tag(id);


--
-- TOC entry 5443 (class 2606 OID 26175)
-- Name: action_status_link read_status_link_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_status_link
    ADD CONSTRAINT read_status_link_fk FOREIGN KEY (staff_member_id) REFERENCES public.staff_member(id);


--
-- TOC entry 5444 (class 2606 OID 26180)
-- Name: action_status_link read_status_link_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.action_status_link
    ADD CONSTRAINT read_status_link_fk_1 FOREIGN KEY (document_id) REFERENCES public.document(id);


--
-- TOC entry 5430 (class 2606 OID 25992)
-- Name: report report_dep_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.report
    ADD CONSTRAINT report_dep_id_fkey FOREIGN KEY (dep_id) REFERENCES public.department(id);


--
-- TOC entry 5431 (class 2606 OID 25997)
-- Name: report report_reporter_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.report
    ADD CONSTRAINT report_reporter_fkey FOREIGN KEY (reporter) REFERENCES public.staff_member(id);


--
-- TOC entry 5432 (class 2606 OID 26002)
-- Name: report report_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.report
    ADD CONSTRAINT report_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5433 (class 2606 OID 26007)
-- Name: staff_formation staff_formation_staff_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_formation
    ADD CONSTRAINT staff_formation_staff_id_fkey FOREIGN KEY (staff_id) REFERENCES public.staff_member(id);


--
-- TOC entry 5434 (class 2606 OID 26012)
-- Name: staff_formation staff_formation_status_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_formation
    ADD CONSTRAINT staff_formation_status_id_fkey FOREIGN KEY (status_id) REFERENCES public.statuslist(id);


--
-- TOC entry 5435 (class 2606 OID 26017)
-- Name: staff_job staff_job_dep_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_job
    ADD CONSTRAINT staff_job_dep_id_fkey FOREIGN KEY (dep_id) REFERENCES public.department(id);


--
-- TOC entry 5436 (class 2606 OID 26022)
-- Name: staff_job staff_job_staff_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_job
    ADD CONSTRAINT staff_job_staff_id_fkey FOREIGN KEY (staff_id) REFERENCES public.staff_member(id);


--
-- TOC entry 5437 (class 2606 OID 26027)
-- Name: staff_job staff_job_staff_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_job
    ADD CONSTRAINT staff_job_staff_role_id_fkey FOREIGN KEY (staff_role_id) REFERENCES public.staff_role(id);


--
-- TOC entry 5438 (class 2606 OID 26032)
-- Name: staff_member staff_member_login_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.staff_member
    ADD CONSTRAINT staff_member_login_role_id_fkey FOREIGN KEY (login_role_id) REFERENCES public.login_role(id);


--
-- TOC entry 5440 (class 2606 OID 26037)
-- Name: xusercfg staff_member_xusercfg_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.xusercfg
    ADD CONSTRAINT staff_member_xusercfg_fk FOREIGN KEY (id) REFERENCES public.staff_member(id);


--
-- TOC entry 5439 (class 2606 OID 26042)
-- Name: tag_link tag_link_tag_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tag_link
    ADD CONSTRAINT tag_link_tag_id_fkey FOREIGN KEY (tag_id) REFERENCES public.tag(id);


-- Completed on 2025-08-28 14:26:58

--
-- PostgreSQL database dump complete
--

