<?php
	require_once '../../autoload.php';
	$pdo = getPDO ();
	$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->prepare ( "SELECT photo FROM staff_member WHERE id = :id" );
    $stmt->bindParam ( ':id', $_GET['id'], PDO::PARAM_INT );
    $stmt->execute();
    
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row || !isset($row['photo'])) 
    {
    	// http_response_code(404);
    	exit ();
	}

    $photoData = $row['photo'];

	if (is_resource($photoData)) 
    	$photoData = stream_get_contents($photoData);

	$finfo = new finfo(FILEINFO_MIME_TYPE);
	$mimeType = $finfo->buffer($photoData);

	header("Content-Type: $mimeType");
	header("Content-Length: ".strlen($photoData));
	
	echo $photoData;
?>