<?php
	session_name("eoQUAL");
	session_start();

	if(isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === TRUE )
	{
		unset($_SESSION['autolog']);
	}
	else
	{
		//autologon
		$_SESSION['loggedin'] = TRUE;
		$_SESSION['autolog'] = 1;
	}

	session_commit();

	include '../autoload.php';

	// include 'SurveyCompletingRender.php';

	// echo "<div>Blabla</div>";


?>


<!DOCTYPE html>
<html>

	<head>
		<meta http-equiv="content-type" content="text/html; charset=UTF-8">
		<title>Enquête de satisfaction</title>
		<link rel="stylesheet" href="/eoQUALBootstrap/eoQUAL/SubFW/css/paper.css">
	</head>

	<body class="A4">
		
		<section class="sheet" style="padding: 5px; height: auto !important;min-height: 297mm;">

			<?php
			$rootPath = $GLOBALS['approot'];

			$pdo = getPDO ();
			$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    		// $stmt = $pdo->prepare ( "SELECT id,name,brand,model,serialnumber FROM device where removed=false order by name" );
    		$stmt = $pdo->prepare ( "select device.id,device.name,brand,model,serialnumber,TO_CHAR(installdate,'DD/MM/YYYY') as install_date, department.name as department, institution.name as institution from device,device_installation di ,department,institution where device.id=di.device_id and department.id=di.dep_id and department.inst_id=institution.id order by name" );
    		$stmt->execute();
    
    		$results = $stmt->fetchAll ( PDO::FETCH_ASSOC );

    		/*
    		echo '<div class="container m-0 p-0">';
    		echo 	'<div class="row row-cols-auto m-0 p-0">';
			for ( $i=0; $i<count($results); $i++ )
			{
				$row = $results[$i];

				$id 		= $row ['id'];
    			$name		= $row ['name'];
    			$brand		= $row ['brand'];

    			echo '<div class="col-sm-3 m-0 p-0 ms-1 mb-2 border">';
    			echo 	'<div class="preview-container1">';
				echo 		"<img src=\"".$rootPath."/eoQUAL/SubFW/database/device/get_device_image.php?id=".$id."\"/>";
    			echo 	"</div>";
    			echo 	'<div class="m-0 p-0 ps-2 fw-bold">'.$name.' '.$brand.'</div>';
    			echo '</div>';
    		}
    		echo 	'</div>';
    		echo '</div>';
    		*/

    		echo '<div class="container m-0 p-0">';
    		for ( $i=0; $i<count($results); $i++ )
			{
				$row = $results[$i];

				$id 			= $row ['id'];
				$name			= $row ['name'];
    			$brand			= $row ['brand'];
    			$model			= $row ['model'];
    			$sn				= $row ['serialnumber'];
    			$install_date	= $row ['install_date'];
    			$institution	= $row ['institution'];
    			$department		= $row ['department'];

    			echo '<div class="row m-0 p-0 border-top">';
    			echo 	'<div class="col m-0 p-0">';
    			echo 		'<div class="row m-0 p-0 fw-bold">';
    			echo 			$name;
    			echo 		'</div>';
    			echo 		'<div class="row m-0 p-0">';
    			echo 			'<div class="col-auto m-0 p-0 ps-3 pe-2">Marque :</div><div class="col m-0 p-0">'.$brand.'</div>';
    			echo 		'</div>';
    			echo 		'<div class="row m-0 p-0">';
    			echo 			'<div class="col-auto m-0 p-0 ps-3 pe-2">Modèle :</div><div class="col m-0 p-0">'.$model.'</div>';
    			echo 		'</div>';
    			echo 		'<div class="row m-0 p-0">';
    			echo 			'<div class="col-auto m-0 p-0 ps-3 pe-2">S.N. :</div><div class="col m-0 p-0">'.$sn.'</div>';
    			echo 		'</div>';
    			echo 		'<div class="row m-0 p-0">';
    			echo 			'<div class="col-auto m-0 p-0 ps-3 pe-2">Date d\'installation :</div><div class="col m-0 p-0">'.$install_date.'</div>';
    			echo 		'</div>';
    			echo 		'<div class="row m-0 p-0">';
    			echo 			'<div class="col-auto m-0 p-0 ps-3 pe-2">Lieu d\'installation :</div><div class="col m-0 p-0">'.$institution.' - '.$department.'</div>';
    			echo 		'</div>';
    			echo 	'</div>';
    			echo 	'<div class="col-auto m-0 p-0">';
    			echo 		'<div class="preview-container1">';
				echo 			'<img src="'.$rootPath.'/eoQUAL/SubFW/database/device/get_device_image.php?id='.$id.'"/>';
    			echo 		'</div>';
    			echo 	'</div>';
    			echo '</div>';
    		}
    		echo '</div>';

			?>

		</section>

	</body>

</html>
