<?php
    require_once '../autoload.php';
    require_once 'JWT.php';
    use \Firebase\JWT\JWT;

    error_log ( "=== OnlyOfficeEditor =================================");

    error_log ( "ID : " .$_SESSION['id'] ); 


    // Get document to open
    
    $doc_id = $_GET['doc_id'];

    $fileToOpen         = "";
    $filename           = "";
    $modification_date  = "";
    $title              = "";

    $pdo = getPDO ();

    if ( $pdo )
    {
        $sql = "select replace(folder||'/'||sourcefile,'\\','/') as fullfilename, sourcefile, modification_date, name, label from document,document_master where document.id = :doc_id and document.doc_master_id=document_master.id";
        
        $s0 = $pdo->prepare ( $sql );
        $s0->bindParam ( ":doc_id", $doc_id );

        if ( $s0->execute () )
        {
            $d0 = $s0->fetchAll ( PDO::FETCH_ASSOC );

            $fileToOpen         = $GLOBALS["document_storage_url"]."/".$d0[0]['fullfilename'];
            $filename           = $d0[0]['sourcefile'];
            $modification_date  = $d0[0]['modification_date'];
            $name               = $d0[0]['name'];
            $label              = $d0[0]['label'];

            $title = ( empty($label) )? $name : $name . " - " .$label;
        }
    }
    error_log ( " File to open : " .$fileToOpen );
    error_log ( " sourcefile : " .$filename );
    error_log ( " Title : " .$title );
    // ====================

    
    $serverUrl  = $GLOBALS["onlyoffice_server"];           // OnlyOffice Document Server

    $fullname = $_SESSION['firstname'] . " " . $_SESSION['lastname'];

    $extension = pathinfo($filename, PATHINFO_EXTENSION);

    $docUrl = $fileToOpen;

    error_log ( " Open file : " .$docUrl );

    $key = base64_encode ( $doc_id."%".$filename."%".$modification_date );
    
    $jwt_secret = "xImEO#2017025#";

    // Objet config
    $config = [
        "document" => [
            "fileType" => $extension,
            "key" => $key,
            // "title" => "Procédure Qualité",
            "title" => $title,
            "url" => $docUrl
        ],
        "editorConfig" => [
        "mode" => "edit",
        "lang" => "fr",
        "callbackUrl" => $GLOBALS["EOQUAL_SERVER_URL"] . $GLOBALS["EOQUAL_FOLDER"] . "/eoQUAL/SubFW/html/OnlyOfficeSaveCB.php",
        "user" => [
            "id" => $_SESSION['id'],
            "name" => $fullname]
        ]
    ];

    // Create token
    $token = JWT::encode($config, $jwt_secret, 'HS256');

    $config["token"] = $token;
?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ONLYOFFICE Editor</title>
        <script src="<?= $serverUrl ?>/web-apps/apps/api/documents/api.js"></script>
        <style>
            html, body {
                margin: 0;
                padding: 0;
                height: 100%;
            }

            #placeholder {
                width: 100%;
                height: 100vh; /* pleine hauteur écran */
            }
            
            #btnFermer {
                position: fixed;
                bottom: 30px;
                right: 45px;
                background-color: rgba(47, 131, 176, 1.0 );
                color: white;
                border: none;
                padding: 6px 14px;
                border-radius: 10px;
                font-size: 14px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
                cursor: pointer;
                z-index: 1000;
            }
            
        </style>
    </head>

    <body>
    
        <div id="placeholder" style="width: 100%; height: 800px; min-height: 800px;"></div>

        <button id="btnFermer" onclick="CloseOOEditor()">✖ Fermer</button>

        <script>
            const docEditor = new DocsAPI.DocEditor("placeholder", <?= json_encode($config, JSON_UNESCAPED_SLASHES) ?>);
        
            function CloseOOEditor () 
            {
                window.parent.postMessage({ action: "CloseOOEditor" }, "*");
                docEditor.destroyEditor();
            }
        </script>

    </body>

</html>
