<?php
    require_once '../autoload.php';

    error_log ( "=== OnlyOfficeSaveCB =================================");

    $data = json_decode(file_get_contents("php://input"), true);
    error_log ( " status : " .$data["status"] );

    $key = base64_decode ( $data["key"] );

    // $ar = explode ( "_", $key );
    $ar = explode ( "%", $key );

    $doc_id         = $ar[0];
    $filename       = $ar[1];

    error_log ( " doc_id : " .$doc_id );
    error_log ( " filename : " .$filename );

    /*
        1 : Le document est en cours d'édition.
        2 : Le document est prêt à être enregistré.
        3 : Une erreur est survenue lors de l'enregistrement du document.
        4 : Le document est fermé sans modifications.
        6 : Le document est en cours d'édition, mais l'état actuel du document est enregistré.
        7 : Une erreur est survenue lors de l'enregistrement forcé du document.
    */

    //
    // Note : le calbback est appelé lorsque tous les utilisateurs ont quitté l'éditeur
    //
    

    // function SaveFileToStorage ( $doc_id, $downloadUrl, $filename )
    function SaveFileToStorage ( $doc_id, $downloadUrl )
    {
        error_log ( "SaveFileToStotage (".$doc_id.")..." );
        error_log ( " Download Url : " .$downloadUrl );

        $fileToReplace = "";

        $pdo = getPDO ();

        if ( $pdo )
        {
            $sql = "select replace(folder||'/'||sourcefile,'\\','/') as fullfilename, sourcefile from document where id = :doc_id";
        
            $s0 = $pdo->prepare ( $sql );
            $s0->bindParam ( ":doc_id", $doc_id );

            if ( $s0->execute () )
            {
                $d0 = $s0->fetchAll ( PDO::FETCH_ASSOC );
                $fileToReplace = $GLOBALS["document_storage"]."/".$d0[0]['fullfilename'];
            }
        }

        error_log ( " File to replace : " .$fileToReplace );

        if ( strlen ($fileToReplace) > 0 )
        {
            $content = file_get_contents($downloadUrl);

            if ( file_put_contents ( $fileToReplace, $content) != false )
            {
                if ( $pdo )
                {
                    $sql = "update document set modification_date=CURRENT_TIMESTAMP where id = :doc_id";
        
                    $s0 = $pdo->prepare ( $sql );
                    $s0->bindParam ( ":doc_id", $doc_id );

                    if ( $s0->execute () == false )
                    {      
                        error_log ( "Unable to update document informations !!!");
                    }
                }
            }
            else
            {
                error_log ( "Unable to update document file !!!");
            }
        }
    }

    if ($data["status"] == 2 || $data["status"] == 6) 
    {
        $downloadUrl = $data["url"];
    
        // SaveFileToStorage ( $doc_id, $downloadUrl, $filename );
        SaveFileToStorage ( $doc_id, $downloadUrl );
    }

    http_response_code(200);
    echo json_encode(["error" => 0]);
?>