

	let XIM_CheckboxMenu = {
		NbCheckboxMenu : 0,
	
		CBMList : Array (),
		
		GetNbItems : function ()
		{
			return XIM_CheckboxMenu.CBMList.length;
		},
		
		IDValid : function ( cbm_id )
		{
			if ( cbm_id >= 0 && cbm_id < XIM_CheckboxMenu.CBMList.length )
				return true;
			else
				return false;
		},
		
		AddItem : function ( item )
		{
			XIM_CheckboxMenu.CBMList.push ( item );
		},
		
		OnClick : function ( cal_id, item )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnClick ( item );
		},
		
		UnselectItem : function ( cbm_id, index )
		{
			if ( XIM_CheckboxMenu.IDValid( cbm_id ) )
				XIM_CheckboxMenu.CBMList [cbm_id].UnselectItem ( index );
		},
		
		OnSelectButtonClicked : function ( cal_id )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnSelectButtonClicked ();
		}
		,
		
		OnUnselectButtonClicked : function ( cal_id )
		{
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnUnselectButtonClicked ();
		}
		,

		OnTextChanged : function ( cal_id )
		{
			console.log ( "OnTextChanged...");
			if ( XIM_CheckboxMenu.IDValid( cal_id ) )
				XIM_CheckboxMenu.CBMList [cal_id].OnTextChanged ();
		}
	}
		



class C_CheckboxMenu
{
	constructor ( container, ident, title )
	{
		this.Container 		= container;
		this.Ident			= ident;
		this.NbItems		= 0;
		this.ID				= XIM_CheckboxMenu.GetNbItems ();
		this.CallbackFct	= "";
		
		let idc = document.getElementById ( this.Container );
		
		let idcButtonsContainer = this.Container + "_buttons_container";
		
		let tmp = "";
		
		tmp += '<div class="dropdown w-100">';
		tmp += 		'<div id="'+idcButtonsContainer+'" class="w-100 m-0 p-0 mb-1" style="max-height: 100px !important; overflow-y: auto !important;">';
		tmp += 		'</div>';

		let idcText = this.Container + "_input";
		tmp += 		'<input class="btn border dropdown-toggle w-100" placeholder="'+title+'" href="#" role="button" id="'+idcText+'" data-bs-toggle="dropdown" aria-expanded="false" style="overflow: hidden;" oninput="XIM_CheckboxMenu.OnTextChanged('+this.ID+')" />';

		let idcList = this.Container + "_ul";
		tmp +=		"<ul id=\""+idcList+"\" class=\"dropdown-menu\" style=\"max-height: 300px !important; overflow-y: auto !important;\">";
		tmp +=			"<div id=\"IdcCBMSelectButton\" class=\"w-100 d-flex flex-row-reverse\"><button type=\"button\" class=\"btn btn-link\" data-langkey=\"Select all\" onclick=\"XIM_CheckboxMenu.OnSelectButtonClicked("+this.ID+")\">Select all</button><button type=\"button\" class=\"btn btn-link\" data-langkey=\"Unselect all\" onclick=\"XIM_CheckboxMenu.OnUnselectButtonClicked("+this.ID+")\">Unselect all</button></div>";
		tmp +=		"</ul>";
		tmp +=	"</div>";
		
		idc.innerHTML = tmp;

		XIM_CheckboxMenu.AddItem ( this );
	}

	AddTextSeparator ( label )
	{
		let idcList = document.getElementById ( this.Container + "_ul" );
		
		let idcItem = this.Container + "_cb_" + this.NbItems;
		
		let li = document.createElement('li');
		let tmp = "";
		tmp +=				"<div class=\"w-100 m-0 p-0 ps-3 pe-3 bg-light text-muted fs-5 border-bottom border-top\">"+label+"</div>";
		
		li.innerHTML = tmp;
		
		idcList.appendChild ( li );
	}
	
	AddItem ( ident1, ident2, label, subLabel )
	{
		// console.log ( "AddItem : " + ident1 + " / " + ident2 + " / " + label );
		let idcList = document.getElementById ( this.Container + "_ul" );
		
		let idcItem 	= this.Container + "_cb_" + this.NbItems;
		let idcLabel 	= this.Container + "_label_" + this.NbItems;
		let idcA 		= this.Container + "_a_" + this.NbItems;
		
		let li = document.createElement('li');
		let tmp = "";
		tmp +=				'<a id="'+idcA+'" class="dropdown-item">';
		tmp +=				"<div class=\"form-check w-100\">";
		tmp +=					"<input id=\""+idcItem+"\" class=\"form-check-input\" type=\"checkbox\" data-ident1="+ident1+" data-ident2="+ident2+" data-index=\""+this.NbItems+"\" data-item=\""+label+"\" data-sublabel=\""+subLabel+"\" onclick=\"XIM_CheckboxMenu.OnClick("+this.ID+", '"+idcItem+"')\" >";
		tmp +=					"</input>";
		// tmp +=					"<label class=\"form-check-label\" for=\""+idcItem+"\">"+label+"</label>";
		tmp +=					'<label id="'+idcLabel+'" class="form-check-label" for="'+idcItem+'">'+label+'</label>';
		tmp +=				"</div>";
		tmp +=				"</a>";
		
		li.innerHTML = tmp;
		
		idcList.appendChild ( li );
		
		this.NbItems++;
	}
	
	OnClick ( item )
	{
		let idcCB = document.getElementById ( item );
		
		let label 		= idcCB.dataset.item;
		let index 		= idcCB.dataset.index;
		let subLabel 	= idcCB.dataset.sublabel;
		
		if ( idcCB.checked )
		{
			this.SelectItem ( label, index, subLabel );
		}
		else
			this.UnselectItem ( index );
	}
	
	OnSelectButtonClicked ()
	{
		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcCBItem = this.Container + "_cb_" + i;
		
			// document.getElementById ( idcCBItem ).checked = true;
			let idcCB = document.getElementById ( idcCBItem );
			idcCB.checked = true;
			let label = idcCB.dataset.item;
			let index = idcCB.dataset.index;
			
			this.SelectItem ( label, index );
		}
	}

	OnTextChanged ()
	{
		let idcTextItem = this.Container + "_input";
		let idcText = document.getElementById ( idcTextItem );
			
		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcAItem = this.Container + "_a_" + i;
			let idcLabelItem = this.Container + "_label_" + i;
		
			let idcLabel = document.getElementById ( idcLabelItem );
			/*
			if ( idcLabel.innerText.includes (idcText.value ) == true )
				$('#'+idcAItem).show ();
			else
				$('#'+idcAItem).hide ();
			*/

			if ( idcLabel.innerText.match ( new RegExp( idcText.value, 'i')) )
				$('#'+idcAItem).show ();
			else
				$('#'+idcAItem).hide ();
		}
	}
	
	OnUnselectButtonClicked ()
	{
		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcCBItem = this.Container + "_cb_" + i;
		
			let idcCB = document.getElementById ( idcCBItem );
			idcCB.checked = false;
			let index = idcCB.dataset.index;
			
			this.UnselectItem ( index );
		}
	}
		
	SelectItem ( itemLabel, index, subLabel )
	{
		let idcButtonsContainer = this.Container + "_buttons_container";
		
		let idc = document.getElementById ( idcButtonsContainer );
		
		let div = document.createElement('div');
		div.setAttribute ( 'id', this.Container + '_button_' + index );
		div.classList.add( "ximeo_sol-selected-display-item" );
		div.dataset.index = index;
		/*
		let tmp = "";
		tmp +=				"<span class=\"ximeo_sol-quick-delete\" onclick=\"XIM_CheckboxMenu.UnselectItem("+this.ID+", '"+index+"')\">x</span>";
		tmp +=				"<span class=\"ximeo_sol-selected-display-item-text\">"+itemLabel+"</span>";
		*/

		let tmp = "";
		tmp += '<div class="row m-0 p-0 ps-1 pe-1">';

		tmp += 		'<div class="col-auto m-0 p-0 ps-1 pe-2">';
		if ( subLabel != 'undefined' )
		{
			tmp += 			'<div class="row m-0 p-0">';
			// tmp +=				"<span class=\"ximeo_sol-selected-display-item-text\">"+subLabel+"</span>";
			tmp +=				'<span class="m-0 p-0 fst-italic">'+subLabel+'</span>';
			tmp += 			'</div>';
		}
		tmp += 			'<div class="row m-0 p-0">';
		// tmp +=				"<span class=\"ximeo_sol-selected-display-item-text\">"+itemLabel+"</span>";
		tmp +=				'<span class="m-0 p-0 fw-bold">'+itemLabel+'</span>';
		tmp += 			'</div>';
		tmp += 		'</div>';

		tmp += 		'<div class="col m-0 p-0 ps-1">';
		// tmp +=			"<span class=\"ximeo_sol-quick-delete\" onclick=\"XIM_CheckboxMenu.UnselectItem("+this.ID+", '"+index+"')\">x</span>";
		tmp +=			'<span class="ximeo_sol-quick-delete" onclick="XIM_CheckboxMenu.UnselectItem('+this.ID+', '+index+')">x</span>';

		tmp += 		'</div>';

		tmp += '</div>';

		
		div.innerHTML = tmp;
		
		idc.appendChild ( div );

		this.SelectionChanged ();
	}
	
	UnselectItem ( index )
	{	
		let idcContainerDiv = this.Container + "_buttons_container";
		let idcButtonDiv 	= this.Container + '_button_' + index;

		let buttonToRemove = document.getElementById ( idcButtonDiv );

		if ( buttonToRemove != null )
			document.getElementById ( idcContainerDiv ).removeChild ( buttonToRemove );
		
		let idcCheckbox = this.Container + "_cb_" + index;
		$('#'+idcCheckbox).prop("checked", false );

		this.SelectionChanged ();
	}

	SelectionChanged ()
	{
		if ( this.CallbackFct != "" )
		{
			this.CallbackFct ();
		}
	}

	GetElementsList ()
	{
		let elements = [];

		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcItem = this.Container + "_cb_" + i;
			// if ( document.getElementById ( idcItem ).checked == true )
			{
				let ident1 = document.getElementById ( idcItem ).dataset.ident1;
				let ident2 = document.getElementById ( idcItem ).dataset.ident2;

				let elem = [];

				elem.push ( ident1 );
				elem.push ( ident2 );

				elements.push ( elem );
			}
		}

		return elements;
	}

	GetSelection ()
	{
		let selectedElements = [];

		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcItem = this.Container + "_cb_" + i;
			if ( document.getElementById ( idcItem ).checked == true )
			{
				let ident1 = document.getElementById ( idcItem ).dataset.ident1;
				let ident2 = document.getElementById ( idcItem ).dataset.ident2;

				let elem = [];

				elem.push ( ident1 );
				elem.push ( ident2 );

				selectedElements.push ( elem );
			}
		}

		return selectedElements;
	}

	
	GetSelection2 ()
	{
		let selectedElements = [];

		for ( let i=0; i<this.NbItems; i++ )
		{
			let idcItem = this.Container + "_cb_" + i;

			if ( document.getElementById ( idcItem ).checked == true )
			{
				let ident2 = document.getElementById ( idcItem ).dataset.ident2;

				let elem = [];

				elem.push ( ident2 );

				selectedElements.push ( elem );
			}
		}

		return selectedElements;
	}

	UnselectAll ()
	{	
		for ( let i=0; i<this.NbItems; i++ )
		{
			this.UnselectItem ( i );
		}
	}

	SelectElement ( elements )
	{
		for ( let i=0; i<elements.length; i++)
		{
			for ( let j=0; j<this.NbItems; j++ )
			{
				let idcCBItem = this.Container + "_cb_" + j;
		
				let idcCB = document.getElementById ( idcCBItem );
				
				let index = idcCB.dataset.index;
			
				if ( index == elements [i] )
				{
					idcCB.checked = true;

					let label 		= idcCB.dataset.item;
					let subLabel 	= idcCB.dataset.sublabel;

					this.SelectItem ( label, index, subLabel );
				}
			}
		}


	}

	SelectElementIdent2 ( elements )
	{
		for ( let i=0; i<elements.length; i++)
		{
			for ( let j=0; j<this.NbItems; j++ )
			{
				let idcCBItem = this.Container + "_cb_" + j;
		
				let idcCB = document.getElementById ( idcCBItem );
				
				let ident2 = idcCB.dataset.ident2;
			
				if ( ident2 == elements [i] )
				{
					idcCB.checked = true;

					let label 		= idcCB.dataset.item;
					let index 		= idcCB.dataset.index;
					let subLabel 	= idcCB.dataset.sublabel;

					this.SelectItem ( label, index, subLabel );
				}
			}
		}


	}

	ClearAll ()
	{
		this.UnselectAll ();

		let idcList = document.getElementById ( this.Container + "_ul" );

		while ( idcList.hasChildNodes() )
		{
			idcList.removeChild ( idcList.firstChild );
		}

		this.NbItems = 0;
	}
}