
/*
function DocumentViewerShow ( caption ) 
{
    if ( caption != undefined )
      $('#IdcDocumentViewerCaption').text ( caption );

    $('#IdcDocumentViewer').modal('show');

  
    if ( !$(".modal.in").length ) 
    {
      $(".modal-dialog").css ( {
          top: 20,
          left: 100,
      });
    }

    $(".modal-dialog").draggable ( {
        cursor: "move",
        handle: ".dragable_touch",
    });
}
*/


function DocumentViewerShow ( caption, element, page, closedCallback, readingValidationCallback ) 
{
    console.log ( "DocumentViewerShow..." );
    console.log ( " readingValidationCallback : " + readingValidationCallback );

    if ( caption != undefined )
      $('#IdcDocumentViewerCaption').text ( caption );

    if ( closedCallback != undefined )
      document.getElementById ('IdcDocumentViewer').addEventListener ( 'hide.bs.modal', () => { closedCallback(); } );

    // $('#IdcDocumentViewerContent').width(1200);
    // $('#IdcDocumentViewerContent').css('left', -200);

    if ( page != null )
    {
        $('#IdcDocumentViewerDiv').hide ();
        $('#IdcDocumentViewerFrame').show ();

        document.getElementById ( 'IdcDocumentViewerFrame' ).src = page;
    }
    else
      if ( element != null )
      {
          $('#IdcDocumentViewerFrame').hide ();
          $('#IdcDocumentViewerDiv').show ();

          $('#IdcDocumentViewerDiv').append(element);
      }

      // const rdvCallback = readingValidationCallback.bind ( this );


      if ( readingValidationCallback != null )
      {
          $('#IdcDocumentViewer').on ('shown.bs.modal', function () 
          {
              const iframe = document.getElementById('IdcDocumentViewerFrame');
              if (iframe) 
              {
            iframe.addEventListener('load', function () 
            {
                const viewerContainer = iframe.contentWindow.document.getElementById('viewerContainer');
                if (viewerContainer) 
                {
                    const viewerDoc = iframe.contentWindow.document;
                    const floatingDiv = viewerDoc.createElement('div');
                    
                    Object.assign(floatingDiv.style, {
                        position: 'fixed',
                        bottom: '15px',
                        right: '20px',
                        background: '#DDD',
                        padding: '5px',
                        borderRadius: '5px',
                        zIndex: 9999
                    });

                    const btn = viewerDoc.createElement ( 'button');
                    btn.type = 'button';
                    btn.id    = 'IdcDocumentValidateButton';
                    btn.textContent = 'Valider la lecture du document';
                    btn.classList.add ('ximeo_button');
                    floatingDiv.appendChild ( btn );
                    btn.disabled = true;

                    viewerDoc.body.appendChild(floatingDiv);

                    if ( readingValidationCallback != undefined )
                    {
                        btn.addEventListener ( 'click', () => { readingValidationCallback (); } );
                    }

                    viewerContainer.addEventListener ('scroll', () => {
                      const scrollTop = viewerContainer.scrollTop;
                      const scrollHeight = viewerContainer.scrollHeight;
                      const clientHeight = viewerContainer.clientHeight;

                      if (scrollTop + clientHeight >= scrollHeight - 5) 
                      {                           
                          btn.disabled = false;      
                      }
                    });
                }
            });
              }
          });
      }


    $('#IdcDocumentViewer').modal('show');

    if ( !$(".modal.in").length ) 
    {
      $(".modal-dialog").css ( {
          top: 20,
          left: 100,
      });
    }

    $(".modal-dialog").draggable ( {
        cursor: "move",
        handle: ".dragable_touch",
    });


    $('#IdcDocumentViewer').css ( { top: 20,
      left: 20,});
}

function  SetDocumentViewerSize ( w, h )
{
    /*
    $('#IdcDocumentViewerContent').css (
      {
        width: w,
          height: h
      }); 
    */
}

function SetDocumentContent ( frame, url, readingValidationCallback )
{
    $('#'+frame).prop ( 'src', url );

    const iframe = document.getElementById ( frame );
    if ( iframe ) 
    {
        iframe.addEventListener('load', function () 
        {
            const viewerContainer = iframe.contentWindow.document.getElementById('viewerContainer');
            if (viewerContainer) 
            {
                const viewerDoc = iframe.contentWindow.document;

                let fdExist = viewerDoc.body.querySelector ( '.DVFloatingDiv' );
                if ( fdExist )
                    fdExist.remove ();

                if ( readingValidationCallback != null )
                {
                    const floatingDiv = viewerDoc.createElement('div');
                    floatingDiv.classList.add ('DVFloatingDiv');
                    
                    Object.assign(floatingDiv.style, {
                        position: 'fixed',
                        bottom: '15px',
                        right: '20px',
                        background: '#DDD',
                        padding: '5px',
                        borderRadius: '5px',
                        zIndex: 9999
                    });

                    const btn = viewerDoc.createElement ( 'button');
                    btn.type = 'button';
                    btn.id    = 'IdcDocumentValidateButton';
                    btn.textContent = 'Valider la lecture du document';
                    btn.classList.add ('ximeo_button');
                    floatingDiv.appendChild ( btn );
                    btn.disabled = true;

                    viewerDoc.body.appendChild(floatingDiv);

                    if ( readingValidationCallback != undefined )
                    {
                        btn.addEventListener ( 'click', () => { readingValidationCallback (); } );
                    }

                    viewerContainer.addEventListener ('scroll', () => {
                      const scrollTop = viewerContainer.scrollTop;
                      const scrollHeight = viewerContainer.scrollHeight;
                      const clientHeight = viewerContainer.clientHeight;

                      if (scrollTop + clientHeight >= scrollHeight - 5) 
                      {                           
                          btn.disabled = false;      
                      }
                    });
                  }
            }
        });
    }
}