function InitMainPage ()
{
	let mainInit = sessionStorage.getItem ( 'MainPageInitialized' );

	if ( mainInit == 'true' )
	{
		return;
	}

	sessionStorage.setItem ( 'MainPageInitialized', 					true  );
				
	sessionStorage.setItem ( 'DashboardPageInitialized', 				false );
	sessionStorage.setItem ( 'LegalDocumentPageInitialized', 			false );
	sessionStorage.setItem ( 'LegalDocumentWorkingPageInitialized',		false );
	sessionStorage.setItem ( 'InstitutionalDocumentPageInitialized', 	false );
	sessionStorage.setItem ( 'ProcedurePageInitialized', 				false );
	sessionStorage.setItem ( 'ProcedureWorkingPageInitialized',			false );
	sessionStorage.setItem ( 'ExamsListPageInitialized', 				false );
	sessionStorage.setItem ( 'ExamsListWorkingPageInitialized',			false );
	sessionStorage.setItem ( 'StaffPageInitialized', 					false );
	sessionStorage.setItem ( 'DevicePageInitialized', 					false );
	sessionStorage.setItem ( 'DosimetryPageInitialized',				false );
	sessionStorage.setItem ( 'IncidentPageInitialized',					false );
	sessionStorage.setItem ( 'AuditPageInitialized', 					false );
	sessionStorage.setItem ( 'StatisticPageInitialized',				false );
	sessionStorage.setItem ( 'TaskPageInitialized',						false );
	sessionStorage.setItem ( 'TaskWorkingPageInitialized',				false );
	sessionStorage.setItem ( 'SettingsPageInitialized',					false );
	sessionStorage.setItem ( 'SettingsStaffMemberPageInitialized',		false );
	sessionStorage.setItem ( 'SettingsJobRolePageInitialized',			false );
	sessionStorage.setItem ( 'SettingsLoginRolePageInitialized',		false );
	sessionStorage.setItem ( 'SettingsInstitutionPageInitialized',		false );
	sessionStorage.setItem ( 'SettingsTagPageInitialized',				false );
	sessionStorage.setItem ( 'SettingsWarningPageInitialized',			false );
	sessionStorage.setItem ( 'SettingsExamIdentPageInitialized',		false );
	sessionStorage.setItem ( 'SettingsExamLinkPageInitialized',			false );
	sessionStorage.setItem ( 'SettingsDocumentPageInitialized',			false );
	sessionStorage.setItem ( 'FastIncidentReportingPageInitialized',	false );
	sessionStorage.setItem ( 'AuthorizedAccessDlgInitialized',			false );
	sessionStorage.setItem ( 'SurveyPageInitialized',					false );
	sessionStorage.setItem ( 'AllDocumentsPageInitialized',				false );
	sessionStorage.setItem ( 'SettingsAuditStandardPageInitialized',	false );
							
	$(document).ready ( function () 
	{
		LeftTabs = new C_Tab ();

		LeftTabs.Ident 		= "IdcLeftTabs";
		LeftTabs.Container 	= "IdcLeftTabsContainer";

		console.log ( "G_UserAccess.VIEW_SCHEDULEDTASK : " + G_UserAccess.VIEW_SCHEDULEDTASK );
		console.log ( "G_UserAccess.VIEW_SCHEDULEDTASK_WORKING : " + G_UserAccess.VIEW_SCHEDULEDTASK_WORKING );

		if ( G_UserAccess.VIEW_DASHBOARD == 1 || G_UserAccess.VIEW_DASHBOARD_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_DASHBOARD', 				"Dashboard", 				"fas fa-fw fa-tachometer-alt fs-4", 		OnSelectDashboard 				);
		if ( G_UserAccess.VIEW_LEGALDOCUMENT == 1 || G_UserAccess.VIEW_LEGALDOCUMENT_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_LEGAL_DOCUMENT', 			"Legal document", 			"fas fa-fw fa-file-export fs-4", 			OnSelectLegalDocument 			);
		if ( G_UserAccess.VIEW_INSTITUTIONDOCUMENT == 1 || G_UserAccess.VIEW_INSTITUTION_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_INSTITUTIONAL_DOCUMENT', 	"Institutional document", 	"fas fa-fw fa-university fs-4",				OnSelectInstitutionalDocument 	);
		if ( G_UserAccess.VIEW_PROCEDURE == 1 || G_UserAccess.VIEW_PROCEDURE_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_PROCEDURE', 				"Procedures", 				"fas fa-fw fa-file-contract fs-4",			OnSelectProcedure	 			);
		if ( G_UserAccess.VIEW_EXAMLIST == 1 || G_UserAccess.VIEW_EXAMLIST_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_EXAMS_LIST', 				"Exams list",				"fas fa-fw fa-list-ol fs-4", 				OnSelectExamsList				);
		if ( G_UserAccess.VIEW_STAFF == 1 || G_UserAccess.VIEW_STAFF_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_STAFF', 					"Staff", 					"fa fa-fw fa-users fs-4",					OnSelectStaff	 				);
		if ( G_UserAccess.VIEW_DEVICE == 1 || G_UserAccess.VIEW_DEVICE_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_DEVICE', 					"Devices", 					"fa fa-fw fa-server fs-4",					OnSelectDevice	 				);
		if ( G_UserAccess.VIEW_DOSIMETRY == 1 || G_UserAccess.VIEW_DOSIMETRY_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_DOSIMETRY', 				"Dosimetry", 				"fas fa-fw fa-radiation fs-4",				OnSelectDosimetry 				);
		if ( G_UserAccess.VIEW_INCIDENTREPORTING == 1 || G_UserAccess.VIEW_INCIDENTREPORTING_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_INCIDENT_REPORTING', 		"Incident reporting",		"fas fa-fw fa-exclamation fs-4",			OnSelectIncident				);
		
		// if ( G_UserAccess.VIEW_SCHEDULEDTASK == 1 || G_UserAccess.VIEW_SCHEDULEDTASK_WORKING == 1 )
		// 	LeftTabs.AddTab ( 'VIEW_SCHEDULED_TASK', 			"Scheduled task",			"fas fa-fw fa-tasks fs-4",					OnSelectTask					);
		if ( G_UserAccess.VIEW_SCHEDULEDTASK == 1 )
		 	LeftTabs.AddTab ( 'VIEW_SCHEDULED_TASK', 			"Scheduled task",			"fas fa-fw fa-tasks fs-4",					OnSelectTask					);
		 if ( G_UserAccess.VIEW_SCHEDULEDTASK_WORKING == 1 )
		 	LeftTabs.AddTab ( 'VIEW_SCHEDULED_TASK_WORKING',	"Scheduled task working",	"fas fa-fw fa-tasks fs-4",					OnSelectTaskWorking				);
		
		if ( G_UserAccess.VIEW_AUDIT == 1 || G_UserAccess.VIEW_AUDIT_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_AUDIT', 					"Audit",					"fas fa-fw fa-thumbtack fs-4",				OnSelectAudit					);
		if ( G_UserAccess.VIEW_STATISTIC == 1 || G_UserAccess.VIEW_STATISTIC_WORKING == 1 )
			LeftTabs.AddTab ( 'VIEW_STATISTIC', 				"Statistic",				"fas fa-fw fa-chart-area fs-4",				OnSelectStatistic				);

		LeftTabs.AddTab ( 'VIEW_SURVEY',		 				"Surveys",					"fas fa-solid fa-list-ul fs-4",				OnSelectSurvey					);

		LeftTabs.AddTab ( 'VIEW_ALL_DOCUMENTS', 				"All documents",			"fas fa-solid fa-file-text fs-4",				OnSelectAllDocuments					);

		if ( G_UserAccess.VIEW_INSTITUTION == 1 && G_UserAccess.VIEW_LOGINROLE == 1 && G_UserAccess.VIEW_STAFF == 1 && G_UserAccess.VIEW_STAFFROLE == 1 && G_UserAccess.VIEW_TAG == 1 && G_UserAccess.VIEW_WARNING == 1 )
			LeftTabs.AddTab ( 'VIEW_SETTING', 					"Settings",					"fas fa-fw fa-cog fs-4",					OnSelectSettings				);

		LeftTabs.AddTab ( 'VIEW_FAST_INCIDENT_REPORTING',	"Incidents",				"fas fa-fw fa-exclamation-triangle fs-4",	OnSelectFastIncidentReporting, 		"rgb(242, 73, 61)", "rgb(242, 73, 61)"		);

		LeftTabs.Create ();

		UpdateAlertTabs ();

		SelectPage ( LeftTabs.GetFirstTabIdent () );

		InitTaskPage (); 

		switchLanguage ( CurrentLanguage );

	} );
}



function SelectPage ( id )
{
	if ( LeftTabs.SelectTab ( id ) == true )
	{
	}
	else
	{
		console.log ( "Error : bad left tab id !!!" );
	}
}


function HideAllPanels ()
{
	$('#IdcDivDashboard' ).hide ();
	$('#IdcDivLegalDocument' ).hide ();
	$('#IdcDivLegalDocumentWorking' ).hide ();
	$('#IdcDivInstitutionalDocument' ).hide ();
	$('#IdcDivProcedure' ).hide ();
	$('#IdcDivProcedureWorking' ).hide ();
	$('#IdcDivExamsList' ).hide ();
	$('#IdcDivExamsListWorking' ).hide ();
	$('#IdcDivStaff' ).hide ();
	$('#IdcDivDevice' ).hide ();
	$('#IdcDivDosimetry' ).hide ();
	$('#IdcDivIncident' ).hide ();
	$('#IdcDivTask' ).hide ();
	$('#IdcDivTaskWorking').hide ();
	$('#IdcDivAudit' ).hide ();
	$('#IdcDivSurvey' ).hide ();
	$('#IdcDivAllDocuments' ).hide ();
	$('#IdcDivStatisticContainer' ).hide ();
	$('#IdcDivSettings' ).hide ();
	$('#IdcDivFastIncidentReporting' ).hide ();
}

function OnSelectDashboard ()
{
	HideAllPanels ();

	RenderPage ( "SubFW/html/Dashboard.php", "IdcDivDashboard" );

	$('#IdcDivDashboard' ).show ();
}

function OnSelectLegalDocument ()
{
	HideAllPanels ();

	if ( G_UserAccess.VIEW_LEGALDOCUMENT_WORKING == 1  )
	{
		$('#IdcDivLegalDocumentWorking' ).show ();
		InitLegalDocumentWorkingPage ();	
	}
	else
	{
		if ( G_UserAccess.VIEW_LEGALDOCUMENT == 1  )
		{
			$('#IdcDivLegalDocument' ).show ();
			InitLegalDocumentPage ();	
		}
	}
}

function OnSelectInstitutionalDocument ()
{
	HideAllPanels ();

	$('#IdcDivInstitutionalDocument' ).show ();
	InitInstitutionalDocumentPage ();
}

function OnSelectProcedure ()
{
	console.log ( "OnSelectProcedure...");

	HideAllPanels ();

	if ( G_UserAccess.VIEW_PROCEDURE_WORKING == 1  )
	{
		$('#IdcDivProcedureWorking' ).show ();
		InitProcedureWorkingPage ();	
	}
	else
	{
		if ( G_UserAccess.VIEW_PROCEDURE == 1  )
		{
			$('#IdcDivProcedure' ).show ();
			InitProcedurePage ();
		}
	}
}

function OnSelectExamsList ()
{
	HideAllPanels ();

	if ( G_UserAccess.VIEW_EXAMLIST_WORKING == 1  )
	{
		$('#IdcDivExamsListWorking' ).show ();
		InitExamsListWorkingPage ();		
	}
	else
	{
		if ( G_UserAccess.VIEW_EXAMLIST == 1 )
		{
			$('#IdcDivExamsList' ).show ();
			InitExamsListPage ();		
		}
	}
}

function OnSelectStaff ()
{
	HideAllPanels ();

	$('#IdcDivStaff' ).show ();

	InitStaffPage ();
}


function OnSelectDevice ()
{
	HideAllPanels ();
	
	$('#IdcDivDevice' ).show ();

	InitDevicePage ();
}

function OnSelectDosimetry ()
{
	HideAllPanels ();
	
	$('#IdcDivDosimetry' ).show ();

	InitDosimetryPage ();
}

function OnSelectIncident ()
{
	HideAllPanels ();
	
	$('#IdcDivIncident' ).show ();

	InitIncidentPage ();
}

function OnSelectAudit ()
{
	HideAllPanels ();
	
	$('#IdcDivAudit' ).show ();

	InitAuditPage ();
}

function OnSelectStatistic ()
{
	HideAllPanels ();
	
	RenderPage ( "SubFW/html/Statistic.php", "IdcDivStatisticContainer" );

	$('#IdcDivStatisticContainer' ).show ();
}

function OnSelectSurvey ()
{
	HideAllPanels ();

	$('#IdcDivSurvey' ).show ();

	InitSurveyPage ();
}

function OnSelectAllDocuments ()
{
	HideAllPanels ();

	$('#IdcDivAllDocuments' ).show ();

	InitAllDocumentsPage ();
}

/*
function OnSelectTask ()
{
	console.log ( "OnSelectTask...");

	HideAllPanels ();

	if ( G_UserAccess.VIEW_SCHEDULEDTASK_WORKING == 1  )
	{
		$('#IdcDivTaskWorking' ).show ();
		InitTaskWorkingPage ();	
	}
	else
	{
		if ( G_UserAccess.VIEW_SCHEDULEDTASK == 1  )
		{
			$('#IdcDivTask' ).show ();
			InitTaskPage ();
		}
	}
}
*/

function OnSelectTask ()
{
	console.log ( "OnSelectTask...");

	HideAllPanels ();

	$('#IdcDivTask' ).show ();
	InitTaskPage ();
}

function OnSelectTaskWorking ()
{
	console.log ( "OnSelectTaskWorking...");

	HideAllPanels ();

	$('#IdcDivTaskWorking' ).show ();
	InitTaskWorkingPage ();	
}

function OnSelectSettings ()
{
	// IdcTaskDT.SetColumnVisibility ( 5, true );

	HideAllPanels ();
	
	$('#IdcDivSettings' ).show ();

	InitSettingsPage ();
}

function OnSelectFastIncidentReporting ()
{
	HideAllPanels ();
	
	$('#IdcDivFastIncidentReporting' ).show ();

	InitFastIncidentReportingPage ();
}


function OnUpdateAlertStaff ( data )
{
	LeftTabs.SetAlert ( 'VIEW_STAFF', JSON.parse ( data ).Alert );
}

function OnUpdateAlertDevice ( data )
{
	LeftTabs.SetAlert ( 'VIEW_DEVICE', JSON.parse ( data ).Alert );
}

function OnUpdateAlertDosimetry ( data )
{
	LeftTabs.SetAlert ( 'VIEW_DOSIMETRY', JSON.parse ( data ).Alert );
}

function OnUpdateAlertIncident ( data )
{
	LeftTabs.SetAlert ( 'VIEW_INCIDENT_REPORTING', JSON.parse ( data ).Alert );
}

function OnUpdateAlertScheduledTask ( data )
{
	LeftTabs.SetAlert ( 'VIEW_SCHEDULED_TASK', JSON.parse ( data ).Alert );
}

function OnUpdateAlertAudit ( data )
{
	LeftTabs.SetAlert ( 'VIEW_AUDIT', JSON.parse ( data ).Alert );
}

function OnUpdateAlertError ()
{
	console.log ( "OnUpdateAlertError..." );
}


function UpdateAlertTabs ()
{
	PostASyncData ( "SubFW/database/GetAlert.php", "tab=VIEW_DEVICE", 			'application/x-www-form-urlencoded', 	OnUpdateAlertDevice, 		OnUpdateAlertError );
	PostASyncData ( "SubFW/database/GetAlert.php", "tab=VIEW_STAFF", 			'application/x-www-form-urlencoded', 	OnUpdateAlertStaff, 		OnUpdateAlertError );
	PostASyncData ( "SubFW/database/GetAlert.php", "tab=VIEW_DOSIMETRY",		'application/x-www-form-urlencoded', 	OnUpdateAlertDosimetry, 	OnUpdateAlertError );
	PostASyncData ( "SubFW/database/GetAlert.php", "tab=VIEW_INCIDENTREPORTING",'application/x-www-form-urlencoded', 	OnUpdateAlertIncident, 		OnUpdateAlertError );
	PostASyncData ( "SubFW/database/GetAlert.php", "tab=VIEW_SCHEDULEDTASK",	'application/x-www-form-urlencoded', 	OnUpdateAlertScheduledTask, OnUpdateAlertError );
	PostASyncData ( "SubFW/database/GetAlert.php", "tab=VIEW_AUDIT",			'application/x-www-form-urlencoded', 	OnUpdateAlertAudit, 		OnUpdateAlertError );
}
