

function InitAllDocumentsPage ()
{
	console.log ( "InitAllDocumentsPage..." );

	let ss = sessionStorage.getItem ( 'AllDocumentsPageInitialized' );

	if ( ss == 'true' )
		return;

	sessionStorage.setItem ( 'AllDocumentsPageInitialized', true );

	AllDocumentsListDTMenu = [
    	{        	header: ''    	},
		{
        	img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcAllDocumentsListDT.Properties (); }
    	}
	];

	IdcAllDocumentsListDT = new C_DataTable ();
	IdcAllDocumentsListDT.DataSrcType		= 0;
	IdcAllDocumentsListDT.Ident 			= 'IdcAllDocumentsListDT';
	IdcAllDocumentsListDT.Container 		= 'IdcAllDocumentsListDTContainer';
	IdcAllDocumentsListDT.DataSrc 			= G_ServerFolder+'/eoQUAL/SubFW/database/document/GetDTAllDocuments.php';
	IdcAllDocumentsListDT.DataFct			= AllDocumentsListDTGetData;
	IdcAllDocumentsListDT.DrawCallbackFct 	= AllDocumentsListDTDrawEnded;
	IdcAllDocumentsListDT.SetColReorder 	( true );
	IdcAllDocumentsListDT.OnSelectChanged	( AllDocumentListDTSelectChanged );
						
	IdcAllDocumentsListDT.AddColumn ( 'id',							'doc_id',	 			0, false,  0,  50, 		false, '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( 'ext_id',						'ext_id',	 			0, false,  1,  50, 		false, '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( 'status_id',					'status_id', 			0, false,  2,  50, 		false, '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( 'extension',					'extension', 			0, false,  3,  50, 		false, '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( '',							'shortcut',	 			0, true,   4,  50, 		false, 'text-center',	'', ADShortcut );
	IdcAllDocumentsListDT.AddColumn ( 'Document type',				'document_type',		1, true,   5, '15%', 	true,  '', 				'', Translate );
	IdcAllDocumentsListDT.AddColumn ( Translate('Department'),		'department_fullname',	1, true,   6, '35%', 	true,  '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( Translate('Element'),			'name', 				1, true,   7, '25%', 	true,  '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( Translate('Document name'),	'document_name', 		1, true,   8, '25%', 	true,  '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( Translate('Version label'),	'document_label', 		1, true,   9, '25%', 	true,  '', 				'' );
	IdcAllDocumentsListDT.AddColumn ( Translate('Rev.'),			'revision',				1, true,  10,  '5%', 	true,  'text-center',	'' );
	IdcAllDocumentsListDT.AddColumn ( Translate('Status'),			'status_name', 			1, true,  11, '10%', 	true,  '', 				'', Translate );
	IdcAllDocumentsListDT.AddColumn ( Translate('Date'),			'status_begdate',		1, true,  12, '10%', 	true,  'text-center', 	'', DBDate2StdDateFR );

	IdcAllDocumentsListDT.SetColumnFilter ( 'name', 		 '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcAllDocumentsNameFilter" class="form-control pt-0 pb-0" oninput="IdcAllDocumentsListDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
	IdcAllDocumentsListDT.SetColumnFilter ( 'document_type', '<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcAllDocumentsTypeFilter" aria-label="Default select example" onchange="IdcAllDocumentsListDT.Refresh();"><option value="-1">*</option></select></div>' );
	IdcAllDocumentsListDT.SetColumnFilter ( 'status_name', 	 '<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcAllDocumentsStatusFilter" aria-label="Default select example" onchange="IdcAllDocumentsListDT.Refresh();"><option value="-1">*</option></select></div>' );

	IdcAllDocumentsListDT.LoadUserCfg ( G_USE_ID );

	$(document).ready(function () 
		{
			IdcAllDocumentsSitesCBMenu = new C_CheckboxMenu ( "IdcAllDocumentsSitesContainer", "IdcAllDocumentsSitesCBMenu0", Translate("Click here to select institution/department") );
			IdcAllDocumentsSitesCBMenu.CallbackFct = AllDocumentsDepartmentsChanged;
			InitTagInstDepCBList ( IdcAllDocumentsSitesCBMenu );

			IdcAllDocumentsListDT.Create ();
			IdcAllDocumentsListDT.SetRowToSelect ( 'first_row' );
			context.attach ( '#IdcAllDocumentsListDT', 	AllDocumentsListDTMenu 	);

			FillDocumentTypeList 	( 'IdcAllDocumentsTypeFilter' );
			FillStatusList			( 'IdcAllDocumentsStatusFilter', 'document' );

			$('#IdcAllDocumentsListDT'+' tbody').on('click', '.C_AllDocumentsDT_View', function () 
			{
				/*
				let row = $(this).closest('tr');
				let id 			= $('#'+ident +'_DT').DataTable().row( row ).data().id;
				let label 		= $('#'+ident +'_DT').DataTable().row( row ).data().label;
				let name 		= $('#'+ident +'_DT').DataTable().row( row ).data().name;
				let revision	= $('#'+ident +'_DT').DataTable().row( row ).data().revision;
				let status_id	= $('#'+ident +'_DT').DataTable().row( row ).data().status_id;
				let extension	= $('#'+ident +'_DT').DataTable().row( row ).data().extension;			// pdf, docx
					
				onViewDocument ( id, label, name, revision, status_id, extension );
				*/

				let row = $(this).closest('tr');
				let doc_id 		= $('#IdcAllDocumentsListDT').DataTable().row( row ).data().doc_id;
				let status_id	= $('#IdcAllDocumentsListDT').DataTable().row( row ).data().status_id;
				let revision	= $('#IdcAllDocumentsListDT').DataTable().row( row ).data().revision;
				let name		= $('#IdcAllDocumentsListDT').DataTable().row( row ).data().name;
				let extension	= $('#IdcAllDocumentsListDT').DataTable().row( row ).data().extension;
				let label = "";

				console.log ( "View ("+doc_id+") !!!" );

				ADViewDocument ( doc_id, label, name, revision, status_id, 	extension );
			} );

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcAllDocumentsEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcAllDocumentsMainDiv").show ();
      				}
    			}
  			});
		});
}

function ADShortcut ()
{
	return '<img class=\"C_AllDocumentsDT_View imgclickable  pe-2\" title=\"'+Translate ( 'View' )+'\" src=\"'+G_ServerFolder+'/eoQUAL/SubFW/bmp/view_blue_48.png\" style=\"height: 18px; width: auto;\"></img>';
}

function AllDocumentsListDTGetData ( d )
{
	let name 		= $('#IdcAllDocumentsNameFilter').val ();
	let type 		= $('#IdcAllDocumentsTypeFilter :selected').val ();
	let status_id 	= $('#IdcAllDocumentsStatusFilter :selected').val ();
	let tags 		= retrieve_selectedtagid ( IdcAllDocumentsSitesCBMenu );

	d.taglist 		= tags.ids.toString();
	d.idtaglistand 	= tags.and.toString();	
	d.idtaglistor 	= tags.or.toString();

	d.name 			= name;

	d.type 			= type;
	d.status_id		= status_id;

	console.log ( "d.type : " + d.type );
	console.log ( "d.status_id : " + d.status_id );
	console.log ( "d.taglist : " + d.taglist );
	console.log ( "d.idtaglistand : " + d.idtaglistand );
	console.log ( "d.idtaglistor : " + d.idtaglisor );

	return $.extend( {}, d );
}



function ADViewDocument ( doc_id, label, name, revision, status_id, extension )
{
	console.log ( "ADViewDocument...");
	console.log ( " status_id : " + status_id );
	console.log ( " doc_id : " + doc_id );
	// this.DocID = doc_id;
	let caption = name + " - revision " + revision;

	if ( status_id == 10 && (extension=="docx" || extension=="xlsx") )	// Draft
	{
		ADDocumentEdition ( doc_id );
	}
	else
	{
		let url = G_ServerAddress + G_ServerFolder + "/PDFViewer/eoQUALPDFViewer.php?docid="+doc_id;
		// let readingValidation = this.OnDocumentReadingValidation.bind ( this );
		let readingValidation = false;
		DocumentViewerShow ( caption, null, url, null, readingValidation );
	}
}

function ADDocumentEdition ( doc_id )
{
	$("#IdcAllDocumentsMainDiv").hide ();
	$("#IdcAllDocumentsEditorFrame").show ();

	$('#IdcAllDocumentsEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
}

function AllDocumentsListDTDrawEnded ()
{

}

function AllDocumentListDTSelectChanged ()
{

}

function AllDocumentsDepartmentsChanged ()
{
	IdcAllDocumentsListDT.Refresh ();
}