	AuditDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnAuditDTGridProperties() }
		}
	];
	
	function OrigineValueToText ( origine )
	{
		let val = '';
		switch ( parseInt(origine))

		{
			case 0: 	val = Translate('Internal');			break;
			case 1: 	val = Translate('External');			break;
			case 2: 	val = Translate('Self-assessment');		break;
		}

		return val;
	}

	function FillAuditTypesList ( idSelect )
	{
		var xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				let idcSelect 		= document.getElementById ( idSelect );
				let reponse			= clean(xhra.responseXML.documentElement);
				let status		 	= reponse.getElementsByTagName ( 'audit_type' );
				
				for ( let i=0; i<status.length; i++ )
				{
					let id			= status.item (i).getAttribute ( "id" 	);
					let name		= status.item (i).getAttribute ( "name" );

					if ( id != -1 )
					{
						let option_elem = document.createElement('option');
  
						option_elem.value 		= id;
						option_elem.textContent = name;
  
						idcSelect.appendChild ( option_elem );				
					}
				}
			}
		};

		let url = "SubFW/database/audit/get_audit_types.php";
		xhra.open ('GET', url, false );
		xhra.send ();
	}

	function FillAuditSourcesList ( idSelect )
	{
		let idcSelect 		= document.getElementById ( idSelect );
				
		for ( let i=0; i< 3; i++ )
		{
			let option = document.createElement('option');

			option.value 		 = i;
			option.textContent = OrigineValueToText ( i );
  
			idcSelect.appendChild ( option );				
		}
	}

	function InitAuditPage ()
	{
		let ss = sessionStorage.getItem ( 'AuditPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'AuditPageInitialized', true );

		IdcAuditDT = new C_DataTable ();
		IdcAuditDT.DataSrcType		= 0;
		IdcAuditDT.Ident 			= 'IdcAuditDT';
		IdcAuditDT.Container 		= 'IdcAuditDTContainer';
		IdcAuditDT.DataSrc 			= 'SubFW/database/audit/GetAudits.php';
		IdcAuditDT.DataFct			= AuditDTGetData;
		IdcAuditDT.SetColReorder 	( true );
		IdcAuditDT.OnSelectChanged	( AuditDTSelectChanged 	);
		IdcAuditDT.AddColumn ( 'id',			'afcnsend.id',	 			0, false,  0,    50, false, '', 				'' );
		IdcAuditDT.AddColumn ( 'Sta_id',		'status_id', 				0, false,  1,    50, true,  '', 				'' );
		IdcAuditDT.AddColumn ( 'Ins_id',		'inst_id',					0, false,  2,    50, true,  '', 				'' );
		IdcAuditDT.AddColumn ( 'Dep_id',		'dep_id',					0, false,  3,    50, true,  '', 				'' );
		IdcAuditDT.AddColumn ( 'Type',			'audit_type',				0, false,  4,    50, true,  '', 				'' );
		IdcAuditDT.AddColumn ( Translate('Date'),			'date',			 			1, true,   5, '10%', true,  '', 				'', DICOMDate2StdDateFR );
		IdcAuditDT.AddColumn ( Translate('Status'),			'status',	 				1, true,   6, '10%', true,  '', 				'' );
		IdcAuditDT.AddColumn ( Translate('Institution'),	'institution',				1, true,   7, '10%', true,  '', 				'' );
		IdcAuditDT.AddColumn ( Translate('Department'),		'department',				1, true,   8, '15%', true,  '', 				'' );
		// IdcAuditDT.AddColumn ( Translate('Device'),			'device',					1, true,   9, '10%', true,  '', 				'' );
		IdcAuditDT.AddColumn ( Translate('Title'),			'title',					1, true,  9, '15%', true,  '', 				'' );
		IdcAuditDT.AddColumn ( Translate('Origin'),			'origine',					1, true,  10, '15%', true,  '', 				'', OrigineValueToText );
		IdcAuditDT.AddColumn ( Translate('Comment'),		'comment',					1, true,  11, '15%', true,  '', 				'' );
		IdcAuditDT.AddColumn ( Translate('Start date'),		'start_date',				1, true,  12, '15%', true,  '', 				'', DICOMDate2StdDateFR  );
		IdcAuditDT.AddColumn ( Translate('End date'),		'end_date',					1, true,  13, '15%', true,  '', 				'', DICOMDate2StdDateFR  );
		IdcAuditDT.LoadUserCfg ( G_USE_ID );

		IdcAuditDocListDT			= new C_DocumentDT ( "IdcAuditDocListDT" );
		IdcAuditDocListDT.Caption  	= 'Document';
		IdcAuditDocListDT.DocType	= "audit";
		IdcAuditDocListDT.ExtType	= "audit";
		IdcAuditDocListDT.Container	= 'IdcAuditDocListDTContainer';
		IdcAuditDocListDT.Editor	= AuditEdition;
		IdcAuditDocListDT.LoadUserCfg ( G_USE_ID );


		$(document).ready(function () 
		{
			IdcAuditSplitter1_2 	= new C_Splitter ( "IdcAuditSplitter1_2" );
			IdcAuditSplitter3_4 	= new C_Splitter ( "IdcAuditSplitter3_4" );

			IdcAuditSplitter1_2.LoadUserCfg		( G_USE_ID );
			IdcAuditSplitter3_4.LoadUserCfg		( G_USE_ID );

			IdcAuditDT.Create ();
			context.attach ( '#IdcAuditDT', AuditDTListMenu );
			IdcAuditDT.SetRowToSelect('first_row');

			IdcAuditDocListDT.Create ();

			FillStatusList 			( 'IdcAuditStatus', 	 'audit');
			FillInstitutionsList 	( 'IdcAuditInstitution' );
			FillAuditSourcesList	( 'IdcAuditSource' );
			FillAuditTypesList		( 'IdcAuditType' );

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcAuditEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; 
        				$("#IdcAuditSplitter1_2").show ();
      				}
    			}
  			});

			switchLanguage ( CurrentLanguage );
		});
	}

	function AuditEdition ( doc_id )
	{
		$("#IdcAuditSplitter1_2").hide ();
		$("#IdcAuditEditorFrame").show ();

		$('#IdcAuditEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}

	function AuditDTGetData ( d )
	{
		d.fromdate  = '01/01/1999';
		d.todate 	= '31/12/2025';
		
		return $.extend( {}, d );
	}
	
	function OnAuditDTGridProperties ()
	{
		IdcAuditDT.Properties ();
	}

	function AuditDTSelectChanged ( rowsIdx )
	{
		let id 			= -1;
		let ins_id		= -1;
		let dep_id		= -1;
		let type		= -1;
		let title		= '';
		let comment		= '';
		let status_id	= -1;
		let date		= '';
		let start_date	= '';
		let end_date	= '';
		let source 		= -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= $('#IdcAuditDT').DataTable().row( rowIdx ).data().id;
			ins_id		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().inst_id;
			dep_id		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().dep_id;
			type		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().audit_type;
			title		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().title;
			comment		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().comment;
			status_id	= $('#IdcAuditDT').DataTable().row( rowIdx ).data().status_id;
			date		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().date;
			start_date	= $('#IdcAuditDT').DataTable().row( rowIdx ).data().start_date;
			end_date	= $('#IdcAuditDT').DataTable().row( rowIdx ).data().end_date;
			source 		= $('#IdcAuditDT').DataTable().row( rowIdx ).data().origine;
		}

		$('#IdcDivAudit' ).data ('id', id );
			
		$('#IdcAuditInstitution' ).val 	( ins_id ).change();
		$('#IdcAuditType' ).val 		( type ).change();
		$('#IdcAuditTitle' ).val 		( title );
		$('#IdcAuditComment' ).val 		( comment );
		$('#IdcAuditStatus' ).val 		( status_id ).change();
		$('#IdcAuditDate' ).val 		( DICOMDate2StdDate(date) );
		$('#IdcAuditStartDate' ).val 	( DICOMDate2StdDate(start_date) );
		$('#IdcAuditEndDate' ).val 		( DICOMDate2StdDate(end_date) );
		
		FillDepartmentsList ( 'IdcAuditDepartment', ins_id );
		$('#IdcAuditDepartment' ).val ( dep_id ).change();

		$('#IdcAuditSource').val ( source ).change();

		IdcAuditDocListDT.ExtID = id;
		IdcAuditDocListDT.Refresh ();
	}

	
	function AuditInstitutionChanged ()
	{
		let ins_id = $('#IdcAuditInstitution' ).val ();

		FillDepartmentsList ( 'IdcAuditDepartment', ins_id );
	}

	function OnAuditOpen ()
	{
		let id = $('#IdcDivAudit' ).data ('id');

		window.open (
  			'SubFW/html/bquaadril.php?audit_id='+id,
  			'Audit' 
		);
	}


	function OnAuditAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcAuditDT.SetRowToSelect ( 'id', response );

			IdcAuditDT.Refresh ();
		}
		else
			OnAuditAddError ();
	}

	function OnAuditAddError ()
	{
		MsgWarning ( Translate("Unable to add audit !!!") );
	}

	function AuditAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		PostASyncData ( "SubFW/database/audit/SaveAudit.php", params, 'application/x-www-form-urlencoded', OnAuditAddOK, OnAuditAddError );
	}

	function AuditSave ()
	{
		console.log ( "AuditSave..." );
		 
		let id 	= $('#IdcDivAudit' ).data ('id');

		let inst_id 	= $('#IdcAuditInstitution' ).val ();
		let dep_id 		= $('#IdcAuditDepartment' ).val ();
		let comment		= $('#IdcAuditComment' ).val ();
		let title		= $('#IdcAuditTitle' ).val ();
		let date 		= $('#IdcAuditDate' ).val ();
		let start_date 	= $('#IdcAuditStartDate' ).val ();
		let end_date 	= $('#IdcAuditEndDate' ).val ();
		let audit_type 	= $('#IdcAuditType' ).val ();
		let status_id 	= $('#IdcAuditStatus' ).val ();
		let origine 	= $('#IdcAuditSource').val ();


		let params = "id=" + id;
		params += "&inst_id=" + inst_id;
		params += "&dep_id=" + dep_id;
		params += "&comment=" + comment;
		params += "&title=" + title;
		params += "&date=" + date;
		params += "&start_date=" + start_date;
		params += "&end_date=" + end_date;
		params += "&audit_type=" + audit_type;
		params += "&status_id=" + status_id;
		params += "&origine=" + origine;

		PostASyncData ( "SubFW/database/audit/SaveAudit.php", params, 'application/x-www-form-urlencoded', OnAuditAddOK, OnAuditAddError );
	}

	function OnDeleteAuditOK ( response )
	{
		if ( response != '-1')
			IdcAuditDT.Refresh ();
		else
			OnAuditError ();
	}

	function OnDeleteAuditError ()
	{
		MsgWarning ( Translate("Unable to delete audit !!!") );
	}

	function DeleteAudit ()
	{
		let selRows = IdcAuditDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcAuditDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/audit/DeleteAudit.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteAuditOK, OnDeleteAuditError );
		}
	}

	function AuditDelete ()
	{
		let selRows = IdcAuditDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			MsgYesNo ( Translate("Delete selected audit ?"), DeleteAudit );
		}
		else
		{
			MsgWarning ( Translate("No audit selected !!!") );
		}
	}