	

	let deviceImageFile 	= null;
	let CurrentDeviceType 	= -1;

	function InitDevicePage ()
	{
		let ss = sessionStorage.getItem ( 'DevicePageInitialized' );

		if ( ss == 'true' )
			return;

		DeviceListDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcDeviceListDT.Properties (); }
    	},
    	{
    	divider: true
    	},
    	{
    		img: G_ServerFolder+'/eoQUAL/SubFW/bmp/photo_album_blue.png',
			text: 'Equipment list...',
			action: function(e, selector) { OnDeviceListing() }
    	}
	];

	DeviceInstallationListDTMenu = [
    	{        	header: ''    	},
		{
        	img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcDeviceInstallationListDT.Properties (); }
    	}
	];

	DeviceInspectionListDTMenu = [
    	{        	header: ''    	},
		{
        	img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcDeviceInspectionListDT.Properties (); }
    	}
	];

	DeviceMaintenanceListDTMenu = [
    	{        	header: ''    	},
		{
        	img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcDeviceMaintenanceListDT.Properties (); }
    	}
	];
		
		sessionStorage.setItem ( 'DevicePageInitialized', true );

		IdcDeviceListDT = new C_DataTable ();
		IdcDeviceListDT.DataSrcType		= 0;
		IdcDeviceListDT.Ident 			= 'IdcDeviceListDT';
		IdcDeviceListDT.Container 		= 'IdcDeviceListDTContainer';
		IdcDeviceListDT.DataSrc 		= G_ServerFolder+'/eoQUAL/SubFW/database/device/GetDeviceList.php';
		IdcDeviceListDT.DataFct			= DeviceListDTGetData;
		IdcDeviceListDT.DrawCallbackFct = DeviceListDTDrawEnded;
		IdcDeviceListDT.SetColReorder 	( true );
		IdcDeviceListDT.OnSelectChanged	( DeviceListDTSelectChanged );
						
		IdcDeviceListDT.AddColumn ( 'id',						'id',	 			0, false,  0,  50, 		false, '', 				'' );
		IdcDeviceListDT.AddColumn ( 'ris',						'ris_name',			0, false,  1,  50, 		false, '', 				'' );
		IdcDeviceListDT.AddColumn ( 'pacs',						'pacs_name',		0, false,  2,  50, 		false, '', 				'' );
		IdcDeviceListDT.AddColumn ( 'dacs',						'dacs_name',		0, false,  3,  50, 		false, '', 				'' );
		IdcDeviceListDT.AddColumn ( 'type',						'type',				0, false,  4,  50, 		false, '', 				'' );
		IdcDeviceListDT.AddColumn ( Translate('Name'),			'name', 			1, true,   5, '15%', 	true,  '', 				'' );
		IdcDeviceListDT.AddColumn ( Translate('Brand'),			'brand',			1, true,   6, '15%', 	true,  '', 				'' );
		IdcDeviceListDT.AddColumn ( Translate('Model'),			'model',			1, true,   7, '15%', 	true,  '', 				'' );
		IdcDeviceListDT.AddColumn ( Translate('SN'),			'serialnumber',		1, true,   8, '15%',	true,  '', 				'' );
		IdcDeviceListDT.AddColumn ( Translate('Mod.'),			'modalitytype',		1, true,   9,  60, 		true,  'text-center', 	'' );
		IdcDeviceListDT.AddColumn ( Translate('Type'),			'typename',			1, true,  10, '15%',	true,  '', 				'', Translate );
		IdcDeviceListDT.AddColumn ( Translate('Institution'),	'institution_name',	1, true,  11, '40%', 	true,  '', 				'' );
		IdcDeviceListDT.AddColumn ( Translate('Department'),	'depname',	 		1, true,  12, '40%', 	true,  '', 				'' );
		IdcDeviceListDT.SetColumnFilter (  'name', 			'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcDeviceListNameFilter" class="form-control pt-0 pb-0" oninput="IdcDeviceListDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcDeviceListDT.SetColumnFilter (  'brand', 		'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcDeviceListBrandFilter" class="form-control pt-0 pb-0" oninput="IdcDeviceListDT.Refresh()" type="text" placeholder="'+Translate("Brand")+'"></div>' );
		IdcDeviceListDT.SetColumnFilter (  'modalitytype', 	'<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcDeviceListModTypeFilter" class="form-control pt-0 pb-0" oninput="IdcDeviceListDT.Refresh()" type="text" placeholder="'+Translate("Modality")+'"></div>' );
		IdcDeviceListDT.SetColumnFilter (  'typename', 		'<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcDeviceListTypeFilter" aria-label="Default select example" onchange="IdcDeviceListDT.Refresh();"><option value="-1">*</option></select></div>' );
		IdcDeviceListDT.LoadUserCfg ( G_USE_ID );

		IdcDeviceDescriptionDocListDT			= new C_DocumentDT ( "IdcDeviceDescriptionDocListDT" );
		IdcDeviceDescriptionDocListDT.Caption  	= Translate('Document');
		IdcDeviceDescriptionDocListDT.DocType	= "device";
		IdcDeviceDescriptionDocListDT.ExtType	= "device";
		IdcDeviceDescriptionDocListDT.Container	= 'IdcDeviceDescriptionDocListDTContainer';
		IdcDeviceDescriptionDocListDT.Editor	= DeviceEdition;
		IdcDeviceDescriptionDocListDT.LoadUserCfg ( G_USE_ID );


		IdcDeviceInstallationListDT = new C_DataTable ();
		IdcDeviceInstallationListDT.DataSrcType		= 0;
		IdcDeviceInstallationListDT.Ident 			= 'IdcDeviceInstallationListDT';
		IdcDeviceInstallationListDT.Container 		= 'IdcDeviceInstallationListDTContainer';
		IdcDeviceInstallationListDT.DataSrc 		= G_ServerFolder+'/eoQUAL/SubFW/database/device/GetDeviceInstallationList.php';
		IdcDeviceInstallationListDT.DataFct			= DeviceInstallationListDTGetData;
		IdcDeviceInstallationListDT.DrawCallbackFct = DeviceInstallationListDTDrawEnded;
		IdcDeviceInstallationListDT.SetColReorder 	( true );
		IdcDeviceInstallationListDT.OnSelectChanged	( DeviceInstallationListDTSelectChanged );
		IdcDeviceInstallationListDT.AddColumn ( 'id',						'id',	 			0, false,  0,    50,	false, '', 				'' );
		IdcDeviceInstallationListDT.AddColumn ( 'dep_id',					'dep_id', 			0, false,  1,    50, 	true, '', 				'' );
		IdcDeviceInstallationListDT.AddColumn ( Translate('Department'),	'department', 		1, true,   2, '20%', 	true,  '', 				'' );
		IdcDeviceInstallationListDT.AddColumn ( Translate('From'),			'installdate',		1, true,   3, '15%', 	true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcDeviceInstallationListDT.AddColumn ( Translate('Until'),			'removeddate',		1, true,   4, '15%', 	true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcDeviceInstallationListDT.AddColumn ( Translate('Installed by'),	'installedby',		1, true,   5, '25%', 	true,  '', 				'' );		
		IdcDeviceInstallationListDT.AddColumn ( Translate('In charge of'),	'inchargeof',		1, false,   6, '25%', 	true,  '', 				'' );		
		IdcDeviceInstallationListDT.AddColumn ( Translate('Comment'),		'comment',			1, false,   7, '50%', 	true, '', 				'' );		
		IdcDeviceInstallationListDT.LoadUserCfg ( G_USE_ID );

		IdcDeviceInstallationDocListDT				= new C_DocumentDT ( "IdcDeviceInstallationDocListDT" );
		IdcDeviceInstallationDocListDT.Caption  	= Translate('Document');
		IdcDeviceInstallationDocListDT.ExtType		= "device_installation";
		IdcDeviceInstallationDocListDT.DocType		= "device_installation";
		IdcDeviceInstallationDocListDT.Container	= 'IdcDeviceInstallationDocListDTContainer';
		IdcDeviceInstallationDocListDT.Editor		= DeviceEdition;
		IdcDeviceInstallationDocListDT.LoadUserCfg ( G_USE_ID );




		IdcDeviceInspectionListDT = new C_DataTable ();
		IdcDeviceInspectionListDT.DataSrcType		= 0;
		IdcDeviceInspectionListDT.Ident 			= 'IdcDeviceInspectionListDT';
		IdcDeviceInspectionListDT.Container 		= 'IdcDeviceInspectionListDTContainer';
		IdcDeviceInspectionListDT.DataSrc 			= G_ServerFolder+'/eoQUAL/SubFW/database/device/GetDeviceInspectionList.php';
		IdcDeviceInspectionListDT.DataFct			= DeviceInspectionListDTGetData;
		IdcDeviceInspectionListDT.SetColReorder 	( true );
		IdcDeviceInspectionListDT.OnSelectChanged	( DeviceInspectionListDTSelectChanged );
		IdcDeviceInspectionListDT.AddColumn ( 'id',							'id',	 					0, false,   0,  50,		false, '', 				'' );
		IdcDeviceInspectionListDT.AddColumn ( 'Status',						'status_id',				0, false,   1,  50, 	false, '', 				'' );		
		IdcDeviceInspectionListDT.AddColumn ( 'Result',						'result',					0, false,   2,  50, 	false, '', 				'' );		
		IdcDeviceInspectionListDT.AddColumn ( 'Comment',					'comment',					0, false,   3,  50, 	false, '', 				'' );		
		IdcDeviceInspectionListDT.AddColumn ( 'Actions',					'listofactiondescription',	0, false,   4,  50, 	false, '', 				'' );		
		IdcDeviceInspectionListDT.AddColumn ( Translate('Status'),			'status_name',				1, true,    5, '10%', 	 true, '', 				'' );		
		IdcDeviceInspectionListDT.AddColumn ( Translate('Planned-f'),		'planned_date',				1, true,   	6, '20%', 	 true, 'text-center', 	'', DICOMDate2StdDateFR );
		IdcDeviceInspectionListDT.AddColumn ( Translate('Performed-f'),		'inspection_date',			1, true,   	7, '20%', 	 true, 'text-center', 	'', DICOMDate2StdDateFR );
		IdcDeviceInspectionListDT.AddColumn ( Translate('Result'),			'result_name',				1, true,   	8, '20%', 	 true, '', 				'' );		
		IdcDeviceInspectionListDT.AddColumn ( Translate('Type'),			'type',						1, true,   	9, '30%', 	 true, '', 				'' );		
		IdcDeviceInspectionListDT.LoadUserCfg ( G_USE_ID );

		IdcDeviceInspectionDocListDT				= new C_DocumentDT ( "IdcDeviceInspectionDocListDT" );
		IdcDeviceInspectionDocListDT.Caption  		= 'Document';
		IdcDeviceInspectionDocListDT.ExtType		= "device_inspection";
		IdcDeviceInspectionDocListDT.DocType		= "device_inspection";
		IdcDeviceInspectionDocListDT.Container		= 'IdcDeviceInspectionDocListDTContainer';
		IdcDeviceInspectionDocListDT.Editor			= DeviceEdition;
		IdcDeviceInspectionDocListDT.LoadUserCfg ( G_USE_ID );


		IdcDeviceMaintenanceListDT = new C_DataTable ();
		IdcDeviceMaintenanceListDT.DataSrcType		= 0;
		IdcDeviceMaintenanceListDT.Ident 			= 'IdcDeviceMaintenanceListDT';
		IdcDeviceMaintenanceListDT.Container 		= 'IdcDeviceMaintenanceListDTContainer';
		IdcDeviceMaintenanceListDT.DataSrc 			= G_ServerFolder+'/eoQUAL/SubFW/database/device/GetDeviceMaintenanceList.php';
		IdcDeviceMaintenanceListDT.DataFct			= DeviceMaintenanceListDTGetData;
		IdcDeviceMaintenanceListDT.SetColReorder 	( true );
		IdcDeviceMaintenanceListDT.OnSelectChanged	( DeviceMaintenanceListDTSelectChanged );
		IdcDeviceMaintenanceListDT.AddColumn ( 'id',						'id',	 					0, false,   0,  50,		false, '', 	'' );
		IdcDeviceMaintenanceListDT.AddColumn ( 'Status',					'status_id',				0, false,   1,  50, 	false, '', 	'' );		
		IdcDeviceMaintenanceListDT.AddColumn ( 'Comment',					'comment',					0, false,   2,  50, 	false, '', 	'' );		
		IdcDeviceMaintenanceListDT.AddColumn ( Translate('Status'),			'status_name',				1, true,    3, '25%', 	true,  '',  '' );		
		IdcDeviceMaintenanceListDT.AddColumn ( Translate('Planned-f'),		'planned_date',				1, true,   	4, '25%', 	true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcDeviceMaintenanceListDT.AddColumn ( Translate('Performed-f'),	'maintenance_date',			1, true,   	5, '25%', 	true,  'text-center', 	'', DICOMDate2StdDateFR );
		IdcDeviceMaintenanceListDT.AddColumn ( Translate('Type'),			'type',						1, true,   	6, '25%', 	true,  '', 	'' );		
		IdcDeviceMaintenanceListDT.LoadUserCfg ( G_USE_ID );

		IdcDeviceMaintenanceDocListDT				= new C_DocumentDT ( "IdcDeviceMaintenanceDocListDT" );
		IdcDeviceMaintenanceDocListDT.Caption  		= Translate('Document');
		IdcDeviceMaintenanceDocListDT.ExtType		= "device_maintenance";
		IdcDeviceMaintenanceDocListDT.DocType		= "device_maintenance";
		IdcDeviceMaintenanceDocListDT.Container		= 'IdcDeviceMaintenanceDocListDTContainer';
		IdcDeviceMaintenanceDocListDT.Editor		= DeviceEdition;
		IdcDeviceMaintenanceDocListDT.LoadUserCfg ( G_USE_ID );
		


		$(document).ready(function () 
		{
			CurrentDeviceType 	= 0;	// Imaging modalities

			IdcDeviceSplitter1_2 				= new C_Splitter ( "IdcDeviceSplitter1_2" );
			IdcDeviceInstallationSplitter1_2 	= new C_Splitter ( "IdcDeviceInstallationSplitter1_2" );
			IdcDeviceInstallationSplitter3_4 	= new C_Splitter ( "IdcDeviceInstallationSplitter3_4" );
			IdcDeviceInspectionSplitter1_2 		= new C_Splitter ( "IdcDeviceInspectionSplitter1_2" );
			IdcDeviceInspectionSplitter3_4 		= new C_Splitter ( "IdcDeviceInspectionSplitter3_4" );
			IdcDeviceMaintenanceSplitter1_2 	= new C_Splitter ( "IdcDeviceMaintenanceSplitter1_2" );
			IdcDeviceMaintenanceSplitter3_4 	= new C_Splitter ( "IdcDeviceMaintenanceSplitter3_4" );

			IdcDeviceSplitter1_2.LoadUserCfg 				( G_USE_ID );
			IdcDeviceInstallationSplitter1_2.LoadUserCfg 	( G_USE_ID );
			IdcDeviceInstallationSplitter3_4.LoadUserCfg 	( G_USE_ID );
			IdcDeviceInspectionSplitter1_2.LoadUserCfg 		( G_USE_ID );
			IdcDeviceInspectionSplitter3_4.LoadUserCfg 		( G_USE_ID );
			IdcDeviceMaintenanceSplitter1_2.LoadUserCfg		( G_USE_ID );
			IdcDeviceMaintenanceSplitter3_4.LoadUserCfg		( G_USE_ID );


			IdcDeviceSitesCBMenu = new C_CheckboxMenu ( "IdcDeviceSitesContainer", "IdcDeviceSitesCBMenu0", Translate("Click here to select institution/department") );
			IdcDeviceSitesCBMenu.CallbackFct = DeviceDepartmentsChanged;
			InitTagInstDepCBList ( IdcDeviceSitesCBMenu );

			FillRISModalityList 	( 'IdcDeviceDescriptionRIS' );

			IdcDeviceListDT.Create ();
			context.attach ( '#IdcDeviceListDT', 	DeviceListDTMenu 	);
			IdcDeviceListDT.SetRowToSelect ( 'first_row' );
			

			IdcDeviceDescriptionDocListDT.Create ( 1 );

			// Installation
			IdcDeviceInstallationListDT.Create ();
			IdcDeviceInstallationListDT.SetRowToSelect ( 'first_row' );
			context.attach ( '#IdcDeviceInstallationListDT', 	DeviceInstallationListDTMenu 	);

			IdcDeviceInstallationDocListDT.Create ( 1 );

			// Inspection
			IdcDeviceInspectionListDT.Create ();
			IdcDeviceInspectionListDT.SetRowToSelect ( 'first_row' );
			context.attach ( '#IdcDeviceInspectionListDT', 	DeviceInspectionListDTMenu 	);

			IdcDeviceInspectionDocListDT.Create ( 1 );

			IdcDeviceMaintenanceListDT.Create ();
			IdcDeviceMaintenanceListDT.SetRowToSelect ( 'first_row' );
			context.attach ( '#IdcDeviceMaintenanceListDT', 	DeviceMaintenanceListDTMenu 	);
			IdcDeviceMaintenanceDocListDT.Create ( 1 );

			// Description
			FillDeviceTypeList ( 'IdcDeviceDescriptionType' );
			// FillDeviceTypeList ( 'IdcDeviceListTypeFilter');

			// Installation
			FillDepartmentsList ( 'IdcDeviceInstallationDepartment', -1 );

			// Inspection
			FillStatusList ( 'IdcDeviceInspectionStatus', 'device_inspection');
			FillStatusList ( 'IdcDeviceInspectionResult', 'device_inspection_result');

			// Maintenance
			FillStatusList ( 'IdcDeviceMaintenanceStatus', 'device_maintenance');


			document.getElementById ( 'IdcDeviceImage' ).addEventListener ( 'load', 
				function () 
				{ 
					$('#IdcDeviceImage').show ();
                	$('#IdcDeviceNoImage').hide (); 
                } );
			document.getElementById ( 'IdcDeviceImage' ).addEventListener ( 'error', 
				function () 
				{ 
					$('#IdcDeviceImage').hide ();
                	$('#IdcDeviceNoImage').show (); 
				} );

			const imageInput = document.getElementById('IdcDeviceImageInput');

        	imageInput.addEventListener('change', function(event) {
            const file = event.target.files[0]; // Récupère le premier fichier sélectionné

            if (file) 
            {
                const reader = new FileReader();

                reader.onload = function(e) {
                	$('#IdcDeviceImage').attr ( 'src', e.target.result );
             	};

             	reader.readAsDataURL(file);
             	deviceImageFile = file;
            }
            });

			document.getElementById ('IdcDeviceModalitiesTab' ).addEventListener 		( 'shown.bs.tab', () => { DeviceModalitiesTabShown (); } 		);
			document.getElementById ('IdcDeviceOtherDevicesTab' ).addEventListener 		( 'shown.bs.tab', () => { DeviceOtherDevicesTabShown (); } 		);

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcDeviceEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcDeviceSplitter1_2").show ();
      				}
    			}
  			});

  			$('#IdcDeviceTypeRow').hide ();

  			IdcDeviceListDT.SetColumnVisibility (   9, true );
  			IdcDeviceListDT.SetColumnVisibility (  10, false );

  			switchLanguage ( CurrentLanguage );

		});
	}

	function DeviceEdition ( doc_id )
	{
		$("#IdcDeviceSplitter1_2").hide ();
		$("#IdcDeviceEditorFrame").show ();

		$('#IdcDeviceEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}

	function DeviceListDTDrawEnded ( ident )
	{	
		let selRows = IdcDeviceListDT.GetSelectedRows ();

		DeviceListDTSelectChanged ( selRows );
	}

	function DeviceListDTGetData ( d ) 
	{
		let tags = retrieve_selectedtagid ( IdcDeviceSitesCBMenu );

		d.taglist 		= tags.ids.toString();
		d.idtaglistand 	= tags.and.toString();	
		d.idtaglistor 	= tags.or.toString();
		
		if ( CurrentDeviceType == 0 )	// Modality
		{
			d.type  	= 0;
			d.excluded 	= 0;
		}
		else
		{
			let type = $('#IdcDeviceListTypeFilter').val ();
			d.type  	= type;
			d.excluded	= 1;
		}
		d.name 			= $('#IdcDeviceListNameFilter').val ();
		d.brand 		= $('#IdcDeviceListBrandFilter').val ();
		d.modalitytype	= $('#IdcDeviceListModTypeFilter').val ();
		return $.extend( {}, d );
	}

	function DeviceInstallationListDTGetData ( d ) 
	{
		d.deviceid 		= $('#IdcDeviceInstallationPanel').data ('device_id' );;

		return $.extend( {}, d );
	}

	function DeviceDepartmentsChanged ()
	{
		IdcDeviceListDT.Refresh ();
	}

	function DeviceListDTSelectChanged ( rowsIdx )
	{
		let id 				= -1;
		let sn 				= "";
		let name 			= "";
		let department 		= "";
		let brand	 		= "";
		let model	 		= "";
		let modalitytype	= "";
		let type			= -1;
		let ris_name_id		= -1;
		let pacs_name_id	= -1;
		let dacs_name_id	= -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= IdcDeviceListDT.GetRowData ( rowIdx ).id;
			type			= IdcDeviceListDT.GetRowData ( rowIdx ).type;
			sn 				= IdcDeviceListDT.GetRowData ( rowIdx ).serialnumber;
			name 			= IdcDeviceListDT.GetRowData ( rowIdx ).name;
			department		= IdcDeviceListDT.GetRowData ( rowIdx ).depname;
			brand 			= IdcDeviceListDT.GetRowData ( rowIdx ).brand;
			model 			= IdcDeviceListDT.GetRowData ( rowIdx ).model;
			modalitytype	= IdcDeviceListDT.GetRowData ( rowIdx ).modalitytype;
			ris_name_id		= IdcDeviceListDT.GetRowData ( rowIdx ).ris_name;
			pacs_name_id	= IdcDeviceListDT.GetRowData ( rowIdx ).pacs_name;
			dacs_name_id	= IdcDeviceListDT.GetRowData ( rowIdx ).dacs_name;
		}

		$('#IdcDeviceDescriptionType' ).val ( type ).change ();
		$('#IdcDeviceDescriptionSN' ).val ( sn );
		$('#IdcDeviceDescriptionName' ).val ( name );
		$('#IdcDeviceDescriptionBrand' ).val ( brand );
		$('#IdcDeviceDescriptionModel' ).val ( model );
		$('#IdcDeviceDescriptionModality' ).val ( modalitytype ).change ();

		$('#IdcDeviceDescriptionRIS' ).val (ris_name_id).change ();

		$('#IdcDeviceDescriptionPanel' 	).data ('device_id', id );
		$('#IdcDeviceInstallationPanel'	).data ('device_id', id );
		$('#IdcDeviceMaintenancePanel'	).data ('device_id', id );
		$('#IdcDeviceInspectionPanel'	).data ('device_id', id );

		IdcDeviceInstallationListDT.SetRowToSelect ( 'first_row' );
		IdcDeviceInstallationListDT.Refresh ();

		IdcDeviceDescriptionDocListDT.ExtID = id;
		IdcDeviceDescriptionDocListDT.Refresh ();
		
		IdcDeviceInspectionListDT.SetRowToSelect ( 'first_row' );
		IdcDeviceInspectionListDT.Refresh ();
		
		IdcDeviceMaintenanceListDT.SetRowToSelect ( 'first_row' );
		IdcDeviceMaintenanceListDT.Refresh ();

		DeviveShowDeviceImage ();
	}

	function DeviveShowDeviceImage ()
	{
		let id = $('#IdcDeviceDescriptionPanel' 	).data ('device_id');
        $('#IdcDeviceImage').attr ( 'src', G_ServerFolder+"/eoQUAL/SubFW/database/device/get_device_image.php?id=" + id );
	}

	function DeviceAdd ()
	{
		const formData = new FormData();
        formData.append ( 'id', 			-1 					);
        formData.append ( 'type', 			CurrentDeviceType 	);

		PostASyncData ( G_ServerFolder+"/eoQUAL/SubFW/database/device/SaveDevice.php", formData, null, OnDeviceAddOK, OnDeviceAddError );
	}

	function DeviceDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/device/DeleteDevice.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No device selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected device ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete device !!!" );

		IdcDeviceListDT.DeleteSelectedRow ( data );
	}

	function DeviceDescriptionSave ()
	{
		let id 				= $('#IdcDeviceDescriptionPanel').data ('device_id');
		let type			= (CurrentDeviceType==0)? CurrentDeviceType : $('#IdcDeviceDescriptionType' ).val ();
		let serialnumber 	= $('#IdcDeviceDescriptionSN' ).val ();
		let name 			= $('#IdcDeviceDescriptionName' ).val ();
		let brand			= $('#IdcDeviceDescriptionBrand' ).val ();
		let model 			= $('#IdcDeviceDescriptionModel' ).val ();
		let modalitytype	= $('#IdcDeviceDescriptionModality' ).val ();
		let ris_name_id		= $('#IdcDeviceDescriptionRIS' ).val ();
		let pacs_name_id	= $('#IdcDeviceDescriptionPACS' ).val ();
		let dacs_name_id	= $('#IdcDeviceDescriptionDACS' ).val ();

		const formData = new FormData();
        formData.append ( 'image', 			deviceImageFile	);
        formData.append ( 'id', 			id 				);
        formData.append ( 'type', 			type			);
        formData.append ( 'name', 			name 			);
        formData.append ( 'brand',			brand 			);
        formData.append ( 'modalitytype',   modalitytype	);
        formData.append ( 'model',  	 	model			);
        formData.append ( 'serialnumber',	serialnumber	);
        formData.append ( 'ris_name', 		ris_name_id 	);
        formData.append ( 'pacs_name', 		pacs_name_id	);
        formData.append ( 'dacs_name', 		dacs_name_id	);

		PostASyncData ( "SubFW/database/device/SaveDevice.php", formData, null, OnDeviceAddOK, OnDeviceAddError );		
	}

	function OnDeviceAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcDeviceListDT.SetRowToSelect ( 'id', response );

			IdcDeviceListDT.Refresh ();
		}
		else
			OnDeviceAddError ();
	}

	function OnDeviceAddError ()
	{
		MsgWarning ( Translate("Unable to add device !!!") );
	}

	function DeviceActiveClicked ()
	{
		IdcDeviceListDT.Refresh ();
	}


	function DeviceInstallationListDTSelectChanged ( rowsIdx )
	{
		let id 			= "";
		let dep_id 		= "";
		let department	= "";
		let fromDate	= "";
		let untilDate	= "";
		let inChargeOf	= "";
		let installedBy	= "";
		let comment	

		if ( rowsIdx .length == 1 )	// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).id;
			dep_id 		= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).dep_id;
			department	= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).depname;
			fromDate	= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).installdate;
			untilDate	= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).removeddate;
			inChargeOf	= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).inchargeof;
			installedBy	= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).installedby;
			comment		= IdcDeviceInstallationListDT.GetRowData ( rowIdx ).comment;
		}

		$('#IdcDeviceInstallationDepartment').val (dep_id).change ();
		$('#IdcDeviceInstallationFrom').val (DICOMDate2StdDate(fromDate));
		$('#IdcDeviceInstallationUntil').val (DICOMDate2StdDate(untilDate));
		$('#IdcDeviceInstallationInChargeOf').val (inChargeOf);
		$('#IdcDeviceInstallationInstalledBy').val (installedBy);
		$('#IdcDeviceInstallationComment').val (comment);

		$('#IdcDeviceInstallationPanel'	).data ('device_installation_id', id );

		IdcDeviceInstallationDocListDT.ExtID = id;
		IdcDeviceInstallationDocListDT.Refresh ();
	}
	

	// =============================================================================
	// Save device Installation
	//

	function OnSaveDeviceInstallationOK ( response )
	{
		if ( response != '-1')
		{
			IdcDeviceInstallationListDT.SetRowToSelect ( 'id', response );

			IdcDeviceInstallationListDT.Refresh ();

			// IdcDeviceInstallationListDT.SelectRow ('123');
		}
		else
			OnSaveDeviceInstallationError ();
	}

	function OnSaveDeviceInstallationError ()
	{
		MsgWarning ( Translate("Unable to save device installation !!!") );
	}

	function DeviceInstallationAdd ()
	{
		let device_installation_id 	= -1;
		let device_id 				= $('#IdcDeviceInstallationPanel'	).data ('device_id');

		let params = "id=" + device_installation_id;
		params += "&device_id=" + device_id;
		PostASyncData ( "SubFW/database/device/SaveDeviceInstallation.php", params, 'application/x-www-form-urlencoded', OnSaveDeviceInstallationOK, OnSaveDeviceInstallationError );
	}

	function DeviceInstallationSave ()
	{
		let device_installation_id 	= $('#IdcDeviceInstallationPanel'	).data ('device_installation_id' );
		let dep_id					= $('#IdcDeviceInstallationDepartment').val ();
		let fromDate				= $('#IdcDeviceInstallationFrom').val ();
		let untilDate				= $('#IdcDeviceInstallationUntil').val ();
		let inChargeOf				= $('#IdcDeviceInstallationInChargeOf').val ();
		let installedBy				= $('#IdcDeviceInstallationInstalledBy').val ();
		let comment					= $('#IdcDeviceInstallationComment').val ();

		let params = "id=" + device_installation_id;
		params += "&dep_id=" + dep_id;
		params += "&installdate=" + fromDate;
		params += "&removeddate=" + untilDate;
		params += "&installedby=" + installedBy;
		params += "&inchargeof=" + inChargeOf;
		params += "&comment=" + comment;
		PostASyncData ( "SubFW/database/device/SaveDeviceInstallation.php", params, 'application/x-www-form-urlencoded', OnSaveDeviceInstallationOK, OnSaveDeviceInstallationError );
	}

	function OnDeleteDeviceInstallationOK ( response )
	{
		if ( response != '-1')
			IdcDeviceInstallationListDT.Refresh ();
		else
			OnDeleteDeviceInstallationError ();
	}

	function OnDeleteDeviceInstallationError ()
	{
		MsgWarning ( Translate("Unable to delete installation !!!") );
	}

	function DeleteDeviceInstallation ()
	{
		let selRows = IdcDeviceInstallationListDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcDeviceInstallationListDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/device/DeleteDeviceInstallation.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteDeviceInstallationOK, OnDeleteDeviceInstallationError );
		}
	}

	function DeviceInstallationDelete ()
	{
		let selRows = IdcDeviceInstallationListDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			MsgYesNo ( Translate("Delete selected installation ?"), DeleteDeviceInstallation );
		}
		else
		{
			MsgWarning ( Translate("No installation selected !!!") );
		}
	}


	function DeviceInstallationListDTDrawEnded ( ident )
	{
	}







	// =================================================================================================
	// Inspection

	function DeviceInspectionListDTGetData ( d ) 
	{
		d.deviceid 		= $('#IdcDeviceInstallationPanel'	).data ('device_id' );;

		return $.extend( {}, d );
	}

	function DeviceInspectionListDTSelectChanged ( rowsIdx )
	{
		let id 				= "";
		let plannedDate		= "";
		let performedDate	= "";
		let status			= "";
		let result			= "";
		let type 			= "";	
		let comment			= "";	
		let actions			= "";

		if ( rowsIdx.length == 1 )
		{
			let rowIdx = rowsIdx [0];

			id 				= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).id;
			plannedDate		= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).planned_date;
			performedDate	= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).inspection_date;
			status			= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).status_id;
			result			= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).result;
			type			= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).type;
			comment			= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).comment;
			actions			= IdcDeviceInspectionListDT.GetRowData ( rowIdx ).listofactiondescription;
		}		
	
		$('#IdcDeviceInspectionPlanned').val (DICOMDate2StdDate(plannedDate));
		$('#IdcDeviceInspectionPerformed').val (DICOMDate2StdDate(performedDate));
		$('#IdcDeviceInspectionStatus').val (status);
		$('#IdcDeviceInspectionResult').val (result);
		$('#IdcDeviceInspectionType').val (type);
		$('#IdcDeviceInspectionComment').val (comment);
		$('#IdcDeviceInspectionTasks').html ( actions );
		
		$('#IdcDeviceInspectionPanel'	).data ('device_inspection_id', id );

		IdcDeviceInspectionDocListDT.ExtID = id;
		IdcDeviceInspectionDocListDT.Refresh ();
	}

	function OnSaveDeviceInspectionOK ( response )
	{
		if ( response != '-1')
		{
			IdcDeviceInspectionListDT.SetRowToSelect ( 'id', response );

			IdcDeviceInspectionListDT.Refresh ();
		}
		else
			OnSaveDeviceInspectionError ();
	}

	function OnSaveDeviceInspectionError ()
	{
		MsgWarning ( Translate("Unable to save device inspection !!!") );
	}

	function DeviceInspectionAdd ()
	{
		let device_inspection_id 	= -1;
		let device_id 				= $('#IdcDeviceInstallationPanel'	).data ('device_id');

		let params = "id=" + device_inspection_id;
		params += "&device_id=" + device_id;
		PostASyncData ( "SubFW/database/device/SaveDeviceInspection.php", params, 'application/x-www-form-urlencoded', OnSaveDeviceInspectionOK, OnSaveDeviceInspectionError );
	}

	function DeviceInspectionSave ()
	{
		let device_inspection_id 	= $('#IdcDeviceInspectionPanel'	).data ('device_inspection_id' );
		let device_id 				= $('#IdcDeviceInspectionPanel'	).data ('device_id');
		let plannedDate				= $('#IdcDeviceInspectionPlanned').val ();
		let inspectionDate			= $('#IdcDeviceInspectionPerformed').val ();
		let status_id				= $('#IdcDeviceInspectionStatus').val ();
		let result 					= $('#IdcDeviceInspectionResult').val ();
		let type 					= $('#IdcDeviceInspectionType').val ();
		let comment 				= $('#IdcDeviceInspectionComment').val ();

		let params = "id=" + device_inspection_id;
		params += "&device_id=" + device_id;
		params += "&planned_date=" + plannedDate;
		params += "&inspection_date=" + inspectionDate;
		params += "&type=" + type;
		params += "&status_id=" + status_id;
		params += "&comment=" + comment;
		params += "&result=" + result;
		PostASyncData ( "SubFW/database/device/SaveDeviceInspection.php", params, 'application/x-www-form-urlencoded', OnSaveDeviceInspectionOK, OnSaveDeviceInspectionError );
	}

	function OnDeleteDeviceInspectionOK ( response )
	{
		if ( response != '-1')
			IdcDeviceInspectionListDT.Refresh ();
		else
			OnDeleteDeviceInspectionError ();
	}

	function DeviceInspectionTaskSelect ()
	{
		let device_inspection_id 	= $('#IdcDeviceInspectionPanel'	).data ('device_inspection_id' );

		SetTaskInfo ( 1, 'device_inspection', device_inspection_id );
		
		var element = $('#IdcDivTask').detach();

		DocumentViewerShow ( Translate ("Tasks"), element, null, OnDeviceInspectionCloseModalTask );
		IdcTaskDT.Refresh ();

		$('#IdcDivTask').show ();
	}

	function OnDeviceInspectionCloseModalTask ()
	{
		SetTaskInfo ( 0, '' );

		var element = $('#IdcDivTask').detach();
		$('#IdcMainContainer').append(element);

		let device_inspection_id 	= $('#IdcDeviceInspectionPanel'	).data ('device_inspection_id' );
		IdcDeviceInspectionListDT.SetRowToSelect ( 'id', device_inspection_id );
		IdcDeviceInspectionListDT.Refresh ();
	}






	// =================================================================================================
	// Maintenance

	function DeviceMaintenanceListDTGetData ( d ) 
	{
		d.deviceid 		= $('#IdcDeviceInstallationPanel'	).data ('device_id' );;

		return $.extend( {}, d );
	}

	function DeviceMaintenanceListDTSelectChanged ( rowsIdx )
	{
		let id 				= "";
		let plannedDate		= "";
		let performedDate	= "";
		let status			= "";
		let result			= "";
		let type 			= "";	
		let comment			= "";	
		let actions			= "";

		if ( rowsIdx.length == 1 )
		{
			let rowIdx = rowsIdx [0];

			id 				= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).id;
			plannedDate		= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).planned_date;
			performedDate	= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).maintenance_date;
			status			= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).status_id;
			result			= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).result;
			type			= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).type;
			comment			= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).comment;
			actions			= IdcDeviceMaintenanceListDT.GetRowData ( rowIdx ).listofactiondescription;
		}		
	
		$('#IdcDeviceMaintenancePlanned').val (DICOMDate2StdDate(plannedDate) );
		$('#IdcDeviceMaintenancePerformed').val (DICOMDate2StdDate(performedDate) );
		$('#IdcDeviceMaintenanceStatus').val (status);
		$('#IdcDeviceMaintenanceResult').val (result);
		$('#IdcDeviceMaintenanceType').val (type);
		$('#IdcDeviceMaintenanceComment').val (comment);
		$('#IdcDeviceMaintenanceActions').val (actions);
		
		$('#IdcDeviceMaintenancePanel'	).data ('device_maintenance_id', id );

		IdcDeviceMaintenanceDocListDT.ExtID = id;
		IdcDeviceMaintenanceDocListDT.Refresh ();
	}

	function OnSaveDeviceMaintenanceOK ( response )
	{
		if ( response != '-1')
		{
			IdcDeviceMaintenanceListDT.SetRowToSelect ( 'id', response );

			IdcDeviceMaintenanceListDT.Refresh ();
		}
		else
			OnSaveDeviceMaintenanceError ();
	}

	function OnSaveDeviceMaintenanceError ()
	{
		MsgWarning ( Translate("Unable to save device maintenance !!!") );
	}

	function DeviceMaintenanceAdd ()
	{
		let device_id 				= $('#IdcDeviceMaintenancePanel'	).data ('device_id');

		let params = "id=-1";
		params += "&device_id=" + device_id;
		PostASyncData ( "SubFW/database/device/SaveDeviceMaintenance.php", params, 'application/x-www-form-urlencoded', OnSaveDeviceMaintenanceOK, OnSaveDeviceMaintenanceError );
	}

	function DeviceMaintenanceDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/device/DeleteDeviceMaintenance.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No maintenance selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected maintenance ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete maintenance !!!" );

		IdcDeviceMaintenanceListDT.DeleteSelectedRow ( data );
	}


	function DeviceMaintenanceSave ()
	{
		let id 						= $('#IdcDeviceMaintenancePanel'	).data ('device_maintenance_id' );
		let device_id 				= $('#IdcDeviceMaintenancePanel'	).data ('device_id');

		
		let planned_date 		= $('#IdcDeviceMaintenancePlanned').val ();
		let maintenance_date 	= $('#IdcDeviceMaintenancePerformed').val ();
		let status_id			= $('#IdcDeviceMaintenanceStatus').val ();
		let type 				= $('#IdcDeviceMaintenanceType').val ();
		let comment 			= $('#IdcDeviceMaintenanceComment').val ();

		let params = "id=" + id;
		params += "&device_id=" + device_id;
		params += "&comment=" + comment;
		params += "&planned_date=" + planned_date;
		params += "&maintenance_date=" + maintenance_date;
		params += "&status_id=" + status_id;
		params += "&type=" + type;
		PostASyncData ( "SubFW/database/device/SaveDeviceMaintenance.php", params, 'application/x-www-form-urlencoded', OnSaveDeviceMaintenanceOK, OnSaveDeviceMaintenanceError );
	}


	function DeviceModalitiesTabShown ()
	{
		console.log ( "DeviceModalitiesTabShown..." );
		CurrentDeviceType = 0;	// Imaging modalities

		$('#IdcDeviceTypeRow').hide ();
		$('#IdcDeviceModalityTypeRow').show ();
		$('#IdcDeviceModalityIdentRow').show ();

		IdcDeviceListDT.SetColumnVisibility (  9, true );
		IdcDeviceListDT.SetColumnVisibility ( 10, false );
		IdcDeviceListDT.SetColumnTitle 		( 'modalitytype', Translate('Mod.') );
		IdcDeviceListDT.Refresh ();
	}

	function DeviceOtherDevicesTabShown ()
	{
		console.log ( "DeviceOtherDevicesTabShown..." );
		CurrentDeviceType = 1;	// Other devices

		IdcDeviceListDT.SetColumnVisibility (  9, false );
		IdcDeviceListDT.SetColumnVisibility ( 10, true );

		IdcDeviceListDT.SetRowToSelect ( 'first_row' );
		IdcDeviceListDT.Refresh ();
		
		$('#IdcDeviceTypeRow').show ();
		$('#IdcDeviceModalityTypeRow').hide ();
		$('#IdcDeviceModalityIdentRow').hide ();

		let nbOptions = $('#IdcDeviceListTypeFilter option').length;
		console.log ( "nbOptions : " + nbOptions );
		if ( nbOptions == '1' )
			FillDeviceTypeList ( 'IdcDeviceListTypeFilter');
	}



	function OnDeviceListing ()
	{
		EquipmentListingShow ();
	}