	DosimetryDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnDosimetryDTGridProperties() }
		}
	];
	
	function InitDosimetryPage ()
	{
		let ss = sessionStorage.getItem ( 'DosimetryPageInitialized' );
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'DosimetryPageInitialized', true );

		IdcDosimetryDT = new C_DataTable ();
		IdcDosimetryDT.DataSrcType		= 0;
		IdcDosimetryDT.Ident 			= 'IdcDosimetryDT';
		IdcDosimetryDT.Container 		= 'IdcDosimetryDTContainer';
		IdcDosimetryDT.DataSrc 			= 'SubFW/database/dosimetry/GetAFCNSendings.php';
		IdcDosimetryDT.DataFct			= DosimetryDTGetData;
		IdcDosimetryDT.SetColReorder 	( true );
		IdcDosimetryDT.OnSelectChanged	( DosimetryDTSelectChanged 	);
		IdcDosimetryDT.AddColumn ( 'id',						'afcnsend.id',	 			0, false,  0,    50, false, '', 				'' );
		IdcDosimetryDT.AddColumn ( 'Sta_id',					'status_id', 				0, false,  1,    50, true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( 'Ins_id',					'inst_id',					0, false,  2,    50, true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( 'Dep_id',					'dep_id',					0, false,  3,    50, true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( 'Dev_id',					'dev_id',					0, false,  4,    50, true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Date'),			'senddate',		 			1, true,   5, '10%', true,  '', 				'', DICOMDate2StdDateFR );
		IdcDosimetryDT.AddColumn ( Translate('Status'),			'status',	 				1, true,   6, '10%', true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Institution'),	'institution',				1, true,   7, '10%', true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Department'),		'department',				1, true,   8, '15%', true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Device'),			'device',					1, true,   9, '10%', true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Title'),			'title',					1, true,  10, '15%', true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Sender'),			'sender',					1, true,  11, '15%', true,  '', 				'' );
		IdcDosimetryDT.AddColumn ( Translate('Comment'),		'comment',					1, true,  12, '15%', true,  '', 				'' );
		IdcDosimetryDT.SetColumnFilter ( 5, '<div class="m-0 p-0 ps-2 pe-2"><input type="date" class="form-control for-control-sm m-0 p-0 ps-2 mb-2 fs-6" id ="IdcDosimetryDateFilter1" autocomplete="off" size="8" placeholder="From" onchange="IdcDosimetryDT.Refresh ();"><input type="date" class="form-control for-control-sm m-0 p-0 ps-2 fs-6" id ="IdcDosimetryDateFilter2" autocomplete="off" size="8" placeholder="To" onchange="IdcDosimetryDT.Refresh ();"></div>' );
		IdcDosimetryDT.SetColumnFilter ( 6, '<div class="m-0 p-0 ps-2 pe-2"><select class="form-select m-0 p-0 ps-2" id="IdcDosimetryStatusFilter" aria-label="Default select example" onchange="IdcDosimetryDT.Refresh();"><option value="-1">*</option></select></div>' );
		IdcDosimetryDT.LoadUserCfg ( G_USE_ID );

		IdcDosimetryFilesDT 			= new C_FileDT ( "IdcDosimetryFilesDT" );
		IdcDosimetryFilesDT.Caption  	= 'Files';
		IdcDosimetryFilesDT.DocType		= "afcnsend";
		IdcDosimetryFilesDT.Container	= 'IdcDosimetryFilesDTContainer';
		IdcDosimetryFilesDT.LoadUserCfg ( G_USE_ID );


		$(document).ready(function () 
		{
			IdcDosimetrySplitter1_2 	= new C_Splitter ( "IdcDosimetrySplitter1_2" );
			IdcDosimetrySplitter3_4 	= new C_Splitter ( "IdcDosimetrySplitter3_4" );

			IdcDosimetrySplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcDosimetrySplitter3_4.LoadUserCfg ( G_USE_ID );

			IdcDosimetryDT.Create ();
			context.attach ( '#IdcDosimetryDT', DosimetryDTListMenu );
			IdcDosimetryDT.SetRowToSelect('first_row');

			IdcDosimetryFilesDT.Create ();

			FillStatusList			( 'IdcDosimetryStatusFilter', 'audit' );

			FillStatusList 			( 'IdcDosimetryStatus', 	 'audit');
			FillInstitutionsList 	( 'IdcDosimetryInstitution' );

			switchLanguage ( CurrentLanguage );
		});
	}

	function DosimetryDTGetData ( d )
	{
		d.fromdate 	= $('#IdcDosimetryDateFilter1').val ();
		d.todate 	= $('#IdcDosimetryDateFilter2').val ();
		d.status_id = $('#IdcDosimetryStatusFilter :selected').val ();
		
		return $.extend( {}, d );
	}
	
	function OnDosimetryDTGridProperties ()
	{
		IdcDosimetryDT.Properties ();
	}

	function DosimetryDTSelectChanged ( rowsIdx )
	{
		let id 			= -1;
		let ins_id		= -1;
		let dep_id		= -1;
		let sender		= '';
		let title		= '';
		let comment		= '';
		let status_id	= -1;
		let date		= '';

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().id;
			ins_id		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().inst_id;
			dep_id		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().dep_id;
			dev_id		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().dev_id;
			sender		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().sender;
			title		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().title;
			comment		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().comment;
			status_id	= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().status_id;
			date		= $('#IdcDosimetryDT').DataTable().row( rowIdx ).data().senddate;
		}

		$('#IdcDivDosimetry' ).data ('id', id );
			
		$('#IdcDosimetryInstitution' ).val ( ins_id ).change();
		$('#IdcDosimetrySender' ).val 	( sender );
		$('#IdcDosimetryTitle' ).val 	( title );
		$('#IdcDosimetryComment' ).val 	( comment );
		$('#IdcDosimetryStatus' ).val 	( status_id ).change();
		$('#IdcDosimetryDate' ).val 	( DICOMDate2StdDate(date) );
		
		FillDepartmentsList ( 'IdcDosimetryDepartment', ins_id );
		$('#IdcDosimetryDepartment' ).val ( dep_id ).change();

		FillDevicesList ( 'IdcDosimetryDevice', dep_id );
		$('#IdcDosimetryDevice' ).val ( dev_id ).change();

		
		IdcDosimetryFilesDT.ExtID = id;
		IdcDosimetryFilesDT.Refresh ();
	}

	function DosimetryFilesListDTGetData ( d )
	{
		d.doctype 		= 'afcnsend';
		d.versioning	= 0;
		d.extid			= $('#IdcDivDosimetry' ).data ('id');

		return $.extend( {}, d );
	}

	function DosimetryInstitutionChanged ()
	{
		let ins_id = $('#IdcDosimetryInstitution' ).val ();

		FillDepartmentsList ( 'IdcDosimetryDepartment', ins_id );
	}

	function DosimetryDepartmentChanged ()
	{
		let dep_id = $('#IdcDosimetryDepartment' ).val ();

		FillDevicesList ( 'IdcDosimetryDevice', dep_id );
	}

	function DosimetryAddOK ( data )
	{
		IdcDosimetryDT.SetRowToSelect ( 'id', data.id );
		IdcDosimetryDT.Refresh ();
	}

	function DosimetryAddError ()
	{
		MsgWarning ( Translate("Unable to add sending !!!") );
	}

	function DosimetryAdd ()
	{
		let data = {};
		data['action']	= 'add';
		data['sender']	= G_USE_ID;

		var request = $.ajax ({
        		url: 		G_ServerFolder + "/eoQUAL/SubFW/database/dosimetry/Sending.php",
        		type: 		"post",
        		dataType: 	"json",
        		data: 		data
    			}
    	)
		.done ( DosimetryAddOK )
    	.fail ( DosimetryAddError );
	}

	function DosimetrySaveOK ( data )
	{
		IdcDosimetryDT.SetRowToSelect ( 'id', data.id );
		IdcDosimetryDT.Refresh ();
	}

	function DosimetrySaveError ()
	{
		MsgWarning ( Translate("Unable to add sending !!!") );
	}

	function DosimetrySave ()
	{
		let data = {};
		data['action']		= 'update';
		data['id']			= $('#IdcDivDosimetry' ).data ('id');;
		data['status_id']	= $('#IdcDosimetryStatus' ).val ();
		data['title']		= $('#IdcDosimetryTitle' ).val ();
		data['comment']		= $('#IdcDosimetryTitle' ).val ();
		data['inst_id']		= $('#IdcDosimetryInstitution' ).val ();
		data['dep_id']		= $('#IdcDosimetryDepartment' ).val ();
		data['device_id']	= $('#IdcDosimetryDevice' ).val ();
		data['send_date']	= $('#IdcDosimetryDate' ).val ();

		var request = $.ajax ({
        		url: 		G_ServerFolder + "/eoQUAL/SubFW/database/dosimetry/Sending.php",
        		type: 		"post",
        		dataType: 	"json",
        		data: 		data
    			}
    	)
		.done ( DosimetrySaveOK )
    	.fail ( DosimetrySaveError );
	}


	function DosimetryDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/dosimetry/DeleteSending.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No sending selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected sending ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete sending !!!" );

		IdcDosimetryDT.DeleteSelectedRow ( data );
	}