	ExamsListDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: 'SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcExamsListDT.Properties (); }
    	}
	];


	function InitExamsListPage ()	
	{
		let ss = sessionStorage.getItem ( 'ExamsListPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'ExamsListPageInitialized', true );

		IdcExamsListDT = new C_DataTable ();
		IdcExamsListDT.DataSrcType		= 0;
		IdcExamsListDT.Ident 			= 'IdcExamsListDT';
		IdcExamsListDT.Container 		= 'IdcExamsListDTContainer';
		IdcExamsListDT.DataSrc 			= 'SubFW/database/exams_list/GetDTExam.php';
		IdcExamsListDT.DataFct			= ExamsListDTGetData;
		IdcExamsListDT.SetColReorder 	( false );
		IdcExamsListDT.OnSelectChanged	( ExamsListDTSelectChanged 	);
		IdcExamsListDT.AddColumn ( 'id',			'id',	 					0, false,  0,  50, false, '', 				'' );
		IdcExamsListDT.AddColumn ( 'Name',			'nameid',	 				1, true,   1,  '50px', true,  '', 				'' );
		IdcExamsListDT.AddColumn ( 'Modality',		'modality', 				1, true,   2,  '20%', true,  'text-center', 	'' );
		IdcExamsListDT.AddColumn ( 'Description',	'description', 				1, true,   3,  '80%', true,  '', 				'' );
		IdcExamsListDT.AddColumn ( 'Warnings',		'riskv',	 				1, false,  4,  40, false, '', 				'' );
		IdcExamsListDT.AddColumn ( 'Tags',			'taglist',	 				1, false,  5,  40, false, '', 				'' );
		IdcExamsListDT.SetColumnEllipsis ( 1, true );
		IdcExamsListDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcExamsListNameFilter" class="form-control pt-0 pb-0" oninput="IdcExamsListDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcExamsListDT.LoadUserCfg ( G_USE_ID );


		// Procedure
		IdcExamsListDocListDT			= new C_DocumentDT ( "IdcExamsListDocListDT" );
		IdcExamsListDocListDT.Caption  	= 'Procedure';
		IdcExamsListDocListDT.OneOnly	= true;
		IdcExamsListDocListDT.ExtType	= "examlist";
		IdcExamsListDocListDT.DocType	= "examlist";
		IdcExamsListDocListDT.Container	= 'IdcExamsListDocListDTContainer';
		IdcExamsListDocListDT.Editor	= ExamEdition;
		IdcExamsListDocListDT.LoadUserCfg ( G_USE_ID );


		// Patient sheet
		IdcExamsListPSDocListDT				= new C_DocumentDT ( "IdcExamsListPSDocListDT" );
		IdcExamsListPSDocListDT.Caption  	= 'Patient sheet';
		IdcExamsListPSDocListDT.OneOnly  	= false;
		IdcExamsListPSDocListDT.ExtType		= "examlist";
		IdcExamsListPSDocListDT.DocType		= "examlist_otherdocument";
		IdcExamsListPSDocListDT.Container	= 'IdcExamsListPSDocListDTContainer';
		IdcExamsListPSDocListDT.Editor		= ExamEdition;
		IdcExamsListPSDocListDT.LoadUserCfg ( G_USE_ID );

		$(document).ready(function () 
		{
			IdcExamsListSplitter1_2 	= new C_Splitter ( "IdcExamsListSplitter1_2" );
			IdcExamsListSplitter3_4 	= new C_Splitter ( "IdcExamsListSplitter3_4" );
			IdcExamsListSplitter5_6 	= new C_Splitter ( "IdcExamsListSplitter5_6" );

			IdcExamsListSplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcExamsListSplitter3_4.LoadUserCfg ( G_USE_ID );
			IdcExamsListSplitter5_6.LoadUserCfg ( G_USE_ID );

			IdcExamsListSitesCBMenu = new C_CheckboxMenu ( "IdcExamsListSitesContainer", "IdcExamsListSitesCBMenu0", Translate("Click here to select institution/department") );
			IdcExamsListSitesCBMenu.CallbackFct = ExamsListDepartmentsChanged;

			IdcExamsListTagsCBMenu = new C_CheckboxMenu ( "IdcExamsListTagsContainer", "IdcExamsListTagsCBMenu0", Translate("Click here to select tags") );
			IdcExamsListTagsCBMenu.CallbackFct = ExamsListTagsChanged;

			InitTagInstDepCBList ( IdcExamsListSitesCBMenu );
			ExamsListInitTagsList 		 ( IdcExamsListTagsCBMenu 	);

			// ================================================================================
			// Details 

			IdcExamsListDetailSitesCBMenu = new C_CheckboxMenu ( "IdcExamsListDetailSitesContainer", "IdcExamsDetailListSitesCBMenu0", Translate("Click here to select institution/department") );
			IdcExamsListDetailSitesCBMenu.CallbackFct = ExamsListDetailDepartmentsChanged;

			IdcExamsListDetailWarningsCBMenu = new C_CheckboxMenu ( "IdcExamsListDetailWarningsContainer", "IdcExamsDetailListWarningsCBMenu0", Translate("Click here to select warnings") );
			IdcExamsListDetailWarningsCBMenu.CallbackFct = ExamsListDetailWarningsChanged;

			IdcExamsListDetailTagsCBMenu = new C_CheckboxMenu ( "IdcExamsListDetailTagsContainer", "IdcExamsDetailListTagsCBMenu0", Translate("Click here to select tags") );
			IdcExamsListDetailTagsCBMenu.CallbackFct = ExamsListDetailTagsChanged;

			InitTagInstDepCBList ( IdcExamsListDetailSitesCBMenu );
			ExamsListInitWarningsList	 ( IdcExamsListDetailWarningsCBMenu );
			ExamsListInitTagsList 		 ( IdcExamsListDetailTagsCBMenu 	);


			IdcExamsListDT.Create ();
			context.attach ( '#IdcExamsListDT', 	ExamsListDTMenu 	);
			IdcExamsListDT.SetRowToSelect('first_row');

			IdcExamsListDocListDT.Create ();	// Procedure

			IdcExamsListPSDocListDT.Create ();	// Patient sheet

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcExamsListEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none";
        				$("#IdcExamsListSplitter1_2").show ();
      				}
    			}
  			});


			switchLanguage ( CurrentLanguage );
		});
	}

	function ExamEdition ( doc_id )
	{
		console.log ( "ExamEdition..." );
		console.log ( " doc_id : " + doc_id );

		$("#IdcExamsListSplitter1_2").hide ();
		$("#IdcExamsListEditorFrame").show ();

		$('#IdcExamsListEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}


	function ExamsListDepartmentsChanged ()
	{
		IdcExamsListDT.Refresh ();
	}

	function ExamsListDetailDepartmentsChanged ()
	{
		IdcExamsListDetailSitesCBMenu.GetSelection ();
	}

	function ExamsListDetailWarningsChanged ()
	{
		IdcExamsListDetailWarningsCBMenu.GetSelection ();
	}

	function ExamsListDetailTagsChanged ()
	{
		IdcExamsListDetailTagsCBMenu.GetSelection ();
	}

	
	function ExamsListTagsChanged ()
	{
		// let selectedElements = IdcExamsListTagsCBMenu.GetSelection ();

		IdcExamsListDT.Refresh ();
	}

	function ExamsListInitTagsList ( cbElem )
	{
		let lastSeparator = "";
		
		var xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				let reponse		= clean(xhra.responseXML.documentElement);
				let tags	 	= reponse.getElementsByTagName ( 'tag' );
				
				for ( let i=0; i<tags.length; i++ )
				{
					let id			= tags.item (i).getAttribute ( "id" 	);
					let name		= tags.item (i).getAttribute ( "name" 	);
																	
					cbElem.AddItem ( -1, id, name );
				}
			}
		};

		let url = "SubFW/database/common/get_tags.php";
		xhra.open ('GET', url, false );
		xhra.send ();
	}

	function ExamsListInitWarningsList ( cbElem )
	{
		let lastSeparator = "";
		
		var xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				let reponse		= clean(xhra.responseXML.documentElement);
				let warnings 	= reponse.getElementsByTagName ( 'warning' );
				
				for ( let i=0; i<warnings.length; i++ )
				{
					let id			= warnings.item (i).getAttribute ( "id" 	);
					let name		= warnings.item (i).getAttribute ( "name" 	);
																	
					cbElem.AddItem ( -1, id, name );
				}
			}
		};

		let url = "SubFW/database/exams_list/get_warning.php";
		xhra.open ('GET', url, false );
		xhra.send ();
	}


	function ExamsListDTGetData ( d )
	{
		let tags = retrieve_selectedtagid ( IdcExamsListSitesCBMenu, IdcExamsListTagsCBMenu );

		d.taglist 		= tags.ids.toString();
		d.idtaglistand 	= tags.and.toString();	
		d.idtaglistor 	= tags.or.toString();
		d.name 			= $('#IdcExamsListNameFilter').val ();

		return $.extend( {}, d );
	}

	/*
	function retrieve_selectedtagid ( sol1, sol2 )
    {
    	let ret = {};
      	let idlist1 = ''; //nothing selected
      	let idlist2 = '';
      	let valueList = sol1.GetSelection2();

      	if(valueList.length)
        	idlist1 = valueList[0];

      	for ( var j = 1; j < valueList.length; j++ )
      	{
       	 	idlist1 += ','+valueList[j];
      	}

      	valueList = sol2.GetSelection2();
      	if(valueList.length)
        	idlist2 = valueList[0];
      	for(var j = 1; j < valueList.length; j++)
      	{
        	idlist2 += ','+valueList[j];
      	}

      	var taglistor = '';
      	if(idlist1 != '')
        	taglistor = '&idtaglistor=' + idlist1;
        ret ['or'] = idlist1;

      	if(idlist1 != '')
      	{
        	if(idlist2 != '')
          		idlist1 += ',';
      	}

      	var taglistand = '';
      	if(idlist2 != '')
         	taglistand = '&idtaglistand=' + idlist2;
        ret ['and'] = idlist2;

      	idlist1 += idlist2;

      	ret ['ids'] = idlist1;

      	return ret;
    }
    */

	function ExamsListDTSelectChanged ( rowsIdx )
	{
		IdcExamsListDetailSitesCBMenu.UnselectAll ();
		IdcExamsListDetailTagsCBMenu.UnselectAll ();
		IdcExamsListDetailWarningsCBMenu.UnselectAll ();
		
		let id 			= -1;
		let nameid 		= "";
		let modality	= "";
		let description	= "";
		let warnings	= "";
		let tags		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
		
			id 			= $('#IdcExamsListDT').DataTable().row( rowIdx ).data().id;
			nameid 		= $('#IdcExamsListDT').DataTable().row( rowIdx ).data().nameid;
			modality	= $('#IdcExamsListDT').DataTable().row( rowIdx ).data().modality;
			description	= $('#IdcExamsListDT').DataTable().row( rowIdx ).data().description;
			warnings	= $('#IdcExamsListDT').DataTable().row( rowIdx ).data().riskv;
			tags		= $('#IdcExamsListDT').DataTable().row( rowIdx ).data().taglist;
		}

		$('#IdcExamsListInformationsDiv').data ( 'id', id );
		$('#IdcExamName').val ( nameid );
		$('#IdcExamModality').val ( modality );
		$('#IdcExamComment').val ( description );

		if ( tags != null && tags.length > 0 )
		{
			console.log ( "Tags : " + tags );
			let tagsArray = tags.split (',');
			IdcExamsListDetailSitesCBMenu.SelectElementIdent2 ( tagsArray );
			IdcExamsListDetailTagsCBMenu.SelectElement ( tagsArray );
		}
		
		IdcExamsListDetailTagsCBMenu.UnselectAll ();
		if ( tags != null && tags.length > 0 )
		{
			let tagsArray = tags.split(',');
			IdcExamsListDetailTagsCBMenu.SelectElementIdent2 ( tagsArray );
		}
		

		IdcExamsListDetailWarningsCBMenu.UnselectAll ();
		if ( warnings != null && warnings.length > 0 )
		{
			let warningsArray = warnings.split(',');
			IdcExamsListDetailWarningsCBMenu.SelectElementIdent2 ( warningsArray );
		}
		
		
		IdcExamsListDocListDT.ExtID = id;
		IdcExamsListDocListDT.Refresh ();

		IdcExamsListPSDocListDT.ExtID = id;
		IdcExamsListPSDocListDT.Refresh ();
	}

	function OnExamAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcExamsListDT.SetRowToSelect ( 'id', response );

			IdcExamsListDT.Refresh ();
		}
		else
			OnExamAddError ();
	}

	function OnExamAddError ()
	{
		MsgWarning ( Translate("Unable to add exam !!!") );
	}

	
	function ExamAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		PostASyncData ( "SubFW/database/exams_list/SaveExam.php", params, 'application/x-www-form-urlencoded', OnExamAddOK, OnExamAddError );
	}

	function ExamSave ()
	{
		let id 			= $('#IdcExamsListInformationsDiv' ).data ('id');
		let name		= $('#IdcExamName' ).val ();
		let modality 	= $('#IdcExamModality' ).val ();
		let description	= $('#IdcExamComment' ).val ();

		let warninglist = IdcExamsListDetailWarningsCBMenu.GetSelection2 ().toString();
		let tagexamlist = IdcExamsListDetailTagsCBMenu.GetSelection2 ().toString ();
		let sites = IdcExamsListDetailSitesCBMenu.GetSelection2 ().toString ();
		if ( tagexamlist.length > 0 )
		{
			if ( sites.length > 0 )
				tagexamlist = tagexamlist + "," + sites;
		}
		else
			tagexamlist =  sites;

		let params = "id=" + id;
		params += "&name=" + name;
		params += "&modality=" + modality;
		params += "&description=" + description;
		params += "&warninglist=" + warninglist;
		params += "&tagexamlist=" + tagexamlist;
		PostASyncData ( "SubFW/database/exams_list/SaveExam.php", params, 'application/x-www-form-urlencoded', OnExamAddOK, OnExamAddError );
	}	

	function ExamDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/exams_list/DeleteExam.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No exam selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected exam ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete exam !!!" );

		IdcExamsListDT.DeleteSelectedRow ( data );
	}