	ExamsListWorkingDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: 'SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcExamsListWorkingDT.Properties (); }
    	}
	];

	let ELWLastDocID 		= -1;
	let ELWLastOtherDocID 	= -1;


	function InitExamsListWorkingPage ()	
	{
		let ss = sessionStorage.getItem ( 'ExamsListWorkingPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'ExamsListWorkingPageInitialized', true );

		IdcExamsListWorkingDT = new C_DataTable ();
		IdcExamsListWorkingDT.DataSrcType		= 0;
		IdcExamsListWorkingDT.Ident 			= 'IdcExamsListWorkingDT';
		IdcExamsListWorkingDT.Container 		= 'IdcExamsListWorkingDTContainer';
		IdcExamsListWorkingDT.DataSrc 			= 'SubFW/database/exams_list/GetDTExamLight.php';
		IdcExamsListWorkingDT.DataFct			= ExamsListWorkingDTGetData;
		IdcExamsListWorkingDT.SetColReorder 	( false );
		IdcExamsListWorkingDT.OnSelectChanged	( ExamsListWorkingDTSelectChanged 	);
		IdcExamsListWorkingDT.AddColumn ( 'id',					'id',	 					0, false,  0,  50, false, '', 				'' );
		IdcExamsListWorkingDT.AddColumn ( 'Name',				'nameid',	 				1, true,   1,  '50px', true,  '', 			'', ELW_NeedToRead );
		IdcExamsListWorkingDT.AddColumn ( 'Mod.',				'modality', 				1, true,   2,  '20%', true,  'text-center', '', ELW_NeedToRead );
		IdcExamsListWorkingDT.AddColumn ( 'Description',		'description', 				1, true,   3,  '80%', true,  '', 			'', ELW_NeedToRead );
		IdcExamsListWorkingDT.AddColumn ( 'Staff',				'staff_member_id',			1, false,  4,  50, false,  '', 			'' );
		IdcExamsListWorkingDT.AddColumn ( 'Read at',			'read_doc_at',				1, false,  5,  50, false,  '', 			'' );
		IdcExamsListWorkingDT.AddColumn ( 'Read otherdoc at',	'read_otherdoc_at',			1, false,  6,  50, false,  '', 			'' );
		IdcExamsListWorkingDT.AddColumn ( 'Warnings',			'riskv',	 				1, false,  7,  40, false, '', 				'' );
		IdcExamsListWorkingDT.AddColumn ( 'Tags',				'taglist',	 				1, false,  8,  40, false, '', 				'' );
		IdcExamsListWorkingDT.AddColumn ( 'DocID',				'doc_id',	 				1, false,  9,  40, false, '', 				'' );
		IdcExamsListWorkingDT.AddColumn ( 'DocOtherDocID',		'doc_otherdoc_id',			1, false, 10,  40, false, '', 				'' );
		
		IdcExamsListWorkingDT.SetColumnEllipsis ( 1, true );
		IdcExamsListWorkingDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcExamsListWorkingNameFilter" class="form-control pt-0 pb-0" oninput="IdcExamsListWorkingDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcExamsListWorkingDT.LoadUserCfg ( G_USE_ID );


		
		$(document).ready(function () 
		{
			IdcExamsListWorkingSplitter1_2 	= new C_Splitter ( "IdcExamsListWorkingSplitter1_2" );
			IdcExamsListWorkingSplitter2_3 	= new C_Splitter ( "IdcExamsListWorkingSplitter2_3" );

			IdcExamsListWorkingSitesCBMenu = new C_CheckboxMenu ( "IdcExamsListWorkingSitesContainer", "IdcExamsListWorkingSitesCBMenu0", Translate("Click here to select institution/department") );
			IdcExamsListWorkingSitesCBMenu.CallbackFct = ExamsListWorkingDepartmentsChanged;

			IdcExamsListWorkingTagsCBMenu = new C_CheckboxMenu ( "IdcExamsListWorkingTagsContainer", "IdcExamsListWorkingTagsCBMenu0", Translate("Click here to select tags") );
			IdcExamsListWorkingTagsCBMenu.CallbackFct = ExamsListWorkingTagsChanged;

			InitTagInstDepCBList ( IdcExamsListWorkingSitesCBMenu );
			ExamsListInitTagsList ( IdcExamsListWorkingTagsCBMenu 	);

			IdcExamsListWorkingDT.Create ();
			context.attach ( '#IdcExamsListWorkingDT', 	ExamsListWorkingDTMenu 	);
			IdcExamsListWorkingDT.SetRowToSelect('first_row');

			switchLanguage ( CurrentLanguage );
		});
	}

	function ELW_NeedToRead ( data, ident, rowIdx, colIdx )
	{
		console.log ( 'ELW_NeedToRead...' );

		let staff_member_id 	= IdcExamsListWorkingDT.GetRowData ( rowIdx ).staff_member_id;
		let doc_id 				= IdcExamsListWorkingDT.GetRowData ( rowIdx ).doc_id;
		let doc_otherdoc_id 	= IdcExamsListWorkingDT.GetRowData ( rowIdx ).doc_otherdoc_id;
		let read_doc_at 		= IdcExamsListWorkingDT.GetRowData ( rowIdx ).read_doc_at;
		let read_otherdoc_at 	= IdcExamsListWorkingDT.GetRowData ( rowIdx ).read_otherdoc_at;

		console.log ( ' staff_member_id : ' + staff_member_id );
		console.log ( ' doc_id : ' + doc_id );
		console.log ( ' doc_otherdoc_id : ' + doc_otherdoc_id );
		console.log ( ' read_doc_at : ' + read_doc_at );
		console.log ( ' read_otherdoc_at : ' + read_otherdoc_at );

		if ( staff_member_id != null && ((doc_id != null && read_doc_at == null) || (doc_otherdoc_id != null && read_otherdoc_at == null)) )
			return '<div class="fw-bold text-danger">'+data+'</div>';
		else
			return data;
	}

	
	function ExamsListWorkingDTGetData ( d )
	{
		/*
		let tags = "";
		let selectedTags = IdcExamsListWorkingTagsCBMenu.GetSelection ();
		for ( let i=0; i<selectedTags.length; i++ )
		{
			tags += selectedTags [i][1];
			if ( i < selectedTags.length-1 )
				tags += ',';
		}
		
		d.taglist 		= tags;
		d.idtaglistand 	= tags;
		*/


		let tags = retrieve_selectedtagid ( IdcExamsListWorkingSitesCBMenu, IdcExamsListWorkingTagsCBMenu );

		d.taglist 		= tags.ids.toString();
		d.idtaglistand 	= tags.and.toString();	
		d.idtaglistor 	= tags.or.toString();

		d.name 			= $('#IdcExamsListNameFilter').val ();
		
		return $.extend( {}, d );
	}

	function ELWReadingValidation ( id, doc_id )
	{
		console.log ( "ELWReadingValidation ("+id+" / "+doc_id+")...");

		$.post (
				"./SubFW/database/document/save_read_status.php",
				{
					doc_id: 	doc_id
				},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );

						IdcExamsListWorkingDT.SetRowToSelect ( 'id', id );
						IdcExamsListWorkingDT.Refresh ();
					}
				);
	}

	function ExamsListWorkingDTSelectChanged ( rowsIdx )
	{
		let id 				= -1;
		let doc_id 			= -1;
		let doc_otherdoc_id = -1;
		let nameid 			= "";
		let modality		= "";
		let description		= "";
		let warnings		= "";
		let tags			= "";
		let staff_member_id	= null;
		let read_doc_at 	= "";

		console.log ( "=== ExamsListWorkingDTSelectChanged...");

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
		
			id 					= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().id;
			nameid 				= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().nameid;
			modality			= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().modality;
			description			= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().description;
			warnings			= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().riskv;
			tags				= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().taglist;
			doc_id 				= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().doc_id;
			doc_otherdoc_id 	= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().doc_otherdoc_id;
			staff_member_id 	= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().staff_member_id;
			read_doc_at			= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().read_doc_at;
			read_otherdoc_at	= $('#IdcExamsListWorkingDT').DataTable().row( rowIdx ).data().read_otherdoc_at;

			
			$('#IdcELWName').text 			( nameid );
			$('#IdcELWModality').text 		( modality );
			$('#IdcELWDescription').text 	( description );

			ELWFillWarningsList ( id );

			if ( doc_id != -1 && doc_id != null )
			{
				if ( doc_id != ELWLastDocID )
				{
					ELWLastDocID =  doc_id;

					let toRead = ( staff_member_id != null && read_doc_at == null )? true : false;

					let url = "../PDFViewer/eoQUALPDFViewer.php?docid="+doc_id;

					let elWReadingValidation = ELWReadingValidation.bind(this, id, doc_id );
					SetDocumentContent ( 'IdcELWProcedureViewerFrame', url, (toRead==true)? elWReadingValidation : null );

					let caption = Translate ('Document') + "- " + nameid;
					$('#IdcELWProcedureLightCaption').text ( caption );
				}
			}
			else
			{
				ELWLastDocID = -1;
				$('#IdcELWProcedureViewerFrame').prop ( 'src', '' );
				$('#IdcELWProcedureLightCaption').text ( Translate ('No document to display') );
			}

			
			if ( doc_otherdoc_id != -1 && doc_otherdoc_id != null )
			{
				if ( doc_otherdoc_id != ELWLastOtherDocID )
				{
					ELWLastOtherDocID =  doc_otherdoc_id;

					let toRead = ( staff_member_id != null && read_otherdoc_at == null )? true : false;

					let url = "../PDFViewer/eoQUALPDFViewer.php?docid="+doc_otherdoc_id;

					let elWReadingValidation = ELWReadingValidation.bind(this, id, doc_otherdoc_id );
					SetDocumentContent ( 'IdcELWPatientSheetViewerFrame', url, (toRead==true)? elWReadingValidation : null );

					let caption = Translate ('Document') + "- " + nameid;
					$('#IdcELWPatientSheetLightCaption').text ( caption );
				}
			}
			else
			{
				ELWLastOtherDocID = -1;
				$('#IdcELWPatientSheetViewerFrame').prop ( 'src', '' );
				$('#IdcELWPatientSheetLightCaption').text ( Translate ('No document to display') );
			}
			
		}
		else
		{
			ELWLastDocID = -1;
			$('#IdcELWProcedureViewerFrame').prop ( 'src', '' );
			$('#IdcELWProcedureLightCaption').text ( Translate ('No document to display') );

			ELWLastOtherDocID = -1;
			$('#IdcELWPatientSheetViewerFrame').prop ( 'src', '' );
			$('#IdcELWPatientSheetLightCaption').text ( Translate ('No document to display') );
		}
	}

	function ExamsListWorkingDepartmentsChanged ()
	{
		IdcExamsListWorkingDT.Refresh ();
	}

	function ExamsListWorkingTagsChanged ()
	{
		IdcExamsListWorkingDT.Refresh ();
	}

	function ELWWarningsListOK ( data )
	{
		let tmp = '';

		for ( let i=0; i<data.length; i++ )
		{
			tmp += '<div class="row w-100 m-0 p-0 pt-2 border-bottom fw-bold">'+data [i].title+'</div>';
			tmp += '<div class="row w-100 m-0 p-0">'+data [i].description+'</div>';
		}

		document.getElementById ( 'IdcELWWarningsDiv' ).innerHTML = tmp;
	}
	function ELWWarningsListError ( data )
	{
		console.log ( "ELWWarningsListError..." );
	}
	function ELWFillWarningsList ( id )
	{
		let data = {};
		data['id'] =  id;
		var request = $.ajax ({
        		url: 		G_ServerFolder+"/eoQUAL/SubFW/database/exams_list/GetWarnings.php",
        		type: 		"post",
        		dataType: 	"json",
        		data: 		data
    			}
    	)
		.done ( ELWWarningsListOK )
    	.fail ( ELWWarningsListError );
	}