
				
	function InitFastIncidentReportingPage ()
	{
		let ss = sessionStorage.getItem ( 'FastIncidentReportingPageInitialized' );
		
		if ( ss == 'true' )
		{
			$('#IdcFIRDepartment').val ( -1 );
			return;
		}
		
		sessionStorage.setItem ( 'FastIncidentReportingPageInitialized', true );


		$(document).ready(function () 
		{
			FillDepartmentsList ( 'IdcFIRDepartment', -1 );

			$('#IdcFIRDate').val ( GetCurrentDate () );

			$('#IdcFIRDepartment').val ( -1 );
			$('#IdcFIRSeverity').val ( -1 );
			$('#IdcFIRAuthor').val ( G_UserFullName );

			switchLanguage ( CurrentLanguage );
		});
	}

	function FIRTitleChanged ()
	{
		let department 	= $('#IdcFIRDepartment').val ();
		let severity 	= $('#IdcFIRSeverity').val ();
		let title 		= $('#IdcFIRTitle').val ();

		let sendPossible = true;

		if ( department != null )
			$('#IdcFIRDepartment').removeClass ( 'border-danger' );
		else
		{
			$('#IdcFIRDepartment').addClass ( 'border-danger' );
			sendPossible &= false;
		}

		if ( severity != null )
			$('#IdcFIRSeverity').removeClass ( 'border-danger' );
		else
		{
			$('#IdcFIRSeverity').addClass ( 'border-danger' );
			sendPossible &= false;
		}

		if ( title.length > 0 )
			$('#IdcFIRTitle').removeClass ( 'border-danger' );
		else
		{
			$('#IdcFIRTitle').addClass ( 'border-danger' );
			sendPossible &= false;
		}

		

		if ( sendPossible == false )
			$('#IdcFIRSend').prop ( 'disabled', true );
		else
			$('#IdcFIRSend').prop ( 'disabled', false );

	}

	function FIRSend ()
	{
		FIRIncidentAdd ();
	}

	function OnFIRAddIncidentOK ()
	{
		$('#IdcFIRDepartment').val ( -1 );
		$('#IdcFIRTitle').val ( '' );
		$('#IdcFIRSeverity').val ( -1 );
		$('#IdcFIRDescription').val ( '' );
		$('#IdcFIRDate').val ( GetCurrentDate () );

		FIRTitleChanged ();

		MsgWarning ( Translate ("Incident recorded.") );
	}

	function OnFIRAddIncidentError ()
	{
		MsgWarning (Translate ("Unable to create incident !!!"));
	}

	function FIRIncidentAdd ()
	{
		let depList = document.getElementById ( 'IdcFIRDepartment').options;
		let dep_id = -1;
		for (let i=0; i<depList.length; i++ )
		{
			if ( depList [i].value != -1 )
			{
				dep_id = depList [i].value;
				break;
			}
		}

		let title 		= $('#IdcFIRTitle').val ();
		let severity 	= $('#IdcFIRSeverity').val ();
		let reportdate	= $('#IdcFIRDate').val ();
		let description	= $('#IdcFIRDescription').val ();

		let params = "";
		params += "id=-1";
		params += "&reporter=" + G_USE_ID;
		params += "&dep_id=" + dep_id;
		params += "&title=" + title;
		params += "&severity=" + severity;
		params += "&reportdate=" + reportdate;
		params += "&comment=" + description;

		PostASyncData ( "SubFW/database/incident/SaveIncident.php", params, 'application/x-www-form-urlencoded', OnFIRAddIncidentOK, OnFIRAddIncidentError );
	}

	