	IncidentDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnIncidentDTGridProperties() }
		}
	];
	
	function InitIncidentPage ()
	{
		let ss = sessionStorage.getItem ( 'IncidentPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'IncidentPageInitialized', true );

		IdcIncidentDT = new C_DataTable ();
		IdcIncidentDT.DataSrcType		= 0;
		IdcIncidentDT.Ident 			= 'IdcIncidentDT';
		IdcIncidentDT.Container 		= 'IdcIncidentDTContainer';
		IdcIncidentDT.DataSrc 			= 'SubFW/database/incident/GetIncidents.php';
		IdcIncidentDT.DataFct			= IncidentDTGetData;
		IdcIncidentDT.SetColReorder 	( true );
		IdcIncidentDT.OnSelectChanged	( IncidentDTSelectChanged 	);
		IdcIncidentDT.AddColumn ( 'id',						'id',	 					0, false,  0,    50, false, '', 				'' );
		IdcIncidentDT.AddColumn ( 'Dep_id',					'dep_id',					0, false,  1,    50, true,  '', 				'' );
		IdcIncidentDT.AddColumn ( 'Sta_id',					'status_id',				0, false,  2,    50, true,  '', 				'' );
		IdcIncidentDT.AddColumn ( 'Severity',				'severity',					0, false,  3,    50, true,  '', 				'' );
		IdcIncidentDT.AddColumn ( 'Status',					'statuscomment',			0, false,  4,    50, true,  '', 				'' );
		IdcIncidentDT.AddColumn ( Translate('Date'),		'reportdate',				1, true,   5, '10%', true,  'text-center',		'', DICOMDate2StdDateFR );
		IdcIncidentDT.AddColumn ( Translate('Closed-m'),	'closeddate',				1, true,   6, '10%', true,  'text-center',		'', DICOMDate2StdDateFR );
		IdcIncidentDT.AddColumn ( Translate('Status'),		'status_name',				1, true,   7, '10%', true,  '', 				'' );
		IdcIncidentDT.AddColumn ( Translate('Department'),	'department',				1, true,   8, '15%', true,  '', 				'' );
		IdcIncidentDT.AddColumn ( Translate('Reported by'),	'reporterby',				1, true,   9, '10%', true,  '', 				'' );
		IdcIncidentDT.AddColumn ( Translate('Title'),		'title',					1, true,  10, '15%', true,  '', 				'' );
		IdcIncidentDT.AddColumn ( Translate('Description'),	'comment',					1, true,  11, '15%', true,   '', 				'' );
		IdcIncidentDT.AddColumn ( '',						'listofactiondescription',	1, false, 12,   20,  false,  '', 				'' );
		
		IdcIncidentDT.LoadUserCfg ( G_USE_ID );

		
		IdcIncidentDocumentsDT			=	 new C_DocumentDT ( "IdcIncidentDocumentsDT" );
		IdcIncidentDocumentsDT.Caption  	= 'Document';
		IdcIncidentDocumentsDT.DocType		= "report";
		IdcIncidentDocumentsDT.ExtType		= "report";
		IdcIncidentDocumentsDT.Container	= 'IdcIncidentDocumentsDTContainer';
		IdcIncidentDocumentsDT.Editor		= IncidentEdition;
		IdcIncidentDocumentsDT.LoadUserCfg ( G_USE_ID );


		$(document).ready(function () 
		{
			IdcIncidentSplitter1_2 	= new C_Splitter ( "IdcIncidentSplitter1_2" );
			IdcIncidentSplitter3_4 	= new C_Splitter ( "IdcIncidentSplitter3_4" );

			IdcIncidentSplitter1_2.LoadUserCfg		( G_USE_ID );
			IdcIncidentSplitter3_4.LoadUserCfg		( G_USE_ID );

			FillDepartmentsList ( 'IdcIncidentDepartment', -1 );

			FillStatusList ( 'IdcIncidentStatus', 	 'report');

			IdcIncidentDocumentsDT.Create ();


			IdcIncidentDT.Create ();
			context.attach ( '#IdcIncidentDT', IncidentDTListMenu );
			IdcIncidentDT.SetRowToSelect ( 'first_row' );

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcIncidentEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcIncidentSplitter1_2").show ();
      				}
    			}
  			});

			switchLanguage ( CurrentLanguage );
		});
	}

	function IncidentEdition ( doc_id )
	{
		$("#IdcIncidentSplitter1_2").hide ();
		$("#IdcIncidentEditorFrame").show ();

		$('#IdcIncidentEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}

	function IncidentDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function OnIncidentDTGridProperties ()
	{
		IdcIncidentDT.Properties ();
	}

	function IncidentDTSelectChanged ( rowsIdx )
	{
		let id 				= -1;
		let title 			= '';
		let reportDate		= '';
		let reporter 		= '';
		let severity 		= -1;
		let status_id 		= -1;
		let comment			= '';
		let closeddate		= '';
		let statuscomment	= '';
		let listofaction	= '';

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().id;
			title			= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().title;
			reportDate		= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().reportdate;
			reporter		= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().reporterby;
			severity		= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().severity;
			status_id		= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().status_id;
			comment			= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().comment;
			closeddate		= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().closeddate;
			statuscomment	= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().statuscomment;
			listofaction	= $('#IdcIncidentDT').DataTable().row( rowIdx ).data().listofactiondescription;
		}

		$('#IdcDivIncident' ).data ('id', id );
		$('#IdcIncidentTitle').val ( title );
		$('#IdcIncidentDate').val ( DICOMDate2StdDate(reportDate) );
		$('#IdcIncidentAuthor').val ( reporter );
		$('#IdcIncidentStatus').val ( status_id ).change();
		$('#IdcIncidentSeverity').val ( severity ).change();
		$('#IdcIncidentDescription').val ( comment );
		$('#IdcIncidentClosedDate').val ( DICOMDate2StdDate(closeddate) );
		$('#IdcIncidentStatusComment').val ( statuscomment );
		$('#IdcIncidentTasks').html ( listofaction );
		
		IdcIncidentDocumentsDT.ExtID = id;	
		IdcIncidentDocumentsDT.Refresh ();
	}

	function OnAddIncidentOK ( response )
	{
		IdcIncidentDT.SetRowToSelect ( 'id', response );
		IdcIncidentDT.Refresh ();
	}

	function OnAddIncidentError ()
	{
		console.log ( "OnAddIncidentError..." );
	}

	function IncidentAdd ()
	{
		let depList = document.getElementById ( 'IdcIncidentDepartment').options;
		let dep_id = -1;
		for (let i=0; i<depList.length; i++ )
		{
			if ( depList [i].value != -1 )
			{
				dep_id = depList [i].value;
				break;
			}
		}

		let params = "";
		params += "id=-1";
		params += "&title=New incident";
		params += "&reporter=" + G_USE_ID;
		params += "&dep_id=" + dep_id;
		params += "&reportdate=" + GetCurrentDate ();

		PostASyncData ( "SubFW/database/incident/SaveIncident.php", params, 'application/x-www-form-urlencoded', OnAddIncidentOK, OnAddIncidentError );
	}

	function IncidentSave ()
	{
		let id 			= $('#IdcDivIncident' ).data ('id');
		let dep_id 		= $('#IdcIncidentDepartment').val ();
		let title 		= $('#IdcIncidentTitle').val ();
		let date 		= $('#IdcIncidentDate').val ();
		let severity 	= $('#IdcIncidentSeverity').val ();
		let description	= $('#IdcIncidentDescription').val ();
		let closeddate	= $('#IdcIncidentClosedDate').val ();
		let statuscomment	= $('#IdcIncidentStatusComment').val ();
		let status_id 		= $('#IdcIncidentStatus').val ();

		let params = "";
		params += "id=" + id;
		params += "&title=" + title;
		params += "&reporter=" + G_USE_ID;
		params += "&dep_id=" + dep_id;
		params += "&reportdate=" + date;
		params += "&severity=" + severity;
		params += "&comment=" + description;
		params += "&closeddate=" + closeddate;
		params += "&statuscomment=" + statuscomment;
		params += "&status_id=" + status_id;

		PostASyncData ( "SubFW/database/incident/SaveIncident.php", params, 'application/x-www-form-urlencoded', OnAddIncidentOK, OnAddIncidentError );
	}

	function IncidentDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/incident/DeleteIncident.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No incident selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected incident ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete incident !!!" );

		IdcIncidentDT.DeleteSelectedRow ( data );
	}

	function IncidentTaskSelect ()
	{
		console.log ("IncidentTaskSelect...");

		let incident_id 	= $('#IdcDivIncident' ).data ('id');

		SetTaskInfo ( 1, 'report', incident_id );
		
		var element = $('#IdcDivTask').detach();

		DocumentViewerShow ( Translate ("Tasks"), element, null, OnIncidentCloseModalTask );
		IdcTaskDT.Refresh ();

		$('#IdcDivTask').show ();
	}

	function OnIncidentCloseModalTask ()
	{
		SetTaskInfo ( 0, '' );

		var element = $('#IdcDivTask').detach();
		$('#IdcMainContainer').append(element);

		let incident_id 	= $('#IdcDivIncident' ).data ('id');
		IdcIncidentDT.SetRowToSelect ( 'id', incident_id );
		IdcIncidentDT.Refresh ();
	}