	
	
	function InitInstitutionalDocumentPage ()
	{
		let ss = sessionStorage.getItem ( 'InstitutionalDocumentPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'InstitutionalDocumentPageInitialized', true );

		InstDocInstDTListMenu = [
			{
				header: ''
			},
			{
				img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
				text: 'Grid properties...',
				action: function(e, selector) { IdcInstDocInstListDT.Properties(); }
			}
		];

		InstDocDepartmentDTListMenu = [
			{
				header: ''
			},
			{
				img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
				text: 'Grid properties...',
				action: function(e, selector) { IdcInstDocDepartmentListDT.Properties(); }
			}
		];
			
		// #################################################################################
		// ### Institutions

		IdcInstDocInstListDT = new C_DataTable ();
		IdcInstDocInstListDT.DataSrcType	= 0;
		IdcInstDocInstListDT.Ident 			= 'IdcInstDocInstListDT';
		IdcInstDocInstListDT.Container 		= 'IdcInstDocInstListDTContainer';
		IdcInstDocInstListDT.DataSrc 		= G_ServerFolder+'/eoQUAL/SubFW/database/institution_document/GetInstitutionsList.php';
		IdcInstDocInstListDT.DataFct		= InstDocInstListDTGetData;
		IdcInstDocInstListDT.SetColReorder 	( true );
		IdcInstDocInstListDT.OnSelectChanged( InstDocInstListDTSelectChanged );
		IdcInstDocInstListDT.AddColumn ( 'id',				'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcInstDocInstListDT.AddColumn ( Translate('Name'),	'name',	 				1, true,   1, '100%', 	true,  '', 	'' );
		IdcInstDocInstListDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcInstDocInstNameFilter" class="form-control pt-0 pb-0" oninput="IdcInstDocInstListDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcInstDocInstListDT.LoadUserCfg ( G_USE_ID );

		IdcInstDocInstDocDT 			= new C_DocumentDT ( "IdcInstDocumentDT" );
		IdcInstDocInstDocDT.Caption  	= 'Institutional documents';
		IdcInstDocInstDocDT.ExtType		= "institution";
		IdcInstDocInstDocDT.DocType		= "institution";
		IdcInstDocInstDocDT.Container	= 'IdcInstDocInstDocContainer';
		IdcInstDocInstDocDT.Editor		= InstDocumentEdition;
		IdcInstDocInstDocDT.LoadUserCfg ( G_USE_ID );

		
		// #################################################################################
		// ### Departments

		IdcInstDocDepartmentListDT = new C_DataTable ();
		IdcInstDocDepartmentListDT.DataSrcType	= 0;
		IdcInstDocDepartmentListDT.Ident 		= 'IdcInstDocDepartmentListDT';
		IdcInstDocDepartmentListDT.Container 	= 'IdcInstDocDepartmentListDTContainer';
		IdcInstDocDepartmentListDT.DataSrc 		= G_ServerFolder+'/eoQUAL/SubFW/database/institution_document/GetDepartmentsList.php';
		IdcInstDocDepartmentListDT.DataFct		= InstDocDepartmentListDTGetData;
		IdcInstDocDepartmentListDT.SetColReorder 	( true );
		IdcInstDocDepartmentListDT.OnSelectChanged	( InstDocDepartmentListDTSelectChanged );
		IdcInstDocDepartmentListDT.AddColumn ( 'id',				'id',	 			0, false,  0,  50, false, '', 	'' );
		IdcInstDocDepartmentListDT.AddColumn ( Translate('Name'),	'name',				1, true,   1, '100%', true,  '', 	'' );
		IdcInstDocDepartmentListDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcInstDocDepNameFilter" class="form-control pt-0 pb-0" oninput="IdcInstDocDepartmentListDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcInstDocDepartmentListDT.LoadUserCfg ( G_USE_ID );

		IdcInstDocDepDocDT 				= new C_DocumentDT ( "IdcInstDepDocumentDT" );
		IdcInstDocDepDocDT.Caption  	= 'Department documents';
		IdcInstDocDepDocDT.DocType		= "department";
		IdcInstDocDepDocDT.Container	= 'IdcInstDocDepDocDTContainer';
		IdcInstDocDepDocDT.Editor		= InstDocumentEdition;
		IdcInstDocDepDocDT.LoadUserCfg ( G_USE_ID );

		
		
		$(document).ready(function () 
		{
			IdcInstDocSplitter1_2 	= new C_Splitter ( "IdcInstDocSplitter1_2" );
			IdcInstDocSplitter3_4 	= new C_Splitter ( "IdcInstDocSplitter3_4" );
			IdcInstDocSplitter5_6 	= new C_Splitter ( "IdcInstDocSplitter5_6" );

			IdcInstDocSplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcInstDocSplitter3_4.LoadUserCfg ( G_USE_ID );
			IdcInstDocSplitter5_6.LoadUserCfg ( G_USE_ID );
			
			IdcInstDocInstListDT.Create ();
			context.attach ( '#IdcInstDocInstListDT', InstDocInstDTListMenu );
			IdcInstDocInstListDT.SetRowToSelect('first_row');

			IdcInstDocInstDocDT.Create ();

			IdcInstDocDepartmentListDT.Create ();
			context.attach ( '#IdcInstDocDepartmentListDT', InstDocDepartmentDTListMenu );

			IdcInstDocDepDocDT.Create ();

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcInstDocEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcInstDocSplitter1_2").show ();
      				}
    			}
  			});


			switchLanguage ( CurrentLanguage );		
		});
	}

	function InstDocumentEdition ( doc_id )
	{
		console.log ( "InstDocumentEdition..." );
		console.log ( " doc_id : " + doc_id );

		$("#IdcInstDocSplitter1_2").hide ();
		$("#IdcInstDocEditorFrame").show ();

		$('#IdcInstDocEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}

	function InstDocInstListDTGetData ( d )
	{
		d.name = $('#IdcInstDocInstNameFilter').val ();
		return $.extend( {}, d );
	}
	
	function InstDocInstListDTSelectChanged ( rowsIdx )
	{
		let id = -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcInstDocInstListDT.GetRowData ( rowIdx ).id;
		}

		$('#IdcDivInstitutionalDocument' ).data ('institution_id', id );

		IdcInstDocInstDocDT.ExtID = id;
		IdcInstDocInstDocDT.Refresh ();

		IdcInstDocDepartmentListDT.SetRowToSelect ( 'first_row' );
		IdcInstDocDepartmentListDT.Refresh ();
	}

	function InstDocInstDocDTGetData ( d )
	{
		d.doctype 		= 'institution';
		d.extid 		= $('#IdcDivInstitutionalDocument' ).data ('institution_id' );
		d.versioning	= 0;
			
		return $.extend( {}, d );
	}


	function InstDocDepartmentListDTGetData ( d )
	{
		d.inst_id	= $('#IdcDivInstitutionalDocument' ).data ('institution_id' );
		d.name = $('#IdcInstDocDepNameFilter').val ();

		return $.extend( {}, d );
	}

	function InstDocDepartmentListDTSelectChanged ( rowsIdx )
	{
		let id = -1;

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcInstDocDepartmentListDT.GetRowData ( rowIdx ).id;
		}

		$('#IdcDivInstitutionalDocument' ).data ('department_id', id );

		IdcInstDocDepDocDT.ExtID = id;
		IdcInstDocDepDocDT.Refresh ();
	}


	function InstDocDepDocDTGetData ( d )
	{
		d.doctype 		= 'department';
		d.extid 		= $('#IdcDivInstitutionalDocument' ).data ('department_id' );
		d.versioning	= 0;

		return $.extend( {}, d );
	}