	LegalDocumentDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcLegalDocumentDT.Properties (); }
		}
	];

		
	function InitLegalDocumentPage ()
	{
		let ss = sessionStorage.getItem ( 'LegalDocumentPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'LegalDocumentPageInitialized', true );
			
		IdcLegalDocumentDT = new C_DataTable ();
		IdcLegalDocumentDT.DataSrcType		= 0;
		IdcLegalDocumentDT.Ident 			= 'IdcLegalDocumentDT';
		IdcLegalDocumentDT.Container 		= 'IdcLegalDocumentDTContainer';
		IdcLegalDocumentDT.CfgParameterName = 'LegalDocumentDTProperties';
		IdcLegalDocumentDT.DataSrc 			= 'SubFW/database/legal_document/GetDTDocument.php';
		IdcLegalDocumentDT.DataFct			= LegalDocumentDTGetData;
		IdcLegalDocumentDT.SetColReorder 	( true );
		IdcLegalDocumentDT.OnSelectChanged	( LegalDocumentDTSelectChanged );
				
		IdcLegalDocumentDT.AddColumn ( 'id',			'id',	 					0, false,  0,  50, false, '', 				'' );
		IdcLegalDocumentDT.AddColumn ( 'Name',			'name',		 				1, true,   1, '35%', true,  '', 				'' );
		IdcLegalDocumentDT.AddColumn ( 'Type',			'type', 					1, true,   2, '20%', true,  'text-center', 	'' );
		IdcLegalDocumentDT.AddColumn ( 'Comment',		'comment',					1, true,   3, '45%', true,  '', 				'' );

		IdcLegalDocumentDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcLegalDocumentNameFilter" class="form-control pt-0 pb-0" oninput="IdcLegalDocumentDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcLegalDocumentDT.SetColumnFilter (  2, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcLegalDocumentTypeFilter" class="form-control pt-0 pb-0" oninput="IdcLegalDocumentDT.Refresh()" type="text" placeholder="'+Translate("Type")+'"></div>' );
		
		IdcLegalDocumentDT.LoadUserCfg ( G_USE_ID );
		

		IdcLegalDocumentRealDT 				= new C_DocumentDT ( "IdcLDDocumentDT" );
		IdcLegalDocumentRealDT.Caption  	= 'Documents';
		IdcLegalDocumentRealDT.ExtType		= "legaldocument";
		IdcLegalDocumentRealDT.DocType		= "legaldocument";
		IdcLegalDocumentRealDT.Container	= 'IdcLegalDocumentRealDocContainer';
		IdcLegalDocumentRealDT.Editor 		= LegalDocumentEdition;
		IdcLegalDocumentRealDT.OneOnly		= true;
		IdcLegalDocumentRealDT.LoadUserCfg ( G_USE_ID );
		
		
		$(document).ready(function () 
		{
			IdcLegalDocumentSplitter1_2 	= new C_Splitter ( "IdcLegalDocumentSplitter1_2" );
			IdcLegalDocumentSplitter1_2.LoadUserCfg ( G_USE_ID );
						
			IdcLegalDocumentDT.Create ();
			context.attach ( '#IdcLegalDocumentDT', LegalDocumentDTListMenu );
			IdcLegalDocumentDT.SetRowToSelect('first_row');
			
			IdcLegalDocumentRealDT.Create ();

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcLegalDocumentEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcLegalDocumentSplitter1_2").show ();
      				}
    			}
  			});
			
			switchLanguage ( CurrentLanguage );
		});
	}

	function LegalDocumentEdition ( doc_id )
	{
		console.log ( "LegalDocumentEdition..." );
		console.log ( " doc_id : " + doc_id );

		$("#IdcLegalDocumentSplitter1_2").hide ();
		$("#IdcLegalDocumentEditorFrame").show ();

		$('#IdcLegalDocumentEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}
		
	function LegalDocumentDTGetData ( d )
	{
		d.name = $('#IdcLegalDocumentNameFilter').val ();
		d.type = $('#IdcLegalDocumentTypeFilter').val ();
		
		return $.extend( {}, d );
	}
		
		
	function LegalDocumentDTSelectChanged ( rowsIdx )
	{
		let id 			= -1;
		let name 		= "";
		let type 		= "";
		let comment		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= $('#IdcLegalDocumentDT').DataTable().row( rowIdx ).data().id;
			name 		= $('#IdcLegalDocumentDT').DataTable().row( rowIdx ).data().name;
			type 		= $('#IdcLegalDocumentDT').DataTable().row( rowIdx ).data().type;
			comment 	= $('#IdcLegalDocumentDT').DataTable().row( rowIdx ).data().comment;
		}

		$('#IdcLegDocInformationsDiv' ).data ('id', id );
			
		$('#IdcLegDocName' ).val ( name );
		$('#IdcLegDocType' ).val ( type );
		$('#IdcLegDocComment' ).val ( comment );
		
		IdcLegalDocumentRealDT.ExtID = id;
		IdcLegalDocumentRealDT.Refresh ();
	}
	
	function LegalDocumentAdd ()
	{
		let xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				var  response = xhra.responseText;
				
				if ( response == -1 )
					alert ( "Error during update !!!" );
				else
					IdcLegalDocumentDT.Refresh ();
			}
		}
		
		var url = "SubFW/database/legal_document/SaveDocument.php?id=-1";
			
		xhra.open ('POST', url, true );
		xhra.send ();
	}

	function LegalDocumentSave ()
	{
		let id 		= $('#IdcLegDocInformationsDiv' ).data ('id');
		let name	= $('#IdcLegDocName' ).val ();
		let type 	= $('#IdcLegDocType' ).val ();
		let comment	= $('#IdcLegDocComment' ).val ();
		
		let xhra= getxhr();
			
		xhra.onloadend = function f()
		{
			if ( xhra.readyState == 4 && xhra.status == 200 )  
			{
				var  response = xhra.responseText;
				
				if ( response == -1 )
					alert ( "Error during update !!!" );
				else
				{
					IdcLegalDocumentDT.GetDataTable ( 'IdcLegalDocumentDT' ).Refresh ();
				}
			}
		}
		
		name 		= encodeURIComponent ( DoubleQuote ( name ) );
		type 		= encodeURIComponent ( DoubleQuote ( type ) );
		comment 	= encodeURIComponent ( DoubleQuote ( comment ) );
		
		var url = "SubFW/database/legal_document/SaveDocument.php?id=" + id + "&name=" + name + "&type=" + type + "&comment=" + comment;
			
		xhra.open ('POST', url, true );
		xhra.send ();
	}	
	
	function LegalDocumentDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/legal_document/DeleteDocument.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No document selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected document ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete document !!!" );

		IdcLegalDocumentDT.DeleteSelectedRow ( data );
	}	
	