	LegalDocumentWorkingDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcLegalDocumentWorkingDT.Properties (); }
		}
	];

	let LDWLastDocID = -1;

		
	function InitLegalDocumentWorkingPage ()
	{
		let ss = sessionStorage.getItem ( 'LegalDocumentWorkingPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'LegalDocumentWorkingPageInitialized', true );
			
		IdcLegalDocumentWorkingDT = new C_DataTable ();
		IdcLegalDocumentWorkingDT.DataSrcType		= 0;
		IdcLegalDocumentWorkingDT.Ident 			= 'IdcLegalDocumentWorkingDT';
		IdcLegalDocumentWorkingDT.Container 		= 'IdcLegalDocumentWorkingDTContainer';
		IdcLegalDocumentWorkingDT.CfgParameterName = 'LegalDocumentDTProperties';
		IdcLegalDocumentWorkingDT.DataSrc 			= 'SubFW/database/legal_document/GetDTDocumentLight.php';
		IdcLegalDocumentWorkingDT.DataFct			= LegalDocumentWorkingDTGetData;
		IdcLegalDocumentWorkingDT.SetColReorder 	( true );
		IdcLegalDocumentWorkingDT.OnSelectChanged	( LegalDocumentWorkingDTSelectChanged );
				
		IdcLegalDocumentWorkingDT.AddColumn ( 'id',			'id',	 					0, false,  0,  50, false, '', 				'' );
		IdcLegalDocumentWorkingDT.AddColumn ( 'Name',			'name',		 				1, true,   1, '35%', true,  '', 				'' );
		IdcLegalDocumentWorkingDT.AddColumn ( 'Type',			'type', 					1, true,   2, '20%', true,  'text-center', 	'' );
		IdcLegalDocumentWorkingDT.AddColumn ( 'Comment',		'comment',					1, true,   3, '45%', true,  '', 				'' );

		IdcLegalDocumentWorkingDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcLegalDocumentWorkingNameFilter" class="form-control pt-0 pb-0" oninput="IdcLegalDocumentWorkingDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcLegalDocumentWorkingDT.SetColumnFilter (  2, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcLegalDocumentWorkingTypeFilter" class="form-control pt-0 pb-0" oninput="IdcLegalDocumentWorkingDT.Refresh()" type="text" placeholder="'+Translate("Type")+'"></div>' );
		
		IdcLegalDocumentWorkingDT.LoadUserCfg ( G_USE_ID );
		
		$(document).ready(function () 
		{
			IdcLegalDocumentWorkingSplitter1_2 	= new C_Splitter ( "IdcLegalDocumentWorkingSplitter1_2" );
			IdcLegalDocumentWorkingSplitter1_2.LoadUserCfg ( G_USE_ID );
						
			IdcLegalDocumentWorkingDT.Create ();
			context.attach ( '#IdcLegalDocumentWorkingDT', LegalDocumentWorkingDTListMenu );
			IdcLegalDocumentWorkingDT.SetRowToSelect('first_row');
			
			switchLanguage ( CurrentLanguage );
		});
	}
		
	function LegalDocumentWorkingDTGetData ( d )
	{
		d.name = $('#IdcLegalDocumentWorkingNameFilter').val ();
		d.type = $('#IdcLegalDocumentWorkingTypeFilter').val ();
		
		return $.extend( {}, d );
	}
		
		
	function LegalDocumentWorkingDTSelectChanged ( rowsIdx )
	{
		let id			= -1;
		let name 		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= $('#IdcLegalDocumentWorkingDT').DataTable().row( rowIdx ).data().id;
			name 		= $('#IdcLegalDocumentWorkingDT').DataTable().row( rowIdx ).data().name;
		}

		if ( id != -1 )
		{
			if ( LDWLastDocID != id )
			{
				LDWLastDocID = id;
				let url = "../PDFViewer/eoQUALPDFViewer.php?docid="+id;

				$('#IdcLegalDocumentViewerFrame').prop ( 'src', url );
				$('#IdcLegaDocumentLightCaption').text ( Translate ('Document') + "- " + name );
			}
		}
		else
		{
			LDWLastDocID = -1;

			$('#IdcLegalDocumentViewerFrame').prop ( 'src', '' );
			$('#IdcLegaDocumentLightCaption').text ( Translate ('No document to display') );
		}
	}
	
	
	