	
	function InitProcedurePage ()
	{
		let ss = sessionStorage.getItem ( 'ProcedurePageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'ProcedurePageInitialized', true );

		ProcedureDTListMenu = [
			{
				header: ''
			},
			{
				img: G_ServerFolder+'/eoQUAL/SubFW/bmp/setup_1_blue.png',
				text: 'Grid properties...',
				action: function(e, selector) { OnProcedureDTGridProperties() }
			}
		];


		IdcProcedureDT = new C_DataTable ();
		IdcProcedureDT.DataSrcType		= 0;
		IdcProcedureDT.Ident 			= 'IdcProcedureDT';
		IdcProcedureDT.Container 		= 'IdcProcedureDTContainer';
		IdcProcedureDT.DataSrc 			=  G_ServerFolder+'/eoQUAL/SubFW/database/procedure/GetDTProcedure.php';
		IdcProcedureDT.DataFct			= ProcedureDTGetData;
		IdcProcedureDT.SetColReorder 	( true );
		IdcProcedureDT.OnSelectChanged	( ProcedureListDTSelectChanged );
		IdcProcedureDT.AddColumn ( 'id',			'id',	 					0, false,  0,  50, false, '', 	'' );
		IdcProcedureDT.AddColumn ( 'Type',			'type', 					0, false,  1,  40, false, '', 	'' );
		IdcProcedureDT.AddColumn ( 'Name',			'name_fr',	 				1, true,   2, '20%', true,  '', 	'' );
		IdcProcedureDT.AddColumn ( 'Comment',		'comment',					1, true,   3, '40%', true,  '', 	'' );
		IdcProcedureDT.AddColumn ( 'alltagidallow',	'alltagidallow',			1, false,  4, '40%', true,  '', 	'' );
		IdcProcedureDT.SetColumnFilter (  2, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcProcedureNameFilter" class="form-control pt-0 pb-0" oninput="IdcProcedureDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcProcedureDT.LoadUserCfg ( G_USE_ID );


		IdcProcedureDocumentDT				= new C_DocumentDT ( "IdcProcDocumentDT" );
		IdcProcedureDocumentDT.Caption  	= 'Documents';
		IdcProcedureDocumentDT.OneOnly  	= true;
		IdcProcedureDocumentDT.ExtType		= "procedure";
		IdcProcedureDocumentDT.DocType		= "procedure";
		IdcProcedureDocumentDT.Container	= 'IdcProcedureDocListDTContainer';
		IdcProcedureDocumentDT.Editor		= ProcedureEdition;
		IdcProcedureDocumentDT.LoadUserCfg ( G_USE_ID );


		$(document).ready(function () 
		{
			IdcProcedureSplitter1_2 	= new C_Splitter ( "IdcProcedureSplitter1_2" );
			IdcProcedureSplitter1_2.LoadUserCfg ( G_USE_ID );
			
			IdcProcedureDepartmentsListCBMenu = new C_CheckboxMenu ( "IdcProcedureDepartmentsListContainer", "IdcProcedureDepartmentsListCBMenu", Translate("Click here to select institution/department") );
			InitTagInstDepCBList ( IdcProcedureDepartmentsListCBMenu );

			IdcProcedureDT.Create ();
			IdcProcedureDT.SetRowToSelect('first_row');
			context.attach ( '#IdcProcedureDT', ProcedureDTListMenu );

			IdcProcedureDocumentDT.Create ();

			window.addEventListener ( "message", function(event) {
    			if (event.data.action === "CloseOOEditor") 
    			{
      				const iframe = document.getElementById("IdcProcedureEditorFrame");
      				if (iframe) 
      				{
        				iframe.style.display = "none"; // ou iframe.remove();
        				$("#IdcProcedureSplitter1_2").show ();
      				}
    			}
  			});

			switchLanguage ( CurrentLanguage );
		});
	}

	function ProcedureEdition ( doc_id )
	{
		$("#IdcProcedureSplitter1_2").hide ();
		$("#IdcProcedureEditorFrame").show ();

		$('#IdcProcedureEditorFrame').attr ( 'src', 'SubFW/html/OnlyOfficeEditor.php?doc_id='+doc_id );
	}

	function ProcedureDTGetData ( d )
	{
		d.name = $('#IdcProcedureNameFilter').val ();

		return $.extend( {}, d );
	}
	
	function OnProcedureDTGridProperties ()
	{
		IdcProcedureDT.Properties ();
	}

	function ProcedureDocListDTGetData ( d ) 
	{
		d.doctype 		= 'procedure';
		d.extid 		= $('#IdcProcedureInformationsDiv' ).data ('procedure_id' );;
		d.versioning	= 0;

		return $.extend( {}, d );
	}

	function ProcedureListDTSelectChanged ( rowsIdx )
	{
		IdcProcedureDepartmentsListCBMenu.UnselectAll ();
		
		let id 				= -1;
		let name 			= "";
		let comment	 		= "";
		let type	 		= "";
		let alltagidallow	= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 				= IdcProcedureDT.GetRowData ( rowIdx ).id;
			name 			= IdcProcedureDT.GetRowData ( rowIdx ).name_fr;
			type 			= IdcProcedureDT.GetRowData ( rowIdx ).type;
			comment			= IdcProcedureDT.GetRowData ( rowIdx ).comment;
			alltagidallow	= IdcProcedureDT.GetRowData ( rowIdx ).alltagidallow;
			if ( alltagidallow != null && alltagidallow.length > 0 )
			{
				console.log ( "alltagidallow : " + alltagidallow );
				let tagsArray = alltagidallow.split (',');

				IdcProcedureDepartmentsListCBMenu.SelectElementIdent2 ( tagsArray );
			}
		}

		$('#IdcProcedureName' ).val ( name );
		$('#IdcProcedureComment' ).val ( comment );
		$('#IdcProcedureType' ).val ( type ).change ();

		$('#IdcProcedureInformationsDiv' ).data ('procedure_id', id );

		IdcProcedureDocumentDT.ExtID = id;
		IdcProcedureDocumentDT.Refresh ();
	}

	
	function ProcedureAddOK ( data )
	{
		IdcProcedureDT.SetRowToSelect ( 'id', data.id );
		IdcProcedureDT.Refresh ();
	}

	function ProcedureAddError ()
	{
		console.log ( "ProcedureAddError...");
	}

	function ProcedureAdd ()
	{
		let data = {};
		data['id'] 		= -1;

		var request = $.ajax ({
        		url: 		G_ServerFolder + "/eoQUAL/SubFW/database/procedure/SaveProcedure.php",
        		type: 		"post",
        		dataType: 	"json",
        		data: 		data
    			}
    	)
		.done ( ProcedureAddOK )
    	.fail ( ProcedureAddError );
	}

	function ProcedureSave ()
	{
		let data = {};
		data['id'] 			= $('#IdcProcedureInformationsDiv' ).data ('procedure_id');
		data['name_fr']		= $('#IdcProcedureName').val ();
		data['name_en']		= $('#IdcProcedureName').val ();
		data['name_nl']		= $('#IdcProcedureName').val ();
		data['type']		= $('#IdcProcedureType').val ();
		data['comment']		= $('#IdcProcedureComment').val ();
		data['listtagid']	= IdcProcedureDepartmentsListCBMenu.GetSelection2 ().toString();

		if ( data['listtagid'].length == 0 )
		{
			MsgWarning ( Translate( "At leat one service must be specified !!!" ) );
			return;
		}

		var request = $.ajax ({
        		url: 		G_ServerFolder+"/eoQUAL/SubFW/database/procedure/SaveProcedure.php",
        		type: 		"post",
        		dataType: 	"json",
        		data: 		data
    			}
    	)
		.done ( ProcedureAddOK )
    	.fail ( ProcedureAddError );
	}

	function ProcedureDelete ()
	{
		let data = {};
		data.RequestURL		= "SubFW/database/procedure/DeleteProcedure.php";
		data.RequestData	= "id";
		data.DTColIdent		= "id";
		data.NoSelectedMsg 	= Translate ( "No procedure selected !!!" );
		data.ConfirmMsg 	= Translate ( "Delete selected procedure ?" );
		data.ErrorMsg 		= Translate ( "Unable to delete procedure !!!" );

		IdcProcedureDT.DeleteSelectedRow ( data );
	}
