	ProcedureWorkingDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcProcedureWorkingDT.Properties (); }
		}
	];

	let PWLastDocID =  -1;

		
	function InitProcedureWorkingPage ()
	{
		let ss = sessionStorage.getItem ( 'ProcedureWorkingPageInitialized' );
		
		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'ProcedureWorkingPageInitialized', true );
			
		IdcProcedureWorkingDT = new C_DataTable ();
		IdcProcedureWorkingDT.DataSrcType		= 0;
		IdcProcedureWorkingDT.Ident 			= 'IdcProcedureWorkingDT';
		IdcProcedureWorkingDT.Container 		= 'IdcProcedureWorkingDTContainer';
		IdcProcedureWorkingDT.CfgParameterName 	= 'ProcedureDTProperties';
		IdcProcedureWorkingDT.DataSrc 			= 'SubFW/database/procedure/GetDTProcedureLight.php';
		IdcProcedureWorkingDT.DataFct			= ProcedureWorkingDTGetData;
		IdcProcedureWorkingDT.SetColReorder 	( true );
		IdcProcedureWorkingDT.OnSelectChanged	( ProcedureWorkingDTSelectChanged );
				
		
		IdcProcedureWorkingDT.AddColumn ( 'doc_id',				'doc_id',					0, false,  0,  50, 	 false,  '', 				'' );
		IdcProcedureWorkingDT.AddColumn ( 'id',					'id',	 					0, false,  1,  50, 	 false, '', 				'' );
		IdcProcedureWorkingDT.AddColumn ( Translate('Name'),	'name',		 				1, true,   2, '35%', true,  '', 				'', PW_NeedToRead );
		IdcProcedureWorkingDT.AddColumn ( Translate('Comment'),	'comment',					1, true,   3, '65%', true,  '', 				'', PW_NeedToRead );
		IdcProcedureWorkingDT.AddColumn ( 'StaffID',			'staff_member_id',			1, false,  4,  50, 	 true,  '', 				'' );
		IdcProcedureWorkingDT.AddColumn ( 'ActionAt',			'action_at',				1, false,  5, 100,   false,  '', 				'' );
		
		IdcProcedureWorkingDT.SetColumnFilter (  2, '<div class="m-0 p-0 ps-0 pe-1 pb-2"><input id="IdcProcedureWorkingNameFilter" class="form-control pt-0 pb-0" oninput="IdcProcedureWorkingDT.Refresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
				
		IdcProcedureWorkingDT.LoadUserCfg ( G_USE_ID );
		
		$(document).ready(function () 
		{
			IdcProcedureWorkingSplitter1_2 	= new C_Splitter ( "IdcProcedureWorkingSplitter1_2" );
			IdcProcedureWorkingSplitter1_2.LoadUserCfg ( G_USE_ID );

			IdcProcedureWorkingDepartmentsListCBMenu = new C_CheckboxMenu ( "IdcProcedureWorkingDepartmentsListContainer", "IdcProcedureWorkingDepartmentsListCBMenu", Translate("Click here to select institution/department") );
			InitTagInstDepCBList ( IdcProcedureWorkingDepartmentsListCBMenu );

			IdcProcedureWorkingDepartmentsListCBMenu.CallbackFct = PWDepartmentChanged;
						
			IdcProcedureWorkingDT.Create ();
			context.attach ( '#IdcProcedureWorkingDT', ProcedureWorkingDTListMenu );
			IdcProcedureWorkingDT.SetRowToSelect('first_row');
			
			switchLanguage ( CurrentLanguage );
		});
	}
		

	function PW_NeedToRead ( data, ident, rowIdx, colIdx )
	{
		console.log ( 'PW_NeedToRead...' );

		let staff_member_id 	= IdcProcedureWorkingDT.GetRowData ( rowIdx ).staff_member_id;
		let doc_id 				= IdcProcedureWorkingDT.GetRowData ( rowIdx ).doc_id;
		let action_at 			= IdcProcedureWorkingDT.GetRowData ( rowIdx ).action_at;

		console.log ( ' staff_member_id : ' + staff_member_id );
		console.log ( ' doc_id : ' + doc_id );
		console.log ( ' action_at : ' + action_at );

		if ( staff_member_id != null && (doc_id != null && action_at == null) )
			return '<div class="fw-bold text-danger">'+data+'</div>';
		else
			return data;
	}

	function ProcedureWorkingDTGetData ( d )
	{
		d.name = $('#IdcProcedureWorkingNameFilter').val ();

		d.taglist = IdcProcedureWorkingDepartmentsListCBMenu.GetSelection2 ().toString();
		
		return $.extend( {}, d );
	}

	function PWReadingValidation ( id, doc_id )
	{
		$.post (
				"./SubFW/database/document/save_read_status.php",
				{
					doc_id: 	doc_id
				},
					function (data, status)
					{		
						IdcProcedureWorkingDT.SetRowToSelect ( 'id', id );
						IdcProcedureWorkingDT.Refresh ();
					}
				);
	}
		
		
	function ProcedureWorkingDTSelectChanged ( rowsIdx )
	{
		let id				= -1;
		let doc_id			= -1;
		let name 			= "";
		let staff_member_id	= null;
		let action_at 		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id				= $('#IdcProcedureWorkingDT').DataTable().row( rowIdx ).data().id;
			doc_id			= $('#IdcProcedureWorkingDT').DataTable().row( rowIdx ).data().doc_id;
			name 			= $('#IdcProcedureWorkingDT').DataTable().row( rowIdx ).data().name;
			staff_member_id	= $('#IdcProcedureWorkingDT').DataTable().row( rowIdx ).data().staff_member_id;
			action_at		= $('#IdcProcedureWorkingDT').DataTable().row( rowIdx ).data().action_at;
		}

		if ( doc_id != -1 )
		{
			if ( doc_id != PWLastDocID )
			{
				PWLastDocID =  doc_id;

				let toRead = ( staff_member_id != null && action_at == null )? true : false;

				let url = "../PDFViewer/eoQUALPDFViewer.php?docid="+doc_id;
				let pWReadingValidation = PWReadingValidation.bind(this, id, doc_id );
				SetDocumentContent ( 'IdcProcedureViewerFrame', url, (toRead==true)? pWReadingValidation : null );

				let caption = Translate ('Document') + "- " + name;
				$('#IdcProcedureLightCaption').text ( caption );
			}
		}
		else
		{
			PWLastDocID = -1;
			SetDocumentContent ( 'IdcProcedureViewerFrame', '' );
			$('#IdcProcedureLightCaption').text ( Translate ('No document to display') );
		}
	}

	function PWDepartmentChanged ()
	{
		IdcProcedureWorkingDT.Refresh ();
	}
	
	
	