	function InitSettingsPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsPageInitialized', true );



		$(document).ready(function () 
		{
			SettingsLeftTabs = new C_Tab ();

			SettingsLeftTabs.Ident 		= "IdcSettingsLeftTabs";
			SettingsLeftTabs.Container 	= "IdcSettingsTabsContainer";
		
			SettingsLeftTabs.AddTab ( 'VIEW_STAFF_MEMBER', 	"Staff members", 	"fas fa-fw fa-users-cog fs-4", 				OnSettingsSelectStaffMember		);
			SettingsLeftTabs.AddTab ( 'VIEW_JOB_ROLE',		"Job roles",		"fas fa-fw fa-user-tag fs-4", 				OnSettingsSelectJobRole 		);
			SettingsLeftTabs.AddTab ( 'VIEW_LOGIN_ROLE',	"Login roles", 		"fas fa-fw fa-user-lock fs-4",				OnSettingsSelectLoginRole 		);
			SettingsLeftTabs.AddTab ( 'VIEW_INSTITUTION', 	"Institutions", 	"fas fa-fw fa-university fs-4",				OnSettingsSelectInstitution		);
			SettingsLeftTabs.AddTab ( 'VIEW_TAG',			"Tags",				"fas fa-fw fa-tags fs-4", 					OnSettingsSelectTag				);
			SettingsLeftTabs.AddTab ( 'VIEW_WARNING', 		"Warnings", 		"fa fa-fw fa-exclamation-triangle fs-4",	OnSettingsSelectWarning	 		);
			SettingsLeftTabs.AddTab ( 'VIEW_EXAMS_IDENT',	"Exams ident",		"fa fa-fw fa-heartbeat fs-4",				OnSettingsSelectExamsIdent		);
			SettingsLeftTabs.AddTab ( 'VIEW_EXAMS_LINK', 	"Exams link", 		"fa fa-fw fa-link fs-4",					OnSettingsSelectExamsLink 		);
			SettingsLeftTabs.AddTab ( 'VIEW_DOCUMENT', 		"Documents", 		"fa fa-fw fa-file-text fs-4",				OnSettingsSelectDocuments 		);
			SettingsLeftTabs.AddTab ( 'VIEW_AUDIT_STANDARD',"Audit standards",	"fa fa-fw fa-file-text fs-4",				OnSettingsSelectAuditStandards 	);
			
			SettingsLeftTabs.DisableAlert ();

			SettingsLeftTabs.Create ();

			SettingsLeftTabs.SelectTab ( 'VIEW_STAFF_MEMBER' );

			switchLanguage ( CurrentLanguage );
		});
	}

	function SettingsHideAllPanels ()
	{
		$('#IdcDivSettingsStaffMember' ).hide ();
		$('#IdcDivSettingsJobRole' ).hide ();
		$('#IdcDivSettingsLoginRole' ).hide ();
		$('#IdcDivSettingsInstitution' ).hide ();
		$('#IdcDivSettingsTag' ).hide ();
		$('#IdcDivSettingsWarning' ).hide ();
		$('#IdcDivSettingsExamIdent' ).hide ();
		$('#IdcDivSettingsExamLink' ).hide ();
		$('#IdcDivSettingsDocuments').hide ();
		$('#IdcDivSettingsAuditStandards').hide ();
	}

	function OnSettingsSelectStaffMember ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsStaffMember' ).show ();
		InitSettingsStaffMemberPage ();
	}

	function OnSettingsSelectJobRole ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsJobRole' ).show ();

		InitSettingsJobRolePage ();
	}

	function OnSettingsSelectLoginRole ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsLoginRole' ).show ();

		InitSettingsLoginRolePage ();
	}

	function OnSettingsSelectInstitution ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsInstitution' ).show ();

		InitSettingsInstitutionPage ();
	}

	function OnSettingsSelectTag ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsTag' ).show ();

		InitSettingsTagPage ();
	}

	function OnSettingsSelectWarning ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsWarning' ).show ();

		InitSettingsWarningPage ();
	}

	function OnSettingsSelectExamsIdent ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsExamIdent' ).show ();

		InitSettingsExamIdentPage ();
	}

	function OnSettingsSelectExamsLink ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsExamLink' ).show ();

		InitSettingsExamLinkPage ();
	}

	function OnSettingsSelectDocuments ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsDocuments' ).show ();

		InitSettingsDocumentsPage ();
	}

	function OnSettingsSelectAuditStandards ()
	{
		SettingsHideAllPanels ();

		$('#IdcDivSettingsAuditStandards').show ();

		InitAuditStandardPage ();

	 	// RenderPage ( "SubFW/html/standards-config.php?standard_version=1&language=FR", "IdcSASStandardsEditPanel" );
	}