	SettingsDocumentDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: 'SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcSettingsDocumentDT.Properties (); }
    	}
	];

	function AAA123 ( data )
	{
		return Translate (data);
	}

	function InitSettingsDocumentsPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsDocumentPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsDocumentPageInitialized', true );

		IdcSettingsDocumentDT = new C_DataTable ();
		IdcSettingsDocumentDT.DataSrcType		= 0;
		IdcSettingsDocumentDT.Ident 			= 'IdcSettingsDocumentDT';
		IdcSettingsDocumentDT.Container 		= 'IdcSDDTContainer';
		IdcSettingsDocumentDT.DataSrc 			= 'SubFW/database/document/GetDTDocType.php';
		IdcSettingsDocumentDT.DataFct			= SettingsDocumentDTGetData;
		IdcSettingsDocumentDT.SetColReorder 	( false );
		IdcSettingsDocumentDT.OnSelect			( SettingsDocumentDTSelected 	);
		IdcSettingsDocumentDT.AddColumn ( Translate('Type'),		'type',	 				1, true,   0,  '100%', true,  '', 				'', Translate );
		// IdcSettingsDocumentDT.AddColumn ( Translate('Type'),		'type',	 				1, true,   1,  '50%', true,  '', 				'' );
		IdcSettingsDocumentDT.SetColumnEllipsis ( 0, true );


		IdcSettingsDocumentDT.LoadUserCfg ( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSDSplitter1_2 	= new C_Splitter ( "IdcSDSplitter1_2" );

			IdcSDSplitter1_2.LoadUserCfg ( G_USE_ID );

			IdcSettingsDocumentDT.Create ();
			context.attach ( '#IdcSettingsDocumentDT', 	SettingsDocumentDTMenu 	);
			IdcSettingsDocumentDT.SetRowToSelect('first_row');

			$('#IdcSDTreeContainer' ).data ( 'action', 1 );


			document.getElementById ('IdcSDReadTab' ).addEventListener 		( 'shown.bs.tab', () => { SDReadTabShown (); } 		);
			document.getElementById ('IdcSDValidateTab' ).addEventListener 	( 'shown.bs.tab', () => { SDValidateTabShown (); } 	);
			document.getElementById ('IdcSDWritingTab' ).addEventListener 	( 'shown.bs.tab', () => { SDWritingTabShown (); } 	);

			
			$.post (
					"./SubFW/database/document/get_inst_dep_job.php",
					{
					},
					function (data, status)
					{		
						console.log ( " data.status : " + data.status );
						console.log ( " data.results : " + data.results );

						$('#IdcSDTreeContainer').C_TreeView ( { data: data.results } );

						TreeViewUncheckAll ('IdcSDTreeContainer');
					}
			);
			

			switchLanguage ( CurrentLanguage );
		});
	}

	function SettingsDocumentDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function SettingsDocumentDTSelected ( rowsIdx )
	{
		let document_type = '';

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			document_type 		= IdcSettingsDocumentDT.GetRowData ( rowIdx ).type;
		}

		$('#IdcSDTreeContainer' ).data ('document_type', document_type );

		SDTreeRefresh ();

		/*
		$.post (
					"./SubFW/database/document/get_default_action.php",
					{
						action: action,
						document_type: document_type
					},
					function (data, status)
					{		
						TreeViewUncheckAll ( 'IdcSDTreeContainer' );

						for ( let i=0; i<data.results.length; i++ )
						{
							TreeViewCheckItem ( 'IdcSDTreeContainer', data.results [i].dep_id + "_" +  data.results [i].job_id );
						}
					}
			);
		*/
	}

	function SDTreeRefresh ()
	{
		let action 			= $('#IdcSDTreeContainer' ).data ('action');
		let document_type	= $('#IdcSDTreeContainer' ).data ('document_type');

		$.post (
					"./SubFW/database/document/get_default_action.php",
					{
						action: action,
						document_type: document_type
					},
					function (data, status)
					{		
						TreeViewUncheckAll ( 'IdcSDTreeContainer' );

						for ( let i=0; i<data.results.length; i++ )
						{
							TreeViewCheckItem ( 'IdcSDTreeContainer', data.results [i].dep_id + "_" +  data.results [i].job_id );
						}
					}
			);
	}


	function DocumentActionSave ()
	{
		let document_type 	= $('#IdcSDTreeContainer' ).data ( 'document_type' 	);
		let action 			= $('#IdcSDTreeContainer' ).data ( 'action'  		);
		
		let items = TreeViewGetSelectedItems ( 'IdcSDTreeContainer' );

		let toSave = new Array ();
		for ( let i=0; i<items.length; i++ )
		{
			console.log ( "items ["+i+"] : " + items [i] );

			let ar = items [i].split ( "_" );

			toSave.push ( ar );
		}

		let values = JSON.stringify ( toSave );

		$.post (
					"./SubFW/database/document/save_default_action.php",
					{
						document_type: document_type,
						action: action,	
						values: values
					},
					function (data, status)
					{		
					}
			);
	}

	function SDReadTabShown ()
	{
		$("#IdcSDCaption").text ( Translate("Default access") );

		$('#IdcSDTreeContainer' ).data ('action', 1 );

		SDTreeRefresh ();
	}

	function SDValidateTabShown ()
	{
		$("#IdcSDCaption").text ( Translate ("Default validation") );
		
		$('#IdcSDTreeContainer' ).data ('action', 0 );

		SDTreeRefresh ();
	}

	function SDWritingTabShown ()
	{
		$("#IdcSDCaption").text ( Translate ("Default writing") );
		
		$('#IdcSDTreeContainer' ).data ('action', 2 );

		SDTreeRefresh ();
	}