	SettingsExamIdentDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnSettingsExamIdentDTGridProperties() }
		}
	];

	function InitSettingsExamIdentPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsExamIdentPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsExamIdentPageInitialized', true );

		IdcSettingsExamIdentDT = new C_DataTable ();
		IdcSettingsExamIdentDT.DataSrcType		= 0;
		IdcSettingsExamIdentDT.Ident 			= 'IdcSettingsExamIdentDT';
		IdcSettingsExamIdentDT.Container 		= 'IdcSEIDTContainer';
		IdcSettingsExamIdentDT.DataSrc 		= 'SubFW/database/exam_ident/GetExamIdents.php';
		IdcSettingsExamIdentDT.DataFct		= SettingsExamIdentDTGetData;
		IdcSettingsExamIdentDT.SetColReorder 	( false );
		IdcSettingsExamIdentDT.OnSelect		( SettingsExamIdentListDTSelected );
		IdcSettingsExamIdentDT.AddColumn 		( 'id',						'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsExamIdentDT.AddColumn 		( Translate('Name'),		'name',		 			1, true,   1, '30%', 	true,  '', 	'' );
		IdcSettingsExamIdentDT.AddColumn 		( Translate('Description'),	'description',			1, true,   2, '70%', 	true,  '', 	'' );
		IdcSettingsExamIdentDT.LoadUserCfg 	( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSEISplitter1_2 	= new C_Splitter ( "IdcSEISplitter1_2" );
			IdcSEISplitter1_2.LoadUserCfg ( G_USE_ID );

			IdcSettingsExamIdentDT.Create ();
			context.attach ( '#IdcSettingsExamIdentDT', SettingsExamIdentDTListMenu );

			IdcSettingsExamIdentDT.SetRowToSelect('first_row');

			switchLanguage ( CurrentLanguage );
		});
	}

	function SettingsExamIdentDTGetData ( d )
	{
		// d.pat_id = ( this.RFPatID == -1 )? -2 : this.RFPatID;
		
		return $.extend( {}, d );
	}

	function OnSettingsExamIdentDTGridProperties ()
	{
		IdcSettingsExamIdentDT.Properties ();
	}

	function SettingsExamIdentListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let name 			= "";
		let description		= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcSettingsExamIdentDT.GetRowData ( rowIdx ).id;
			name 		= IdcSettingsExamIdentDT.GetRowData ( rowIdx ).name;
			description	= IdcSettingsExamIdentDT.GetRowData ( rowIdx ).description;
		}

		$('#IdcSEIName' ).val ( name );
		$('#IdcSEIDescription' ).val ( description );

		$('#IdcSEIInformationsDiv' ).data ('id', id );
	}

	function OnSettingsExamIdentAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsExamIdentDT.SetRowToSelect ( 'id', response );

			IdcSettingsExamIdentDT.Refresh ();
		}
		else
			OnSaveDeviceInstallationError ();
	}

	function OnSettingsExamIdentAddError ()
	{
		MsgWarning ( Translate("Unable to add ExamIdent !!!") );
	}

	function SettingsExamIdentAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		params += "&name=New exam ident";
		params += "&description=Description";
		
		PostASyncData ( "SubFW/database/exam_ident/SaveExamIdent.php", params, 'application/x-www-form-urlencoded', OnSettingsExamIdentAddOK, OnSettingsExamIdentAddError );
	}

	function SettingsExamIdentSave ()
	{
		let id 	= $('#IdcSEIInformationsDiv' ).data ('id');

		let name 		= $('#IdcSEIName' ).val ();
		let description = $('#IdcSEIDescription' ).val ();
		
		let params = "id=" + id;
		params += "&name=" + name;
		params += "&description=" + description;

		PostASyncData ( "SubFW/database/exam_ident/SaveExamIdent.php", params, 'application/x-www-form-urlencoded', OnSettingsExamIdentAddOK, OnSettingsExamIdentAddError );
	}

	function OnDeleteSettingsExamIdentOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsExamIdentDT.Refresh ();
			IdcSettingsExamIdentDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsExamIdentError ();
	}

	function OnDeleteSettingsExamIdentError ()
	{
		MsgWarning ( Translate("Unable to delete ExamIdent !!!") );
	}

	function DeleteSettingsExamIdent ()
	{
		let selRows = IdcSettingsExamIdentDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsExamIdentDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/exam_ident/DeleteExamIdent.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsExamIdentOK, OnDeleteSettingsExamIdentError );
		}
	}

	function SettingsExamIdentDelete ()
	{
		let selRows = IdcSettingsExamIdentDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected ExamIdent ?"), DeleteSettingsExamIdent );
		else
			MsgWarning ( Translate("No ExamIdent selected !!!") );
	}