	SettingsExamsListDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: 'SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcSettingsExamsListDT.Properties (); }
    	}
	];

	SettingsExamsLinkedListDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: 'SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcSettingsExamsLinkedListDT.Properties (); }
    	}
	];

	SettingsExamsNotLinkedListDTMenu = [
    	{
        	header: ''
    	},

		{
        	img: 'SubFW/bmp/setup_1_blue.png',
        	text: 'Grid properties...',
        	action: function(e, selector) { IdcSettingsExamsNotLinkedListDT.Properties (); }
    	}
	];

	function InitSettingsExamLinkPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsExamLinkPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsExamLinkPageInitialized', true );

		IdcSettingsExamsListDT = new C_DataTable ();
		IdcSettingsExamsListDT.DataSrcType		= 0;
		IdcSettingsExamsListDT.Ident 			= 'IdcSettingsExamsListDT';
		IdcSettingsExamsListDT.Container 		= 'IdcSELDTContainer';
		IdcSettingsExamsListDT.DataSrc 			= 'SubFW/database/exams_list/GetDTExam.php';
		IdcSettingsExamsListDT.DataFct			= SettingsExamsListDTGetData;
		IdcSettingsExamsListDT.SetColReorder 	( false );
		IdcSettingsExamsListDT.OnSelect			( SettingsExamsListDTSelected 	);
		IdcSettingsExamsListDT.AddColumn ( 'id',					'id',	 					0, false,  0,  50, false, '', 				'' );
		IdcSettingsExamsListDT.AddColumn ( Translate('Name'),		'nameid',	 				1, true,   1,  '30%', true,  '', 				'' );
		IdcSettingsExamsListDT.AddColumn ( Translate('Modality'),	'modality', 				1, true,   2,  '20%', true,  'text-center', 	'' );
		IdcSettingsExamsListDT.AddColumn ( Translate('Description'),'description', 				1, true,   3,  '50%', true,  '', 				'' );
		IdcSettingsExamsListDT.SetColumnEllipsis ( 1, true );

		IdcSettingsExamsListDT.SetColumnFilter (  1, '<div class="m-0 p-0 ps-1 pe-1 pb-2"><input id="IdcSELNameFilter" class="form-control pt-0 pb-0" oninput="SELDTListRefresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcSettingsExamsListDT.SetColumnFilter (  3, '<div class="m-0 p-0 ps-1 pe-1 pb-2"><input id="IdcSELDescriptionFilter" class="form-control pt-0 pb-0" oninput="SELDTListRefresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );

		IdcSettingsExamsListDT.LoadUserCfg ( G_USE_ID );


		IdcSettingsExamsLinkedListDT = new C_DataTable ();
		IdcSettingsExamsLinkedListDT.DataSrcType		= 0;
		IdcSettingsExamsLinkedListDT.Ident 				= 'IdcSettingsExamsLinkedListDT';
		IdcSettingsExamsLinkedListDT.Container 			= 'IdcSELLinkedDTContainer';
		IdcSettingsExamsLinkedListDT.DataSrc 			= 'SubFW/database/exams_list/GetDTExamLinked.php';
		IdcSettingsExamsLinkedListDT.DataFct			= SettingsExamsLinkedListDTGetData;
		IdcSettingsExamsLinkedListDT.SetColReorder 	( false );
		IdcSettingsExamsLinkedListDT.AddColumn ( Translate('Short.'),		'',			 				0, true,   0,     60, false, '', 				'', SELLinkedDeleteRenderer );			
		IdcSettingsExamsLinkedListDT.AddColumn ( 'exam_id',					'exam_id',					0, false,  1,     50, false, '', 				'' );
		IdcSettingsExamsLinkedListDT.AddColumn ( 'examident_id',			'examident_id',				0, false,  2,     50, false, '', 				'' );
		IdcSettingsExamsLinkedListDT.AddColumn ( Translate('Name'),			'name',		 				1, true,   3,  '30%', true,  '', 				'' );
		IdcSettingsExamsLinkedListDT.AddColumn ( Translate('Description'),	'description', 				1, true,   4,  '70%', true,  '', 				'' );
		IdcSettingsExamsLinkedListDT.SetColumnEllipsis ( 1, true );

		IdcSettingsExamsLinkedListDT.SetColumnFilter (  3, '<div class="m-0 p-0 ps-1 pe-1 pb-2"><input id="IdcSELLinkedNameFilter" class="form-control pt-0 pb-0" oninput="SELLinkedDTListRefresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcSettingsExamsLinkedListDT.SetColumnFilter (  4, '<div class="m-0 p-0 ps-1 pe-1 pb-2"><input id="IdcSELLinkedDescriptionFilter" class="form-control pt-0 pb-0" oninput="SELLinkedDTListRefresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );

		IdcSettingsExamsLinkedListDT.LoadUserCfg ( G_USE_ID );


		IdcSettingsExamsNotLinkedListDT = new C_DataTable ();
		IdcSettingsExamsNotLinkedListDT.DataSrcType		= 0;
		IdcSettingsExamsNotLinkedListDT.Ident 				= 'IdcSettingsExamsNotLinkedListDT';
		IdcSettingsExamsNotLinkedListDT.Container 			= 'IdcSELNotLinkedDTContainer';
		IdcSettingsExamsNotLinkedListDT.DataSrc 			= 'SubFW/database/exams_list/GetDTExamNotLinked.php';
		IdcSettingsExamsNotLinkedListDT.DataFct			= SettingsExamsNotLinkedListDTGetData;
		IdcSettingsExamsNotLinkedListDT.SetColReorder 	( false );
		IdcSettingsExamsNotLinkedListDT.AddColumn ( Translate('Short.'),		'',			 				0, true,   0,     60, false, '', 				'', SELNotLinkedAddRenderer );			
		IdcSettingsExamsNotLinkedListDT.AddColumn ( 'id',						'id',						0, false,  1,     50, false, '', 				'' );
		IdcSettingsExamsNotLinkedListDT.AddColumn ( Translate('Name'),			'name',		 				1, true,   2,  '30%', true,  '', 				'' );
		IdcSettingsExamsNotLinkedListDT.AddColumn ( Translate('Description'),	'description', 				1, true,   3,  '70%', true,  '', 				'' );
		IdcSettingsExamsNotLinkedListDT.SetColumnEllipsis ( 1, true );

		IdcSettingsExamsNotLinkedListDT.SetColumnFilter (  2, '<div class="m-0 p-0 ps-1 pe-1 pb-2"><input id="IdcSELNotLinkedNameFilter" class="form-control pt-0 pb-0" oninput="SELNotLinkedDTListRefresh()" type="text" placeholder="'+Translate("Name")+'"></div>' );
		IdcSettingsExamsNotLinkedListDT.SetColumnFilter (  3, '<div class="m-0 p-0 ps-1 pe-1 pb-2"><input id="IdcSELNotLinkedDescriptionFilter" class="form-control pt-0 pb-0" oninput="SELNotLinkedDTListRefresh()" type="text" placeholder="'+Translate("Description")+'"></div>' );

		IdcSettingsExamsNotLinkedListDT.LoadUserCfg ( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSELSplitter1_2 	= new C_Splitter ( "IdcSELSplitter1_2" );
			IdcSELSplitter3_4 	= new C_Splitter ( "IdcSELSplitter3_4" );

			IdcSELSplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcSELSplitter3_4.LoadUserCfg ( G_USE_ID );

			IdcSettingsExamsListDT.Create ();
			context.attach ( '#IdcSettingsExamsListDT', 	SettingsExamsListDTMenu 	);
			IdcSettingsExamsListDT.SetRowToSelect('first_row');

			IdcSettingsExamsLinkedListDT.Create ();
			context.attach ( '#IdcSettingsExamsLinkedListDT', 	SettingsExamsLinkedListDTMenu 	);

			IdcSettingsExamsNotLinkedListDT.Create ();
			context.attach ( '#IdcSettingsExamsNotLinkedListDT', 	SettingsExamsNotLinkedListDTMenu 	);

			switchLanguage ( CurrentLanguage );
		});
	}

	function SettingsExamsListDTGetData ( d )
	{
		console.log ( "SettingsExamsListDTGetData..." );

		let name 		= $('#IdcSELNameFilter').val ();
		let description = $('#IdcSELDescriptionFilter').val ();
		
		d.name 			= name;
		d.description 	= description;

		return $.extend( {}, d );
	}

	function SELDTListRefresh()
	{
		IdcSettingsExamsListDT.Refresh ();
	}

	function SELLinkedDTListRefresh()
	{
		IdcSettingsExamsLinkedListDT.Refresh ();
	}

	function SELNotLinkedDTListRefresh()
	{
		IdcSettingsExamsNotLinkedListDT.Refresh ();
	}

	function SettingsExamsListDTSelected ( rowsIdx )
	{
		let id 			= -1;
		
		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];
		
			id 			= $('#IdcSettingsExamsListDT').DataTable().row( rowIdx ).data().id;
		}

		$('#IdcSELLinkedDiv').data ( 'id', id );
		
		IdcSettingsExamsLinkedListDT.Refresh ();

		$('#IdcSELNotLinkedDiv').data ( 'id', id );
		
		IdcSettingsExamsNotLinkedListDT.Refresh ();
		
	}


	function SettingsExamsLinkedListDTGetData ( d )
	{
		let id 			= $('#IdcSELLinkedDiv').data ( 'id' );
		let name 		= $('#IdcSELLinkedNameFilter').val();
		let description = $('#IdcSELLinkedDescriptionFilter').val();
		
		d.id 			= id;
		d.name 			= name;
		d.description 	= description;
		
		return $.extend( {}, d );
	}



	function SettingsExamsNotLinkedListDTGetData ( d )
	{
		let id 			= $('#IdcSELNotLinkedDiv').data ( 'id' );
		let name 		= $('#IdcSELNotLinkedNameFilter').val();
		let description = $('#IdcSELNotLinkedDescriptionFilter').val();
		
		d.id 			= id;
		d.name 			= name;
		d.description 	= description;
		
		return $.extend( {}, d );
	}

	function SELNotLinkedAddOK ()
	{
		IdcSettingsExamsLinkedListDT.Refresh ();
		IdcSettingsExamsNotLinkedListDT.Refresh ();
	}

	function SELNotLinkedAddError ()
	{
		
	}

	function SELNotLinkedAdd (el) 
	{
		let exam_id 		= $('#IdcSELNotLinkedDiv').data ( 'id' );
		let examident_id	= IdcSettingsExamsNotLinkedListDT.GetRowData ( el.dataset.row_idx ).id;

		let params = "exam_id=" + exam_id;
		params += "&examident_id=" + examident_id;

		PostASyncData ( "SubFW/database/exams_list/AddExamLinked.php", params, 'application/x-www-form-urlencoded', SELNotLinkedAddOK, SELNotLinkedAddError );
	}

	function SELNotLinkedAddRenderer ( data, ident, rowIdx, colIdx )
	{
		return '<div class="w-100 m-0 p-0 text-center"><img class="imgclickable  pe-2" title="Add exam" src="SubFW/bmp/add_blue.png" style="height: 18px; width: auto;" data-row_idx='+rowIdx+' onclick="SELNotLinkedAdd(this)"></img></div>';
	}


	function SELLinkedDeleteOK ()
	{
		IdcSettingsExamsLinkedListDT.Refresh ();
		IdcSettingsExamsNotLinkedListDT.Refresh ();
	}

	function SELLinkedDeleteError ()
	{
		
	}

	function SELLinkedDelete (el) 
	{
		let exam_id 		= $('#IdcSELLinkedDiv').data ( 'id' );
		let examident_id	= IdcSettingsExamsLinkedListDT.GetRowData ( el.dataset.row_idx ).examident_id;

		let params = "exam_id=" + exam_id;
		params += "&examident_id=" + examident_id;

		PostASyncData ( "SubFW/database/exams_list/DeleteExamLinked.php", params, 'application/x-www-form-urlencoded', SELLinkedDeleteOK, SELLinkedDeleteError );
	}

	function SELLinkedDeleteRenderer ( data, ident, rowIdx, colIdx )
	{
		return '<div class="w-100 m-0 p-0 text-center"><img class="imgclickable  pe-2" title="'+Translate("Delete")+'" src="SubFW/bmp/trash.png" style="height: 18px; width: auto;" data-row_idx='+rowIdx+' onclick="SELLinkedDelete(this)"></img></div>';
	}