	SettingsInstitutionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSettingsInstitutionDT.Properties() }
		}
	];

	SettingsInsDepartmentDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSettingsInsDepartmentDT.Properties() }
		}
	];

	function InitSettingsInstitutionPage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsInstitutionPageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsInstitutionPageInitialized', true );

		IdcSettingsInstitutionDT = new C_DataTable ();
		IdcSettingsInstitutionDT.DataSrcType		= 0;
		IdcSettingsInstitutionDT.Ident 			= 'IdcSettingsInstitutionDT';
		IdcSettingsInstitutionDT.Container 		= 'IdcSIDTContainer';
		IdcSettingsInstitutionDT.DataSrc 		= 'SubFW/database/settings/GetDTInstitution.php';
		IdcSettingsInstitutionDT.DataFct		= SettingsInstitutionDTGetData;
		IdcSettingsInstitutionDT.SetColReorder 	( false );
		IdcSettingsInstitutionDT.OnSelect		( SettingsInstitutionListDTSelected );
		IdcSettingsInstitutionDT.AddColumn 		( 'id',					'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsInstitutionDT.AddColumn 		( Translate('Name'),	'name',		 			1, true,   1, '100%', 	true,  '', 	'' );
		IdcSettingsInstitutionDT.LoadUserCfg 	( G_USE_ID );


		IdcSettingsInsDepartmentDT = new C_DataTable ();
		IdcSettingsInsDepartmentDT.DataSrcType		= 0;
		IdcSettingsInsDepartmentDT.Ident 			= 'IdcSettingsInsDepartmentDT';
		IdcSettingsInsDepartmentDT.Container 		= 'IdcSIDepartmentDTContainer';
		IdcSettingsInsDepartmentDT.DataSrc 			= 'SubFW/database/settings/GetDTInsDepartment.php';
		IdcSettingsInsDepartmentDT.DataFct			= SettingsInsDepartmentDTGetData;
		IdcSettingsInsDepartmentDT.SetColReorder 	( false );
		IdcSettingsInsDepartmentDT.OnSelect			( SettingsInsDepartmentListDTSelected );
		IdcSettingsInsDepartmentDT.AddColumn 		( 'id',			'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsInsDepartmentDT.AddColumn 		( 'inst_id',	'inst_id', 				0, false,  1,  50, 		false, '', 	'' );
		IdcSettingsInsDepartmentDT.AddColumn 		( 'Name',		'name',		 			1, true,   2, '100%', 	true,  '', 	'' );
		IdcSettingsInsDepartmentDT.LoadUserCfg 	( G_USE_ID );



		$(document).ready(function () 
		{
			IdcSISplitter1_2 	= new C_Splitter ( "IdcSISplitter1_2" );
			IdcSISplitter3_4 	= new C_Splitter ( "IdcSISplitter3_4" );

			IdcSISplitter1_2.LoadUserCfg ( G_USE_ID );
			IdcSISplitter3_4.LoadUserCfg ( G_USE_ID );

			IdcSettingsInstitutionDT.Create ();
			context.attach ( '#IdcSettingsInstitutionDT', SettingsInstitutionDTListMenu );

			IdcSettingsInsDepartmentDT.Create ();
			context.attach ( '#IdcSettingsInsDepartmentDT', SettingsInsDepartmentDTListMenu );

			IdcSettingsInstitutionDT.SetRowToSelect('first_row');
		});
	}

	function SettingsInstitutionDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function SettingsInstitutionListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let name 			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcSettingsInstitutionDT.GetRowData ( rowIdx ).id;
			name 		= IdcSettingsInstitutionDT.GetRowData ( rowIdx ).name;
		}

		$('#IdcSIName' ).val ( name );

		$('#IdcSIInformationsDiv' ).data ('id', id );

		IdcSettingsInsDepartmentDT.Refresh ();
	}


	function SettingsInsDepartmentDTGetData ( d )
	{
		d.inst_id = $('#IdcSIInformationsDiv' ).data ('id');

		return $.extend( {}, d );
	}

	function SettingsInsDepartmentListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let name 			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcSettingsInsDepartmentDT.GetRowData ( rowIdx ).id;
			name 		= IdcSettingsInsDepartmentDT.GetRowData ( rowIdx ).name;
		}

		$('#IdcSIDepartmentName' ).val ( name );

		$('#IdcSIDepartmentInformationsDiv' ).data ('id', id );
	}




	function OnSettingsInstitutionAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsInstitutionDT.SetRowToSelect ( 'id', response );
			IdcSettingsInstitutionDT.Refresh ();
		}
		else
			OnSettingsInstitutionAddError ();
	}

	function OnSettingsInstitutionAddError ()
	{
		MsgWarning ( Translate("Unable to add institution !!!") );
	}

	function SettingsInstitutionAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		params += "&name=New Institution";
		PostASyncData ( "SubFW/database/settings/SaveInstitution.php", params, 'application/x-www-form-urlencoded', OnSettingsInstitutionAddOK, OnSettingsInstitutionAddError );
	}

	function SettingsInstitutionSave ()
	{
		let id 	= $('#IdcSIInformationsDiv' ).data ('id');

		let name 	= $('#IdcSIName' ).val ();
		
		let params = "id=" + id;
		params += "&name=" + name;

		PostASyncData ( "SubFW/database/settings/SaveInstitution.php", params, 'application/x-www-form-urlencoded', OnSettingsInstitutionAddOK, OnSettingsInstitutionAddError );
	}

	function OnDeleteSettingsInstitutionOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsInstitutionDT.Refresh ();
			IdcSettingsInstitutionDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsInstitutionError ();
	}

	function OnDeleteSettingsInstitutionError ()
	{
		MsgWarning ( Translate("Unable to delete institution !!!") );
	}

	function DeleteSettingsInstitution ()
	{
		let selRows = IdcSettingsInstitutionDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsInstitutionDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteInstitution.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsInstitutionOK, OnDeleteSettingsInstitutionError );
		}
	}

	function SettingsInstitutionDelete ()
	{
		let selRows = IdcSettingsInstitutionDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected institution ?"), DeleteSettingsInstitution );
		else
			MsgWarning ( Translate("No institution selected !!!") );
	}



	// ###########################################################################
	// ### Department

	function OnSettingsInsDepartmentAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsInsDepartmentDT.SetRowToSelect ( 'id', response );
			IdcSettingsInsDepartmentDT.Refresh ();
		}
		else
			OnSettingsInsDepartmentAddError ();
	}

	function OnSettingsInsDepartmentAddError ()
	{
		MsgWarning ( Translate("Unable to add department !!!") );
	}

	function SettingsInsDepartmentAdd ()
	{
	 	let id 		= -1;
	 	let inst_id = $('#IdcSIInformationsDiv' ).data ('id');

		let params = "id=" + id;
		params += "&name=New department";
		params += "&inst_id=" + inst_id;
		PostASyncData ( "SubFW/database/settings/SaveInsDepartment.php", params, 'application/x-www-form-urlencoded', OnSettingsInsDepartmentAddOK, OnSettingsInsDepartmentAddError );
	}

	function SettingsInsDepartmentSave ()
	{
	 	let id 		= $('#IdcSIDepartmentInformationsDiv' ).data ('id');
	 	let name 	= $('#IdcSIDepartmentName' ).val ();

		let params = "id=" + id;
		params += "&name=" + name;
		PostASyncData ( "SubFW/database/settings/SaveInsDepartment.php", params, 'application/x-www-form-urlencoded', OnSettingsInsDepartmentAddOK, OnSettingsInsDepartmentAddError );
	}


	function OnDeleteSettingsInsDepartmentOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsInsDepartmentDT.Refresh ();
			IdcSettingsInsDepartmentDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsInsDepartmentError ();
	}

	function OnDeleteSettingsInsDepartmentError ()
	{
		MsgWarning ( Translate("Unable to delete department !!!") );
	}

	function DeleteSettingsInsDepartment ()
	{
		let selRows = IdcSettingsInsDepartmentDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsInsDepartmentDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteInsDepartment.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsInsDepartmentOK, OnDeleteSettingsInsDepartmentError );
		}
	}

	function SettingsInsDepartmentDelete ()
	{
		let selRows = IdcSettingsInsDepartmentDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected department ?"), DeleteSettingsInsDepartment );
		else
			MsgWarning ( Translate("No department selected !!!") );	
	}