	SettingsJobRoleDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { OnSettingsJobRoleDTGridProperties() }
		}
	];

	function InitSettingsJobRolePage ()
	{
		let ss = sessionStorage.getItem ( 'SettingsJobRolePageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsJobRolePageInitialized', true );

		IdcSettingsJobRoleDT = new C_DataTable ();
		IdcSettingsJobRoleDT.DataSrcType		= 0;
		IdcSettingsJobRoleDT.Ident 			= 'IdcSettingsJobRoleDT';
		IdcSettingsJobRoleDT.Container 		= 'IdcSJRDTContainer';
		IdcSettingsJobRoleDT.DataSrc 		= 'SubFW/database/settings/GetDTStaffRole.php';
		IdcSettingsJobRoleDT.DataFct		= SettingsJobRoleDTGetData;
		IdcSettingsJobRoleDT.SetColReorder 	( false );
		IdcSettingsJobRoleDT.OnSelect		( SettingsJobRoleListDTSelected );
		IdcSettingsJobRoleDT.AddColumn 		( 'id',					'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsJobRoleDT.AddColumn 		( 'scope_id',			'scope_id',	 			0, false,  1,  50, 		false, '', 	'' );
		IdcSettingsJobRoleDT.AddColumn 		( Translate('Name'),	'name',		 			1, true,   2, '100%', 	true,  '', 	'' );
		IdcSettingsJobRoleDT.LoadUserCfg 	( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSJRSplitter1_2 	= new C_Splitter ( "IdcSJRSplitter1_2" );
			IdcSJRSplitter1_2.LoadUserCfg ( G_USE_ID );

			IdcSettingsJobRoleDT.Create ();
			context.attach ( '#IdcSettingsJobRoleDT', SettingsJobRoleDTListMenu );

			FillValueList ( 'IdcSJRScopeID', 'jobrolescope' );

			IdcSettingsJobRoleDT.SetRowToSelect('first_row');
		});
	}

	function SettingsJobRoleDTGetData ( d )
	{
		// d.pat_id = ( this.RFPatID == -1 )? -2 : this.RFPatID;
		
		return $.extend( {}, d );
	}

	function OnSettingsJobRoleDTGridProperties ()
	{
		IdcSettingsJobRoleDT.Properties ();
	}

	function SettingsJobRoleListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let scope_id 		= -1;
		let name 			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcSettingsJobRoleDT.GetRowData ( rowIdx ).id;
			scope_id	= IdcSettingsJobRoleDT.GetRowData ( rowIdx ).scope_id;
			name 		= IdcSettingsJobRoleDT.GetRowData ( rowIdx ).name;
		}

		$('#IdcSJRInformationsDiv' ).data ('id', id );
		
		$('#IdcSJRName' ).val ( name );
		$('#IdcSJRScopeID' ).val ( scope_id ).change ();
	}

	function OnSettingsJobRoleAddOK ( response )
	{
		if ( response != '-1')
		{
			console.log ( " response : " + response );

			IdcSettingsJobRoleDT.SetRowToSelect ( 'id', response );

			IdcSettingsJobRoleDT.Refresh ();
		}
		else
			OnSaveDeviceInstallationError ();
	}

	function OnSettingsJobRoleAddError ()
	{
		MsgWarning ( Translate("Unable to add JobRole !!!") );
	}

	function SettingsJobRoleAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		params += "&name=New job role";
		PostASyncData ( "SubFW/database/settings/SaveJobRole.php", params, 'application/x-www-form-urlencoded', OnSettingsJobRoleAddOK, OnSettingsJobRoleAddError );
	}

	function SettingsJobRoleSave ()
	{
		let id 	= $('#IdcSJRInformationsDiv' ).data ('id');

		let name 		= $('#IdcSJRName' ).val ();
		let scope_id 	= $('#IdcSJRScopeID' ).val ();
		
		let params = "id=" + id;
		params += "&name=" + name;
		params += "&scope_id=" + scope_id;

		PostASyncData ( "SubFW/database/settings/SaveJobRole.php", params, 'application/x-www-form-urlencoded', OnSettingsJobRoleAddOK, OnSettingsJobRoleAddError );
	}

	function OnDeleteSettingsJobRoleOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsJobRoleDT.Refresh ();
			IdcSettingsJobRoleDT.SetRowToSelect('first_row');
		}
		else
			OnDeleteSettingsJobRoleError ();
	}

	function OnDeleteSettingsJobRoleError ()
	{
		MsgWarning ( Translate("Unable to delete job role !!!") );
	}

	function DeleteSettingsJobRole ()
	{
		let selRows = IdcSettingsJobRoleDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsJobRoleDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteJobRole.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsJobRoleOK, OnDeleteSettingsJobRoleError );
		}
	}

	function SettingsJobRoleDelete ()
	{
		let selRows = IdcSettingsJobRoleDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected job ?"), DeleteSettingsJobRole );
		else
			MsgWarning ( Translate("No job selected !!!") );
	}