	SettingsLoginRoleDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSettingsLoginRoleDT.Properties () }
		}
	];

	SettingsLoginRolePermissionDTListMenu = [
		{
			header: ''
		},
		{
			img: 'SubFW/bmp/setup_1_blue.png',
			text: 'Grid properties...',
			action: function(e, selector) { IdcSettingsLoginRolePermissionDT.Properties () }
		}
	];

	function InitSettingsLoginRolePage ()
	{
		console.log ( "InitSettingsLoginRolePage..." );
		let ss = sessionStorage.getItem ( 'SettingsLoginRolePageInitialized' );

		if ( ss == 'true' )
			return;
		
		sessionStorage.setItem ( 'SettingsLoginRolePageInitialized', true );

		IdcSettingsLoginRoleDT = new C_DataTable ();
		IdcSettingsLoginRoleDT.DataSrcType		= 0;
		IdcSettingsLoginRoleDT.Ident 			= 'IdcSettingsLoginRoleDT';
		IdcSettingsLoginRoleDT.Container 		= 'IdcSLRDTContainer';
		IdcSettingsLoginRoleDT.DataSrc 			= 'SubFW/database/settings/GetDTLoginRole.php';
		IdcSettingsLoginRoleDT.DataFct			= SettingsLoginRoleDTGetData;
		IdcSettingsLoginRoleDT.SetColReorder 	( false );
		IdcSettingsLoginRoleDT.OnSelect			( SettingsLoginRoleListDTSelected );
		IdcSettingsLoginRoleDT.AddColumn 		( 'id',					'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsLoginRoleDT.AddColumn 		( 'scope_id',			'scope_id',	 			0, false,  1,  50, 		false, '', 	'' );
		IdcSettingsLoginRoleDT.AddColumn 		( Translate('Name'),	'name',		 			1, true,   2, '100%', 	true,  '', 	'' );
		IdcSettingsLoginRoleDT.LoadUserCfg 		( G_USE_ID );

		IdcSettingsLoginRolePermissionDT = new C_DataTable ();
		IdcSettingsLoginRolePermissionDT.DataSrcType		= 0;
		IdcSettingsLoginRolePermissionDT.Ident 				= 'IdcSettingsLoginRolePermissionDT';
		IdcSettingsLoginRolePermissionDT.Container 			= 'IdcSLRPermissionDTContainer';
		IdcSettingsLoginRolePermissionDT.DataSrc 			= 'SubFW/database/settings/GetDTLoginRolePermission.php';
		IdcSettingsLoginRolePermissionDT.DataFct			= SettingsLoginRolePermissionDTGetData;
		IdcSettingsLoginRolePermissionDT.DrawCallbackFct	= SettingsLoginRolePermissionDTDrawCallback;
		IdcSettingsLoginRolePermissionDT.SetColReorder 		( false );
		IdcSettingsLoginRolePermissionDT.OnSelect			( SettingsLoginRolePermissionListDTSelected );
		IdcSettingsLoginRolePermissionDT.AddColumn 			( 'id',					'id',	 				0, false,  0,  50, 		false, '', 	'' );
		IdcSettingsLoginRolePermissionDT.AddColumn 			( 'working_view_exist',	'working_view_exist',	0, false,  1,  50, 		false, '', 	'' );
		IdcSettingsLoginRolePermissionDT.AddColumn 			( 'Type',				'ptype',		 		1, true,   2, '15%', 	true,  '', 	'' );
		IdcSettingsLoginRolePermissionDT.AddColumn 			( 'Description',		'description',	 		1, true,   3, '55%', 	true,  '', 	'' );
		IdcSettingsLoginRolePermissionDT.AddColumn 			( 'Admin.',				'value',		 		1, true,   4, '15%', 	true,  '', 	'', SettingsLoginRolePermissionValueCBRenderer );
		IdcSettingsLoginRolePermissionDT.AddColumn 			( 'Light view',			'working_view',	 		1, true,   5, '15%', 	true,  '', 	'', SettingsLoginRolePermissionWorkingViewCBRenderer );
		IdcSettingsLoginRolePermissionDT.SetDefaultOrderColumn ( 3, 'asc' );
		IdcSettingsLoginRolePermissionDT.LoadUserCfg 		( G_USE_ID );


		$(document).ready(function () 
		{
			IdcSLRSplitter1_2 	= new C_Splitter ( "IdcSLRSplitter1_2" );
			IdcSLRSplitter1_2.LoadUserCfg ( G_USE_ID );

			IdcSettingsLoginRoleDT.Create ();
			context.attach ( '#IdcSettingsLoginRoleDT', SettingsLoginRoleDTListMenu );
			IdcSettingsLoginRoleDT.SetRowToSelect('first_row');

			IdcSettingsLoginRolePermissionDT.Create ();
			context.attach ( '#IdcSettingsLoginRolePermissionDT', SettingsLoginRolePermissionDTListMenu );

			switchLanguage ( CurrentLanguage );
		});
	}

	function SettingsLoginRoleDTGetData ( d )
	{
		return $.extend( {}, d );
	}

	function SettingsLoginRoleListDTSelected ( rowsIdx )
	{
		let id 				= -1;
		let name 			= "";

		if ( rowsIdx.length == 1 )		// Only one row selected
		{
			let rowIdx = rowsIdx [0];

			id 			= IdcSettingsLoginRoleDT.GetRowData ( rowIdx ).id;
			name 		= IdcSettingsLoginRoleDT.GetRowData ( rowIdx ).name;
		}
		console.log ("name : " + name );
		$('#IdcSLRName' ).val ( name );

		$('#IdcSLRInformationsDiv' ).data ('id', id );

		IdcSettingsLoginRolePermissionDT.Refresh ();
	}

	function OnSettingsLoginRoleAddOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsLoginRoleDT.SetRowToSelect ( 'id', response );
			IdcSettingsLoginRoleDT.Refresh ();
		}
		else
			OnSettingsLoginRoleAddError ();
	}

	function OnSettingsLoginRoleAddError ()
	{
		MsgWarning ( Translate("Unable to add login role !!!") );
	}

	function SettingsLoginRoleAdd ()
	{
		let id 	= -1;

		let params = "id=" + id;
		params += "&name=New login role";
		PostASyncData ( "SubFW/database/settings/SaveLoginRole.php", params, 'application/x-www-form-urlencoded', OnSettingsLoginRoleAddOK, OnSettingsLoginRoleAddError );
	}

	function SettingsLoginRoleSave ()
	{
		let id 	= $('#IdcSLRInformationsDiv' ).data ('id');

		let name 	= $('#IdcSLRName' ).val ();
		
		let params = "id=" + id;
		params += "&name=" + name;

		PostASyncData ( "SubFW/database/settings/SaveLoginRole.php", params, 'application/x-www-form-urlencoded', OnSettingsLoginRoleAddOK, OnSettingsLoginRoleAddError );
	}

	function OnDeleteSettingsLoginRoleOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsLoginRoleDT.Refresh ();
			IdcSettingsLoginRoleDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsLoginRoleError ();
	}

	function OnDeleteSettingsLoginRoleError ()
	{
		MsgWarning ( Translate("Unable to delete login role !!!") );
	}

	function DeleteSettingsLoginRole ()
	{
		let selRows = IdcSettingsLoginRoleDT.GetSelectedRows ();
		if ( selRows.length == 1 )
		{
			let id = IdcSettingsLoginRoleDT.GetRowData ( selRows [0] ).id;

			PostASyncData ( "SubFW/database/settings/DeleteLoginRole.php", "id="+id, 'application/x-www-form-urlencoded', OnDeleteSettingsLoginRoleOK, OnDeleteSettingsLoginRoleError );
		}
	}

	function SettingsLoginRoleDelete ()
	{
		let selRows = IdcSettingsLoginRoleDT.GetSelectedRows ();
		if ( selRows.length == 1 )
			MsgYesNo ( Translate("Delete selected login role ?"), DeleteSettingsLoginRole );
		else
			MsgWarning ( Translate("No login role selected !!!") );
	}


	// #######################################################
	// #### Permissions

	function SettingsLoginRolePermissionDTGetData ( d )
	{
		let id = $('#IdcSLRInformationsDiv' ).data ('id');

		d.roleid = id;		
		return $.extend( {}, d );
	}

	function SettingsLoginRolePermissionListDTSelected ( rowsIdx )
	{
	}

	function SettingsLoginRolePermissionValueCBRenderer ( data, ident, rowIdx, colIdx )
	{
		let id = "IdcLoginRolePermissionAdminCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" data-row_idx='+rowIdx+' data-col_idx='+colIdx+' onclick="OnSettingsLoginRolePermissionAdminCBClicked(this)"/></div>';
	}

	function SettingsLoginRolePermissionWorkingViewCBRenderer ( data, ident, rowIdx, colIdx )
	{
		let id = "IdcLoginRolePermissionWorkingViewCB_" + rowIdx;
		return '<div class="w-100 m-0 p-0 text-center"><input id='+id+' class="XIMEO_DT-Checkbox" type="checkbox" data-row_idx='+rowIdx+' data-col_idx='+colIdx+' onclick="OnSettingsLoginRolePermissionWorkingViewCBClicked(this)"/></div>';
	}

	function SettingsLoginRolePermissionUpdateCheckbox ()
	{
		let rowsData 	= $('#IdcSettingsLoginRolePermissionDT').DataTable().rows().data ();
		
		for ( let j=0; j<rowsData.length; j++ )
		{
			let val = ( rowsData [j].value == 1 )? true : false;
			document.getElementById ( "IdcLoginRolePermissionAdminCB_" + j ).checked = val; 

			val = ( rowsData [j].working_view == 1 )? true : false;
			document.getElementById ( "IdcLoginRolePermissionWorkingViewCB_" + j ).checked = val; 
			
			val = ( rowsData [j].working_view_exist == 1 )? false : true;
			document.getElementById ( "IdcLoginRolePermissionWorkingViewCB_" + j ).disabled = val; 
		}
	}

	function SettingsLoginRolePermissionDTDrawCallback ()
	{
		SettingsLoginRolePermissionUpdateCheckbox ();
	}

	function OnSettingsLoginRolePermissionSaveOK ( response )
	{
		if ( response != '-1')
		{
			IdcSettingsLoginRolePermissionDT.Refresh ();
			IdcSettingsLoginRolePermissionDT.SetRowToSelect('first_row');
		}
		else
			OnSettingsLoginRoleError ();
	}

	function OnSettingsLoginRolePermissionSaveError ()
	{

	}

	function OnSettingsLoginRolePermissionAdminCBClicked ( e )
	{
		let rowIdx = $(e).data ( 'row_idx' );

		let id 	= IdcSettingsLoginRolePermissionDT.GetRowData ( rowIdx ).id;
		let chk = document.getElementById ( "IdcLoginRolePermissionAdminCB_" + rowIdx ).checked;

		let params = "id=" + id;
		params += "&admin=";
		params += (chk==true)? "1" : "0";

		PostASyncData ( "SubFW/database/settings/SaveLoginRolePermission.php", params, 'application/x-www-form-urlencoded', OnSettingsLoginRolePermissionSaveOK, OnSettingsLoginRolePermissionSaveError );
	}

	function OnSettingsLoginRolePermissionWorkingViewCBClicked ( e )
	{
		let rowIdx = $(e).data ( 'row_idx' );

		let id 	= IdcSettingsLoginRolePermissionDT.GetRowData ( rowIdx ).id;
		let chk = document.getElementById ( "IdcLoginRolePermissionWorkingViewCB_" + rowIdx ).checked;

		let params = "id=" + id;
		params += "&working_view=";
		params += (chk==true)? "1" : "0";
		
		PostASyncData ( "SubFW/database/settings/SaveLoginRolePermission.php", params, 'application/x-www-form-urlencoded', OnSettingsLoginRolePermissionSaveOK, OnSettingsLoginRolePermissionSaveError );
	}